unit m_elemen; { Elementary functions }
{----------------------------------------------------------}
interface
uses M_common;

Function  m_pow( x, y: extended ) : extended;    { x^y }
Function  m_log( x, a: extended ) : extended;    { log_a(x) }
Function  m_Factorial( n: integer): extended;    { N = 0..1754 }
function  m_binom( n: extended; k: integer ): extended; { n!/(k!(n-k)!) }

             { TRIGONOMETRY  }

Function  m_sin( x: extended ) : extended;
Function  m_cos( x: extended ) : extended;
Function  m_tg ( x: extended ) : extended;
Function  m_ctg( x: extended ) : extended;

Function  m_asin( x: extended ) : extended;
Function  m_acos( x: extended ) : extended;

             { HIPERBOLIC     }

Function  m_sh ( x: extended ) : extended;
Function  m_ch ( x: extended ) : extended;
Function  m_th ( x: extended ) : extended;
Function  m_cth( x: extended ) : extended;

             { SPECIAL       }

Function  m_Bernoulli( n: integer ):extended; { Bernoulli numbers  }
Function  m_lnGAMMA( x: extended ) : extended;{ log Gamma, x >   0 }
Function  m_GAMMA( x: extended ) : extended;  { GAMMA              }
Function  m_ZETA( x: extended ):extended;     { Riemann's Zeta-function }
{----------------------------------------------------------}
implementation

Function  m_pow( x, y: extended ) : extended;    { x^y }
var modd, revers, iy : integer;
begin
    m_pow := Nothing;
    if x = 0 then begin m_pow := 0; Exit; end;
    if x<0 then begin
      if y = int(y) then begin { ⥫쭮 ᫮  楫 ⥯ }
          iy := round(y);
          if x = -1 then begin
              if odd(iy) then m_pow := -1 else m_pow := 1;
          end else begin
              if odd(iy) then modd := -1 else modd := 1;
              m_pow := modd*exp( y*ln(-x) );
          end;
      end else begin ErrProc( 1, 'm_pow: x < 0' ); Exit; end;

    end else begin             { ------------------- x > 0 }
        m_pow := exp(y*ln(x));
    end;
end;

Function  m_log( x, a: extended ) : extended;    { log_a(x) }
begin
  m_log := Nothing;
  if (x<=0)or(a<=0) then begin ErrProc(1,'m_log: negativ' ); Exit; end
  else  m_log := ln(x)/ln(a);
end;

Function  m_Factorial( n: integer): extended;    { N = 0..1754 }
var
    i: integer;
    f: extended;
begin
    m_Factorial := Nothing;
    if (n < 0) or ( n>1754 ) then begin
        ErrProc(1,'m_Factorial: n out of range' );
        Exit;
    end;
    f := 1;
    if  n > 1  then
    for  i := 2 to n do  f := f*i;
    m_Factorial := f;

end;

function m_binom( n: extended; k: integer ): extended;
var i: integer;
    b: extended;
begin
  m_binom := Nothing;
  if k < 0 then begin ErrProc(1,'m_binom: k<0' ); Exit; end;
  if k = 0 then begin m_binom := 1; Exit; end;
  if k = 1 then begin m_binom := n; Exit; end;
  if (n=int(n)) and (k>n/2) and (k<n) then k:= round(n)-k;
  b := n;
  for i := 2 to k do b := b * (n-i+1) / i;
  m_binom := b;
end;

{----------------------------------------------------------}
Function  m_sin( x: extended ) : extended;
begin
    m_sin := sin(x);
end;

Function  m_cos( x: extended ) : extended;
begin
    m_cos := cos(x);
end;

Function  m_tg( x: extended ) : extended;
var c: extended;
begin
    m_tg := Nothing;
    c := cos(x);
    if c=0 then begin ErrProc( 1, 'm_tg: cos = 0' ); Exit; end;
    m_tg := sin(x)/c;
end;

Function  m_ctg( x: extended ) : extended;
var s: extended;
begin
    m_ctg := Nothing;
    s := sin(x);
    if s=0 then begin ErrProc( 1, 'm_ctg: sin = 0' ); Exit; end;
    m_ctg := cos(x)/s;
end;

{----------------------------------------------------------}
Function  m_asin( x: extended ) : extended;
var asin: extended;
begin
    m_asin := Nothing;
    if abs(x)>1 then begin ErrProc( 1, 'm_asin: abs(x)>1' ); Exit; end;
    if  x = -1  then  asin := -pi/2
    else
    if  x = 1  then  asin := pi/2
    else  asin := arctan(x/sqrt(1 - sqr(x)));
    m_asin := asin;
end;


Function  m_acos( x: extended ) : extended;
var acos: extended;
begin
    m_acos := Nothing;
    if abs(x)>1 then begin ErrProc( 1, 'm_acos: abs(x)>1' ); Exit; end;

    if  x = 0  then acos := pi/2
    else begin
        acos := arctan(sqrt(1 - sqr(x))/x);
        if  x < 0  then  acos := acos + pi;
    end;
    m_acos := acos;
end;

{-------------- HIPERBOLIC FUNCTIONS ----------------------}
function  m_sh ( x: extended ) : extended;
begin
    m_sh := (exp(x) - exp(-x))/2;
end;

function  m_ch ( x: extended ) : extended;
begin
    m_ch := (exp(x) + exp(-x))/2;
end;

function  m_th ( x: extended ) : extended;
begin
    m_th := (exp(x) - exp(-x))/(exp(x) + exp(-x));
end;

function  m_cth ( x: extended ) : extended;
begin
    m_cth := Nothing;
    if x= 0 then begin ErrProc( 1, 'm_cth: x=0' ); Exit; end;
    m_cth := (exp(x) + exp(-x))/(exp(x) - exp(-x));
end;
{----------------------------------------------------------}


{                  SPECIAL FUNCTIONS                       }


{--- simple ln(GAMMA) for x >= 40, only for internal use --}
Function  mi_LGam1( x: extended ) : extended;
var be: extended;
begin
  be := 1/sqr(x);
  mI_LGam1 := (x-0.5)*ln(x) - x + 0.5*ln(2*Pi) +
  (1 - be/30 + sqr(be)/105 - be*be*be/140 + sqr(sqr(be))/99)/12/x;
end;

{--------------- Bernoulli numbers, n<2300 ----------------}
Function  m_Bernoulli( n: integer ):extended;
const  bern0: array[1..20] of extended = (
          {   1  }      1./6                            ,
          {   2  }     -1./30                           ,
          {   3  }      1./42                           ,
          {   4  }     -1./30                           ,
          {   5  }      5./66                           ,
          {   6  }     -691./2730                       ,
          {   7  }      7./6                            ,
          {   8  }     -3617./510                       ,
          {   9  }      43867./798                      ,
          {  10  }     -174611./330                     ,
          {  11  }      854513./138                     ,
          {  12  }     -236364091./2730                 ,
          {  13  }      8553103./6                      ,
          {  14  }     -23749461029./870                ,
          {  15  }      8615841276005./14322            ,
          {  16  }     -7709321041217./510              ,
          {  17  }      2577687858367./6                ,
          {  18  }     -26315271553053477373./1919190   ,
          {  19  }      2929993913841559./6             ,
          {  20  }     -261082718496449122051./13530    );
var brn : extended;
begin
  m_Bernoulli := Nothing;
  if n < 0 then begin ErrProc( 1, 'm_Bernoulli: n<0' ); Exit; end;
  if n = 1  then begin m_Bernoulli:=1; Exit; end;
  if odd(n) then begin m_Bernoulli:=0; Exit; end;
  if n <41  then begin m_Bernoulli:=bern0[ n div 2 ]; Exit; end;
  brn := 2*( 1+exp(-n*ln(2)) )*exp( mi_LGam1(n+1) - n*ln(2*Pi) );
  if not odd( n div 2) then brn := - brn;
  m_Bernoulli := brn;
end;

{------------------- ln(GAMMA) ----------------------------}
Function  m_lnGAMMA( x: extended ) : extended;
var A, v, be, r, s: extended;
    k : integer;
begin
  m_lnGAMMA := Nothing;
  if x < 0 then begin ErrProc( 1, 'm_lnGAMMA: x<0' ); Exit; end;
  A := 0;
  while x < 12 do begin A := A-ln(x); x:=x+1; end;
  r  := (x-0.5)*ln(x) - x + 0.5*ln(2*Pi);
  be := 1/sqr(x); v := 1/x; k := 1;
  repeat r := r + v*m_Bernoulli(2*k)/(k*(4*k-2));
         k := k+1;
         v := v*be;
  until  v < 1e-18;
  m_lnGAMMA := r + A;
end;

{-------------------- GAMMA -------------------------------}
Function  m_GAMMA( x: extended ) : extended;
begin
  if x < 0.5 then m_GAMMA := Pi/sin(Pi*x)/exp(m_lnGAMMA(1-X))
             else m_GAMMA :=             exp(m_lnGAMMA(X));
end;

{----------------- Riemann's Zeta-function ----------------}
Function  m_ZETA( x: extended ):extended;
const  la: array[1..10] of extended = (
          {   1  }      - 0.16666666666666666667         ,
          {   2  }      0.019444444444444444444          ,
          {   3  }      -0.0020502645502645502646        ,
          {   4  }      0.00020998677248677248677        ,
          {   5  }      -0.000021336045641601197157      ,
          {   6  }      0.21633474427786597099e-5        ,
          {   7  }      -0.21923271344567640864e-6       ,
          {   8  }      0.22213930853920414559e-7        ,
          {   9  }      -0.22507674795567867297e-8       ,
          {  10  }      0.22805107707218211705e-9        );
var dz, su, P, al2, t : extended;
    i : integer;
    low: boolean;
const n = 20; al = n-0.5;
begin
  m_ZETA := Nothing;
  if x = 1 then begin ErrProc( 1, 'm_ZETA: x=1' ); Exit; end;
  low := false; if x < 0.5 then begin low:=true; x := 1-x; end;
  al2 := 0.25/sqr(al);
  dz := 1;
  for i:= 2 to n-1 do dz := dz + exp( -x*ln(i) );
  P := x*al2;   su := 1/(x-1) + la[1]*P;    t:=x+1;
  for i:= 2 to 6 do begin P:=P*t*(t+1)*al2; t:=t+2; su:=su+la[i]*P; end;
  dz := dz + exp( (1-x)*ln(al) ) * su;
  if low then dz := 2*dz*m_GAMMA(x)*sin(Pi*(1-x)/2)*exp( -x*ln(2*Pi) );
  m_ZETA := dz;
end;

{----------------------------------------------------------}
begin
end.
