unit m_llong; {   8-⮢묨 楫묨 ᫠ (⨯ comp)             }
              {   묨 ᫠                                  }
{--------------------------------------------------------------------------}
interface
var max_comp, two32, two31 : comp;       { 2^63-1, 2^32, 2^31              }
function  m_div( a, b: comp ) : comp;    { a div b                         }
function  m_mod( a, b: comp ) : comp;    { a mod b                         }
function  m_mul_mod(a, b, c: comp):comp; { a*b mod c; c<2^62               }
function  m_pow_mod(a, b, c: comp):comp; { a^b mod c; c<2^62               }
function  m_GCD(a, b : comp):comp;       { Greatest Common Divisor         }
function  m_LCM(a, b : comp):comp;       { Least Common Multiple           }
function  m_divisor( n:comp ):comp;      { min.divisor                     }
function  m_is_prime( n:comp ):boolean;  { Is prime?                       }
function  m_next_prime( n:comp ):comp;   { min.prime k: k>= n              }
function  m_is_primary( a, n:comp ):boolean;{ a - primary root for n?      }
function  m_comp2str( a:comp ):string;   { comp -> string                  }
function  m_str2comp( s:string ):comp;   { string -> comp                  }
function  m_compLow ( a:comp ):longint;  { low  4 byte                     }
function  m_compHigh( a:comp ):longint;  { high 4 byte                     }

const NPrimes = 16000;
type  PrArray = array[1..NPrimes] of longint;
var   primes: ^PrArray;
Function  m_is_prime_0( n: longint ):boolean;
Procedure m_FillPrimes_0;

{--------------------------------------------------------------------------}
implementation
uses M_common;

function  m_div( a, b: comp ) : comp;    { a div b }
var c: comp;
begin
  c := a/b;
  if c*b > a then c := c-1;
  m_div := c;
end;

function  m_mod( a, b: comp ) : comp;    { a mod b }
var c: comp;
begin
  if b<2 then begin ErrProc( 1, 'm_mod: b<2' ); Exit; end;
  c := a/b;
  c := a - c*b;
  if c < 0 then c:=c+b;
  m_mod := c;
end;

{--------------------------------------------------------------------------}
function  m_mul_mod( a, b, c: comp ) : comp;    { a*b mod c; c<2^62 }
var a2i, res: comp;
begin
  m_mul_mod := max_comp;
  if (c<1) or (c > max_comp/2) then
  begin errproc( 1, 'm_mul_mod: c out of range' ); exit; end;
  if (a<0) or (a>=c) then a := m_mod(a,c);
  if (b<0) or (b>=c) then b := m_mod(b,c);

  res := 0; a2i := a;
  while b>0 do begin
    res := res + m_mod(b,2)*a2i;
    if res > c then res := res-c;
    a2i := 2*a2i;
    if a2i > c then a2i := a2i-c;
    b   := m_div(b,2);
  end;
  m_mul_mod := res;
end;

{--------------------------------------------------------------------------}
function  m_pow_mod( a, b, c: comp ) : comp;    { a^b mod c; c<2^62 }
var a2i, res: comp;
begin
  m_pow_mod := max_comp;
  if (c<1) or (c > max_comp/2) then
  begin errproc( 1, 'm_pow_mod: c out of range' ); exit; end;
  if b<0                       then
  begin errproc( 1, 'm_pow_mod: b is negativ  ' ); exit; end;

  if (a<0) or (a>=c) then a := m_mod(a,c);

  res := 1; a2i := a;
  while b>0 do begin
    if m_mod(b,2)=1 then res := m_mul_mod( res, a2i, c);
    a2i := m_mul_mod( a2i, a2i, c);
    b   := m_div(b,2);
  end;
  m_pow_mod := res;
end;

{--------------------------------------------------------------------------}
function m_GCD(a, b : comp):comp; { Greatest Common Divisor                }
var t: comp;
begin
  a := abs(a); b:= abs(b);
  while b <> 0 do begin
    t := m_mod(a, b);
    a := b;
    b := t;
  end;
  m_GCD := a;
end;

function m_LCM(a, b : comp):comp; { Least Common Multiple }
begin
  m_LCM := (a/m_GCD(a,b))*b;
end;

{--------------------------------------------------------------------------}
function  m_divisor( n:comp ):comp;      { 訩 ⥫             }
var i: integer;
    k: comp;
begin
  if primes = NIL then m_FillPrimes_0;
  i := 1;
  while (i<=NPrimes) and (Sqr(primes^[i]) <= n) do begin
    if m_mod(n, primes^[i]) = 0 then begin
      m_divisor := primes^[i];
      Exit;
    end;
    inc(i);
  end;
  if Sqr(primes^[NPrimes]) >= n then begin
    m_divisor := n;
    Exit;
  end;
  { ᫮ n  ᫨誮 訬.   ⮥? }
  if m_is_prime(n) then begin m_divisor := n; Exit; end;

  {  ⮥. ஢ਬ     ᫠  }
  k := primes^[NPrimes] + 2;
  while Sqr(k) <= n do begin
    if m_mod(n, k) = 0 then begin
      m_divisor := k;
      Exit;
    end;
    k := k+2;
  end;
  m_divisor := n;   {  ⥫ }
  Exit;
end;

{--------------------------------------------------------------------------}
function  m_is_prime( n:comp ):boolean;       { Is prime?                  }
var n2, pw: comp;
    i : integer;
begin
  m_FillPrimes_0;
  if Sqr( primes^[NPrimes] ) >= n then begin  { ᫨ ᫮ 쪮       }
    m_is_prime := m_is_prime_0( trunc(n) );
    Exit;
  end;
  m_is_prime := False;
  { ᫮  訬 }
  n2 := m_div(n,2);
  pw := m_pow_mod( 2, n2, n ); if (pw <> 1) and (pw <> (n-1)) then Exit;
  pw := m_pow_mod( 3, n2, n ); if (pw <> 1) and (pw <> (n-1)) then Exit;
  pw := m_pow_mod( 5, n2, n ); if (pw <> 1) and (pw <> (n-1)) then Exit;
  pw := m_pow_mod( 7, n2, n ); if (pw <> 1) and (pw <> (n-1)) then Exit;
  pw := m_pow_mod(11, n2, n ); if (pw <> 1) and (pw <> (n-1)) then Exit;
  pw := m_pow_mod(13, n2, n ); if (pw <> 1) and (pw <> (n-1)) then Exit;
  pw := m_pow_mod(17, n2, n ); if (pw <> 1) and (pw <> (n-1)) then Exit;

  m_is_prime := True;
end;
{--------------------------------------------------------------------------}
function  m_next_prime( n:comp ):comp;   { min.prime k: k>= n              }
var k: comp;
begin
  if m_mod(n,2)=0 then k:= n+1 else k:=n;
  while not m_is_prime(k) do k:=k+2;
  m_next_prime := k;
end;
{--------------------------------------------------------------------------}
function  m_is_primary( a, n:comp ):boolean;{ a - primary root for n?      }
var n1, n1a, d: comp;
begin
  m_is_primary := False;
  n1a := n-1;
  repeat
    d := m_divisor(n1a); n1a := m_div(n1a,d);
    if m_pow_mod( a, m_div(n-1, d), n ) = 1 then Exit;
  until n1a=1;
  m_is_primary := True;
end;
{--------------------------------------------------------------------------}
function  m_comp2str( a:comp ):string;   { comp -> string          }
var s  : string[20];
    ten: comp;
    d  : integer;
begin
  ten := 10;
  s   := '';
  repeat
    d := Trunc( m_mod( a, ten ) );
    s := chr( 48+d ) + s;
    a := m_div( a, ten );
  until a=0;
  if s = '' then s:= '0';
  m_comp2str := s;
end;
{--------------------------------------------------------------------------}
function  m_str2comp( s:string ):comp;   { string -> comp                  }
var i, sgn: integer;
    v: comp;
begin
  v := 0;  { १ }
  sgn := 1;  {       }
  for i:=1 to length(s) do if s[i]>' ' then break; { s[i]-  ஡}
  if s[i] = '-' then begin sgn:=-1; inc(i) end;
  while (i<=length(s)) and ('0'<=s[i]) and (s[i]<='9') do begin
    if v > max_comp/10 then begin
      ErrProc( 1, 'm_str2comp: '+s+' - value too large' );
      m_str2comp := max_comp;
      Exit;
    end;
    v := 10*v + (ord(s[i])- ord('0'));
    i := i+1;
  end;
  m_str2comp := v*sgn;
end;
{--------------------------------------------------------------------------}
function  m_compLow ( a:comp ):longint;  { low  4 byte                     }
var tmp: comp;
begin
  tmp := m_mod( a, two32 );
  if tmp >= two31 then tmp := tmp-two32;
  m_compLow := Trunc(tmp);
end;

function  m_compHigh( a:comp ):longint;  { high 4 byte                     }
var tmp: comp;
begin
  tmp := m_div( a, two32 );
  if tmp >= two31 then tmp := tmp-two32;
  m_compHigh:= Trunc(tmp);
end;
{--------- ⨭, ᫨  ⥫ । primes^[1..NPrimes] -----------}
Function  m_is_prime_0( n: longint ):boolean;
var i: integer;
begin
  if primes = NIL then m_FillPrimes_0;
  m_is_prime_0 := False;
  i := 1;
  while (i<=NPrimes) and (Sqr(primes^[i]) <= n) do begin
    if (n mod primes^[i]) = 0 then Exit;
    inc(i);
  end;
  m_is_prime_0 := True;
end;
{--------------------------------------------------------------------------}
Procedure m_FillPrimes_0;
var n: longint;  i: integer;
begin
  if primes <> NIL then Exit;
  if MemAvail<=sizeOf(PrArray) then ErrProc(1,'No memory for primes');
  New( primes );

  i:=1; primes^[i] := 2;
  n := 3;
  repeat
    inc(i);
    while not m_is_prime_0(n) do n:= n+2;
    primes^[i] := n; n:= n+2;
  until i = NPrimes;
end;
{--------------------------------------------------------------------------}
begin
  max_comp := $7FFFFFFF;
  max_comp := 2*max_comp*max_comp+4*max_comp+1;     {2^63-1}
  two32    := 65536; two32 := Sqr(two32);           {2^32  }
  two31    := 65536; two31 := two31*32768;          {2^31  }
  primes   := NIL;
end.


               A*.FRM                                        *.MAC                                                          8         