uses uni2dos;

type TStr3=Array[1..3] of Char;
     TStr8=Array[1..8] of Char;
     TStr10=Array[1..10] of Char;

type TSector0 = Record
       Jump             : Array[1..3] of Char;   { NEAR-    }
       OEMName          : Array[1..8] of Char;   { OEM-     }
       SectSize         : Word;                  {    }
       ClustSize        : Byte;                  {     () }
       ResSecs          : Word;                  {   (   FAT) }
       FatCnt           : Byte;                  {   FAT }
       RootSiz          : Word;                  { . 32-    }
       TotSecs          : Word;                  {      ( DOS) }
       Media            : Byte;                  {   ( ,  1-  FAT) }
       FatSize          : Word;                  {     FAT }
       TrkSecs          : Word;                  {    () }
       HeadCnt          : Word;                  {   / () }
       HidnSec          : Word;                  {   (.   ) }
       Ostatok          : Array[1..486] of Char; { , -      }
     End;

type TFile = Record
       Name             : TStr8;                 {   }
       Ext              : TStr3;                 {  }
       Attr             : Byte;                  {   }
       Reserv           : TStr10;                {  }
       Time             : Word;                  {  /   filetime }
       Date             : Word;                  {  /   filetime }
       ClstrNo          : Word;                  {     (  FAT ) }
       Size             : LongInt;               {     }
     End;

type TLongSearchRec = Record
       Name             : TStr8;                 {   }
       LongName         : String;                {    }
       Ext              : TStr3;                 {  }
       Attr             : Byte;                  {   }
       Reserv           : TStr10;                {  }
       Time             : Word;                  {  /   filetime }
       Date             : Word;                  {  /   filetime }
       ClstrNo          : Word;                  {     (  FAT ) }
       Size             : LongInt;               {     }
       FPosInSec        : Integer;               {  -   }
       FSecPos          : Integer;               {  -  }
       FMask            : String;                {    }
       FAttr            : Byte;                  {    FindFirst }
     End;

type TDTA = Record
       Reserved         : Array[1..$15] of Byte; {   FindNext }
       Attr             : Byte;                  {   }
       Time             : Word;                  {  /   filetime }
       Date             : Word;                  {  /   filetime }
       Size             : LongInt;               {     }
       Name             : Array[1..13] of Char;  {   + . + }
     End;

type TDir=Array[0..15] of TFile;

var s0           : TSector0;
    dir          : TDir;
    Root         : Word;
    I            : Word;
    Search       : TLongSearchRec;
    LongDosError : Integer;
    SecPerCat    : Integer;
    DTA          : TDTA;        {  DTA }

Function ReadSector(A:Pointer;Disk:Byte;Count:Word;Sector:Word):Boolean;
var Error     :Word;
    Offs      :Word;
Begin
 Offs:=Word(A);
 Error:=0;
  asm
         mov  al,[Disk]         {  0-A}
         mov  cx,[Count]        {  }
         mov  dx,[Sector]       { }

         mov  bx,[Offs]
         int  25h
         pop  dx
         je   @nError
         mov  ax,1
         mov  [Error],ax
@nError:
  end;
 if Error=0 then ReadSector:=True
            else ReadSector:=False;
End;

{     #################################################}
function GetUniLFN(I:Word):String;
var Str,Str0,Str1:String;
    Flag:Boolean;
    Len:Integer;
Begin
 Flag:=true;Str0:=#255+#255;Str:='';Str1:='';
 While flag do
  Begin
      Str1:=copy(Dir[I-1].Name,2,7)+Dir[I-1].Ext+copy(Dir[I-1].Reserv,3,8)+char(Dir[I-1].Time)+
            char(Dir[I-1].Time shr 8)+char(Dir[I-1].Date)+char(Dir[I-1].Date shr 8)+char(Dir[I-1].Size)+
            char(Dir[I-1].Size shr 8)+char(Dir[I-1].Size shr 16)+char(Dir[I-1].Size shr 24);
   Len:=pos(Str0,Str1);
   If Len<>0 then Begin Flag:=False; Str:=Str+copy(Str1,1,Len); End
             else Begin
                    dec(i);
                    Str:=Str+Str1;
                    if Dir[I].Attr<>15 then Flag:=False;
                  End;
  End;
 GetUniLFN:=Str;
End;

{ Long Find First ###########################################################}
Procedure LongFindFirst(Path:String;Attr:Word;var SR:TLongSearchRec);
var I,Sec                  :Integer;
    Drive                  :Word;        {   }
    NameSeg,NameOfs        :Word;        {     }
    ParentDir              :String;      {   }
    Sector,InSect,Data     :LongInt;     { ,     }
    DTASeg,DTASize,DTAOfs  :Word;        {   DTA }
Begin
 LongDOSError:=0;
 {Drive:=Path[1];} Drive:=0;         {    }
 ParentDir:=copy(Path,4,Length(Path)-1);   {    }
 If not ReadSector(@s0,Drive,1,0) then Exit;
 If Pos('\',ParentDir)=0 then
  Begin {     #################################################}
   Path:=Path+#0;
   NameSeg:=Seg(Path);NameOfs:=Ofs(Path)+1;
   DTAOfs:=Ofs(DTA);DTASeg:=Seg(DTA);DTASize:=Sizeof(DTA);
   asm                                 { FindFirst -  }
         push ds

         mov ax,[NameSeg]
         mov ds,ax
         mov dx,[NameOfs]
         mov ah,$4E                   {  DOS -    }
         mov cx,Attr                  {   }
         int 21h
         jnc @FilesF
         mov ax,$FF
         mov [LongDOSError],ax
         jmp @AsmEnd
@FilesF: mov ah,$2f                   {    DTA }
         int 21h
         mov ax,es                    {       DTA }
         mov ds,ax
         mov si,bx
         mov di,[DTAOfs]
         mov es,[DTASeg]
         mov cx,[DTASize]
         cld
         rep movsb

@AsmEnd: pop ds
   end; {  DTA.Reserved[14]       }
   If LongDOSError<>0 then Exit;
   Sector:=trunc((DTA.Reserved[14]+256*DTA.Reserved[15])/(s0.SectSize shr 5)); {  ,     }
   InSect:=(DTA.Reserved[14]+256*DTA.Reserved[15])-Sector*(s0.SectSize shr 5); {     }
   Root:=s0.ResSecs+s0.FatSize*s0.FatCnt; {      }
   If not ReadSector(@dir,0,1,Root+Sector) then Exit; {   }
   SR.Name:=dir[InSect].Name; {  TLongSearchRec }
   SR.Ext:=dir[InSect].Ext;
   SR.Attr:=dir[InSect].Attr;
   SR.Reserv:=dir[InSect].Reserv;
   SR.Time:=dir[InSect].Time;
   SR.Date:=dir[InSect].Date;
   SR.ClstrNo:=dir[InSect].ClstrNo;
   SR.Size:=dir[InSect].Size;
   {     }
   If (InSect>0) and (dir[InSect-1].attr=15) then SR.LongName:=UniToDos(GetUniLFN(InSect))
                                             else SR.LongName:=dir[InSect].Name+'.'+dir[InSect].Ext;
  End
 else
  Begin {      ##############################################}
   Path:=Path+#0;
   NameSeg:=Seg(Path);NameOfs:=Ofs(Path)+1;
   DTAOfs:=Ofs(DTA);DTASeg:=Seg(DTA);DTASize:=Sizeof(DTA);
   asm                                 { FindFirst -  }
         push ds

         mov ax,[NameSeg]
         mov ds,ax
         mov dx,[NameOfs]
         mov ah,$4E                   {  DOS -    }
         mov cx,Attr                  {   }
         int 21h
         jnc @FilesF
         mov ax,$FF
         mov [LongDOSError],ax
         jmp @AsmEnd
@FilesF: mov ah,$2f                   {    DTA }
         int 21h
         mov ax,es                    {       DTA }
         mov ds,ax
         mov si,bx
         mov di,[DTAOfs]
         mov es,[DTASeg]
         mov cx,[DTASize]
         cld
         rep movsb

@AsmEnd: pop ds
   end; {  DTA.Reserved[14]       }
   If LongDOSError<>0 then Exit;
   Sector:=trunc((DTA.Reserved[14]+256*DTA.Reserved[15])/(s0.SectSize shr 5));
   InSect:=(DTA.Reserved[14]+256*DTA.Reserved[15])-Sector*(s0.SectSize shr 5); {     }
   Sector:=Sector+DTA.Reserved[16]+256*DTA.Reserved[17]-3; {  ,     }
   Root:=s0.ResSecs+s0.FatSize*s0.FatCnt; {      }
   Data:=Root+(s0.RootSiz*32) div s0.SectSize;
   If not ReadSector(@dir,0,1,Data+Sector) then Exit; {   }
   SR.Name:=dir[InSect].Name; {  TLongSearchRec }
   SR.Ext:=dir[InSect].Ext;
   SR.Attr:=dir[InSect].Attr;
   SR.Reserv:=dir[InSect].Reserv;
   SR.Time:=dir[InSect].Time;
   SR.Date:=dir[InSect].Date;
   SR.ClstrNo:=dir[InSect].ClstrNo;
   SR.Size:=dir[InSect].Size;
   {     }
   If (InSect>0) and (dir[InSect-1].attr=15) then SR.LongName:=UniToDos(GetUniLFN(InSect))
                                             else SR.LongName:=dir[InSect].Name+'.'+dir[InSect].Ext;
  End;
End;

{ Long Find Next ############################################################}
Procedure LongFindNext(var SR:TLongSearchRec);
var
    Drive                  :Word;        {   }
    Sector,InSect,Data     :LongInt;     { ,     }
    DTASeg,DTASize,DTAOfs  :Word;        {   DTA }
Begin
 Drive:=0;
 LongDOSError:=0;
 DTAOfs:=Ofs(DTA);DTASeg:=Seg(DTA);DTASize:=Sizeof(DTA);
 asm                                  { FindFirst -  }
         push ds

         mov ah,$2f                   {    DTA }
         int 21h
         mov dx,bx
         mov ah,$4F                   {  DOS -    }
         int 21h
         jnc @FilesF
         mov ax,$FF
         mov [LongDOSError],ax
         jmp @AsmEnd
@FilesF: mov ah,$2f                   {    DTA }
         int 21h
         mov ax,es                    {       DTA }
         mov ds,ax
         mov si,bx
         mov di,[DTAOfs]
         mov es,[DTASeg]
         mov cx,[DTASize]
         cld
         rep movsb

@AsmEnd: pop ds
 end; {  DTA.Reserved[14]       }
 If LongDOSError<>0 then Exit;
 Sector:=trunc((DTA.Reserved[14]+256*DTA.Reserved[15])/(s0.SectSize shr 5));
 InSect:=(DTA.Reserved[14]+256*DTA.Reserved[15])-Sector*(s0.SectSize shr 5); {     }
 Sector:=Sector+DTA.Reserved[16]+256*DTA.Reserved[17]-3; {  ,     }
 Root:=s0.ResSecs+s0.FatSize*s0.FatCnt; {      }
 Data:=Root+(s0.RootSiz*32) div s0.SectSize;
 If not ReadSector(@dir,0,1,Data) then Exit; {   }
 SR.Name:=dir[InSect].Name; {  TLongSearchRec }
 SR.Ext:=dir[InSect].Ext;
 SR.Attr:=dir[InSect].Attr;
 SR.Reserv:=dir[InSect].Reserv;
 SR.Time:=dir[InSect].Time;
 SR.Date:=dir[InSect].Date;
 SR.ClstrNo:=dir[InSect].ClstrNo;
 SR.Size:=dir[InSect].Size;
 {     }
 If (InSect>0) and (dir[InSect-1].attr=15) then SR.LongName:=UniToDos(GetUniLFN(InSect))
                                           else SR.LongName:=dir[InSect].Name+'.'+dir[InSect].Ext;
End;

Begin
 WriteLn;
 InitUni;
 LongFindFirst('A:\1\*.*',$FFFF,Search);
 While LongDosError=0 do
  Begin
   WriteLn(Search.Name+' '+Search.Ext+' ',Search.Size:8,' ',
           Search.FPosInSec:8,' ',Search.FSecPos:8,' ',Search.LongName);
   LongFindNext(Search);
   Search.LongName:=copy(Search.LongName,1,30);
  End;
End.