.model tiny
.code
locals

                org 100h

;----- ⭠   -----

Entry:
                jmp Init

DefInt2F        dd ?    ;।饥 祭  뢠 2Fh
MPId            db ?    ;⨯ 䨪

;ࠡ稪 ⨯᭮ 뢠. ᯮ  ࣠樨 䥩
; ࠭⭮  १⭮ ﬨ .  AH ਭ 䨪
;ணࠬ,  AL -  㭪樨
Int2F           proc
                cmp ah,cs:MPId
                je @@SelFunc
                jmp cs:DefInt2F

@@SelFunc:
                or al,al
                jz @@Func0
                dec al
                jz @@GetInstAddr
                iret

;㭪 0 ⨯᭮ 뢠: ஢ઠ ⨯᭮ 䨪
; . 頥 -1, ᫨ 䨪 ਭ  ணࠬ
;( ᥣ ।  DX 祭 'RS')  1, ᫨ 䨪
;ਭ 㣮 १. ⠭ ࠡ稪 頥 0. ᫨ 
;-⠪  ࠢ,  㪠  AH 䨪
;  . 㭪 0   ॠ ᥣ.
@@Func0:                
                dec al
                cmp dx,'RS'
                je @@Func0_1
                neg al
@@Func0_1:
                iret

;㭪 1 頥  ES   ᥣ १⭮ 樨.
@@GetInstAddr:
                push cs
                pop es
                iret
Int2F           endp

res_size        equ ($ - entry)/16+17
;ࠧ १⭮ 樨  ࠣ (  16 ) + 16  PSP

;----- ࠭⭠   -----
Init:
;஢ઠ ᨨ DOS: TSR  ⨯᭮ 뢠 ࠡ ⮫쪮 
;2.0  
                mov ah,30h
                int 21h
                cmp al,2
                jge ParseArg
                lea dx,ErrMsg5
                jmp Error

;ࠧ 㬥⮢  ப (᫥ ࠭  PSP  ᬥ饭 80h,
;  - )
ParseArg:
                mov si,80h
                xor cx,cx
                cld
                lodsb
                or cl,al
                jz Install
ParseArg_1:
                lodsb
                cmp al,' '              
                loope ParseArg_1
                je Install
                jcxz ShowUsage
                mov ah,al
                lodsb
                cmp ax,'/q'
                je Release
ShowUsage:
                lea dx,UsageMsg
                jmp Error

;㤠   १⭮ 樨
Release:
                call EnumMPIds      ; , -   㤠?
                or al,al
                jz ErrNoRelease
                push ds
                mov al,1
                int 2Fh
                mov ax,252Fh        ;⠭ 祭  2Fh
                lds dx,es:DefInt2F
                int 21h
                pop ds
                mov ah,49h          ;㤠塞 १   
                int 21h
                jc ErrMemAlloc
                mov ah,9
                lea dx,Msg2
                int 21h
                mov ax,4C00h
                int 21h

;⠭ १⭮ 樨
Install:
                call EnumMPIds      ;㦥 ⠭?
                jcxz ErrNoId
                cmp al,-1
                je ErrAlreadyInst
                mov MPId,ah

                mov es,ds:[2Ch]     ;  - 頥  ६
                mov ah,49h          ;।
                int 21h
                jc ErrMemAlloc
                mov ax,352Fh        ;砥 ⥪騩  뢠 2Fh
                int 21h
                mov word ptr DefInt2F,bx    ; 
                mov word ptr DefInt2F[2],es
                mov ax,252Fh        ; ⠭  ࠡ稪
                lea dx,Int2F
                int 21h
                lea dx,Msg1
                mov ah,9
                int 21h
                mov dx,res_size     ;TSR!
                mov ax,3100h
                int 21h

;----- 뢮 ᮮ饭  訡 -----

ErrMemAlloc:
                lea dx,ErrMsg1
                jmp Error
ErrNoId:
                lea dx,ErrMsg2
                jmp Error
ErrAlreadyInst:
                lea dx,ErrMsg3
                jmp Error
ErrNoRelease:
                lea dx,ErrMsg4

Error:
                mov ah,9
                int 21h
                mov ax,4C01h
                int 21h

;楤 ᪠ ᢮,  ਭ饣  ணࠬ
;⨯᭮ 䨪 (ᯮ 㭪 0 ⨯᭮
;뢠)
EnumMPIds       proc
                mov cx,64
@@CheckId:
                push cx
                mov ax,0BF00h
                add ah,cl
                mov dx,'RS'
                int 2Fh
                pop cx
                cmp al,-1
                je @@Exit
                or al,al
                loopnz @@CheckId
@@Exit:
                ret     
EnumMPIds       endp

;----- 饭 -----

UsageMsg        db 'Usage: resid [/q]',13,10
                db 9, '/q - release resident',13,10,'$'

Msg1            db 'Resident installed',13,10,'$'
Msg2            db 'Resident released',13,10,'$'

ErrMsg1         db 'Memory allocation error',13,10,'$'
ErrMsg2         db 'Could not find a free multiplex identifer: '
                db 'too many resident programs are installed',13,10,'$'
ErrMsg3         db 'Resident is already installed',13,10,'$'
ErrMsg4         db 'Nothing to release',13,10,'$'
ErrMsg5         db 'This program requires MS-DOS 2.0 or later',13,10,'$'

                end entry
