{        Calendar.pas 
 㭪権  ࠡ  ⠬ 
 ᫥  .
:   襢
Fido:   2:5020/1194
E-mail: v_ostashev@chat.ru
WWW:    http://ostashev.newmail.ru
}
unit calendar;

interface

type
     tdate               = record
                                d                   : byte;
                                m                   : byte;
                                y                   : integer;
                           end;
     {࠭ }
     tstyle              = (grigorian, julian);
     { ⨫ -  ᪨,   - ਣਠ᪨}

function datein(low, high, dt : tdate) : boolean;
{஢ 宦   ஬⪥
  low  high}

procedure stringtodate(st : string; var dt : tdate);
{८ࠧ ப  }

procedure datetostring(dt : tdate; var st : string);
{८ࠧ   ப}

function compdate(d1, d2 : tdate) : integer;
{ࠢ  . 頥 0, ᫨  ࠢ,
 -1, ᫨ ࢠ   ன  1, ᫨ }

function numofday(dat : tdate; style : tstyle) : longint;
{ ᫮     dat  ⮬
  ⨫  style=true}

function dayofweek(dat : tdate; style : tstyle) : byte;
{     dat  ⮬
  ⨫  style=true}

function numinyear(dat : tdate; style : tstyle) : word;
{    砫   ⮬ ⨫}

function lenofmonth(month : byte; year : word; style : tstyle) : byte;
{    ⮬ ⨫}

procedure numtodate(num : longint; style : tstyle; var dat : tdate);
{     }

function isleap(year : integer):boolean;
{   ᮪}


implementation

     function datein;
     begin
          datein := (compdate(low, dt) <= 0) and (compdate(high, dt) >= 0);
     end;

     procedure stringtodate;
     var
          s                   : array[1..3] of string[5];
          i, j                : integer;
     begin
          for i := 1 to 3 do s[i] := '';
          j := 1;
          for i := 1 to 3 do begin
               while (st[j] in ['0'..'9']) and (j <= length(st)) do
                    begin
                         s[i] := s[i]+st[j];
                         inc(j);
                    end;
               inc(j);
          end;
          val(s[1], dt.d, i);
          val(s[2], dt.m, i);
          val(s[3], dt.y, i);
     end;

     procedure datetostring;
     var
          s1, s2, s3          : string[5];
     begin
          str(dt.d, s1);
          str(dt.m, s2);
          str(dt.y, s3);
          if dt.d < 10 then s1 := '0'+s1;
          if dt.m < 10 then s2 := '0'+s2;
          st := s1+'.'+s2+'.'+s3;
     end;


     function compdate;
     var
          a, b                : longint;
     begin
          {  ࠧ   ⨫  }
          a:= numofday(d1,julian);
          b:= numofday(d2,julian);
          if a-b = 0 then compdate := 0;
          if a-b > 0 then compdate := 1;
          if a-b < 0 then compdate := -1;
     end;

     function numofday;
     var
          stcor               : integer;
     begin
          { 㫥 num=[year*365.25]+[(month+1)*30.6]+day+style}
          {塞 ࠢ  ਣਠ᪨ ⨫}
          if style = grigorian then
               begin
                    stcor := 2-dat.y div 100+dat.y div 400;
                    if ((dat.y mod 100 = 0) and (dat.y mod 400 <> 0)) and (dat.m <= 2) then stcor := stcor + 1;
               end
                               else
               begin
                    stcor := 0;
               end;
          {ࠧ 㢥 }
          inc(dat.m);
          {᫨  ﭢ  䥢ࠫ,  month=month+12, year=year-1}
          if dat.m <= 3 then
               begin
                    dat.m := dat.m+12;
                    dec(dat.y);
               end;
          {塞  }
          numofday := (36525*dat.y) div 100 + (306*dat.m) div 10 + stcor + dat.d;
     end;

     function dayofweek;
     var
          sum                 : real;
          day                 : byte;
          buf                 : longint;
     begin
          buf := numofday(dat, style);
          {ਡ塞 ⠭ 4.5 - ⠪  㫥}
          buf := buf+4;
          day := buf mod 7;
          {ᥭ쥬   砥 }
          if day = 0 then day := 7;
          dayofweek := day;
     end;

     function lenofmonth;
     var
          len                 : byte;
     begin
          case month of
               2 : begin
                        if year mod 4 = 0 then len := 29
                                          else len := 28;
                        if (style = grigorian) and (year mod 100 = 0) and (year mod 400 > 0) then len := 28;
                   end;
               4, 6, 9, 11 : len := 30
               else len := 31;
          end;
          lenofmonth := len;
     end;

     function numinyear;
     var
          dbuf                : tdate;
     begin
          dbuf.d := 0;
          dbuf.m := 1;
          dbuf.y := dat.y;
          numinyear := word(numofday(dat, style)-numofday(dbuf, style));
     end;

     procedure numtodate;
     begin
          {ਡ⥫쭮 室    ࠭⨨ ਡ塞 5,
           ⮡ 筮 ஬   ஭}
          dat.y := (num*100) div 36525 + 5;
          dat.d := 1;
          dat.m := 1;
          {  ᪠  室  ॡ஬}
          repeat
               dec(dat.y);
          until (num >= numofday(dat, style));
          {  饬 ॡ஬ ,  }
          repeat
               inc(dat.m);
          until (num < numofday(dat, style));
          {஬㫨  1  }
          dec(dat.m);
          {     ⠫ -   }
          dat.d := num-numofday(dat, style)+1;
     end;

     function isleap;
     begin
          isleap := (((year mod 4 = 0) and (year mod 100 <> 0)) or (year mod 400 = 0));
     end;

end.


