with Ada.Strings.Wide_Wide_Fixed;
with Ada.Strings.Wide_Wide_Unbounded;
with Ada.Strings.UTF_Encoding.Wide_Wide_Strings;

package Minimal_Console is

   pragma Preelaborate;

   use Ada;

   subtype Char is Wide_Wide_Character;
   subtype F_String is Wide_Wide_String;
   subtype U_String is Ada.Strings.Wide_Wide_Unbounded.Unbounded_Wide_Wide_String;

   package F_Strings renames Ada.Strings.Wide_Wide_Fixed;
   package U_Strings renames Ada.Strings.Wide_Wide_Unbounded;

   function "+" (Source : in F_String) return U_String renames U_Strings.To_Unbounded_Wide_Wide_String;
   function "+" (Source : in U_String) return F_String renames U_Strings.To_Wide_Wide_String;

   function "&"  (Left, Right : in U_String) return U_String renames U_Strings."&";
   function "&"  (Left : in U_String; Right : in F_String) return U_String renames U_Strings."&";
   function "&"  (Left : in F_String; Right : in U_String) return U_String renames U_Strings."&";
   function "&"  (Left : in U_String; Right : in Char) return U_String renames U_Strings."&";
   function "&"  (Left : in Char; Right : in U_String) return U_String renames U_Strings."&";

   function "="  (Left, Right : in U_String) return Boolean renames U_Strings."=";
   function "="  (Left : in U_String; Right : in F_String) return Boolean renames U_Strings."=";
   function "="  (Left : in F_String; Right : in U_String) return Boolean renames U_Strings."=";

   function "<"  (Left, Right : in U_String) return Boolean renames U_Strings."<";
   function "<"  (Left : in U_String; Right : in F_String) return Boolean renames U_Strings."<";
   function "<"  (Left : in F_String; Right : in U_String) return Boolean renames U_Strings."<";

   function "<=" (Left, Right : in U_String) return Boolean renames U_Strings."<=";
   function "<=" (Left : in U_String; Right : in F_String) return Boolean renames U_Strings."<=";
   function "<=" (Left : in F_String; Right : in U_String) return Boolean renames U_Strings."<=";

   function ">"  (Left, Right : in U_String) return Boolean renames U_Strings.">";
   function ">"  (Left : in U_String; Right : in F_String) return Boolean renames U_Strings.">";
   function ">"  (Left : in F_String; Right : in U_String) return Boolean renames U_Strings.">";

   function ">=" (Left, Right : in U_String) return Boolean renames U_Strings.">=";
   function ">=" (Left : in U_String; Right : in F_String) return Boolean renames U_Strings.">=";
   function ">=" (Left : in F_String; Right : in U_String) return Boolean renames U_Strings.">=";

   subtype UTF_8_String is Ada.Strings.UTF_Encoding.UTF_8_String;

   function To_UTF_8 (Item : F_String) return UTF_8_String is
     (Ada.Strings.UTF_Encoding.Wide_Wide_Strings.Encode (Item)) with Inline;
   function To_UTF_32 (Item : UTF_8_String) return F_String renames Ada.Strings.UTF_Encoding.Wide_Wide_Strings.Decode;

end Minimal_Console;
