------------------------------------------------------------------------------
-- Copyright 2019 Levashev Ivan Aleksandrovich                              --
--                                                                          --
-- Licensed under the Apache License, Version 2.0 (the "License");          --
-- you may not use this file except in compliance with the License.         --
-- You may obtain a copy of the License at                                  --
--                                                                          --
--     http://www.apache.org/licenses/LICENSE-2.0                           --
--                                                                          --
-- Unless required by applicable law or agreed to in writing, software      --
-- distributed under the License is distributed on an "AS IS" BASIS,        --
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. --
-- See the License for the specific language governing permissions and      --
-- limitations under the License.                                           --
------------------------------------------------------------------------------

--  Wide_Wide_Character and Wide_Wide_String backported to AdaMagic
--
--  GNAT version of this package is supposed to be empty. This is to make 
--  possible to "use" this package and expect that the right thing will be 
--  found in both GNAT and AdaMagic.
--
--  "Use"-ability of this package is in conflict with qualified referencing.
--  Ada_Magic_Forward.Standard_Forward complements this package to fill this
--  gap. I.e. Ada_Magic_Forward.Standard_Forward.Wide_Wide_Character or
--  Ada_Magic_Forward.Standard_Forward."<" are defined in both GNAT and
--  AdaMagic.

with Interfaces;

package Ada_Magic_Forward.Wide_Wide_Characters is

   pragma Pure;
   pragma Preelaborate;

   --  The declaration of type Wide_Wide_Character is based on the full
   --  ISO/IEC 10646:2011 character set. The first 65536 positions have the
   --  same contents as type Wide_Character. See 3.5.2.

   type Wide_Wide_Character is
     new Interfaces.Integer_32 range 0 .. 16#7FFFFFFF#;
   for Wide_Wide_Character'Size use 32;
   --  Enumerable nature of Wide_Wide_Character had to be shown somehow.
   --  Public inheritance from Interfaces.Integer_32 achieves this.
   --
   --  Integer origins are cleaned, functions "+", "-" and so on are 
   --  removed. However, it is still possible to create Wide_Wide_Character
   --  from universal integral literal. It virtually cannot be fixed.
   --
   --  Reminder: use Wide_Wide_Character'Val (...) for portable creation of 
   --  character values.

   function "+" (Right : Wide_Wide_Character'Base) return Wide_Wide_Character'Base is
     abstract;
   function "-" (Right : Wide_Wide_Character'Base) return Wide_Wide_Character'Base is
     abstract;
   function "abs" (Right : Wide_Wide_Character'Base) return Wide_Wide_Character'Base is
     abstract;

   function "+" (Left, Right : Wide_Wide_Character'Base) return Wide_Wide_Character'Base is
     abstract;
   function "-" (Left, Right : Wide_Wide_Character'Base) return Wide_Wide_Character'Base is
     abstract;
   function "*" (Left, Right : Wide_Wide_Character'Base) return Wide_Wide_Character'Base is
     abstract;
   function "/" (Left, Right : Wide_Wide_Character'Base) return Wide_Wide_Character'Base is
     abstract;
   function "rem" (Left, Right : Wide_Wide_Character'Base) return Wide_Wide_Character'Base is
     abstract;
   function "mod" (Left, Right : Wide_Wide_Character'Base) return Wide_Wide_Character'Base is
     abstract;

   function "**" (Left : Wide_Wide_Character'Base; Right : Natural) return Wide_Wide_Character'Base is
     abstract;

   type Wide_Wide_String is array (Positive range <>) of Wide_Wide_Character;
   pragma Pack (Wide_Wide_String);

   --  The predefined operators for this type correspond to those for String.

end Ada_Magic_Forward.Wide_Wide_Characters;
