------------------------------------------------------------------------------
-- Copyright 2019 Levashev Ivan Aleksandrovich                              --
--                                                                          --
-- Licensed under the Apache License, Version 2.0 (the "License");          --
-- you may not use this file except in compliance with the License.         --
-- You may obtain a copy of the License at                                  --
--                                                                          --
--     http://www.apache.org/licenses/LICENSE-2.0                           --
--                                                                          --
-- Unless required by applicable law or agreed to in writing, software      --
-- distributed under the License is distributed on an "AS IS" BASIS,        --
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. --
-- See the License for the specific language governing permissions and      --
-- limitations under the License.                                           --
------------------------------------------------------------------------------

--  Ada 2005+ and GNAT features backported to AdaMagic
--
--  GNAT version of this package is supposed to rename stuff from Standard
--
--  Features like Wide_Wide_Character rely on "use"-able packages providing
--  missing stuff. However, in this case it's not possible to write
--  qualified identifiers in a portable way. Standard_Forward fills this gap.
--  It is not suitable to be "use"-d, but it is suitable for qualified 
--  references.

with Ada_Magic_Forward.Wide_Wide_Characters;

package Ada_Magic_Forward.Standard_Forward is

   pragma Pure;
   pragma Preelaborate;

   subtype Boolean renames Standard.Boolean;

   --  The predefined relational operators for this type are as follows:

   function "=" (Left, Right : Boolean'Base) return Boolean
     renames Standard."=";
   function "/=" (Left, Right : Boolean'Base) return Boolean
     renames Standard."/=";
   function "<" (Left, Right : Boolean'Base) return Boolean
     renames Standard."<";
   function "<=" (Left, Right : Boolean'Base) return Boolean
     renames Standard."<=";
   function ">" (Left, Right : Boolean'Base) return Boolean
     renames Standard.">";
   function ">=" (Left, Right : Boolean'Base) return Boolean
     renames Standard.">=";

   --  The predefined logical operators and the predefined logical
   --  negation operator are as follows:

   function "and" (Left, Right : Boolean'Base) return Boolean'Base
     renames Standard."and";
   function "or" (Left, Right : Boolean'Base) return Boolean'Base
     renames Standard."or";
   function "xor" (Left, Right : Boolean'Base) return Boolean'Base
     renames Standard."xor";

   function "not" (Right : Boolean'Base) return Boolean'Base
     renames Standard."not";

   subtype Integer is Standard.Integer;
   subtype Natural is Standard.Natural;
   subtype Positive is Standard.Positive;

   --  The predefined operators for type Integer are as follows:

   function "=" (Left, Right : Integer'Base) return Boolean
     renames Standard."=";
   function "/=" (Left, Right : Integer'Base) return Boolean
     renames Standard."/=";
   function "<" (Left, Right : Integer'Base) return Boolean
     renames Standard."<";
   function "<=" (Left, Right : Integer'Base) return Boolean
     renames Standard."<=";
   function ">" (Left, Right : Integer'Base) return Boolean
     renames Standard.">";
   function ">=" (Left, Right : Integer'Base) return Boolean
     renames Standard.">=";

   function "+" (Right : Integer'Base) return Integer'Base
     renames Standard."+";
   function "-" (Right : Integer'Base) return Integer'Base
     renames Standard."-";
   function "abs" (Right : Integer'Base) return Integer'Base
     renames Standard."abs";

   function "+" (Left, Right : Integer'Base) return Integer'Base
     renames Standard."+";
   function "-" (Left, Right : Integer'Base) return Integer'Base
     renames Standard."-";
   function "*" (Left, Right : Integer'Base) return Integer'Base
     renames Standard."*";
   function "/" (Left, Right : Integer'Base) return Integer'Base
     renames Standard."/";
   function "rem" (Left, Right : Integer'Base) return Integer'Base
     renames Standard."rem";
   function "mod" (Left, Right : Integer'Base) return Integer'Base
     renames Standard."mod";

   function "**" (Left : Integer'Base; Right : Natural)
     return Integer'Base
     renames Standard."**";

   --  The specification of each operator for the type
   --  root_integer, or for any additional predefined integer
   --  type, is obtained by replacing Integer by the name of the type
   --  in the specification of the corresponding operator of the type
   --  Integer. The right operand of the exponentiation operator
   --  remains as subtype Natural.

   subtype Long_Integer is Standard.Long_Integer;

   -- The predefined operators for type Long_Integer are as follows:

   function "=" (Left, Right : Long_Integer'Base) return Boolean
     renames Standard."=";
   function "/=" (Left, Right : Long_Integer'Base) return Boolean
     renames Standard."/=";
   function "<" (Left, Right : Long_Integer'Base) return Boolean
     renames Standard."<";
   function "<=" (Left, Right : Long_Integer'Base) return Boolean
     renames Standard."<=";
   function ">" (Left, Right : Long_Integer'Base) return Boolean
     renames Standard.">";
   function ">=" (Left, Right : Long_Integer'Base) return Boolean
     renames Standard.">=";

   function "+" (Right : Long_Integer'Base) return Long_Integer'Base
     renames Standard."+";
   function "-" (Right : Long_Integer'Base) return Long_Integer'Base
     renames Standard."-";
   function "abs" (Right : Long_Integer'Base) return Long_Integer'Base
     renames Standard."abs";

   function "+" (Left, Right : Long_Integer'Base) return Long_Integer'Base
     renames Standard."+";
   function "-" (Left, Right : Long_Integer'Base) return Long_Integer'Base
     renames Standard."-";
   function "*" (Left, Right : Long_Integer'Base) return Long_Integer'Base
     renames Standard."*";
   function "/" (Left, Right : Long_Integer'Base) return Long_Integer'Base
     renames Standard."/";
   function "rem" (Left, Right : Long_Integer'Base) return Long_Integer'Base
     renames Standard."rem";
   function "mod" (Left, Right : Long_Integer'Base) return Long_Integer'Base
     renames Standard."mod";

   function "**" (Left : Long_Integer'Base; Right : Natural)
     return Long_Integer'Base
     renames Standard."**";

   subtype Long_Long_Integer is Standard.Long_Long_Integer;

   --  The predefined operators for type Long_Long_Integer are as follows:

   function "=" (Left, Right : Long_Long_Integer'Base) return Boolean
     renames Standard."=";
   function "/=" (Left, Right : Long_Long_Integer'Base) return Boolean
     renames Standard."/=";
   function "<" (Left, Right : Long_Long_Integer'Base) return Boolean
     renames Standard."<";
   function "<=" (Left, Right : Long_Long_Integer'Base) return Boolean
     renames Standard."<=";
   function ">" (Left, Right : Long_Long_Integer'Base) return Boolean
     renames Standard.">";
   function ">=" (Left, Right : Long_Long_Integer'Base) return Boolean
     renames Standard.">=";

   function "+" (Right : Long_Long_Integer'Base) return Long_Long_Integer'Base
     renames Standard."+";
   function "-" (Right : Long_Long_Integer'Base) return Long_Long_Integer'Base
     renames Standard."-";
   function "abs" (Right : Long_Long_Integer'Base) return Long_Long_Integer'Base
     renames Standard."abs";

   function "+" (Left, Right : Long_Long_Integer'Base) return Long_Long_Integer'Base
     renames Standard."+";
   function "-" (Left, Right : Long_Long_Integer'Base) return Long_Long_Integer'Base
     renames Standard."-";
   function "*" (Left, Right : Long_Long_Integer'Base) return Long_Long_Integer'Base
     renames Standard."*";
   function "/" (Left, Right : Long_Long_Integer'Base) return Long_Long_Integer'Base
     renames Standard."/";
   function "rem" (Left, Right : Long_Long_Integer'Base) return Long_Long_Integer'Base
     renames Standard."rem";
   function "mod" (Left, Right : Long_Long_Integer'Base) return Long_Long_Integer'Base
     renames Standard."mod";

   function "**" (Left : Long_Long_Integer'Base; Right : Natural)
     return Long_Long_Integer'Base
     renames Standard."**";

   subtype Short_Integer is Standard.Short_Integer;

   --  The predefined operators for type Short_Integer are as follows:

   function "=" (Left, Right : Short_Integer'Base) return Boolean
     renames Standard."=";
   function "/=" (Left, Right : Short_Integer'Base) return Boolean
     renames Standard."/=";
   function "<" (Left, Right : Short_Integer'Base) return Boolean
     renames Standard."<";
   function "<=" (Left, Right : Short_Integer'Base) return Boolean
     renames Standard."<=";
   function ">" (Left, Right : Short_Integer'Base) return Boolean
     renames Standard.">";
   function ">=" (Left, Right : Short_Integer'Base) return Boolean
     renames Standard.">=";

   function "+" (Right : Short_Integer'Base) return Short_Integer'Base
     renames Standard."+";
   function "-" (Right : Short_Integer'Base) return Short_Integer'Base
     renames Standard."-";
   function "abs" (Right : Short_Integer'Base) return Short_Integer'Base
     renames Standard."abs";

   function "+" (Left, Right : Short_Integer'Base) return Short_Integer'Base
     renames Standard."+";
   function "-" (Left, Right : Short_Integer'Base) return Short_Integer'Base
     renames Standard."-";
   function "*" (Left, Right : Short_Integer'Base) return Short_Integer'Base
     renames Standard."*";
   function "/" (Left, Right : Short_Integer'Base) return Short_Integer'Base
     renames Standard."/";
   function "rem" (Left, Right : Short_Integer'Base) return Short_Integer'Base
     renames Standard."rem";
   function "mod" (Left, Right : Short_Integer'Base) return Short_Integer'Base
     renames Standard."mod";

   function "**" (Left : Short_Integer'Base; Right : Natural)
     return Short_Integer'Base
     renames Standard."**";

   subtype Short_Short_Integer is Standard.Short_Short_Integer;

   --  The predefined operators for type Short_Short_Integer are as follows:

   function "=" (Left, Right : Short_Short_Integer'Base) return Boolean
     renames Standard."=";
   function "/=" (Left, Right : Short_Short_Integer'Base) return Boolean
     renames Standard."/=";
   function "<" (Left, Right : Short_Short_Integer'Base) return Boolean
     renames Standard."<";
   function "<=" (Left, Right : Short_Short_Integer'Base) return Boolean
     renames Standard."<=";
   function ">" (Left, Right : Short_Short_Integer'Base) return Boolean
     renames Standard.">";
   function ">=" (Left, Right : Short_Short_Integer'Base) return Boolean
     renames Standard.">=";

   function "+" (Right : Short_Short_Integer'Base) return Short_Short_Integer'Base
     renames Standard."+";
   function "-" (Right : Short_Short_Integer'Base) return Short_Short_Integer'Base
     renames Standard."-";
   function "abs" (Right : Short_Short_Integer'Base) return Short_Short_Integer'Base
     renames Standard."abs";

   function "+" (Left, Right : Short_Short_Integer'Base) return Short_Short_Integer'Base
     renames Standard."+";
   function "-" (Left, Right : Short_Short_Integer'Base) return Short_Short_Integer'Base
     renames Standard."-";
   function "*" (Left, Right : Short_Short_Integer'Base) return Short_Short_Integer'Base
     renames Standard."*";
   function "/" (Left, Right : Short_Short_Integer'Base) return Short_Short_Integer'Base
     renames Standard."/";
   function "rem" (Left, Right : Short_Short_Integer'Base) return Short_Short_Integer'Base
     renames Standard."rem";
   function "mod" (Left, Right : Short_Short_Integer'Base) return Short_Short_Integer'Base
     renames Standard."mod";

   function "**" (Left : Short_Short_Integer'Base; Right : Natural)
     return Short_Short_Integer'Base
     renames Standard."**";

   subtype Float is Standard.Float;

   --  The predefined operators for this type are as follows:

   function "=" (Left, Right : Float) return Boolean
     renames Standard."=";
   function "/=" (Left, Right : Float) return Boolean
     renames Standard."/=";
   function "<" (Left, Right : Float) return Boolean
     renames Standard."<";
   function "<=" (Left, Right : Float) return Boolean
     renames Standard."<=";
   function ">" (Left, Right : Float) return Boolean
     renames Standard.">";
   function ">=" (Left, Right : Float) return Boolean
     renames Standard.">=";

   function "+" (Right : Float) return Float
     renames Standard."+";
   function "-" (Right : Float) return Float
     renames Standard."-";
   function "abs" (Right : Float) return Float
     renames Standard."abs";

   function "+" (Left, Right : Float) return Float
     renames Standard."+";
   function "-" (Left, Right : Float) return Float
     renames Standard."-";
   function "*" (Left, Right : Float) return Float
     renames Standard."*";
   function "/" (Left, Right : Float) return Float
     renames Standard."/";

   function "**" (Left : Float; Right : Integer'Base) return Float
     renames Standard."**";

   subtype Long_Float is Standard.Long_Float;

   --  The predefined operators for this type are as follows:

   function "=" (Left, Right : Long_Float) return Boolean
     renames Standard."=";
   function "/=" (Left, Right : Long_Float) return Boolean
     renames Standard."/=";
   function "<" (Left, Right : Long_Float) return Boolean
     renames Standard."<";
   function "<=" (Left, Right : Long_Float) return Boolean
     renames Standard."<=";
   function ">" (Left, Right : Long_Float) return Boolean
     renames Standard.">";
   function ">=" (Left, Right : Long_Float) return Boolean
     renames Standard.">=";

   function "+" (Right : Long_Float) return Long_Float
     renames Standard."+";
   function "-" (Right : Long_Float) return Long_Float
     renames Standard."-";
   function "abs" (Right : Long_Float) return Long_Float
     renames Standard."abs";

   function "+" (Left, Right : Long_Float) return Long_Float
     renames Standard."+";
   function "-" (Left, Right : Long_Float) return Long_Float
     renames Standard."-";
   function "*" (Left, Right : Long_Float) return Long_Float
     renames Standard."*";
   function "/" (Left, Right : Long_Float) return Long_Float
     renames Standard."/";

   function "**" (Left : Long_Float; Right : Integer'Base) return Long_Float
     renames Standard."**";

   subtype Short_Float is Standard.Short_Float;

   --  The predefined operators for this type are as follows:

   function "=" (Left, Right : Short_Float) return Boolean
     renames Standard."=";
   function "/=" (Left, Right : Short_Float) return Boolean
     renames Standard."/=";
   function "<" (Left, Right : Short_Float) return Boolean
     renames Standard."<";
   function "<=" (Left, Right : Short_Float) return Boolean
     renames Standard."<=";
   function ">" (Left, Right : Short_Float) return Boolean
     renames Standard.">";
   function ">=" (Left, Right : Short_Float) return Boolean
     renames Standard.">=";

   function "+" (Right : Short_Float) return Short_Float
     renames Standard."+";
   function "-" (Right : Short_Float) return Short_Float
     renames Standard."-";
   function "abs" (Right : Short_Float) return Short_Float
     renames Standard."abs";

   function "+" (Left, Right : Short_Float) return Short_Float
     renames Standard."+";
   function "-" (Left, Right : Short_Float) return Short_Float
     renames Standard."-";
   function "*" (Left, Right : Short_Float) return Short_Float
     renames Standard."*";
   function "/" (Left, Right : Short_Float) return Short_Float
     renames Standard."/";

   function "**" (Left : Short_Float; Right : Integer'Base) return Short_Float
     renames Standard."**";

   --  The declaration of type Character is based on the standard ISO 8859-1 character set.

   subtype Character is Standard.Character;

   --  The predefined operators for the type Character are the same as for
   --  any enumeration type.

   function "=" (Left, Right : Character) return Boolean
     renames Standard."=";
   function "/=" (Left, Right : Character) return Boolean
     renames Standard."/=";
   function "<" (Left, Right : Character) return Boolean
     renames Standard."<";
   function "<=" (Left, Right : Character) return Boolean
     renames Standard."<=";
   function ">" (Left, Right : Character) return Boolean
     renames Standard.">";
   function ">=" (Left, Right : Character) return Boolean
     renames Standard.">=";
   
   --  The declaration of type Wide_Character is based on the standard ISO/IEC 10646:2011 BMP character
   --  set. The first 256 positions have the same contents as type Character. See 3.5.2.

   subtype Wide_Character is Standard.Wide_Character;

   function "=" (Left, Right : Wide_Character) return Boolean
     renames Standard."=";
   function "/=" (Left, Right : Wide_Character) return Boolean
     renames Standard."/=";
   function "<" (Left, Right : Wide_Character) return Boolean
     renames Standard."<";
   function "<=" (Left, Right : Wide_Character) return Boolean
     renames Standard."<=";
   function ">" (Left, Right : Wide_Character) return Boolean
     renames Standard.">";
   function ">=" (Left, Right : Wide_Character) return Boolean
     renames Standard.">=";

   --  The declaration of type Wide_Wide_Character is based on the full
   --  ISO/IEC 10646:2011 character set. The first 65536 positions have the
   --  same contents as type Wide_Character. See 3.5.2.

   subtype Wide_Wide_Character is
     Ada_Magic_Forward.Wide_Wide_Characters.Wide_Wide_Character;

   function "=" (Left, Right : Wide_Wide_Character) return Boolean
     renames Ada_Magic_Forward.Wide_Wide_Characters."=";
   function "/=" (Left, Right : Wide_Wide_Character) return Boolean
     renames Ada_Magic_Forward.Wide_Wide_Characters."/=";
   function "<" (Left, Right : Wide_Wide_Character) return Boolean
     renames Ada_Magic_Forward.Wide_Wide_Characters."<";
   function "<=" (Left, Right : Wide_Wide_Character) return Boolean
     renames Ada_Magic_Forward.Wide_Wide_Characters."<=";
   function ">" (Left, Right : Wide_Wide_Character) return Boolean
     renames Ada_Magic_Forward.Wide_Wide_Characters.">";
   function ">=" (Left, Right : Wide_Wide_Character) return Boolean
     renames Ada_Magic_Forward.Wide_Wide_Characters.">=";

   package ASCII renames Standard.ASCII;  --  Obsolescent; see J.5

   --  Predefined string types:

   subtype String is Standard.String;

   --  The predefined operators for this type are as follows:

   function "=" (Left, Right : String) return Boolean
     renames Standard."=";
   function "/=" (Left, Right : String) return Boolean
     renames Standard."/=";
   function "<" (Left, Right : String) return Boolean
     renames Standard."<";
   function "<=" (Left, Right : String) return Boolean
     renames Standard."<=";
   function ">" (Left, Right : String) return Boolean
     renames Standard.">";
   function ">=" (Left, Right : String) return Boolean
     renames Standard.">=";

   function "&" (Left : String; Right : String) return String
     renames Standard."&";
   function "&" (Left : Character; Right : String) return String
     renames Standard."&";
   function "&" (Left : String; Right : Character) return String
     renames Standard."&";
   function "&" (Left : Character; Right : Character) return String
     renames Standard."&";

   subtype Wide_String is Standard.Wide_String;

   --  The predefined operators for this type correspond to those for String.

   function "=" (Left, Right : Wide_String) return Boolean
     renames Standard."=";
   function "/=" (Left, Right : Wide_String) return Boolean
     renames Standard."/=";
   function "<" (Left, Right : Wide_String) return Boolean
     renames Standard."<";
   function "<=" (Left, Right : Wide_String) return Boolean
     renames Standard."<=";
   function ">" (Left, Right : Wide_String) return Boolean
     renames Standard.">";
   function ">=" (Left, Right : Wide_String) return Boolean
     renames Standard.">=";

   function "&" (Left : Wide_String; Right : Wide_String) return Wide_String
     renames Standard."&";
   function "&" (Left : Wide_Character; Right : Wide_String) return Wide_String
     renames Standard."&";
   function "&" (Left : Wide_String; Right : Wide_Character) return Wide_String
     renames Standard."&";
   function "&" (Left : Wide_Character; Right : Wide_Character) return Wide_String
     renames Standard."&";

   subtype Wide_Wide_String is
     Ada_Magic_Forward.Wide_Wide_Characters.Wide_Wide_String;

   --  The predefined operators for this type correspond to those for String.

   function "=" (Left, Right : Wide_Wide_String) return Boolean
     renames Ada_Magic_Forward.Wide_Wide_Characters."=";
   function "/=" (Left, Right : Wide_Wide_String) return Boolean
     renames Ada_Magic_Forward.Wide_Wide_Characters."/=";
   function "<" (Left, Right : Wide_Wide_String) return Boolean
     renames Ada_Magic_Forward.Wide_Wide_Characters."<";
   function "<=" (Left, Right : Wide_Wide_String) return Boolean
     renames Ada_Magic_Forward.Wide_Wide_Characters."<=";
   function ">" (Left, Right : Wide_Wide_String) return Boolean
     renames Ada_Magic_Forward.Wide_Wide_Characters.">";
   function ">=" (Left, Right : Wide_Wide_String) return Boolean
     renames Ada_Magic_Forward.Wide_Wide_Characters.">=";

   function "&" (Left : Wide_Wide_String; Right : Wide_Wide_String) return Wide_Wide_String
     renames Ada_Magic_Forward.Wide_Wide_Characters."&";
   function "&" (Left : Wide_Wide_Character; Right : Wide_Wide_String) return Wide_Wide_String
     renames Ada_Magic_Forward.Wide_Wide_Characters."&";
   function "&" (Left : Wide_Wide_String; Right : Wide_Wide_Character) return Wide_Wide_String
     renames Ada_Magic_Forward.Wide_Wide_Characters."&";
   function "&" (Left : Wide_Wide_Character; Right : Wide_Wide_Character) return Wide_Wide_String
     renames Ada_Magic_Forward.Wide_Wide_Characters."&";

   subtype Duration is Standard.Duration;

   --  The predefined operators for the type Duration are the same as for
   --  any fixed point type.

   function "=" (Left, Right : Duration) return Boolean
     renames Standard."=";
   function "/=" (Left, Right : Duration) return Boolean
     renames Standard."/=";
   function "<" (Left, Right : Duration) return Boolean
     renames Standard."<";
   function "<=" (Left, Right : Duration) return Boolean
     renames Standard."<=";
   function ">" (Left, Right : Duration) return Boolean
     renames Standard.">";
   function ">=" (Left, Right : Duration) return Boolean
     renames Standard.">=";

   function "+" (Right : Duration) return Duration
     renames Standard."+";
   function "-" (Right : Duration) return Duration
     renames Standard."-";
   function "abs" (Right : Duration) return Duration
     renames Standard."abs";

   function "+" (Left, Right : Duration) return Duration
     renames Standard."+";
   function "-" (Left, Right : Duration) return Duration
     renames Standard."-";
   function "*" (Left, Right : Duration) return Duration
     renames Standard."*";
   function "/" (Left, Right : Duration) return Duration
     renames Standard."/";

   function "**" (Left : Duration; Right : Integer'Base) return Duration
     renames Standard."**";

   -- The predefined exceptions:

   Constraint_Error : exception renames Standard.Constraint_Error;
   Program_Error : exception renames Standard.Program_Error;
   Storage_Error : exception renames Standard.Storage_Error;
   Tasking_Error : exception renames Standard.Tasking_Error;

end Ada_Magic_Forward.Standard_Forward;
