<HTML >
<HEAD>
	<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=windows-1252" />
    	<TITLE>A Sample RTF Reader Implementation (Rich Text Format (RTF) Specification, version 1.6)</TITLE>
<META NAME="Description" CONTENT="Create an RTF reader for your own application when used in conjunction with the Microsoft Rich Text Format Specification."/>
<META NAME="Robots" CONTENT=""/>
<META NAME="Keywords" CONTENT=""/>
<META NAME="MS.LOCALE" CONTENT="en-us"/>

<LINK REL="stylesheet" TYPE="text/css" HREF="ie3.css" />
<LINK REL="stylesheet" TYPE="text/css" HREF="/library/shared/comments/css/down.css" />

	<style>
	BODY
	{
		font-family:verdana,arial,helvetica;
		margin:0;
	}
	</style>
	
<SCRIPT LANGUAGE="javascript" SRC="/library/toolbar/toolbar.js"></SCRIPT>

<LINK REL="stylesheet" TYPE="text/css" HREF="/library/shared/eyebrow/css/default.css" />


   <SCRIPT LANGUAGE="JavaScript"><!--
   function BrowserData()
{
		this.userAgent = "Wget/1.8.2";

		this.bot = true;

		this.browser = "Other";

		this.getsNavBar = false;

		this.doesActiveX = false;

		this.doesPersistence = false;

		this.fullVer = NaN;

   }

   var oBD = new BrowserData();

   //--></SCRIPT>

   <SCRIPT LANGUAGE="JavaScript"><!--

   if (document.layers) {
    origWidth  = innerWidth;
  origHeight = innerHeight;
   }

   function resizeFix() { if (innerWidth != origWidth || innerHeight != origHeight) location.reload(); }

   if (document.layers) onresize = resizeFix;

   //--></SCRIPT><BASE TARGET="_top" />

   <SCRIPT LANGUAGE="JavaScript"><!--
   function BrowserData()
{
		this.userAgent = "Wget/1.8.2";

		this.bot = true;

		this.browser = "Other";

		this.getsNavBar = false;

		this.doesActiveX = false;

		this.doesPersistence = false;

		this.fullVer = NaN;

   }

   var oBD = new BrowserData();

   //--></SCRIPT>

   <SCRIPT LANGUAGE="JavaScript"><!--

   if (document.layers) {
    origWidth  = innerWidth;
  origHeight = innerHeight;
   }

   function resizeFix() { if (innerWidth != origWidth || innerHeight != origHeight) location.reload(); }

   if (document.layers) onresize = resizeFix;

   //--></SCRIPT>

<xml id='xmlPageContext'><eyebrow findmenu="false">
	<item label="MSDN Home" url="/default.asp"/>
	<item label="MSDN Library" url="/library/default.asp"/>
</eyebrow></xml>

        <!--VENUS_START-->
        <meta name="MSHTOCTitle" content="A Sample RTF Reader Implementation" />
        <meta name="MSHRLTitle" content="A Sample RTF Reader Implementation" />
        <meta name="MSHKeywordA" content="RTFSpec_46"/>
        <meta name="MSHKeywordA" content="RTFSpec_46"/>
        <meta name="MSHAttr" content="DocSet:kbmsdn"/>
        <meta name="MSHAttr" content="HostCPU:kbx86"/>
        <meta name="MSHAttr" content="HostOS:Windows"/>
        <meta name="MSHAttr" content="HostOSVers:kbWinOS"/>
        <meta name="MSHAttr" content="Locale:kbEnglish"/>
        <meta name="MSHAttr" content="Media:kbText"/>
        <meta name="MSHAttr" content="Product:Word"/>
        <meta name="MSHAttr" content="ProductVers:kbWord"/>
        <meta name="MSHAttr" content="TargetCPU:kbx86"/>
        <meta name="MSHAttr" content="TargetOSVers:kbWinOS"/>
        <meta name="MSHAttr" content="TopicType:kbRef"/>
        <meta name="MSHAttr" content="TargetOS:Windows"/>

        <!---VENUS_END--->

 </HEAD> <BODY TOPMARGIN="0"  LEFTMARGIN="0" MARGINHEIGHT="0" MARGINWIDTH="0" BGCOLOR="#FFFFFF" TEXT="#000000">

       <TABLE BORDER="0" CELLSPACING="0" CELLPADDING="4" HEIGHT="24" WIDTH="100%" BGCOLOR="#FFFFFF">
       <TR>
        <TD CLASS="eyebrow" VALIGN="middle" ALIGN="left" WIDTH="100%">&nbsp;&nbsp;

            <a class="small" target="_top" href="/default.asp">MSDN Home</a><a href=""></a>
        </TD>
       </TR>
       </TABLE>
 <TABLE class='clsContainer' CELLPADDING='15' CELLSPACING='0' float='left' WIDTH='100%' BORDER='0'> <TR> <TD VALIGN='top'>
<!--TOOLBAR_START-->
<!--TOOLBAR_EXEMPT-->
<!--TOOLBAR_END-->
<!-- Begin Content -->

<!--NONSCROLLING BANNER START-->
<div id="nsbanner">

<div id="TitleRow">
<H2 class="dtH1"><A NAME="rtfspec_46"></A>A Sample RTF Reader Implementation</H2>
</div></div>
<!--NONSCROLLING BANNER END-->
<DIV id="nstext" valign="bottom"><DIV id="smpMgrCell" style="width:230px;float:right"></DIV>
<P>The Microsoft Word Processing Conversions group uses a table-driven approach to reading RTF. This approach allows the most flexibility in reading RTF, with the corresponding problem that it's difficult to detect incorrect RTF. An RTF reader that is based on this approach is presented below. This reader works exactly as described in the RTF specification and uses the principles of operation described in the RTF specification. This reader is designed to be simple to understand but is not intended to be very efficient. This RTF reader also implements the three design principles listed in the previous section.</P>

<P>The RTF reader consists of four files:

<UL type="disc">
	<LI>Rtfdecl.h, which contains the prototypes for all the functions in the RTF reader</li>

	<LI>Rtftype.h, which contains the types used in the RTF reader</li>

	<LI>Rtfreadr.c, which contains the main program, the main loop of the RTF reader, and the RTF control parser</li>

	<LI>Rtfactn.c, which contains the dispatch routines for the RTF reader</li>
</UL>

<H2 class="dtH1"><A NAME="rtfspec_47"></A>Rtfdecl.h and Rtfreadr.c</H2>

<P>Rtfdecl.h is straightforward and requires little explanation.</P>

<P>rtfreadr.c is also reasonably straightforward; the function <B>ecRtfParse</B> separates text from RTF controls and handles text, and the function <B>ecParseRtfKeyword</B> parses an RTF control and also collects any parameter that follows the RTF control.</P>

<H2 class="dtH1"><A NAME="rtfspec_48"></A>Rtftype.h</H2>

<P>Rtftype.h begins by declaring a sample set of character, paragraph, section, and document properties. These structures are present to demonstrate how the dispatch routines can modify any particular property and are not actually used to format text.</P>

<P>For example, the following enumeration describes which destination text should be routed to:</P>

<PRE class="code">typedef enum { rdsNorm, rdsSkip } RDS;
</PRE>

<P>Because this is just a sample RTF reader, there are only two destinations; a more complicated reader would add an entry to this enumeration for each destination supported [for example, headers, footnotes, endnotes, comments (annotations), bookmarks, and pictures].</P>

<P>The following enumeration describes the internal state of the RTF parser:</P>

<PRE class="code">typedef enum { risNorm, risBin, risHex } RIS;
</PRE>

<P>This is entirely separate from the state of the dispatch routines and the destination state; other RTF readers may not necessarily have anything similar to this.</P>

<P>The following structure encapsulates the state that must be saved at a group start and restored at a group end:</P>

<PRE class="code">typedef struct save
{
struct save *pNext;
CHP chp;
PAP pap;
SEP sep;
DOP dop;
RDS rds;
RIS ris;
} SAVE;
</PRE>

<P>The following enumeration describes a set of classes for RTF controls:</P>

<PRE class="code">typedef enum {kwdChar, kwdDest, kwdProp, kwdSpec} KWD;
</PRE>

<P>Use <B>kwdChar</B> for controls that represent special characters (such as <B><CODE>\</CODE>-</B>, <B><CODE>\{</CODE></B>, or <B><CODE>\}</CODE></B>).</P>

<P>Use <B>kwdDest</B> for controls that introduce RTF destinations.</P>

<P>Use <B>kwdProp</B> for controls that modify some sort of property.</P>

<P>Use <B>kwdSpec</B> for controls that need to run some specialized code.</P>

<P>The following enumeration defines the number of PROP structures (described below) that will be used. There will typically be an <B>iprop</B> for every field in the character, paragraph, section, and document properties.</P>

<PRE class="code">typedef enum {ipropBold, ipropItalic, ipropUnderline, ipropLeftInd,
ipropRightInd, ipropFirstInd, ipropCols, ipropPgnX, ipropPgnY,
ipropXaPage, ipropYaPage, ipropXaLeft, ipropXaRight,
ipropYaTop, ipropYaBottom, ipropPgnStart, ipropSbk, 
ipropPgnFormat, ipropFacingp, ipropLandscape, ipropJust,
ipropPard, ipropPlain,
ipropMax} IPROP;
</PRE>

<P>The following structure is a very compact way to describe how to locate the address of a particular value in one of the property structures:</P>

<PRE class="code">typedef enum {actnSpec, actnByte, actnWord} ACTN;
typedef enum {propChp, propPap, propSep, propDop} PROPTYPE;

typedef struct propmod
{
ACTN actn;
PROPTYPE prop;
int offset;
} PROP;
</PRE>

<P>The <B>actn</B> field describes the width of the value being described: if the value is a byte, then <B>actn</B> is <B>actnByte;</B> if the value is a word, then <B>actn</B> is <B>actnWord;</B> if the value is neither a byte nor a word, then you can use <B>actnSpec</B> to indicate that some C code needs to be run to set the value. The <B>prop</B> field indicates which property structure is being described; <B>propChp</B> indicates that the value is located within the CHP structure; <B>propPap</B> indicates that the value is located within the PAP structure, and so on. Finally, the offset field contains the offset of the value from the start of the structure. The <B>offsetof() </B>macro is usually used to initialize this field.</P>

<P>The following structure describes how to parse a particular RTF control:</P>

<PRE class="code">typedef enum {ipfnBin, ipfnHex, ipfnSkipDest } IPFN;
typedef enum {idestPict, idestSkip } IDEST;

typedef struct symbol
{
char *szKeyword;
int dflt;
bool fPassDflt;
KWD kwd;
int idx;
} SYM;
</PRE>

<P><B>szKeyword</B> points to the RTF control being described; <B>kwd</B><I> </I>describes the class of the particular RTF control (described above); <B>dflt</B> is the default value for this control, and <B>fPassDflt</B> should be nonzero if the value in <B>dflt</B> should be passed to the dispatch routine. (<B>fPassDflt</B> is only nonzero for control words that normally set a particular value.<B> </B>For example, the various section break controls typically have nonzero <B>fPassDflt</B> controls, but controls that take parameters should not.)</P>

<P><B>Idx</B> is a generalized index; its use depends on the <B>kwd</B> being used for this control.

<UL type="disc">
	<LI>If <B>kwd</B> is <B>kwdChar,</B> then <B>idx</B> is the character that should be output.</li>

	<LI>If <B>kwd</B> is <B>kwdDest,</B> then <B>idx</B> is the <B>idest</B> for the new destination.</li>

	<LI>If <B>kwd</B> is <B>kwdProp,</B> then <B>idx</B> is the <B>iprop</B> for the appropriate property.</li>

	<LI>If <B>kwd</B> is <B>kwdSpec,</B> then <B>idx</B> is an <B>ipfn</B> for the appropriate function.</li>
</UL>

<P>With this structure, it is very simple to dispatch an RTF control word. Once the reader isolates the RTF control word and its (possibly associated) value, the reader then searches an array of SYM structures to find the RTF control word. If the control word is not found, the reader ignores it, unless the previous control was <B><CODE>\</CODE>*</B>, in which case the reader must scan past an entire group.</P>

<P>If the control word is found, the reader then uses the <B>kwd</B> value from the SYM structure to determine what to do. This is, in fact, exactly what the function <B>ecTranslateKeyword</B> in the file RTFACTN.C does.</P>

<H2 class="dtH1"><A NAME="rtfspec_49"></A>Rtfactn.c</H2>

<P>Rtfactn.c contains the tables describing the properties and control words, and the routines to evaluate properties (<B>ecApplyPropChange</B>) and to dispatch control words (<B>ecTranslateKeyword</B>).</P>

<P>The tables are the keys to understanding the RTF dispatch routines. The following are some sample entries from both tables, together with a brief explanation of each entry.</P>

<P><B>The Property Table.</B> This table must have an entry for every <B>iprop.</B>

<UL type="disc">
	<LI>The property below says that the <B><I>ipropBold</I></B> property is a byte parameter bound to <B>chp.fBold</B>.
<PRE class="code">actnByte,&nbsp;&nbsp;&nbsp;propChp,&nbsp;&nbsp;&nbsp;&nbsp;offsetof(CHP, fBold),&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;//&nbsp;ipropBold
</PRE>
</li>

	<LI>This property says that <B><I>ipropRightInd</I></B> is a word parameter bound to <B>pap.xaRight.</B>
<PRE class="code">actnWord,&nbsp;&nbsp;&nbsp;propPap,&nbsp;&nbsp;&nbsp;&nbsp;offsetof(PAP, xaRight),&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;//&nbsp;ipropRightInd
</PRE>
</li>

	<LI>This property says that <B><I>ipropCols</I></B> is a word parameter bound to <B>sep.cCols.</B>
<PRE class="code">actnWord,&nbsp;&nbsp;&nbsp;propSep,&nbsp;&nbsp;&nbsp;&nbsp;offsetof(SEP, cCols),&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;//&nbsp;ipropCols
</PRE>
</li>

	<LI>This property says that ipropPlain is a special parameter. Instead of directly evaluating it, ecApplyPropChange will run some custom C code to apply a property change.
<PRE class="code">actnSpec,&nbsp;&nbsp;&nbsp;propChp,&nbsp;&nbsp;&nbsp;&nbsp;0,&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;// ipropPlain
</PRE>
</li>
</UL>

<P><B>The Control Word Table</B>

<UL type="disc">
	<LI>This structure says that the control <B><CODE>\</CODE>b</B> sets the ipropBold property. Because <B>fPassDflt</B> is <B>False</B>, the reader only uses the default value if the control does not have a parameter. If no parameter is provided, the reader uses a value of 1.
<PRE class="code">"b",&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1,&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;fFalse,&nbsp;&nbsp;&nbsp;&nbsp; kwdProp,&nbsp;&nbsp;&nbsp;&nbsp;ipropBold,
</PRE>
</li>

	<LI>This entry says that the control <B><CODE>\</CODE>sbknone</B> sets the <B>ipropSbk</B> property. Because <B>fPassDflt</B> is <B>True</B>, the reader always uses the default value of <B>sbkNon</B>, even if the control has a parameter.
<PRE class="code">"sbknone",&nbsp;&nbsp;sbkNon, fTrue,&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;kwdProp,&nbsp;&nbsp;&nbsp;&nbsp;ipropSbk,
</PRE>
</li>

	<LI>This entry says that the control <B><CODE>\</CODE>par</B> is equivalent to a 0x0a (linefeed) character.
<PRE class="code">"par",&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0,&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;fFalse,&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;kwdChar,&nbsp;&nbsp;&nbsp;&nbsp;0x0a,
</PRE>
</li>

	<LI>This entry says that the control <B><CODE>\</CODE>tab</B> is equivalent to a 0x09 (tab) character.
<PRE class="code">"tab",&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0,&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;fFalse,&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;kwdChar,&nbsp;&nbsp;&nbsp; 0x09,
</PRE>
</li>

	<LI>This entry says that the control <B><CODE>\</CODE>bin</B> should run some C code. The particular piece of C code can be located by the <B>ipfnBin</B> parameter.
<PRE class="code">"bin",&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0,&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;fFalse,&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;kwdSpec,&nbsp;&nbsp;&nbsp;&nbsp;ipfnBin,
</PRE>
</li>

	<LI>This entry says that the control <B><CODE>\</CODE>fonttbl</B> should change to the destination <B>idestSkip</B>.
<PRE class="code">"fonttbl",&nbsp;&nbsp;0,&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;fFalse,&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;kwdDest,&nbsp;&nbsp;&nbsp;&nbsp;idestSkip,
</PRE>
</li>
</UL>
 <!--closes the topic content div-->
<!--FOOTER_END-->


<!-- End Content -->

 </TD> </TR> </TABLE>
<TABLE WIDTH="100%" HEIGHT="50" ID="idToolbar" CELLPADDING="0" CELLSPACING="0" BORDER="0" BGCOLOR="#003399">
<TR>
<TD BGCOLOR=#003399 HEIGHT="20" VALIGN="middle" NOWRAP ID="idTBLocal" WIDTH="100%">
<FONT FACE="Verdana, Arial" SIZE="2"><B>

		&nbsp;&nbsp;<A STYLE='color:##FFFFFF;text-decoration:none;' HREF='http://register.microsoft.com/contactus30/contactus.asp?domain=msdn' TARGET='_top'><FONT COLOR='#FFFFFF'>Contact Us</FONT></A>

					&nbsp;&nbsp;<FONT COLOR='#FFFFFF'>|</FONT>
				
		&nbsp;&nbsp;<A STYLE='color:##FFFFFF;text-decoration:none;' HREF='mailto:?subject=An article from MSDN&body=Here is an interesting article from MSDN:  msdn.microsoft.com/library/en-us/dnrtfspec/html/rtfspec_46.asp' TARGET='_top'><FONT COLOR='#FFFFFF'>E-Mail this Page</FONT></A>

					&nbsp;&nbsp;<FONT COLOR='#FFFFFF'>|</FONT>
				
		&nbsp;&nbsp;<A STYLE='color:##FFFFFF;text-decoration:none;' HREF='/flash/' TARGET='_top'><FONT COLOR='#FFFFFF'>MSDN Flash Newsletter</FONT></A>


</B></FONT>
</TD>
</TR>
<TR>
<TD BGCOLOR=#003399 HEIGHT="20" VALIGN="middle" NOWRAP ID="idTBLocal" WIDTH="100%">
<FONT FACE="Verdana, Arial" SIZE="2"><B>
&nbsp;&nbsp;<FONT COLOR='#FFFFFF'>&#169; 2003 Microsoft Corporation. All rights reserved.</FONT>&nbsp;&nbsp;
&nbsp;&nbsp;<A STYLE='color:##FFFFFF;text-decoration:none;' HREF=' /isapi/gomscom.asp?target=/info/cpyright.htm' TARGET='_top'><FONT COLOR='#FFFFFF'>Terms of Use</FONT></A>&nbsp;&nbsp;&nbsp;&nbsp;<A STYLE='color:##FFFFFF;text-decoration:none;' HREF='/isapi/gomscom.asp?target=/info/privacy.htm' TARGET='_top'><FONT COLOR='#FFFFFF'>Privacy Statement </FONT></A>&nbsp;&nbsp;&nbsp;&nbsp;<A STYLE='color:##FFFFFF;text-decoration:none;' HREF='/isapi/gomscom.asp?target=/enable/' TARGET='_top'><FONT COLOR='#FFFFFF'>Accessibility </FONT></A>&nbsp;&nbsp;</B></FONT>
</TD>
</TR>
</TABLE>
 </BODY> </HTML>