<HTML >
<HEAD>
	<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=windows-1252" />
    	<TITLE>Header (Rich Text Format (RTF) Specification, version 1.6)</TITLE>
<META NAME="Description" CONTENT="View elements of a header file for an RTF document."/>
<META NAME="Robots" CONTENT=""/>
<META NAME="Keywords" CONTENT=""/>
<META NAME="MS.LOCALE" CONTENT="en-us"/>

<LINK REL="stylesheet" TYPE="text/css" HREF="ie3.css" />
<LINK REL="stylesheet" TYPE="text/css" HREF="/library/shared/comments/css/down.css" />

	<style>
	BODY
	{
		font-family:verdana,arial,helvetica;
		margin:0;
	}
	</style>
	
<SCRIPT LANGUAGE="javascript" SRC="/library/toolbar/toolbar.js"></SCRIPT>

<LINK REL="stylesheet" TYPE="text/css" HREF="/library/shared/eyebrow/css/default.css" />


   <SCRIPT LANGUAGE="JavaScript"><!--
   function BrowserData()
{
		this.userAgent = "Wget/1.8.2";

		this.bot = true;

		this.browser = "Other";

		this.getsNavBar = false;

		this.doesActiveX = false;

		this.doesPersistence = false;

		this.fullVer = NaN;

   }

   var oBD = new BrowserData();

   //--></SCRIPT>

   <SCRIPT LANGUAGE="JavaScript"><!--

   if (document.layers) {
    origWidth  = innerWidth;
  origHeight = innerHeight;
   }

   function resizeFix() { if (innerWidth != origWidth || innerHeight != origHeight) location.reload(); }

   if (document.layers) onresize = resizeFix;

   //--></SCRIPT><BASE TARGET="_top" />

   <SCRIPT LANGUAGE="JavaScript"><!--
   function BrowserData()
{
		this.userAgent = "Wget/1.8.2";

		this.bot = true;

		this.browser = "Other";

		this.getsNavBar = false;

		this.doesActiveX = false;

		this.doesPersistence = false;

		this.fullVer = NaN;

   }

   var oBD = new BrowserData();

   //--></SCRIPT>

   <SCRIPT LANGUAGE="JavaScript"><!--

   if (document.layers) {
    origWidth  = innerWidth;
  origHeight = innerHeight;
   }

   function resizeFix() { if (innerWidth != origWidth || innerHeight != origHeight) location.reload(); }

   if (document.layers) onresize = resizeFix;

   //--></SCRIPT>

<xml id='xmlPageContext'><eyebrow findmenu="false">
	<item label="MSDN Home" url="/default.asp"/>
	<item label="MSDN Library" url="/library/default.asp"/>
</eyebrow></xml>

        <!--VENUS_START-->
        <meta name="MSHTOCTitle" content="Header" />
        <meta name="MSHRLTitle" content="Header" />
        <meta name="MSHKeywordA" content="RTFSpec_6"/>
        <meta name="MSHKeywordA" content="RTFSpec_6"/>
        <meta name="MSHAttr" content="DocSet:kbmsdn"/>
        <meta name="MSHAttr" content="HostCPU:kbx86"/>
        <meta name="MSHAttr" content="HostOS:Windows"/>
        <meta name="MSHAttr" content="HostOSVers:kbWinOS"/>
        <meta name="MSHAttr" content="Locale:kbEnglish"/>
        <meta name="MSHAttr" content="Media:kbText"/>
        <meta name="MSHAttr" content="Product:Word"/>
        <meta name="MSHAttr" content="ProductVers:kbWord"/>
        <meta name="MSHAttr" content="TargetCPU:kbx86"/>
        <meta name="MSHAttr" content="TargetOSVers:kbWinOS"/>
        <meta name="MSHAttr" content="TopicType:kbRef"/>
        <meta name="MSHAttr" content="TargetOS:Windows"/>

        <!---VENUS_END--->

 </HEAD> <BODY TOPMARGIN="0"  LEFTMARGIN="0" MARGINHEIGHT="0" MARGINWIDTH="0" BGCOLOR="#FFFFFF" TEXT="#000000">

       <TABLE BORDER="0" CELLSPACING="0" CELLPADDING="4" HEIGHT="24" WIDTH="100%" BGCOLOR="#FFFFFF">
       <TR>
        <TD CLASS="eyebrow" VALIGN="middle" ALIGN="left" WIDTH="100%">&nbsp;&nbsp;

            <a class="small" target="_top" href="/default.asp">MSDN Home</a><a href=""></a>
        </TD>
       </TR>
       </TABLE>
 <TABLE class='clsContainer' CELLPADDING='15' CELLSPACING='0' float='left' WIDTH='100%' BORDER='0'> <TR> <TD VALIGN='top'>
<!--TOOLBAR_START-->
<!--TOOLBAR_EXEMPT-->
<!--TOOLBAR_END-->
<!-- Begin Content -->

<!--NONSCROLLING BANNER START-->
<div id="nsbanner">

<div id="TitleRow">
<H2 class="dtH1"><A NAME="rtfspec_6"></A>Header</H2>
</div></div>
<!--NONSCROLLING BANNER END-->
<DIV id="nstext" valign="bottom"><DIV id="smpMgrCell" style="width:230px;float:right"></DIV>
<P>The header has the following syntax:</P>

<BLOCKQUOTE class="dtBlock">
&lt;header&gt;<B><I><CODE>\</CODE>rtf</I></B> &lt;charset&gt; <B><I><CODE>\</CODE>deff</I></B>? &lt;fonttbl&gt; &lt;filetbl&gt;? &lt;colortbl&gt;? &lt;stylesheet&gt;? &lt;listtables&gt;? &lt;revtbl&gt;?</BLOCKQUOTE>

<P>Each of the various header tables should appear, if they exist, in the above order. Document properties can occur before and between the header tables. A property must be defined before being referenced. Specifically:

<UL type="disc">
	<LI>The style sheet must occur before any style usage.</li>

	<LI>The font table must precede any reference to a font.</li>

	<LI>The <B><CODE>\</CODE>deff</B> keyword must precede any text without an explicit reference to a font, because it specifies the font to use in such cases.</li>
</UL>

<H2 class="dtH1"><A NAME="rtfspec_7"></A>RTF Version</H2>

<P>An entire RTF file is considered a group and must be enclosed in braces. The \<B>rtf<I>N</I></B> control word must follow the opening brace. The numeric parameter <B><I>N</I></B> identifies the major version of the RTF Specification used. The RTF standard described in this RTF Specification, although titled as version 1.6, continues to correspond syntactically to RTF Specification version 1. Therefore, the numeric parameter <B><I>N</I></B> for the \<B>rtf</B> control word should still be emitted as 1.</P>

<H2 class="dtH1"><A NAME="rtfspec_8"></A>Character Set</H2>

<P>After specifying the RTF version, you must declare the character set used in this document. The control word for the character set must precede any plain text or any table control words. The RTF Specification currently supports the following character sets.</P>
<table class="data">

<TR VALIGN="top">
<TD width=20% class="data"><b class="le">Control<BR>
Word</b></TD>
<TD width=80% class="data"><b class="le">Character set</b></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><B><CODE>\</CODE>ansi</B></TD>
<TD width=80% class="data">ANSI (the default)</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><B><CODE>\</CODE>mac</B></TD>
<TD width=80% class="data">Apple Macintosh</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><B><CODE>\</CODE>pc</B></TD>
<TD width=80% class="data">IBM PC code page 437</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><B><CODE>\</CODE>pca</B></TD>
<TD width=80% class="data">IBM PC code page 850, used by IBM Personal System/2 (not implemented in version 1 of Microsoft Word for OS/2)</TD>
</TR>
</table>

<H2 class="dtH1"><A NAME="rtfspec_9"></A>Unicode RTF</H2>

<P>Word 2000 is a Unicode-enabled application. Text is handled using the 16-bit Unicode character encoding scheme. Expressing this text in RTF requires a new mechanism, because until this release (version 1.6), RTF has only handled 7-bit characters directly and 8-bit characters encoded as hexadecimal. The Unicode mechanism described here can be applied to any RTF destination or body text.</P>
<table class="data">

<TR VALIGN="top">
<TD width=16% class="data"><b class="le">Control<BR>
Word</b></TD>
<TD width=84% class="data"><b class="le">Meaning</b></TD>
</TR>

<TR VALIGN="top">
<TD width=16% class="data"><B><CODE>\</CODE>ansicpg<I>N</I></B></TD>
<TD width=84% class="data">This keyword represents the ANSI code page that is used to perform the Unicode to ANSI conversion when writing RTF text. <B><I>N</I></B> represents the code page in decimal. This is typically set to the default ANSI code page of the run-time environment (for example <B><CODE>\</CODE>ansicpg1252</B> for U.S. Windows). The reader can use the same ANSI code page to convert ANSI text back to Unicode. Possible values include:
<P>437United States IBM</P>

<P>708Arabic (ASMO 708)</P>

<P>709Arabic (ASMO 449+, BCON V4)</P>

<P>710Arabic (transparent Arabic)</P>

<P>711Arabic (Nafitha Enhanced)</P>

<P>720Arabic (transparent ASMO)</P>

<P>819Windows 3.1 (United States and Western Europe)</P>

<P>850IBM multilingual</P>

<P>852Eastern European</P>

<P>860Portuguese</P>

<P>862Hebrew</P>

<P>863French Canadian</P>

<P>864Arabic</P>

<P>865Norwegian</P>

<P>866Soviet Union</P>

<P>874Thai</P>

<P>932Japanese</P>

<P>936Simplified Chinese</P>

<P>949Korean</P>

<P>950Traditional Chinese</P>

<P>1250Windows 3.1 (Eastern European)</P>

<P>1251Windows 3.1 (Cyrillic)</P>

<P>1252Western European</P>

<P>1253Greek</P>

<P>1254Turkish</P>

<P>1255Hebrew</P>

<P>1256Arabic</P>

<P>1257Baltic</P>

<P>1258Vietnamese</P>

<P>1361Johab</P>

<P>This keyword should be emitted in the RTF header section right after the <B><CODE>\</CODE>ansi, \mac, \pc </B>or <B><CODE>\</CODE>pca</B> keyword.</P>
</TD>
</TR>

<TR VALIGN="top">
<TD width=16% class="data"><B><CODE>\</CODE>upr</B></TD>
<TD width=84% class="data">This keyword represents a destination with two embedded destinations, one represented using Unicode and the other using ANSI. This keyword operates in conjunction with the <B><CODE>\</CODE>ud </B>keyword to provide backward compatibility. The general syntax is as follows:
<P>{\upr{keyword ansi_text}{\*\ud{keyword Unicode_text}}}</P>

<P>Notice that this keyword-destination does not use the <B><CODE>\</CODE>* </B>keyword; this forces the old RTF readers to pick up the ANSI representation and discard the Unicode one.</P>
</TD>
</TR>

<TR VALIGN="top">
<TD width=16% class="data"><B><CODE>\</CODE>ud</B></TD>
<TD width=84% class="data">This is a destination that is represented in Unicode. The text is represented using a mixture of ANSI translation and use of <B><CODE>\</CODE>u<I>N </I></B>keywords to represent characters that do not have the exact ANSI equivalent.</TD>
</TR>

<TR VALIGN="top">
<TD width=16% class="data"><B><CODE>\</CODE>u<I>N</I> </B></TD>
<TD width=84% class="data">This keyword represents a single Unicode character that has no equivalent ANSI representation based on the current ANSI code page. <B><I>N</I></B> represents the Unicode character value expressed as a decimal number.
<P>This keyword is followed immediately by equivalent character(s) in ANSI representation. In this way, old readers will ignore the <B><CODE>\</CODE>u<I>N</I></B> keyword and pick up the ANSI representation properly. When this keyword is encountered, the reader should ignore the next <B><I>N</I></B> characters, where <B><I>N</I> </B>corresponds to the last <B><CODE>\</CODE>uc<I>N</I></B> value encountered.</P>

<P>As with all RTF keywords, a keyword-terminating space may be present (before the ANSI characters) that is not counted in the characters to skip. While this is not likely to occur (or recommended), a <B><CODE>\</CODE>bin</B> keyword, its argument, and the binary data that follows are considered one character for skipping purposes. If an RTF scope delimiter character (that is, an opening or closing brace) is encountered while scanning skippable data, the skippable data is considered to be ended before the delimiter. This makes it possible for a reader to perform some rudimentary error recovery. To include an RTF delimiter in skippable data, it must be represented using the appropriate control symbol (that is, escaped with a backslash,) as in plain text. Any RTF control word or symbol is considered a single character for the purposes of counting skippable characters.</P>

<P>An RTF writer, when it encounters a Unicode character with no corresponding ANSI character, should output <B><CODE>\</CODE>u<I>N</I></B> followed by the best ANSI representation it can manage. Also, if the Unicode character translates into an ANSI character stream with count of bytes differing from the current Unicode Character Byte Count, it should emit the <B><CODE>\</CODE>uc<I>N</I></B> keyword prior to the <B><CODE>\</CODE>u<I>N</I> </B>keyword<B> </B>to notify the reader of the change.</P>

<P>RTF control words generally accept signed 16-bit numbers as arguments. For this reason, Unicode values greater than 32767 must be expressed as negative numbers.</P>
</TD>
</TR>

<TR VALIGN="top">
<TD width=16% class="data"><B><CODE>\</CODE>uc<I>N</I></B></TD>
<TD width=84% class="data">This keyword represents the number of bytes corresponding to a given <B><CODE>\</CODE>u<I>N </I></B>Unicode character. This keyword may be used at any time, and values are scoped like character properties. That is, a <B><CODE>\</CODE>uc<I>N </I></B>keyword applies only to text following the keyword, and within the same (or deeper) nested braces. On exiting the group, the previous <B><CODE>\</CODE>uc</B> value is restored. The reader must keep a stack of counts seen and use the most recent one to skip the appropriate number of characters when it encounters a <B><CODE>\</CODE>u<I>N </I></B>keyword. When leaving an RTF group that specified a <B><CODE>\</CODE>uc</B> value, the reader must revert to the previous value. A default of 1 should be assumed, if no <B><CODE>\</CODE>uc</B> keyword has been seen in the current or outer scopes.
<P>A common practice is to emit no ANSI representation for Unicode characters within a Unicode destination context (that is, inside a <B><CODE>\</CODE>ud</B> destination.). Typically, the destination will contain a <B><CODE>\</CODE>uc0</B> control sequence. There is no need to reset the count on leaving the <B><CODE>\</CODE>ud </B>destination as the scoping rules will ensure the previous value is restored.</P>
</TD>
</TR>
</table>

<H3 class="dtH1">Document Text</H3>

<P>Document text should be emitted as ANSI characters. If there are Unicode characters that do not have corresponding ANSI characters, they should be output using the <B><CODE>\</CODE>uc<I>N</I></B> and <B><CODE>\</CODE>u<I>N</I></B> keywords.</P>

<P>For example, the text <B>Lab</B><B>&Gamma;</B><B>Value</B> (Unicode characters 0x004c, 0x0061, 0x0062, 0x0393, 0x0056, 0x0061, 0x006c, 0x0075, 0x0065) should be represented as follows (assuming a previous \<B>ucl)</B>:</P>

<PRE class="code">Lab\u915Gvalue
</PRE>

<H3 class="dtH1">Destination Text</H3>

<P>Destination text is defined as any text represented in an RTF destination. A good example is the bookmark name in the <B><CODE>\</CODE>bkmkstart</B> destination.</P>

<P>Any destination containing Unicode characters should be emitted as two destinations within a <B><CODE>\</CODE>upr</B> destination to ensure that old readers can read it properly and that no Unicode character encoding is lost when read with a new reader.</P>

<P>For example, a bookmark name <B>Lab</B><B>&Gamma;</B><B>Value</B> (Unicode characters 0x004c, 0x0061, 0x0062, 0x0393, 0x0056, 0x0061, 0x006c, 0x0075, 0x0065) should be represented as follows:</P>

<PRE class="code">{\upr{\*\bkmkstart LabGValue}{\*\ud{\*\bkmkstart Lab\u915 Value}}}
</PRE>

<P>The first sub-destination contains only ANSI characters and is the representation that old readers will see. The second sub-destination is a <B><CODE>\</CODE>*\ud </B>destination that contains a second copy of the <B><CODE>\</CODE>bkmkstart</B> destination. This copy can contain Unicode characters and is the representation that Unicode-aware readers must pay attention to, ignoring the ANSI-only version.</P>

<H2 class="dtH1"><A NAME="rtfspec_10"></A>Font Table</H2>

<P>The \<B>fonttbl</B> control word introduces the font table group. Unique <B><CODE>\</CODE>f<I>N</I></B> control words define each font available in the document, and are used to reference that font throughout the document. This group has the syntax listed in the following table.</P>
<table class="data">

<TR VALIGN="top">
<TD width=20% class="data">&lt;fonttbl&gt;</TD>
<TD width=80% class="data">'{' <B><CODE>\</CODE>fonttbl </B>(&lt;fontinfo&gt; | ('{' &lt;fontinfo&gt; '}'))+ '}'</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;fontinfo&gt;</TD>
<TD width=80% class="data">&lt;fontnum&gt; &lt;fontfamily&gt; &lt;fcharset&gt;? &lt;fprq&gt;? &lt;panose&gt;? &lt;nontaggedname&gt;? &lt;fontemb&gt;? &lt;codepage&gt;? &lt;fontname&gt; &lt;fontaltname&gt;? ';' </TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;fontnum&gt;</TD>
<TD width=80% class="data"><B><I><CODE>\</CODE>f</I></B></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;fontfamily&gt;</TD>
<TD width=80% class="data"><B><CODE>\</CODE>fnil</B> | <B><CODE>\</CODE>froman</B> | <B><CODE>\</CODE>fswiss</B> | <B><CODE>\</CODE>fmodern</B> | <B><CODE>\</CODE>fscript</B> | <B><CODE>\</CODE>fdecor</B> | <B><CODE>\</CODE>ftech</B> | <B><CODE>\</CODE>fbidi</B></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;fcharset&gt;</TD>
<TD width=80% class="data"><B><CODE>\</CODE><I>fcharset</I></B></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;fprq&gt;</TD>
<TD width=80% class="data"><B><CODE>\</CODE><I>fprq</I></B></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;panose&gt;</TD>
<TD width=80% class="data">&lt;data&gt;</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;nontaggedname&gt;</TD>
<TD width=80% class="data">\*\<B>fname</B></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;fontname&gt;</TD>
<TD width=80% class="data">#PCDATA</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;fontaltname&gt;</TD>
<TD width=80% class="data">'{<B><CODE>\</CODE>*</B>'<B> \falt </B>#PCDATA '}'</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;fontemb&gt;</TD>
<TD width=80% class="data">'{\*' <B><CODE>\</CODE>fontemb</B> &lt;fonttype&gt; &lt;fontfname&gt;? &lt;data&gt;? '}'</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;fonttype&gt;</TD>
<TD width=80% class="data"><B><CODE>\</CODE>ftnil</B> | <B><CODE>\</CODE>fttruetype</B></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;fontfname&gt;</TD>
<TD width=80% class="data">'{\*' <B><CODE>\</CODE>fontfile</B> &lt;codepage&gt;? #PCDATA '}'</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;codepage&gt;</TD>
<TD width=80% class="data">\<B><I>cpg</I></B></TD>
</TR>
</table>

<BLOCKQUOTE class="dtBlock">
<b class="le">Note</b><CODE>&nbsp;&nbsp;&nbsp;</CODE>For &lt;fontemb&gt;, either &lt;fontfname&gt; or &lt;data&gt; must be present, although both may be present.</BLOCKQUOTE>

<P>All fonts available to the RTF writer can be included in the font table, even if the document doesn't use all the fonts.</P>

<P>RTF also supports font families, so that applications can attempt to intelligently choose fonts if the exact font is not present on the reading system. RTF uses the following control words to describe the various font families.</P>
<table class="data">

<TR VALIGN="top">
<TD width=20% class="data"><b class="le">Control<BR>
Word</b></TD>
<TD width=51% class="data"><b class="le">Font Family</b></TD>
<TD width=29% class="data"><b class="le">Examples</b></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><B><CODE>\</CODE>fnil</B></TD>
<TD width=51% class="data">Unknown or default fonts (the default)</TD>
<TD width=29% class="data">  </TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><B><CODE>\</CODE>froman</B></TD>
<TD width=51% class="data">Roman, proportionally spaced serif fonts</TD>
<TD width=29% class="data">Times New Roman, Palatino</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><B><CODE>\</CODE>fswiss</B></TD>
<TD width=51% class="data">Swiss, proportionally spaced sans serif fonts</TD>
<TD width=29% class="data">Arial</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><B><CODE>\</CODE>fmodern</B></TD>
<TD width=51% class="data">Fixed-pitch serif and sans serif fonts</TD>
<TD width=29% class="data">Courier New, Pica</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><B><CODE>\</CODE>fscript</B></TD>
<TD width=51% class="data">Script fonts</TD>
<TD width=29% class="data">Cursive</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><B><CODE>\</CODE>fdecor</B></TD>
<TD width=51% class="data">Decorative fonts</TD>
<TD width=29% class="data">Old English, ITC Zapf Chancery</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><B><CODE>\</CODE>ftech</B></TD>
<TD width=51% class="data">Technical, symbol, and mathematical fonts</TD>
<TD width=29% class="data">Symbol</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><B><CODE>\</CODE>fbidi</B></TD>
<TD width=51% class="data">Arabic, Hebrew, or other bidirectional font</TD>
<TD width=29% class="data">Miriam</TD>
</TR>
</table>

<P>If an RTF file uses a default font, the default font number is specified with the \<B>deff<I>N</I></B> control word, which must precede the font-table group. The RTF writer supplies the default font number used in the creation of the document as the numeric argument <B><I>N</I></B>. The RTF reader then translates this number through the font table into the most similar font available on the reader's system.</P>

<P>The following control words specify the character set, alternative font name, pitch of a font in the font table, and non-tagged font name.</P>
<table class="data">

<TR VALIGN="top">
<TD width=18% class="data"><b class="le">Control<BR>
Word</b></TD>
<TD width=82% class="data"><b class="le">Definition</b></TD>
</TR>

<TR VALIGN="top">
<TD width=18% class="data"><B><CODE>\</CODE>fcharsetN </B></TD>
<TD width=82% class="data">Specifies the character set of a font in the font table. Values for <I>N</I> are defined by Windows header files:
<P>0ANSI</P>

<P>1Default</P>

<P>2Symbol</P>

<P>3Invalid</P>

<P>77Mac</P>

<P>128Shift Jis</P>

<P>129Hangul</P>

<P>130Johab</P>

<P>134GB2312</P>

<P>136Big5</P>

<P>161Greek</P>

<P>162Turkish</P>

<P>163Vietnamese</P>

<P>177Hebrew</P>

<P>178Arabic</P>

<P>179Arabic Traditional</P>

<P>180Arabic user</P>

<P>181Hebrew user</P>

<P>186Baltic</P>

<P>204Russian</P>

<P>222Thai</P>

<P>238Eastern European</P>

<P>254PC 437</P>

<P>255OEM</P>
</TD>
</TR>

<TR VALIGN="top">
<TD width=18% class="data"><B><CODE>\</CODE>falt</B></TD>
<TD width=82% class="data">Indicates alternate font name to use if the specified font in the font table is not available. '{\*' \falt &lt;Alternate Font Name&gt;'}' </TD>
</TR>

<TR VALIGN="top">
<TD width=18% class="data"><B><CODE>\</CODE>fprqN </B></TD>
<TD width=82% class="data">Specifies the pitch of a font in the font table.</TD>
</TR>

<TR VALIGN="top">
<TD width=18% class="data"><B><CODE>\</CODE>*\panose</B></TD>
<TD width=82% class="data">Destination keyword. This destination contains a 10-byte Panose 1 number. Each byte represents a single font property as described by the Panose 1 standard specification.</TD>
</TR>

<TR VALIGN="top">
<TD width=18% class="data"><B><CODE>\</CODE>*\fname</B></TD>
<TD width=82% class="data">This is an optional control word in the font table to define the non-tagged font name. This is the actual name of the font without the tag, used to show which character set is being used. For example, Arial is a non-tagged font name, and Arial (Cyrillic) is a tagged font name. This control word is used by WordPad. Word ignores this control word (and never creates it).</TD>
</TR>

<TR VALIGN="top">
<TD width=18% class="data"><B><CODE>\</CODE>fbias<I>N</I></B></TD>
<TD width=82% class="data">Used to arbitrate between two fonts when a particular character can exist in either non-Far East or Far East font. Word 97-2000 emits the \fbiasN keyword only in the context of bullets or list information (that is, a \listlevel destination). The default value of 0 for N indicates a non-Far East font. A value of 1 indicates a Far East font. Additional values may be defined in future releases.</TD>
</TR>
</table>

<P>If <B><CODE>\</CODE>fprq</B> is specified, the <B><I>N</I></B> argument can be one of the following values.</P>
<table class="data">

<TR VALIGN="top">
<TD width=20% class="data"><b class="le">Pitch</b></TD>
<TD width=80% class="data"><b class="le">Value</b></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">Default pitch</TD>
<TD width=80% class="data">0</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">Fixed pitch</TD>
<TD width=80% class="data">1</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">Variable pitch</TD>
<TD width=80% class="data">2</TD>
</TR>
</table>

<H3 class="dtH1">Font Embedding</H3>

<P>RTF supports embedded fonts with the \<B>fontemb</B> group located inside a font definition. An embedded font can be specified by a file name, or the actual font data may be located inside the group. If a file name is specified, it is contained in the \<B>fontfile</B> group. The \<B>cpg</B> control word can be used to specify the character set for the file name.</P>

<P>RTF supports TrueType&#174; and other embedded fonts. The type of the embedded font is described by the following control words.</P>
<table class="data">

<TR VALIGN="top">
<TD width=20% class="data"><b class="le">Control<BR>
Word</b></TD>
<TD width=80% class="data"><b class="le">Embedded font type</b></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><CODE>\</CODE>ftnil</TD>
<TD width=80% class="data">Unknown or default font type (the default)</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><CODE>\</CODE>fttruetype</TD>
<TD width=80% class="data">TrueType font</TD>
</TR>
</table>

<H3 class="dtH1"><A NAME="rtfspec_codepgsupp"></A>Code Page Support</H3>

<P>A font may have a different character set from the character set of the document. For example, the Symbol font has the same characters in the same positions both on the Macintosh and in Windows. RTF describes this with the \<B>cpg</B> control word, which names the character set used by the font. In addition, file names (used in field instructions and in embedded fonts) may not necessarily be the same as the character set of the document; the \<B>cpg</B> control word can change the character set for these file names as well. However, all RTF documents must still declare a character set (that is, <B><CODE>\</CODE>ansi, \mac, \pc,</B> or <B><CODE>\</CODE>pca</B>) to maintain backward compatibility with earlier RTF readers.</P>

<P>The table below describes valid values for \<B>cpg</B>.</P>
<table class="data">

<TR VALIGN="top">
<TD width=21% class="data"><b class="le">Value</b></TD>
<TD width=79% class="data"><b class="le">Description</b></TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">437</TD>
<TD width=79% class="data">United States IBM</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">708</TD>
<TD width=79% class="data">Arabic (ASMO 708)</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">709</TD>
<TD width=79% class="data">Arabic (ASMO 449+, BCON V4)</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">710</TD>
<TD width=79% class="data">Arabic (transparent Arabic)</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">711</TD>
<TD width=79% class="data">Arabic (Nafitha Enhanced)</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">720</TD>
<TD width=79% class="data">Arabic (transparent ASMO)</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">819</TD>
<TD width=79% class="data">Windows 3.1 (United States and Western Europe)</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">850</TD>
<TD width=79% class="data">IBM multilingual</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">852</TD>
<TD width=79% class="data">Eastern European</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">860</TD>
<TD width=79% class="data">Portuguese</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">862</TD>
<TD width=79% class="data">Hebrew</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">863</TD>
<TD width=79% class="data">French Canadian</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">864</TD>
<TD width=79% class="data">Arabic</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">865</TD>
<TD width=79% class="data">Norwegian</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">866</TD>
<TD width=79% class="data">Soviet Union</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">874</TD>
<TD width=79% class="data">Thai</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">932</TD>
<TD width=79% class="data">Japanese</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">936</TD>
<TD width=79% class="data">Simplified Chinese</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">949</TD>
<TD width=79% class="data">Korean</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">950</TD>
<TD width=79% class="data">Traditional Chinese</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">1250</TD>
<TD width=79% class="data">Windows 3.1 (Eastern European)</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">1251</TD>
<TD width=79% class="data">Windows 3.1 (Cyrillic)</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">1252</TD>
<TD width=79% class="data">Western European</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">1253</TD>
<TD width=79% class="data">Greek</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">1254</TD>
<TD width=79% class="data">Turkish</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">1255</TD>
<TD width=79% class="data">Hebrew</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">1256</TD>
<TD width=79% class="data">Arabic</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">1257</TD>
<TD width=79% class="data">Baltic</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">1258</TD>
<TD width=79% class="data">Vietnamese</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">1361</TD>
<TD width=79% class="data">Johab</TD>
</TR>
</table>

<H2 class="dtH1"><A NAME="rtfspec_11"></A>File Table</H2>

<P>The <B><CODE>\</CODE>filetbl</B> control word introduces the file table destination. The only time a file table is created in RTF is when the document contains subdocuments. This group defines the files referenced in the document and has the following syntax:</P>
<table class="data">

<TR VALIGN="top">
<TD width=20% class="data">&lt;filetbl&gt; </TD>
<TD width=80% class="data">'{\*' <B><CODE>\</CODE>filetbl </B>('{' &lt;fileinfo&gt; '}')+ '}'</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;fileinfo&gt;</TD>
<TD width=80% class="data">\<B>file</B> &lt;filenum&gt;&lt;relpath&gt;?&lt;osnum&gt;? &lt;filesource&gt;+ &lt;file name&gt;</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;filenum&gt;</TD>
<TD width=80% class="data"><B><I><CODE>\</CODE>fid </I></B></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;relpath&gt;</TD>
<TD width=80% class="data"><B><CODE>\</CODE><I>frelative</I></B> </TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;osnum&gt;</TD>
<TD width=80% class="data">\<B><I>fosnum</I></B></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;filesource&gt;</TD>
<TD width=80% class="data"><B><CODE>\</CODE>fvalidmac</B> | <B><CODE>\</CODE>fvaliddos</B> | <B><CODE>\</CODE>fvalidntfs</B> | <B><CODE>\</CODE>fvalidhpfs</B> | <B><CODE>\</CODE>fnetwork</B></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;file name&gt;</TD>
<TD width=80% class="data">#PCDATA</TD>
</TR>
</table>

<BLOCKQUOTE class="dtBlock">
<b class="le">Note</b><CODE>&nbsp;&nbsp;&nbsp;</CODE>The file name can be any valid alphanumeric string for the named file system, indicating the complete path and file name.</BLOCKQUOTE>
<table class="data">

<TR VALIGN="top">
<TD width=20% class="data"><b class="le">Control<BR>
Word</b></TD>
<TD width=80% class="data"><b class="le">Definition</b></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><B><CODE>\</CODE>filetbl</B></TD>
<TD width=80% class="data">A list of documents referenced by the current document. The file table has a structure analogous to the style or font table. This is a destination control word output as part of the document header. </TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><B><CODE>\</CODE>file</B></TD>
<TD width=80% class="data">Marks the beginning of a file group that lists relevant information about the referenced file. This is a destination control word.</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><B><CODE>\</CODE>fid<I>N</I></B></TD>
<TD width=80% class="data">File ID number. Files are referenced later in the document using this number.</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><B><CODE>\</CODE>frelative<I>N</I></B></TD>
<TD width=80% class="data">The character position within the path (starting at 0) where the referenced file's path starts to be relative to the path of the owning document. For example, if a document is saved to the path C:\Private\Resume\File1.doc and its file table contains the path C:\Private\Resume\Edu\File2.doc, then that entry in the file table will be \frelative18, to point at the character "e" in "edu". This allows preservation of relative paths.</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><B><CODE>\</CODE>fosnum<I>N</I></B></TD>
<TD width=80% class="data">Currently only filled in for paths from the Macintosh file system. It is an operating-system-specific number for identifying the file, which may be used to speed up access to the file, or find it if the file has been moved to another folder or disk. The Macintosh operating system name for this number is the "file id." Additional meanings of the \fosnumN control word may be defined for other file systems in the future.</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><B><CODE>\</CODE>fvalidmac</B></TD>
<TD width=80% class="data">Macintosh file system.</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><B><CODE>\</CODE>fvaliddos</B></TD>
<TD width=80% class="data">MS-DOS file system.</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><B><CODE>\</CODE>fvalidntfs</B></TD>
<TD width=80% class="data">NTFS file system.</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><B><CODE>\</CODE>fvalidhpfs</B></TD>
<TD width=80% class="data">HPFS file system.</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><B><CODE>\</CODE>fnetwork</B></TD>
<TD width=80% class="data">Network file system. This control word may be used in conjunction with any of the previous file source control words.</TD>
</TR>
</table>

<H2 class="dtH1"><A NAME="rtfspec_12"></A>Color Table</H2>

<P>The \<B>colortbl</B> control word introduces the color table group, which defines screen colors, character colors, and other color information. This group has the following syntax:</P>
<table class="data">

<TR VALIGN="top">
<TD width=21% class="data">&lt;colortbl&gt;</TD>
<TD width=79% class="data">'{' <B><CODE>\</CODE>colortbl</B> &lt;colordef&gt;+ '}'</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data">&lt;colordef&gt;</TD>
<TD width=79% class="data"><B><I><CODE>\</CODE>red</I></B> ? &amp; <B><I><CODE>\</CODE>green</I></B> ? &amp;<B><I> \blue</I></B> ? ';'</TD>
</TR>
</table>

<P>The following are valid control words for this group:</P>
<table class="data">

<TR VALIGN="top">
<TD width=21% class="data"><b class="le">Control<BR>
Word</b></TD>
<TD width=79% class="data"><b class="le">Meaning</b></TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data"><B><CODE>\</CODE>red<I>N</I></B></TD>
<TD width=79% class="data">Red index</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data"><B><CODE>\</CODE>green<I>N</I></B></TD>
<TD width=79% class="data">Green index</TD>
</TR>

<TR VALIGN="top">
<TD width=21% class="data"><B><CODE>\</CODE>blue<I>N</I></B></TD>
<TD width=79% class="data">Blue index</TD>
</TR>
</table>

<P>Each definition must be delimited by a semicolon, even if the definition is omitted. If a color definition is omitted, the RTF reader uses its default color. The example below defines the default color table used by Word. The first color is omitted, as shown by the semicolon following the<B> \colortbl </B>control word. The missing definition indicates that color 0 is the ''auto'' color.</P>

<PRE class="code">{\colortbl;\red0\green0\blue0;\red0\green0\blue255;\red0\green255\blue255;
\red0\green255\blue0;
\red255\green0\blue255;\red255\green0\blue0;\red255\green255\blue0;
\red255\green255\blue255;\red0\green0\blue128;\red0\green128\blue128;
\red0\green128\blue0;\red128\green0\blue128;\red128\green0\blue0;
\red128\green128\blue0;\red128\green128\blue128;\red192\green192\blue192;}
</PRE>

<P>The foreground and background colors use indexes into the color table to define a color. For more information on color setup, see your Windows documentation.</P>

<P>The following example defines a block of text in color (where supported). Note that the <B>cf</B>/<B>cb</B> index is the index of an entry in the color table, which represents a red/green/blue color combination.</P>

<PRE class="code">{\f1\cb1\cf2 This is colored text. The background is color
1 and the foreground is color 2.}
</PRE>

<P>If the file is translated for software that does not display color, the reader ignores the color table group.</P>

<H2 class="dtH1"><A NAME="rtfspec_13"></A>Style Sheet</H2>

<P>The \<B>stylesheet</B> control word introduces the style sheet group, which contains definitions and descriptions of the various styles used in the document. All styles in the document's style sheet can be included, even if not all the styles are used. In RTF, a style is a form of shorthand used to specify a set of character, paragraph, or section formatting.</P>

<P>The style-sheet group has the following syntax:</P>
<table class="data">

<TR VALIGN="top">
<TD width=20% class="data">&lt;stylesheet&gt; </TD>
<TD width=80% class="data">'{' <B><CODE>\</CODE>stylesheet </B>&lt;style&gt;+ '}'</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;style&gt;</TD>
<TD width=80% class="data">'{' &lt;styledef&gt;?&lt;keycode&gt;? &lt;formatting&gt; &lt;additive&gt;? &lt;based&gt;? &lt;next&gt;? &lt;autoupd&gt;? &lt;hidden&gt;? &lt;personal&gt;? &lt;compose&gt;? &lt;reply&gt;? &lt;stylename&gt;? ';' '}'</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;styledef&gt;</TD>
<TD width=80% class="data"><B><I><CODE>\</CODE>s</I></B>  |<B><I><CODE>\</CODE></I></B>*<B><I><CODE>\</CODE>cs</I></B>  | <B><I><CODE>\</CODE>ds</I></B></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;keycode&gt;</TD>
<TD width=80% class="data">'{'<B> \keycode</B> &lt;keys&gt; '}'</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;keys&gt;</TD>
<TD width=80% class="data">( <B><CODE>\</CODE>shift</B>? &amp; <B><CODE>\</CODE>ctrl</B>? &amp; <B><CODE>\</CODE>alt</B>?) &lt;key&gt;</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;key&gt;</TD>
<TD width=80% class="data"><B><I><CODE>\</CODE>fn</I></B> | #PCDATA</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;additive&gt;</TD>
<TD width=80% class="data"><B><CODE>\</CODE>additive</B></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;based&gt;</TD>
<TD width=80% class="data"><B><CODE>\</CODE><I>sbasedon</I></B></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;next&gt;</TD>
<TD width=80% class="data"><B><CODE>\</CODE><I>snext</I></B></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;autoupd&gt;</TD>
<TD width=80% class="data">\<B><I>sautoupd</I></B></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;hidden&gt;</TD>
<TD width=80% class="data">\<B><I>shidden</I></B></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;personal&gt;</TD>
<TD width=80% class="data"><B><CODE>\</CODE>spersonal</B></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;compose&gt;</TD>
<TD width=80% class="data"><B><CODE>\</CODE>scompose</B></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;reply&gt;</TD>
<TD width=80% class="data"><B><CODE>\</CODE>sreply</B></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;formatting&gt;</TD>
<TD width=80% class="data">(&lt;brdrdef&gt; | &lt;parfmt&gt; | &lt;apoctl&gt; | &lt;tabdef&gt; | &lt;shading&gt; | &lt;chrfmt&gt;)+</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">&lt;stylename&gt;</TD>
<TD width=80% class="data">#PCDATA</TD>
</TR>
</table>

<P>For &lt;style&gt;, both &lt;styledef&gt; and &lt;stylename&gt; are optional; the default is paragraph style 0. Note for &lt;stylename&gt; that Microsoft Word for the Macintosh interprets commas in #PCDATA as separating style synonyms. Also, for &lt;key&gt;, the data must be exactly one character.</P>
<table class="data">

<TR VALIGN="top">
<TD width=19% class="data"><b class="le">Control<BR>
Word</b></TD>
<TD width=81% class="data"><b class="le">Meaning</b></TD>
</TR>

<TR VALIGN="top">
<TD width=19% class="data"><B><CODE>\</CODE>*\cs<I>N</I></B></TD>
<TD width=81% class="data">Designates character style. Like \s, \cs is not a destination control word. However, it is important to treat it like one inside the style sheet; that is, \cs must be prefixed with \* and must appear as the first item inside a group. Doing so ensures that readers that do not understand character styles will skip the character style information correctly. When used in body text to indicate that a character style has been applied, do not include the \* prefix.</TD>
</TR>

<TR VALIGN="top">
<TD width=19% class="data"><B><CODE>\</CODE>s<I>N</I></B></TD>
<TD width=81% class="data">Designates paragraph style.</TD>
</TR>

<TR VALIGN="top">
<TD width=19% class="data"><B><CODE>\</CODE>ds<I>N</I></B></TD>
<TD width=81% class="data">Designates section style.</TD>
</TR>

<TR VALIGN="top">
<TD width=19% class="data"><B><CODE>\</CODE>additive</B></TD>
<TD width=81% class="data">Used in a character style definition ('{\*'\cs...'}'). Indicates that character style attributes are to be added to the current paragraph style attributes, rather than setting the paragraph attributes to only those defined in the character style definition.</TD>
</TR>

<TR VALIGN="top">
<TD width=19% class="data"><B><CODE>\</CODE>sbasedon<I>N</I></B></TD>
<TD width=81% class="data">Defines the number of the style on which the current style is based (the default is 222&#0151;no style).</TD>
</TR>

<TR VALIGN="top">
<TD width=19% class="data"><B><CODE>\</CODE>snext<I>N</I></B></TD>
<TD width=81% class="data">Defines the next style associated with the current style; if omitted, the next style is the current style.</TD>
</TR>

<TR VALIGN="top">
<TD width=19% class="data"><B><CODE>\</CODE>sautoupd</B></TD>
<TD width=81% class="data">Automatically update styles.</TD>
</TR>

<TR VALIGN="top">
<TD width=19% class="data"><B><CODE>\</CODE>shidden</B></TD>
<TD width=81% class="data">Style does not appear in the Styles drop-down list in the <B>Style</B> dialog box (on the <B>Format</B> menu, click Styles).
<BLOCKQUOTE class="dtBlock">
<b class="le">Note</b><CODE>&nbsp;&nbsp;&nbsp;</CODE>The hidden style property can only be accessed using Microsoft Visual Basic&#174; for Applications.</BLOCKQUOTE>
</TD>
</TR>

<TR VALIGN="top">
<TD width=19% class="data"><B><CODE>\</CODE>spersonal</B></TD>
<TD width=81% class="data">Style is a personal e-mail style</TD>
</TR>

<TR VALIGN="top">
<TD width=19% class="data"><B><CODE>\</CODE>scompose</B></TD>
<TD width=81% class="data">Style is the e-mail compose style</TD>
</TR>

<TR VALIGN="top">
<TD width=19% class="data"><B><CODE>\</CODE>sreply</B></TD>
<TD width=81% class="data">Style is the e-mail reply style</TD>
</TR>

<TR VALIGN="top">
<TD width=19% class="data"><B><CODE>\</CODE>keycode</B></TD>
<TD width=81% class="data">This group is specified within the description of a style in the style sheet in the RTF header. The syntax for this group is '{\*'\keycode &lt;keys&gt;<I>'</I><CODE>}</CODE>' where <I>&lt;keys&gt;</I> are the characters used in the key code. For example, a style, Normal, may be defined {\s0 {\*\keycode \shift\ctrl n}Normal;} within the RTF style sheet. See the Special Character control words for the characters outside the alphanumeric range that may be used.</TD>
</TR>

<TR VALIGN="top">
<TD width=19% class="data"><B><CODE>\</CODE>alt</B></TD>
<TD width=81% class="data">The <SMALL>ALT</SMALL> modifier key. Used to describe shortcut-key codes for styles.</TD>
</TR>

<TR VALIGN="top">
<TD width=19% class="data"><B><CODE>\</CODE>shift</B></TD>
<TD width=81% class="data">The <SMALL>SHIFT</SMALL> modifier key. Used to describe shortcut-key codes for styles.</TD>
</TR>

<TR VALIGN="top">
<TD width=19% class="data"><B><CODE>\</CODE>ctrl</B></TD>
<TD width=81% class="data">The <SMALL>CTRL </SMALL>modifier key. Used to describe shortcut-key codes for styles.</TD>
</TR>

<TR VALIGN="top">
<TD width=19% class="data"><B><CODE>\</CODE>fn<I>N</I></B></TD>
<TD width=81% class="data">Specifies a function key where <I>N</I> is the function key number. Used to describe shortcut-key codes for styles.</TD>
</TR>
</table>

<P>The following is an example of an RTF style sheet:</P>

<PRE class="code">{\stylesheet{\ql \li0\ri0\widctlpar\aspalpha\aspnum\faauto\adjustright\rin0\lin0\itap0 
\fs24\lang1033\langfe1033\cgrid\langnp1033\langfenp1033 \snext0 Normal;}
{\*\cs10 \additive Default Paragraph Font;}{\*\cs15 \additive \b\ul\cf6 
\sbasedon10 UNDERLINE;}{\s16\qc \li0\ri0\widctlpar\aspalpha\aspnum\faauto
\adjustright\rin0\lin0\itap0 \b\fs24\cf2\lang1033\langfe1033\cgrid\
langnp1033\langfenp1033 \sbasedon0 \snext16 \sautoupd CENTER;}}
</PRE>

<P>and RTF paragraphs to which the styles are applied:</P>

<PRE class="code">\pard\plain \ql \li0\ri0\widctlpar\aspalpha\aspnum\faauto\outlinelevel0\
adjustright\rin0\lin0\itap0 \fs24
\lang1033\langfe1033\cgrid\langnp1033\langfenp1033 
{This is the Normal Style
\par }\pard \ql \li0\ri0\widctlpar\aspalpha\aspnum\faauto
\adjustright\rin0\lin0\itap0 {\par }\pard\plain \s16\qc 
\li0\ri0\widctlpar\aspalpha\aspnum\faauto\outlinelevel0
\adjustright\rin0\lin0\itap0 \b\fs24\cf2\lang1033\langfe1033\cgrid
\langnp1033\langfenp1033 
{This is a centered paragraph with blue, bold font.&nbsp;&nbsp;I call the style CENTER.\par }
\pard\plain \ql \li0\ri0\widctlpar\aspalpha\aspnum\faauto\adjustright
\rin0\lin0\itap0 \fs24\lang1033\langfe1033\cgrid\langnp1033\langfenp1033 
{\par The word \'93}{\cs15\b\ul\cf6 style}
{\'94 is red and underlined.&nbsp;&nbsp;I used a style I called UNDERLINE.\par }
</PRE>

<P>Some of the control words in this example are discussed in later sections. In the example, note that the properties of the style were emitted following the application of the style. This was done for two reasons: (1) to allow RTF readers that don't support styles to still retain all formatting; and, (2) to allow the additive model for styles, where additional property changes are "added" on top of the defined style. Some RTF readers may not "apply" a style upon only encountering the style number without the accompanying formatting information because of this.</P>

<H2 class="dtH1"><A NAME="rtfspec_14"></A>List Table</H2>

<P>Word 97 and 2000 store bullets and numbering information very differently from earlier versions of Word. In Word 6.0, for example, number formatting data is stored individually with each paragraph. From Word 97 onwards, however, all the formatting information is stored in a pair of document-wide list tables that act as a style sheet, and each individual paragraph stores only an index to one of the tables, like a style index.</P>

<P>There are two list tables in Word: the List table (destination <B><CODE>\</CODE>listtable</B>), and the List Override table (destination <B><CODE>\</CODE>listoverridetable)</B>.</P>

<P>The first table Word stores is the List table. A List table is a list of lists (destination <B><CODE>\</CODE>list</B>). Each list contains a number of list properties that pertain to the entire list, and a list of levels (destination \<B>listlevel)</B>, each of which contains properties that pertain only to that level.</P>

<P>The syntax for the list table is the following:</P>
<table class="data">

<TR VALIGN="top">
<TD width=22% class="data">&lt;listtable&gt;</TD>
<TD width=78% class="data">'{' \*\<B>listtable</B> &lt;list&gt;+ '}'</TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data">&lt;list&gt;</TD>
<TD width=78% class="data"><CODE>\</CODE><B>list</B> \<B><I>listemplateid</I></B> &amp; (\<B>listsimple</B> | <B>listhybrid</B>)? &amp; &lt;listlevel&gt;+ &amp; \<B>listrestarthdn</B> &amp; \<B><I>listid</I></B> &amp; (\<B>listname</B> #PCDATA ';') </TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data">&lt;listlevel&gt;</TD>
<TD width=78% class="data">&lt;number&gt; &lt;justification&gt; <B>&amp; \leveljcn<I>N</I></B>? &amp; <B><CODE>\</CODE>levelstartat<I>N</I></B> &amp; <B>(\leveloldN</B> &amp; <B><CODE>\</CODE>levelprev<I>N</I></B>? &amp; <B><CODE>\</CODE>levelprevspace<I>N</I></B>? &amp; <B><CODE>\</CODE>levelspace<I>N</I></B>? &amp; <B><CODE>\</CODE>levelindent<I>N</I></B>?)? &amp; &lt;leveltext&gt; &amp; &lt;levelnumbers&gt; &amp; <B><CODE>\</CODE>levelfollow<I>N</I></B> &amp; <B><CODE>\</CODE>levellegal<I>N</I></B>? &amp; <B><CODE>\</CODE>levelnorestart<I>N</I></B>? &amp; &lt;chrfmt&gt;? &amp; \<B><I>li</I></B>? &amp; \<B><I>fi</I></B>? &amp; (\jclisttab \<B><I>tx</I></B>)?</TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data">&lt;number&gt;</TD>
<TD width=78% class="data"><B><CODE>\</CODE>levelnfcN | \levelnfcnN | (\levelnfcN &amp; \levelnfcnN)</B></TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data">&lt;justification&gt;</TD>
<TD width=78% class="data"><B><CODE>\</CODE>leveljcN | \leveljcnN | (\leveljcN &amp; \leveljcnN)</B></TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data">&lt;leveltext&gt;</TD>
<TD width=78% class="data">'{' <B><CODE>\</CODE>leveltext \leveltemplateid</B>? #SDATA ';' '}'</TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data">&lt;levelnumbers&gt;</TD>
<TD width=78% class="data">'{' <B><CODE>\</CODE>levelnumbers</B> #SDATA ';' '}'</TD>
</TR>
</table>

<H3 class="dtH1">Top-Level List Properties</H3>
<table class="data">

<TR VALIGN="top">
<TD width=22% class="data"><b class="le">Control<BR>
Word</b></TD>
<TD width=78% class="data"><b class="le">Meaning</b></TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data"><B><CODE>\</CODE>listidN</B></TD>
<TD width=78% class="data">Each list must have a unique list ID that should be randomly generated. The value <B>N</B> is a long integer. The list ID cannot be between -1 and -5. </TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data"><B><CODE>\</CODE>listtemplateidN</B></TD>
<TD width=78% class="data">Each list should have a unique template ID as well, which also should be randomly generated. The template ID cannot be -1. The value <B>N</B> is a long integer. </TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data"><B><CODE>\</CODE>listsimpleN</B></TD>
<TD width=78% class="data">1 if the list has one level; 0 (default) if the list has nine levels.</TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data"><B><CODE>\</CODE>listhybrid</B></TD>
<TD width=78% class="data">Present if the list is has 9 levels, each of which is the equivalent of a simple list. Only one of <B><CODE>\</CODE>listsimple</B> and <B><CODE>\</CODE>listhybrid</B> should be present. Word 2000 will write lists with the <B><CODE>\</CODE>listhybrid</B> property.</TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data"><B><CODE>\</CODE>listrestarthdnN</B></TD>
<TD width=78% class="data">1 if the list restarts at each section; 0 if not. Used for Word 7.0 compatibility only. </TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data"><B><CODE>\</CODE>listname</B></TD>
<TD width=78% class="data">The argument for <B><CODE>\</CODE>listname</B> is a string that is the name of this list. Names allow ListNum fields to specify the list they belong to. This is a destination control word.</TD>
</TR>
</table>

<P>While Word 97 emitted simple or multilevel lists (not simple), Word 2000 emits hybrid lists, which are essentially collections of simple lists. The main difference between Word 2000 hybrid lists and Word 97 multilevel ones is that each level of a hybrid list has a unique identifier.</P>

<H3 class="dtH1">List Levels</H3>

<P>Each list consists of either one or nine list levels depending upon whether the <B><CODE>\</CODE>listsimple </B>flag is set. Each list level contains a number of properties that specify the formatting for that level, such as the start-at value, the text string surrounding the number, its justification and indents, and so on.</P>
<table class="data">

<TR VALIGN="top">
<TD width=22% class="data"><b class="le">Control<BR>
Word</b></TD>
<TD width=78% class="data"><b class="le">Meaning</b></TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data"><B><CODE>\</CODE>levelstartat<I>N</I></B></TD>
<TD width=78% class="data"><B><I>N</I></B> specifies the start-at value for the level</TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data"><B><CODE>\</CODE>levelnfc<I>N</I></B></TD>
<TD width=78% class="data">Specifies the number type for the level:
<P>0Arabic (1, 2, 3)</P>

<P>1Uppercase Roman numeral (I, II, III)</P>

<P>2Lowercase Roman numeral (i, ii, iii)</P>

<P>3Uppercase letter (A, B, C)</P>

<P>4Lowercase letter (a, b, c)</P>

<P>5Ordinal number (1st, 2nd, 3rd)</P>

<P>6Cardinal text number (One, Two Three)</P>

<P>7Ordinal text number (First, Second, Third)</P>

<P>10Kanji numbering without the digit character (*dbnum1).</P>

<P>11Kanji numbering with the digit character (*dbnum2).</P>

<P>1246 phonetic Katakana characters in "aiueo" order (*aiueo).</P>

<P>1346 phonetic katakana characters in "iroha" order (*iroha).</P>

<P>14Double Byte character</P>

<P>15Single Byte character</P>

<P>16Kanji numbering 3 (*dbnum3).</P>

<P>17Kanji numbering 4 (*dbnum4).</P>

<P>18Circle numbering (*circlenum).</P>

<P>19Double-byte Arabic numbering</P>

<P>2046 phonetic double-byte Katakana characters (*aiueo*dbchar).</P>

<P>2146 phonetic double-byte katakana characters (*iroha*dbchar).</P>

<P>22Arabic with leading zero (01, 02, 03, ..., 10, 11)</P>

<P>23Bullet (no number at all)</P>

<P>24Korean numbering 2 (*ganada).</P>

<P>25Korean numbering 1 (*chosung).</P>

<P>26Chinese numbering 1 (*gb1).</P>

<P>27Chinese numbering 2 (*gb2).</P>

<P>28Chinese numbering 3 (*gb3).</P>

<P>29Chinese numbering 4 (*gb4).</P>

<P>30Chinese Zodiac numbering 1 (* zodiac1)</P>

<P>31Chinese Zodiac numbering 2 (* zodiac2)</P>

<P>32Chinese Zodiac numbering 3 (* zodiac3)</P>

<P>33Taiwanese double-byte numbering 1</P>

<P>34Taiwanese double-byte numbering 2</P>

<P>35Taiwanese double-byte numbering 3</P>

<P>36Taiwanese double-byte numbering 4</P>

<P>37Chinese double-byte numbering 1</P>

<P>38Chinese double-byte numbering 2</P>

<P>39Chinese double-byte numbering 3</P>

<P>40Chinese double-byte numbering 4</P>

<P>41Korean double-byte numbering 1</P>

<P>42Korean double-byte numbering 2</P>

<P>43Korean double-byte numbering 3</P>

<P>44Korean double-byte numbering 4</P>

<P>45Hebrew non-standard decimal</P>

<P>46Arabic Alif Ba Tah</P>

<P>47Hebrew Biblical standard</P>

<P>48Arabic Abjad style</P>

<P>255No number</P>
</TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data"><B><CODE>\</CODE>leveljc<I>N</I></B></TD>
<TD width=78% class="data">0Left justified
<P>1Center justified</P>

<P>2Right justified</P>
</TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data"><B><CODE>\</CODE>levelnfcn<I>N</I></B></TD>
<TD width=78% class="data">Same arguments as <B><CODE>\</CODE><I>levelnfc</I>. </B>Takes priority over it if both are present. In Word 97 <B><CODE>\</CODE><I>levelnfc</I></B> was interpreted differently by the Hebrew/Arabic versions. <B><CODE>\</CODE>levelnfcn</B> in Word 2000 eliminates dual interpretation while <B><CODE>\</CODE>levelnfc</B> is still needed for backwards compatibility.</TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data"><B><CODE>\</CODE>leveljcn<I>N</I></B></TD>
<TD width=78% class="data">0Left justified if for left-to-right paragraphs and right justified for right-to-left paragraphs
<P>1Center justified</P>

<P>2Right justified if for left-to-right paragraphs and left justified for right-to-left paragraphs</P>

<P>Word 2000 prefers it over <B><CODE>\</CODE><I>leveljc</I></B> if both are present, but it will be written for backwards compatibility with older readers.</P>
</TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data"><B><CODE>\</CODE>levelold<I>N</I></B></TD>
<TD width=78% class="data">1 if this level was converted from Word 6.0 or 7.0, 0 if it is a native Word 97-2000 level.</TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data"><B><CODE>\</CODE>levelprev<I>N</I></B></TD>
<TD width=78% class="data">1 if this level includes the text from the previous level (used for Word 7.0 compatibility only); otherwise, the value is 0 . This keyword will only be valid if the <B><CODE>\</CODE>leveloldN </B>keyword is emitted.</TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data"><B><CODE>\</CODE>levelprevspace<I>N</I></B></TD>
<TD width=78% class="data">1 if this level includes the indentation from the previous level (used for Word 7.0 compatibility only); otherwise, the value is 0. This keyword will only be valid if the <B><CODE>\</CODE>leveloldN </B>keyword is emitted.</TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data"><B><CODE>\</CODE>levelindent<I>N</I></B></TD>
<TD width=78% class="data">Minimum distance from the left indent to the start of the paragraph text (used for Word 7.0 compatibility only). This keyword will only be valid if the <B><CODE>\</CODE>levelold<I>N</I></B> keyword is emitted.</TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data"><B><CODE>\</CODE>levelspace<I>N</I></B></TD>
<TD width=78% class="data">Minimum distance from the right edge of the number to the start of the paragraph text (used for Word 7.0 compatibility only). This keyword will only be valid if the <B><CODE>\</CODE>levelold<I>N</I> </B>keyword is emitted.</TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data"><B><CODE>\</CODE>leveltext</B></TD>
<TD width=78% class="data">If the list is hybrid, as indicated by <B><CODE>\</CODE>listhybrid</B> we will find the <B><CODE>\</CODE>leveltemplateid<I>N</I></B> keyword, whose argument is a unique level ID that should be randomly generated. The value <B><I>N</I></B> is a long integer. The level ID cannot be between -1 and -5.
<P>The second argument for this destination should be the number format string for this level. The first character is the length of the string, and any numbers within the level should be replaced by the index of the level they represent. For example, a level three number such as "1.1.1." would generate the following RTF: "<B><CODE>{\</CODE>leveltext <CODE>\</CODE>leveltemplateid<I>N</I></B> <B><CODE>\</CODE>'06\'00.\'01.\'02.}</B>" where the '06 is the string length, the \'00, \'01, and \'02 are the level place holders, and the periods are the surrounding text. This is a destination control word.</P>
</TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data"><B><CODE>\</CODE>levelnumbers</B></TD>
<TD width=78% class="data">The argument for this destination should be a string that gives the offsets into the <B><CODE>\</CODE>leveltext </B>of the level place holders. In the above example, "1.1.1.", the <B><CODE>\</CODE>levelnumbers </B>RTF should be
<PRE class="code">{\levelnumbers \'01\'03\'05}
</PRE>

<P>because the level place holders have indices 1, 3, and 5. This is a destination control word.</P>
</TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data"><B><CODE>\</CODE>levelfollow<I>N</I></B></TD>
<TD width=78% class="data">Specifies which character follows the level text:
<P>0Tab</P>

<P>1Space</P>

<P>2Nothing</P>
</TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data"><B><CODE>\</CODE>levellegal<I>N</I></B></TD>
<TD width=78% class="data">1 if any list numbers from previous levels should be converted to Arabic numbers; 0 if they should be left with the format specified by their own level's definition.</TD>
</TR>

<TR VALIGN="top">
<TD width=22% class="data"><B><CODE>\</CODE>levelnorestart<I>N</I></B></TD>
<TD width=78% class="data">1 if this level does not restart its count each time a number of a higher level is reached, 0 if this level does restart its count each time a number of a higher level is reached.</TD>
</TR>
</table>

<P>In addition to all of these properties, each list level can contain any character properties (all of which affect all text for that level) and any combination of three paragraph properties: left indents, first line left indents, and tabs&#0151;each of which must be of a special type: <B>jclisttab</B>. These paragraph properties will be automatically applied to any paragraph in the list.</P>

<H4 class="dtH1">List Override table</H4>

<P>The List Override table is a list of list overrides (destination \<B>listoverride</B>). Each list override contains the <B>listid</B> of one of the lists in the List table, as well as a list of any properties it chooses to override. Each paragraph will contain a list override index (keyword <B>ls</B>) which is a 1-based index into this table. Most list overrides don't override any properties&#0151;instead, they provide a level of indirection to a list. The two types of list overrides are, in general: (1) formatting overrides, which allow a paragraph to be part of a list, are numbered together with the other members of the list, but have different formatting properties; and (2) start-at overrides, which allow a paragraph to share the formatting properties of a list, but have a different start-at values. The first element in the document with each list override index takes the start-at value that the list override specifies as its value, while each subsequent element is assigned the number succeeding the previous element of the list.</P>

<P>List overrides have a few top-level keywords, including a \<B>listoverridecount</B>, which contains a count of the number of levels whose format is overridden. This \<B>listoverridecount</B> should always be either 1 or 9, depending upon whether the list to be overridden is simple or hybrid/multilevel. All of the actual override information is stored within a list of list override levels (destination \<B>lfolevel</B>).</P>
<table class="data">

<TR VALIGN="top">
<TD width=29% class="data"><b class="le">Control<BR>
Word</b></TD>
<TD width=71% class="data"><b class="le">Meaning</b></TD>
</TR>

<TR VALIGN="top">
<TD width=29% class="data"><B><CODE>\</CODE>listid<I>N</I></B></TD>
<TD width=71% class="data">Should exactly match the \<B>listid</B> of one of the lists in the List table. The value <I><B>N</B> </I>is a long integer.</TD>
</TR>

<TR VALIGN="top">
<TD width=29% class="data"><B><CODE>\</CODE>listoverridecount<I>N</I></B></TD>
<TD width=71% class="data">Number of list override levels within this list override (1 or 9).</TD>
</TR>

<TR VALIGN="top">
<TD width=29% class="data"><B><CODE>\</CODE>ls</B></TD>
<TD width=71% class="data">The (1-based) index of this \<B>listoverride</B> in the \<B>listoverride</B> table. This value should never be zero inside a \<B>listoverride</B>, and must be unique for all \<B>listoverrides </B>within a document. The valid values are from 1 to 2000.</TD>
</TR>
</table>

<H4 class="dtH1">List override level</H4>

<P>Each list override level contains flags to specify whether the formatting or start-at values are being overridden for each level. If the format flag (<B>listoverrideformat</B>) is given, the <B>lfolevel</B> should also contain a list level (<B>listlevel</B>). If the start-at flag (<B>listoverridestartat</B>) is given, a start-at value must be provided. If the start-at is overridden but the format is not, then a <B>levelstartat</B> should be provided in the <B>lfolevel</B> itself. If both start-at and format are overridden, put the <B>levelstartat</B> inside the <B>listlevel</B> contained in the <B>lfolevel</B>.</P>
<table class="data">

<TR VALIGN="top">
<TD width=30% class="data"><b class="le">Control<BR>
Word</b></TD>
<TD width=70% class="data"><b class="le">Meaning</b></TD>
</TR>

<TR VALIGN="top">
<TD width=30% class="data"><B><CODE>\</CODE>listoverridestartat</B></TD>
<TD width=70% class="data">Indicates an override of the start-at value.</TD>
</TR>

<TR VALIGN="top">
<TD width=30% class="data"><B><CODE>\</CODE>listoverrideformat<I>N</I></B></TD>
<TD width=70% class="data">Number of list override levels within this list override (should be either 1 or 9).</TD>
</TR>
</table>

<H2 class="dtH1"><A NAME="rtfspec_15"></A>Track Changes (Revision Marks)</H2>

<P>This table allows tracking of multiple authors and reviewers of a document, and is used in conjunction with the character properties for tracking changes (using revision marks).</P>
<table class="data">

<TR VALIGN="top">
<TD width=20% class="data"><b class="le">Control<BR>
Word</b></TD>
<TD width=80% class="data"><b class="le">Definition</b></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data"><B><CODE>\</CODE>*\revtbl</B></TD>
<TD width=80% class="data">This group consists of subgroups that each identify the author of a revision in the document, as in {Author1;}. This is a destination control word.
<P>Revision conflicts, such as one author deleting another's additions, are stored as one group, in the following form:</P>

<PRE class="code">CurrentAuthor\'00\'&lt;length of previous author's name&gt;PreviousAuthor\'00
PreviousRevisionTime
</PRE>

<P>The 4 bytes of the Date/Time (DTTM) structure are emitted as ASCII characters, so values greater than 127 should be emitted as hexadecimal values enclosed in quotation marks.</P>
</TD>
</TR>
</table>

<P>All time references for revision marks use the following bit field structure, DTTM.</P>
<table class="data">

<TR VALIGN="top">
<TD width=20% class="data"><b class="le">Bit numbers</b></TD>
<TD width=24% class="data"><b class="le">Information</b></TD>
<TD width=56% class="data"><b class="le">Range</b></TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">0&#0150;5</TD>
<TD width=24% class="data">Minute</TD>
<TD width=56% class="data">0&#0150;59</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">6&#0150;10</TD>
<TD width=24% class="data">Hour</TD>
<TD width=56% class="data">0&#0150;23</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">11&#0150;15</TD>
<TD width=24% class="data">Day of month</TD>
<TD width=56% class="data">1&#0150;31</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">16&#0150;19</TD>
<TD width=24% class="data">Month</TD>
<TD width=56% class="data">1&#0150;12</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">20&#0150;28</TD>
<TD width=24% class="data">Year</TD>
<TD width=56% class="data">= Year&#0151;1900</TD>
</TR>

<TR VALIGN="top">
<TD width=20% class="data">29&#0150;31</TD>
<TD width=24% class="data">Day of week</TD>
<TD width=56% class="data">0 (Sun)&#0150;6 (Sat)</TD>
</TR>
</table>
 <!--closes the topic content div-->
<!--FOOTER_END-->


<!-- End Content -->

 </TD> </TR> </TABLE>
<TABLE WIDTH="100%" HEIGHT="50" ID="idToolbar" CELLPADDING="0" CELLSPACING="0" BORDER="0" BGCOLOR="#003399">
<TR>
<TD BGCOLOR=#003399 HEIGHT="20" VALIGN="middle" NOWRAP ID="idTBLocal" WIDTH="100%">
<FONT FACE="Verdana, Arial" SIZE="2"><B>

		&nbsp;&nbsp;<A STYLE='color:##FFFFFF;text-decoration:none;' HREF='http://register.microsoft.com/contactus30/contactus.asp?domain=msdn' TARGET='_top'><FONT COLOR='#FFFFFF'>Contact Us</FONT></A>

					&nbsp;&nbsp;<FONT COLOR='#FFFFFF'>|</FONT>
				
		&nbsp;&nbsp;<A STYLE='color:##FFFFFF;text-decoration:none;' HREF='mailto:?subject=An article from MSDN&body=Here is an interesting article from MSDN:  msdn.microsoft.com/library/en-us/dnrtfspec/html/rtfspec_6.asp' TARGET='_top'><FONT COLOR='#FFFFFF'>E-Mail this Page</FONT></A>

					&nbsp;&nbsp;<FONT COLOR='#FFFFFF'>|</FONT>
				
		&nbsp;&nbsp;<A STYLE='color:##FFFFFF;text-decoration:none;' HREF='/flash/' TARGET='_top'><FONT COLOR='#FFFFFF'>MSDN Flash Newsletter</FONT></A>


</B></FONT>
</TD>
</TR>
<TR>
<TD BGCOLOR=#003399 HEIGHT="20" VALIGN="middle" NOWRAP ID="idTBLocal" WIDTH="100%">
<FONT FACE="Verdana, Arial" SIZE="2"><B>
&nbsp;&nbsp;<FONT COLOR='#FFFFFF'>&#169; 2003 Microsoft Corporation. All rights reserved.</FONT>&nbsp;&nbsp;
&nbsp;&nbsp;<A STYLE='color:##FFFFFF;text-decoration:none;' HREF=' /isapi/gomscom.asp?target=/info/cpyright.htm' TARGET='_top'><FONT COLOR='#FFFFFF'>Terms of Use</FONT></A>&nbsp;&nbsp;&nbsp;&nbsp;<A STYLE='color:##FFFFFF;text-decoration:none;' HREF='/isapi/gomscom.asp?target=/info/privacy.htm' TARGET='_top'><FONT COLOR='#FFFFFF'>Privacy Statement </FONT></A>&nbsp;&nbsp;&nbsp;&nbsp;<A STYLE='color:##FFFFFF;text-decoration:none;' HREF='/isapi/gomscom.asp?target=/enable/' TARGET='_top'><FONT COLOR='#FFFFFF'>Accessibility </FONT></A>&nbsp;&nbsp;</B></FONT>
</TD>
</TR>
</TABLE>
 </BODY> </HTML>