{------------------------------------------------------------------------------}
{    _____      _______   ________   _       _        ________    _            }
{   |  __ \    |   __  | |        | | |     | |     /  _____  \  | |           }
{   | |  \ \   |  |__| | |  ____  | | |\    | |     | |     |_|  | |           }
{   | |  |  |  | ______| | |    | | | |\\   | |     | |          | |           }
{   | |  |  |  | |\\     | |    | | | | \\  | |     | |    ___   | |           }
{   | |  |  |  | | \\    | |____| | | |  \\ | |     | |   |_  |  | |     _     }
{   | |_/  /   | |  \\   |        | | |   \\| |     | |_____| |  | |____| |    }
{   |_____/    |_|   \\  |________| |_|    \|_|     \________/   |________|    }
{                                                                              }
{  DRON's OpenGl Engine V 1.0 PreRelease http://dronprogs.mirgames.ru          }
{                                                                              }
{  Date: 25.09.2005                                                            }
{                                                                              }
{ :      ,   ,   }
{     ,    ,      }
{   ,    DGLEngine    ,   }
{       .                       }
{         .            }
{                                                                              }
{------------------------------------------------------------------------------}
unit DGLEngine_header;

interface
uses Windows, Classes, Gl;

  const
  DGLE_dll = 'DGLEngine.dll';

{***Engine***}
{Module version: 1.1}

{***     ***}
const
PROC_DRAW    = 0;
PROC_PROCESS = 1;
PROC_INIT    = 2;
procedure RegProcedure(ID: WORD; ProcAdress: pointer); stdcall; external DGLE_dll;
procedure SetEngineInitParametrs(ResX,ResY,ColorDepth, DisplayFrequency : integer; Fullscreen, VSync,
                                 UseEngineSettingsIni : boolean;
                                 WriteLog : boolean = true); stdcall; external DGLE_dll;
procedure SetWindowPosition(Left, Top : integer); stdcall; external DGLE_dll;
procedure EnableStencilBuffer; stdcall; external DGLE_dll;
procedure SetEngineInifileName(Name : string); stdcall; external DGLE_dll;
procedure PleaseNoLogo; stdcall; external DGLE_dll;
procedure SetGameProcessInterval(Interval : byte); stdcall; external DGLE_dll;
procedure SetCutingPlanes(ZNear, ZFar : single); stdcall; external DGLE_dll;
procedure SetViewAngle(Angle : single); stdcall; external DGLE_dll;
{***---***}

procedure StartEngine; stdcall; external DGLE_dll;
function  LoadPlugin(FileName : string) : string; stdcall; external DGLE_dll;
function  IsPluginLoaded(Name : string) : boolean; stdcall; external DGLE_dll;
function  GetPluginHandle(Name : string) : THandle; stdcall; external DGLE_dll;
procedure FreePlugin(Name : string); stdcall; external DGLE_dll;

const
ENGINE_LOGFILE = 'DGLEngine_Log.txt';
procedure AddToLogFile(FileName, LogStr:String; IsDate : Boolean = false; IsTime : Boolean = false;
                       FileRewrite : boolean = false);  stdcall; external DGLE_dll;
procedure ApplicationName(Name : PAnsiChar); stdcall; external DGLE_dll;
function  GetFPS : integer; stdcall; external DGLE_dll;

const
ENGINE_INIFILE = 'Settings.ini';
function  ReadValueFromIniFile(Filename, Section, Key: string):string; stdcall; external DGLE_dll;
procedure WriteValueToIniFile(Filename, Section, Key, Value : string); stdcall; external DGLE_dll;
function  GetScreenResX : integer; stdcall; external DGLE_dll;
function  GetScreenResY : integer; stdcall; external DGLE_dll;
procedure QuitEngine; stdcall; external DGLE_dll;

const
TEXDETAIL_BEST   = 0;
TEXDETAIL_SMOOTH = 1;
TEXDETAIL_MEDIUM = 2;
TEXDETAIL_POOR   = 3;
function  LoadTexture(Filename: String; var Texture: Cardinal; Detail : byte = TEXDETAIL_BEST;
                      BMPTransparentColor : cardinal = $808080) : Boolean;  stdcall; external DGLE_dll;
procedure ExtractFromPackage(const PackageName, Name, DestFilename : string); stdcall; external DGLE_dll;
function  LoadFromPackage(const Filename, Name : string):TMemoryStream; stdcall; external DGLE_dll;
function  LoadTextureFromPackage(Filename, Name : string; var Texture: Cardinal; Detail : byte = TEXDETAIL_BEST;                                  BMPTransparentColor : cardinal = $808080) : boolean;  stdcall; external DGLE_dll;
procedure FreeTexture(Texture : Cardinal); stdcall; external DGLE_dll;
procedure TextureCompression(Enable : boolean); stdcall; external DGLE_dll;

const
IS_TGA       = 1;
IS_BMP       = 2;
IS_JPG       = 3;
IS_GEN       = 4;
IS_UNLOAD    = 0;
INDEX_UNLOAD = 0;
type TTextureInfo = record
Index : Cardinal;
Width,Height : integer;
Detail,
TextureType : byte;
end;
function  GetTextureInfo(Texture : Cardinal) : TTextureInfo; stdcall; external DGLE_dll;
function  PrintScreen(Folder : string = '') : integer; stdcall; external DGLE_dll;
function  AddTimer(Interval : Cardinal; OnTimerProcedure : pointer) : Cardinal; stdcall; external DGLE_dll;
procedure DisableTimer(Ident : Cardinal); stdcall; external DGLE_dll;
procedure EnableTimer(Ident : Cardinal); stdcall; external DGLE_dll;
procedure SetTimerInterval(Ident, Interval : Cardinal); stdcall; external DGLE_dll;
function  LoadFontFromFile(Filename : string) : Cardinal; stdcall; external DGLE_dll;
procedure FreeFont(Ident : cardinal); stdcall; external DGLE_dll;

{***Console***}
{Module version: 1.01}

procedure CreateConsole(Font : Cardinal; Size : real = 1.0; Texture : Cardinal = 0); stdcall; external DGLE_dll;
procedure RegisterCommandProcedure(ComName : string; ProcAdress : pointer); stdcall; external DGLE_dll;
function  GetLastComParam : string; stdcall; external DGLE_dll;
procedure RegisterCommandValue(ComName : string; ValueAdress : pointer; MaxValue,
                               MinValue : integer); stdcall; external DGLE_dll;
procedure AddStringToConsole(Text : string); stdcall; external DGLE_dll;
procedure ClearConsole; stdcall; external DGLE_dll;
procedure ProcessConsole; stdcall; external DGLE_dll;
procedure DrawConsole; stdcall; external DGLE_dll;

{***Graphics 2D***}
{Module version: 1.02}

procedure Begin2D; stdcall; external DGLE_dll;
procedure End2D; stdcall; external DGLE_dll;

procedure PutPoint2D(X,Y,Color : integer; Alpha : integer = 255) ; stdcall; external DGLE_dll;
procedure DrawLine2D(X1, Y1, X2, Y2, Color : integer; Alpha : integer = 255; LineWidth : real = 1.0;
                     Smooth : boolean = false); stdcall; external DGLE_dll;
procedure DrawColorLine2D(X1, Y1, X2, Y2, Color1, Color2 : integer; Alpha : integer = 255;
                          LineWidth : real = 1.0; Smooth : boolean = true); stdcall; external DGLE_dll;
procedure DrawRectangle2D(X, Y, Width, Height, Color : integer; Alpha : integer = 255;
                          Fill : boolean = false); stdcall; external DGLE_dll;
procedure DrawRectangle2D_Fill_VertexColor(X, Y, Width, Height, Color1, Color2, Color3, Color4,
                                           Alpha1, Alpha2, Alpha3, Alpha4 : integer); stdcall; external DGLE_dll;
procedure DrawCircle2D(X, Y, Radius, Color : integer; Alpha : byte = 255); stdcall; external DGLE_dll;
procedure DrawCircle2D_Fill(X, Y, Radius, Color : integer; Alpha : byte = 255); stdcall; external DGLE_dll;
procedure DrawEllipse2D(Center: TPoint; Radius0, Radius1, Vertices: Integer; Color: Cardinal;
                        Alpha: byte=255); stdcall; external DGLE_dll;
procedure DrawEllipse2D_Fill(Center: TPoint; Radius0, Radius1: Integer; Color: Cardinal;
                             Alpha: byte=255); stdcall; external DGLE_dll;
procedure DrawCircleArc2D(X, Y, Radius, Angle1, Angle2, Color: Integer;
                          Alpha : byte = 255); stdcall; external DGLE_dll;
procedure DrawPolygon2D(points : array of Tpoint; Color, Alpha : integer); stdcall; external DGLE_dll;
type TColorVertex2D = record X,Y,Color, Alpha : integer; end;
procedure DrawPolygon2D_VertexColor(points : array of TColorVertex2D); stdcall; external DGLE_dll;

procedure DrawTexture2D_Simple(Texture : Cardinal; X , Y, ImageWidth, ImageHeight : integer;
                               FlipX : boolean = false; FlipY : boolean = false); stdcall; external DGLE_dll;
procedure DrawTexture2D_Split(Texture : Cardinal; X , Y, TexWidth, TexHeight : integer; Angle, Alpha,
                              Color : integer; SplitRect : Trect; Scale : single = 1.0; FlipX : boolean = false;
                              FlipY : boolean = false); stdcall; external DGLE_dll;
procedure DrawTexture2D(Texture : Cardinal; X , Y, ImageWidth, ImageHeight, Angle, Alpha, Color : integer;
                        Diffuse : boolean = false; FlipX : boolean = false; FlipY : boolean = false);
                        stdcall; external DGLE_dll;
procedure DrawTexture2D_VertexColor(Texture : Cardinal; X , Y, ImageWidth, ImageHeight, Color1, Color2,
                                    Color3, Color4, Alpha1, Alpha2, Alpha3, Alpha4 : integer; FlipX : boolean = false;
                                    FlipY : boolean = false); stdcall; external DGLE_dll;
procedure DrawSprite2D_Simple(Texture : Cardinal; X , Y, ImageWidth, ImageHeight,FramesXCount, FramesYCount,
                              FrameNumber: integer; FlipX : boolean = false; FlipY : boolean = false);
                              stdcall; external DGLE_dll;
procedure DrawSprite2D(Texture : Cardinal; X , Y, ImageWidth, ImageHeight,FramesXCount, FramesYCount,
                       FrameNumber, Angle, Alpha, Color : integer; Diffuse : boolean = false; FlipX : boolean = false;
                       FlipY : boolean = false); stdcall; external DGLE_dll;
procedure DrawSprite2D_VertexColor(Texture : Cardinal; X , Y, ImageWidth, ImageHeight,FramesXCount,
                                   FramesYCount, FrameNumber, Color1, Color2, Color3, Color4, Alpha1,
                                   Alpha2, Alpha3, Alpha4 : integer; FlipX : boolean = false;
                                   FlipY : boolean = false); stdcall; external DGLE_dll;
procedure DrawSprite2D_Tile(Texture : Cardinal; X, Y, TexWidth, TexHeight, FrameWidth, FrameHeight,
                            FramesXCount, FramesYCount, FrameNumber, Angle, Alpha, Color : integer;
                            Scale : single = 1.0; FlipX : boolean = false; FlipY : boolean = false);
                            stdcall; external DGLE_dll;
procedure DrawText2D(Font : Cardinal; X,Y : integer; Text : string; Color : integer = $FFFFFF;
                     Alpha : integer = 255; Scale : real = 1.0); stdcall; external DGLE_dll;
function  GetTextWidth(Font : Cardinal; Text : string; Scale : real = 1.0):integer; stdcall; external DGLE_dll;
function  GetTextHeight(Font : Cardinal; Text : string; Scale : real = 1.0):integer; stdcall; external DGLE_dll;

function  CreateSystemFont2D(Face: PChar; Width, Height: integer): cardinal; stdcall; external DGLE_dll;
procedure FreeSystemFont2D(Font: cardinal); stdcall; external DGLE_dll;
procedure SystemTextOut2D(Font: cardinal; const Text: string; X, Y: integer; Color : integer = $FFFFFF;
                          Alpha : byte = 255); stdcall; external DGLE_dll;

{***Graphics 3D***}
{Module version: 1.0}

procedure BeginObj3D; stdcall; external DGLE_dll;
procedure EndObj3D; stdcall; external DGLE_dll;

type
  TVertex = record X, Y, Z: single; end;
  TCamera = record
            Eye    : TVertex;
            Center : TVertex;
            end;
procedure SetCamera(Camera : TCamera); stdcall; external DGLE_dll;
procedure Position3D(X,Y,Z : single); stdcall; external DGLE_dll;
procedure Scale3D(Scale : single); stdcall; external DGLE_dll;
procedure RotateX(Angle : single); stdcall; external DGLE_dll;
procedure RotateY(Angle : single); stdcall; external DGLE_dll;
procedure RotateZ(Angle : single); stdcall; external DGLE_dll;
procedure Color3D(Color:integer; Alpha : byte = 255; Diffuse : boolean= false; MaterialShininess : single = 0.0);
                  stdcall; external DGLE_dll;
const
TEX_BLANK = 0;
procedure SetTexture(Texture : Cardinal); stdcall; external DGLE_dll;
const
  LIGHTS_ALL = -1;
  LIGHT0     =  0;
  LIGHT1     =  1;
  LIGHT2     =  2;
  LIGHT3     =  3;
  LIGHT4     =  4;
  LIGHT5     =  5;
  LIGHT6     =  6;
  LIGHT7     =  7;
  LIGHT8     =  8;
  LIGHT9     =  9;
procedure SetLight(ID : integer = LIGHT0; X : single = 1;Y : single = 0;Z : single = 1;
                   light_Color : integer =$FFFFFF; Visualize : boolean = false; VisualScale : single = 0.1);
                   stdcall; external DGLE_dll;
procedure DeactiveLight(ID : integer = LIGHTS_ALL); stdcall; external DGLE_dll;
procedure AdductingMatrix3Dto2D; stdcall; external DGLE_dll;
procedure ReturnStandartMatrix3D; stdcall; external DGLE_dll;
procedure Position2D(X,Y : integer); stdcall; external DGLE_dll;
function  CreateFont3D(const Fontname : string):integer; stdcall; external DGLE_dll;
procedure Write3D(FontIdent: integer; Text: string); stdcall; external DGLE_dll;
const
MDL_NO_SCALE               = 0;
MDL_SCALE_EVERY_FRAME      = 1;
MDL_SCALE_GL_ONE           = 2;
MDL_SCALE_BY_LARGEST_FRAME = 3;
function  LoadModel(Filename : string; ScaleType : byte = MDL_SCALE_BY_LARGEST_FRAME) : integer; stdcall; external DGLE_dll;
procedure FreeModel(ModelIdent : integer); stdcall; external DGLE_dll;
procedure DrawModel(ModelIdent : integer; Frame : integer = 0; Smooth : boolean = true); stdcall; external DGLE_dll;
function  ModelFramesCount(Modelident : integer):Integer; stdcall; external DGLE_dll;
function  ModelBoundingBox(Modelident,Frame : integer):TVertex; stdcall; external DGLE_dll;
function  ModelTrianglesCount(Modelident,Frame : integer) : Cardinal; stdcall; external DGLE_dll;
procedure EnableSphereMapping; stdcall; external DGLE_dll;
procedure DisableSphereMapping; stdcall; external DGLE_dll;
procedure SetFog(Color : Integer; Fog_Start, Fog_End : single); stdcall; external DGLE_dll;
procedure DeactiveFog; stdcall; external DGLE_dll;
procedure DrawBumpMappedPlane(Tex, BumpTex : Cardinal; LightX, LightY : single); stdcall; external DGLE_dll;

procedure DrawAxes(Length : single = 1.0); stdcall; external DGLE_dll;
procedure DrawPoint(X,Y,Z : single); stdcall; external DGLE_dll;
procedure DrawLine(X,Y,Z,X1,Y1,Z1 : single; LineWidth : real = 1.0; Smooth : boolean = true); stdcall; external DGLE_dll;
procedure DrawPlane(Width,Height : single); stdcall; external DGLE_dll;
type TVertex3D = record X,Y,Z : single; Color, Alpha : integer; TexX, TexY : single; end;
procedure DrawPolygon3D(points : array of TVertex3D); stdcall; external DGLE_dll;
procedure DrawSprite(Width,Height : single; FramesXCount, FramesYCount, FrameNumber: integer);stdcall; external DGLE_dll;
procedure DrawSprite_BillBoard(Width,Height : single; FramesXCount, FramesYCount, FrameNumber: integer);stdcall;
                               external DGLE_dll;
procedure DrawCube(Width,Height,Depth : single); stdcall; external DGLE_dll;
procedure DrawSphere(Radius : single); stdcall; external DGLE_dll;
procedure DrawCylinder(Radius,Height : single); stdcall; external DGLE_dll;
procedure DrawEllipse(Width, Height, Depth : single); stdcall; external DGLE_dll;
procedure DrawSky(Up,Down,Left,Right,Front,Back : Cardinal); stdcall;  external DGLE_dll;

{***Advanced Engine Utils****}
{Module version: 1.0}

function  Get3DPos : TVertex;  stdcall; external DGLE_dll;
function  Get2DPos(Vertex : TVertex) : TPoint; stdcall; external DGLE_dll;

function  StartWriteToVideoMemory : cardinal; stdcall; external DGLE_dll;
procedure EndWriteToVideoMemory; stdcall; external DGLE_dll;
procedure FreeFromVideoMemory(Ident : integer); stdcall; external DGLE_dll;
procedure DrawFromVM(Ident : integer); stdcall; external DGLE_dll;

function  CreateAVITexture(Filename : string) : integer; stdcall; external DGLE_dll;
procedure FreeAVITexture(index : integer); stdcall; external DGLE_dll;
procedure SetAviTexture(index : integer); stdcall; external DGLE_dll;

procedure RenderShadowsToPlane(LightID : integer; ShadowCasterProc : pointer; PlaneCenter : TVertex;
                               PLaneWidth, PlaneHeight : single; PlaneTexture : Cardinal;
                               PlaneXTexturesCount : integer = 1; PlaneYTexturesCount : integer = 1);
                               stdcall; external DGLE_dll;

procedure ClearZBuffer; stdcall; external DGLE_dll;

procedure PrepareProjectTexture(Texture : cardinal);stdcall; external DGLE_dll;
procedure SetupProjector; stdcall; external DGLE_dll;
procedure DisableProjector; stdcall; external DGLE_dll;
procedure RenderProjection(ProjectTexture : cardinal; DrawScene : pointer; ProjectorOrientation: TCamera;
                           InversedDeffuse : boolean = false); stdcall; external DGLE_dll;
procedure EndDrawingProjectedScene; stdcall; external DGLE_dll;
procedure RenderProjectedTexture(ProjectTexture : Cardinal; ProjectorOrientation: TCamera;
                                 InversedDeffuse : boolean = false); stdcall; external DGLE_dll;
procedure PrepareSceneForProjecting; stdcall; external DGLE_dll;

procedure StartEngine_DrawToPanel(PanelHandle : HWND); stdcall; external DGLE_dll;
procedure EngineProcessMessages(var Msg: tagMSG); stdcall; external DGLE_dll;
procedure EngineMainDraw; stdcall; external DGLE_dll;
procedure UpdateRenderRect(NewWidth,NewHeight : integer); stdcall; external DGLE_dll;

function  CreateTextureToRenderIn(TextureWidth,TextureHeight : integer):Cardinal; stdcall; external DGLE_dll;
procedure StartRenderToTexture(Texture : Cardinal); stdcall; external DGLE_dll;
procedure EndRenderToTexture; stdcall; external DGLE_dll;

procedure CalculateFrustum; stdcall; external DGLE_dll;
function  IsPointInFrustum(X,Y,Z : single) : boolean; stdcall; external DGLE_dll;
function  IsSphereInFrustum(X,Y,Z,Radius : single) : boolean; stdcall; external DGLE_dll;
function  IsBoxInFrustum(X,Y,Z,W,H,D : single) : boolean; stdcall; external DGLE_dll;

{***Network****}
{Module version: 1.0}

function  NET_Init: boolean; stdcall; external DGLE_dll;
procedure NET_Free; stdcall; external DGLE_dll;
procedure NET_Clear; stdcall; external DGLE_dll;
procedure NET_ClearAPL; stdcall; external DGLE_dll;
function  NET_GetExternalIP: PChar; stdcall; external DGLE_dll;
function  NET_GetHost: PChar; stdcall; external DGLE_dll;
function  NET_GetLocalIP: PChar; stdcall; external DGLE_dll;
function  NET_HostToIP(Host: PChar): PChar; stdcall; external DGLE_dll;
function  NET_InitSocket(Port: WORD): integer; stdcall; external DGLE_dll;
function  NET_Write(Buf: pointer; Count: integer): boolean; stdcall; external DGLE_dll;
function  NET_Send(IP: PChar; Port: WORD; APL: boolean): integer; stdcall; external DGLE_dll;
function  NET_Recv(Buf: pointer; Count: integer; var IP: PChar; var Port: integer; var RecvBytes: integer): integer;
                   stdcall; external DGLE_dll;
procedure NET_Update; stdcall; external DGLE_dll;

{***Sound****}
{Module version: 1.1}

procedure PlayMusic(Filename : string; Looped : boolean = true); stdcall; external DGLE_dll;
procedure StopMusic; stdcall; external DGLE_dll;
function  IsMusicPlaying : boolean; stdcall; external DGLE_dll;

procedure DirectSoundInit; stdcall;external DGLE_dll;
function  LoadSample(Filename : string; FromPackage : boolean = false; Name : string = ''):integer;
                     stdcall; external DGLE_dll;
procedure FreeSample(Index : integer); stdcall;external DGLE_dll;
procedure PlaySample(Index : integer); stdcall; external DGLE_dll;
procedure SetSampleVolume(Index : integer; Volume : byte); stdcall; external DGLE_dll;
procedure SetSample3DPosition(Index : integer; X,Y,Z : real); stdcall; external DGLE_dll;
procedure GetSample3DPosition(Index : integer; var X,Y,Z : single); stdcall; external DGLE_dll;

{***Input***}
{Module version: 1.0}

const
MB_LEFT  =1;
MB_MIDDLE=3;
MB_RIGHT =2;
function  GetMouseButtonPressed : byte; stdcall; external DGLE_dll;
function  IsLeftMouseButtonPressed : boolean; stdcall; external DGLE_dll;
function  IsRightMouseButtonPressed : boolean; stdcall; external DGLE_dll;
function  GetMousePos : Tpoint; stdcall; external DGLE_dll;
function  IsMouseMoveing : boolean; stdcall; external DGLE_dll;
procedure StartKeyboardTextInput; stdcall; external DGLE_dll;
procedure EndKeyboardTextInput; stdcall; external DGLE_dll;
function  GetKeyboardText : string; stdcall; external DGLE_dll;
const
JOY_MAIN=0;
function  Input_JoyDown(JoyNum, Button: Byte): boolean; stdcall; external DGLE_dll;
const
JOY_LEFT = 1;
JOY_RIGHT= 2;
JOY_UP   = 3;
JOY_DOWN = 4;
function  Input_JoyDirections(JoyNum, Direction: Byte): boolean; stdcall; external DGLE_dll;

function  IsKeyPressed(Key : integer) : boolean; stdcall; external DGLE_dll;
//Key codes
const
    Key_Escape = 27;
    Key_Tab = 9;
    Key_Backspace = 8;
    Key_Space = 32;
    Key_Enter = 13;
    Key_Shift = 16;
    Key_Control = 17;
    Key_Alt = 18;
    Key_F1 =  112;
    Key_F2 =  113;
    Key_F3 =  114;
    Key_F4 =  115;
    Key_F5 =  116;
    Key_F6 =  117;
    Key_F7 =  118;
    Key_F8 =  119;
    Key_F9 =  120;
    Key_F10 = 121;
    Key_F11 = 122;
    Key_F12 = 123;
    Key_Left = 37;
    Key_Up = 38;
    Key_Right = 39;
    Key_Down = 40;
    Key_0 = 48;
    Key_1 = 49;
    Key_2 = 50;
    Key_3 = 51;
    Key_4 = 52;
    Key_5 = 53;
    Key_6 = 54;
    Key_7 = 55;
    Key_8 = 56;
    Key_9 = 57;
    Key_A = 65;
    Key_B = 66;
    Key_C = 67;
    Key_D = 68;
    Key_E = 69;
    Key_F = 70;
    Key_G = 71;
    Key_H = 72;
    Key_I = 73;
    Key_J = 74;
    Key_K = 75;
    Key_L = 76;
    Key_M = 77;
    Key_N = 78;
    Key_O = 79;
    Key_P = 80;
    Key_Q = 81;
    Key_R = 82;
    Key_S = 83;
    Key_T = 84;
    Key_U = 85;
    Key_V = 86;
    Key_W = 87;
    Key_X = 88;
    Key_Y = 89;
    Key_Z = 90;

implementation
end.
