unit GMain;

interface
uses DGLEngine_Header ,Math;
var Font ,korpus ,pushka ,bg ,rock: cardinal;
    Deads : integer = 0;

   function IntToStr(Num : Integer) : String;
   procedure DrawScene;
   procedure ChangeCoord;
   procedure ProcessBullets;
   procedure ProcessRocks;

implementation
type TBullet = record
                  x,y : integer;
                  angle : integer;
                  active : boolean;
               end;
     TRock = record
                x,y : integer;
                active : boolean;
             end;

var x,y : integer;
    angle : integer;
    bullets : array[1..40]of TBullet;
    bulletCreateWait : integer = 0;
    bulletMoveWait : integer = 0;
    rocks : array[1..40]of TRock;
    hard_level : integer = 2;
    rocksDestroyed : integer = 0;
    level_counter : integer = 0;

function IntToStr(Num : Integer) : String;
begin
  Str(Num, result);
end;

procedure FillBgr;
begin
   DrawTexture2D_Simple(Bg,0,0,400,300);
   DrawTexture2D_Simple(Bg,400,0,400,300);
   DrawTexture2D_Simple(Bg,0,300,400,300);
   DrawTexture2D_Simple(Bg,400,300,400,300);
end;

procedure DrawBullets;
var i : integer;
begin
   i := 1;
   while i <= 40 do
   begin
      if bullets[i].active then
         begin
            with bullets[i] do
            DrawCircle2D_Fill(x,y,3,$CC00CC);
            inc(i);
         end;
      inc(i);
   end;
end;

procedure DrawRocks;
var i : integer;
begin
   for i := 1 to 40 do
      if Rocks[i].active then
         DrawTexture2D_Simple(rock,Rocks[i].x,Rocks[i].y,32,32);
end;

procedure DrawScene;
var i : integer;
begin
   FillBgr;
   DrawTexture2D_Simple(korpus,x,y,64,128);
   DrawTexture2D(pushka,x,y,64,128,angle,150,$000000);
   DrawBullets;
   DrawRocks;
end;

procedure CreateBullet;
var i : integer;
begin
   if bulletCreateWait > 20 then
   begin
      i := 1;
      while (i <= 40) and (bullets[i].active) do inc(i);
      if i <= 40 then
         begin
            bullets[i].x := x + 32 + round (58 * cos (DegToRad(angle - 90)));
            bullets[i].y := y + 64 + round (58 * sin (DegToRad(angle - 90)));
            bullets[i].angle := angle;
            bullets[i].active := true;
            inc(i);
         end;
      bulletCreateWait := 0;
   end;
end;

procedure ChangeCoord;
begin
   angle := trunc(RadToDeg(ArcTan2((GetMousePos.y - y + 64), GetMousePos.x - x + 32))) + 90;
   if GetMouseButtonPressed = MB_Left then CreateBullet;
   if IsKeyPressed(Key_D) then x := x + 2;
   if IsKeyPressed(Key_A) then x := x - 2;
   if IsKeyPressed(Key_S) then y := y + 2;
   if IsKeyPressed(Key_W) then y := y - 2;
end;

procedure ProcessBullets;
var i : integer;
begin
   bulletCreateWait := bulletCreateWait + 1;
   if bulletCreateWait > 30 then bulletCreateWait := 21;
   bulletMoveWait := bulletMoveWait + 1;
   if bulletMoveWait > 0 then
   begin
      i := 1;
      while i <= 40 do
      begin
         if bullets[i].active then
            begin
               bullets[i].x := bullets[i].x + round (5 * cos (DegToRad(bullets[i].angle - 90)));
               bullets[i].y := bullets[i].y + round (5 * sin (DegToRad(bullets[i].angle - 90)));
               if (bullets[i].x < 0) or (bullets[i].x > 800) or (bullets[i].y < 0) or (bullets[i].y > 600) then
                  bullets[i].active := false;
            end;
         inc(i);
      end;
      bulletMoveWait := 0;
   end;
end;

procedure ProcessRocks;
var i,j : integer;
begin
   for i := 1 to 40 do
      if rocks[i].active then
      begin
         for j := 1 to 40 do
            if bullets[j].active then
               if sqrt(sqr(rocks[i].x - bullets[j].x) + sqr(rocks[i].y - bullets[j].y)) < 14 + 5 then
                  begin
                     rocks[i].active := false;
                     bullets[j].active := false;
                     inc(rocksDestroyed);
                     hard_level := rocksDestroyed div 10 + 2;
                  end;
         if (x - 11 < rocks[i].x) and (x + 54 + 11 >rocks[i].x) and (y - 11 < rocks[i].y) and (y + 118 + 11 > rocks[i].y) then
            begin
               for j := 1 to 40 do
                  rocks[j].active := false;
               rocksDestroyed := 0;
               hard_level := 0;
               deads := deads + 1;
               hard_level := 2;
               break;
            end;
      end;
   for i := 1 to 40 do
      if rocks[i].active then
         begin
            rocks[i].y := rocks[i].y + 1;
            if rocks[i].y > 600 then rocks[i].active := false;
         end;
   inc(level_counter);
   if level_counter > 200 div hard_level then
   begin
      level_counter := 0;
      i := 1;
      while (i <= 40) and (rocks[i].active) do inc(i);
      if i <= 40 then
      begin
         rocks[i].active := true;
         rocks[i].x := random(760) + 1;
         rocks[i].y := 0;
      end;
   end;
end;

begin
   x := 100;
   y := 100;
   fillchar(bullets,sizeof(bullets),0);
   fillchar(rocks,sizeof(rocks),0);
end.
