program Game;

uses DGLEngine_header in 'DGLEngine_header.pas',
     GMain in 'GMain.pas';

procedure EngineInit;
begin
   Font:=LoadFontFromFile('Areal_20.dft');
   LoadTextureFromPackage('Textures.dpc','Grass.jpg',bg);
   LoadTextureFromPackage('Textures.dpc','korpus.bmp',korpus);
   LoadTextureFromPackage('Textures.dpc','pushka.bmp',pushka);
   LoadTextureFromPackage('Textures.dpc','Rock.bmp',rock);
end;

procedure Draw;
begin
   Begin2D;
   DrawScene;
   DrawText2D(Font,GetScreenResX-GetTextWidth(Font,'FPS:'+inttostr(GetFPS),0.7)-10,0,'FPS:'+inttostr(GetFPS),$FFFFFF,255,0.7);
   DrawText2D(Font,GetScreenResX-GetTextWidth(Font,'Deaths:'+inttostr(Deads),0.7)-10,21,'Deaths:'+inttostr(Deads),$FFFFFF,255,0.7);
   End2D;
end;

procedure Process;
begin
   ChangeCoord;
   ProcessBullets;
   ProcessRocks;
   if IsKeyPressed(Key_Escape) then QuitEngine;
end;

begin
   SetGameProcessInterval(5);
   RegProcedure(PROC_DRAW,@Draw);
   RegProcedure(PROC_PROCESS,@Process);
   RegProcedure(PROC_INIT,@EngineInit);

   SetEngineInitParametrs(800,600,32,0,true,false,false);

   PleaseNoLogo;
   StartEngine;
   FreeTexture(bg);
   FreeTexture(korpus);
   FreeTexture(pushka);
   FreeTexture(rock);
end.
