{$A+,B-,D+,E+,F-,G-,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V+,X+}
{$M 16384,0,655360}
program read_bmps;
uses graph,crt;
type bmFileHeader=record
                     sig:word;
                     filesize:longint;
                     reserved:longint;
                     offsimg:longint;
                  end;
     bm256InfoHeader=record
                        IHsize:longint;
                        imgWidth:longint;
                        imgHeight:longint;
                        planes:word;
                        bitCount:word;
                        compression:longint;
                        imgSize:longint;
                        Xppm:longint;
                        Yppm:longint;
                        UsedColors:longint;
                        ImportantColors:longint;
                     end;
     TPallet=array[0..255,0..3]of byte;
     TImg=array[0..0]of byte;
     PImg=^TImg;
     bm256File=record
                  bmFH:bmFileHeader;
                  bm256IH:bm256InfoHeader;
                  pallet:TPallet;
                  img:PImg;
               end;

var bmp:bm256File;
    gd,gm:integer;
    i,j:integer;

procedure readBMP(const fname:string;var bmp:bm256File);
var bmf:file;
    i,j:longint;
begin
   assign(bmf,fname);
   reset(bmf,1);
   blockread(bmf,bmp.bmFH,sizeof(bmp.bmFH));
   blockread(bmf,bmp.bm256IH,sizeof(bmp.bm256IH));
   blockread(bmf,bmp.pallet,sizeof(bmp.pallet));
   getmem(bmp.img,bmp.bm256IH.imgSize);
   for i:=0 to bmp.bm256IH.imgHeight-1 do
   begin
      {$R-}blockread(bmf,bmp.img^[(bmp.bm256IH.imgHeight-i-1)*bmp.bm256IH.imgWidth],bmp.bm256IH.imgWidth);{$R+}
      if bmp.bm256IH.imgWidth mod 4<>0 then blockread(bmf,j,4-bmp.bm256IH.imgWidth mod 4);
   end;
end;

procedure writeBMP(const fname:string;bmp:bm256File);
var bmf:file;
    i,j:longint;
begin
   assign(bmf,fname);
   rewrite(bmf,1);
   blockwrite(bmf,bmp.bmFH,sizeof(bmp.bmFH));
   blockwrite(bmf,bmp.bm256IH,sizeof(bmp.bm256IH));
   blockwrite(bmf,bmp.pallet,sizeof(bmp.pallet));
   for i:=0 to bmp.bm256IH.imgHeight-1 do
   begin
      {$R-}blockwrite(bmf,bmp.img^[(bmp.bm256IH.imgHeight-i-1)*bmp.bm256IH.imgWidth],bmp.bm256IH.imgWidth);{$R+}
      if bmp.bm256IH.imgWidth mod 4<>0 then blockwrite(bmf,j,4-bmp.bm256IH.imgWidth mod 4);
   end;
end;

procedure setpal(const pallet:TPallet);
var i:integer;
begin
   for i:=0 to 255 do
      setrgbpalette(i,pallet[i,2] shr 2,pallet[i,1] shr 2,pallet[i,0] shr 2);
end;

procedure outBMP(const bmp:bm256File;const x,y:integer);
var i,j:longint;
begin
   for i:=0 to bmp.bm256IH.imgHeight-1 do
      for j:=0 to bmp.bm256IH.imgWidth-1 do
      {$R-}putpixel(j+x,i+y,bmp.img^[i*bmp.bm256IH.imgWidth+j]);{$R+}
end;

begin
   gd:=installuserdriver('svga256',nil);
   gm:=2;
   initgraph(gd,gm,'');
   readBMP('kurs2.bmp',bmp);
{   writeBMP('kurs1.bmp',bmp);}
   setpal(bmp.pallet);
   setfillstyle(0,0);
   for i:=1 to 440 do
   begin
      asm
              mov dx,03DAh
       @loop1:
              in al,dx
              test al,08h
              jnz @loop1
       @loop2:
              in al,dx
              test al,08h
              jz @loop2
      end;
      bar(i-1,i-1,i+4,i+18);
      outBMP(bmp,i,i);
{      delay(4000);}
   end;
   readln;
end.