{$A+,B-,D+,E+,F-,G-,I+,L+,N+,O-,P-,Q+,R+,S+,T-,V+,X+}
{$M 16384,0,655360}
{made by virt 2004}
program BMP_img_redak;
uses graph,crt;
type bmFileHeader=record
                     sig:word;
                     filesize:longint;
                     reserved:longint;
                     offsimg:longint;
                  end;
     bm256InfoHeader=record
                        IHsize:longint;
                        imgWidth:longint;
                        imgHeight:longint;
                        planes:word;
                        bitCount:word;
                        compression:longint;
                        imgSize:longint;
                        Xppm:longint;
                        Yppm:longint;
                        UsedColors:longint;
                        ImportantColors:longint;
                     end;
     TPallet=array[0..255,0..3]of byte;
     TImg=array[0..0]of byte;
     PImg=^TImg;
     bm256File=record
                  bmFH:bmFileHeader;
                  bm256IH:bm256InfoHeader;
                  pallet:TPallet;
                  img:PImg;
               end;

var bmp:bm256File;
    gd,gm:integer;

procedure readBMP(const fname:string;var bmp:bm256File);
var bmf:file;
    i,j:longint;
begin
   assign(bmf,fname);
   reset(bmf,1);
   blockread(bmf,bmp.bmFH,sizeof(bmp.bmFH));
   blockread(bmf,bmp.bm256IH,sizeof(bmp.bm256IH));
   blockread(bmf,bmp.pallet,sizeof(bmp.pallet));
   getmem(bmp.img,bmp.bm256IH.imgSize);
   for i:=0 to bmp.bm256IH.imgHeight-1 do
   begin
      {$R-}blockread(bmf,bmp.img^[(bmp.bm256IH.imgHeight-i-1)*bmp.bm256IH.imgWidth],bmp.bm256IH.imgWidth);{$R+}
      if bmp.bm256IH.imgWidth mod 4<>0 then blockread(bmf,j,4-bmp.bm256IH.imgWidth mod 4);
   end;
end;

procedure writeBMP(const fname:string;bmp:bm256File);
var bmf:file;
    i,j:longint;
begin
   assign(bmf,fname);
   rewrite(bmf,1);
   blockwrite(bmf,bmp.bmFH,sizeof(bmp.bmFH));
   blockwrite(bmf,bmp.bm256IH,sizeof(bmp.bm256IH));
   blockwrite(bmf,bmp.pallet,sizeof(bmp.pallet));
   for i:=0 to bmp.bm256IH.imgHeight-1 do
   begin
      {$R-}blockwrite(bmf,bmp.img^[(bmp.bm256IH.imgHeight-i-1)*bmp.bm256IH.imgWidth],bmp.bm256IH.imgWidth);{$R+}
      if bmp.bm256IH.imgWidth mod 4<>0 then blockwrite(bmf,j,4-bmp.bm256IH.imgWidth mod 4);
   end;
end;

procedure setpal(const pallet:TPallet);
var i:integer;
begin
   for i:=0 to 255 do
      setrgbpalette(i,pallet[i,2] shr 2,pallet[i,1] shr 2,pallet[i,0] shr 2);
end;

procedure outBMP(const bmp:bm256File;const x,y:integer);
var i,j:longint;
begin
   for i:=0 to bmp.bm256IH.imgHeight-1 do
      for j:=0 to bmp.bm256IH.imgWidth-1 do
      {$R-}putpixel(j+x,i+y,bmp.img^[i*bmp.bm256IH.imgWidth+j]);{$R+}
end;

procedure DrawInterface;
begin
   rectangle(20,20,120,120);
   setcolor(4);outtextxy(560,20,'N');setcolor(15);outtextxy(568,20,'ew');
   setcolor(4);outtextxy(560,35,'S');setcolor(15);outtextxy(568,35,'ave');
   setcolor(4);outtextxy(560,50,'L');setcolor(15);outtextxy(568,50,'oad');
end;

procedure redak;
var quit:boolean;
    key:char;
    _x,_y:integer;
begin
   DrawInterface;
   quit:=false;
   _x:=100;_y:=100;
   repeat
      if keypressed then key:=readkey;
      if key=#0 then key:=readkey;
      case key of
       'n','N':;
       's','S':;
       'l','L':;
       #72:;{up}
       #75:;{left}
       #77:;{right}
       #80:;{down}
      end;
      key:='z';
   until quit=true;
   readln;
end;

begin
   gd:=installuserdriver('svga256',nil);
   gm:=2;
   initgraph(gd,gm,'');
   redak;
end.