Unit Button;

Interface
Uses Strings, mouseUnit, Square;

Type
  ActionType = Procedure;

Const
  btnStandard = 10;
  btnWindowed = 4;

Type
  PTButton = ^TButton;
  TButton =
    Object( TSquare )

      Title : PShortStr;
      Key : Word;
      Action : ActionType;

      Constructor Init( pxSt, pySt : Word; Var pxFn, pyFn : Word;
                  Const s : String; pKey : Word; Const Delta : Byte;
                  pAction : ActionType );
      Destructor Done; Virtual;

      Procedure Show; Virtual;
      Procedure PressIt;

      Function HandleEvent( Var Event : TEvent ) : Boolean;
               Virtual;

    Private
      Procedure Draw( Active : Boolean );
    End;

Type
  PTButtonBar = ^TButtonBar;
  TButtonBar =
    Object( TSquare )

      arr : TGroup;

      Constructor Init( pxSt, pySt, pxFn, pyFn : Word );
      Destructor Done; Virtual;

      Procedure Show; Virtual;
      Function Process( Var Event : TEvent ) : Boolean;

      Function Insert( p : PTButton ) : Boolean;
    End;

Procedure noneAction;

Implementation
Uses Crt, Graph;

Constructor TButton.Init( pxSt, pySt : Word; Var pxFn, pyFn : Word;
            Const s : String; pKey : Word; Const Delta : Byte;
            pAction : ActionType );
  Begin
    SetTextStyle( SmallFont, HorizDir, 4 );

    pxFn := pxSt + TextWidth( s ) + Delta;
    pyFn := pySt + TextHeight( s ) + Delta;

    TSquare.Init( pxSt, pySt, pxFn, pyFn, White, LightGray );

    New( Title ); Title^ := s;
    Action := pAction; Key := pKey
  End;

Destructor TButton.Done;
  Begin
    Dispose( Title );
    TSquare.Done
  End;

Procedure TButton.Show;
  Begin Draw( False ) End;

Procedure TButton.Draw( Active : Boolean );
  Begin
    mouse.msOff;

    TSquare.Show;
    SetColor( Byte(Active) * Red + Byte(not Active) * White );
    SetTextStyle( SmallFont, HorizDir, 4 );
    SetTextJustify( CenterText, CenterText );
    OutTextXY( xSt + (xFn - xSt) Div 2,
               ySt + (yFn - ySt) Div 2, Title^ );

    mouse.msOn
  End;

Procedure TButton.PressIt;
  Const
    DelayTime = 15000;
  Begin
    Draw( True );
    Delay( DelayTime );
    Draw( False );
    Action
  End;

Function TButton.HandleEvent( Var Event : TEvent ) : Boolean;
  Var WasClick : Boolean;
  Begin
    WasClick := False;

    With Event Do
      If not mousePressed Then
        WasClick := (keyPressed = Key)
      Else WasClick := TSquare.IsClicked( Event );

    If WasClick Then PressIt;
    HandleEvent := WasClick;
  End;



Constructor TButtonBar.Init( pxSt, pySt, pxFn, pyFn : Word );
  Var i : Word;
  Begin
    TSquare.Init( pxSt, pySt, pxFn, pyFn, DarkGray, Black );
    arr.Init
  End;

Destructor TButtonBar.Done;
  Begin
    arr.Done;
    TSquare.Done
  End;

Procedure TButtonBar.Show;
  Begin
    TSquare.Show;
    arr.Show;
  End;

Function TButtonBar.Process( Var Event : TEvent ) : Boolean;
  Begin
    Process := arr.HandleEvent( Event )
  End;

Function TButtonBar.Insert( p : PTButton ) : Boolean;
  Begin
    Insert := True;
    arr.Insert( p )
  End;

Procedure noneAction;
  Begin End;

END.
