Unit Graphix;

Interface

Procedure OpenGraphix;
Procedure CloseGraphix;

Implementation
Uses Graph;

{$L EGAVGA.OBJ}
Procedure EGAVGADriverProc; External;
{$L LITT.OBJ}
Procedure LittFontProc; External;

Procedure OpenGraphix;
  Var grDriver, grMode, ErrCode : Integer;
  Begin
    If RegisterBGIDriver( @EGAVGADriverProc ) < 0 Then
      Begin
        WriteLn( 'Error registering driver : ',
                 GraphErrorMsg(GraphResult) );
        Halt( 100 )
      End;
    If RegisterBGIFont( @LittFontProc ) < 0 Then
      Begin
        WriteLn( 'Error registering font : ',
                 GraphErrorMsg(GraphResult) );
        Halt( 100 )
      End;

    grDriver := VGA; grMode := VGAHi;
    InitGraph( grDriver, grMode, '' );
    ErrCode := GraphResult;
    If ErrCode <> grOk Then
      Begin
        WriteLn( 'Graphics error : ', GraphErrorMsg(ErrCode) );
        Halt( 100 )
      End
  End;

Procedure CloseGraphix;
  Begin
    ClearDevice;
    CloseGraph
  End;

END.
