Unit Keyboard;

Interface

Const
  kbdNone       = $0000;


  kbdBack       = $0001;
  kbdTab        = $0002;
  kbdEnter      = $0003;
  kbdEscape     = $0004;
  kbdSpace      = $0005;


  kbdUpArrow    = $0100;
  kbdDownArrow  = $0101;
  kbdRightArrow = $0102;
  kbdLeftArrow  = $0103;
  kbdPageUp     = $0104;
  kbdPageDown   = $0105;

  kbdHome       = $0110;
  kbdEnd        = $0111;
  kbdInsert     = $0112;
  kbdDelete     = $0113;

  kbdF1         = $0150;
  kbdF2         = $0151;
  kbdF3         = $0152;
  kbdF4         = $0153;
  kbdF5         = $0154;
  kbdF6         = $0155;
  kbdF7         = $0156;
  kbdF8         = $0157;
  kbdF9         = $0158;
  kbdF10        = $0159;

Function GetKey( Var nextCh : Char ) : Word;

Implementation
Uses Crt;

Const
  codeBack   =  #8;
  codeTab    =  #9;
  codeEnter  = #13;
  codeEscape = #27;
  codeSpace  = #32;


  codeUpArrow    = #72;
  codeDownArrow  = #80;
  codeRightArrow = #77;
  codeLeftArrow  = #75;
  codePageUp     = #73;
  codePageDown   = #81;
  codeHome       = #71;
  codeEnd        = #79;
  codeInsert     = #82;
  codeDelete     = #83;

  codeF1  = #59;
  codeF2  = #60;
  codeF3  = #61;
  codeF4  = #62;
  codeF5  = #63;
  codeF6  = #64;
  codeF7  = #65;
  codeF8  = #66;
  codeF9  = #67;
  codeF10 = #68;


Function GetKey( Var nextCh : Char ) : Word;
  Var Ch : Char;
  Begin
    GetKey := kbdNone;

    nextCh := #0;
    Ch := ReadKey;

    Case Ch Of
      #0 :
        Case ReadKey Of
          codeUpArrow    : GetKey := kbdUpArrow;
          codeDownArrow  : GetKey := kbdDownArrow;
          codeRightArrow : GetKey := kbdRightArrow;
          codeLeftArrow  : GetKey := kbdLeftArrow;
          codePageUp     : GetKey := kbdPageUp;
          codePageDown   : GetKey := kbdPageDown;
          codeHome       : GetKey := kbdHome;
          codeEnd        : GetKey := kbdEnd;
          codeInsert     : GetKey := kbdInsert;
          codeDelete     : GetKey := kbdDelete;

          codeF1         : GetKey := kbdF1;
          codeF2         : GetKey := kbdF2;
          codeF3         : GetKey := kbdF3;
          codeF4         : GetKey := kbdF4;
          codeF5         : GetKey := kbdF5;
          codeF6         : GetKey := kbdF6;
          codeF7         : GetKey := kbdF7;
          codeF8         : GetKey := kbdF8;
          codeF9         : GetKey := kbdF9;
          codeF10        : GetKey := kbdF10;
        End;

      codeBack   : GetKey := kbdBack;
      codeTab    : GetKey := kbdTab;
      codeEnter  : GetKey := kbdEnter;
      codeEscape : GetKey := kbdEscape;
      codeSpace  : GetKey := kbdSpace;

      #32 .. #128 :
        nextCh := Ch
    End

  End;

END.
