Unit mouseUnit;

Interface

Type
  msButton = ( msbLeft, msbRight, msbMidd );
  msStatus = ( mssIdle, mssPressed, mssReleased, mssHeld );

  msCursorType = ( mcurDefault, mcurPen, mcurBucket, mcurHand );

Type
  TEvent =
    Record
      xMouse, yMouse : Word;
      buttClicked : msButton;
      mousePressed : Boolean;
      keyPressed : Word;
      keySecond : Char;
    End;

Type
  TMouse =
    Object
      Private
        btnCount : Word;
        isInit : Boolean;

        Bottoms : Word;
        pX, pY : Word;

        fCurrentCursor : msCursorType;
        fVisible : Boolean;

      Public
        Constructor Init;
        Destructor Done;

        Function GetX : Word;
        Function GetY : Word;
        Function GetButton : Word;

        Procedure msSetCursor( nCur : msCursorType );

        Procedure msOn;
        Procedure msOff;

        Function msQuery : Integer;
        Procedure msQuerm;

        Function msQuerp( Bottom : Word ) : Integer;
        Function msQuerr( Bottom : Word ) : Integer;

        Procedure msRangX( xmin, xmax : Word );
        Procedure msRangY( ymin, ymax : Word );
        Procedure msTForm( curType, msk1, msk2 : Word );

        Function GetEvent( Var Event : TEvent ) : Boolean;
    End;

Var
  mouse : TMouse;
  LastEvent : TEvent;

Implementation
Uses Crt, Dos, Keyboard;

Const
  Cursor : Array[ msCursorType ] Of
    Record
      HotSpot :
        Record
          X, Y : Word;
        End;
      screenMask : Array[ 0 .. 15 ] Of Word;
      cursorMask : Array[ 0 .. 15 ] Of Word;
    End =
    (
      (HotSpot : (X : 0; Y : 0);
       screenMask : ($3fff, $1fff, $0fff, $07ff, $03ff, $01ff, $00ff, $007f,
                     $003f, $001f, $01ff, $10ff, $30ff, $f87f, $f87f, $fc3f);
       cursorMask : ($0000, $4000, $6000, $7000, $7800, $7c00, $7e00, $7f00,
                     $7f80, $78c0, $7c00, $4600, $0600, $0300, $0300, $0180)),
      (HotSpot : (X : 1; Y : 15);
       screenMask : ($ffcf, $ff87, $ff03, $fe01, $fc03, $f807, $f00f, $e01f,
                     $c03f, $807f, $00ff, $01ff, $03ff, $07ff, $0fff, $9fff);
       cursorMask : ($0000, $0030, $0078, $009c, $01e8, $03f0, $07e0, $0fc0,
                     $1f80, $2700, $7a00, $5c00, $4800, $5000, $6000, $0000)),
      (HotSpot : (X : 14; Y : 14);
       screenMask : ($ffcf, $ff87, $fe03, $f803, $e001, $c001, $8000, $0000,
                     $0000, $8000, $8008, $8018, $c078, $c0f8, $c3f8, $e7f8);
       cursorMask : ($0000, $0030, $0048, $0188, $0604, $1804, $2002, $7ffe,
                     $7ffa, $3ff2, $3fe2, $3f82, $1f02, $1c02, $1802, $0000)),
      (HotSpot : (X : 4; Y : 0);
       screenMask : ($f3ff, $e1ff, $e1ff, $e1ff, $e001, $e000, $e000, $e000,
                     $8000, $0000, $0000, $0000, $0000, $0000, $8001, $c003);
       cursorMask : ($0c00, $1200, $1200, $1200, $13fe, $1249, $1249, $1249,
                     $7249, $9001, $9001, $9001, $8001, $8001, $4002, $3ffc))
    );

Constructor TMouse.Init;
  Var Regs : Registers;
  Begin
    isInit := True;
    Regs.ax := 0;
    Intr( $33, Regs );

    btnCount := Regs.bx;
    isInit := (isInit And (Regs.ax <> $0000));
    {
    msSetCursor( mcurDefault );
    }
    msSetCursor( mcurHand );
    fVisible := False
  End;

Destructor TMouse.Done;
  Begin
    msOff
  End;

Procedure TMouse.msOn;
  Var Regs : Registers;
  Begin
    If (not isInit) Or fVisible Then Exit;
    fVisible := True; Regs.ax := 1;
    Intr( $33, Regs )
  End;

Procedure TMouse.msOff;
  Var Regs : Registers;
  Begin
    If (not isInit) Or (not fVisible) Then Exit;
    fVisible := False; Regs.ax := 2;
    Intr( $33, Regs )
  End;

Function TMouse.GetX : Word;
  Begin
    GetX := pX
  End;
Function TMouse.GetY : Word;
  Begin
    GetY := pY
  End;
Function TMouse.GetButton : Word;
  Begin
    GetButton := 0
  End;

Function TMouse.msQuery : Integer;
  Var Regs : Registers;
  Begin
    msQuery := -1;
    If not isInit Then Exit;

    Regs.ax := 3;
    Intr( $33, Regs );
    pX := Regs.cx;
    pY := Regs.dx;
    Bottoms := Regs.bx;
    msQuery := Bottoms
  End;

Procedure TMouse.msQuerm;
  Var Regs : Registers;
  Begin
    If not isInit Then Exit;

    Regs.ax := $0b;
    Intr( $33, Regs );
    Bottoms := 0;
    pX := Regs.cx;
    pY := Regs.dx
  End;


{ Checks if mouse currently pressed }
Function TMouse.msQuerp( Bottom : Word ) : Integer;
  Var Regs : Registers;
  Begin
    msQuerp := -1;
    If not isInit Then Exit;

    Regs.ax := 5;
    Regs.bx := Bottom;
    Intr( $33, Regs );

    Bottoms := Regs.ax;
    pX := Regs.cx;
    pY := Regs.dx;
    msQuerp := Regs.bx
  End;

Function TMouse.msQuerr( Bottom : Word ) : Integer;
  Var Regs : Registers;
  Begin
    msQuerr := -1;
    If not isInit Then Exit;

    Regs.ax := 6;
    Regs.bx := Bottom;
    Intr( $33, Regs );

    Bottoms := Regs.ax;
    pX := Regs.cx;
    pY := Regs.dx;
    msQuerr := Regs.bx
  End;

Procedure TMouse.msRangX( xmin, xmax : Word );
  Var Regs : Registers;
  Begin
    If not isInit Then Exit;

    Regs.ax := 7;
    Regs.cx := xmin;
    Regs.dx := xmax;
    Intr( $33, Regs )
  End;

Procedure TMouse.msRangY( ymin, ymax : Word );
  Var Regs : Registers;
  Begin
    If not isInit Then Exit;

    Regs.ax := 8;
    Regs.cx := ymin;
    Regs.dx := ymax;
    Intr( $33, Regs )
  End;


Procedure TMouse.msTForm( curType, msk1, msk2 : Word );
  Var Regs : Registers;
  Begin
    Regs.ax := $0a;
    Regs.bx := curType;
    Regs.cx := msk1;
    Regs.dx := msk2;
    Intr( $33, Regs )
  End;

Procedure TMouse.msSetCursor( nCur : msCursorType );
  Var Regs : Registers;
  Begin
    If (not isInit) Or (fCurrentCursor = nCur) Then Exit;

    fCurrentCursor := nCur;
    Regs.bx := Word( Cursor[nCur].HotSpot.X );
    Regs.cx := Word( Cursor[nCur].HotSpot.Y );
    Regs.dx := Ofs( Cursor[nCur].screenMask );
    Regs.es := Seg( Cursor[nCur].screenMask );
    Regs.ax := 9;
    Intr( $33, Regs )
  End;

Function TMouse.GetEvent( Var Event : TEvent ) : Boolean;
  Var indx : msButton;
      nextCh : Char;
  Begin
    GetEvent := False;

    With Event Do
      If Crt.KeyPressed
        Then
          Begin
            mousePressed := False;
            keyPressed := GetKey(nextCh);
            keySecond := nextCh;
            GetEvent := True
          End
        Else
          Begin
            For indx := msbLeft To msbMidd Do
              If msQuerp( Ord(indx) ) = 1 Then
                Begin
                  mousePressed := True;
                  buttClicked := indx;
                  keyPressed := kbdNone;
                  xMouse := pX; yMouse := pY;
                  GetEvent := True; Break
                End
          End
  End;

END.
