Unit Square;

Interface
Uses Strings, mouseUnit;

Type
  PTSquare = ^TSquare;
  TSquare =
    Object

    Private
      ClrActive, ClrPassive : Word;
      next : PTSquare;

    Public
      xSt, ySt, xFn, yFn : Word;

      Function OwnWidth : Word;
      Function OwnHeight : Word;

      Constructor Init( pxSt, pySt, pxFn, pyFn : Word;
                  pcActive, pcPassive : Word );
      Destructor Done; Virtual;

      Function IsClicked( Var Event : TEvent ) : Boolean;
      Procedure SetColors( pActive, pPassive : Word );

      Procedure Show; Virtual;
      Procedure Clear; Virtual;

      Function HandleEvent( Var Event : TEvent ) : Boolean;
               Virtual;

      Function GetActive : Word;
      Function GetPassive : Word;
    End;

Type
  PTLabel = ^TLabel;
  TLabel =
    Object( TSquare )
      pStr : PShortStr;

      Constructor Init( pxSt, pySt, pxFn, pyFn : Word;
                  Const s : String );
      Destructor Done; Virtual;

      Procedure Show; Virtual;
    End;

Type
  PTGroup = ^TGroup;
  TGroup =
    Object
      First, Last : PTSquare;

      Constructor Init;
      Destructor Done; Virtual;

      Procedure Show;
      Procedure Insert( p : PTSquare );

      Function HandleEvent( Var Event : TEvent ) : Boolean;
    End;

Type
  PTScrollBar = ^TScrollBar;
  TScrollBar =
    Object( TSquare )
      Step : Word;
      sys : TGroup;

      Constructor Init( pxSt, pySt, pxFn, pyFn : Word;
                  pStep : Word );

      Procedure Show; Virtual;
      Procedure Clear; Virtual;
      Function HandleEvent( Var Event : TEvent ) : Boolean;
               Virtual;
    End;

  PTVertScrollBar = ^TVertScrollBar;
  TVertScrollBar =
    Object( TScrollBar )
      Constructor Init( pxSt, pySt : Word; Var pxFn, pyFn : Word;
                  pStep : Word );
    End;
  PTHorizScrollBar = ^THorizScrollBar;
  THorizScrollBar =
    Object( TScrollBar )
      Constructor Init( pxSt, pySt : Word; Var pxFn, pyFn : Word;
                  pStep : Word );
    End;


Implementation
Uses Graph, Keyboard, Button;

Constructor TSquare.Init( pxSt, pySt, pxFn, pyFn : Word;
            pcActive, pcPassive : Word );
  Begin
    xSt := pxSt; ySt := pySt; xFn := pxFn; yFn := pyFn;
    ClrActive := pcActive; ClrPassive := pcPassive;
    next := nil
  End;
Destructor TSquare.Done;
  Begin End;

Function TSquare.OwnWidth : Word;
  Begin OwnWidth := xFn - xSt End;
Function TSquare.OwnHeight : Word;
  Begin OwnHeight := yFn - ySt End;

Procedure TSquare.Show;
  Begin
    Clear;
    SetColor( ClrActive );
    Rectangle( xSt, ySt, xFn, yFn )
  End;
Procedure TSquare.Clear;
  Begin
    SetFillStyle( SolidFill, ClrPassive );
    Bar( xSt, ySt, xFn, yFn )
  End;

Function TSquare.IsClicked( Var Event : TEvent ) : Boolean;
  Begin
    IsClicked := False;
    With Event Do
      If buttClicked = msbLeft Then
          IsClicked := ((xMouse >= xSt) And (xMouse <= xFn) And
                        (yMouse >= ySt) And (yMouse <= yFn))
  End;

Function TSquare.HandleEvent( Var Event : TEvent ) : Boolean;
  Begin HandleEvent := False End;
Procedure TSquare.SetColors( pActive, pPassive : Word );
  Begin
    ClrActive := pActive; ClrPassive := pPassive
  End;

Function TSquare.GetActive : Word;
  Begin GetActive := ClrActive End;
Function TSquare.GetPassive : Word;
  Begin GetPassive := ClrPassive; End;



Constructor TLabel.Init( pxSt, pySt, pxFn, pyFn : Word;
            Const s : String );
  Begin
    TSquare.Init( pxSt, pySt, pxFn, pyFn, White, Black );
    New( pStr ); pStr^ := s
  End;
Destructor TLabel.Done;
  Begin
    Dispose( pStr );
    TSquare.Done
  End;

Procedure TLabel.Show;
  Begin
  End;



Constructor TGroup.Init;
  Begin
    First := nil; Last := nil
  End;
Destructor TGroup.Done;
  Var p, nxt : PTSquare;
  Begin
    p := First;
    While p <> nil Do
      Begin
        nxt := p^.next;
        Dispose( p, Done );
        p := nxt
      End
  End;

Procedure TGroup.Show;
  Var p : PTSquare;
  Begin
    p := First;
    While p <> nil Do
      Begin p^.Show; p := p^.next End
  End;

Procedure TGroup.Insert( p : PTSquare );
  Begin
    If First = nil Then First := p
    Else Last^.next := p; Last := p
  End;

Function TGroup.HandleEvent( Var Event : TEvent ) : Boolean;
  Var p : PTSquare;
  Begin
    p := First;
    While p <> nil Do
      Begin
        If p^.HandleEvent( Event ) Then
          Begin HandleEvent := True; Exit End;
        p := p^.next
      End;
    HandleEvent := False
  End;


Const
  ScrollZone = 25;

Constructor TScrollBar.Init( pxSt, pySt, pxFn, pyFn : Word;
            pStep : Word );
  Begin
    TSquare.Init( pxSt, pySt, pxFn, pyFn, White, LightGray );
    sys.Init; Step := pStep
  End;

Procedure TScrollBar.Show;
  Begin
    TSquare.Show;
    sys.Show
  End;

Procedure TScrollBar.Clear;
  Begin
    SetFillStyle( XHatchFill, ClrPassive );
    Bar( xSt, ySt, xFn, yFn )
  End;


Function TScrollBar.HandleEvent( Var Event : TEvent ) : Boolean;
  Begin HandleEvent := sys.HandleEvent(Event) End;


Constructor TVertScrollBar.Init( pxSt, pySt : Word;
            Var pxFn, pyFn : Word; pStep : Word );
  Var pnext : PTButton;
      CoorX, CoorY : Word;
  Begin
    pxFn := pxSt + GetWidest('Up', 'Dn') + btnWindowed + 2 * strFresh;
    pyFn := pySt + 2 * (TextHeight('W') + btnWindowed + strFresh) + ScrollZone;

    TScrollBar.Init( pxSt, pySt, pxFn, pyFn, pStep );

    New( pnext, Init(pxSt + strFresh, pySt + strFresh, CoorX, CoorY,
         'Up', kbdNone, btnWindowed, noneAction) );
    sys.Insert( pnext );
    New( pnext, Init(pxSt + strFresh, CoorY + ScrollZone, CoorX, CoorY,
         'Dn', kbdNone, btnWindowed, noneAction) );
    sys.Insert( pnext )
  End;


Constructor THorizScrollBar.Init( pxSt, pySt : Word; Var pxFn, pyFn : Word;
            pStep : Word );
  Var pnext : PTButton;
      CoorX, CoorY : Word;
  Begin
    pxFn := pxSt + TextWidth('Lt') + TextWidth('Rg') + 2 * (btnWindowed + strFresh) + ScrollZone;
    pyFn := pySt + GetTallest('Lt', 'Rg') + btnWindowed + 2 * strFresh;
    TScrollBar.Init( pxSt, pySt, pxFn, pyFn, pStep );

    New( pnext, Init(pxSt + strFresh, pySt + strFresh, CoorX, CoorY,
         'Lt', kbdNone, btnWindowed, noneAction) );
    sys.Insert( pnext );
    New( pnext, Init(CoorX + ScrollZone, pySt + strFresh, CoorX, CoorY,
         'Rg', kbdNone, btnWindowed, noneAction) );
    sys.Insert( pnext )
  End;

END.
