.model tiny

locals

CR              equ 13
LF              equ 10
EOLN            equ CR,LF
EOF             equ -1

.code
.startup
                mov ah,3Ch              ;ᮧ 䠩
                xor cx,cx
                lea dx,FileName
                call DosFunc
                mov File,ax

                mov ah,40h              ;  䠩 ⮢ 
                lea dx,TestData
                mov cx,DATA_SIZE
                call FileFunc

;----- 뢮 ப   ஬ -----
                lea dx,Prompt1
                call SeekLine
                call Writeln

;-----  ᨬ -----
                lea dx,Prompt2
                call SeekLine
                lea dx,Prompt2_1
                call ReadChar
                mov c1,al
                lea dx,Prompt2_2
                call ReadChar
                mov c2,al
l2_1:
                call FileReadChar
                cmp ax,EOF
                je l2_2
                cmp al,LF
                je l2_2
                cmp al,c1
                jne l2_1
                mov al,c2
                call FileChangeChar
                jmp l2_1
l2_2:
                call Writeln

;----- 뢮 ᫮   ஬ -----
                lea dx,Prompt3
                call SeekLine
                lea dx,Prompt3_1
                call ReadWord
                mov i,ax
l3_1:
                call ReadLineChar
                cmp al,' '
                je l3_1
                cmp al,9
                je l3_1
                dec i
                jz l3_3
l3_2:
                call ReadLineChar
                cmp al,' '
                je l3_1
                cmp al,9
                je l3_1
                jmp l3_2
l3_3:
                cmp ax,EOF
                je l3_4
                cmp al,LF
                je l3_4
                cmp al,' '
                je l3_4
                cmp al,9
                je l3_4
                mov dl,al
                call WriteChar
                call FileReadChar
                jmp l3_3
l3_4:
                call Writeln
                call Writeln

;----- ஢ ப  䠩 -----
                lea dx,Prompt4
                call SeekLine
                mov ah,3Ch
                xor cx,cx
                lea dx,FileName2
                call DosFunc
                mov File2,ax
l4_1:
                call FileReadChar
                cmp ax,EOF
                je l4_2
                mov c1,al
                mov ah,40h
                mov bx,File2
                mov cx,1
                lea dx,c1
                call DosFunc
                cmp c1,LF
                jne l4_1
l4_2:
                mov ah,3Eh
                mov bx,File2
                call DosFunc

                call FileFlush          ; 
                mov ah,3Eh              ;⨥ 䠩
                call FileFunc
Exit:
                mov ax,4C00h            ;室
                int 21h

;----- ࠡ⪠ 訡 짮⥫ -----
EofReached:
                lea dx,MsgEof
                mov ah,9
                int 21h
                mov ax,4C01h
                int 21h
EolnReached:
                lea dx,MsgEoln
                mov ah,9
                int 21h
                jmp Exit

;   ப,  ப, 뢮   ࠭
SeekLine        proc
                call ReadWord
                push ax
                call FileSeekLine
                or ax,ax
                jnz EofReached
@@1:
                call FileReadChar
                cmp ax,EOF
                je @@Eof
                mov dl,al
                call WriteChar
                cmp al,LF
                je @@Exit
                jmp @@1
@@Eof:
                call Writeln
@@Exit:
                pop ax
                call FileSeekLine
                ret
SeekLine        endp

ReadLineChar    proc
                call FileReadChar
                cmp ax,EOF
                je EofReached
                cmp al,LF
                je EolnReached
                ret
ReadLineChar    endp

DosError:
                lea dx,MsgDOSError
                mov ah,9
                int 21h
                mov ax,4C01h
                int 21h

;⥬ 맮 DOS  墠⮬ 訡
DosFunc         proc
                int 21h
                jc DosError
                ret
DosFunc         endp

; ⥬ 맮 DOS  墠⮬ 訡
FileFunc        proc
                mov bx,File
                int 21h
                jc DosError
                ret
FileFunc        endp

;  
FileFlush       proc
                cmp Modified,0
                je @@Exit
                mov ax,4200h
                mov dx,BaseOfsL
                mov cx,BaseOfsH
                call FileFunc
                mov ah,40h
                lea dx,Buffer
                mov cx,BytesRead
                call FileFunc
                mov Modified,0
@@Exit:
                ret
FileFlush       endp

;ਧ ᨬ쭮 ⥭  䠩
FileReadChar    proc
                mov bx,BufPos
                cmp bx,BytesRead
                jb @@1
                call FileFlush
                mov ax,BytesRead
                add BaseOfsL,ax
                adc BaseOfsH,0
                mov ah,3Fh
                lea dx,Buffer
                mov cx,BUF_SIZE
                call FileFunc
                mov BytesRead,ax
                or ax,ax
                jz @@Eof
                xor bx,bx
@@1:
                mov al,Buffer[bx]
                xor ah,ah
                inc bx
                mov BufPos,bx
                ret
@@Eof:
                mov ax,EOF
                ret
FileReadChar    endp

;   ᫥ ⠭ ᨬ
FileChangeChar  proc
                mov bx,BufPos
                mov Buffer[bx-1],al
                mov Modified,1
                ret
FileChangeChar  endp

;⠭ 㪠⥫ 樨  砫 䠩
FileRewind      proc
                call FileFlush
                mov ax,4200h
                xor cx,cx
                xor dx,dx
                call FileFunc
                xor ax,ax
                mov BaseOfsL,ax
                mov BaseOfsH,ax
                mov BufPos,ax
                mov BytesRead,ax
                ret
FileRewind      endp

; ப 䠩  ஬,   AX
FileSeekLine    proc
                push bp
                mov bp,sp
                sub sp,2
Line            = word ptr [bp-2]

                mov Line,ax
                call FileRewind
@@1:
                dec Line
                jz @@Exit
@@2:
                call FileReadChar
                cmp ax,EOF
                je @@Exit
                cmp al,LF
                jne @@2
                jmp @@1
@@Exit:
                mov ax,Line
                mov sp,bp
                pop bp
                ret
FileSeekLine    endp

;----- 楤 ᮫쭮 -뢮 -----

;室   ப
Writeln         proc
                mov dl,13
                call WriteChar
                mov dl,10
                call WriteChar
                ret
Writeln         endp

;뢮 ᨬ,     DL
WriteChar       proc
                push ax
                mov ah,2
                int 21h
                pop ax
                ret
WriteChar       endp

;⥭ ᨬ (AL =  ⠭ ᨬ)
ReadChar        proc
                mov ah,9
                int 21h
                mov ah,1
                int 21h
                call Writeln
                ret
ReadChar        endp

;⥭ 16-ࠧ來  楫 (AX =  祭)
ReadWord        proc
                push bp
                mov bp,sp
                sub sp,2
Result          = word ptr [bp-2]

                mov ah,9
                int 21h

                mov Result,0
@@1:
                mov ah,8
                int 21h
                cmp al,13
                je @@2
                cmp al,'0'
                jb @@1
                cmp al,'9'
                ja @@1
                mov dx,ax
                call WriteChar
                sub al,'0'
                xor ah,ah
                xchg cx,ax
                mov ax,10
                mul Result
                add ax,cx
                mov Result,ax
                jmp @@1
@@2:
                call Writeln
                mov ax,Result
                mov sp,bp
                pop bp
                ret
ReadWord        endp

.const
FileName        db 'data.txt',0
FileName2       db 'output.txt',0

Prompt1         db ' ப,  室 뢥  ࠭> $'
Prompt2         db ' ப,  室  ᨬ> $'
Prompt2_1       db ' ᨬ> $'
Prompt2_2       db ' ᨬ> $'
Prompt3         db ' ப, ᮤঠ饩 ᫮> $'
Prompt3_1       db ' ᫮> $'
Prompt4         db ' ப,  㤥 ࠭  䠩 "output.txt"> $'

MsgEof          db '⨣  䠩',13,10,'$'
MsgEoln         db '⨣  ப',13,10,'$'

TestData        db '.model tiny',EOLN
                db '.code',EOLN
                db '.startup',EOLN
                db '                lea dx,Msg',EOLN
                db '                mov ah,9',EOLN
                db '                int 21h',EOLN
                db '                ret',EOLN
                db EOLN
                db 'Msg             db "Hello, World!",13,10,"$"',EOLN
                db EOLN
                db 'end'
DATA_SIZE       equ $-TestData

MsgDOSError     db '訡  ࠡ  䠩',13,10,'$'

.data

BaseOfsL        dw 0    ;ᬥ饭  ⭮⥫쭮 砫 䠩
BaseOfsH        dw 0
BufPos          dw 0    ;⥪饥 ᬥ饭  
BytesRead       dw 0    ;⢮ ⠭ 
Modified        db 0    ;ਧ 䨪樨  

.data?

i               dw ?
c1              db ?
c2              db ?

File            dw ?    ;᪨  (handle) 䠩
File2           dw ?

Buffer          db 4096 dup(?)  ; -뢮
BUF_SIZE        equ $-Buffer    ; ࠧ

end