unit xboard;

INTERFACE {--------------------------------------------------}

uses dos,xconsole,xfantom,xconst;

Type board = object(fantom)
     rsx,rsy,rex,rey,rht,rwh,
     cx,cy: byte;
     b:  pointer;
     constructor init(x,y,h,w: byte; s: string; pal: palptr; stat: byte);
     destructor done;
     procedure show; virtual;
     procedure hide; virtual;
     procedure select; virtual;
     procedure unselect; virtual;
     procedure cls;
     procedure locate(x,y: byte);
     procedure roll(up: boolean);
     procedure lf;
     procedure printf(s: string; f: char; var v);
     procedure readf(s: string; f: char; var v);
     procedure get(var v: string);
     procedure put(v: string);
end;

IMPLEMENTATION {------------------------------------------------------}

constructor board.init(x,y,h,w: byte; s: string; pal: palptr; stat: byte);
begin
       state:=stat;
       sx:=x;
       rsx:=x;
       sy:=y;
       rsy:=y;
       cx:=x;
       cy:=y;
       ht:=h;
       rht:=h;
       wh:=w;
       rwh:=w;
       ex:=x+w-1;
       ey:=y+h-1;
       name:=s;

       if pal <> nil then p:=pal;

       if (state and FShadow) <> 0 then
           begin
                inc(rht);
                inc(rwh);
           end;

       if (state and FFrame) <> 0 then
           begin
                inc(rht,2);
                inc(rwh,2);
                dec(rsy);
                dec(rsx);
           end;

       rex:=rsx+rwh-1;
       rey:=rsy+rht-1;
end;

destructor board.done; begin end;

procedure board.show;
var a:char;
begin


       if (state and FActiv) <> 0
          then
              exit
          else
              state:=(state or FActiv);

       if (state and FSolid) = 0
         then
           begin
                  getmem(b,rht*rwh*2);
		              save(rsx,rsy,rht,rwh,b);
           end;

       fill(sx,sy,ht,wh,' ');

       if (state and FColor) <> 0
          then paint(sx,sy,ht,wh,p^.txt);

       if (state and FFrame) <> 0
          then
             begin
                if (state and FColor) <> 0
                   then outlina(sx,sy,ht,wh,p^.border)
                   else outline(sx,sy,ht,wh);

                puts(sx-1+(ex-sx-length(name)) div 2, sy-1, name);
             end;

       if (state and FShadow) <> 0
          then
             begin
                  paint(rex,rsy+1,rht-1,1,$08);
                  paint(rsx+1,rey,1,rwh-1,$08);
             end;

      goto_xy(sx,sy);

end;

procedure board.hide;
begin


       if (state and FActiv) = 0
          then
              exit
          else
              state:=(state and (not FActiv));

       if (state and FSolid) <> 0
          then exit;

       restore(rsx,rsy,rht,rwh,b);
       freemem(b,rwh*rht*2);

end;


procedure board.select;
begin
       if (state and FFrame) <> 0
          then puts(sx,sy-1,'');
                {
                  puta(sx+1,sy-1,(geta(sx+1,sy-1)+128));
                }
       goto_xy(cx,cy);
end;

procedure board.unselect;
begin
       if (state and FFrame) <> 0
          then puts(sx,sy-1,'');
            {
              puta(sx+1,sy-1,(geta(sx+1,sy-1)-128));
            }
end;

procedure board.cls;
begin
      if (state and FActiv) = 0 then exit;

      cx:=sx;
      cy:=sy;
      fill(sx,sy,ht,wh,' ');
      if (state and FColor) <> 0 then paint(sx,sy,ht,wh,p^.txt);
      goto_xy(sx,sy);
end;

procedure board.locate(x,y: byte);
begin
      cx:=sx+x;
      cy:=sy+y;
      goto_xy(cx,cy);
end;

procedure board.roll(up: boolean);
begin
      scroll(sx,sy,ht,wh,p^.txt,up);
end;

procedure board.lf;
begin
      if cy < ey
        then
          inc(cy)
        else
          roll(true);
     cx:=sx;
     goto_xy(cx,cy);
end;


procedure board.printf(s: string; f: char; var v);
var sv: string absolute v;
    iv: integer absolute v;
    rv: real absolute v;
    ss: string;
begin
      puts(cx,cy,s);
      cx:=cx+length(s);

      case f of
          's': put(sv);
          'i': begin
                    str(iv,ss);
                    put(ss);
               end;
          'r': begin
                    str(rv,ss);
                    put(ss);
               end;
      end;

end;


procedure board.readf(s: string; f: char; var v);
var sv: string absolute v;
    iv: integer absolute v;
    rv: real absolute v;
    ss: string;
    ii: integer;
begin
      puts(cx,cy,s);
      cx:=cx+length(s);
      get(ss);

      case f of
          's': sv:=ss;
          'i': val(ss,iv,ii);
          'r': val(ss,rv,ii);
      end;

end;

procedure board.put(v: string);
begin
      puts(cx,cy,v);
      lf;
end;

procedure board.get(var v: string);
begin
     edit(cx,cy,1,ex-cx+1);
     v:=scan(cx,cy,1,ex-cx+1);
     lf;
end;

begin
end.