Unit XConsole;

INTERFACE   {----------------------------------------------}
uses dos;

Type
     screenchar = record
       c: char;
       a: byte;
     end;

     screen = array [0..1999] of screenchar;
     txtbuf = ^screen;

Const
    ScrollUp = true;
    ScrollDn = false;

 TAB=#9;

 UP=#72;
 RIGHT=#77;
 DOWN=#80;
 LEFT=#75;

 HOME=#71;
 ENDkey=#79;

 INSERT=#82;
 DELETE=#83;

 ENTER=#13;
 ESC=#27;

 PAGE_UP=#73;
 PAGE_DOWN=#81;

 F1=#59;
 F2=#60;
 F3=#61;
 F4=#62;
 F5=#63;
 F6=#64;
 F7=#65;
 F8=#66;
 F9=#67;
 F10=#68;

 ALT_F1=#104;
 ALT_F2=#105;
 ALT_F3=#106;
 ALT_F4=#107;
 ALT_F5=#108;
 ALT_F6=#109;
 ALT_F7=#110;
 ALT_F8=#111;
 ALT_F9=#112;
 ALT_F10=#113;

 SHIFT_F1=#84;
 SHIFT_F2=#85;
 SHIFT_F3=#86;
 SHIFT_F4=#87;
 SHIFT_F5=#88;
 SHIFT_F6=#89;
 SHIFT_F7=#90;
 SHIFT_F8=#91;
 SHIFT_F9=#92;
 SHIFT_F10=#93;

 CTRL_F1=#94;
 CTRL_F2=#95;
 CTRL_F3=#96;
 CTRL_F4=#97;
 CTRL_F5=#98;
 CTRL_F6=#99;
 CTRL_F7=#100;
 CTRL_F8=#101;
 CTRL_F9=#102;
 CTRL_F10=#103;

 CTRL_END=#117;

 ALT_X=#45;
 SPACE=#32;
 BACKSPACE=#8;

Var
    txtscr: screen absolute $B800:0000;
    REGS: registers;

procedure putc(x,y: byte; c: char);
procedure puta(x,y,a: byte);
procedure putca(x,y: byte; c: char; a: byte);
procedure puts(x,y: byte; s: string);
procedure putsa(x,y: byte; s: string; a: byte);
function  getc(x,y: byte): char;
function  geta(x,y: byte): byte;
procedure fill(x,y,h,w: byte; c: char);
procedure paint(x,y,h,w,a: byte);
procedure outline(x,y,h,w: byte);
procedure outlina(x,y,h,w,a: byte);
Procedure Scroll(x,y,h,w,a: byte; up: boolean);
Procedure goto_xy(x,y: byte);
Procedure Hide_Cursor;
procedure save(x,y,h,w: byte; p: pointer);
procedure restore(x,y,h,w: byte; p: pointer);
function  read_key: char;
function  read_kbd(var special: boolean): char;
procedure clr_scr;
procedure edit(x,y,h,w: byte);
function scan(x,y,h,w: byte): string;

IMPLEMENTATION  {----------------------------------------------------}

procedure putc(x,y: byte; c: char);
begin
      txtscr[x+80*y].c:=c;
end;

procedure puta(x,y,a: byte);
begin
      txtscr[x+80*y].a:=a;
end;

procedure putca(x,y: byte; c: char; a: byte);
begin
      txtscr[x+80*y].c:=c;
      txtscr[x+80*y].a:=a;
end;

procedure puts(x,y: byte; s: string);
var i: byte;
begin
    for i:=1 to length(s) do
      begin
          txtscr[(x+i-1)+(80*y)].c:=s[i];
      end;
end;

procedure putsa(x,y: byte; s: string; a: byte);
var i: byte;
begin
    for i:=1 to length(s) do
      begin
          txtscr[(x+i-1)+(80*y)].c:=s[i];
          txtscr[(x+i-1)+(80*y)].a:=a;
      end;
end;

function getc(x,y: byte): char;
begin
    getc:=txtscr[x+80*y].c;
end;

function geta(x,y: byte): byte;
begin
    geta:=txtscr[x+80*y].a;
end;

procedure fill(x,y,h,w: byte; c: char);
var ix,iy: byte;
begin
    for ix:=0 to w-1 do
        for iy:=0 to h-1 do
           txtscr[x+ix+80*(y+iy)].c:=c;
end;

procedure paint(x,y,h,w,a: byte);
var ix,iy: byte;
begin
    for ix:=0 to w-1 do
        for iy:=0 to h-1 do
           txtscr[x+ix+80*(y+iy)].a:=a;
end;

procedure outline(x,y,h,w: byte);
var ix,iy: byte;
begin
    putc(x-1,y-1,'');
    putc(x-1,y+h,'');
    putc(x+w,y-1,'');
    putc(x+w,y+h,'');

    for ix:=x to x+w-1 do
      begin
          putc(ix,y-1,'');
          putc(ix,y+h,'');
      end;

    for iy:=y to y+h-1 do
      begin
          putc(x-1,iy,'');
          putc(x+w,iy,'');
      end;
end;

procedure outlina(x,y,h,w,a: byte);
var ix,iy: byte;
begin
    putca(x-1,y-1,'',a);
    putca(x-1,y+h,'',a);
    putca(x+w,y-1,'',a);
    putca(x+w,y+h,'',a);

    for ix:=x to x+w-1 do
      begin
	  putca(ix,y-1,'',a);
	  putca(ix,y+h,'',a);
      end;

    for iy:=y to y+h-1 do
      begin
	  putca(x-1,iy,'',a);
	  putca(x+w,iy,'',a);
      end;
end;


procedure videoint;
begin
   inline($55);
   intr($10,regs);
   inline($5D);
end;

Procedure Scroll(x,y,h,w,a: byte; up: boolean);
begin
   if up then REGS.ah:=6
         else REGS.ah:=7;
   REGS.al:=1;
   REGS.ch:=y;
   REGS.cl:=x;
   REGS.dh:=y+h-1;
   REGS.dl:=x+w-1;
   REGS.bh:=a;
   videoint;
end;

Procedure goto_xy(x,y: byte);
begin
  REGS.ah:=2;
  REGS.bh:=0;
  REGS.dh:=y;
  REGS.dl:=x;
  videoint;
end;

procedure save(x,y,h,w: byte; p: pointer);
var bufptr: txtbuf absolute p;
    ix,iy: byte;
    iz: word;
begin
       iz:=0;
       for ix:=x to x+w-1 do
          for iy:=y to y+h-1 do
            begin
                   bufptr^[iz].c:=getc(ix,iy);
                   bufptr^[iz].a:=geta(ix,iy);
                   inc(iz);
            end;
end;

procedure restore(x,y,h,w: byte; p: pointer);
var bufptr: txtbuf absolute p;
    ix,iy: byte;
    iz: word;
begin
       iz:=0;
       for ix:=x to x+w-1 do
          for iy:=y to y+h-1 do
            begin
                   putc(ix,iy,bufptr^[iz].c);
                   puta(ix,iy,bufptr^[iz].a);
                   inc(iz);
            end;
end;

Procedure Hide_Cursor;
begin
  REGS.ah:=2;
  REGS.bh:=0;
  REGS.dh:=25;
  REGS.dl:=0;
  videoint;
end;

function read_key: char;
begin
      REGS.ah := 7;
      intr($21,REGS);
      read_key := chr(REGS.al);
end;

function read_kbd(var special: boolean): char;
var key: char;
begin
      key:=read_key;
      if key = #0 then
	 begin
	       key:=read_key;
	       special:=true;
	 end
      else special:=false;
      read_kbd:=key;
end;

procedure clr_scr;
var ix,iy: byte;
begin
    for ix:=0 to 79 do
        for iy:=0 to 24 do
          begin
           txtscr[ix+80*iy].a:=$07;
           txtscr[ix+80*iy].c:=' ';
         end;
end;

procedure edit(x,y,h,w: byte);
var
   crx,cry,ix,ex,ey: byte;
   anykey: char;
   special: boolean;

begin
   crx:=x;
   cry:=y;
   goto_xy(x,y);
   ex:=x+w-1;
   ey:=y+h-1;

   repeat
             anykey:=read_kbd(special);
             if special
               then
                   case anykey of
                       HOME:  crx:=x;
                      ENDkey: crx:=ex;
                       LEFT:  if crx>x then dec(crx);
                       RIGHT: if crx<ex then inc(crx);
                       UP:    if cry>y then dec(cry);
                       DOWN:  if cry<ey then inc(cry);
                     DELETE:  begin
                                for ix:=crx to ex-1 do
                                   putc(ix,cry,getc(ix+1,cry));
                                putc(ex,cry,' ');
                              end;
                       else;
                   end
               else
                 case anykey of
                       ENTER: exit;
                   BACKSPACE: if crx>x then
                                begin
                                  dec(crx);
                                  putc(crx,cry,' ');
                                end;
                       else   begin
                                for ix:=ex downto crx+1 do
                                   putc(ix,cry,getc(ix-1,cry));
                                putc(crx,cry,anykey);
                                if crx<ex then inc(crx)
                                  else if cry<ey then
                                       begin
                                           inc(cry);
                                           crx:=x;
                                       end;
                              end;
                 end;

       goto_xy(crx,cry);

   until false;

end;

function scan(x,y,h,w:byte): string;
 var ix,iy,ex,ey: shortint;
     s: string;
 procedure next;
 begin
       dec(ix);
       if ix<x then
         begin
             ix:=ex;
             dec(iy);
         end;
 end;
begin
       ex:=x+w-1;
       ey:=y+h-1;
       ix:=ex;
       iy:=ey;
       s:='';

       while getc(ix,iy) = ' ' do
         begin
             next;
             if iy<y then
               begin
                   scan:=s;
                   exit;
               end;
         end;

       repeat
                  s:=getc(ix,iy)+s;
                  next;
                  if iy<y then
                    begin
                      scan:=s;
                      exit;
                  end;
       until false
end;

begin
end.