unit xitem;
INTERFACE
uses xconsole,xconst,xfantom,xboard;

{ ࠪ oꥪ ⨯ ITEM }

Type itemptr = ^item;

  item = object(fantom)
     f,c: itemptr;
     constructor init;
     destructor done;
     procedure show; virtual;
     procedure hide; virtual;
     procedure select; virtual;
     procedure unselect; virtual;
     function go: byte; virtual;
end;

  group = object(item)
     head,tail,now,wrk:   itemptr;
     w: board;
     constructor init(x,y: byte; s: string; pal: palptr; stat: byte);
     destructor done;
     procedure show; virtual;
     procedure hide; virtual;
     procedure select; virtual;
     procedure unselect; virtual;
     function go: byte; virtual;
     procedure insert(it: itemptr); virtual;
     procedure goup; virtual;
     procedure godown; virtual;
     procedure gotop;  virtual;
     procedure gobottom; virtual;
     procedure complete; virtual;
end;


IMPLEMENTATION

constructor item.init; begin end;
destructor  item.done; begin end;
procedure   item.show; begin end;
procedure   item.hide; begin end;
procedure   item.select; begin end;
procedure   item.unselect; begin end;
function    item.go; begin go:=cmOK; end;

constructor group.init(x,y: byte; s: string; pal: palptr; stat: byte);
begin
     sx:=x;
     sy:=y;
     ex:=sx;
     ey:=sy;

     p:=pal;

     state:=stat;

     name:=s;

     new(head,init);
     tail:=head;
     now:=nil;
end;

destructor  group.done; begin end;

procedure   group.show;
begin

       if (state and FActiv) <> 0
          then
            begin
              exit;
            end;

       w.show;
       state:=(state or FActiv);

       wrk:=head^.c;

       repeat
              wrk^.show;
              wrk:=wrk^.c;
       until
             wrk=head^.c;

       hide_cursor;
end;

procedure   group.hide;
begin

       if (state and FActiv) = 0
          then
            begin
              exit;
            end
          else
            begin
              wrk:=head^.c;

              repeat
                    wrk^.hide;
                    wrk:=wrk^.c;
             until
                  wrk=head^.c;

              w.hide;
              state:=(state and (not FActiv));
            end;

end;

procedure   group.select;
begin
     w.select;
     hide_cursor;
     { now^.select; }
end;

procedure   group.unselect;
begin
     w.unselect;
     { now^.unselect }
end;

function    group.go;
var cmd: byte;
begin
     if (state and FAuto) <> 0 then show;
     select;

Repeat

     now^.select;

     cmd:=now^.go;

     case cmd of
       cmNext: godown;
   cmPrevious: goup;
       cmHome: gotop;
        cmEnd: gobottom;
         else  begin
                   unselect;
                   if (state and FAuto) <> 0 then hide;
                   go:=cmd;
                   exit;
               end;
     end;

Until FALSE;

end;

procedure   group.goup;
begin
     now^.unselect;
     now:=now^.f;
     now^.select;
end;

procedure   group.gotop;
begin
     now^.unselect;
     now:=head^.c;
     now^.select;
end;

procedure   group.godown;
begin
     now^.unselect;
     now:=now^.c;
     now^.select;
end;

procedure   group.gobottom;
begin
     now^.unselect;
     now:=tail;
     now^.select;
end;

procedure   group.insert(it: itemptr);
begin
      tail^.c:=it;
      it^.f:=tail;
      it^.c:=head^.c;
      tail:=it;
      head^.c^.f:=tail;
end;

procedure group.complete;
begin
     now:=head^.c;

     ex:=sx;
     ey:=sy;

     repeat

           if ex < now^.ex then ex:=now^.ex;
           if ey < now^.ey then ey:=now^.ey;

           now:=now^.c;

     until now = head^.c;

     wh:=ex-sx+1;
     ht:=ey-sy+1;

     w.init(sx,sy,ht,wh,name,p,state);
end;

begin

end.