unit xmenu;
interface
uses xconsole,xconst,xfantom,xitem,xboard;

type option = object(item)
     rc: byte;
     constructor init(x,y: byte; s: string; pt: palptr; code: byte);
     destructor done;
     procedure show; virtual;
     procedure select; virtual;
     procedure unselect; virtual;
     function go: byte; virtual;
end;

      menuptr = ^menu;

   subentry = object(option)
     sm: menuptr;
     constructor init(x,y: byte; s: string; pt: palptr; m: menuptr);
     destructor done;
     function go: byte; virtual;
   end;

   menu = object(group)
     column: boolean;
     constructor init(x,y: byte; s: string; pt: palptr; st: byte; clmn: boolean);
     destructor done;
     procedure addoption(s: string; retcode: byte);
     procedure addsub(s: string; m: menuptr);
   end;


implementation

constructor option.init(x,y: byte; s: string; pt: palptr; code: byte);
begin
     f:=nil;
     c:=nil;
     sx:=x;
     sy:=y;
     ey:=y;
     ht:=1;
     wh:=length(s);
     ex:=sx+wh-1;
     name:=s;
     p:=pt;
     rc:=code;
end;

destructor option.done; begin end;

procedure option.show;
begin
     puts(sx,sy,name);
     paint(sx,sy,ht,wh,p^.txt);
end;

procedure option.select;
begin
     paint(sx,sy,ht,wh,p^.marker);
end;

procedure option.unselect;
begin
     paint(sx,sy,ht,wh,p^.txt);
end;

function option.go: byte;
var hit: char;
   spec: boolean;
begin
     repeat
                 hit:=read_kbd(spec);

                 if spec
                    then
                        case hit of
                         LEFT,
                           UP: begin
                                   go:=cmPrevious;
                                   exit;
                               end;
                        RIGHT,
                         DOWN: begin
                                   go:=cmNext;
                                   exit;
                               end;
                         HOME: begin
                                   go:=cmHOME;
                                   exit;
                               end;
                       ENDkey: begin
                                   go:=cmEND;
                                   exit;
                               end;
                         else;
                        end
                    else
                        case hit of
                            ESC: begin
                                     go:=cmCancel;
                                     exit;
                                 end;
                          ENTER: begin
                                     go:=rc;
                                     exit;
                                 end;
                            else;
                        end;
     until false;
end;

constructor subentry.init(x,y: byte; s: string; pt: palptr; m: menuptr);
begin
     f:=nil;
     c:=nil;
     sx:=x;
     sy:=y;
     ey:=y;
     ht:=1;
     wh:=length(s);
     ex:=sx+wh-1;
     name:=s;
     p:=pt;
     sm:=m;
end;

destructor subentry.done; begin end;

function subentry.go: byte;
var hit: char;
   spec: boolean;
begin
     repeat
                 hit:=read_kbd(spec);

                 if spec
                    then
                        case hit of
                         LEFT,
                           UP: begin
                                   go:=cmPrevious;
                                   exit;
                               end;
                        RIGHT,
                         DOWN: begin
                                   go:=cmNext;
                                   exit;
                               end;
                         HOME: begin
                                   go:=cmHOME;
                                   exit;
                               end;
                       ENDkey: begin
                                   go:=cmEND;
                                   exit;
                               end;
                         else;
                        end
                    else
                        case hit of
                            ESC: begin
                                     go:=cmCancel;
                                     exit;
                                 end;
                          ENTER: begin
                                     go:=sm^.go;
                                     exit;
                                 end;
                            else;
                        end;
     until false;
end;


constructor menu.init(x,y: byte;
                      s: string; pt: palptr; st: byte; clmn: boolean);
begin
       state:=st;
       column:=clmn;
       sx:=x;
       ex:=x;
       sy:=y;
       ey:=y;
       name:=s;

       new(head);
       head^.c:=nil;
       tail:=head;
       now:=nil;

       p:=pt;
end;

destructor menu.done;
begin
end;

procedure menu.addoption(s: string; retcode: byte);
var it: ^option;
begin
       new(it,init(ex,ey,s,p,retcode));
       insert(it);

       if column then inc(ey)
                 else ex:=it^.ex+2;
end;

procedure menu.addsub(s: string; m: menuptr);
var it: ^subentry;
begin
       new(it,init(ex,ey,s,p,m));
       insert(it);

       if column then inc(ey)
                 else ex:=it^.ex+2;
end;

begin

end.