unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMSystem, WaveIn, WaveOut;

const
  TmpFile = 'wavedata.tmp';

type
  TfrmMain = class(TForm)
    btRecord: TButton;
    btPlay: TButton;
    btStop: TButton;
    btExit: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btRecordClick(Sender: TObject);
    procedure btStopClick(Sender: TObject);
    procedure btPlayClick(Sender: TObject);
    procedure btExitClick(Sender: TObject);
  private
    { Private declarations }
    Tmp: TFileStream;
    WaveIn: TWaveIn;
    WaveOut: TWaveOut;
    procedure WaveInRead(const Buf: TWaveHdr);
    procedure WaveOutRender(var Buf: TWaveHdr);
    procedure SetEnabled(Stopped: Boolean);
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.WaveInRead(const Buf: TWaveHdr);
begin
  Tmp.Write(Buf.lpData^, Buf.dwBytesRecorded);
end;

procedure TfrmMain.WaveOutRender(var Buf: TWaveHdr);
begin
  if Tmp.Position >= Tmp.Size then
    btStopClick(Self)
  else
    Tmp.Read(Buf.lpData^, Buf.dwBufferLength);
end;

procedure TfrmMain.SetEnabled(Stopped: Boolean);
begin
  btPlay.Enabled := Stopped;
  btStop.Enabled := not Stopped;
  btRecord.Enabled := Stopped;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  SetEnabled(True);
  Tmp := TFileStream.Create(TmpFile, fmCreate or fmShareDenyWrite);
  WaveIn := TWaveIn.CreatePCM(WAVE_MAPPER, 44100, 16, 2, WaveInRead);
  WaveOut := TWaveOut.CreatePCM(WAVE_MAPPER, 44100, 16, 2, WaveOutRender);
end;

procedure TfrmMain.FormDestroy(Sender: TObject);
begin
  WaveOut.Free;
  WaveIn.Free;
  Tmp.Free;
  DeleteFile(TmpFile);
end;

procedure TfrmMain.btRecordClick(Sender: TObject);
begin
  SetEnabled(False);
  Tmp.Position := 0;
  WaveIn.Start;
end;

procedure TfrmMain.btStopClick(Sender: TObject);
begin
  SetEnabled(True);
  if WaveOut.State = wsPlaying then
    WaveOut.Stop
  else
    begin
      WaveIn.Stop;
      Tmp.Size := Tmp.Position;
    end
end;

procedure TfrmMain.btPlayClick(Sender: TObject);
begin
  SetEnabled(False);
  Tmp.Position := 0;
  WaveOut.Play;
end;

procedure TfrmMain.btExitClick(Sender: TObject);
begin
  Application.Terminate;
end;

end.
