unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Asg;

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    Grid: TAdvancedStringGrid;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
  i, j: Integer;
begin
  Grid := TAdvancedStringGrid.Create(Self);
  Grid.BoundsRect := Rect(0, 0, ClientWidth, ClientHeight);
  InsertControl(Grid);

  for i := 0 to Grid.ColCount - 1 do
    for j := 0 to Grid.RowCount - 1 do
      Grid.Cells[i, j] := Format('%d, %d', [i, j]);

    with Grid.Attributes[2, 2] do
      begin
        Alignment := taCenter;
        Fill.Color := clYellow;
      end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  Grid.Free;
end;

end.
