.model tiny

TONE_PERIOD	equ 2386
MAX_BEEP_LEN	equ 9

.code
.startup
	jmp init

int8:
	push ax
	cmp cs:beep_count,0
	je jmp_std8
	in al,61h
	and al,not 1
	dec cs:beep_count
	jz set_out
	or al,3
set_out:
	out 61h,al
jmp_std8:
	pop ax
	jmp cs:std_int8

int9:
	push ax
	push ds
	in al,60h
	cmp al,2Dh
	jne jmp_std9

	xor ax,ax
	mov ds,ax
	mov al,ds:[417h]
	and al,0Ch
	cmp al,0Ch
	jne jmp_std9

	mov al,0B6h
	out 43h,al
	mov ax,TONE_PERIOD
	out 42h,al
	mov al,ah
	out 42h,al

	mov ax,cs:beep_len
	inc ax
	cmp ax,MAX_BEEP_LEN
	jbe set_count
	mov ax,2

set_count:
	mov cs:beep_len,ax
	mov cs:beep_count,ax

	mov al,20h
	out 20h,al
	pop ds
	pop ax
	iret

jmp_std9:
	pop ds
	pop ax
	jmp cs:std_int9

std_int8	label dword	
std_int8_ip	dw ?
std_int8_cs	dw ?

beep_len	dw 2
beep_count	dw 0

std_int9	label dword	
std_int9_ip	dw ?
std_int9_cs	dw ?

res_size	equ ($-@STARTUP+15)/16+16

init:
	mov ax,3508h
	int 21h
	mov std_int8_ip,bx
	mov std_int8_cs,es
	lea dx,int8
	mov ax,2508h
	int 21h

	mov ax,3509h
	int 21h
	mov std_int9_ip,bx
	mov std_int9_cs,es
	lea dx,int9
	mov ax,2509h
	int 21h
	
	mov dx,res_size
	mov ax,3100h
	int 21h

	end