unit xlat;

interface

uses Windows,Sysutils;

type
  XCharSet=(koi,win,dos);

function XConvert(s:string;XFrom:XCharSet;XTo:XCharSet):string;
procedure XConvert2(var s:string;XFrom:XCharSet;XTo:XCharSet);
function AutoCode(var st:string):XCharSet;

implementation

type
  TArrayByte=array[byte]of byte;

const
  Win_:array[0..127]of byte=($C0,$C1,$C2,$C3,$C4,$C5,$C6,$C7,$C8,$C9,$CA,$CB,$CC,$CD,$CE,$CF,$D0,$D1,$D2,$D3,$D4,$D5,$D6,$D7,$D8,$D9,$DA,$DB,$DC,$DD,$DE,$DF,$E0,$E1,$E2,$E3,$E4,$E5,$E6,$E7,$E8,$E9,$EA,$EB,$EC,$ED,$EE,$EF,$80,$81,$82,$83,$84,$85,$86,$87,$88,$89,$8A,$8B,$8C,$8D,$8E,$8F,$90,$91,$92,$93,$94,$95,$96,$97,$98,$99,$9A,$9B,$9C,$9D,$9E,$9F,$A0,$A1,$A2,$A3,$A4,$A5,$A6,$A7,$A9,$AA,$AB,$AC,$AD,$AE,$AF,$B0,$F0,$F1,$F2,$F3,$F4,$F5,$F6,$F7,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF,$A8,$B8,$B1,$B2,$B3,$B4,$B5,$B6,$B7,$B9,$BA,$BB,$BC,$BD,$BE,$BF);
  Koi_:array[0..127]of byte=($E1,$E2,$F7,$E7,$E4,$E5,$F6,$FA,$E9,$EA,$EB,$EC,$ED,$EE,$EF,$F0,$F2,$F3,$F4,$F5,$E6,$E8,$E3,$FE,$FB,$FD,$FF,$F9,$F8,$FC,$E0,$F1,$C1,$C2,$D7,$C7,$C4,$C5,$D6,$DA,$C9,$CA,$CB,$CC,$CD,$CE,$CF,$D0,$90,$91,$92,$81,$87,$B2,$B4,$A7,$A6,$B5,$A1,$A8,$AE,$AD,$AC,$83,$84,$89,$88,$86,$80,$8A,$AF,$B0,$AB,$A5,$BB,$B8,$B1,$A0,$BE,$B9,$BA,$B6,$B7,$AA,$A9,$A2,$A4,$BD,$BC,$85,$82,$8D,$8C,$8E,$8F,$8B,$D2,$D3,$D4,$D5,$C6,$C8,$C3,$DE,$DB,$DD,$DF,$D9,$D8,$DC,$C0,$D1,$B3,$A3,$99,$98,$93,$9B,$9F,$97,$9C,$95,$9E,$96,$BF,$9D,$94,$9A);
  Dos_:array[0..127]of byte=($80,$81,$82,$83,$84,$85,$86,$87,$88,$89,$8A,$8B,$8C,$8D,$8E,$8F,$90,$91,$92,$93,$94,$95,$96,$97,$98,$99,$9A,$9B,$9C,$9D,$9E,$9F,$A0,$A1,$A2,$A3,$A4,$A5,$A6,$A7,$A8,$A9,$AA,$AB,$AC,$AD,$AE,$AF,$B0,$B1,$B2,$B3,$B4,$B5,$B6,$B7,$B8,$B9,$BA,$BB,$BC,$BD,$BE,$BF,$C0,$C1,$C2,$C3,$C4,$C5,$C6,$C7,$C8,$C9,$CA,$CB,$CC,$CD,$CE,$CF,$D0,$D1,$D2,$D3,$D4,$D5,$D6,$D7,$D8,$D9,$DA,$DB,$DC,$DD,$DE,$DF,$E0,$E1,$E2,$E3,$E4,$E5,$E6,$E7,$E8,$E9,$EA,$EB,$EC,$ED,$EE,$EF,$F0,$F1,$F2,$F3,$F4,$F5,$F6,$F7,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF);

var table:TArrayByte;

function XConvert(s:string;XFrom:XCharSet;XTo:XCharSet):string;
begin
  XConvert2(s,XFrom,XTo);
  Result:=s;
end;

procedure XConvert2(var s:string;XFrom:XCharSet;XTo:XCharSet);
var xf,xt:^TArrayByte;sz:integer;i:byte;p:pointer;
begin
  sz:=length(s);
  if not((XFrom=XTo)or(sz=0)) then begin
    case XFrom of
      win:xf:=@Win_;
      koi:xf:=@Koi_;
      dos:xf:=@Dos_;
    end;
    case XTo of
      win:xt:=@Win_;
      koi:xt:=@Koi_;
      dos:xt:=@Dos_;
    end;
    for i:=0 to 127 do begin table[i]:=i;table[xf^[i]]:=xt^[i] end;
    p:=@s[1];
    asm
      pushad
      mov ecx,sz
      mov esi,p
      lea ebx,table
      xor eax,eax
    @L:
      mov al,[esi]
      xlat
      mov [esi],al
      inc esi
      dec ecx
      jnz @l
      popad
    end;
  end;
end;

function AutoCode(var st:string):XCharSet;
var s1,s2,s3:dword;i:integer;
begin
if st='' then result:=win else begin
  s1:=0;s2:=0;s3:=0;
  for i:=1 to length(st) do case byte(st[i]) of
    192,200,206,210,224,232,238,242:inc(s1);
    193,201,207,212,225,233,239,244:inc(s2);
    128,136,142,146,160,168,174,226:inc(s3);
  end;
  if s1<s3 then if s3<s2 then result:=koi else result:=dos else if s1<s2 then result:=koi else result:=win
end;
end;

end.
