Unit MOUSE;
INTERFACE
(* 樠                                *)
Function InitMouse:boolean;

(* 㭪 頥 ⢮         *)
function ButtonMouse:byte;

(* ⮡ࠦ 㪠⥫                        *)
Procedure ShowMouse; 

(*  㪠⥫                                 *)
Procedure HideMouse; 

(*  न 㪠⥫                *)
Procedure GetMouseXY(VAR KoordX,KoordY:Word );

(* 頥 true, ᫨ 㪠⥫ 室       *)
(*   X1,Y1,X2,Y2                     *)
Function MouseIn(X1,Y1,X2,Y2:word):boolean;

(*  㭪 頥 ᫥騥 祭: *)
(* 1 - ᫨   .                    *)
(* 2 - ᫨  ࠢ .                   *)
(* 3 - ᫨    ࠢ             *)
(* 4 - ᫨  ।  (ᨪ)        *)
(* 5 - ᫨     ᨪ          *)
(* 6 - ᫨  ࠢ   ᨪ.        *)
(* 7 - ᫨    (2   ᨪ).*)
Function ButtonPressed:byte;

(* ⠭ 㪠⥫    X, Y          *)
Procedure GotoMouseXY(x,y:word); 

(* 頥 true, ᫨ 뫠   . *)
Function MousePressed: Boolean;

(*  㭪 頥 ⢮ ⨩  *)
(* ( num=0), ।( num=2),            *)
(* ࠢ( num=1)             *)
(* ᫥ 맮  楤.              *)
Function getnum(num:word; var x,y:word):word;

(*࠭祭 ६饭 㪠⥫  ਧ⠫. *)
Procedure LimHor(max,min:word);

(*࠭祭 ६饭 㪠⥫  ⨪.   *)
Procedure LimVer(max,min:word); 

(* 頥 稭 ᬥ饭   ⨪  *)
(* ਧ⠫ ( )  ६ ᫥      *)
(* 맮  楤.                               *)
Procedure GetMikki(var x,y:integer);

(*  ᪫祭 㪠⥫                     *)
(* न x1,y1,x2,y2 - ᮮ⢥⢥ -        *)
(*  ࠭(ਧ),                         *)
(* ୨ ᢥ, ࠢ ࠭, .          *)
Procedure SetArea(x1,y1,x2,y2:word); 

(* ⠭ ண ᪮                     *)
(* 祭  㬮砭 - 64 /               *)
Procedure SetSpeedMouse(mikkiS:word); 

(* ⠭ ⢨⥫쭮                   *)
Procedure SetMouseOptions(hor,ver,porog:word); 


IMPLEMENTATION

Function InitMouse:boolean;
var
ResultRegAX:word;
begin
asm
 mov ax,$00
 int $33
 mov ResultRegAX,ax
end;
If ResultRegAX=$FFFF then InitMouse:=true else InitMouse:=false
End;


function ButtonMouse:byte;
var
ResultRegBX:word;
Begin
 Asm
  mov ax,$00
  int $33
  mov ResultRegBX,bx
 End;
 ButtonMouse:=ResultRegBX
end;

Procedure ShowMouse; assembler;
Asm
 Mov AX,$01
 Int $33
end;

Procedure HideMouse; assembler;
Asm
 Mov AX,$02
 INT $33
End;

Procedure GetMouseXY(VAR KoordX,KoordY:Word );
var
 ResultCX,ResultDX:word;
begin
 Asm
  mov ax,$03
  int $33
  mov ResultCX,CX
  mov ResultDX,DX
 end;
 KoordX:=ResultCX;
 KoordY:=ResultDX
end; 

Function MouseIn(X1,Y1,X2,Y2:word):boolean;
var
rdx,rcx:word;
begin
asm
 mov ax,$03
 int $33
 mov rdx,dx
 mov rcx,cx
end;
MouseIn := (rcx>=X1) and (rcx<=X2) and (rdx>=Y1) and (rdx<=Y2)
end;

Function ButtonPressed:byte;
var
rbl:byte;
begin
 asm
  mov ax,$03
  int $33
  mov rbl,bl
 end;
 ButtonPressed:=rbl
end;

Procedure GotoMouseXY(x,y:word); assembler;
asm
 mov ax,$04
 mov cx,x
 mov dx,y
end;

Function MousePressed: Boolean;
var
resultbx:word;
begin
asm
 Mov ax, $03
 Int $33
 mov resultbx,bx
end;
MousePressed := resultbx<>0
end;

Function getnum(num:word; var x,y:word):word;
var
kn,ResultCX,ResultDX:word;
begin
 asm
  mov ax,$05
  mov bx,num
  int $33
  mov ResultCX,cx
  mov ResultDX,dx
  mov kn,bx
 end;
 getnum:=kn;
 x:=ResultCX;
 y:=ResultDX
end;

Procedure LimHor(max,min:word); assembler;
asm
mov ax,$07
mov cx,min
mov dx,max
int $33
end;

Procedure LimVer(max,min:word); assembler;
asm
mov ax,$08
mov cx,min
mov dx,max
int $33
end;

Procedure GetMikki(var x,y:integer);
var
 RCX,RDX:word;
begin
 asm
  mov ax,$0B
  int $33
  mov RCX,cx
  mov RDX,dx
 end;
 x:=RCX; y:=RDX
end;

Procedure SetArea(x1,y1,x2,y2:word); assembler;
asm
 mov ax,$10
 mov cx,x1
 mov dx,y1
 mov si,x2
 mov di,y2
 int $33
end;

Procedure SetSpeedMouse(mikkiS:word); assembler;
asm
mov ax,$13
mov dx,mikkiS
end;

Procedure SetMouseOptions(hor,ver,porog:word); assembler;
asm
mov ax,$1A
mov bx,hor
mov cx,ver
mov dx,porog
int $33
end;


End.
