{$M 32000,0,655360}

Program Fill;
Uses crt,myVoc;

{
Procedure PrintGrid; -   ⪨
Procedure LoadGrid; - ⥭ ⪨  -䠩
Function  IsLetter(x,y: integer): boolean; -  "㪢" ⪠?
Procedure FindSlots; - 饬   ⪥
Function  GetNewWord: string; - ⠥ ᫮  ᫮
Function  Already: boolean; -  ᫮ 㦥 ⢮?
Function  OK(i: byte; s: string): boolean; - ᫮ ப?
Procedure SaveWord(i: byte; s: string); - 뢠 ᫮  
Procedure UndoWord(i: byte); - ࠥ ᫮  ⪨
function  CheckNext(i: integer): boolean; - ஢ i-⮥ 
Procedure CheckSlots; - ஢  
}

Const GridWidth  = 10;
      GridHeight = 10;
      MaxSlotNum = 20;
      MaxWords = 10000;

Type TCell = record
      c: char;
      n: byte;
     end;

Type TGrid = array[1..GridWidth] of array[1..GridHeight] of TCell;

Type TSlot = record
      x,y: byte;
      len: byte;
      hor: boolean;
     end;

Type TSlotArray = Array[1..MaxSlotNum] of TSlot;

Var
  Grid: TGrid;
  Slot: TSlotArray;
  SlotNum: byte;
  LogFile: text;
  LastRead: word;

Procedure PrintGrid;
var
  i,j: byte;
begin
  Writeln(LogFile,'Grid is like this:');

  For i:=1 to GridHeight do
    begin
      For j:=1 to GridWidth do
        begin
          If Grid[j][i].c = ' '
             then Write(LogFile,'.')
             else If Grid[j][i].c = '1'
                  then Write(LogFile,'')
                  else Write(LogFile,Grid[j][i].c);
        end;

        Writeln(LogFile);
    end;
end;

Procedure ShowGrid;
var
  i,j: byte;
begin

  GoToXY(1,1);

  For i:=1 to GridHeight do
    begin
      For j:=1 to GridWidth do
        begin
          If Grid[j][i].c = ' '
             then Write('.')
             else If Grid[j][i].c = '1'
                  then Write('')
                  else Write(Grid[j][i].c);
        end;

        Writeln;
    end;
end;

Procedure LoadGrid;
var f: text;
  i,j: byte;
  s: string;
begin
  Assign(f,'grid.txt');
  Reset(f);

  For i:=1 to GridHeight do
    begin
      Readln(f,s);

      For j:=1 to GridWidth do
        begin
          If s[j]='.'
             then Grid[j][i].c := ' '
             else Grid[j][i].c := '1';

          Grid[j][i].n := 0;
        end;
    end;

  Close(f);
end;

Function IsLetter(x,y: integer): boolean;
begin
  If (x < 1) or (x > GridWidth) or (y < 1) or (y > GridHeight)
     then IsLetter := false
     else IsLetter := (Grid[x][y].c = ' ');
end;

Procedure FindSlots;
var x,y,i,l: integer;
begin
  SlotNum := 0;

  For x:=1 to GridWidth do
  For y:=1 to GridHeight do
    begin
      If IsLetter(x,y) and not IsLetter(x-1,y) then
         begin
           l := 1;
           i := x + 1;

           While IsLetter(i,y) do
             begin
               Inc(i);
               Inc(l);
             end;

             If l > 1 then
                begin
                  Inc(SlotNum);
                  Slot[SlotNum].x := x;
                  Slot[SlotNum].y := y;
                  Slot[SlotNum].len := l;
                  Slot[SlotNum].hor := true;
                end;
         end;
         
      if IsLetter(x,y) and not IsLetter(x,y-1) then
            begin
              l := 1;
              i := y + 1;

              While IsLetter(x,i) do
                begin
                  Inc(i);
                  Inc(l);
                end;

                If l > 1 then
                   begin
                     Inc(SlotNum);
                     Slot[SlotNum].x := x;
                     Slot[SlotNum].y := y;
                     Slot[SlotNum].len := l;
                     Slot[SlotNum].hor := false;
                   end;
            end;
    end;

  If SlotNum > 0 then
     begin
       Writeln(LogFile,'Slots found (x,y,len,h/v):');

       For x:=1 to SlotNum do
           begin
             Write(LogFile,Slot[x].x:4,Slot[x].y:4,Slot[x].len:4);
             If Slot[x].hor
                then Writeln(LogFile,' H')
                else Writeln(LogFile,' V');
           end;
     end;
end;

Function OK(i: byte; s: string): boolean;
var j: byte;
begin
  if s='-1' then
     begin
       OK := false;
       exit;
     end;

{  Writeln(LogFile,'஢塞 ᫮ #'+s+'#   ',i);
  Write(LogFile,'न : ',Slot[i].x:4,Slot[i].y:4,Slot[i].len:4);

  If Slot[i].hor
     then Writeln(LogFile,' H')
     else Writeln(LogFile,' V');
}
  if Slot[i].hor then
     begin
       For j:=0 to Slot[i].len-1 do
           begin
             if (Grid[Slot[i].x+j][Slot[i].y].c <> ' ')
             and (Grid[Slot[i].x+j][Slot[i].y].c <> s[j+1])
                then
                  begin
                    OK := false; {
                    Writeln(LogFile,'宦  ⪥ ',
                            Slot[i].x+j,' ',Slot[i].y);
                    Writeln(LogFile,'⪠: '+Grid[Slot[i].x+j][Slot[i].y].c);
                    Writeln(LogFile,': '+s[j+1]); }
                    exit;
                  end;
           end;
     end
  else
     begin
       For j:=0 to Slot[i].len-1 do
           begin
             if (Grid[Slot[i].x][Slot[i].y+j].c <> ' ')
             and (Grid[Slot[i].x][Slot[i].y+j].c <> s[j+1])
                then
                  begin
                    OK := false; {
                    Writeln(LogFile,'宦  ⪥ ',
                            Slot[i].x,' ',Slot[i].y+j);
                    Writeln(LogFile,'⪠: '+Grid[Slot[i].x][Slot[i].y+j].c);
                    Writeln(LogFile,': '+s[j+1]); }
                    exit;
                  end;
           end;
     end;

  OK := true;
{  Writeln(LogFile,' 室  !'); }
end;

Procedure SaveWord(i: byte; s: string);
var j: byte;
begin
{  Writeln(LogFile,'襬 ᫮ #'+s+'#   ',i,'.'); }

  If Slot[i].hor then
     begin
       For j:=0 to Slot[i].len-1 do
           begin
             Grid[Slot[i].x+j][Slot[i].y].c := s[j+1];
             Inc(Grid[Slot[i].x+j][Slot[i].y].n);
           end;
     end
  else
     begin
       For j:=0 to Slot[i].len-1 do
           begin
             Grid[Slot[i].x][Slot[i].y+j].c := s[j+1];
             Inc(Grid[Slot[i].x][Slot[i].y+j].n);
           end;
     end;
end;

Procedure UndoWord(i: byte);
var j: byte;
begin
{  Writeln(LogFile,'㡨ࠥ ᫮   ',i,'.'); }

  If Slot[i].hor then
     begin
       For j:=0 to Slot[i].len-1 do
           begin
             If (Grid[Slot[i].x+j][Slot[i].y].n > 0) Then
                Dec(Grid[Slot[i].x+j][Slot[i].y].n);

             If (Grid[Slot[i].x+j][Slot[i].y].n = 0) Then
                begin
                  Grid[Slot[i].x+j][Slot[i].y].c := ' ';
                end;
           end;
     end
  else
     begin
       For j:=0 to Slot[i].len-1 do
           begin
             If (Grid[Slot[i].x][Slot[i].y+j].n > 0) Then
                Dec(Grid[Slot[i].x][Slot[i].y+j].n);

             If (Grid[Slot[i].x][Slot[i].y+j].n = 0) Then
                begin
                  Grid[Slot[i].x][Slot[i].y+j].c := ' ';
                end;
           end;
     end;
end;

function CheckNext(i: integer): boolean;
var s: TWord; x: byte;
    off: word;
    oldUsedNum: word;
begin

  ShowGrid;

  if i > SlotNum then {  ஢७}
    begin
       Writeln(LogFile, '  ஢७!');
       Writeln(LogFile, '室  ४ᨨ...i=', i);
       CheckNext := true;  {蠡}
       exit;
    end;

    LastRead := 0;

    OldUsedNum := UsedNum;

    vocStartWith(Slot[i].len,off);

    repeat

      s := vocGetNextWord(Slot[i].len,off);  {롨ࠥ ᫮  ᫮}

      gotoxy(1,15); write(s);

      if s <> '-1' then
         begin
           vocMarkUsed(Off);  { 砥  ᫮,  ᯮ짮}

           if OK(i, s) {᫮ 襥}
              then
                begin
                  SaveWord(i, s);  {࠭塞   ⪥}

                  UsedNum := OldUsedNum;  {뢠 稪 ᯮ짮 ᫮}
                  vocMarkUsed(Off);   { ୮ 砥  ᫮}
                                      { ᯮ짮}

                  Writeln(LogFile, '㡫塞  ४...i=', i);
                  if CheckNext(i+1) then   {뢠 ४}
                     begin
                       CheckNext := true;
                       Writeln(LogFile, '室  ४ᨨ...i=', i);
                       exit;
                     end
                  else
                     UndoWord(i);  {ન ᫮  ⪨}
                end;
         end
      else      {  室 ᫮    }
         begin
           CheckNext := false;
           UsedNum := OldUsedNum;
           Writeln(LogFile, ' ', i, '   㤠.');
           Writeln(LogFile, '室  ४ᨨ...i=', i);
           Exit;
         end;
    until false;
end;

Procedure CheckSlots;
var s: string;
    foo: boolean;
begin
  foo := CheckNext(1);
end;

(******** Main Program ************)
Begin
  ClrScr;
  Assign(LogFile,'log.txt');
  Rewrite(LogFile);
  vocOpen;
  LoadGrid;
  PrintGrid;
  FindSlots;
  CheckSlots;
  PrintGrid;
  vocClose;
  Close(LogFile);
End.
