// Module: 'ProcessList.pas'
// Desription: Universal processes enumeration function for Win32
// (conditionally uses ToolHelp32 (Windows 9x, Me, 2000) or
// PSAPI (Windows NT) functions)

// Mad Developer, 2001

unit ProcessList;

interface

uses Windows, TlHelp32, PSAPI;

const MaxProcesses = 4096;
      MaxExeFileNameLength = 256;

type TEnumProcessesProc = function(PID: DWord; const ExeFileName: String;
  Data: Pointer): Boolean;

function EnumProcesses(CallbackProc: TEnumProcessesProc;
  CallbackData: Pointer): Boolean;

implementation

function EnumProcesses(CallbackProc: TEnumProcessesProc;
  CallbackData: Pointer): Boolean;
var Snapshot,
    ProcessHandle,
    ModuleHandle,
    i: Integer;
    BytesRead: Cardinal;
    ProcessEntry: TProcessEntry32;
    ExeFileName: array[0..MaxExeFileNameLength - 1] of Char;
    PIDs: array[0..MaxProcesses - 1] of DWord;
begin
  Result := False;
  if not Assigned(CallbackProc) then
    begin
      SetLastError(ERROR_INVALID_PARAMETER);
      Exit;
    end;
  Snapshot := CreateToolHelp32Snapshot(TH32CS_SNAPPROCESS, 0);
  if Snapshot <> 0 then
    begin
      // Processes enumeration loop for Windows 9x, Me, 2000
      // ToolHelp32 API 
      ProcessEntry.dwSize := SizeOf(TProcessEntry32);
      if Process32First(Snapshot, ProcessEntry) then
        repeat
        until not (CallbackProc(ProcessEntry.th32ProcessID,
          ProcessEntry.szExeFile, CallbackData) and
          Process32Next(Snapshot, ProcessEntry));
      CloseHandle(Snapshot);
      Result := True;
    end
  else
    // Processes enumeration loop for Windows NT, 2000 PSAPI
    if PSAPI.EnumProcesses(@PIDs, SizeOf(PIDs), BytesRead) then
      begin
        for i := 0 to BytesRead shr 2 - 1 do
          begin
            ProcessHandle := OpenProcess(PROCESS_VM_READ or
              PROCESS_QUERY_INFORMATION, False, PIDs[i]);
            if ProcessHandle <> 0 then
              begin
                ExeFileName := '';
                if EnumProcessModules(ProcessHandle, @ModuleHandle,
                     SizeOf(ModuleHandle), BytesRead) then
                  GetModuleFileNameEx(ProcessHandle, ModuleHandle, ExeFileName,
                    SizeOf(ExeFileName));
                CloseHandle(ProcessHandle);
                if not CallbackProc(PIDs[i], ExeFileName, CallbackData) then Break;
              end // then
            else
          end; // for
        Result := True;
      end // then
    else
      SetLastError(ERROR_INVALID_FUNCTION);
end;

end.
