unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SnapinData, Menus, XPMan;

type
  TDataModule1 = class(TDataModule)
    SnapinData1: TSnapinData;
    PopupMenu1: TPopupMenu;
    est11: TMenuItem;
    N1: TMenuItem;
    est21: TMenuItem;
    MainMenu: TMainMenu;
    ertrt1: TMenuItem;
    ertert1: TMenuItem;
    tert1: TMenuItem;
    procedure SnapinData1ResultProperties(sender: TObject;
      var Changed: Boolean);
    procedure SnapinData1ResultDblClick(Sender: TObject);
    procedure SnapinData1ResultRename(sender: TObject; const newName: string;
      var allowRename: Boolean);
    procedure SnapinData1ScopeExpand(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DataModule1: TDataModule1;

implementation

{$R *.DFM}

uses ComServ, ComObj, MMCFactory, Snapins, unitVersionInfo;

const
  Class_SimpleSnapin : TGuid = '{B1EF0C14-61C9-4239-A8F1-6A82E2135FD7}';
  Class_SimpleSnapinAbout : TGuid = '{6740FFA1-2CC1-4D5D-B8A9-5FE7AB5810D8}';

type
  TSimpleComponentData = class (TSnapinComponentData)
  private
    fDataModule : TDataModule1;
  protected
    function GetSnapinData : TSnapinData; override;
  public
    destructor Destroy; override;
  end;

  TSimpleSnapinAbout = class (TSnapinAbout)
  private
    fDataModule : TDataModule1;
  protected
    function GetSnapinData : TSnapinData; override;
  public
    destructor Destroy; override;
  end;

{ TSimpleComponentData }

destructor TSimpleComponentData.Destroy;
begin
  fDataModule.Free;
  inherited
end;

function TSimpleComponentData.GetSnapinData: TSnapinData;
begin
  fDataModule := TDataModule1.Create (Nil);
  result := fDataModule.SnapinData1;
  Result.ScopeItem.HasChildren := True;
end;

{ TTestSnapinAbout }

destructor TSimpleSnapinAbout.Destroy;
begin
  fDataModule.Free;
  inherited;
end;

function TSimpleSnapinAbout.GetSnapinData: TSnapinData;
begin
  fDataModule := TDataModule1.Create (nil);
  result := fDataModule.SnapinData1;
end;

var
  snapinName, snapinDescription, snapinProvider : string;

procedure TDataModule1.SnapinData1ResultDblClick(Sender: TObject);
begin
  ShowMessage('SnapinData1ResultDblClick');
end;

procedure TDataModule1.SnapinData1ResultProperties(sender: TObject;
  var Changed: Boolean);
begin
  ShowMessage('SnapinData1ResultProperties');
end;

procedure TDataModule1.SnapinData1ResultRename(sender: TObject;
  const newName: string; var allowRename: Boolean);
begin
  ShowMessage('SnapinData1ScopeExpand1');
  allowRename := False;
end;

procedure TDataModule1.SnapinData1ScopeExpand(Sender: TObject);
var
  Item: TScopeItem;
begin
 if TScopeItem(Sender) = SnapinData1.ScopeItem then
 begin
   if not Assigned(TScopeItem(Sender).Data) then
   begin
     Item := TScopeItem(Sender).ScopeItems.Add();
     Item.Text := ' ';
     Item.ViewTypeGUID := '{2D360200-FFF5-11D1-8D03-00A0C959BC0A}';
     Item := TScopeItem(Sender).ScopeItems.Add();
     Item.Text := '';
     Item.ViewTypeGUID := '{E443621E-3DEB-4A74-89A1-9722AE056E82}';
     Item := TScopeItem(Sender).ScopeItems.Add();
     Item.Text := '';
     Item.ViewTypeGUID := '{8A33EBF2-5FE8-40C9-8D0F-9C29416CFBC4}';
     Item := TScopeItem(Sender).ScopeItems.Add();
     Item.Text := ' ';
     Item.ViewTypeGUID := '{05A8094E-B5F0-4E20-860C-F26522ECEABE}';
     Item := TScopeItem(Sender).ScopeItems.Add();
     Item.Text := ' ';
     Item := TScopeItem(Sender).ScopeItems.Add();
     Item.Text := '';
     Item := TScopeItem(Sender).ScopeItems.Add();
     Item.Text := '';
     TScopeItem(Sender).Data := Self;
   end;
 end;

end;

initialization
  DataModule1 := TDataModule1.Create (nil);
  try
    snapinDescription := DataModule1.SnapinData1.FileDescription;
    snapinName := DataModule1.SnapinData1.ProductName;
    snapinProvider := DataModule1.SnapinData1.Provider;
  finally
    DataModule1.Free
  end;
  if snapinDescription = '' then snapinDescription := snapinName;
  TMMCObjectFactory.Create (ComServer, TSimpleComponentData, Class_SimpleSnapin, TSimpleSnapinAbout, Class_SimpleSnapinAbout,
    snapinName, snapinDescription, snapinProvider);
end.
