{Originally from Frederic Gaonac'h }
{slightly corrected by Valery Votintsev [vv]}
program tetris;
uses crt, graph;
type
  tableau=Array[1..10,1..29]of integer;
  switch= array[1..4,1..6] of integer;

const
  d500=5;  {vv delay constant. Increase this if very fast}
  d6000=600; {vv delay constant. Increase this if very fast}
function max(a,b,c: integer):integer;
begin
  if (a>=b)and(a>=c) then max:=a;
  if (b>=a)and(b>=c) then max:=b;
  if (c>=a)and(c>=b) then max:=c;
end;

function min(a,b,c: integer):integer;
begin
  if (a<=b)and(a<=c) then min:=a;
  if (b<=a)and(b<=c) then min:=b;
  if (c<=a)and(c<=b) then min:=c;
end;

function descent(t:tableau;grille:switch; b,c,i: integer):integer;
begin
  while
    (t[grille[b,1]+c,i+1+grille[b,2]]=0)and(t[grille[b,3]+c,i+1+grille[b,4]]=0)and(t[grille[b,5]+c,i+1+grille[b,6]]=0)and
    (t[c,i+1]=0)and(i+grille[b,2]<29)and(i+grille[b,4]<29)and(i+grille[b,6]<29)and(i<29)
    do i:=i+1;
  descent:=i;
end;

procedure pause;
var  i,j,k: integer;
begin
  for i:=1 to 2 do begin
    if i=1 then
      setcolor(3)
    else setcolor(0);
    outtextxy(30,20,'Programming:');
    outtextxy(30,50,'Left:           4');
    outtextxy(30,70,'Right:          6');
    outtextxy(30,90,'Shift:          5');
{vv}outtextxy(30,110,'Fall from here!:2,Space');
{vv outtextxy(30,110,'Fall from here!:2');}
    outtextxy(30,130,'Max Left:       7');
    outtextxy(30,150,'Max right:      9');
    outtextxy(30,170,'Faster!:        8');
    outtextxy(30,190,'Next:           N');
    outtextxy(30,210,'Pause:          P');
    outtextxy(30,230,'Sound/Sil.:     S');
    outtextxy(30,250,'First handicap: H');
{vv}outtextxy(30,270,'Iwannaquit:     Q,Esc');
{vv    outtextxy(30,270,'Iwannaquit:     Q,Esc');}
    outtextxy(2,300,'Of course, you win less');
    outtextxy(2,320,'points playing at a low');
    outtextxy(2,340,'level, without clattering');
    outtextxy(2,360,'and with the next...');
    outtextxy(2,400,'My mail for others programs');
    outtextxy(2,420,'Balafred@mailexcite.com');
    if i=1 then begin
      repeat
        for j:=1 to 20  do begin
          for k:=1 to 2 do begin
            if k=1 then setcolor(4) else setcolor(0);
            outtextxy(230+1*j,20,'F');
            outtextxy(240+2*j,20,'r');
            outtextxy(250+3*j,20,'e');
            outtextxy(260+4*j,20,'d');
            if k=1 then delay(d500);
          end;
        end;
        for j:=20 downto 1  do begin
          for k:=1 to 2 do begin
            if k=1 then setcolor(4) else setcolor(0);
            outtextxy(230+1*j,20,'F');
            outtextxy(240+2*j,20,'r');
            outtextxy(250+3*j,20,'e');
            outtextxy(260+4*j,20,'d');
            if k=1 then delay(d500);
          end;
        end;
      until keypressed;

    end;
  end;
end;

var
  a,b,c,i,j,k,l,m,n,r,r2,x,v,w, ind, i2, nbre, next, lignes, fin, pilote, mode: integer;
  t: tableau;
  t1,t2,t3,t4,t5,t10,t14,grille: switch;
  abscents, presents, test ,son: boolean;
  p: longint;
  s: string;
{vv} z:char;

begin
  t1[1,1]:=0; t1[1,2]:=1; t1[1,3]:=0; t1[1,4]:=-1; t1[1,5]:=1; t1[1,6]:=-1;
  t1[2,1]:=1; t1[2,2]:=0; t1[2,3]:=-1; t1[2,4]:=0; t1[2,5]:=-1; t1[2,6]:=-1;
  t1[3,1]:=0; t1[3,2]:=1; t1[3,3]:=0; t1[3,4]:=-1; t1[3,5]:=-1; t1[3,6]:=1;
  t1[4,1]:=1; t1[4,2]:=0; t1[4,3]:=-1; t1[4,4]:=0; t1[4,5]:=1; t1[4,6]:=1;
  t2[1,1]:=1; t2[1,2]:=0; t2[1,3]:=0; t2[1,4]:=-1; t2[1,5]:=-1; t2[1,6]:=-1;
  t2[2,1]:=0; t2[2,2]:=-1; t2[2,3]:=-1; t2[2,4]:=0; t2[2,5]:=-1; t2[2,6]:=1;
  t3[1,1]:=1; t3[1,2]:=0; t3[1,3]:=-1; t3[1,4]:=0; t3[1,5]:=0; t3[1,6]:=1;
  t3[2,1]:=1; t3[2,2]:=0; t3[2,3]:=0; t3[2,4]:=-1; t3[2,5]:=0; t3[2,6]:=1;
  t3[3,1]:=0; t3[3,2]:=-1; t3[3,3]:=-1; t3[3,4]:=0; t3[3,5]:=1; t3[3,6]:=0;
  t3[4,1]:=0; t3[4,2]:=-1; t3[4,3]:=0; t3[4,4]:=1; t3[4,5]:=-1; t3[4,6]:=0;
  t4[1,1]:=0; t4[1,2]:=-1; t4[1,3]:=0; t4[1,4]:=1; t4[1,5]:=0; t4[1,6]:=2;
  t4[2,1]:=1; t4[2,2]:=0; t4[2,3]:=2; t4[2,4]:=0; t4[2,5]:=-1; t4[2,6]:=0;
  t5[1,1]:=1; t5[1,2]:=0; t5[1,3]:=1; t5[1,4]:=-1; t5[1,5]:=0; t5[1,6]:=-1;
  t10[1,1]:=0; t10[1,2]:=-1; t10[1,3]:=0; t10[1,4]:=1; t10[1,5]:=-1; t10[1,6]:=-1;
  t10[2,1]:=1; t10[2,2]:=0; t10[2,3]:=-1; t10[2,4]:=0; t10[2,5]:=-1; t10[2,6]:=1;
  t10[3,1]:=0; t10[3,2]:=1; t10[3,3]:=0; t10[3,4]:=-1; t10[3,5]:=1; t10[3,6]:=1;
  t10[4,1]:=1; t10[4,2]:=0; t10[4,3]:=-1; t10[4,4]:=0; t10[4,5]:=1; t10[4,6]:=-1;
  t14[1,1]:=0; t14[1,2]:=-1; t14[1,3]:=1; t14[1,4]:=-1; t14[1,5]:=-1; t14[1,6]:=0;
  t14[2,1]:=0; t14[2,2]:=1; t14[2,3]:=-1; t14[2,4]:=0; t14[2,5]:=-1; t14[2,6]:=-1;

  for i:=1 to 10 do begin
    for j:=1 to 29 do
      t[i,j]:=0;
  end;

  pilote:=detect;
  initGraph(pilote,mode,'c:\tp\bgi');
  clearviewport;
  setcolor(8);
  setbkcolor(black);
  for j:=1 to 30 do
    line(220,j*15+20,420,j*15+20);
  for i:=1 to 11 do
    line(i*20+200,35,i*20+200,470);
  setcolor(3);
  outtextxy(450,30,'Points: 0');
  outtextxy(450,50,'Lines:  0');
  outtextxy(450,70,'Level:  1');
  outtextxy(450,100,'Infos: I');
  outtextxy(450,140,'Next:');
  setcolor(8);
  rectangle(465,160,535,230);

  p:=0;
  lignes:=0;
  n:=1;
  ind:=0;
  son:=true;
  next:=0;

  r2:=random(7)+1;

  repeat
    r:=r2;
    randomize;
    m:=0;
    i:=1;
    x:=310;
    c:=5;
    b:=1;

    r2:=random(7)+1;
    if r2=7 then r2:=14;
    if r2=6 then r2:=10;
    if r2=1 then grille:=t1;
    if r2=2 then grille:=t2;
    if r2=3 then grille:=t3;
    if r2=4 then grille:=t4;
    if r2=5 then grille:=t5;
    if r2=10 then grille:=t10;
    if r2=14 then grille:=t14;

    if next=1 then begin
      setfillstyle(1,0);
      floodfill(500,190,8);
      setcolor(r2);
      rectangle(490,180,510,195);
      rectangle(490+grille[1,1]*20,180+grille[1,2]*15,510+grille[1,1]*20,195+grille[1,2]*15);
      rectangle(490+grille[1,3]*20,180+grille[1,4]*15,510+grille[1,3]*20,195+grille[1,4]*15);
      rectangle(490+grille[1,5]*20,180+grille[1,6]*15,510+grille[1,5]*20,195+grille[1,6]*15);
    end;

    if r=1 then grille:=t1;
    if r=2 then grille:=t2;
    if r=3 then grille:=t3;
    if r=4 then grille:=t4;
    if r=5 then grille:=t5;
    if r=10 then grille:=t10;
    if r=14 then grille:=t14;

    repeat
{vv}  z:=' ';
{vv      z:=0;}
      if i<>1 then begin
        setfillstyle(1,0);
        floodfill(x,i*15+25,8);
        floodfill(grille[b,1]*20+x,(i+grille[b,2])*15+25,8);
        floodfill(grille[b,3]*20+x,(i+grille[b,4])*15+25,8);
        floodfill(grille[b,5]*20+x,(i+grille[b,6])*15+25,8);
      end;

      i:=i+1;
      while keypressed do begin
{vv}        z:=upcase(readkey);
{vv        z:=ord(readkey)-ord('0');}
        v:=min(grille[b,1],grille[b,3],grille[b,5]);
        w:=max(grille[b,1],grille[b,3],grille[b,5]);

{vv}    if (z='4')and(c+v>1)and(t[c+grille[b,1]-1,i+grille[b,2]]=0)
{vv     if (z='4')and(c+v>1)and(t[c+grille[b,1]-1,i+grille[b,2]]=0)}
           and(t[c+grille[b,3]-1,i+grille[b,4]]=0)
           and(t[c+grille[b,5]-1,i+grille[b,6]]=0) then begin
          x:=x-20; c:=c-1;
        end;

        if (z='6')and(c+w<10)and(t[c+grille[b,1]+1,i+grille[b,2]]=0)
           and(t[c+grille[b,3]+1,i+grille[b,4]]=0)
           and(t[c+grille[b,5]+1,i+grille[b,6]]=0) then begin
          x:=x+20; c:=c+1;
        end;

        if z='7' then begin
          while (c+v>1)and(t[c+grille[b,1]-1,i+grille[b,2]]=0)
                and(t[c+grille[b,3]-1,i+grille[b,4]]=0)
                and(t[c+grille[b,5]-1,i+grille[b,6]]=0) do begin
            x:=x-20;c:=c-1;
          end;
        end;

        if z='9' then begin
          while (c+w<10)and(t[c+grille[b,1]+1,i+grille[b,2]]=0)
                and(t[c+grille[b,3]+1,i+grille[b,4]]=0)
                and(t[c+grille[b,5]+1,i+grille[b,6]]=0) do begin
            x:=x+20;c:=c+1;
          end;
        end;

{vv}    if (z='2') or (z=#32) then begin
{vv        if (z=2) then begin}
          i2:=i;
          i:=descent(t,grille,b,c,i);
          setcolor(0);
          str(p,s);
          outtextxy(514,30,s);
          p:=p+(i-i2)*SQR(n) div 4;
          setcolor(3);
          str(p,s);
          outtextxy(514,30,s);
        end;

        if z='5' then begin
          a:=1;
          if (r=2)or(r=14)or(r=4) then a:=2;
          if (r=1)or(r=10)or(r=3) then a:=4;
          v:=min(grille[(b mod a)+1,1],grille[(b mod a)+1,3],grille[(b mod a)+1,5]);
          w:=max(grille[(b mod a)+1,1],grille[(b mod a)+1,3],grille[(b mod a)+1,5]);

          if (c+v>0)and(c+w<11)
             and(t[c+grille[(b mod a)+1,1],i+grille[(b mod a)+1,2]]=0)
             and(t[c+grille[(b mod a)+1,3],i+grille[(b mod a)+1,4]]=0)
             and(t[c+grille[(b mod a)+1,5],i+grille[(b mod a)+1,6]]=0)
             then begin
            m:=m+1;
            b:=(m mod a)+1;
          end;
        end;

        if (z='8')or(ind=1) then begin
          ind:=0;
          setcolor(0);
          str(n,s);
          outtextxy(514,70,s);
          n:=n+1;
          setcolor(3);
          str(n,s);
          outtextxy(514,70,s);
        end;

{vv}    if (z='Q') or (z=#27) then begin
                      closegraph;
                      halt(1);
                      end;
{vv     if z=ord('q')-ord('0') then halt(1);}

{vv}    if z='S' then
{vv     if (z=ord('s')-ord('0'))or((z=ord('S')-ord('0'))) then}
          if son=true then son:=false else son:=true;

{vv}    if z='P' then begin
{vv        if (z=ord('p')-ord('0'))or(z=ord('P')-ord('0')) then begin}
          repeat
            for j:=1 to 25  do begin
              for k:=1 to 2 do begin
                if k=1 then setcolor(4) else setcolor(0);
                outtextxy(290-3*j,20,'P');
                outtextxy(300-j,20,'a');
                outtextxy(310,20,'u');
                outtextxy(320+j,20,'s');
                outtextxy(330+3*j,20,'e');
                if k=1 then delay(d500);
              end;
            end;
            for j:=25 downto 1  do begin
              for k:=1 to 2 do begin
                if (k=1) then setcolor(4) else setcolor(0);
                outtextxy(290-3*j,20,'P');
                outtextxy(300-j,20,'a');
                outtextxy(310,20,'u');
                outtextxy(320+j,20,'s');
                outtextxy(330+3*j,20,'e');
                if k=1 then delay(d500);
              end;
            end;
          until keypressed;
        end;

{vv}  if z='N' then begin
{vv      if (z=ord('n')-ord('0'))or(z=ord('N')-ord('0')) then begin}
        if next=1 then begin
          next:=0;
          floodfill(500,190,8);
        end else
          next:=1;
      end;

{vv}  if (z='H')and(p=0) then begin
{vv      if (z=ord('h')-ord('0'))and(p=0) then begin}
        setcolor(3);
        outtextxy(450,250,'Hauteur ?');
        repeat
          repeat until keypressed;
          z:=Upcase(readkey);
{vv}    until (z in ['0'..'9']);
{vv        until (z>=0)and(z<10);}
        setcolor(0);
        outtextxy(450,250,'Height ?');
        setfillstyle(1,9);
{vv}    for j:=29 downto 30-(ord(z)-ord('0')) do begin
{vv     for j:=29 downto 30-z do begin}
          for k:=1 to 10 do begin
            if (random(2)=1)or(k=30-j) then begin
              t[k,j]:=9;
              floodfill(k*20+210,j*15+25,8);
            end;
          end;
        end;
      end;

{vv}  if z='I' then
{vv      if (z=ord('i')-ord('0'))or(z=ord('I')-ord('0')) then}
        pause;
      end;

      setfillstyle(1,r);
      floodfill(x,i*15+25,8);
      floodfill(grille[b,1]*20+x,(i+grille[b,2])*15+25,8);
      floodfill(grille[b,3]*20+x,(i+grille[b,4])*15+25,8);
      floodfill(grille[b,5]*20+x,(i+grille[b,6])*15+25,8);

{vv}  delay(Round(d6000/(exp(0.7*ln(n)))));
{vv      delay(Round(6000/(exp(0.7*ln(n)))));}
      fin:=descent(t,grille,b,c,i);
    until (z='2')or(fin=i);

    setcolor(0);
    str(p,s);
    outtextxy(514,30,s);
    p:=p+7*n+50*(1-next);
    setcolor(3);
    str(p,s);
    outtextxy(514,30,s);

    t[c,i]:=r;
    t[c+grille[b,1],i+grille[b,2]]:=r;
    t[c+grille[b,3],i+grille[b,4]]:=r;
    t[c+grille[b,5],i+grille[b,6]]:=r;

    {Suppress of full lines}
    i:=30;
    nbre:=0;

    repeat
      i:=i-1;
      abscents:=true;
      presents:=true;
      for j:=1 to 10 do begin
        if t[j,i]<>0 then abscents:=false;
        if t[j,i]=0 then presents:=false;
      end;

      if presents=true then begin
        nbre:=nbre+1;
        setcolor(0);
        str(lignes,s);
        outtextxy(514,50,s);
        lignes:=lignes+1;
        setcolor(3);
        str(lignes,s);
        outtextxy(514,50,s);

        if lignes=10*(n+1) then begin
          ind:=1;
          if son=true then begin
            for a:=100 to 1500 do begin
              sound(a);
              delay(10);
            end;
            nosound;
          end;
        end else begin
          if son=true then begin
            sound(440*nbre);
          end;
        end;

        for j:=1 to 10 do begin
          setfillstyle(1,0);
          floodfill(j*20+210,i*15+25,8);
          delay(round(1000/n));
        end;
        for j:=1 to 10 do begin
          for k:=i downto 1 do begin
            if k>1 then begin
              t[j,k]:=t[j,k-1];
              setfillstyle(1,t[j,k-1]);
              floodfill(j*20+210,k*15+25,8);
            end else
              t[j,1]:=0;
          end;
        end;
        i:=i+1;
        nosound;
      end;
    until (abscents)or(i=1);

    test:=false;
    for j:=1 to 10 do
      if t[j,1]<>0 then test:=true;

  until test;

  if son=true then begin
    for a:=1500 downto 100 do begin
      sound(a);
      delay(10);
    end;
    nosound;
  end;

  repeat
    for j:=1 to 25  do begin
      for k:=1 to 2 do begin
        if k=1 then setcolor(4) else setcolor(0);
        outtextxy(300-3*j,20,'L');
        outtextxy(310-j,20,'o');
        outtextxy(320+j,20,'s');
        outtextxy(330+3*j,20,'t');
        if k=1 then delay(d500);
      end;
    end;
    for j:=25 downto 1  do begin
      for k:=1 to 2 do begin
        if (k=1) then setcolor(4) else setcolor(0);
        outtextxy(300-3*j,20,'L');
        outtextxy(310-j,20,'o');
        outtextxy(320+j,20,'s');
        outtextxy(330+3*j,20,'t');
        if k=1 then delay(d500);
      end;
    end;
  until keypressed;

  repeat until keypressed;

{vv} CloseGraph;
end.