Program Udaff;
Uses crt, xconsole;

const NONE =  #0;

Type TChain = record
       x,y: integer;
       dir: char;
     end;

Type TSnake = record
       Body: Array[1..2000] of TChain;
       Length: word;
       Direction: char;
     end;

Var Board: Array[1..80] of Array[2..24] of char;
    Snake: TSnake;
    Score: Word;
    Interval: Word;
    Lives: byte;

Procedure FlushKeyboard;
var foo: char;
begin
  While KeyPressed do foo := ReadKey;
end;

Procedure Intro;
begin
 TextColor(15);
 TextBackGround(0);
 ClrScr;

 LoadScreen('Intro.scr');
 
 Hide_Cursor;

 While not KeyPressed do;

 FlushKeyboard;

 ClrScr;

 Hide_Cursor;
end;

Procedure PlaceTile(Tile: char; x,y:byte);
begin
    putc(x-1, y-1, Tile);

    Case Tile of
    '=', '', '^', 'V', '<', '>',
    'J', 'L', '', '7': Tile := '#';
    end;

    Board[x][y] := Tile;
end;

Procedure PlaceBonus;
var x,y: byte;
begin
  Repeat
    x := random(79) + 1;
    y := random(21) + 2;
  Until Board[x][y] = ' ';

  PlaceTile('!', x, y);
end;

Procedure BuildSnake;
var i: byte;
begin
  Snake.Direction := UP;
  Snake.Length := 5;

  For i:=1 to 5 do
    begin
      Snake.Body[i].dir := UP;
      Snake.Body[i].x := 40;
      Snake.Body[i].y := 18-i;
    end;
end;

Function GetDirection: char;
var Key: char;
Begin
  GetDirection := NONE;

  If not Keypressed Then Exit;

  Key := ReadKey;
  
  If Key = #0 Then Key := ReadKey;
  
  Case Key Of
       ESC, LT, RT, UP, DN: GetDirection := Key;
  End;
End;

Procedure DrawBoard;
var i,j: byte;
begin
 For i:=1 to 80 do
 For j:=2 to 24 do
     Board[i][j] := ' ';

 For i:=1 to 80 do
   begin
     PlaceTile('#', i,  2);
     PlaceTile('#', i, 24);
   end;

 For i:=2 to 23 do
   begin
     PlaceTile('#',  1, i);
     PlaceTile('#', 80, i);
   end;
   
 PlaceTile('!', 10, 5);
 PlaceTile('!', 10, 21);
 PlaceTile('!', 70, 5);
 PlaceTile('!', 70, 21);
end;

Procedure DrawHead;
var Dir1,Dir2,Tile: char;
begin
  Dir1 := Snake.Body[Snake.Length].dir;
  Dir2 := Snake.Body[Snake.Length-1].dir;

  Case Dir1 of
    UP: Tile := '^';
    DN: Tile := 'V';
    LT: Tile := '<';
    RT: Tile := '>';
  end;

  PlaceTile(Tile, Snake.Body[Snake.Length].x,Snake.Body[Snake.Length].y);

       Case Dir2 of
         UP: If Dir1 = LT then Tile := '7'
             else if Dir1 = RT then Tile := ''
             else Tile := '';
         DN: If Dir1 = LT then Tile := 'J'
             else if Dir1 = RT then Tile := 'L'
             else Tile := '';
         LT: If Dir1 = DN then Tile := ''
             else if Dir1 = UP then Tile := 'L'
             else Tile := '=';
         RT: If Dir1 = DN then Tile := '7'
             else if Dir1 = UP then Tile := 'J'
             else Tile := '=';
       end;

  PlaceTile(Tile, Snake.Body[Snake.Length-1].x,Snake.Body[Snake.Length-1].y);

end;

Procedure DrawTail;
var Dir1,Dir2,Tile: char;
begin
  Dir1 := Snake.Body[1].dir;
  Dir2 := Snake.Body[2].dir;

  Case Dir1 of
    UP: Tile := 'V';
    DN: Tile := '^';
    LT: Tile := '>';
    RT: Tile := '<';
  end;

  PlaceTile(Tile, Snake.Body[1].x,Snake.Body[1].y);

  Case Dir2 of
    UP: If Dir1 = LT then Tile := 'L'
        else if Dir1 = RT then Tile := 'J'
        else Tile := '';
    DN: If Dir1 = LT then Tile := ''
        else if Dir1 = RT then Tile := '7'
        else Tile := '';
    LT: If Dir1 = DN then Tile := '7'
        else if Dir1 = UP then Tile := 'J'
        else Tile := '=';
    RT: If Dir1 = DN then Tile := ''
        else if Dir1 = UP then Tile := 'L'
        else Tile := '=';
  end;

  PlaceTile(Tile, Snake.Body[2].x,Snake.Body[2].y);

end;

Procedure DrawSnake;
var i: word;
begin
  For i:=3 to Snake.Length-2 do
    begin
      PlaceTile('', Snake.Body[i].x,Snake.Body[i].y);
    end;
    
  DrawHead;
  DrawTail;
end;

Procedure DrawScore;
begin
  GoToXY(1,1);
  Write('Lives: ', Lives:1, '  Scores: ',Score);
  Hide_Cursor;
end;

Procedure KillSnake;
var i: word;
Begin
  For i:=1 to Snake.Length do
    begin
      PlaceTile('.', Snake.Body[i].x,Snake.Body[i].y);
      DelayEX(70);
      FlushKeyboard;
    end;

  For i:=1 to Snake.Length do
    begin
      PlaceTile(' ', Snake.Body[i].x,Snake.Body[i].y);
      DelayEX(70);
      FlushKeyboard;
    end;
End;

Function MoveSnake(Direction: char): boolean;
var TailX,TailY,DestX,DestY: byte;
    i: word;
begin
  DestX := Snake.Body[Snake.Length].x;
  DestY := Snake.Body[Snake.Length].y;

  Case Direction of
       UP: Dec(DestY);
       DN: Inc(DestY);
       LT: Dec(DestX);
       RT: Inc(DestX);
  End;

  If Board[DestX][DestY] = '#' then
    begin
      MoveSnake := false;
      exit;
    end;

  If Board[DestX][DestY] <> '!' then
     begin
       TailX := Snake.Body[1].x;
       TailY := Snake.Body[1].y;

       For i:=2 to Snake.Length do
           begin
             Snake.Body[i-1] := Snake.Body[i];
           end;

       PlaceTile(' ', TailX,TailY);
     end
  else
     begin
       Inc(Snake.Length);
       Inc(Score);
       If Interval > 0 then Dec(Interval);
       DrawScore;
       PlaceBonus;
     end;

  Snake.Body[Snake.Length].x := DestX;
  Snake.Body[Snake.Length].y := DestY;
  Snake.Body[Snake.Length].dir := Direction;
  Snake.Direction := Direction;
  
  DrawTail;
  DrawHead;

  MoveSnake := true;
end;

Function Play: boolean;
var Direction: char;
begin
  Score := 0;

  DrawScore;

  While true do
    begin
      Direction := GetDirection;

      Case Direction of
         ESC: begin
                KillSnake;
                Play := false;
                Exit;
              end;
          UP: If Snake.Direction = DN then Direction := DN;
          DN: If Snake.Direction = UP then Direction := UP;
          RT: If Snake.Direction = LT then Direction := LT;
          LT: If Snake.Direction = RT then Direction := RT;
        NONE: Direction := Snake.Direction;
      End;

      If not MoveSnake(Direction) then
         begin
           KillSnake;
           Play := true;
           Exit;
         end;

      DelayEx(Interval);
    end;
end;

(******** Main Program ************)

Begin
 Intro;
 DrawBoard;

 Lives := 3;
 Interval := 100;
 
 Repeat
   BuildSnake;
   DrawSnake;
   
   If Play 
      then Dec(Lives)
      else Lives := 0;
 Until Lives=0;
 
 ClrScr;
 LoadScreen('Bye.scr');
End.
