Unit XConsole;

INTERFACE   {----------------------------------------------}
uses dos;

Type
     screenchar = record
       c: char;
       a: byte;
     end;

     screen = array [0..1999] of screenchar;
     txtbuf = ^screen;

Const

 UP=#72;
 RT=#77;
 DN=#80;
 LT=#75;
 ESC=#27;

Var
    txtscr: screen absolute $B800:0000;
    REGS: registers;

procedure DelayEX(ms: word);
procedure putc(x,y: byte; c: char);
procedure puta(x,y,a: byte);
procedure putca(x,y: byte; c: char; a: byte);
procedure puts(x,y: byte; s: string);
procedure putsa(x,y: byte; s: string; a: byte);
procedure fill(x,y,h,w: byte; c: char);
procedure paint(x,y,h,w,a: byte);
procedure outline(x,y,h,w: byte);
procedure outlina(x,y,h,w,a: byte);
Procedure goto_xy(x,y: byte);
Procedure Hide_Cursor;
Procedure LoadScreen(s: string);

IMPLEMENTATION  {----------------------------------------------------}

var SystemTimer: LongInt absolute $40:$6C;

function ReadTimer: longint;
begin
 ReadTimer := SystemTimer;
end;

function ReadTimerChipCount: word;
var frec: word;
begin
 frec := port[$40];
 frec := frec or (port[$40] shl 8);
 ReadTimerChipCount := frec;
end;

function ReadOscelator: longint;
begin
  ReadOscelator := ((ReadTimer and $7fff)*$10000)
                or (65535-ReadTimerChipCount);
end;

procedure DelayEX(ms: word);
const k=1193180/1000;
var T: longint;
begin
 T := ReadOscelator + trunc(ms*k);
 Repeat until T <= ReadOscelator;
end;

procedure putc(x,y: byte; c: char);
begin
      txtscr[x+80*y].c:=c;
end;

procedure puta(x,y,a: byte);
begin
      txtscr[x+80*y].a:=a;
end;

procedure putca(x,y: byte; c: char; a: byte);
begin
      txtscr[x+80*y].c:=c;
      txtscr[x+80*y].a:=a;
end;

procedure puts(x,y: byte; s: string);
var i: byte;
begin
    for i:=1 to length(s) do
      begin
          txtscr[(x+i-1)+(80*y)].c:=s[i];
      end;
end;

procedure putsa(x,y: byte; s: string; a: byte);
var i: byte;
begin
    for i:=1 to length(s) do
      begin
          txtscr[(x+i-1)+(80*y)].c:=s[i];
          txtscr[(x+i-1)+(80*y)].a:=a;
      end;
end;

procedure fill(x,y,h,w: byte; c: char);
var ix,iy: byte;
begin
    for ix:=0 to w-1 do
        for iy:=0 to h-1 do
           txtscr[x+ix+80*(y+iy)].c:=c;
end;

procedure paint(x,y,h,w,a: byte);
var ix,iy: byte;
begin
    for ix:=0 to w-1 do
        for iy:=0 to h-1 do
           txtscr[x+ix+80*(y+iy)].a:=a;
end;

procedure outline(x,y,h,w: byte);
var ix,iy: byte;
begin
    putc(x-1,y-1,'');
    putc(x-1,y+h,'');
    putc(x+w,y-1,'');
    putc(x+w,y+h,'');

    for ix:=x to x+w-1 do
      begin
          putc(ix,y-1,'');
          putc(ix,y+h,'');
      end;

    for iy:=y to y+h-1 do
      begin
          putc(x-1,iy,'');
          putc(x+w,iy,'');
      end;
end;

procedure outlina(x,y,h,w,a: byte);
var ix,iy: byte;
begin
    putca(x-1,y-1,'',a);
    putca(x-1,y+h,'',a);
    putca(x+w,y-1,'',a);
    putca(x+w,y+h,'',a);

    for ix:=x to x+w-1 do
      begin
	  putca(ix,y-1,'',a);
	  putca(ix,y+h,'',a);
      end;

    for iy:=y to y+h-1 do
      begin
	  putca(x-1,iy,'',a);
	  putca(x+w,iy,'',a);
      end;
end;

procedure videoint;
begin
   inline($55);
   intr($10,regs);
   inline($5D);
end;

Procedure goto_xy(x,y: byte);
begin
  REGS.ah:=2;
  REGS.bh:=0;
  REGS.dh:=y;
  REGS.dl:=x;
  videoint;
end;

Procedure Hide_Cursor;
begin
  REGS.ah:=2;
  REGS.bh:=0;
  REGS.dh:=25;
  REGS.dl:=0;
  videoint;
end;

Procedure LoadScreen(s: string);

var Scr: Screen;
    f: file of Screen;
    c: char;
    x,y: byte;
    i: word;
begin

    Assign(f,s);
    reset(f);

    Read(f,Scr);

    close(f);

    i:=0;

    for y:= 0 to 24 do
    for x:= 0 to 79 do
      begin
           putc(x,y,Scr[i].c);
           puta(x,y,Ord(Scr[i].a));
           i := i+1;
      end;
end;

begin
end.