unit Struct;

interface
uses Windows, Graphics, Dialogs;

const
AMaxX= 50;
AMaxY= 50;

var GameA: array [1..AMaxX,1..AMaxY] of integer;

type TElem  = ^TStek; // 
     TStek   = record
     X:integer;   //  X
     Y:integer;   //  Y
     View: Byte;  //  
     Nomber: Word;// 
     Next: TElem; //  
     Prev: TElem; //  
     end;

TDir= 1..4; //

TSnake = object
First    : TElem; //  
Last     : TElem; //  
Direction: TDir;  // 
Length   : Word;  // 
Color    : TColor;// 

constructor Create(sDirection:TDir;sLength:Word;sX,sY:Byte;sColor:TColor);
//  
destructor Destroy;
// 

procedure Release; //     
procedure Draw(Canvas: TCanvas); // 
procedure DrawElement(Elem:TElem;Canvas:TCanvas); //   

function Move(newX,newY:word):boolean; //   
procedure Add;                  //   
procedure Remove;               //  

function GetByNomber(Nomber:Word):TElem; //   
function GetByCoord(X,Y:word):TElem;     //   

function SetDirection(sDirection:TDir):boolean;
procedure SetView(sView:byte);  //   
end;

implementation

constructor TSnake.Create(sDirection:TDir;sLength:Word;sX,sY:Byte;sColor:TColor);
var i:integer;
    Beg, Tek, Tek2: TElem;
begin
if sDirection = 3 then Direction:=1 else Direction:=sDirection;
Length:=sLength;
Color:=sColor;


First:=nil;
Last:=nil;

//     
if (sX<1) or (sX>AMaxX) or (sY<1) or (sY>AMaxY) or ((sX+sLength)>AMaxX) then begin ShowMessage('  '); exit end;

if sLength=0 then begin ShowMessage('  '); exit end;
new(Beg);

//  
Beg^.X:=sX+sLength;
Beg^.Y:=sY;
Beg^.View:=0;
Beg^.Nomber:=1;
Beg^.Next:=nil;
Beg^.Prev:=nil;

first:=beg; //   

Tek:=beg;
if sLength-1<1 then exit;
for i:=1 to (sLength-1) do begin

new(Tek2);

Tek2^.X:=Tek^.X-1; //   
Tek2^.Y:=Tek^.Y;   //  Y   
Tek2^.View:=0;     //    
Tek2^.Next:=nil;   //    ,     
Tek2^.Prev:=Tek;   //    

Tek2^.Nomber:=Tek^.Nomber+1; // 

Tek^.Next:=Tek2;
Tek:=Tek2;
Last:=Tek2;
end;

end;

destructor TSnake.Destroy;
var Tek, Tek2: TElem;
begin
Tek:=First;
if tek=nil then exit; //  

while tek^.Next<>nil do begin
Tek2:=Tek.Next;
dispose(tek2); //
tek:=tek2;
end;

dispose(First);
end;

procedure TSnake.Release;
var Tek: TElem;
begin
tek:=First;
if tek=nil then exit;
GameA[tek^.X,tek^.Y]:=1;
while tek^.Next<>nil do begin
tek:=tek^.Next;
GameA[tek^.X,tek^.Y]:=1; end;
end;

function TSnake.GetByNomber(Nomber:Word):TElem;
var Tek: TElem;
begin
Result:=nil;

if Nomber>Length then exit;
if First=nil then exit;

if Nomber=1 then begin Result:=First; exit end;
if Nomber=Length then begin Result:=Last; exit end;

Tek:=First;

while tek^.Next<>nil do begin
tek:=tek^.Next;
if tek^.Nomber=Nomber then begin Result:=tek; exit end;
end;
end;

function TSnake.GetByCoord(X,Y:word):TElem;
var Tek: TElem;
begin
Result:=nil;
//   
if First=nil then exit;

tek:=Last; if (Tek^.X=X) and (Tek^.Y=Y) then Result:=Tek;
tek:=First;if (Tek^.X=X) and (Tek^.Y=Y) then Result:=Tek;

while Tek^.Next<>nil do begin
Tek:=Tek^.Next;
if (Tek^.X=X) and (Tek^.Y=Y) then begin Result:=Tek; exit; end;
end;
end;

procedure Tsnake.DrawElement(Elem:TElem;Canvas:TCanvas);
var Rect:TRect;
begin
Rect.Left:=Elem.X*5;
Rect.Top:=Elem.Y*5;
Rect.Bottom:=Rect.Top+5;
Rect.Right:=Rect.Left+5;

Canvas.Pen.Color:=clBlack;
Canvas.Brush.Color:=Color;
case Elem.View of
0: Canvas.Rectangle(Rect);
end;
end;

procedure TSnake.Draw(Canvas:TCanvas);
var Tek: TElem;
begin
tek:=First;
if tek=nil then exit;
DrawElement(tek,Canvas);
while tek^.Next<>nil do begin
tek:=tek^.Next;
DrawElement(tek,Canvas); end;
end;

function TSnake.Move(newX,newY:word):boolean;
var tek :TElem;
    tek2: TElem;
begin
result:=false;
if First=nil then exit;

tek:=last;

if newX>AMaxX then newX:=1;
if newX<1     then newX:=AMaxX;
if newY>AMaxY then newY:=1;
if newY<1     then newY:=AMaxY;

Release;

if GameA[newX,newY]>0 then result:=true;

while tek^.Prev<>nil do begin
tek2:=tek^.Prev;
tek^.X:=tek2^.X;
tek^.Y:=tek2^.Y;
tek^.View:=tek2^.View;
tek:=tek2;
end;

First^.X:=newX;
First^.Y:=newY;

end;

function TSnake.SetDirection(sDirection:TDir):boolean;
begin
Result:=false;
if (sDirection=1) and (Direction=3) then exit;
if (sDirection=3) and (Direction=1) then exit;
if (sDirection=2) and (Direction=4) then exit;
if (sDirection=4) and (Direction=2) then exit;

Direction:=sDirection;
Result:=true;
end;

procedure TSnake.Add;
var tek:TElem;
begin

new(tek);
tek^.X:=0; //   ,
tek^.Y:=0; //       
tek^.Next:=nil;
tek^.Prev:=Last;
tek^.View:=Last^.View;
tek^.Nomber:=Last^.Nomber+1;
Last^.Next:=tek;

inc(length);

Last:=Tek;

end;

procedure TSnake.Remove;
var Tek:TElem;
begin
if Last=First then exit;

tek:=Last;
last:=tek^.Prev;
last^.Next:=nil;
dispose(tek);

inc(length,-1);
end;

procedure TSnake.SetView(sView:Byte);
var Tek: TElem;
begin
if First=nil then exit;
tek:=first;
first^.View:=sView;
while tek^.Next<>nil do begin
tek:=tek^.Next;
tek^.View:=sView;
end;

end;

end.
