.MODEL TINY
.386
.CODE
ORG 100h
;;
BIOSWrite MACRO AXX,BXX,CXX,DHX,DLX
      mov ax,AXX
      mov bx,BXX
      mov cx,CXX
      mov dh,DHX
      mov dl,DLX
      int 10h
ENDM

Start:

;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 砫 ⠭ ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;
      mov ax,3
      int 10h                    ; ⠢  802516
      call ReadDump              ; ⠥ 䠩   ⥪⮢ ࠭
      call SavePage              ; ࠭塞    殬 
      call GenerateOffsetTable   ; ਬ ⠡ ᬥ饭  ६
      mov CurMode,3              ;  ⥪饣 ० - 3
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; ⢥  横 ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@RefreshScreen:                  ;  ந室   
                                 ;  ࠭
      mov ax,3
      int 10h
      call HideCursor            ; 祬 
      call RestorePage           ; ⠭ . ࠭   1
; 뢮 ப  ०
@Loop:
      mov ax,0B800h
      mov es,ax
      mov di,ModeDigsOffset      ; ES:DI -  । ࠭
      mov al,CurMode             ; 騥 쪨
      call Byte2Screen           ; 뢮 
      push ds
      pop es                     ; ⠭ ES
;;;;;;;;;;;;;;;;;;;;;;;;;
;;; ⥭  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;
      mov ah,0
      int 16h                    ;  ᫥ ⢨
      cmp ax,011Bh               ; Escape -> 室
      je  @End
      cmp ax,4D00h               ; ५ ࠢ
      jne _Left_
      inc CurMode                ; 稢  ०
      jmp @Loop
_Left_:
      cmp ax,4B00h               ; ५ 
      jne _Enter_
      dec CurMode                ; 蠥  ०
      jmp @Loop
_Enter_:
      cmp ax,1C0Dh               ; Enter -> 뢮 ଠ樨
      jne _Space_
      mov al,CurMode             ;
      call ShowRegsInfo          ;  ଠ  
      call RestorePage           ; ⠭  1
      jmp @Loop
_Space_:
      cmp ax,3920h               ; Space ->  ०
      jne _Tab_
      mov ah,0
      mov al,CurMode
      call TestMode              ; 㥬
      jmp @RefreshScreen         ;  ⠭ ࠭
_Tab_:
      cmp ax,0F09h               ; Tab ->  ० 0 - 127
      jne _BackSpace_
      call TestAllModes          ; 㥬...
      jmp  @RefreshScreen        ;   ࠭
_BackSpace_:
      cmp ax,0E08h               ; ---  饥..
      jne _Home_
      ;call GetNewFNumber
      ;call SavePage
      jmp @End
_Home_:
      cmp ax,4700h               ; Home -> +...
      jne @Loop
      call GLukIntro             ;  
      jmp @RefreshScreen         ;   ࠭
@End:
      mov ax,2508h
      lds dx,OldInt8Handler
      int 21h                    ; ES:BX
      mov ax,4C00h               ; The end.
      int 21h

ModeDigsOffset EQU 80*2*10+76    ; 饭  न⠬ 뢮  ०
FillDig        EQU 04F103F2h     ; ⥫   
ParaTbl dd ?                     ;  ⠡ ࠬ஢ BIOS
CurMode db ?                     ; 騩 ०

ShowRegsInfo PROC
; 뢮 ଠ樨  ० AL
   push ds                    ; ࠭塞 ᯮ㥬 ॣ
   push es
   pusha
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 塞 ⥪ 묨 ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   lea di,ModeDigs            ; ८ࠧ㥬  ०, ।  室
   call Byte2Hex
   lea bp,Offsets+2           ; 砫 ⠡ ᬥ饭 + 2, .. ᬥ饭 1 -
                              ;  ModeDigs
   mov dx,es:[bp+6]           ; DX - ᬥ饭  4 ࠬ ⨯ Word, 
                              ; ਣ...
   mov cx,ECnt                ; - ⮢ ⠡ ࠬ஢
   push ds                    ; . DS
   lds si,ParaTbl             ;  ⠡ ࠬ஢
   mov ah,0
   shl ax,6                   ; 塞 ᬥ饭  㦭 ⠡
   add si,ax                  ; AX*64 (64   ⠡)
@NextOffs:
   mov di,es:[bp]             ; 砥 ᬥ饭  ⠡ ᬥ饭
   lodsb                      ; 砥   ⠡ ࠬ஢
   call Byte2Hex              ; ८ࠧ㥬
   inc bp
   inc bp                     ; 稢 稪
loop @NextOffs
   pop ds                     ; . DS

; 塞 ⠬   ࠬ 3, ⨯ Word

   mov si,dx                  ; ...  ᬥ饭
   mov di,si                  ;
   lodsw
   mov bx,ax
   lodsw                      ; 砥  ᫮
   stosw
   xchg ax,bx                 ;   ⭮ 浪,  ᫥⢨
   stosw                      ;  祭 쥣 ࠬ
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; ࠭筮 ⮡ࠦ ନ஢ ଠ樨 ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   lea si,Paraf               ;  ᬥ饭 ࠭
   lea dx,Strt                ; ⮢ ᬥ饭
   mov cx,ParaCnt             ; - ࠭
   call ClearScreen           ; 頥 ࠭
@Print:
   mov ah,9
   int 21h
   mov ah,0
   int 16h
   cmp ax,011Bh
   je  @StopPrint             ; Escape -> 室
   lodsw
   mov dx,ax                  ; 饭  砫 ᫥饩 ࠭
   call ClearScreen           ; 頥 ࠭
   loop @Print
@StopPrint:
   popa                       ; ⠭ ,  﫨
   pop es
   pop ds
   ret
; ⢥ ᠬ ⥪
Strt     db ' #'
ModeDigs db '??',13,10
         db 13,10,'>>> ୮ ࠭, ᨬ <<<',13,10,13,10
         db '⮫殢       : ??',13,10
         db 'ப (-1)     : ??',13,10
         db ' ᨬ : ??',13,10
         db '  ࠧ饭 ࠭: ????',13,10
         db 13,10,'>>>  ॣ <<<',13,10,13,10
         db '" ஭樨"       ( 3C5h,  1) : ??',13,10
         db '"᪨஢ "       ( 3C5h,  2) : ??',13,10
         db '"롮  ᨬ" ( 3C5h,  3) : ??',13,10
         db '" "              ( 3C5h,  4) : ??',13,10
         db '"蠭"                 ( 3CFh,  6) : ??',13,10
         db '$'    ; ਧ  ࠭
         db 13,10,'>>>   <<<',13,10,13,10
         db '"騩 ਧ⠫": ??',13,10
         db '" 襭 뢮  ਧ⠫": ??',13,10
         db '"砫 ⥬  ਧ⠫": ??',13,10
         db '" ⥬  ਧ⠫": ??',13,10
         db '"砫 ⭮ ஢  ਧ⠫": ??',13,10
         db '" ⭮ ஢  ਧ⠫": ??',13,10
         db '"騩 ⨪": ??',13,10
         db '"९": ??',13,10
         db '"।⥫쭠 筠 ⪠": ??',13,10
         db '"ᨬ쭠 ப ⪨": ??',13,10
         db '"砫 Kypcopa": ??',13,10
         db '" ": ??',13,10
         db '" ᯮ": ??,??,??,??',13,10
         db '"砫 ⭮    ": ??',13,10
         db '" ⭮    ": ??',13,10
         db '" 襭 뢮 ஢": ??',13,10
         db '"饭": ??',13,10
         db '" ન": ??',13,10
         db '"砫 ⥬  ": ??',13,10
         db '" ⥬  ": ??',13,10
         db '"ࠢ ": ??',13,10
         db '"ࠢ ப": ??',13,10
         db '$'
         db '  >>>   <<<',13,10
         db 'ͻ',13,10
         db ' 00: ??  01: ??  02: ?? ',13,10
         db ' 03: ??  04: ??  05: ?? ',13,10
         db ' 06: ??  07: ??  08: ?? ',13,10
         db ' 09: ??  10: ??  11: ?? ',13,10
         db ' 12: ??  13: ??  14: ?? ',13,10
         db ' 15: ??                 ',13,10
         db 'ͼ',13,10
         db 13,10,'>>> ⠭ ॣ஢ ਡ <<<',13,10,13,10
         db '"ࠢ "             : ??',13,10
         db '" "                     : ??',13,10
         db '"襭 ⮢ "    : ??',13,10
         db '"ਧ⠫쭮 ࠬ஢" : ??',13,10
         db '$'
         db 13,10,'>>>  ᪮ ஫ <<<',13,10,13,10
         db '"⠭/"             : ??',13,10
         db '"襭 ⠭/" : ??',13,10
         db '"ࠢ ⮢"            : ??',13,10
         db '"᪨ "           : ??',13,10
         db '"롮 奬 ⥭"          : ??',13,10
         db '" "               : ??',13,10
         db '"蠭"                   : ??',13,10
         db '" ࠧ祭"            : ??',13,10
         db '"⮢ ᪠"               : ??',0FFh,'$'

TextLength EQU $-Strt         ;  ⥪

ECnt    DW ?                  ; - ⮢
Offsets DW 200 DUP (?)        ;  ᬥ饭 ࠬ஢
ParaCnt DW ?                  ; - ࠭
Paraf   DW 20 DUP (?)         ;  ᬥ饭 ࠭
EndP

Byte2Hex Proc
;;  室 ES:DI -  ਥ; AL - ᫮ ;;
; ࠭塞 ᯮ㥬 ॣ
      push ax
      push ax
      ;cld
      shr al,4          ; 뤥塞 訩 㡠, ᤢ  4  ࠢ
      add al,30h        ; ८ࠧ㥬  ASCII-
      cmp al,39h        ;
      jbe $+4           ; ᫨  㪢
      add al,7          ; 塞  7
      stosb             ; 
      pop ax
      and al,0Fh        ; 뤥塞 訩 㡠
      add al,30h        ; ८ࠧ㥬  ASCII-
      cmp al,39h
      jbe $+4
      add al,7          ;   ࠧ
      stosb             ;  
      pop ax
      ret
EndP

Byte2Screen Proc
;;  室 ES:DI -  ਥ; AL - ᫮ ;;
;; ८ࠧ  ᫥騩 뢮   ࠭  16- /
;;   0B800:XXXX
      push ax
      push ax
      shr al,4          ; 뤥塞 訩 㡠, ᤢ  4  ࠢ
      add al,30h        ; ८ࠧ㥬  ASCII-
      cmp al,39h        ;
      jbe $+4           ; ᫨  㪢
      add al,7          ; 塞  7
      stosb             ; 
      inc di            ; +
      pop ax
      and al,0Fh        ; 뤥塞 訩 㡠
      add al,30h        ; ८ࠧ㥬  ASCII-
      cmp al,39h
      jbe $+4
      add al,7          ;   ࠧ
      stosb             ;  
      pop ax
      ret
EndP

ClearScreen PROC
; ⪠ ࠭ + ⠭ 
    pusha
    push es
    mov ax,0B800h
    mov es,ax
    xor di,di
    mov cx,1000
    mov eax,07200720h
    rep stosd               ; 20h - ஡, 7 - 梥 ᢥ⫮-, 䮭 - 
    mov ah,2
    mov bh,0
    xor dx,dx
    int 10h                 ;    孨 㣮
    pop es
    popa
    ret
EndP

TestMode PROC
;;  ०  AL
    pusha
    push es
    push ds
    mov cl,al
    mov ah,0
    int 10h                ; ⠭ ० (஡㥬 ;)
    mov ah,0Fh
    int 10h
    cmp cl,al              ; 砥  , ࠢ  ⠭
    jne _TestEnd_
    mov byte ptr PELNr,7   ;     ० 0-13h
    lea di,Digs
    call Byte2Hex          ; ८ࠧ㥬  ⠭ ०
    lea bp,Stat            ; ப
    BIOSWrite 1300h,7,ModeStringLength,0Ch,40-ModeStringLength/2
    mov eax,FillDig        ; 04010302h
    mov edx,eax            ;  饥  ᫥饣 㢥祭
;  64    0A000:0
_F1_:
    mov ah,0
    int 16h
    cmp ax,3B00h           ; F1
    jne _F2_
_A0Rec_:
    mov ax,0A000h
    mov es,ax              ;
    mov cx,16000
    jmp _Record_
;  4    0B800:0
_F2_:
    cmp ax,3C00h           ; F2
    jne _F3_
_B8Rec_:
    mov ax,0B800h
    mov es,ax
    mov cx,1000
    jmp _Record_
;  2    0B000:0
_F3_:
    cmp ax,3D00h           ; F3
    jne _F4_
_B0Rec_:
    mov ax,0B000h
    mov es,ax
    mov cx,480
    jmp _Record_
; ⮢롮 砫   -   
_F4_:
    cmp ax,3E00h           ; F4 - ⮢롮
    jne _TestEnd_
    mov al,CurMode
    cmp al,0
    jb  _NotSupported_
    cmp al,13h
    ja  _NotSupported_      ; 쪮  ० 0-13h
    cmp al,6
    ja  _0B000_
    jmp _B8Rec_
_0B000_:
    cmp al,7
    ja  _0A000_
    jmp _B0Rec_
_0A000_:
    jmp _A0Rec_
_NotSupported_:
    lea bp,NotSupportedStr            ; ப
    BIOSWrite 1300h,4,SupportLength,0Ch,40-SupportLength/2
    jmp _F1_
_Record_:
    mov eax,edx
    add eax,FillDigInc
    mov edx,eax
    xor di,di
    rep stosd
    jmp _F1_
_TestEnd_:
    mov byte ptr PELNr,1

    pop ds
    pop es
    popa
    ret

Stat db 'Mode '
Digs db '??'
ModeStringLength EQU $-Stat
NotSupportedStr db 'Only for modes 0-13h...'
SupportLength EQU $-NotSupportedStr
FillDigInc EQU 10

EndP

GenerateOffsetTable PROC
;;; ⮢ ᨢ ᬥ饭 ६ ;;;
      pusha
      push ds
      push es
      cld
      lea di,Strt                ; ⮢ ᬥ饭  ᪠
      mov cx,TextLength          ;  ⥪
      lea si,Offsets             ;  ᬥ饭
      xor dx,dx                  ; 稪 ⮢
      push di
      push cx                    ; ࠭塞  . ᯮ짮
      mov al,'?'                 ; 饬 ⥫ 
@NextQuest:
      repne scasb
      jnz @End
      cmp byte ptr es:[di],'?'   ; 饬    
      jne @NextQuest
      dec di                     ;  ᨬ '?'
      mov [si],di                ;  ᬥ饭  ⠡
      inc si
      inc si
      inc di
      inc di
      cmp byte ptr es:[di],0FFh  ;  ᪠
      je  @TextEnd
      inc dx
      jmp @NextQuest
@TextEnd:
      mov ECnt,dx                ; 饥 - ⮢
      pop cx                     ;  ⥪
      pop di                     ; ⮢ ᬥ饭  ᪠
      lea si,Paraf               ;  ᬥ饭 ࠭
      xor dx,dx                  ; 稪
      mov al,'$'                 ; 饬 
;;; ⮢ ᨢ ᬥ饭 ࠭ ;;;
@NextPara:
      repne scasb
      jnz @End
      mov [si],di                ;  ᬥ饭 ᫥ 
      inc si
      inc si
      cmp byte ptr es:[di-2],0FFh ;  ᪠
      je  @TextE
      inc dx                     ; 饥 - ⮢
      jmp @NextPara
@TextE:
      inc dx
      mov ParaCnt,dx
;;; 砥   ࠬ஢ BIOS ;;;
      push ds
      mov ax,40h
      mov ds,ax                    ; DS:SI ->   ࠭
      mov si,0A8h                  ; (40h:0A8h)
      lodsw
      mov bx,ax
      lodsw
      mov ds,ax                    ;    ࠬ஢
      mov si,bx                    ;  ᥣ   C000:????
      lodsd
      pop ds
      mov ParaTbl,eax              ; ->   ࠬ஢
;;; ⠢ ᢮ ࠡ稪 뢠  ⠩ ;;;
      mov ax,3508h
      int 21h                      ; ࠭塞  ண ࠡ稪
      mov word ptr OldInt8Handler,bx
      mov word ptr OldInt8Handler + 2,es
      lea dx,Int8Handler
      mov ax,2508h
      int 21h                      ; ⠭ ᢮ ࠡ稪 int8
      pop es
      pop ds
      popa
      ret
EndP

SavePage PROC
; . ⥪⮢ ࠭   @CodeEnds
    pusha
    push ds
    push es
    mov ax,0B800h
    mov ds,ax
    xor si,si
    lea di,@CodeEnds
    mov cx,1000
    rep movsd
    pop es
    pop ds
    popa
    ret
EndP

RestorePage PROC
; ७ 묨 ᫮    @CodeEnds  0B800:0
    pusha
    push ds
    push es
    mov ax,0B800h
    mov es,ax
    xor di,di
    lea si,@CodeEnds
    mov cx,1000
    rep movsd
    pop es
    pop ds
    popa
    ret
EndP

ReadDump PROC
; ⠥ 4000   䠩 FName   0B800:0
   push ax
   push bx
   push dx
   push cx
   push ds
   mov ax,3D02h
   lea dx,FName
   int 21h
   jc @NotExist
   mov bx,ax
   mov ax,0B800h
   mov ds,ax
   xor dx,dx
   mov ah,3Fh
   mov cx,4000
   int 21h
   mov ah,3Eh
   int 21h
@NotExist:
   pop ds
   pop cx
   pop dx
   pop bx
   pop ax
   ret
FName db 'dump.scr',0
EndP

HideCursor PROC
; 뢠 
   push ax
   push dx
   mov dx,3D4h
   push dx
   mov al,0Ah
   out dx,al         ; 砥  ॣ
   inc dx
   mov al,1          ; 祭 孥 ᪥-
   out dx,al
   pop dx
   mov al,0Bh
   out dx,al
   inc dx
   mov al,0
   out dx,al
   pop dx
   pop ax
   ret
EndP

TestAllModes PROC
;;;  ⢮ প ⠭ ०  0  127 
;;; ஭ BIOS.  ஢ન ᯮ  㭪樨 10h 뢠:
;;; 0Fh ( ⥪饥 ﭨ) & 00 (⠭ ०).
;;;  室 DS=ES=ᥣ 
   pusha
   push es
   push ds                      ; Save
   lea si,ModeList
   lea di,@CodeEnds+4000        ;
   mov bp,di                    ;  ᫥饣 뢮 ப
   mov cx,ModeListLength
   rep movsb                    ; ७ᨬ ப    + 4000 
   xor dx,dx                    ; 稪  ப
   mov bx,dx                    ; 稪 ⮢
   mov cx,127                   ; 127 ०, ᪫ 㫥
_NextMode_:
   mov ah,0
   mov al,cl
   push di                      ; 易⥫쭮 . - 祣 BIOS'a!!
   int 10h                      ; ஡㥬 ⠭ ०
   pop di
   mov ah,0Fh
   int 10h
   cmp al,cl
   jne _DecModeN_               ; ਬ  稫...
   inc dx
   call Byte2Hex
   cmp dx,25                    ; 稪 ॢ ப (25*3=75)
   jne _Comma_
   add bx,dx
   xor dx,dx
   mov ax,0A0Dh                 ; ॢ ப +  ⪨
   stosw
   jmp _DecModeN_
_Comma_:
   mov al,','
   stosb
_DecModeN_:
   loop _NextMode_
   cmp byte ptr es:[di-1],','   ; ࠢ,  ⮩ 
   jne _SetTotalCnt_
   mov byte ptr es:[di-1],'.'   ; ᫨ , ⠢ 
_SetTotalCnt_:
   push di                      ;   饣 -
   lea di,ModesCntDigs
   mov al,bl
   call Byte2Hex                ; ନ㥬 ન
   pop di
   lea si,ModesCount
   mov cx,ModesCntLength
   rep movsb                    ; ७ᨬ ନ஢ ப
   mov si,di                    ;  
   mov ax,3
   int 10h
   mov ah,9
   mov dx,bp                    ;  ᠬ BP
   int 21h                      ;
   mov ah,0
   int 16h
   cmp ax,3B00h                 ; F1 - ࠭  䠩 list.mds
   jne _AllTestEnd_
   mov ah,3Ch
   mov cx,20h
   lea dx,ListName
   int 21h
   mov bx,ax
   mov cx,si
   lea ax,@CodeEnds+4000
   mov dx,ax                    ; DS:DX - 
   sub cx,ax                    ; 쪮 ...
   dec cx                       ;  $
   mov ah,40h
   int 21h
_AllTestEnd_:
   pop ds
   pop es
   popa
   ret
ModeList db '᮪ ०:',13,10
ModeListLength EQU $-ModeList
ModesCount db 13,10,'饥 ⢮: '
ModesCntDigs db '??$'
ModesCntLength EQU $-ModesCount
ListName db 'list.mds',0
EndP

GLukIntro PROC
   pusha
   push es
   push ds
   mov byte ptr STOP,1
   mov ax,3D02h
   lea dx,GName
   int 21h
   mov bx,ax
   push ds
   mov ax,0B800h
   mov ds,ax
   mov cx,4000
   mov ah,3Fh
   xor dx,dx
   int 21h
   pop ds
   mov ah,3Eh
   int 21h          ; 뢠 䠩, ⠥  , 뢠.
   mov bx,60
   mov cl,0         ;  饭
_NextRGB_:
   mov dx,3C8h
   mov al,1
   out dx,al
   inc dx
   mov al,bh
   out dx,al
   out dx,al
   out dx,al        ;   㬫. - ᨭ
   dec dx
   mov al,2
   out dx,al
   inc dx
   mov al,bl
   out dx,al
   out dx,al
   out dx,al        ;   㬫. - 
   mov     dx,3DAh
_Wait1_:
   in      al,dx
   test    al,8
   jnz     _Wait1_
_Wait2_:
   in      al,dx
   test    al,8
   jz      _Wait2_
   or cl,cl         ;  㫥?
   jnz _Invert_
   dec bl
   inc bh
   jmp _CheckCL_
_Invert_:
   inc bl
   dec bh
_CheckCL_:
   cmp bh,60
   je  _InvertFlag_
   or bh,bh
   jnz _CheckKey_
_InvertFlag_:
   not cl
_CheckKey_:
   mov ah,1
   int 16h
   jz _NextRGB_
   mov ah,0
   int 16h
   mov byte ptr STOP,0              ; 蠥 ࠡ稪 int8
   pop ds
   pop es
   popa
   ret
GName db 'gluk.scr',0
EndP

Int8Handler PROC
   pushf
   call CS:OldInt8Handler           ; 뢠  ࠡ稪
   push ax
   cmp byte ptr CS:STOP,1
   je  _DontPlay_
   push cx
   push dx
   jmp _StartProg_
Filler         db 0                 ; 祭 ⥪饣 梥 PEL ॣ
OldInt8Handler dd ?                 ;  ࠡ稪
DirFlag        db 0                 ;  ࠢ (inc or dec)
ModValue       db 6                 ; 祭 饭
PELNr          db 1                 ;  ॣ  䨪樨
STOP           db 0                 ;    
_StartProg_:

   mov dx,3C8h
   mov al,CS:PELNr
   out dx,al                        ; 頥   襬 ७
   inc dx                           ; DX=3C9h,  
   mov al,byte ptr CS:Filler
   mov cl,byte ptr CS:ModValue
   cmp CS:DirFlag,0                 ; 塞 ࠢ
   jne _Decrease_
   add al,cl
   add byte ptr CS:Filler,cl        ; ਡ塞
   jmp _SetColor_
_Decrease_:
   sub al,cl                        ; 塞
   sub byte ptr CS:Filler,cl
_SetColor_:
   out dx,al                        ; ⢥ ᠬ 䨪
   out dx,al
   out dx,al
   cmp al,0                         ; ஢塞 ࠭ ᫮ 
   jle _Maybe60_
   dec CS:DirFlag
_Maybe60_:
   cmp al,60
   jge _NotChange_
   inc CS:DirFlag                   ;  砥 室 塞 祭 䫠...
_NotChange_:                        ; ...ࠢ
   pop dx
   pop cx
_DontPlay_:
   mov al,20h                       ;  EOI  ஫ 뢠
   out 20h,al
   pop ax
   iret
EndP

@CodeEnds:
END Start