{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

USES gxcrt,gxcrtext,gxtype,gxbase,gxsup,graphix,gximg,gxmouse,gx3d,gx3dtype,gximeff,
     gxdemo1,gxdemo2,gxdemo3,gxdemo4,gxdemo5,gxdemo6,gxdemot;

CONST mlxL=78;
      mlxH=86;
      alpha=192;

VAR wx,wy:longint;
    GXpointer:PMousePointer;
    GXpointerImg,GXTempPointerImg:pimage;
    ende:boolean;
    maxidx:word;

FUNCTION MouseArea(x1,y1,x2,y2:longint):boolean;
BEGIN
  MouseArea:=FALSE;
  IF (IsMouseInArea(x1,y1,x2,y2)=129) THEN
    BEGIN
      MouseOff;
      barXOR(x1,y1,x2,y2,$FFFFFF);
      MouseOn;
      WaitButtonReleased;
      MouseOff;
      barXOR(x1,y1,x2,y2,$FFFFFF);
      MouseOn;
      IF (IsMouseInArea(x1,y1,x2,y2)=128) THEN MouseArea:=TRUE;
    END;
END;

PROCEDURE GXDrawMouseCursor(x,y:longint;fg,bg:pimage);
BEGIN
  copyimage(GXTempPointerImg,bg);
  composeimageC(GXTempPointerImg,fg,0,0);
  blendimageALPHAimage(GXTempPointerImg,GXTempPointerImg,alpha,bg);
  putimage(x,y,GXTempPointerImg);
END;

PROCEDURE gxsetmousepointer;
BEGIN
  LoadImageFile(itBMP,'gxmp2.bmp',GXpointerimg,0);
  setimagetransparencycolor(GXpointerimg,rgbcolorRGB(255,255,255));
  setimageflags(GXpointerimg,img_transparency);
  CreateMousePointer(gxpointer,0,0,gxpointerimg);
  SetMousePointer(gxpointer);
  GXTempPointerImg:=CloneImage(GXPointerImg);
  SetDrawMouseCursorProc(@GXDrawMouseCursor);
END;

PROCEDURE gxresetmousepointer;
BEGIN
  ResetMousePointer;
  Destroymousepointer(GXpointer);
  DestroyImage(GXpointerimg);
  DestroyImage(GXtemppointerimg);
END;

PROCEDURE shadedbar(x1,y1,x2,y2,col1,col2,col3,col4:longint);
VAR rend:trender;
BEGIN
  IF LFBenabled OR MFBused THEN
    BEGIN
      rend.points[0].x:=x1;
      rend.points[0].y:=y1;
      rend.points[1].x:=x2;
      rend.points[1].y:=y1;
      rend.points[2].x:=x1;
      rend.points[2].y:=y2;
      rend.colors[0]:=col1;
      rend.colors[1]:=col2;
      rend.colors[2]:=col3;
      triangle_gouraud(prender(addr(rend)));
      rend.points[0].x:=x2;
      rend.points[0].y:=y1;
      rend.points[1].x:=x1;
      rend.points[1].y:=y2;
      rend.points[2].x:=x2;
      rend.points[2].y:=y2;
      rend.colors[0]:=col2;
      rend.colors[1]:=col3;
      rend.colors[2]:=col4;
      triangle_gouraud(Prender(addr(rend)));
    END;
END;

PROCEDURE WriteText2(x,y:longint;s:string);
BEGIN
  ft2^.outtext(x+1,y+1,s,rgbcolor($000050));
  ft2^.outtext(x,y,s,rgbcolor($FFFFFF));
END;

PROCEDURE BaseScreen320x200;
BEGIN
  MouseOff;
  bar(0,0,getmaxX,getmaxY,rgbcolorRGB(0,0,80));
  shadedbar(0,100,getmaxX,getmaxY,rgbcolorRGB(0,0,80),rgbcolorRGB(0,0,80),rgbcolorRGB(192,192,192),rgbcolorRGB(192,192,192));
  MouseOn;
END;

PROCEDURE BaseScreen640x480;
VAR gxlogo:pointer;
BEGIN
  MouseOff;
  LoadImageFile(itGIF,'gxlogo.gif',gxlogo,0);
  bar(0,0,getmaxX,getmaxY,rgbcolorRGB(0,0,80));
  shadedbar(0,100,getmaxX,getmaxY,rgbcolorRGB(0,0,80),rgbcolorRGB(0,0,80),rgbcolorRGB(192,192,192),rgbcolorRGB(192,192,192));
  putimage(20,10,gxlogo);
  ft3^.outtext(25,13,vergraphix,rgbcolor($00FFFFFF));
  DestroyImage(gxlogo);
  MouseOn;
END;

PROCEDURE InfoScreen320x200;
VAR gxmenu:pointer;
    x,y:longint;
    modeinfolist:Pmodeinfoentry;
    modeinfo:Tmodeinfoentry;
BEGIN
  MouseOff;
  wx:=(getmaxX+1-320) DIV 2;
  wy:=(getmaxY+1-200) DIV 2;
  LoadImageFile(itBMP,'gxmenu2.bmp',gxmenu,0);
  shadedbar(wx+1,wy,wx+318,wy+47,rgbcolorRGB(192,192,192),rgbcolorRGB(96,96,136),rgbcolorRGB(96,96,136),rgbcolorRGB(0,0,80));
  shadedbar(wx+1,wy+49,wx+318,wy+198,rgbcolorRGB(192,192,192),rgbcolorRGB(96,96,136),rgbcolorRGB(96,96,136),rgbcolorRGB(0,0,80));
  putimage(wx+1,wy+1,gxmenu);
  bar(wx+2,wy+51,wx+317,wy+197,-1);
  rectangle(wx+2,wy+51,wx+317,wy+197,0);
  x:=wx+5;
  y:=wy+53;
  maxidx:=0;
  modeinfolist:=CreateModeInfoList;
  WHILE GetNextModeInfo(modeinfolist,modeinfo) AND (x<=wx+315) DO
    BEGIN
      inc(maxidx);
      IF (getmaxX=modeinfo.xres-1) AND
         (getmaxY=modeinfo.yres-1) AND
         (gxcurflags=modeinfo.flags) THEN
        BEGIN
          bar(x-2,y-1,x+mlxL-1,y+ft1^.fontheight-1,rgbcolorRGB(0,90,0));
          ft1^.outtext(x,y,modeinfo.name,rgbcolorRGB(220,130,0));
        END
      ELSE
        BEGIN
          ft1^.outtext(x,y,modeinfo.name,0);
        END;
      inc(y,ft1^.fontheight);
      IF (y>wy+196) THEN
        BEGIN
          y:=wy+53;
          x:=x+mlxL;
        END;
    END;
  DeleteModeInfoList(modeinfolist);
  MouseOn;
END;

PROCEDURE InfoScreen640x480;
VAR gxmenu:pointer;
    x,y:longint;
    s:string;
    modeinfolist:Pmodeinfoentry;
    modeinfo:Tmodeinfoentry;
BEGIN
  MouseOff;
  wx:=getmaxX DIV 2-300;
  wy:=getmaxY DIV 2-50;
  IF (getmaxY<=399) THEN wy:=getmaxY-290;

  LoadImageFile(itBMP,'gxmenu.bmp',gxmenu,0);

  shadedbar(wx-7,wy-80,wx+517,wy+55,rgbcolorRGB(192,192,192),rgbcolorRGB(96,96,136),rgbcolorRGB(96,96,136),rgbcolorRGB(0,0,80));
  shadedbar(wx-7,wy+60,wx+517,wy+275,rgbcolorRGB(192,192,192),rgbcolorRGB(96,96,136),rgbcolorRGB(96,96,136),rgbcolorRGB(0,0,80));
  putimage(wx+527,wy-80,gxmenu);

  bar(wx-4,wy+63,wx+514,wy+273,-1);
  rectangle(wx-4,wy+63,wx+514,wy+273,0);
  x:=wx;
  y:=wy+65;
  maxidx:=0;
  modeinfolist:=CreateModeInfoList;
  WHILE GetNextModeInfo(modeinfolist,modeinfo) DO
    BEGIN
      inc(maxidx);
      IF (getmaxX=modeinfo.xres-1) AND
         (getmaxY=modeinfo.yres-1) AND
         (gxcurflags=modeinfo.flags) THEN
        BEGIN
          bar(x-3,y-1,x+mlxH-3,y+ft1^.fontheight-1,rgbcolorRGB(0,90,0));
          ft1^.outtext(x,y,modeinfo.name,rgbcolorRGB(220,130,0));
        END
      ELSE
        BEGIN
          ft1^.outtext(x,y,modeinfo.name,0);
        END;
      inc(y,ft1^.fontheight);
      IF (y>wy+270) THEN
        BEGIN
          y:=wy+65;
          x:=x+mlxH;
        END;
    END;
  WriteText2(wx,wy-75,'Graphics Device . . . . . .');
  WriteText2(wx+205,wy-75,CurGraphiX.name);
  WriteText2(wx,wy-50,'Graphics Memory . . . . .');
  WriteText2(wx+205,wy-50,long2str(CurGraphiX.memory)+' KB');
  WriteText2(wx,wy-25,'Name . . . . . . . . . . . . . . .');
  WriteText2(wx+205,wy-25,CurGraphiX.vendorname);
  WriteText2(wx,wy,'Output Mode . . . . . . . . .');
  IF LFBenabled THEN s:='Linear Frame Buffer' ELSE s:='Banked Frame Buffer';
  IF HWAenabled THEN s:=s+' + Hardware';
  WriteText2(wx+205,wy,s);
  WriteText2(wx,wy+25,'Current Mode  . . . . . . . .');
  WriteText2(wx+205,wy+25,gxcurresname+'x'+gxcurcolname);
  DestroyImage(gxmenu);
  MouseOn;
END;

PROCEDURE BaseScreen;
BEGIN
  StartDraw;
  CASE gxcurres OF
  $03200200..$05120480:BaseScreen320x200;
  $06400350..$16001200:BaseScreen640x480;
  END;
  EndDraw;
END;

PROCEDURE InfoScreen;
BEGIN
  StartDraw;
  CASE gxcurres OF
  $03200200..$05120480:InfoScreen320x200;
  $06400350..$16001200:InfoScreen640x480;
  END;
  EndDraw;
END;

PROCEDURE Graphix3DDemo;
VAR bg:pointer;
    flags:dword;
    sf:PSurface;
BEGIN
{  createimage(0,0,getmaxX,getmaxY,bg);
  getimage(0,0,bg);
  saveimagebmp('savescrn.bmp',bg);
  Destroyimage(bg); }
  IF LFBenabled THEN flags:=gxsf_videomem ELSE flags:=gxsf_sysmem;
  BaseScreen;
  MouseOff;
  bg:=createimage(0,0,getmaxX,getmaxY);
  getimage(0,0,bg);
  EnableSurfaceFlipping(sf,flags);
  GraphixDemo1(bg);
  DisableSurfaceFlipping(sf);
  Destroyimage(bg);
  MouseOn;
  BaseScreen;
  InfoScreen;
END;

PROCEDURE GraphixClassicDemo;
VAR bg:pointer;
BEGIN
  BaseScreen;
  MouseOff;
  bg:=createimage(0,0,getmaxX,getmaxY);
  getimage(0,0,bg);
  GraphixDemo2(bg);
  Destroyimage(bg);
  MouseOn;
  BaseScreen;
  InfoScreen;
END;

PROCEDURE GraphixTextDemo;
BEGIN
  BaseScreen;
  MouseOff;
  GraphixDemo3;
  MouseOn;
  BaseScreen;
  InfoScreen;
END;

PROCEDURE GraphiXEffectsDemo;
VAR bg:pointer;
BEGIN
  MouseOff;
  bg:=createimage(0,0,getmaxX,getmaxY);
  getimage(0,0,bg);
  GraphixDemo4(bg);
  Destroyimage(bg);
  MouseOn;
END;

PROCEDURE GraphiXMediaDemo;
BEGIN
  GraphixDemo5;
  BaseScreen;
  InfoScreen;
END;

PROCEDURE GraphiXImageDemo;
BEGIN
  GraphixDemo6;
  BaseScreen;
  InfoScreen;
END;

PROCEDURE SwitchMode(idx:word);
VAR modeinfolist:Pmodeinfoentry;
    modeinfo:Tmodeinfoentry;
BEGIN
  IF (idx<=maxidx) THEN
    BEGIN
      modeinfolist:=CreateModeInfoList;
      WHILE (idx>0) DO
        BEGIN
          GetNextModeInfo(modeinfolist,modeinfo);
          dec(idx);
        END;
      DeleteModeInfoList(modeinfolist);
      GXResetmousepointer;
      DisableMouse;
      DoneGXDemo;
      SetModeGraphiX(modeinfo.xres,modeinfo.yres,(modeinfo.flags AND ig_colmask));
      InitGXDemo;
      BaseScreen;
      InfoScreen;
      ReInitmouse;
      GXSetmousepointer;
      MouseOn;
    END;
END;

PROCEDURE SelectMode320x200;
VAR x,y,ax,ay,mx,my:longint;
BEGIN
  mousecoords(x,y);
  IF (IsMouseInArea(wx+5,wy+52,wx+316,wy+196)>0) THEN
    BEGIN
      mx:=(x-wx-5) DIV mlxL;
      my:=(y-wy-52) DIV ft1^.fontheight;
      ax:=mx*mlxL+wx+5;
      ay:=my*ft1^.fontheight+wy+52;
      MouseOff;
      barXOR(ax-2,ay,ax+mlxL-1,ay+ft1^.fontheight,$FFFFFF);
      MouseOn;
      WaitButtonReleased;
      MouseOff;
      barXOR(ax-2,ay,ax+mlxL-1,ay+ft1^.fontheight,$FFFFFF);
      MouseOn;
      mousecoords(x,y);
      ax:=(x-wx-5) DIV mlxL;
      ay:=(y-wy-52) DIV ft1^.fontheight;
      IF (ax=mx) AND (ay=my) THEN SwitchMode(ax*9+ay+1);
    END;
END;

PROCEDURE SelectMode640x480;
VAR x,y,ax,ay,mx,my:longint;
BEGIN
  mousecoords(x,y);
  IF (IsMouseInArea(wx-3,wy+64,wx+512,wy+271)>0) THEN
    BEGIN
      mx:=(x-wx+3) DIV mlxH;
      my:=(y-wy-64) DIV ft1^.fontheight;
      ax:=mx*mlxH+wx-3;
      ay:=my*ft1^.fontheight+wy+64;
      MouseOff;
      barXOR(ax,ay,ax+mlxH,ay+ft1^.fontheight,$FFFFFF);
      MouseOn;
      WaitButtonReleased;
      MouseOff;
      barXOR(ax,ay,ax+mlxH,ay+ft1^.fontheight,$FFFFFF);
      MouseOn;
      mousecoords(x,y);
      ax:=(x-wx+3) DIV mlxH;
      ay:=(y-wy-64) DIV ft1^.fontheight;
      IF (ax=mx) AND (ay=my) THEN SwitchMode(ax*13+ay+1);
    END;
END;

PROCEDURE SelectMode;
BEGIN
{DBG(gxcurresname);
DBG(gxcurres);}
  CASE gxcurres OF
  $03200200..$05120480:SelectMode320x200;
  $06400350..$16001200:SelectMode640x480;
  END;
END;

PROCEDURE SelectDemo;
BEGIN
  CASE gxcurres OF
  $03200200..$05120480:
    BEGIN
      IF mousearea(wx+  5,wy+2,wx+ 64,wy+46) THEN Graphix3ddemo;
      IF mousearea(wx+ 67,wy+2,wx+126,wy+46) THEN GraphixclassicDemo;
      IF mousearea(wx+129,wy+2,wx+188,wy+46) THEN GraphixTextDemo;
      IF mousearea(wx+191,wy+2,wx+250,wy+46) THEN GraphixEffectsDemo;
      IF mousearea(wx+253,wy+2,wx+312,wy+46) THEN ende:=TRUE;
    END;
  $06400350..$16001200:
    BEGIN
      IF mousearea(wx+531,wy-75,wx+605,wy-30) THEN Graphix3ddemo;
      IF mousearea(wx+531,wy-25,wx+605,wy+20) THEN GraphixclassicDemo;
      IF mousearea(wx+531,wy+25,wx+605,wy+70) THEN GraphixTextDemo;
      IF mousearea(wx+531,wy+75,wx+605,wy+120) THEN GraphixEffectsDemo;
      IF mousearea(wx+531,wy+125,wx+605,wy+170) THEN GraphixMediaDemo;
      IF mousearea(wx+531,wy+175,wx+605,wy+220) THEN GraphixImageDemo;
      IF mousearea(wx+531,wy+225,wx+605,wy+270) THEN ende:=TRUE;
    END;
  END;
END;

PROCEDURE MainScreen;
VAR x,y:longint;
BEGIN
  MouseOff;
  BaseScreen;
  InfoScreen;
  MouseOn;
  ende:=FALSE;
  REPEAT
    mousecoords(x,y);
    IF (mousebutton>0) THEN
      BEGIN
        SelectMode;
        SelectDemo;
      END;
    IF keypressed THEN
      CASE readkey OF
      '1':GraphiX3DDemo;
      '2':GraphiXClassicDemo;
      '3':GraphiXTextDemo;
      '4':GraphiXEffectsDemo;
      #27:ende:=TRUE;
      END;
  UNTIL ende;
END;

BEGIN
  InitGraphiX(ig_vesa,ig_lfb);
  SetModeGraphiX(640,480,ig_col8);
  InitMouse;
  InitGXDemo;
  GXSetmousepointer;
  MainScreen;
  GXResetmousepointer;
  DoneGXDemo;
END.
