{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

{$I gxglobal.cfg}
UNIT gxpci;

INTERFACE

{$I gxlocal.cfg}

TYPE TPCIdevice=RECORD
       vendor,device:word;
       SysBusCmd,SysBusStat:word;
       Revision:byte;
       ProgrInterface:byte;
       deviceclass:word;
       CacheLineSize:byte;
       LatencyTimer:byte;
       HeaderType:byte;
       bist:byte;
       base0,base1,base2,base3,base4,base5:dword;
       reserved1,reserved2:dword;
       ROMbase:dword;
       reserved3,reserved4:dword;
       IntrLine,IntrPin:byte;
       MinimumGrant:byte;
       MaxLat:byte;
       reserved:array[64..255] of byte;
     END;

FUNCTION TestPCI:boolean;
FUNCTION GetPCIDevice(bus,nr:dword;var PCIdevice:TPCIdevice):longint;
FUNCTION GetPCIDeviceFunc(bus,nr,func:dword;var PCIdevice:TPCIdevice):longint;
FUNCTION ReadPCI8(offs:dword):byte;
FUNCTION ReadPCI16(offs:dword):word;
FUNCTION ReadPCI32(offs:dword):dword;
PROCEDURE WritePCI8(offs:dword;i:byte);
PROCEDURE WritePCI16(offs:dword;i:word);
PROCEDURE WritePCI32(offs,i:dword);
FUNCTION TestPCI32(offs,mask:dword):dword;
FUNCTION getpcibasesize(pciaddr,base:dword):dword;
FUNCTION GetPCIname(vendor,device,rev:word):string;

IMPLEMENTATION

USES gxcrtext;

FUNCTION TestPCI:boolean;
VAR PCItype:word;
BEGIN
  ASM
    XOR BX,BX      {PCItype=0}

    XOR AX,AX
    MOV DX,0CF8h
    OUT DX,AX
    MOV DX,0CFAh
    OUT DX,AX

    MOV DX,0CF8h
    IN AX,DX
    OR AX,AX
    JNZ @w1
    MOV DX,0CFAh
    IN AX,DX
    OR AX,AX
    JNZ @w1
    MOV BX,0002h   {PCItype=2}
    JMP @e1

  @w1:
    MOV DX,0CF8h
    IN EAX,DX
    MOV ECX,EAX
    MOV EAX,80000000h
    OUT DX,EAX
    IN EAX,DX
    CMP EAX,80000000h
    JNE @w2
    MOV BX,0001h   {PCItype=1}
  @w2:
    MOV EAX,ECX
    OUT DX,EAX
  @e1:
    MOV PCItype,BX
  END;
  TestPCI:=boolean(PCItype);
END;

FUNCTION GetPCIDevice(bus,nr:dword;var PCIdevice:TPCIdevice):longint;
VAR PCItype,i,j:dword;
BEGIN
  GetPCIdevice:=-1;
  ASM
    XOR EBX,EBX      {PCItype=0}

    XOR AX,AX
    MOV DX,0CF8h
    OUT DX,AX
    MOV DX,0CFAh
    OUT DX,AX

    MOV DX,0CF8h
    IN AX,DX
    OR AX,AX
    JNZ @w1
    MOV DX,0CFAh
    IN AX,DX
    OR AX,AX
    JNZ @w1
    MOV EBX,0002h   {PCItype=2}
    JMP @e1

  @w1:
    MOV DX,0CF8h
    IN EAX,DX
    MOV ECX,EAX
    MOV EAX,80000000h
    OUT DX,EAX
    IN EAX,DX
    CMP EAX,80000000h
    JNE @w2
    MOV EBX,0001h   {PCItype=1}
  @w2:
    MOV EAX,ECX
    OUT DX,EAX
  @e1:
    MOV PCItype,EBX
  END;
  CASE PCItype OF
    1:BEGIN
        i:=nr+bus*32;
        ASM
          MOV EBX,00100000h
          OR EBX,i
          SHL EBX,11
          MOV ECX,64
          MOV EDI,PCIdevice
        @loop1:
          MOV EAX,EBX
          MOV DX,0CF8h
          OUT DX,EAX
          MOV DX,0CFCh
          IN EAX,DX
          STOSD
          ADD EBX,00000004h
          LOOP @loop1
        END;
        IF (PCIdevice.vendor<>$FFFF) THEN GetPCIdevice:=i SHL 11;
      END;
    2:BEGIN
        i:=nr;
        ASM
          MOV AL,80h
          MOV DX,0CF8h
          OUT DX,AL
          MOV AL,00h
          MOV DX,0CFAh
          OUT DX,AL

          MOV ECX,128
          MOV EDX,i
          SHL DX,8
          OR DX,0C000h
          LEA EDI,PCIdevice
        @loop1:
          IN AX,DX
          STOSW
          ADD DX,2
          LOOP @loop1
        END;
        IF (PCIdevice.vendor<>$FFFF) THEN GetPCIdevice:=i SHL 8;
        ASM
          MOV AL,00h
          MOV DX,0CF8h
          OUT DX,AL
        END;
      END;
  END;
END;

FUNCTION GetPCIDeviceFunc(bus,nr,func:dword;var PCIdevice:TPCIdevice):longint;
VAR PCItype,i,j:dword;
BEGIN
  GetPCIdevicefunc:=-1;
  ASM
    XOR BX,BX      {PCItype=0}

    XOR AX,AX
    MOV DX,0CF8h
    OUT DX,AX
    MOV DX,0CFAh
    OUT DX,AX

    MOV DX,0CF8h
    IN AX,DX
    OR AX,AX
    JNZ @w1
    MOV DX,0CFAh
    IN AX,DX
    OR AX,AX
    JNZ @w1
    MOV BX,0002h   {PCItype=2}
    JMP @e1

  @w1:
    MOV DX,0CF8h
    IN EAX,DX
    MOV ECX,EAX
    MOV EAX,80000000h
    OUT DX,EAX
    IN EAX,DX
    CMP EAX,80000000h
    JNE @w2
    MOV EBX,0001h   {PCItype=1}
  @w2:
    MOV EAX,ECX
    OUT DX,EAX
  @e1:
    MOV PCItype,EBX
  END;
  CASE PCItype OF
    1:BEGIN
        i:=nr+bus*32;
        ASM
          MOV EBX,00100000h
          OR EBX,i
          SHL EBX,11
          OR BH,BYTE PTR func
          MOV ECX,64
          MOV EDI,PCIdevice
        @loop1:
          MOV EAX,EBX
          MOV DX,0CF8h
          OUT DX,EAX
          MOV DX,0CFCh
          IN EAX,DX
          STOSD
          ADD EBX,0004h
          LOOP @loop1
        END;
        IF (PCIdevice.vendor<>$FFFF) THEN
          IF (PCIdevice.headertype AND $80>0) OR (func=0) THEN
            GetPCIdevicefunc:=i SHL 11+func SHL 8;
      END;
  END;
END;

FUNCTION ReadPCI8(offs:dword):byte;assembler;
ASM
  MOV DX,0CF8h
  MOV EAX,80000000h
  OR EAX,offs
  OUT DX,EAX
  MOV DX,0CFCh
  IN AL,DX
END;

FUNCTION ReadPCI16(offs:dword):word;assembler;
ASM
  MOV DX,0CF8h
  MOV EAX,80000000h
  OR EAX,offs
  OUT DX,EAX
  MOV DX,0CFCh
  IN AX,DX
END;

FUNCTION ReadPCI32(offs:dword):dword;assembler;
ASM
  MOV DX,0CF8h
  MOV EAX,80000000h
  OR EAX,offs
  OUT DX,EAX
  MOV DX,0CFCh
  IN EAX,DX
END;

PROCEDURE WritePCI8(offs:dword;i:byte);assembler;
ASM
  MOV DX,0CF8h
  MOV EAX,80000000h
  OR EAX,offs
  OUT DX,EAX
  MOV DX,0CFCh
  MOV AL,i
  OUT DX,AL
END;

PROCEDURE WritePCI16(offs:dword;i:word);assembler;
ASM
  MOV DX,0CF8h
  MOV EAX,80000000h
  OR EAX,offs
  OUT DX,EAX
  MOV DX,0CFCh
  MOV AX,i
  OUT DX,AX
END;

PROCEDURE WritePCI32(offs,i:dword);assembler;
ASM
  MOV DX,0CF8h
  MOV EAX,80000000h
  OR EAX,offs
  OUT DX,EAX
  MOV DX,0CFCh
  MOV EAX,i
  OUT DX,EAX
END;

FUNCTION TestPCI32(offs,mask:dword):dword;
VAR save:dword;
BEGIN
  save:=ReadPCI32(offs);
  WritePCI32(offs,mask);
  TestPCI32:=ReadPCI32(offs);
  WritePCI32(offs,save);
END;

FUNCTION getpcibasesize(pciaddr,base:dword):dword;
BEGIN
  getpcibasesize:=((NOT TestPCI32(pciaddr+$10+base*4,$FFFFFFFF)) AND $FFFFFFF0)+$10;
END;

FUNCTION GetPCIname(vendor,device,rev:word):string;
VAR s:string;
BEGIN
  s:='';
  CASE vendor OF
  $1002:CASE device OF { ATI Technology }
        $4158:s:='ATI 68800AX Mach 32';
        $4354:s:='ATI 215CT222 Mach 64 CT';
        $4358:s:='ATI 210888CX Mach64 CX';
        $4554:s:='ATI Mach64 ET';
        $4654:s:='ATI Mach64 VT';
        $4742:s:='ATI Rage 3D Pro AGP 2x';
        $4744:s:='ATI Rage 3D Pro AGP 1x';
        $4747:s:='ATI Rage 3D Pro';
        $4749:s:='ATI 3D RAGE PRO 2X AGP ATI ALL IN WONDER PRO (8MB)';
        $474C:s:='ATI Rage XC PCI-66';
        $474D:s:='ATI Rage XL AGP 2x';
        $474E:s:='ATI Rage XC AGP 2x';
        $474F:s:='ATI Rage XL PCI-66';
        $4750:s:='ATI Rage 3D Pro PCI Graphics Accelerator';
        $4751:s:='ATI Rage 3D Pro PCI';
        $4753:s:='ATI Rage XC PCI';
        $4754:s:='ATI Mach 64 GT Rage 3D II Graphics Accelerator';
        $4755:s:='ATI Rage 3D II+';
        $4756:s:='ATI Rage 3D IIC PCI Graphics Accelerator';
        $4757:s:='ATI Rage 3D IIC AGP';
        $4758:s:='ATI 210888GX Mach 64 GX (WinTurbo)';
        $4759:s:='ATI Rage 3D IIC';
        $475A:s:='ATI Rage 3D IIC AGP';
        $4C42:s:='ATI Rage 3D LT Pro AGP 133 MHz';
        $4C44:s:='ATI Rage 3D LT Pro AGP 66 MHz';
        $4C46:s:='ATI Mobility M3 AGP 2x';
        $4C47:s:='ATI Rage 3D LT-G';
        $4C49:s:='ATI Rage 3D LT Pro PCI';
        $4C4D:s:='ATI Rage P/M Mobility AGP 2x';
        $4C4E:s:='ATI Rage L Mobility AGP 2x';
        $4C50:s:='ATI Rage 3D LT Pro PCI';
        $4C51:s:='ATI Rage 3D LT Pro PCI';
        $4C52:s:='ATI Rage P/M Mobility PCI';
        $4C53:s:='ATI Rage L Mobility PCI';
        $4C54:s:='ATI Mach 64 LT';
        $5041:s:='ATI Rage 128 Pro PCI';
        $5042:s:='ATI Rage 128 Pro AGP 2x';
        $5043:s:='ATI Rage 128 Pro AGP 4x';
        $5044:s:='ATI Rage 128 Pro PCI (TMDS)';
        $5045:s:='ATI Rage 128 Pro AGP 2x (TMDS)';
        $5046:s:='ATI Rage Fury MAXX AGP4x';
        $5047:s:='ATI Rage 128 Pro PCI';
        $5048:s:='ATI Rage 128 Pro AGP 2x';
        $5049:s:='ATI Rage 128 Pro AGP 4x';
        $504A:s:='ATI Rage 128 Pro PCI';
        $5245:s:='ATI Rage 128 GL PCI';
        $5246:s:='ATI Rage 128 GL AGP 2x';
        $524B:s:='ATI Rage 128 VR PCI';
        $524C:s:='ATI Rage 128 VR AGP 2x';
        $5345:s:='ATI Rage 128 4x PCI';
        $5346:s:='ATI Rage 128 4x AGP 2x';
        $5347:s:='ATI Rage 128 4x AGP 4x';
        $5348:s:='ATI Rage 128 4x';
        $5354:s:='ATI Mach 64 ST';
        $5654:s:='ATI 215VT222 Mach 64 VT VIDEO XPRESSION';
        $5655:s:='ATI Mach 64 VT3';
        $5656:s:='ATI Mach 64 VT4 PCI';
        END;
  $1005:CASE device OF { Avance Logics Inc }
        $2064:s:='Avance Logic ALG2032/2064';
        $2128:s:='Avance Logic ALG2364A';
        $2301:s:='Avance Logic ALG2301';
        $2302:s:='Avance Logic ALG2302';
        $2364:s:='Avance Logic ALG2364';
      {  $2364:s:='Avance Logic ALG2364A'; }
        $2501:s:='Avance Logic ALG2564A/25128A';
        END;
  $100C:CASE device OF { Tseng Labs Inc }
        $3202:s:='Tseng ET4000/W32p revA';
        $3205:s:='Tseng ET4000/W32p revB';
        $3206:s:='Tseng ET4000/W32p revD';
        $3207:s:='Tseng ET4000/W32p revC';
        $3208:s:='Tseng ET6000/6100';
        $4702:s:='Tseng ET6300';
        END;
  $1013:CASE device OF { Cirrus Logic }
        $0038:s:='Cirrus Logic CL-GD7548';
        $0040:s:='Cirrus Logic CL-GD7555';
        $004C:s:='Cirrus Logic CL-GD7556';
        $0088:s:='Cirrus Logic CL-GD5402';
        $0089:s:='Cirrus Logic CL-GD5402 r1';
        $008A:s:='Cirrus Logic CL-GD5420';
        $008B:s:='Cirrus Logic CL-GD5420 r1';
        $008C..$008F:s:='Cirrus Logic CL-GD5422';
        $0090..$0093:s:='Cirrus Logic CL-GD5426';
        $0094..$0097:s:='Cirrus Logic CL-GD5424';
        $0098..$009B:s:='Cirrus Logic CL-GD5428';
        $00A0:s:='Cirrus Logic CL-GD5430/40';
        $00A4:s:='Cirrus Logic CL-GD5434 rev 4';
        $00A8:s:='Cirrus Logic CL-GD5434 rev 8';
        $00AC:s:='Cirrus Logic CL-GD5436';
        $00B8:s:='Cirrus Logic CL-GD5446';
        $00BC:s:='Cirrus Logic CL-GD5480';
        $00D0:s:='Cirrus Logic CL-GD5462';
        $00D4:s:='Cirrus Logic CL-GD5464';
        $00D5:s:='Cirrus Logic CL-GD5464 rev BD';
        $00D6:s:='Cirrus Logic CL-GD5465';
        $00E8:s:='Cirrus Logic CL-GD5436';
        $1200:s:='Cirrus Logic CL-GD7542 (Nordic)';
        $1202:s:='Cirrus Logic CL-GD7543 (Viking)';
        $1204:s:='Cirrus Logic CL-GD7541 (Nordic Light)';
        END;
  $1023:CASE device OF { Trident Microsystems }
        $8400:s:='Trident CyberBlade i7';
        $8420:s:='Trident CyberBlade i7';
        $8500:s:='Trident CyberBlade i1';
        $8520:s:='Trident CyberBlade i1';
        $9320:s:='Trident TGUI9320';
        $9350:s:='Trident TGUI9350';
        $9360:s:='Trident TGUI9360';
        $9382:s:='Trident Cyber9382';
        $9383:s:='Trident Cyber9383';
        $9385:s:='Trident Cyber9385';
        $9386:s:='Trident Cyber9386';
        $9388:s:='Trident Cyber9388';
        $9397:s:='Trident Cyber9397';
        $939A:s:='Trident Cyber9397DVD';
        $9420:s:='Trident TGUI9420DGi';
        $9430:s:='Trident TGUI9430';
        $9440:s:='Trident TGUI9440DGi';
        $9460:s:='Trident TGUI9460';
        $9470:s:='Trident TGUI9470';
        $9520:s:='Trident Cyber9520';
        $9525:s:='Trident Cyber9525';
        $9660:s:='Trident TGUI9660XGi';
        $9680:s:='Trident TGUI9680';
        $9682:s:='Trident TGUI9682';
        $9683:s:='Trident TGUI9683';
        $9685:s:='Trident ProVidia9685';
        $9750:s:='Trident 3DImage 9750';
        $9753:s:='Trident TGUI9753';
        $9754:s:='Trident TGUI9753';
        $9759:s:='Trident TGUI975?';
        $9783:s:='Trident TGUI9783';
        $9785:s:='Trident TGUI9785';
        $9850:s:='Trident 3DImage9850';
        $9880:s:='Trident Blade3D';
        END;
  $1025:CASE device OF { Acer Labs Inc }
        $3141:s:='Acer M3145 VGA';
        $3145:s:='Acer M3141 VGA';
        $3147:s:='Acer M3147v VGA';
        $3151:s:='Acer M3151 3D VGA';
        END;
  $102B:CASE device OF { Matrox }
        $0518:s:='Matrox Atlas 2085PX (MGA-2)';
        $0519:s:='Matrox MGA-2064W Millenium';
        $051A:s:='Matrox MGA-1064SG Mystique';
        $051B:s:='Matrox MGA-2164W Millenium II';
        $051E:s:='Matrox MGA-1164SG Mystique AGP';
        $051F:s:='Matrox MGA-2164W Millenium II AGP';
        $0520:s:='Matrox G200 PCI';
        $0521:s:='Matrox G200 AGP';
        $0D10:s:='Matrox Impression Plus';
        $1000:s:='Matrox G100 PCI';
        $1001:s:='Matrox G100 AGP';
        $2007:s:='Matrox Mistral GUI+3D Accelerator';
        END;
  $102C:CASE device OF { Chips and Technologies }
        $00B8:s:='Chips&Tech CT64310';
        $00C0:s:='Chips&Tech CT69000';
        $00D8:s:='Chips&Tech CT65545';
        $00DC:s:='Chips&Tech CT65548';
        $00E0:s:='Chips&Tech CT65550';
        $00E4:s:='Chips&Tech CT65554';
        $00E5:s:='Chips&Tech CT65555';
        $00F4:s:='Chips&Tech CT68554';
        END;
  $1039:CASE device OF { Silicon integrated System (SiS) }
        $0001:s:='SiS 86c201 VGA';
        $0002:s:='SiS 86c202 VGA';
        $0200:s:='SiS 5597/8 Integrated VGA';
        $0205:s:='SiS 6205, 6215 and 5596 (VGA)';
        $6225:s:='SiS 6225 VGA';
        $6306:s:='SiS 530 3D/VGA part';
        $6326:s:='SiS 6326 VGA';
        END;
  $104E:CASE device OF { OAK Technology, Inc }
        $0017:s:='OTI-64017';
        $0107:s:='OTI-64107';
        $0111:s:='OTI-64111';
        $0217:s:='OTI-64217';
        $0317:s:='OTI-64317 (Warp5)';
        END;
  $105D:CASE device OF { Number Nine (#9) Computer Company }
        $2309:s:='#9 Imagine 128';
        $2339:s:='#9 Imagine 128-II (VGA enabled)';
        $493D:s:='#9 Imagine 128 3D (Revolution 3D)';
        $5348:s:='#9 Revolution IV';
        END;
  $10C8:CASE device OF { NeoMagic Corporation }
        $0001:s:='NeoMagic NM2070 MagicGraph 128';
        $0002:s:='NeoMagic NM2090 MagicGraph 128V';
        $0003:s:='NeoMagic NM2093 MagicGraph 128ZV';
        $0004:s:='NeoMagic NM2160 MagicGraph 128XD';
        $0005:s:='NeoMagic NM2200 MagicMedia256';
        END;
  $121A:CASE device OF { 3Dfx }
        $0001:s:='3Dfx Voodoo';
        $0002:s:='3Dfx Voodoo 2';
        $0003:s:='3Dfx Voodoo Banshee';
        $0005:s:='3Dfx Voodoo 3 Avenger';
        END;
  $12D2:CASE device OF { NVidia / SGS Thomson }
        $0018:s:='nVidia Riva128 or Riva128zx';
        $0019:s:='nVidia Riva128zx w/ACPI enabled';
        END;
  $3D3D:CASE device OF { 3D Labs }
        $0001:s:='3D Labs Glint 300SX';
        $0002:s:='3D Labs Glint 500TX';
        $0003:s:='3D Labs Glint Delta';
        $0004:s:='3D Labs Glint Permedia';
        $0006:s:='3D Labs Glint MX';
        $0007:s:='3D Labs Glint Permedia 2';
        $0009:s:='3D Labs Glint Permedia 2v';
        END;
  $4005:CASE device OF { Avance Logic, Inc (Also see vendor 1005h) }
        $1064:s:='Avance Logic ALG1064 GUI Accelerator';
        $2064:s:='Avance Logic ALG2064i GUI Accelerator';
        $2128:s:='Avance Logic ALG-2364A';
        $2301:s:='Avance Logic ALG2301 GUI Accelerator';
        $2302:s:='Avance Logic ALG2302 GUI Accelerator';
        $2303:s:='Avance Logic ALG2302 GUI Accelerator';
        $2364:s:='Avance Logic ALG2364';
        $2464:s:='Avance Logic ALG2464';
        $2501:s:='Avance Logic ALG2564A/25128A';
        END;
  $5333:CASE device OF { S3, Inc }
        $0551:s:='S3 PLATO/PX';
        $5631:s:='S3 86c325 (ViRGE)';
        $8800:s:='S3 Vision 866';
        $8811:
          CASE rev OF
            $00..$3F:s:='S3 86c764 (Trio64)';
            $40..$5F:s:='S3 86c765 (Trio64V+)';
            $60..$FF:s:='S3 Trio64';
          END;
        $8812:s:='S3 86cm65 (Aurora64V+)';
        $8814:s:='S3 86c767 (Trio64UV+)';
        $8815:s:='S3 (Aurora128)';
        $883D:s:='S3 86c988 (VIRGE/VX)';
        $8880:s:='S3 86c866';
        $88B0:s:='S3 86c928P';
        $88C0:s:='S3 86c864';
        $88C1:s:='S3 86c864P';
        $88D0:s:='S3 86c964';
        $88D1:s:='S3 86c964P';
        $88F0:s:='S3 86c968';
        $8901:s:='S3 86c775 (Trio64V2)';
        $8902:s:='S3 Plato PX';
        $8A01:s:='S3 Virge DX/GX';
        $8A10:s:='S3 ViRGE/GX2';
        $8A20:s:='S3 Savage3D (86c391)';
        $8A21:s:='S3 Savage3D (86c795)';
        $8C01:s:='S3 ViRGE/MX';
        $8C03:s:='S3 ViRGE/MX+';
        END;
  $8086:CASE device OF { Intel Corporation }
        $7800:s:='Intel i740 GUI/3D Accelerator';
        END;
  $EDD8:CASE device OF { ARK Logic Inc }
        $A091:s:='ARK 1000PV';
        $A099:s:='ARK 2000PV';
        $A0A1:s:='ARK 2000MT';
        $A0A9:s:='ARK 2000MI';
        END;
  END;
  IF (s='') THEN s:='v'+hexword(vendor)+'d'+hexword(device)+'r'+hexbyte(rev);
  GetPCIname:=s;
END;


END.
