{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

{
                       -------------------------
                       GX3D - G r a p h i X  3 D
                       -------------------------
                                 v1.20
                       -------------------------

VERSION HISTORY

Version 1.20 (planned)


Version 1.10 (planned)
  = overall speed optimation
  * the unit has now:
    - Flat Shaded Triangle (Software, Matrox, S3 Trio, S3 ViRGE)
    - Gouraud Shaded Triangle (Software, Matrox, S3 ViRGE)
    - Texture Mapping (Software)
    - Texture Mapping Alpha (Software)
    - Texture Mapping Flat Alpha (Software)
    - Texture Mapping Gouraud Alpha (Software)

Version 1.01 (12.02.1998)
    = overall speed optimation
    - Flat Shaded Triangle (Software, Matrox)
    - Gouraud Shaded Triangle (Software, Matrox)
    - Texture Mapping (Software, Matrox)

Version 1.00.3beta (06.11.1998)
  + Funktionen:
    - Support fr 8bit (flat, gouraud, textured)

Version 1.00.2beta (04.10.1998)
  + Funktionen:
    - Texture Mapping (Software)

Version 1.00.1beta (27.09.1998)
  * Grundstruktur der Unit
  + Funktionen:
    - Flat Shaded Triangle (Software, Matrox)
    - Gouraud Shaded Triangle (Software, Matrox)

                       --------------------------
}

{$I gxglobal.cfg}
UNIT gx3d;

INTERFACE

USES gx3dtype;
{$I gxlocal.cfg}

CONST rt_no_shad=$0000;
      rt_flat_shad=$0001;
      rt_line_shad=$0002;
      rt_shading=$000F;

      rt_no_texture=$0000;
      rt_flat_texture=$0010;
      rt_texture=$00F0;

      rt_no_filter=$0100;
      rt_bilinear=$0200;
      rt_trilinear=$0300;
      rt_filter=$0F00;

VAR triangle_flat:triangle_renderproc;
    triangle_gouraud:triangle_renderproc;
    triangle_textured:triangle_renderproc;
    triangle_textured_perspective:triangle_renderproc;
    triangle_textured_gouraud_alpha:triangle_renderproc;

    polygon_flat:polygon_renderproc;

    v3dx1,v3dy1,v3dx2,v3dy2:longint;

PROCEDURE polygon3d(Render:RenderPtr);

{PROCEDURE InitGX3D;}
PROCEDURE InitGX3DZBuffer;
PROCEDURE DoneGX3DZBuffer;
PROCEDURE maxgraphwin3D;
PROCEDURE graphwin3D(x1,y1,x2,y2:longint);

IMPLEMENTATION

USES gxbase,gxsup,gxtype,graphix{$IFDEF GO32V2},gxhw_mga{$ENDIF}{,dbgherc};

{========================================================================}

TYPE PXdata=^TXdata;
     TXdata=RECORD
       x,z:longint;
       r,g,b:longint;
    {   nx,ny,nz:longint; }
       next:PXdata;
     END;

PROCEDURE InsertX(var Xdata:PXdata;Xentry:PXdata);
VAR p,h:PXdata;
BEGIN
  p:=nil;
  h:=Xdata;
  WHILE (h<>nil) DO
    BEGIN
      IF (h^.x>Xentry^.x) THEN break;
      p:=h;
      h:=h^.next;
    END;
  IF (p=nil) THEN
    BEGIN
      Xentry^.next:=Xdata;
      Xdata:=Xentry;
    END
  ELSE
    BEGIN
      Xentry^.next:=p^.next;
      p^.next:=Xentry;
    END;
END;

PROCEDURE ScanlineFlat(x1,x2:PXdata;y:longint;color:PRGB);
BEGIN
  lineh(x1^.x,x2^.x,y,rgbcolorRGB(color^.r,color^.g,color^.b));
END;

PROCEDURE ScanlineGouraud(x1,x2:PXdata;y:longint);
VAR x,r,g,b,ri,gi,bi,xd,i:longint;
BEGIN
  x:=x1^.x;
  r:=x1^.r;
  g:=x1^.g;
  b:=x1^.b;
  xd:=x2^.x-x;
  IF (xd>0) THEN
    BEGIN
      ri:=(x2^.r-r) DIV xd;
      gi:=(x2^.g-g) DIV xd;
      bi:=(x2^.b-b) DIV xd;
    END;
  FOR i:=0 TO xd DO
    BEGIN
      putpixel(x+i,y,rgbcolorRGB(r SHR 16,g SHR 16,b SHR 16));
      inc(r,ri);
      inc(g,gi);
      inc(b,bi);
    END;
END;

(*
PROCEDURE ScanlinePhong(x1,x2:PXdata;y:longint;color:PRGB);
CONST f1=1/65536;
VAR x,nx,ny,nz,nxi,nyi,nzi,xd,i,len,light:longint;
    fnx,fny,fnz:double;
BEGIN
  x:=x1^.x;
  nx:=x1^.nx;
  ny:=x1^.ny;
  nz:=x1^.nz;
  xd:=x2^.x-x;
  IF (xd>0) THEN
    BEGIN
      nxi:=(x2^.nx-nx) DIV xd;
      nyi:=(x2^.ny-ny) DIV xd;
      nzi:=(x2^.nz-nz) DIV xd;
    END;
  FOR i:=0 TO xd DO
    BEGIN
      len:=trunc(sqrt(sqr(nx*f1)+sqr(ny*f1)*sqr(nz*f1))*65536);
{      len:=trunc(sqrt(nx*nx+ny*ny+nz*nz)); }
      len:=65536;
      light:=nz;
      IF (light<0) THEN light:=0;
{DBG(nz);}
      putpixel(x+i,y,rgbcolorRGB((light*color^.r) DIV len,
                              (light*color^.g) DIV len,
                              (light*color^.b) DIV len));
      inc(nx,nxi);
      inc(ny,nyi);
      inc(nz,nzi);
    END;
END;
*)

PROCEDURE polygon3d(Render:RenderPtr);
VAR i,j,ymin,ymax,yrange:longint;
    h,x,y,xi,x1,y1,x2,y2,yc,yp:longint;
    r,g,b,r1,g1,b1,r2,g2,b2,ri,gi,bi:longint;
{    nx,ny,nz,nx1,ny1,nz1,nx2,ny2,nz2,nxi,nyi,nzi:longint; }
    Xdatalist:^PXdata;
    Xdata:PXdata;
    Xentry,Xtmp:PXdata;
    Xcnt,Xidx:longint;
    rendertype:dword;
BEGIN
  WITH Render^ DO
    BEGIN
      rendertype:=flags AND polygon3d_type;
      ymin:=points[0].y;
      ymax:=points[0].y;
      Xcnt:=abs(points[0].y-points[Num-1].y)+1;
      FOR i:=1 TO Num-1 DO
        BEGIN
          IF (points[i].y<ymin) THEN ymin:=points[i].y;
          IF (points[i].y>ymax) THEN ymax:=points[i].y;
          inc(Xcnt,abs(points[i-1].y-points[i].y)+1);
        END;

      IF (ymin>getmaxX) OR (ymax<0) THEN exit;
      IF (ymin<0) THEN ymin:=0;
      IF (ymax>getmaxY) THEN ymax:=getmaxX;
      yrange:=ymax-ymin+1;

      getmem(Xdatalist,yrange*sizeof(PXdata));
      getmem(Xdata,Xcnt*sizeof(TXdata));
      FOR y:=0 TO yrange-1 DO Xdatalist[y]:=nil;
      Xidx:=0;

      yp:=points[Num-2].y;
      j:=Num-1;
      FOR i:=0 TO Num-1 DO
        BEGIN
          x1:=points[j].x;
          y1:=points[j].y;
          x2:=points[i].x;
          y2:=points[i].y;

          r1:=colors[j].r;
          g1:=colors[j].g;
          b1:=colors[j].b;
          r2:=colors[i].r;
          g2:=colors[i].g;
          b2:=colors[i].b;

     {     nx1:=normals[j].x;
          ny1:=normals[j].y;
          nz1:=normals[j].z;
          nx2:=normals[i].x;
          ny2:=normals[i].y;
          nz2:=normals[i].z; }

          IF (y1<>y2) THEN
            BEGIN
              IF (y1>y2) THEN
                BEGIN
                  h:=x1;x1:=x2;x2:=h;
                  h:=y1;y1:=y2;y2:=h;
                  h:=r1;r1:=r2;r2:=h;
                  h:=g1;g1:=g2;g2:=h;
                  h:=b1;b1:=b2;b2:=h;
              {    h:=nx1;nx1:=nx2;nx2:=h;
                  h:=ny1;ny1:=ny2;ny2:=h;
                  h:=nz1;nz1:=nz2;nz2:=h; }
                  yc:=yp;
                END
              ELSE
                BEGIN
                  h:=i;
                  WHILE (y2=points[h].y) DO
                    BEGIN
                      inc(h);
                      IF (h>=num) THEN h:=0;
                      IF (h=i) THEN break;
                    END;
                  yc:=points[h].y;
                END;
              IF (y2<>y1) THEN
                BEGIN
                  xi:=((x2-x1) SHL 16) DIV (y2-y1);
                  IF (rendertype=polygon3d_gouraud) THEN
                    BEGIN
                      ri:=((r2-r1) SHL 16) DIV (y2-y1);
                      gi:=((g2-g1) SHL 16) DIV (y2-y1);
                      bi:=((b2-b1) SHL 16) DIV (y2-y1);
                 {     nxi:=0;
                      nyi:=0;
                      nzi:=0; }
                    END;
               {   IF (rendertype=polygon3d_phong) THEN
                    BEGIN
                      ri:=0;
                      gi:=0;
                      bi:=0;
                      nxi:=((nx2-nx1)) DIV (y2-y1);
                      nyi:=((ny2-ny1)) DIV (y2-y1);
                      nzi:=((nz2-nz1)) DIV (y2-y1);
                    END; }
                END
              ELSE
                BEGIN
                  xi:=0;
                  ri:=0;
                  gi:=0;
                  bi:=0;
               {   nxi:=0;
                  nyi:=0;
                  nzi:=0; }
                END;
              x:=x1 SHL 16;
              r:=r1 SHL 16;
              g:=g1 SHL 16;
              b:=b1 SHL 16;
         {     nx:=nx1;
              ny:=ny1;
              nz:=nz1; }
              IF (yc>y2) THEN dec(y2);
              FOR y:=y1 TO y2 DO
                BEGIN
                  IF (y>=ymin) AND (y<=ymax) THEN
                    BEGIN
                      Xentry:=@Xdata[Xidx];
                      inc(Xidx);
                      Xentry^.x:=x DIV 65536;
                      Xentry^.r:=r;
                      Xentry^.g:=g;
                      Xentry^.b:=b;
                 {     Xentry^.nx:=nx;
                      Xentry^.ny:=ny;
                      Xentry^.nz:=nz; }
                      Xentry^.next:=nil;
                      InsertX(Xdatalist[y-ymin],Xentry);
                    END;
                  inc(x,xi);
                  inc(r,ri);
                  inc(g,gi);
                  inc(b,bi);
               {   inc(nx,nxi);
                  inc(ny,nyi);
                  inc(nz,nzi); }
                END;
              yp:=points[j].y;
            END;
          j:=i;
        END;

      FOR y:=ymin TO ymax DO
        BEGIN
          Xentry:=Xdatalist[y-ymin];
          WHILE (Xentry<>nil) DO
            BEGIN
              Xtmp:=Xentry;
              Xentry:=Xentry^.next;
              IF (Xentry=nil) THEN break;
              CASE rendertype OF
                polygon3d_flat:
                  ScanlineFlat(Xtmp,Xentry,y,@color);
                polygon3d_gouraud:
                  ScanlineGouraud(Xtmp,Xentry,y);
           {     polygon3d_phong:
                  ScanlinePhong(Xtmp,Xentry,y,@color); }
              END;
              Xentry:=Xentry^.next;
            END;
        END;

      freemem(Xdatalist,yrange*sizeof(PXdata));
      freemem(Xdata,Xcnt*sizeof(TXdata));
    END;
END;

{ triangle_flat =========================================================}

PROCEDURE triangle_flatL8(rend:prender);assembler;
CONST trlinesize=4;
VAR px1,py1,px2,py2,lx1,ly1,lx2,ly2,f:longint;
ASM
  MOV ESI,rend
  MOV EDI,graphbuf

  MOV px1,7FFFFFFFh
  MOV py1,7FFFFFFFh
  MOV px2,80000000h
  MOV py2,80000000h

  MOV ECX,3
@trL8_loop11:
  LODSD
  CMP EAX,px1
  JGE @trL8_w1
  MOV px1,EAX
@trL8_w1:
  CMP EAX,px2
  JLE @trL8_w2
  MOV px2,EAX
@trL8_w2:
  LODSD
  CMP EAX,py1
  JGE @trL8_w3
  MOV py1,EAX
@trL8_w3:
  CMP EAX,py2
  JLE @trL8_w4
  MOV py2,EAX
@trL8_w4:
  ADD ESI,4
  DEC ECX
  JNZ @trL8_loop11

{----------}

  MOV EAX,vx2
  CMP EAX,px1
  JLE @trL8_ende

  MOV EAX,vx1
  CMP EAX,px2
  JGE @trL8_ende

  MOV EAX,vy2
  CMP EAX,py1
  JLE @trL8_ende

  MOV EAX,vy1
  CMP EAX,py2
  JGE @trL8_ende

{----------}
  MOV ECX,py2
  SUB ECX,py1
  JZ @trL8_ende

  MOV EAX,00000000h
  MOV EDI,graphbuf
@trL8_loop22:
  MOV [EDI],EAX
  ADD EDI,trlinesize*4
  DEC ECX
  JNZ @trL8_loop22

{----------}
  MOV ESI,rend
  ADD ESI,24

  LODSD
  MOV lx2,EAX
  LODSD
  SUB EAX,py1
  MOV ly2,EAX

{----------}
  MOV ESI,rend
  MOV ECX,3
@trL8_loop33:
  PUSH ECX

  MOV EAX,lx2
  MOV lx1,EAX
  MOV EAX,ly2
  MOV ly1,EAX

  LODSD
  MOV lx2,EAX
  MOV EDX,EAX

  LODSD
  SUB EAX,py1
  MOV ly2,EAX
  MOV ECX,EAX

  ADD ESI,4

  MOV EAX,lx1
  MOV EBX,ly1

  CMP EBX,ECX
  JE @trL8_weiter44
  JL @trL8_weiter22
  XCHG EAX,EDX
  XCHG EBX,ECX
@trL8_weiter22:

  SUB EDX,EAX
  SUB ECX,EBX
  SHL EAX,16
  SHL EDX,16

  PUSH EAX
  MOV EAX,EDX
  CDQ
  IDIV ECX
  MOV EDX,EAX
  POP EAX

  MOV EDI,trlinesize*4
  IMUL EDI,EBX
  ADD EDI,graphbuf

@trL8_loop44:
  MOV EBX,[EDI]
  ADD EBX,4
  MOV [EDI],EBX
  PUSH EAX
  SAR EAX,16
  MOV [EDI+EBX],EAX
  POP EAX
  ADD EAX,EDX
  ADD EDI,trlinesize*4
  DEC ECX
  JNZ @trL8_loop44

@trL8_weiter44:
  POP ECX
  DEC ECX
  JNZ @trL8_loop33

{--- Zeichnen der X-Werte ---}

  LODSB
  MOV AH,AL
  SHL EAX,8
  MOV AL,AH
  SHL EAX,8
  MOV AL,AH
  MOV f,EAX

  XOR ESI,ESI

  MOV EAX,vy1
  MOV EBX,py1

  CMP EAX,EBX
  JLE @trL8_w5
  MOV ESI,EAX
  SUB ESI,EBX
  MOV EBX,EAX
  IMUL ESI,trlinesize*4
@trL8_w5:

  MOV EAX,vy2
  MOV ECX,py2

  CMP EAX,ECX
  JGE @trL8_w6
  INC EAX
  MOV ECX,EAX
@trL8_w6:

  SUB ECX,EBX
  ADD ESI,4
  ADD ESI,graphbuf

  IMUL EBX,bytperline
  ADD EBX,drawoffset
  ADD EBX,LFBoffs

@trL8_loop55:

  PUSH ECX

  MOV ECX,[ESI]
  MOV EDI,[ESI+4]

  CMP EDI,ECX
  JL @trL8_lineh_w1
  XCHG EDI,ECX
@trL8_lineh_w1:

  CMP EDI,vx2
  JG @trL8_lineh_ende
  CMP ECX,vx1
  JL @trL8_lineh_ende

  CMP EDI,vx1
  JGE @trL8_lineh_w2
  MOV EDI,vx1
@trL8_lineh_w2:
  CMP ECX,vx2
  JLE @trL8_lineh_w3
  MOV ECX,vx2
@trL8_lineh_w3:

  CLD
  SUB ECX,EDI
  INC ECX
  ADD EDI,EBX
  MOV EAX,f
  MOV EDX,ECX
  SHR ECX,2
  AND EDX,3
  REP STOSD
  MOV ECX,EDX
  REP STOSB
@trL8_lineh_ende:
  POP ECX

  ADD EBX,bytperline
  ADD ESI,trlinesize*4

  DEC ECX
  JNZ @trL8_loop55
@trL8_ende:
END;

PROCEDURE triangle_flatL16(rend:prender);assembler;
CONST trlinesize=4;
VAR px1,py1,px2,py2,lx1,ly1,lx2,ly2,f:longint;
ASM
  MOV ESI,rend
  MOV EDI,graphbuf

  MOV px1,7FFFFFFFh
  MOV py1,7FFFFFFFh
  MOV px2,80000000h
  MOV py2,80000000h

  MOV ECX,3
@trL16_loop11:
  LODSD
  CMP EAX,px1
  JGE @trL16_w1
  MOV px1,EAX
@trL16_w1:
  CMP EAX,px2
  JLE @trL16_w2
  MOV px2,EAX
@trL16_w2:
  LODSD
  CMP EAX,py1
  JGE @trL16_w3
  MOV py1,EAX
@trL16_w3:
  CMP EAX,py2
  JLE @trL16_w4
  MOV py2,EAX
@trL16_w4:
  ADD ESI,4
  DEC ECX
  JNZ @trL16_loop11

{----------}

  MOV EAX,vx2
  CMP EAX,px1
  JLE @trL16_ende

  MOV EAX,vx1
  CMP EAX,px2
  JGE @trL16_ende

  MOV EAX,vy2
  CMP EAX,py1
  JLE @trL16_ende

  MOV EAX,vy1
  CMP EAX,py2
  JGE @trL16_ende

{----------}
  MOV ECX,py2
  SUB ECX,py1
  JZ @trL16_ende

  MOV EAX,00000000h
  MOV EDI,graphbuf
@trL16_loop22:
  MOV [EDI],EAX
  ADD EDI,trlinesize*4
  DEC ECX
  JNZ @trL16_loop22

{----------}
  MOV ESI,rend
  ADD ESI,24

  LODSD
  MOV lx2,EAX
  LODSD
  SUB EAX,py1
  MOV ly2,EAX

{----------}
  MOV ESI,rend
  MOV ECX,3
@trL16_loop33:
  PUSH ECX

  MOV EAX,lx2
  MOV lx1,EAX
  MOV EAX,ly2
  MOV ly1,EAX

  LODSD
  MOV lx2,EAX
  MOV EDX,EAX

  LODSD
  SUB EAX,py1
  MOV ly2,EAX
  MOV ECX,EAX

  ADD ESI,4

  MOV EAX,lx1
  MOV EBX,ly1

  CMP EBX,ECX
  JE @trL16_weiter44
  JL @trL16_weiter22
  XCHG EAX,EDX
  XCHG EBX,ECX
@trL16_weiter22:

  SUB EDX,EAX
  SUB ECX,EBX
  SHL EAX,16
  SHL EDX,16

  PUSH EAX
  MOV EAX,EDX
  CDQ
  IDIV ECX
  MOV EDX,EAX
  POP EAX

  MOV EDI,trlinesize*4
  IMUL EDI,EBX
  ADD EDI,graphbuf

@trL16_loop44:
  MOV EBX,[EDI]
  ADD EBX,4
  MOV [EDI],EBX
  PUSH EAX
  SAR EAX,16
  MOV [EDI+EBX],EAX
  POP EAX
  ADD EAX,EDX
  ADD EDI,trlinesize*4
  DEC ECX
  JNZ @trL16_loop44

@trL16_weiter44:
  POP ECX
  DEC ECX
  JNZ @trL16_loop33

{--- Zeichnen der X-Werte ---}

  LODSW
  MOV BX,AX
  SHL EAX,16
  MOV AX,BX
  MOV f,EAX

  XOR ESI,ESI

  MOV EAX,vy1
  MOV EBX,py1

  CMP EAX,EBX
  JLE @trL16_w5
  MOV ESI,EAX
  SUB ESI,EBX
  MOV EBX,EAX
  IMUL ESI,trlinesize*4
@trL16_w5:

  MOV EAX,vy2
  MOV ECX,py2

  CMP EAX,ECX
  JGE @trL16_w6
  INC EAX
  MOV ECX,EAX
@trL16_w6:

  SUB ECX,EBX
  ADD ESI,4
  ADD ESI,graphbuf

  IMUL EBX,bytperline
  ADD EBX,drawoffset
  ADD EBX,LFBoffs

@trL16_loop55:

  PUSH ECX

  MOV ECX,[ESI]
  MOV EDI,[ESI+4]

  CMP EDI,ECX
  JL @trL16_lineh_w1
  XCHG EDI,ECX
@trL16_lineh_w1:

  CMP EDI,vx2
  JG @trL16_lineh_ende
  CMP ECX,vx1
  JL @trL16_lineh_ende

  CMP EDI,vx1
  JGE @trL16_lineh_w2
  MOV EDI,vx1
@trL16_lineh_w2:
  CMP ECX,vx2
  JLE @trL16_lineh_w3
  MOV ECX,vx2
@trL16_lineh_w3:

  CLD
  SUB ECX,EDI
  INC ECX
  SHL EDI,1
  ADD EDI,EBX
  MOV EAX,f

  TEST EDI,0003h
  JZ @trL16_lineh_weiter
  DEC ECX
  STOSW
@trL16_lineh_weiter:
  MOV DX,CX
  SHR CX,1
  AND DX,1
  REP STOSD
  MOV CX,DX
  REP STOSW
@trL16_lineh_ende:
  POP ECX

  ADD EBX,bytperline
  ADD ESI,trlinesize*4

  DEC ECX
  JNZ @trL16_loop55
@trL16_ende:
END;

PROCEDURE triangle_flatL24(rend:prender);assembler;
CONST trlinesize=4;
VAR px1,py1,px2,py2,lx1,ly1,lx2,ly2,f:longint;
ASM
  MOV ESI,rend
  MOV EDI,graphbuf

  MOV px1,7FFFFFFFh
  MOV py1,7FFFFFFFh
  MOV px2,80000000h
  MOV py2,80000000h

  MOV ECX,3
@trL24_loop11:
  LODSD
  CMP EAX,px1
  JGE @trL24_w1
  MOV px1,EAX
@trL24_w1:
  CMP EAX,px2
  JLE @trL24_w2
  MOV px2,EAX
@trL24_w2:
  LODSD                                                                                                                                                                                                                                                        
  CMP EAX,py1
  JGE @trL24_w3
  MOV py1,EAX                                                                                                                                                                                                                                                  
@trL24_w3:
  CMP EAX,py2                                                                                                                                                                                                                                                  
  JLE @trL24_w4
  MOV py2,EAX                                                                                                                                                                                                                                                  
@trL24_w4:
  ADD ESI,4
  DEC ECX
  JNZ @trL24_loop11

{----------}                                                                                                                                                                                                                                                   
                                                                                                                                                                                                                                                               
  MOV EAX,vx2                                                                                                                                                                                                                                                  
  CMP EAX,px1
  JLE @trL24_ende
                                                                                                                                                                                                                                                               
  MOV EAX,vx1                                                                                                                                                                                                                                                  
  CMP EAX,px2
  JGE @trL24_ende
                                                                                                                                                                                                                                                               
  MOV EAX,vy2
  CMP EAX,py1                                                                                                                                                                                                                                                  
  JLE @trL24_ende

  MOV EAX,vy1                                                                                                                                                                                                                                                  
  CMP EAX,py2                                                                                                                                                                                                                                                  
  JGE @trL24_ende
                                                                                                                                                                                                                                                               
{----------}                                                                                                                                                                                                                                                   
  MOV ECX,py2                                                                                                                                                                                                                                                  
  SUB ECX,py1
  JZ @trL24_ende
                                                                                                                                                                                                                                                               
  MOV EAX,00000000h                                                                                                                                                                                                                                            
  MOV EDI,graphbuf
@trL24_loop22:
  MOV [EDI],EAX                                                                                                                                                                                                                                                
  ADD EDI,trlinesize*4
  DEC ECX
  JNZ @trL24_loop22

{----------}
  MOV ESI,rend
  ADD ESI,24

  LODSD
  MOV lx2,EAX
  LODSD
  SUB EAX,py1
  MOV ly2,EAX

{----------}
  MOV ESI,rend
  MOV ECX,3
@trL24_loop33:
  PUSH ECX

  MOV EAX,lx2
  MOV lx1,EAX
  MOV EAX,ly2
  MOV ly1,EAX

  LODSD
  MOV lx2,EAX
  MOV EDX,EAX

  LODSD
  SUB EAX,py1
  MOV ly2,EAX
  MOV ECX,EAX

  ADD ESI,4

  MOV EAX,lx1
  MOV EBX,ly1

  CMP EBX,ECX
  JE @trL24_weiter44
  JL @trL24_weiter22
  XCHG EAX,EDX
  XCHG EBX,ECX
@trL24_weiter22:

  SUB EDX,EAX
  SUB ECX,EBX
  SHL EAX,16
  SHL EDX,16

  PUSH EAX
  MOV EAX,EDX
  CDQ
  IDIV ECX
  MOV EDX,EAX
  POP EAX

  MOV EDI,trlinesize*4
  IMUL EDI,EBX
  ADD EDI,graphbuf

@trL24_loop44:
  MOV EBX,[EDI]
  ADD EBX,4
  MOV [EDI],EBX
  PUSH EAX
  SAR EAX,16
  MOV [EDI+EBX],EAX
  POP EAX
  ADD EAX,EDX
  ADD EDI,trlinesize*4
  DEC ECX
  JNZ @trL24_loop44

@trL24_weiter44:
  POP ECX
  DEC ECX
  JNZ @trL24_loop33

{--- Zeichnen der X-Werte ---}

  LODSD
  MOV f,EAX

  XOR ESI,ESI

  MOV EAX,vy1
  MOV EBX,py1

  CMP EAX,EBX
  JLE @trL24_w5
  MOV ESI,EAX
  SUB ESI,EBX
  MOV EBX,EAX
  IMUL ESI,trlinesize*4
@trL24_w5:

  MOV EAX,vy2
  MOV ECX,py2

  CMP EAX,ECX
  JGE @trL24_w6
  INC EAX
  MOV ECX,EAX
@trL24_w6:

  SUB ECX,EBX
  ADD ESI,4
  ADD ESI,graphbuf

  IMUL EBX,bytperline
  ADD EBX,drawoffset
  ADD EBX,LFBoffs

@trL24_loop55:

  PUSH ECX

  MOV ECX,[ESI]
  MOV EDI,[ESI+4]

  CMP EDI,ECX
  JL @trL24_lineh_w1
  XCHG EDI,ECX
@trL24_lineh_w1:

  CMP EDI,vx2
  JG @trL24_lineh_ende
  CMP ECX,vx1
  JL @trL24_lineh_ende

  CMP EDI,vx1
  JGE @trL24_lineh_w2
  MOV EDI,vx1
@trL24_lineh_w2:
  CMP ECX,vx2
  JLE @trL24_lineh_w3
  MOV ECX,vx2
@trL24_lineh_w3:

  CLD
  SUB ECX,EDI
  INC ECX
  LEA EDI,[EDI+EDI*2]
  ADD EDI,EBX

  PUSH EBX

  MOV EAX,EDI
  NOT EAX
  INC EAX
  AND EAX,0003h

  LEA EDX,[ECX+ECX*2]
  SUB EDX,EAX

  MOV EBX,EDX
  SHR EDX,2

  MOV BH,AL
  AND EBX,0303h

  MOV EAX,f
  SHL EAX,8

  XOR ECX,ECX
  MOV CL,BH
  JECXZ @trL24_lineh_weiter1
@trL24_lineh_loop1a:
  MOV AL,AH
  ROR EAX,8
  STOSB
  DEC ECX
  JNZ @trL24_lineh_loop1a
@trL24_lineh_weiter1:

  MOV ECX,EDX
  JECXZ @trL24_lineh_weiter2
@trL24_lineh_loop1b:
  MOV AL,AH
  ROR EAX,8
  STOSD
  DEC ECX
  JNZ @trL24_lineh_loop1b
@trL24_lineh_weiter2:

  MOV CL,BL
  JECXZ @trL24_lineh_weiter3
@trL24_lineh_loop1c:
  SHR EAX,8
  STOSB
  DEC ECX
  JNZ @trL24_lineh_loop1c
@trL24_lineh_weiter3:
  POP EBX

@trL24_lineh_ende:
  POP ECX

  ADD EBX,bytperline
  ADD ESI,trlinesize*4

  DEC ECX
  JNZ @trL24_loop55
@trL24_ende:
END;


PROCEDURE triangle_flatL32(rend:prender);assembler;
CONST trlinesize=4;
VAR px1,py1,px2,py2,lx1,ly1,lx2,ly2,f:longint;
ASM
  MOV ESI,rend
  MOV EDI,graphbuf

  MOV px1,7FFFFFFFh
  MOV py1,7FFFFFFFh
  MOV px2,80000000h
  MOV py2,80000000h

  MOV ECX,3
@trL32_loop11:
  LODSD
  CMP EAX,px1
  JGE @trL32_w1
  MOV px1,EAX
@trL32_w1:
  CMP EAX,px2
  JLE @trL32_w2
  MOV px2,EAX
@trL32_w2:
  LODSD
  CMP EAX,py1
  JGE @trL32_w3
  MOV py1,EAX
@trL32_w3:
  CMP EAX,py2
  JLE @trL32_w4
  MOV py2,EAX
@trL32_w4:
  ADD ESI,4
  DEC ECX
  JNZ @trL32_loop11

{----------}

  MOV EAX,vx2
  CMP EAX,px1
  JLE @trL32_ende

  MOV EAX,vx1
  CMP EAX,px2
  JGE @trL32_ende

  MOV EAX,vy2
  CMP EAX,py1
  JLE @trL32_ende

  MOV EAX,vy1
  CMP EAX,py2
  JGE @trL32_ende

{----------}
  MOV ECX,py2
  SUB ECX,py1
  JZ @trL32_ende

  MOV EAX,00000000h
  MOV EDI,graphbuf
@trL32_loop22:
  MOV [EDI],EAX
  ADD EDI,trlinesize*4
  DEC ECX
  JNZ @trL32_loop22

{----------}
  MOV ESI,rend
  ADD ESI,24

  LODSD
  MOV lx2,EAX
  LODSD
  SUB EAX,py1
  MOV ly2,EAX

{----------}
  MOV ESI,rend
  MOV ECX,3
@trL32_loop33:
  PUSH ECX

  MOV EAX,lx2
  MOV lx1,EAX
  MOV EAX,ly2
  MOV ly1,EAX

  LODSD
  MOV lx2,EAX
  MOV EDX,EAX

  LODSD
  SUB EAX,py1
  MOV ly2,EAX
  MOV ECX,EAX

  ADD ESI,4

  MOV EAX,lx1
  MOV EBX,ly1

  CMP EBX,ECX
  JE @trL32_weiter44
  JL @trL32_weiter22
  XCHG EAX,EDX
  XCHG EBX,ECX
@trL32_weiter22:

  SUB EDX,EAX
  SUB ECX,EBX
  SHL EAX,16
  SHL EDX,16

  PUSH EAX
  MOV EAX,EDX
  CDQ
  IDIV ECX
  MOV EDX,EAX
  POP EAX

  MOV EDI,trlinesize*4
  IMUL EDI,EBX
  ADD EDI,graphbuf

@trL32_loop44:
  MOV EBX,[EDI]
  ADD EBX,4
  MOV [EDI],EBX
  PUSH EAX
  SAR EAX,16
  MOV [EDI+EBX],EAX
  POP EAX
  ADD EAX,EDX
  ADD EDI,trlinesize*4
  DEC ECX
  JNZ @trL32_loop44

@trL32_weiter44:
  POP ECX
  DEC ECX
  JNZ @trL32_loop33

{--- Zeichnen der X-Werte ---}

  LODSD
  MOV f,EAX

  XOR ESI,ESI

  MOV EAX,vy1
  MOV EBX,py1

  CMP EAX,EBX
  JLE @trL32_w5
  MOV ESI,EAX
  SUB ESI,EBX
  MOV EBX,EAX
  IMUL ESI,trlinesize*4
@trL32_w5:

  MOV EAX,vy2
  MOV ECX,py2

  CMP EAX,ECX
  JGE @trL32_w6
  INC EAX
  MOV ECX,EAX
@trL32_w6:

  SUB ECX,EBX
  ADD ESI,4
  ADD ESI,graphbuf

  IMUL EBX,bytperline
  ADD EBX,drawoffset
  ADD EBX,LFBoffs

@trL32_loop55:

  PUSH ECX

  MOV ECX,[ESI]
  MOV EDI,[ESI+4]

  CMP EDI,ECX
  JL @trL32_lineh_w1
  XCHG EDI,ECX
@trL32_lineh_w1:

  CMP EDI,vx2
  JG @trL32_lineh_ende
  CMP ECX,vx1
  JL @trL32_lineh_ende

  CMP EDI,vx1
  JGE @trL32_lineh_w2
  MOV EDI,vx1
@trL32_lineh_w2:
  CMP ECX,vx2
  JLE @trL32_lineh_w3
  MOV ECX,vx2
@trL32_lineh_w3:

  CLD
  SUB ECX,EDI
  INC ECX
  SHL EDI,2
  ADD EDI,EBX
  MOV EAX,f
  REP STOSD
@trL32_lineh_ende:
  POP ECX

  ADD EBX,bytperline
  ADD ESI,trlinesize*4

  DEC ECX
  JNZ @trL32_loop55
@trL32_ende:
END;

{ triangle_shaded =========================================================}

PROCEDURE triangle_gouraudL8(rend:prender);assembler;
VAR xp1,xp2,yp,xp1ai,xp1bi,xp2ai,xp2bi:longint;
    r,g,b,rd,gd,bd,
    r1,g1,b1,rd1a,gd1a,bd1a,rd1b,gd1b,bd1b,
    r2,g2,b2,rd2a,gd2a,bd2a,rd2b,gd2b,bd2b,
    r3,g3,b3:longint;
    lineoffs:dword;
    xd12,yd12,xd13,yd13,xd23,yd23,xdd1:longint;
    f3,f2,f1:longint;
    z3,y3,x3,z2,y2,x2,z1,y1,x1:longint; {=Trender}
ASM
{-- SWAP 1 / Y-sort --------}
  MOV EDI,rend
  MOV EAX,[EDI+04h]
  MOV EBX,[EDI+10h]
  MOV ECX,[EDI+1Ch]
  MOV EDX,0
  MOV EDI,4
  MOV ESI,8
  CMP EAX,EBX
  JL @tg8_noswap12
  XCHG EDX,EDI
  XCHG EAX,EBX
@tg8_noswap12:
  CMP EAX,ECX
  JL @tg8_noswap13
  XCHG EDX,ESI
  XCHG EAX,ECX
@tg8_noswap13:
  CMP EBX,ECX
  JL @tg8_noswap23
  XCHG EDI,ESI
  XCHG EBX,ECX
@tg8_noswap23:

  MOV ECX,rend

  MOV EAX,[ECX+EDX+24h]
  MOV f1,EAX
  LEA EDX,[EDX+EDX*2]
  MOV EAX,[ECX+EDX+00h]
  MOV x1,EAX
  MOV EAX,[ECX+EDX+04h]
  MOV y1,EAX

  MOV EAX,[ECX+EDI+24h]
  MOV f2,EAX
  LEA EDI,[EDI+EDI*2]
  MOV EAX,[ECX+EDI+00h]
  MOV x2,EAX
  MOV EAX,[ECX+EDI+04h]
  MOV y2,EAX

  MOV EAX,[ECX+ESI+24h]
  MOV f3,EAX
  LEA ESI,[ESI+ESI*2]
  MOV EAX,[ECX+ESI+00h]
  MOV x3,EAX
  MOV EAX,[ECX+ESI+04h]
  MOV y3,EAX

{-- x/y setup --------------}
  MOV EDX,x1
  MOV EBX,x2
  MOV EDI,x3
  MOV ECX,x3
  SUB EDI,EDX
  SUB ECX,EBX
  SUB EBX,EDX
  MOV xd13,EDI
  MOV xd23,ECX
  MOV xd12,EBX

  SHL EDX,16
  MOV xp1,EDX
  MOV xp2,EDX

  MOV EDX,y1
  MOV EBX,y2
  MOV EDI,y3
  MOV ECX,y3
  SUB EDI,EDX
  SUB ECX,EBX
  SUB EBX,EDX
  INC EDI
  INC ECX
  INC EBX
  MOV yd13,EDI
  MOV yd23,ECX
  MOV yd12,EBX
{-- x/y setup - x/y inc ----}
  MOV EAX,xd13
  SHL EAX,16
  CDQ
  IDIV EDI
  MOV xp1ai,EAX
  MOV xp2ai,EAX

  MOV EAX,xd12
  SHL EAX,16
  CDQ
  IDIV EBX
  MOV xp1bi,EAX

  MOV EAX,xd23
  SHL EAX,16
  CDQ
  IDIV ECX
  MOV xp2bi,EAX
{-- f# ==> r#/g#/b# --------}
  MOV EAX,f1
  SHL EAX,16
  SHRD EBX,EAX,29
  SHRD ECX,EAX,26
  AND EAX,00E00000h
  AND EBX,00E00000h
  AND ECX,00C00000h
  MOV r1,EAX
  MOV g1,EBX
  MOV b1,ECX
  MOV EAX,f2
  SHL EAX,16
  SHRD EBX,EAX,29
  SHRD ECX,EAX,26
  AND EAX,00E00000h
  AND EBX,00E00000h
  AND ECX,00C00000h
  MOV r2,EAX
  MOV g2,EBX
  MOV b2,ECX
  MOV EAX,f3
  SHL EAX,16
  SHRD EBX,EAX,29
  SHRD ECX,EAX,26
  AND EAX,00E00000h
  AND EBX,00E00000h
  AND ECX,00C00000h
  MOV r3,EAX
  MOV g3,EBX
  MOV b3,ECX
{-- (Cx-Cy)/(Yx-Yy) --------}
  MOV ECX,yd13
  MOV EAX,b3
  SUB EAX,b1
  CDQ
  IDIV ECX
  MOV bd1a,EAX
  MOV bd2a,EAX
  MOV EAX,g3
  SUB EAX,g1
  CDQ
  IDIV ECX
  MOV gd1a,EAX
  MOV gd2a,EAX
  MOV EAX,r3
  SUB EAX,r1
  CDQ
  IDIV ECX
  MOV rd1a,EAX
  MOV rd2a,EAX

  MOV ECX,yd12
  MOV EAX,b2
  SUB EAX,b1
  CDQ
  IDIV ECX
  MOV bd1b,EAX
  MOV EAX,g2
  SUB EAX,g1
  CDQ
  IDIV ECX
  MOV gd1b,EAX
  MOV EAX,r2
  SUB EAX,r1
  CDQ
  IDIV ECX
  MOV rd1b,EAX

  MOV ECX,yd23
  MOV EAX,b3
  SUB EAX,b2
  CDQ
  IDIV ECX
  MOV bd2b,EAX
  MOV EAX,g3
  SUB EAX,g2
  CDQ
  IDIV ECX
  MOV gd2b,EAX
  MOV EAX,r3
  SUB EAX,r2
  CDQ
  IDIV ECX
  MOV rd2b,EAX
{-- SWAP 2 -----------------}
  MOV EAX,xd13
  IMUL yd12
  IDIV yd13
  MOV EDX,EAX

  MOV EAX,x1
  ADD EAX,EDX
  CMP EAX,x2
  JLE @tg8_noswap2
  MOV EAX,xp1ai
  MOV EBX,xp2ai
  XCHG EAX,xp1bi
  XCHG EBX,xp2bi
  MOV xp1ai,EAX
  MOV xp2ai,EBX
  MOV EAX,rd1a
  MOV EBX,gd1a
  MOV ECX,bd1a
  XCHG EAX,rd1b
  XCHG EBX,gd1b
  XCHG ECX,bd1b
  MOV rd1a,EAX
  MOV gd1a,EBX
  MOV bd1a,ECX
  MOV EAX,rd2a
  MOV EBX,gd2a
  MOV ECX,bd2a
  XCHG EAX,rd2b
  XCHG EBX,gd2b
  XCHG ECX,bd2b
  MOV rd2a,EAX
  MOV gd2a,EBX
  MOV bd2a,ECX
@tg8_noswap2:
{-- col X increase ---------}
  MOV EBX,yd12
  MOV ECX,xd12
  SUB ECX,EDX
  MOV EDX,ECX
  SAR EDX,31
  XOR ECX,EDX
  SUB ECX,EDX
  INC ECX
  MOV EAX,rd1b
  SUB EAX,rd1a
  IMUL EBX
  IDIV ECX
  SHL EAX,8
  MOV rd,EAX
  MOV EAX,gd1b
  SUB EAX,gd1a
  IMUL EBX
  IDIV ECX
  SHL EAX,8
  MOV gd,EAX
  MOV EAX,bd1b
  SUB EAX,bd1a
  IMUL EBX
  IDIV ECX
  SHL EAX,8
  MOV bd,EAX
{---------------------------}
  SHL r1,8
  SHL g1,8
  SHL b1,8
  SHL rd1a,8
  SHL gd1a,8
  SHL bd1a,8
  SHL rd2a,8
  SHL gd2a,8
  SHL bd2a,8
{-- DRAW OR NOT TO DRAW 1st }
  MOV EAX,vy1
  CMP EAX,y2
  JG @tg8_else1
  MOV EAX,vy2
  CMP EAX,y1
  JL @tg8_else1
{-- skip top of 1st part ---}
  MOV EBX,vy1
  SUB EBX,y1
  JLE @tg8_noskip1t
  MOV EAX,xp1ai
  MUL EBX
  ADD xp1,EAX
  MOV EAX,xp1bi
  MUL EBX
  ADD xp2,EAX
  MOV EAX,rd1a
  MUL EBX
  ADD r1,EAX
  MOV EAX,gd1a
  MUL EBX
  ADD g1,EAX
  MOV EAX,bd1a
  MUL EBX
  ADD b1,EAX
  MOV EAX,vy1
  MOV y1,EAX
@tg8_noskip1t:
{-- IF y2>vy2 THEN y2:=vy2; }
  MOV EAX,vy2
  CMP EAX,y2
  JGE @tg8_weiter1t
  MOV y2,EAX
@tg8_weiter1t:
{-- lineoffs ---------------}
  MOV EAX,y1
  MUL bytperline
  ADD EAX,drawoffset
  ADD EAX,LFBoffs
  MOV lineoffs,EAX
{-- draw 1st part ----------}
  MOV ECX,y2
  SUB ECX,y1
  JS @tg8_nodraw1
  INC ECX
@tg8_loopt1:
  PUSH ECX

  MOVSX EDI,WORD PTR [xp1+2]
  MOVSX ECX,WORD PTR [xp2+2]
  SUB ECX,EDI
  JLE @tg8_nolinea
  INC ECX

  XOR EBX,EBX
  XOR ESI,ESI
  XOR EDX,EDX

  MOV EAX,vx1
  SUB EAX,EDI
  JLE @tg8_noleftclipa
  MOV EBX,bd
  MOV ESI,gd
  MOV EDX,rd
  IMUL EBX,EAX
  IMUL ESI,EAX
  IMUL EDX,EAX
  SUB ECX,EAX
  JLE @tg8_nolinea
  MOV EDI,vx1
@tg8_noleftclipa:
  MOV EAX,EDI
  ADD EAX,ECX
  SUB EAX,vx2
  JLE @tg8_norightclipa
  DEC EAX
  SUB ECX,EAX
  JLE @tg8_nolinea
@tg8_norightclipa:

  ADD EBX,b1
  ADD ESI,g1
  ADD EDX,r1
  ADD EDI,lineoffs

  TEST EDI,0003h
  JZ @tg8_nooddpix1a
  SHLD EAX,EDX,3
  SHLD EAX,ESI,3
  SHLD EAX,EBX,2
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  STOSB
  DEC ECX
@tg8_nooddpix1a:
  ROR ECX,1
  OR CX,CX
  JZ @tg8_noloopa
@tg8_loop1a:
  SHLD EAX,EDX,3
  SHLD EAX,ESI,3
  SHLD EAX,EBX,2
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  SHLD EAX,EDX,3
  SHLD EAX,ESI,3
  SHLD EAX,EBX,2
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  XCHG AL,AH
  STOSW
  DEC CX
  JNZ @tg8_loop1a
@tg8_noloopa:
  SHL ECX,1
  JNC @tg8_nolinea
  SHLD EAX,EDX,3
  SHLD EAX,ESI,3
  SHLD EAX,EBX,2
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  STOSB
@tg8_nolinea:

  MOV EAX,xp1ai
  MOV EBX,xp1bi
  MOV ECX,bytperline
  ADD xp1,EAX
  ADD xp2,EBX
  ADD lineoffs,ECX

  MOV EAX,rd1a
  MOV EBX,gd1a
  MOV ECX,bd1a
  ADD r1,EAX
  ADD g1,EBX
  ADD b1,ECX

  POP ECX
  DEC ECX
  JNZ @tg8_loopt1
  JMP @tg8_nodraw1
{-- ELSE: skip 1st part ----}
@tg8_else1:
  MOV EBX,y2
  SUB EBX,y1
  INC EBX
  MOV EAX,xp1ai
  MUL EBX
  ADD xp1,EAX
  MOV EAX,xp1bi
  MUL EBX
  ADD xp2,EAX
  MOV EAX,rd1a
  MUL EBX
  ADD r1,EAX
  MOV EAX,gd1a
  MUL EBX
  ADD g1,EAX
  MOV EAX,bd1a
  MUL EBX
  ADD b1,EAX
@tg8_nodraw1:
{---------------------------}
  INC y2
{-- DRAW OR NOT TO DRAW 2nd }
  MOV EAX,vy1
  CMP EAX,y3
  JG @tg8_else2
  MOV EAX,vy2
  CMP EAX,y2
  JL @tg8_else2
{-- skip top of 2nd part ---}
  MOV EBX,vy1
  SUB EBX,y2
  JLE @tg8_noskip2t
  MOV EAX,xp2ai
  MUL EBX
  ADD xp1,EAX
  MOV EAX,xp2bi
  MUL EBX
  ADD xp2,EAX
  MOV EAX,rd2a
  MUL EBX
  ADD r1,EAX
  MOV EAX,gd2a
  MUL EBX
  ADD g1,EAX
  MOV EAX,bd2a
  MUL EBX
  ADD b1,EAX
  MOV EAX,vy1
  MOV y2,EAX
@tg8_noskip2t:
{-- IF y3>vy2 THEN y3:=vy2; }
  MOV EAX,vy2
  CMP EAX,y3
  JGE @tg8_weiter2t
  MOV y3,EAX
@tg8_weiter2t:
{-- lineoffs ---------------}
  MOV EAX,y2
  MUL bytperline
  ADD EAX,drawoffset
  ADD EAX,LFBoffs
  MOV lineoffs,EAX
{-- draw 2nd part ----------}
  MOV ECX,y3
  SUB ECX,y2
  JS @tg8_nodraw2
  INC ECX
 @tg8_loopt2:
  PUSH ECX

  MOVSX EDI,WORD PTR [xp1+2]
  MOVSX ECX,WORD PTR [xp2+2]
  SUB ECX,EDI
  JLE @tg8_nolineb
  INC ECX

  XOR EBX,EBX
  XOR ESI,ESI
  XOR EDX,EDX

  MOV EAX,vx1
  SUB EAX,EDI
  JLE @tg8_noleftclipb
  MOV EBX,bd
  MOV ESI,gd
  MOV EDX,rd
  IMUL EBX,EAX
  IMUL ESI,EAX
  IMUL EDX,EAX
  SUB ECX,EAX
  JLE @tg8_nolineb
  MOV EDI,vx1
@tg8_noleftclipb:
  MOV EAX,EDI
  ADD EAX,ECX
  SUB EAX,vx2
  JLE @tg8_norightclipb
  DEC EAX
  SUB ECX,EAX
  JLE @tg8_nolineb
@tg8_norightclipb:

  ADD EBX,b1
  ADD ESI,g1
  ADD EDX,r1
  ADD EDI,lineoffs

  TEST EDI,0003h
  JZ @tg8_nooddpix1b
  SHLD EAX,EDX,3
  SHLD EAX,ESI,3
  SHLD EAX,EBX,2
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  STOSB
  DEC ECX
@tg8_nooddpix1b:
  ROR ECX,1
  OR CX,CX
  JZ @tg8_noloopb
@tg8_loop1b:
  SHLD EAX,EDX,3
  SHLD EAX,ESI,3
  SHLD EAX,EBX,2
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  SHLD EAX,EDX,3
  SHLD EAX,ESI,3
  SHLD EAX,EBX,2
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  XCHG AL,AH
  STOSW
  DEC CX
  JNZ @tg8_loop1b
@tg8_noloopb:
  SHL ECX,1
  JNC @tg8_nolineb
  SHLD EAX,EDX,3
  SHLD EAX,ESI,3
  SHLD EAX,EBX,2
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  STOSB
@tg8_nolineb:

  MOV EAX,xp2ai
  MOV EBX,xp2bi
  MOV ECX,bytperline
  ADD xp1,EAX
  ADD xp2,EBX
  ADD lineoffs,ECX

  MOV EAX,rd2a
  MOV EBX,gd2a
  MOV ECX,bd2a
  ADD r1,EAX
  ADD g1,EBX
  ADD b1,ECX

  POP ECX
  DEC ECX
  JNZ @tg8_loopt2
@tg8_nodraw2:
@tg8_else2:
END;

PROCEDURE triangle_gouraudL15(rend:prender);assembler;
VAR xp1,xp2,yp,xp1ai,xp1bi,xp2ai,xp2bi:longint;
    r,g,b,rd,gd,bd,
    r1,g1,b1,rd1a,gd1a,bd1a,rd1b,gd1b,bd1b,
    r2,g2,b2,rd2a,gd2a,bd2a,rd2b,gd2b,bd2b,
    r3,g3,b3:longint;
    lineoffs:dword;
    xd12,yd12,xd13,yd13,xd23,yd23,xdd1:longint;
    f3,f2,f1:longint;
    z3,y3,x3,z2,y2,x2,z1,y1,x1:longint; {=Trender}
ASM
{-- SWAP 1 / Y-sort --------}
  MOV EDI,rend
  MOV EAX,[EDI+04h]
  MOV EBX,[EDI+10h]
  MOV ECX,[EDI+1Ch]
  MOV EDX,0
  MOV EDI,4
  MOV ESI,8
  CMP EAX,EBX
  JL @tg15_noswap12
  XCHG EDX,EDI
  XCHG EAX,EBX
@tg15_noswap12:
  CMP EAX,ECX
  JL @tg15_noswap13
  XCHG EDX,ESI
  XCHG EAX,ECX
@tg15_noswap13:
  CMP EBX,ECX
  JL @tg15_noswap23
  XCHG EDI,ESI
  XCHG EBX,ECX
@tg15_noswap23:

  MOV ECX,rend

  MOV EAX,[ECX+EDX+24h]
  MOV f1,EAX
  LEA EDX,[EDX+EDX*2]
  MOV EAX,[ECX+EDX+00h]
  MOV x1,EAX
  MOV EAX,[ECX+EDX+04h]
  MOV y1,EAX

  MOV EAX,[ECX+EDI+24h]
  MOV f2,EAX
  LEA EDI,[EDI+EDI*2]
  MOV EAX,[ECX+EDI+00h]
  MOV x2,EAX
  MOV EAX,[ECX+EDI+04h]
  MOV y2,EAX

  MOV EAX,[ECX+ESI+24h]
  MOV f3,EAX
  LEA ESI,[ESI+ESI*2]
  MOV EAX,[ECX+ESI+00h]
  MOV x3,EAX
  MOV EAX,[ECX+ESI+04h]
  MOV y3,EAX

{-- x/y setup --------------}
  MOV EDX,x1
  MOV EBX,x2
  MOV EDI,x3
  MOV ECX,x3
  SUB EDI,EDX
  SUB ECX,EBX
  SUB EBX,EDX
  MOV xd13,EDI
  MOV xd23,ECX
  MOV xd12,EBX

  SHL EDX,16
  MOV xp1,EDX
  MOV xp2,EDX

  MOV EDX,y1
  MOV EBX,y2
  MOV EDI,y3
  MOV ECX,y3
  SUB EDI,EDX
  SUB ECX,EBX
  SUB EBX,EDX
  INC EDI
  INC ECX
  INC EBX
  MOV yd13,EDI
  MOV yd23,ECX
  MOV yd12,EBX
{-- x/y setup - x/y inc ----}
  MOV EAX,xd13
  SHL EAX,16
  CDQ
  IDIV EDI
  MOV xp1ai,EAX
  MOV xp2ai,EAX

  MOV EAX,xd12
  SHL EAX,16
  CDQ
  IDIV EBX
  MOV xp1bi,EAX

  MOV EAX,xd23
  SHL EAX,16
  CDQ
  IDIV ECX
  MOV xp2bi,EAX
{-- f# ==> r#/g#/b# --------}
  MOV EDX,00F80000h
  MOV EAX,f1
  SHL EAX,9
  SHRD EBX,EAX,27
  SHRD ECX,EAX,22
  AND EAX,EDX
  AND EBX,EDX
  AND ECX,EDX
  MOV r1,EAX
  MOV g1,EBX
  MOV b1,ECX
  MOV EAX,f2
  SHL EAX,9
  SHRD EBX,EAX,27
  SHRD ECX,EAX,22
  AND EAX,EDX
  AND EBX,EDX
  AND ECX,EDX
  MOV r2,EAX
  MOV g2,EBX
  MOV b2,ECX
  MOV EAX,f3
  SHL EAX,9
  SHRD EBX,EAX,27
  SHRD ECX,EAX,22
  AND EAX,EDX
  AND EBX,EDX
  AND ECX,EDX
  MOV r3,EAX
  MOV g3,EBX
  MOV b3,ECX
{-- (Cx-Cy)/(Yx-Yy) --------}
  MOV ECX,yd13
  MOV EAX,b3
  SUB EAX,b1
  CDQ
  IDIV ECX
  MOV bd1a,EAX
  MOV bd2a,EAX
  MOV EAX,g3
  SUB EAX,g1
  CDQ
  IDIV ECX
  MOV gd1a,EAX
  MOV gd2a,EAX
  MOV EAX,r3
  SUB EAX,r1
  CDQ
  IDIV ECX
  MOV rd1a,EAX
  MOV rd2a,EAX

  MOV ECX,yd12
  MOV EAX,b2
  SUB EAX,b1
  CDQ
  IDIV ECX
  MOV bd1b,EAX
  MOV EAX,g2
  SUB EAX,g1
  CDQ
  IDIV ECX
  MOV gd1b,EAX
  MOV EAX,r2
  SUB EAX,r1
  CDQ
  IDIV ECX
  MOV rd1b,EAX

  MOV ECX,yd23
  MOV EAX,b3
  SUB EAX,b2
  CDQ
  IDIV ECX
  MOV bd2b,EAX
  MOV EAX,g3
  SUB EAX,g2
  CDQ
  IDIV ECX
  MOV gd2b,EAX
  MOV EAX,r3
  SUB EAX,r2
  CDQ
  IDIV ECX
  MOV rd2b,EAX
{-- SWAP 2 -----------------}
  MOV EAX,xd13
  IMUL yd12
  IDIV yd13
  MOV EDX,EAX

  MOV EAX,x1
  ADD EAX,EDX
  CMP EAX,x2
  JLE @tg15_noswap2
  MOV EAX,xp1ai
  MOV EBX,xp2ai
  XCHG EAX,xp1bi
  XCHG EBX,xp2bi
  MOV xp1ai,EAX
  MOV xp2ai,EBX
  MOV EAX,rd1a
  MOV EBX,gd1a
  MOV ECX,bd1a
  XCHG EAX,rd1b
  XCHG EBX,gd1b
  XCHG ECX,bd1b
  MOV rd1a,EAX
  MOV gd1a,EBX
  MOV bd1a,ECX
  MOV EAX,rd2a
  MOV EBX,gd2a
  MOV ECX,bd2a
  XCHG EAX,rd2b
  XCHG EBX,gd2b
  XCHG ECX,bd2b
  MOV rd2a,EAX
  MOV gd2a,EBX
  MOV bd2a,ECX
@tg15_noswap2:
{-- col X increase ---------}
  MOV EBX,yd12
  MOV ECX,xd12
  SUB ECX,EDX
  MOV EDX,ECX
  SAR EDX,31
  XOR ECX,EDX
  SUB ECX,EDX
  INC ECX
  MOV EAX,rd1b
  SUB EAX,rd1a
  IMUL EBX
  IDIV ECX
  SHL EAX,8
  MOV rd,EAX
  MOV EAX,gd1b
  SUB EAX,gd1a
  IMUL EBX
  IDIV ECX
  SHL EAX,8
  MOV gd,EAX
  MOV EAX,bd1b
  SUB EAX,bd1a
  IMUL EBX
  IDIV ECX
  SHL EAX,8
  MOV bd,EAX
{---------------------------}
  SHL r1,8
  SHL g1,8
  SHL b1,8
  SHL rd1a,8
  SHL gd1a,8
  SHL bd1a,8
  SHL rd2a,8
  SHL gd2a,8
  SHL bd2a,8
{-- DRAW OR NOT TO DRAW 1st }
  MOV EAX,vy1
  CMP EAX,y2
  JG @tg15_else1
  MOV EAX,vy2
  CMP EAX,y1
  JL @tg15_else1
{-- skip top of 1st part ---}
  MOV EBX,vy1
  SUB EBX,y1
  JLE @tg15_noskip1t
  MOV EAX,xp1ai
  MUL EBX
  ADD xp1,EAX
  MOV EAX,xp1bi
  MUL EBX
  ADD xp2,EAX
  MOV EAX,rd1a
  MUL EBX
  ADD r1,EAX
  MOV EAX,gd1a
  MUL EBX
  ADD g1,EAX
  MOV EAX,bd1a
  MUL EBX
  ADD b1,EAX
  MOV EAX,vy1
  MOV y1,EAX
@tg15_noskip1t:
{-- IF y2>vy2 THEN y2:=vy2; }
  MOV EAX,vy2
  CMP EAX,y2
  JGE @tg15_weiter1t
  MOV y2,EAX
@tg15_weiter1t:
{-- lineoffs ---------------}
  MOV EAX,y1
  MUL bytperline
  ADD EAX,drawoffset
  ADD EAX,LFBoffs
  MOV lineoffs,EAX
{-- draw 1st part ----------}
  MOV ECX,y2
  SUB ECX,y1
  JS @tg15_nodraw1
  INC ECX
@tg15_loopt1:
  PUSH ECX

  MOVSX EDI,WORD PTR [xp1+2]
  MOVSX ECX,WORD PTR [xp2+2]
  SUB ECX,EDI
  JLE @tg15_nolinea
  INC ECX

  XOR EBX,EBX
  XOR ESI,ESI
  XOR EDX,EDX

  MOV EAX,vx1
  SUB EAX,EDI
  JLE @tg15_noleftclipa
  MOV EBX,bd
  MOV ESI,gd
  MOV EDX,rd
  IMUL EBX,EAX
  IMUL ESI,EAX
  IMUL EDX,EAX
  SUB ECX,EAX
  JLE @tg15_nolinea
  MOV EDI,vx1
@tg15_noleftclipa:
  MOV EAX,EDI
  ADD EAX,ECX
  SUB EAX,vx2
  JLE @tg15_norightclipa
  DEC EAX
  SUB ECX,EAX
  JLE @tg15_nolinea
@tg15_norightclipa:

  SHL EDI,1 {bytperpix}
  ADD EBX,b1
  ADD ESI,g1
  ADD EDX,r1
  ADD EDI,lineoffs

  TEST EDI,0003h
  JZ @tg15_nooddpix1a
  SHLD EAX,EDX,5
  SHLD EAX,ESI,5
  SHLD EAX,EBX,5
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  STOSW
  DEC ECX
@tg15_nooddpix1a:
  ROR ECX,1
  OR CX,CX
  JZ @tg15_noloopa
@tg15_loop1a:
  SHLD EAX,EDX,5
  SHLD EAX,ESI,5
  SHLD EAX,EBX,5
  ADD EDX,rd
  ADD ESI,gd
  SHL EAX,1
  ADD EBX,bd
  SHLD EAX,EDX,5
  SHLD EAX,ESI,5
  SHLD EAX,EBX,5
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  ROR EAX,16
  STOSD
  DEC CX
  JNZ @tg15_loop1a
@tg15_noloopa:
  SHL ECX,1
  JNC @tg15_nolinea
  SHLD EAX,EDX,5
  SHLD EAX,ESI,5
  SHLD EAX,EBX,5
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  STOSW
@tg15_nolinea:

  MOV EAX,xp1ai
  MOV EBX,xp1bi
  MOV ECX,bytperline
  ADD xp1,EAX
  ADD xp2,EBX
  ADD lineoffs,ECX

  MOV EAX,rd1a
  MOV EBX,gd1a
  MOV ECX,bd1a
  ADD r1,EAX
  ADD g1,EBX
  ADD b1,ECX

  POP ECX
  DEC ECX
  JNZ @tg15_loopt1
  JMP @tg15_nodraw1
{-- ELSE: skip 1st part ----}
@tg15_else1:
  MOV EBX,y2
  SUB EBX,y1
  INC EBX
  MOV EAX,xp1ai
  MUL EBX
  ADD xp1,EAX
  MOV EAX,xp1bi
  MUL EBX
  ADD xp2,EAX
  MOV EAX,rd1a
  MUL EBX
  ADD r1,EAX
  MOV EAX,gd1a
  MUL EBX
  ADD g1,EAX
  MOV EAX,bd1a
  MUL EBX
  ADD b1,EAX
@tg15_nodraw1:
{---------------------------}
  INC y2
{-- DRAW OR NOT TO DRAW 2nd }
  MOV EAX,vy1
  CMP EAX,y3
  JG @tg15_else2
  MOV EAX,vy2
  CMP EAX,y2
  JL @tg15_else2
{-- skip top of 2nd part ---}
  MOV EBX,vy1
  SUB EBX,y2
  JLE @tg15_noskip2t
  MOV EAX,xp2ai
  MUL EBX
  ADD xp1,EAX
  MOV EAX,xp2bi
  MUL EBX
  ADD xp2,EAX
  MOV EAX,rd2a
  MUL EBX
  ADD r1,EAX
  MOV EAX,gd2a
  MUL EBX
  ADD g1,EAX
  MOV EAX,bd2a
  MUL EBX
  ADD b1,EAX
  MOV EAX,vy1
  MOV y2,EAX
@tg15_noskip2t:
{-- IF y3>vy2 THEN y3:=vy2; }
  MOV EAX,vy2
  CMP EAX,y3
  JGE @tg15_weiter2t
  MOV y3,EAX
@tg15_weiter2t:
{-- lineoffs ---------------}
  MOV EAX,y2
  MUL bytperline
  ADD EAX,drawoffset
  ADD EAX,LFBoffs
  MOV lineoffs,EAX
{-- draw 2nd part ----------}
  MOV ECX,y3
  SUB ECX,y2
  JS @tg15_nodraw2
  INC ECX
 @tg15_loopt2:
  PUSH ECX

  MOVSX EDI,WORD PTR [xp1+2]
  MOVSX ECX,WORD PTR [xp2+2]
  SUB ECX,EDI
  JLE @tg15_nolineb
  INC ECX

  XOR EBX,EBX
  XOR ESI,ESI
  XOR EDX,EDX

  MOV EAX,vx1
  SUB EAX,EDI
  JLE @tg15_noleftclipb
  MOV EBX,bd
  MOV ESI,gd
  MOV EDX,rd
  IMUL EBX,EAX
  IMUL ESI,EAX
  IMUL EDX,EAX
  SUB ECX,EAX
  JLE @tg15_nolineb
  MOV EDI,vx1
@tg15_noleftclipb:
  MOV EAX,EDI
  ADD EAX,ECX
  SUB EAX,vx2
  JLE @tg15_norightclipb
  DEC EAX
  SUB ECX,EAX
  JLE @tg15_nolineb
@tg15_norightclipb:

  SHL EDI,1 {bytperpix}
  ADD EBX,b1
  ADD ESI,g1
  ADD EDX,r1
  ADD EDI,lineoffs

  TEST EDI,0003h
  JZ @tg15_nooddpix1b
  SHLD EAX,EDX,5
  SHLD EAX,ESI,5
  SHLD EAX,EBX,5
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  STOSW
  DEC ECX
@tg15_nooddpix1b:
  ROR ECX,1
  OR CX,CX
  JZ @tg15_noloopb
@tg15_loop1b:
  SHLD EAX,EDX,5
  SHLD EAX,ESI,5
  SHLD EAX,EBX,5
  ADD EDX,rd
  ADD ESI,gd
  SHL EAX,1
  ADD EBX,bd
  SHLD EAX,EDX,5
  SHLD EAX,ESI,5
  SHLD EAX,EBX,5
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  ROR EAX,16
  STOSD
  DEC CX
  JNZ @tg15_loop1b
@tg15_noloopb:
  SHL ECX,1
  JNC @tg15_nolineb
  SHLD EAX,EDX,5
  SHLD EAX,ESI,5
  SHLD EAX,EBX,5
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  STOSW
@tg15_nolineb:

  MOV EAX,xp2ai
  MOV EBX,xp2bi
  MOV ECX,bytperline
  ADD xp1,EAX
  ADD xp2,EBX
  ADD lineoffs,ECX

  MOV EAX,rd2a
  MOV EBX,gd2a
  MOV ECX,bd2a
  ADD r1,EAX
  ADD g1,EBX
  ADD b1,ECX

  POP ECX
  DEC ECX
  JNZ @tg15_loopt2
@tg15_nodraw2:
@tg15_else2:
END;

PROCEDURE triangle_gouraudL16(rend:prender);assembler;
VAR xp1,xp2,yp,xp1ai,xp1bi,xp2ai,xp2bi:longint;
    r,g,b,rd,gd,bd,
    r1,g1,b1,rd1a,gd1a,bd1a,rd1b,gd1b,bd1b,
    r2,g2,b2,rd2a,gd2a,bd2a,rd2b,gd2b,bd2b,
    r3,g3,b3:longint;
    lineoffs:dword;
    xd12,yd12,xd13,yd13,xd23,yd23,xdd1:longint;
    f3,f2,f1:longint;
    z3,y3,x3,z2,y2,x2,z1,y1,x1:longint; {=Trender}
ASM
{-- SWAP 1 / Y-sort --------}
  MOV EDI,rend
  MOV EAX,[EDI+04h]
  MOV EBX,[EDI+10h]
  MOV ECX,[EDI+1Ch]
  MOV EDX,0
  MOV EDI,4
  MOV ESI,8
  CMP EAX,EBX
  JL @tg16_noswap12
  XCHG EDX,EDI
  XCHG EAX,EBX
@tg16_noswap12:
  CMP EAX,ECX
  JL @tg16_noswap13
  XCHG EDX,ESI
  XCHG EAX,ECX
@tg16_noswap13:
  CMP EBX,ECX
  JL @tg16_noswap23
  XCHG EDI,ESI
  XCHG EBX,ECX
@tg16_noswap23:

  MOV ECX,rend

  MOV EAX,[ECX+EDX+24h]
  MOV f1,EAX
  LEA EDX,[EDX+EDX*2]
  MOV EAX,[ECX+EDX+00h]
  MOV x1,EAX
  MOV EAX,[ECX+EDX+04h]
  MOV y1,EAX

  MOV EAX,[ECX+EDI+24h]
  MOV f2,EAX
  LEA EDI,[EDI+EDI*2]
  MOV EAX,[ECX+EDI+00h]
  MOV x2,EAX
  MOV EAX,[ECX+EDI+04h]
  MOV y2,EAX

  MOV EAX,[ECX+ESI+24h]
  MOV f3,EAX
  LEA ESI,[ESI+ESI*2]
  MOV EAX,[ECX+ESI+00h]
  MOV x3,EAX
  MOV EAX,[ECX+ESI+04h]
  MOV y3,EAX

{-- x/y setup --------------}
  MOV EDX,x1
  MOV EBX,x2
  MOV EDI,x3
  MOV ECX,x3
  SUB EDI,EDX
  SUB ECX,EBX
  SUB EBX,EDX
  MOV xd13,EDI
  MOV xd23,ECX
  MOV xd12,EBX

  SHL EDX,16
  MOV xp1,EDX
  MOV xp2,EDX

  MOV EDX,y1
  MOV EBX,y2
  MOV EDI,y3
  MOV ECX,y3
  SUB EDI,EDX
  SUB ECX,EBX
  SUB EBX,EDX
  INC EDI
  INC ECX
  INC EBX
  MOV yd13,EDI
  MOV yd23,ECX
  MOV yd12,EBX
{-- x/y setup - x/y inc ----}
  MOV EAX,xd13
  SHL EAX,16
  CDQ
  IDIV EDI
  MOV xp1ai,EAX
  MOV xp2ai,EAX

  MOV EAX,xd12
  SHL EAX,16
  CDQ
  IDIV EBX
  MOV xp1bi,EAX

  MOV EAX,xd23
  SHL EAX,16
  CDQ
  IDIV ECX
  MOV xp2bi,EAX
{-- f# ==> r#/g#/b# --------}
  MOV EAX,f1
  SHL EAX,8
  SHRD EBX,EAX,27
  SHRD ECX,EAX,21
  AND EAX,00F80000h
  AND EBX,00FC0000h
  AND ECX,00F80000h
  MOV r1,EAX
  MOV g1,EBX
  MOV b1,ECX
  MOV EAX,f2
  SHL EAX,8
  SHRD EBX,EAX,27
  SHRD ECX,EAX,21
  AND EAX,00F80000h
  AND EBX,00FC0000h
  AND ECX,00F80000h
  MOV r2,EAX
  MOV g2,EBX
  MOV b2,ECX
  MOV EAX,f3
  SHL EAX,8
  SHRD EBX,EAX,27
  SHRD ECX,EAX,21
  AND EAX,00F80000h
  AND EBX,00FC0000h
  AND ECX,00F80000h
  MOV r3,EAX
  MOV g3,EBX
  MOV b3,ECX
{-- (Cx-Cy)/(Yx-Yy) --------}
  MOV ECX,yd13
  MOV EAX,b3
  SUB EAX,b1
  CDQ
  IDIV ECX
  MOV bd1a,EAX
  MOV bd2a,EAX
  MOV EAX,g3
  SUB EAX,g1
  CDQ
  IDIV ECX
  MOV gd1a,EAX
  MOV gd2a,EAX
  MOV EAX,r3
  SUB EAX,r1
  CDQ
  IDIV ECX
  MOV rd1a,EAX
  MOV rd2a,EAX

  MOV ECX,yd12
  MOV EAX,b2
  SUB EAX,b1
  CDQ
  IDIV ECX
  MOV bd1b,EAX
  MOV EAX,g2
  SUB EAX,g1
  CDQ
  IDIV ECX
  MOV gd1b,EAX
  MOV EAX,r2
  SUB EAX,r1
  CDQ
  IDIV ECX
  MOV rd1b,EAX

  MOV ECX,yd23
  MOV EAX,b3
  SUB EAX,b2
  CDQ
  IDIV ECX
  MOV bd2b,EAX
  MOV EAX,g3
  SUB EAX,g2
  CDQ
  IDIV ECX
  MOV gd2b,EAX
  MOV EAX,r3
  SUB EAX,r2
  CDQ
  IDIV ECX
  MOV rd2b,EAX
{-- SWAP 2 -----------------}
  MOV EAX,xd13
  IMUL yd12
  IDIV yd13
  MOV EDX,EAX

  MOV EAX,x1
  ADD EAX,EDX
  CMP EAX,x2
  JLE @tg16_noswap2
  MOV EAX,xp1ai
  MOV EBX,xp2ai
  XCHG EAX,xp1bi
  XCHG EBX,xp2bi
  MOV xp1ai,EAX
  MOV xp2ai,EBX
  MOV EAX,rd1a
  MOV EBX,gd1a
  MOV ECX,bd1a
  XCHG EAX,rd1b
  XCHG EBX,gd1b
  XCHG ECX,bd1b
  MOV rd1a,EAX
  MOV gd1a,EBX
  MOV bd1a,ECX
  MOV EAX,rd2a
  MOV EBX,gd2a
  MOV ECX,bd2a
  XCHG EAX,rd2b
  XCHG EBX,gd2b
  XCHG ECX,bd2b
  MOV rd2a,EAX
  MOV gd2a,EBX
  MOV bd2a,ECX
@tg16_noswap2:
{-- col X increase ---------}
  MOV EBX,yd12
  MOV ECX,xd12
  SUB ECX,EDX
  MOV EDX,ECX
  SAR EDX,31
  XOR ECX,EDX
  SUB ECX,EDX
  INC ECX
  MOV EAX,rd1b
  SUB EAX,rd1a
  IMUL EBX
  IDIV ECX
  SHL EAX,8
  MOV rd,EAX
  MOV EAX,gd1b
  SUB EAX,gd1a
  IMUL EBX
  IDIV ECX
  SHL EAX,8
  MOV gd,EAX
  MOV EAX,bd1b
  SUB EAX,bd1a
  IMUL EBX
  IDIV ECX
  SHL EAX,8
  MOV bd,EAX
{---------------------------}
  SHL r1,8
  SHL g1,8
  SHL b1,8
  SHL rd1a,8
  SHL gd1a,8
  SHL bd1a,8
  SHL rd2a,8
  SHL gd2a,8
  SHL bd2a,8
{-- DRAW OR NOT TO DRAW 1st }
  MOV EAX,vy1
  CMP EAX,y2
  JG @tg16_else1
  MOV EAX,vy2
  CMP EAX,y1
  JL @tg16_else1
{-- skip top of 1st part ---}
  MOV EBX,vy1
  SUB EBX,y1
  JLE @tg16_noskip1t
  MOV EAX,xp1ai
  MUL EBX
  ADD xp1,EAX
  MOV EAX,xp1bi
  MUL EBX
  ADD xp2,EAX
  MOV EAX,rd1a
  MUL EBX
  ADD r1,EAX
  MOV EAX,gd1a
  MUL EBX
  ADD g1,EAX
  MOV EAX,bd1a
  MUL EBX
  ADD b1,EAX
  MOV EAX,vy1
  MOV y1,EAX
@tg16_noskip1t:
{-- IF y2>vy2 THEN y2:=vy2; }
  MOV EAX,vy2
  CMP EAX,y2
  JGE @tg16_weiter1t
  MOV y2,EAX
@tg16_weiter1t:
{-- lineoffs ---------------}
  MOV EAX,y1
  MUL bytperline
  ADD EAX,drawoffset
  ADD EAX,LFBoffs
  MOV lineoffs,EAX
{-- draw 1st part ----------}
  MOV ECX,y2
  SUB ECX,y1
  JS @tg16_nodraw1
  INC ECX
@tg16_loopt1:
  PUSH ECX

  MOVSX EDI,WORD PTR [xp1+2]
  MOVSX ECX,WORD PTR [xp2+2]
  SUB ECX,EDI
  JLE @tg16_nolinea
  INC ECX

  XOR EBX,EBX
  XOR ESI,ESI
  XOR EDX,EDX

  MOV EAX,vx1
  SUB EAX,EDI
  JLE @tg16_noleftclipa
  MOV EBX,bd
  MOV ESI,gd
  MOV EDX,rd
  IMUL EBX,EAX
  IMUL ESI,EAX
  IMUL EDX,EAX
  SUB ECX,EAX
  JLE @tg16_nolinea
  MOV EDI,vx1
@tg16_noleftclipa:
  MOV EAX,EDI
  ADD EAX,ECX
  SUB EAX,vx2
  JLE @tg16_norightclipa
  DEC EAX
  SUB ECX,EAX
  JLE @tg16_nolinea
@tg16_norightclipa:

  SHL EDI,1 {bytperpix}
  ADD EBX,b1
  ADD ESI,g1
  ADD EDX,r1
  ADD EDI,lineoffs

  TEST EDI,0003h
  JZ @tg16_nooddpix1a
  SHLD EAX,EDX,5
  SHLD EAX,ESI,6
  SHLD EAX,EBX,5
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  STOSW
  DEC ECX
@tg16_nooddpix1a:
  ROR ECX,1
  OR CX,CX
  JZ @tg16_noloopa
@tg16_loop1a:
  SHLD EAX,EDX,5
  SHLD EAX,ESI,6
  SHLD EAX,EBX,5
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  SHLD EAX,EDX,5
  SHLD EAX,ESI,6
  SHLD EAX,EBX,5
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  ROR EAX,16
  STOSD
  DEC CX
  JNZ @tg16_loop1a
@tg16_noloopa:
  SHL ECX,1
  JNC @tg16_nolinea
  SHLD EAX,EDX,5
  SHLD EAX,ESI,6
  SHLD EAX,EBX,5
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  STOSW
@tg16_nolinea:

  MOV EAX,xp1ai
  MOV EBX,xp1bi
  MOV ECX,bytperline
  ADD xp1,EAX
  ADD xp2,EBX
  ADD lineoffs,ECX

  MOV EAX,rd1a
  MOV EBX,gd1a
  MOV ECX,bd1a
  ADD r1,EAX
  ADD g1,EBX
  ADD b1,ECX

  POP ECX
  DEC ECX
  JNZ @tg16_loopt1
  JMP @tg16_nodraw1
{-- ELSE: skip 1st part ----}
@tg16_else1:
  MOV EBX,y2
  SUB EBX,y1
  INC EBX
  MOV EAX,xp1ai
  MUL EBX
  ADD xp1,EAX
  MOV EAX,xp1bi
  MUL EBX
  ADD xp2,EAX
  MOV EAX,rd1a
  MUL EBX
  ADD r1,EAX
  MOV EAX,gd1a
  MUL EBX
  ADD g1,EAX
  MOV EAX,bd1a
  MUL EBX
  ADD b1,EAX
@tg16_nodraw1:
{---------------------------}
  INC y2
{-- DRAW OR NOT TO DRAW 2nd }
  MOV EAX,vy1
  CMP EAX,y3
  JG @tg16_else2
  MOV EAX,vy2
  CMP EAX,y2
  JL @tg16_else2
{-- skip top of 2nd part ---}
  MOV EBX,vy1
  SUB EBX,y2
  JLE @tg16_noskip2t
  MOV EAX,xp2ai
  MUL EBX
  ADD xp1,EAX
  MOV EAX,xp2bi
  MUL EBX
  ADD xp2,EAX
  MOV EAX,rd2a
  MUL EBX
  ADD r1,EAX
  MOV EAX,gd2a
  MUL EBX
  ADD g1,EAX
  MOV EAX,bd2a
  MUL EBX
  ADD b1,EAX
  MOV EAX,vy1
  MOV y2,EAX
@tg16_noskip2t:
{-- IF y3>vy2 THEN y3:=vy2; }
  MOV EAX,vy2
  CMP EAX,y3
  JGE @tg16_weiter2t
  MOV y3,EAX
@tg16_weiter2t:
{-- lineoffs ---------------}
  MOV EAX,y2
  MUL bytperline
  ADD EAX,drawoffset
  ADD EAX,LFBoffs
  MOV lineoffs,EAX
{-- draw 2nd part ----------}
  MOV ECX,y3
  SUB ECX,y2
  JS @tg16_nodraw2
  INC ECX
 @tg16_loopt2:
  PUSH ECX

  MOVSX EDI,WORD PTR [xp1+2]
  MOVSX ECX,WORD PTR [xp2+2]
  SUB ECX,EDI
  JLE @tg16_nolineb
  INC ECX

  XOR EBX,EBX
  XOR ESI,ESI
  XOR EDX,EDX

  MOV EAX,vx1
  SUB EAX,EDI
  JLE @tg16_noleftclipb
  MOV EBX,bd
  MOV ESI,gd
  MOV EDX,rd
  IMUL EBX,EAX
  IMUL ESI,EAX
  IMUL EDX,EAX
  SUB ECX,EAX
  JLE @tg16_nolineb
  MOV EDI,vx1
@tg16_noleftclipb:
  MOV EAX,EDI
  ADD EAX,ECX
  SUB EAX,vx2
  JLE @tg16_norightclipb
  DEC EAX
  SUB ECX,EAX
  JLE @tg16_nolineb
@tg16_norightclipb:

  SHL EDI,1 {bytperpix}
  ADD EBX,b1
  ADD ESI,g1
  ADD EDX,r1
  ADD EDI,lineoffs

  TEST EDI,0003h
  JZ @tg16_nooddpix1b
  SHLD EAX,EDX,5
  SHLD EAX,ESI,6
  SHLD EAX,EBX,5
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  STOSW
  DEC ECX
@tg16_nooddpix1b:
  ROR ECX,1
  OR CX,CX
  JZ @tg16_noloopb
@tg16_loop1b:
  SHLD EAX,EDX,5
  SHLD EAX,ESI,6
  SHLD EAX,EBX,5
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  SHLD EAX,EDX,5
  SHLD EAX,ESI,6
  SHLD EAX,EBX,5
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  ROR EAX,16
  STOSD
  DEC CX
  JNZ @tg16_loop1b
@tg16_noloopb:
  SHL ECX,1
  JNC @tg16_nolineb
  SHLD EAX,EDX,5
  SHLD EAX,ESI,6
  SHLD EAX,EBX,5
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  STOSW
@tg16_nolineb:

  MOV EAX,xp2ai
  MOV EBX,xp2bi
  MOV ECX,bytperline
  ADD xp1,EAX
  ADD xp2,EBX
  ADD lineoffs,ECX

  MOV EAX,rd2a
  MOV EBX,gd2a
  MOV ECX,bd2a
  ADD r1,EAX
  ADD g1,EBX
  ADD b1,ECX

  POP ECX
  DEC ECX
  JNZ @tg16_loopt2
@tg16_nodraw2:
@tg16_else2:
END;

PROCEDURE triangle_gouraudL24(rend:prender);assembler;
VAR xp1,xp2,yp,xp1ai,xp1bi,xp2ai,xp2bi:longint;
    r,g,b,rd,gd,bd,
    r1,g1,b1,rd1a,gd1a,bd1a,rd1b,gd1b,bd1b,
    r2,g2,b2,rd2a,gd2a,bd2a,rd2b,gd2b,bd2b,
    r3,g3,b3:longint;
    lineoffs:dword;
    xd12,yd12,xd13,yd13,xd23,yd23,xdd1:longint;
    f3,f2,f1:longint;
    z3,y3,x3,z2,y2,x2,z1,y1,x1:longint; {=Trender}
ASM
{-- SWAP 1 / Y-sort --------}
  MOV EDI,rend
  MOV EAX,[EDI+04h]
  MOV EBX,[EDI+10h]
  MOV ECX,[EDI+1Ch]
  MOV EDX,0
  MOV EDI,4
  MOV ESI,8
  CMP EAX,EBX
  JL @tg24_noswap12
  XCHG EDX,EDI
  XCHG EAX,EBX
@tg24_noswap12:
  CMP EAX,ECX
  JL @tg24_noswap13
  XCHG EDX,ESI
  XCHG EAX,ECX
@tg24_noswap13:
  CMP EBX,ECX
  JL @tg24_noswap23
  XCHG EDI,ESI
  XCHG EBX,ECX
@tg24_noswap23:

  MOV ECX,rend

  MOV EAX,[ECX+EDX+24h]
  MOV f1,EAX
  LEA EDX,[EDX+EDX*2]
  MOV EAX,[ECX+EDX+00h]
  MOV x1,EAX
  MOV EAX,[ECX+EDX+04h]
  MOV y1,EAX

  MOV EAX,[ECX+EDI+24h]
  MOV f2,EAX
  LEA EDI,[EDI+EDI*2]
  MOV EAX,[ECX+EDI+00h]
  MOV x2,EAX
  MOV EAX,[ECX+EDI+04h]
  MOV y2,EAX

  MOV EAX,[ECX+ESI+24h]
  MOV f3,EAX
  LEA ESI,[ESI+ESI*2]
  MOV EAX,[ECX+ESI+00h]
  MOV x3,EAX
  MOV EAX,[ECX+ESI+04h]
  MOV y3,EAX

{-- x/y setup --------------}
  MOV EDX,x1
  MOV EBX,x2
  MOV EDI,x3
  MOV ECX,x3
  SUB EDI,EDX
  SUB ECX,EBX
  SUB EBX,EDX
  MOV xd13,EDI
  MOV xd23,ECX
  MOV xd12,EBX

  SHL EDX,16
  MOV xp1,EDX
  MOV xp2,EDX

  MOV EDX,y1
  MOV EBX,y2
  MOV EDI,y3
  MOV ECX,y3
  SUB EDI,EDX
  SUB ECX,EBX
  SUB EBX,EDX
  INC EDI
  INC ECX
  INC EBX
  MOV yd13,EDI
  MOV yd23,ECX
  MOV yd12,EBX
{-- x/y setup - x/y inc ----}
  MOV EAX,xd13
  SHL EAX,16
  CDQ
  IDIV EDI
  MOV xp1ai,EAX
  MOV xp2ai,EAX

  MOV EAX,xd12
  SHL EAX,16
  CDQ
  IDIV EBX
  MOV xp1bi,EAX

  MOV EAX,xd23
  SHL EAX,16
  CDQ
  IDIV ECX
  MOV xp2bi,EAX
{-- f# ==> r#/g#/b# --------}
  MOV EDX,00FF0000h
  MOV EAX,f1
  SHRD EBX,EAX,24
  SHRD ECX,EAX,16
  AND EAX,EDX
  AND EBX,EDX
  AND ECX,EDX
  MOV r1,EAX
  MOV g1,EBX
  MOV b1,ECX
  MOV EAX,f2
  SHRD EBX,EAX,24
  SHRD ECX,EAX,16
  AND EAX,EDX
  AND EBX,EDX
  AND ECX,EDX
  MOV r2,EAX
  MOV g2,EBX
  MOV b2,ECX
  MOV EAX,f3
  SHRD EBX,EAX,24
  SHRD ECX,EAX,16
  AND EAX,EDX
  AND EBX,EDX
  AND ECX,EDX
  MOV r3,EAX
  MOV g3,EBX
  MOV b3,ECX
{-- (Cx-Cy)/(Yx-Yy) --------}
  MOV ECX,yd13
  MOV EAX,b3
  SUB EAX,b1
  CDQ
  IDIV ECX
  MOV bd1a,EAX
  MOV bd2a,EAX
  MOV EAX,g3
  SUB EAX,g1
  CDQ
  IDIV ECX
  MOV gd1a,EAX
  MOV gd2a,EAX
  MOV EAX,r3
  SUB EAX,r1
  CDQ
  IDIV ECX
  MOV rd1a,EAX
  MOV rd2a,EAX

  MOV ECX,yd12
  MOV EAX,b2
  SUB EAX,b1
  CDQ
  IDIV ECX
  MOV bd1b,EAX
  MOV EAX,g2
  SUB EAX,g1
  CDQ
  IDIV ECX
  MOV gd1b,EAX
  MOV EAX,r2
  SUB EAX,r1
  CDQ
  IDIV ECX
  MOV rd1b,EAX

  MOV ECX,yd23
  MOV EAX,b3
  SUB EAX,b2
  CDQ
  IDIV ECX
  MOV bd2b,EAX
  MOV EAX,g3
  SUB EAX,g2
  CDQ
  IDIV ECX
  MOV gd2b,EAX
  MOV EAX,r3
  SUB EAX,r2
  CDQ
  IDIV ECX
  MOV rd2b,EAX
{-- SWAP 2 -----------------}
  MOV EAX,xd13
  IMUL yd12
  IDIV yd13
  MOV EDX,EAX

  MOV EAX,x1
  ADD EAX,EDX
  CMP EAX,x2
  JLE @tg24_noswap2
  MOV EAX,xp1ai
  MOV EBX,xp2ai
  XCHG EAX,xp1bi
  XCHG EBX,xp2bi
  MOV xp1ai,EAX
  MOV xp2ai,EBX
  MOV EAX,rd1a
  MOV EBX,gd1a
  MOV ECX,bd1a
  XCHG EAX,rd1b
  XCHG EBX,gd1b
  XCHG ECX,bd1b
  MOV rd1a,EAX
  MOV gd1a,EBX
  MOV bd1a,ECX
  MOV EAX,rd2a
  MOV EBX,gd2a
  MOV ECX,bd2a
  XCHG EAX,rd2b
  XCHG EBX,gd2b
  XCHG ECX,bd2b
  MOV rd2a,EAX
  MOV gd2a,EBX
  MOV bd2a,ECX
@tg24_noswap2:
{-- col X increase ---------}
  MOV EBX,yd12
  MOV ECX,xd12
  SUB ECX,EDX
  MOV EDX,ECX
  SAR EDX,31
  XOR ECX,EDX
  SUB ECX,EDX
  INC ECX
  MOV EAX,rd1b
  SUB EAX,rd1a
  IMUL EBX
  IDIV ECX
  SHL EAX,8
  MOV rd,EAX
  MOV EAX,gd1b
  SUB EAX,gd1a
  IMUL EBX
  IDIV ECX
  SHL EAX,8
  MOV gd,EAX
  MOV EAX,bd1b
  SUB EAX,bd1a
  IMUL EBX
  IDIV ECX
  SHL EAX,8
  MOV bd,EAX
{---------------------------}
  SHL r1,8
  SHL g1,8
  SHL b1,8
  SHL rd1a,8
  SHL gd1a,8
  SHL bd1a,8
  SHL rd2a,8
  SHL gd2a,8
  SHL bd2a,8
{-- DRAW OR NOT TO DRAW 1st }
  MOV EAX,vy1
  CMP EAX,y2
  JG @tg24_else1
  MOV EAX,vy2
  CMP EAX,y1
  JL @tg24_else1
{-- skip top of 1st part ---}
  MOV EBX,vy1
  SUB EBX,y1
  JLE @tg24_noskip1t
  MOV EAX,xp1ai
  MUL EBX
  ADD xp1,EAX
  MOV EAX,xp1bi
  MUL EBX
  ADD xp2,EAX
  MOV EAX,rd1a
  MUL EBX
  ADD r1,EAX
  MOV EAX,gd1a
  MUL EBX
  ADD g1,EAX
  MOV EAX,bd1a
  MUL EBX
  ADD b1,EAX
  MOV EAX,vy1
  MOV y1,EAX
@tg24_noskip1t:
{-- IF y2>vy2 THEN y2:=vy2; }
  MOV EAX,vy2
  CMP EAX,y2
  JGE @tg24_weiter1t
  MOV y2,EAX
@tg24_weiter1t:
{-- lineoffs ---------------}
  MOV EAX,y1
  MUL bytperline
  ADD EAX,drawoffset
  ADD EAX,LFBoffs
  MOV lineoffs,EAX
{-- draw 1st part ----------}
  MOV ECX,y2
  SUB ECX,y1
  JS @tg24_nodraw1
  INC ECX
@tg24_loopt1:
  PUSH ECX

  MOVSX EDI,WORD PTR [xp1+2]
  MOVSX ECX,WORD PTR [xp2+2]
  SUB ECX,EDI
  JLE @tg24_nolinea
  INC ECX

  XOR EBX,EBX
  XOR ESI,ESI
  XOR EDX,EDX

  MOV EAX,vx1
  SUB EAX,EDI
  JLE @tg24_noleftclipa
  MOV EBX,bd
  MOV ESI,gd
  MOV EDX,rd
  IMUL EBX,EAX
  IMUL ESI,EAX
  IMUL EDX,EAX
  SUB ECX,EAX
  JLE @tg24_nolinea
  MOV EDI,vx1
@tg24_noleftclipa:
  MOV EAX,EDI
  ADD EAX,ECX
  SUB EAX,vx2
  JLE @tg24_norightclipa
  DEC EAX
  SUB ECX,EAX
  JLE @tg24_nolinea
@tg24_norightclipa:

  LEA EDI,[EDI+EDI*2] {bytperpix}
  ADD EBX,b1
  ADD ESI,g1
  ADD EDX,r1
  ADD EDI,lineoffs

@tg24_loop1a:
  SHLD EAX,EDX,8
  SHLD EAX,ESI,8
  SHLD EAX,EBX,8
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  STOSW
  SHR EAX,16
  STOSB
  DEC ECX
  JNZ @tg24_loop1a
@tg24_nolinea:

  MOV EAX,xp1ai
  MOV EBX,xp1bi
  MOV ECX,bytperline
  ADD xp1,EAX
  ADD xp2,EBX
  ADD lineoffs,ECX

  MOV EAX,rd1a
  MOV EBX,gd1a
  MOV ECX,bd1a
  ADD r1,EAX
  ADD g1,EBX
  ADD b1,ECX

  POP ECX
  DEC ECX
  JNZ @tg24_loopt1
  JMP @tg24_nodraw1
{-- ELSE: skip 1st part ----}
@tg24_else1:
  MOV EBX,y2
  SUB EBX,y1
  INC EBX
  MOV EAX,xp1ai
  MUL EBX
  ADD xp1,EAX
  MOV EAX,xp1bi
  MUL EBX
  ADD xp2,EAX
  MOV EAX,rd1a
  MUL EBX
  ADD r1,EAX
  MOV EAX,gd1a
  MUL EBX
  ADD g1,EAX
  MOV EAX,bd1a
  MUL EBX
  ADD b1,EAX
@tg24_nodraw1:
{---------------------------}
  INC y2
{-- DRAW OR NOT TO DRAW 2nd }
  MOV EAX,vy1
  CMP EAX,y3
  JG @tg24_else2
  MOV EAX,vy2
  CMP EAX,y2
  JL @tg24_else2
{-- skip top of 2nd part ---}
  MOV EBX,vy1
  SUB EBX,y2
  JLE @tg24_noskip2t
  MOV EAX,xp2ai
  MUL EBX
  ADD xp1,EAX
  MOV EAX,xp2bi
  MUL EBX
  ADD xp2,EAX
  MOV EAX,rd2a
  MUL EBX
  ADD r1,EAX
  MOV EAX,gd2a
  MUL EBX
  ADD g1,EAX
  MOV EAX,bd2a
  MUL EBX
  ADD b1,EAX
  MOV EAX,vy1
  MOV y2,EAX
@tg24_noskip2t:
{-- IF y3>vy2 THEN y3:=vy2; }
  MOV EAX,vy2
  CMP EAX,y3
  JGE @tg24_weiter2t
  MOV y3,EAX
@tg24_weiter2t:
{-- lineoffs ---------------}
  MOV EAX,y2
  MUL bytperline
  ADD EAX,drawoffset
  ADD EAX,LFBoffs
  MOV lineoffs,EAX
{-- draw 2nd part ----------}
  MOV ECX,y3
  SUB ECX,y2
  JS @tg24_nodraw2
  INC ECX
 @tg24_loopt2:
  PUSH ECX

  MOVSX EDI,WORD PTR [xp1+2]
  MOVSX ECX,WORD PTR [xp2+2]
  SUB ECX,EDI
  JLE @tg24_nolineb
  INC ECX

  XOR EBX,EBX
  XOR ESI,ESI
  XOR EDX,EDX

  MOV EAX,vx1
  SUB EAX,EDI
  JLE @tg24_noleftclipb
  MOV EBX,bd
  MOV ESI,gd
  MOV EDX,rd
  IMUL EBX,EAX
  IMUL ESI,EAX
  IMUL EDX,EAX
  SUB ECX,EAX
  JLE @tg24_nolineb
  MOV EDI,vx1
@tg24_noleftclipb:
  MOV EAX,EDI
  ADD EAX,ECX
  SUB EAX,vx2
  JLE @tg24_norightclipb
  DEC EAX
  SUB ECX,EAX
  JLE @tg24_nolineb
@tg24_norightclipb:

  LEA EDI,[EDI+EDI*2] {bytperpix}
  ADD EBX,b1
  ADD ESI,g1
  ADD EDX,r1
  ADD EDI,lineoffs

@tg24_loop1b:
  SHLD EAX,EDX,8
  SHLD EAX,ESI,8
  SHLD EAX,EBX,8
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  STOSW
  SHR EAX,16
  STOSB
  DEC ECX
  JNZ @tg24_loop1b
@tg24_nolineb:

  MOV EAX,xp2ai
  MOV EBX,xp2bi
  MOV ECX,bytperline
  ADD xp1,EAX
  ADD xp2,EBX
  ADD lineoffs,ECX

  MOV EAX,rd2a
  MOV EBX,gd2a
  MOV ECX,bd2a
  ADD r1,EAX
  ADD g1,EBX
  ADD b1,ECX

  POP ECX
  DEC ECX
  JNZ @tg24_loopt2
@tg24_nodraw2:
@tg24_else2:
END;

PROCEDURE triangle_gouraudL32(rend:prender);assembler;
VAR xp1,xp2,yp,xp1ai,xp1bi,xp2ai,xp2bi:longint;
    r,g,b,rd,gd,bd,
    r1,g1,b1,rd1a,gd1a,bd1a,rd1b,gd1b,bd1b,
    r2,g2,b2,rd2a,gd2a,bd2a,rd2b,gd2b,bd2b,
    r3,g3,b3:longint;
    lineoffs:dword;
    xd12,yd12,xd13,yd13,xd23,yd23,xdd1:longint;
    f3,f2,f1:longint;
    z3,y3,x3,z2,y2,x2,z1,y1,x1:longint; {=Trender}
ASM
{-- SWAP 1 / Y-sort --------}
  MOV EDI,rend
  MOV EAX,[EDI+04h]
  MOV EBX,[EDI+10h]
  MOV ECX,[EDI+1Ch]
  MOV EDX,0
  MOV EDI,4
  MOV ESI,8
  CMP EAX,EBX
  JL @tg32_noswap12
  XCHG EDX,EDI
  XCHG EAX,EBX
@tg32_noswap12:
  CMP EAX,ECX
  JL @tg32_noswap13
  XCHG EDX,ESI
  XCHG EAX,ECX
@tg32_noswap13:
  CMP EBX,ECX
  JL @tg32_noswap23
  XCHG EDI,ESI
  XCHG EBX,ECX
@tg32_noswap23:

  MOV ECX,rend

  MOV EAX,[ECX+EDX+24h]
  MOV f1,EAX
  LEA EDX,[EDX+EDX*2]
  MOV EAX,[ECX+EDX+00h]
  MOV x1,EAX
  MOV EAX,[ECX+EDX+04h]
  MOV y1,EAX

  MOV EAX,[ECX+EDI+24h]
  MOV f2,EAX
  LEA EDI,[EDI+EDI*2]
  MOV EAX,[ECX+EDI+00h]
  MOV x2,EAX
  MOV EAX,[ECX+EDI+04h]
  MOV y2,EAX

  MOV EAX,[ECX+ESI+24h]
  MOV f3,EAX
  LEA ESI,[ESI+ESI*2]
  MOV EAX,[ECX+ESI+00h]
  MOV x3,EAX
  MOV EAX,[ECX+ESI+04h]
  MOV y3,EAX

{-- x/y setup --------------}
  MOV EDX,x1
  MOV EBX,x2
  MOV EDI,x3
  MOV ECX,x3
  SUB EDI,EDX
  SUB ECX,EBX
  SUB EBX,EDX
  MOV xd13,EDI
  MOV xd23,ECX
  MOV xd12,EBX

  SHL EDX,16
  MOV xp1,EDX
  MOV xp2,EDX

  MOV EDX,y1
  MOV EBX,y2
  MOV EDI,y3
  MOV ECX,y3
  SUB EDI,EDX
  SUB ECX,EBX
  SUB EBX,EDX
  INC EDI
  INC ECX
  INC EBX
  MOV yd13,EDI
  MOV yd23,ECX
  MOV yd12,EBX
{-- x/y setup - x/y inc ----}
  MOV EAX,xd13
  SHL EAX,16
  CDQ
  IDIV EDI
  MOV xp1ai,EAX
  MOV xp2ai,EAX

  MOV EAX,xd12
  SHL EAX,16
  CDQ
  IDIV EBX
  MOV xp1bi,EAX

  MOV EAX,xd23
  SHL EAX,16
  CDQ
  IDIV ECX
  MOV xp2bi,EAX
{-- f# ==> r#/g#/b# --------}
  MOV EDX,00FF0000h
  MOV EAX,f1
  SHRD EBX,EAX,24
  SHRD ECX,EAX,16
  AND EAX,EDX
  AND EBX,EDX
  AND ECX,EDX
  MOV r1,EAX
  MOV g1,EBX
  MOV b1,ECX
  MOV EAX,f2
  SHRD EBX,EAX,24
  SHRD ECX,EAX,16
  AND EAX,EDX
  AND EBX,EDX
  AND ECX,EDX
  MOV r2,EAX
  MOV g2,EBX
  MOV b2,ECX
  MOV EAX,f3
  SHRD EBX,EAX,24
  SHRD ECX,EAX,16
  AND EAX,EDX
  AND EBX,EDX
  AND ECX,EDX
  MOV r3,EAX
  MOV g3,EBX
  MOV b3,ECX
{-- (Cx-Cy)/(Yx-Yy) --------}
  MOV ECX,yd13
  MOV EAX,b3
  SUB EAX,b1
  CDQ
  IDIV ECX
  MOV bd1a,EAX
  MOV bd2a,EAX
  MOV EAX,g3
  SUB EAX,g1
  CDQ
  IDIV ECX
  MOV gd1a,EAX
  MOV gd2a,EAX
  MOV EAX,r3
  SUB EAX,r1
  CDQ
  IDIV ECX
  MOV rd1a,EAX
  MOV rd2a,EAX

  MOV ECX,yd12
  MOV EAX,b2
  SUB EAX,b1
  CDQ
  IDIV ECX
  MOV bd1b,EAX
  MOV EAX,g2
  SUB EAX,g1
  CDQ
  IDIV ECX
  MOV gd1b,EAX
  MOV EAX,r2
  SUB EAX,r1
  CDQ
  IDIV ECX
  MOV rd1b,EAX

  MOV ECX,yd23
  MOV EAX,b3
  SUB EAX,b2
  CDQ
  IDIV ECX
  MOV bd2b,EAX
  MOV EAX,g3
  SUB EAX,g2
  CDQ
  IDIV ECX
  MOV gd2b,EAX
  MOV EAX,r3
  SUB EAX,r2
  CDQ
  IDIV ECX
  MOV rd2b,EAX
{-- SWAP 2 -----------------}
  MOV EAX,xd13
  IMUL yd12
  IDIV yd13
  MOV EDX,EAX

  MOV EAX,x1
  ADD EAX,EDX
  CMP EAX,x2
  JLE @tg32_noswap2
  MOV EAX,xp1ai
  MOV EBX,xp2ai
  XCHG EAX,xp1bi
  XCHG EBX,xp2bi
  MOV xp1ai,EAX
  MOV xp2ai,EBX
  MOV EAX,rd1a
  MOV EBX,gd1a
  MOV ECX,bd1a
  XCHG EAX,rd1b
  XCHG EBX,gd1b
  XCHG ECX,bd1b
  MOV rd1a,EAX
  MOV gd1a,EBX
  MOV bd1a,ECX
  MOV EAX,rd2a
  MOV EBX,gd2a
  MOV ECX,bd2a
  XCHG EAX,rd2b
  XCHG EBX,gd2b
  XCHG ECX,bd2b
  MOV rd2a,EAX
  MOV gd2a,EBX
  MOV bd2a,ECX
@tg32_noswap2:
{-- col X increase ---------}
  MOV EBX,yd12
  MOV ECX,xd12
  SUB ECX,EDX
  MOV EDX,ECX
  SAR EDX,31
  XOR ECX,EDX
  SUB ECX,EDX
  INC ECX
  MOV EAX,rd1b
  SUB EAX,rd1a
  IMUL EBX
  IDIV ECX
  SHL EAX,8
  MOV rd,EAX
  MOV EAX,gd1b
  SUB EAX,gd1a
  IMUL EBX
  IDIV ECX
  SHL EAX,8
  MOV gd,EAX
  MOV EAX,bd1b
  SUB EAX,bd1a
  IMUL EBX
  IDIV ECX
  SHL EAX,8
  MOV bd,EAX
{---------------------------}
  SHL r1,8
  SHL g1,8
  SHL b1,8
  SHL rd1a,8
  SHL gd1a,8
  SHL bd1a,8
  SHL rd2a,8
  SHL gd2a,8
  SHL bd2a,8
{-- DRAW OR NOT TO DRAW 1st }
  MOV EAX,vy1
  CMP EAX,y2
  JG @tg32_else1
  MOV EAX,vy2
  CMP EAX,y1
  JL @tg32_else1
{-- skip top of 1st part ---}
  MOV EBX,vy1
  SUB EBX,y1
  JLE @tg32_noskip1t
  MOV EAX,xp1ai
  MUL EBX
  ADD xp1,EAX
  MOV EAX,xp1bi
  MUL EBX
  ADD xp2,EAX
  MOV EAX,rd1a
  MUL EBX
  ADD r1,EAX
  MOV EAX,gd1a
  MUL EBX
  ADD g1,EAX
  MOV EAX,bd1a
  MUL EBX
  ADD b1,EAX
  MOV EAX,vy1
  MOV y1,EAX
@tg32_noskip1t:
{-- IF y2>vy2 THEN y2:=vy2; }
  MOV EAX,vy2
  CMP EAX,y2
  JGE @tg32_weiter1t
  MOV y2,EAX
@tg32_weiter1t:
{-- lineoffs ---------------}
  MOV EAX,y1
  MUL bytperline
  ADD EAX,drawoffset
  ADD EAX,LFBoffs
  MOV lineoffs,EAX
{-- draw 1st part ----------}
  MOV ECX,y2
  SUB ECX,y1
  JS @tg32_nodraw1
  INC ECX
@tg32_loopt1:
  PUSH ECX

  MOVSX EDI,WORD PTR [xp1+2]
  MOVSX ECX,WORD PTR [xp2+2]
  SUB ECX,EDI
  JLE @tg32_nolinea
  INC ECX

  XOR EBX,EBX
  XOR ESI,ESI
  XOR EDX,EDX

  MOV EAX,vx1
  SUB EAX,EDI
  JLE @tg32_noleftclipa
  MOV EBX,bd
  MOV ESI,gd
  MOV EDX,rd
  IMUL EBX,EAX
  IMUL ESI,EAX
  IMUL EDX,EAX
  SUB ECX,EAX
  JLE @tg32_nolinea
  MOV EDI,vx1
@tg32_noleftclipa:
  MOV EAX,EDI
  ADD EAX,ECX
  SUB EAX,vx2
  JLE @tg32_norightclipa
  DEC EAX
  SUB ECX,EAX
  JLE @tg32_nolinea
@tg32_norightclipa:

  SHL EDI,2 {bytperpix}
  ADD EBX,b1
  ADD ESI,g1
  ADD EDX,r1
  ADD EDI,lineoffs

@tg32_loop1a:
  SHLD EAX,EDX,8
  SHLD EAX,ESI,8
  SHLD EAX,EBX,8
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  STOSD
  DEC ECX
  JNZ @tg32_loop1a
@tg32_nolinea:

  MOV EAX,xp1ai
  MOV EBX,xp1bi
  MOV ECX,bytperline
  ADD xp1,EAX
  ADD xp2,EBX
  ADD lineoffs,ECX

  MOV EAX,rd1a
  MOV EBX,gd1a
  MOV ECX,bd1a
  ADD r1,EAX
  ADD g1,EBX
  ADD b1,ECX

  POP ECX
  DEC ECX
  JNZ @tg32_loopt1
  JMP @tg32_nodraw1
{-- ELSE: skip 1st part ----}
@tg32_else1:
  MOV EBX,y2
  SUB EBX,y1
  INC EBX
  MOV EAX,xp1ai
  MUL EBX
  ADD xp1,EAX
  MOV EAX,xp1bi
  MUL EBX
  ADD xp2,EAX
  MOV EAX,rd1a
  MUL EBX
  ADD r1,EAX
  MOV EAX,gd1a
  MUL EBX
  ADD g1,EAX
  MOV EAX,bd1a
  MUL EBX
  ADD b1,EAX
@tg32_nodraw1:
{---------------------------}
  INC y2
{-- DRAW OR NOT TO DRAW 2nd }
  MOV EAX,vy1
  CMP EAX,y3
  JG @tg32_else2
  MOV EAX,vy2
  CMP EAX,y2
  JL @tg32_else2
{-- skip top of 2nd part ---}
  MOV EBX,vy1
  SUB EBX,y2
  JLE @tg32_noskip2t
  MOV EAX,xp2ai
  MUL EBX
  ADD xp1,EAX
  MOV EAX,xp2bi
  MUL EBX
  ADD xp2,EAX
  MOV EAX,rd2a
  MUL EBX
  ADD r1,EAX
  MOV EAX,gd2a
  MUL EBX
  ADD g1,EAX
  MOV EAX,bd2a
  MUL EBX
  ADD b1,EAX
  MOV EAX,vy1
  MOV y2,EAX
@tg32_noskip2t:
{-- IF y3>vy2 THEN y3:=vy2; }
  MOV EAX,vy2
  CMP EAX,y3
  JGE @tg32_weiter2t
  MOV y3,EAX
@tg32_weiter2t:
{-- lineoffs ---------------}
  MOV EAX,y2
  MUL bytperline
  ADD EAX,drawoffset
  ADD EAX,LFBoffs
  MOV lineoffs,EAX
{-- draw 2nd part ----------}
  MOV ECX,y3
  SUB ECX,y2
  JS @tg32_nodraw2
  INC ECX
 @tg32_loopt2:
  PUSH ECX

  MOVSX EDI,WORD PTR [xp1+2]
  MOVSX ECX,WORD PTR [xp2+2]
  SUB ECX,EDI
  JLE @tg32_nolineb
  INC ECX

  XOR EBX,EBX
  XOR ESI,ESI
  XOR EDX,EDX

  MOV EAX,vx1
  SUB EAX,EDI
  JLE @tg32_noleftclipb
  MOV EBX,bd
  MOV ESI,gd
  MOV EDX,rd
  IMUL EBX,EAX
  IMUL ESI,EAX
  IMUL EDX,EAX
  SUB ECX,EAX
  JLE @tg32_nolineb
  MOV EDI,vx1
@tg32_noleftclipb:
  MOV EAX,EDI
  ADD EAX,ECX
  SUB EAX,vx2
  JLE @tg32_norightclipb
  DEC EAX
  SUB ECX,EAX
  JLE @tg32_nolineb
@tg32_norightclipb:

  SHL EDI,2 {bytperpix}
  ADD EBX,b1
  ADD ESI,g1
  ADD EDX,r1
  ADD EDI,lineoffs

@tg32_loop1b:
  SHLD EAX,EDX,8
  SHLD EAX,ESI,8
  SHLD EAX,EBX,8
  ADD EDX,rd
  ADD ESI,gd
  ADD EBX,bd
  STOSD
  DEC ECX
  JNZ @tg32_loop1b
@tg32_nolineb:

  MOV EAX,xp2ai
  MOV EBX,xp2bi
  MOV ECX,bytperline
  ADD xp1,EAX
  ADD xp2,EBX
  ADD lineoffs,ECX

  MOV EAX,rd2a
  MOV EBX,gd2a
  MOV ECX,bd2a
  ADD r1,EAX
  ADD g1,EBX
  ADD b1,ECX

  POP ECX
  DEC ECX
  JNZ @tg32_loopt2
@tg32_nodraw2:
@tg32_else2:
END;

PROCEDURE triangle_gouraudLM32(rend:prender);assembler;
TYPE TXY=RECORD x,y:longint; END;
     TGB=RECORD b,g:longint; END;
     TXR=RECORD r,x:longint; END;
{CONST mask_FF00FF00FF00FF00:int64=$FF00FF00FF00FF00;}
CONST mask_FF00FF00FF00FF00:array[0..1] of longint=($FF00FF00,$FF00FF00);
VAR xp1,xp2,yp,xp1ai,xp1bi,xp2ai,xp2bi:longint;

    GBd:TGB;
    XRd:TXR;
    GB1,GB2,GB3:TGB;
    XR1,XR2,XR3:TXR;
    GBd1a,GBd1b,GBd2a,GBd2b:TGB;
    XRd1a,XRd1b,XRd2a,XRd2b:TXR;
    p1,p2,p3:TXY;
    d12,d13,d23:TXY;


    lineoffs:dword;
  {  d12.x,d12.y,d13.x,d13.y,d23.x,d23.y,}  {xdd1:longint;}
    f3,f2,f1:longint;
  {  z3,p3.y,p3.x,z2,p2.y,p2.x,z1,p1.y,p1.x:longint;} {=Trender}

{    a1,a2,a3:longint; }

ASM
{-- SWAP 1 / Y-sort --------}
  MOV EDI,rend
  MOV EAX,[EDI+04h]
  MOV EBX,[EDI+10h]
  MOV ECX,[EDI+1Ch]
  MOV EDX,0
  MOV EDI,4
  MOV ESI,8
  CMP EAX,EBX
  JL @tgm32_noswap12
  XCHG EDX,EDI
  XCHG EAX,EBX
@tgm32_noswap12:
  CMP EAX,ECX
  JL @tgm32_noswap13
  XCHG EDX,ESI
  XCHG EAX,ECX
@tgm32_noswap13:
  CMP EBX,ECX
  JL @tgm32_noswap23
  XCHG EDI,ESI
  XCHG EBX,ECX
@tgm32_noswap23:

  MOV ECX,rend

  MOV EAX,[ECX+EDX+24h]
  MOV f1,EAX
  LEA EDX,[EDX+EDX*2]
  MOVQ MM0,[ECX+EDX+00h]
  MOVQ p1,MM0

  MOV EAX,[ECX+EDI+24h]
  MOV f2,EAX
  LEA EDI,[EDI+EDI*2]
  MOVQ MM0,[ECX+EDI+00h]
  MOVQ p2,MM0

  MOV EAX,[ECX+ESI+24h]
  MOV f3,EAX
  LEA ESI,[ESI+ESI*2]
  MOVQ MM0,[ECX+ESI+00h]
  MOVQ p3,MM0

{-- x/y setup --------------}
  MOV EDX,p1.x
  MOV EBX,p2.x
  MOV EDI,p3.x
  MOV ECX,p3.x
  SUB EDI,EDX
  SUB ECX,EBX
  SUB EBX,EDX
  MOV d13.x,EDI
  MOV d23.x,ECX
  MOV d12.x,EBX

  SHL EDX,16
  MOV xp1,EDX
  MOV xp2,EDX

  MOV EDX,p1.y
  MOV EBX,p2.y
  MOV EDI,p3.y
  MOV ECX,p3.y
  SUB EDI,EDX
  SUB ECX,EBX
  SUB EBX,EDX
  INC EDI
  INC ECX
  INC EBX
  MOV d13.y,EDI
  MOV d23.y,ECX
  MOV d12.y,EBX
{-- x/y setup - x/y inc ----}
  MOV EAX,d13.x
  SHL EAX,16
  CDQ
  IDIV EDI
  MOV xp1ai,EAX
  MOV xp2ai,EAX

  MOV EAX,d12.x
  SHL EAX,16
  CDQ
  IDIV EBX
  MOV xp1bi,EAX

  MOV EAX,d23.x
  SHL EAX,16
  CDQ
  IDIV ECX
  MOV xp2bi,EAX
{-- f# ==> r#/g#/b# --------}
  PXOR MM1,MM1
  PXOR MM2,MM2
  MOV EAX,f1
  MOVD MM0,EAX
  PUNPCKLBW MM0,MM1
  PUNPCKLWD MM1,MM0
  PUNPCKHWD MM2,MM0
  MOVQ GB1,MM1
  MOVQ XR1,MM2
  PXOR MM1,MM1
  PXOR MM2,MM2
  MOV EAX,f2
  MOVD MM0,EAX
  PUNPCKLBW MM0,MM1
  PUNPCKLWD MM1,MM0
  PUNPCKHWD MM2,MM0
  MOVQ GB2,MM1
  MOVQ XR2,MM2
  PXOR MM1,MM1
  PXOR MM2,MM2
  MOV EAX,f3
  MOVD MM0,EAX
  PUNPCKLBW MM0,MM1
  PUNPCKLWD MM1,MM0
  PUNPCKHWD MM2,MM0
  MOVQ GB3,MM1
  MOVQ XR3,MM2
{-- (Cx-Cy)/(Yx-Yy) --------}
  MOV ECX,d13.y
  MOV EAX,GB3.b
  SUB EAX,GB1.b
  CDQ
  IDIV ECX
  MOV GBd1a.b,EAX
  MOV GBd2a.b,EAX
  MOV EAX,GB3.g
  SUB EAX,GB1.g
  CDQ
  IDIV ECX
  MOV GBd1a.g,EAX
  MOV GBd2a.g,EAX
  MOV EAX,XR3.r
  SUB EAX,XR1.r
  CDQ
  IDIV ECX
  MOV XRd1a.r,EAX
  MOV XRd2a.r,EAX

  MOV ECX,d12.y
  MOV EAX,GB2.b
  SUB EAX,GB1.b
  CDQ
  IDIV ECX
  MOV GBd1b.b,EAX
  MOV EAX,GB2.g
  SUB EAX,GB1.g
  CDQ
  IDIV ECX
  MOV GBd1b.g,EAX
  MOV EAX,XR2.r
  SUB EAX,XR1.r
  CDQ
  IDIV ECX
  MOV XRd1b.r,EAX

  MOV ECX,d23.y
  MOV EAX,GB3.b
  SUB EAX,GB2.b
  CDQ
  IDIV ECX
  MOV GBd2b.b,EAX
  MOV EAX,GB3.g
  SUB EAX,GB2.g
  CDQ
  IDIV ECX
  MOV GBd2b.g,EAX
  MOV EAX,XR3.r
  SUB EAX,XR2.r
  CDQ
  IDIV ECX
  MOV XRd2b.r,EAX
{-- SWAP 2 -----------------}
  MOV EAX,d13.x
  IMUL d12.y
  IDIV d13.y
  MOV EDX,EAX

  MOV EAX,p1.x
  ADD EAX,EDX
  CMP EAX,p2.x
  JLE @tgm32_noswap2
  MOV EAX,xp1ai
  MOV EBX,xp2ai
  XCHG EAX,xp1bi
  XCHG EBX,xp2bi
  MOV xp1ai,EAX
  MOV xp2ai,EBX
  MOVQ MM0,GBd1a
  MOVQ MM1,XRd1a
  MOVQ MM2,GBd1b
  MOVQ MM3,XRd1b
  MOVQ GBd1b,MM0
  MOVQ XRd1b,MM1
  MOVQ GBd1a,MM2
  MOVQ XRd1a,MM3
  MOVQ MM0,GBd2a
  MOVQ MM1,XRd2a
  MOVQ MM2,GBd2b
  MOVQ MM3,XRd2b
  MOVQ GBd2b,MM0
  MOVQ XRd2b,MM1
  MOVQ GBd2a,MM2
  MOVQ XRd2a,MM3
@tgm32_noswap2:
{-- col X increase ---------}
  MOV EBX,d12.y
  MOV ECX,d12.x
  SUB ECX,EDX
  MOV EDX,ECX
  SAR EDX,31
  XOR ECX,EDX
  SUB ECX,EDX
  INC ECX
  MOV EAX,XRd1b.r
  SUB EAX,XRd1a.r
  IMUL EBX
  IDIV ECX
  MOV XRd.r,EAX
  MOV EAX,GBd1b.g
  SUB EAX,GBd1a.g
  IMUL EBX
  IDIV ECX
  MOV GBd.g,EAX
  MOV EAX,GBd1b.b
  SUB EAX,GBd1a.b
  IMUL EBX
  IDIV ECX
  MOV GBd.b,EAX
{-- DRAW OR NOT TO DRAW 1st }
  MOV EAX,vy1
  CMP EAX,p2.y
  JG @tgm32_else1
  MOV EAX,vy2
  CMP EAX,p1.y
  JL @tgm32_else1
{-- skip top of 1st part ---}
  MOV EBX,vy1
  SUB EBX,p1.y
  JLE @tgm32_noskip1t
  MOV EAX,xp1ai
  MUL EBX
  ADD xp1,EAX
  MOV EAX,xp1bi
  MUL EBX
  ADD xp2,EAX
  MOV EAX,XRd1a.r
  MUL EBX
  ADD XR1.r,EAX
  MOV EAX,GBd1a.g
  MUL EBX
  ADD GB1.g,EAX
  MOV EAX,GBd1a.b
  MUL EBX
  ADD GB1.b,EAX
  MOV EAX,vy1
  MOV p1.y,EAX
@tgm32_noskip1t:
{-- IF p2.y>vy2 THEN p2.y:=vy2; }
  MOV EAX,vy2
  CMP EAX,p2.y
  JGE @tgm32_weiter1t
  MOV p2.y,EAX
@tgm32_weiter1t:
{-- lineoffs ---------------}
  MOV EAX,p1.y
  MUL bytperline
  ADD EAX,drawoffset
  ADD EAX,LFBoffs
  MOV lineoffs,EAX
{-- draw 1st part ----------}
  MOV ECX,p2.y
  SUB ECX,p1.y
  JS @tgm32_nodraw1
  INC ECX

  MOVQ MM2,GBd
  MOVQ MM3,XRd
  MOVQ MM4,GB1
  MOVQ MM5,XR1

@tgm32_loopt1:
  PUSH ECX

  MOVSX EDI,WORD PTR [xp1+2]
  MOVSX ECX,WORD PTR [xp2+2]
  SUB ECX,EDI
  JLE @tgm32_nolinea
  INC ECX

  MOVQ MM0,MM4
  MOVQ MM1,MM5

  MOV EAX,vx1
  SUB EAX,EDI
  JLE @tgm32_noleftclipa
  MOV EBX,GBd.b
  MOV ESI,GBd.g
  MOV EDX,XRd.r
  IMUL EBX,EAX
  IMUL ESI,EAX
  IMUL EDX,EAX
  MOVD MM0,EBX
  MOVD MM1,ESI
  PUNPCKLDQ MM0,MM1
  MOVD MM1,EDX
  PADDD MM0,MM4
  PADDD MM1,MM5
  SUB ECX,EAX
  JLE @tgm32_nolinea
  MOV EDI,vx1
@tgm32_noleftclipa:
  MOV EAX,EDI
  ADD EAX,ECX
  SUB EAX,vx2
  JLE @tgm32_norightclipa
  DEC EAX
  SUB ECX,EAX
  JLE @tgm32_nolinea
@tgm32_norightclipa:

  SHL EDI,2 {bytperpix}
  ADD EDI,lineoffs

  TEST EDI,0007h
  JZ @tgm32_nooddpix1a
  MOVQ MM6,MM0
  PACKUSWB MM6,MM1
  PSRLW MM6,8
  PACKUSWB MM6,MM1
  MOVD DWORD PTR [EDI],MM6
  PADDD MM0,MM2
  PADDD MM1,MM3
  ADD EDI,4
  DEC ECX
@tgm32_nooddpix1a:
  ROR ECX,1
  OR CX,CX
  JZ @tgm32_noloopa
@tgm32_loop1a:
  MOVQ MM6,MM0
  PACKUSWB MM6,MM1
  PADDD MM0,MM2
  PADDD MM1,MM3
  MOVQ MM7,MM0
  PACKUSWB MM7,MM1
  PSRLW MM6,8
  PSRLW MM7,8
  PACKUSWB MM6,MM7
  PADDD MM0,MM2
  MOVQ [EDI],MM6
  PADDD MM1,MM3
  ADD EDI,8
  DEC CX
  JNZ @tgm32_loop1a
@tgm32_noloopa:
  SHL ECX,1
  JNC @tgm32_nolinea
  MOVQ MM6,MM0
  PACKUSWB MM6,MM1
  PSRLW MM6,8
  PACKUSWB MM6,MM1
  MOVD DWORD PTR [EDI],MM6
  PADDD MM0,MM2
  PADDD MM1,MM3
  ADD EDI,4
@tgm32_nolinea:

  MOV EAX,xp1ai
  MOV EBX,xp1bi
  MOV ECX,bytperline
  ADD xp1,EAX
  ADD xp2,EBX
  ADD lineoffs,ECX

  PADDD MM4,GBd1a
  PADDD MM5,XRd1a

  POP ECX
  DEC ECX
  JNZ @tgm32_loopt1

  MOVQ GB1,MM4
  MOVQ XR1,MM5

  JMP @tgm32_nodraw1
{-- ELSE: skip 1st part ----}
@tgm32_else1:
  MOV EBX,p2.y
  SUB EBX,p1.y
  INC EBX
  MOV EAX,xp1ai
  MUL EBX
  ADD xp1,EAX
  MOV EAX,xp1bi
  MUL EBX
  ADD xp2,EAX
  MOV EAX,XRd1a.r
  MUL EBX
  ADD XR1.r,EAX
  MOV EAX,GBd1a.g
  MUL EBX
  ADD GB1.g,EAX
  MOV EAX,GBd1a.b
  MUL EBX
  ADD GB1.b,EAX
@tgm32_nodraw1:
{---------------------------}
  INC p2.y
{-- DRAW OR NOT TO DRAW 2nd }
  MOV EAX,vy1
  CMP EAX,p3.y
  JG @tgm32_else2
  MOV EAX,vy2
  CMP EAX,p2.y
  JL @tgm32_else2
{-- skip top of 2nd part ---}
  MOV EBX,vy1
  SUB EBX,p2.y
  JLE @tgm32_noskip2t
  MOV EAX,xp2ai
  MUL EBX
  ADD xp1,EAX
  MOV EAX,xp2bi
  MUL EBX
  ADD xp2,EAX
  MOV EAX,XRd2a.r
  MUL EBX
  ADD XR1.r,EAX
  MOV EAX,GBd2a.g
  MUL EBX
  ADD GB1.g,EAX
  MOV EAX,GBd2a.b
  MUL EBX
  ADD GB1.b,EAX
  MOV EAX,vy1
  MOV p2.y,EAX
@tgm32_noskip2t:
{-- IF p3.y>vy2 THEN p3.y:=vy2; }
  MOV EAX,vy2
  CMP EAX,p3.y
  JGE @tgm32_weiter2t
  MOV p3.y,EAX
@tgm32_weiter2t:
{-- lineoffs ---------------}
  MOV EAX,p2.y
  MUL bytperline
  ADD EAX,drawoffset
  ADD EAX,LFBoffs
  MOV lineoffs,EAX
{-- draw 2nd part ----------}
  MOV ECX,p3.y
  SUB ECX,p2.y
  JS @tgm32_nodraw2
  INC ECX

  MOVQ MM2,GBd
  MOVQ MM3,XRd
  MOVQ MM4,GB1
  MOVQ MM5,XR1

 @tgm32_loopt2:
  PUSH ECX

  MOVSX EDI,WORD PTR [xp1+2]
  MOVSX ECX,WORD PTR [xp2+2]
  SUB ECX,EDI
  JLE @tgm32_nolineb
  INC ECX

  MOVQ MM0,MM4
  MOVQ MM1,MM5

  MOV EAX,vx1
  SUB EAX,EDI
  JLE @tgm32_noleftclipb
  MOV EBX,GBd.b
  MOV ESI,GBd.g
  MOV EDX,XRd.r
  IMUL EBX,EAX
  IMUL ESI,EAX
  IMUL EDX,EAX
  MOVD MM0,EBX
  MOVD MM1,ESI
  PUNPCKLDQ MM0,MM1
  MOVD MM1,EDX
  PADDD MM0,MM4
  PADDD MM1,MM5
  SUB ECX,EAX
  JLE @tgm32_nolineb
  MOV EDI,vx1
@tgm32_noleftclipb:
  MOV EAX,EDI
  ADD EAX,ECX
  SUB EAX,vx2
  JLE @tgm32_norightclipb
  DEC EAX
  SUB ECX,EAX
  JLE @tgm32_nolineb
@tgm32_norightclipb:

  SHL EDI,2 {bytperpix}
  ADD EDI,lineoffs

  TEST EDI,0007h
  JZ @tgm32_nooddpix1b
  MOVQ MM6,MM0
  PACKUSWB MM6,MM1
  PSRLW MM6,8
  PACKUSWB MM6,MM1
  MOVD DWORD PTR [EDI],MM6
  PADDD MM0,MM2
  PADDD MM1,MM3
  ADD EDI,4
  DEC ECX
@tgm32_nooddpix1b:
  ROR ECX,1
  OR CX,CX
  JZ @tgm32_noloopb
@tgm32_loop1b:
  MOVQ MM6,MM0
  PACKUSWB MM6,MM1
  PADDD MM0,MM2
  PADDD MM1,MM3
  MOVQ MM7,MM0
  PACKUSWB MM7,MM1
  PSRLW MM6,8
  PSRLW MM7,8
  PACKUSWB MM6,MM7
  PADDD MM0,MM2
  MOVQ [EDI],MM6
  PADDD MM1,MM3
  ADD EDI,8
  DEC CX
  JNZ @tgm32_loop1b
@tgm32_noloopb:
  SHL ECX,1
  JNC @tgm32_nolineb
  MOVQ MM6,MM0
  PACKUSWB MM6,MM1
  PSRLW MM6,8
  PACKUSWB MM6,MM1
  MOVD DWORD PTR [EDI],MM6
  PADDD MM0,MM2
  PADDD MM1,MM3
  ADD EDI,4
@tgm32_nolineb:

  MOV EAX,xp2ai
  MOV EBX,xp2bi
  MOV ECX,bytperline
  ADD xp1,EAX
  ADD xp2,EBX
  ADD lineoffs,ECX

  PADDD MM4,GBd2a
  PADDD MM5,XRd2a

  POP ECX
  DEC ECX
  JNZ @tgm32_loopt2
@tgm32_nodraw2:
@tgm32_else2:
  EMMS
END;

{ triangle_textured =========================================================}

PROCEDURE triangle_texturedL8(rend:prender);
LABEL md_a1,md_a2a,md_a3a,md_a2b,md_a3b,md_a2c,md_a3c;
LABEL md_b1,md_b2a,md_b3a,md_b2b,md_b3b,md_b2c,md_b3c;
VAR xp1,_xp2,xpd,yp,xp1ai,xp1bi,xp2ai,xp2bi,xp1i,xp2i,hl:longint;
    _xt,_yt,_xtd,_ytd,
    _xt1,_yt1,_xtd1a,_ytd1a,_xtd1b,_ytd1b,_xtxd,
    _xt2,_yt2,_xtd2a,_ytd2a,_xtd2b,_ytd2b,_ytyd,
    _xt3,_yt3,f1,f2,f3:longint;
    xtyi1,ytyi1,xtyi2,ytyi2:longint;
    imgofs:pointer;
    lineoffs:dword;
    x,y,x1,y1,x2,y2,x3,y3,h:longint;
    xd12,yd12,xd13,yd13,xd23,yd23:longint;
    pixel2draw:longint;
    ts:byte;
BEGIN
  imgofs:=rend^.texture^.pixeldata;
  f1:=longint(rend^.texcoords[0].y) SHL 16+rend^.texcoords[0].x;
  f2:=longint(rend^.texcoords[1].y) SHL 16+rend^.texcoords[1].x;
  f3:=longint(rend^.texcoords[2].y) SHL 16+rend^.texcoords[2].x;
  ts:=rend^.texturesize;
  x1:=rend^.points[0].x;
  y1:=rend^.points[0].y;
  x2:=rend^.points[1].x;
  y2:=rend^.points[1].y;
  x3:=rend^.points[2].x;
  y3:=rend^.points[2].y;

  ASM
    MOV CL,ts
    {16-n: 2,5,9,13}
    MOV AL,16
    SUB AL,CL

    LEA EBX,md_a1
    MOV [EBX+2],AL
    MOV [EBX+5],AL
    MOV [EBX+9],AL
    MOV [EBX+13],AL

    LEA EBX,md_b1
    MOV [EBX+2],AL
    MOV [EBX+5],AL
    MOV [EBX+9],AL
    MOV [EBX+13],AL

    {16+16-n: 2}
    ADD AL,16
    LEA EBX,md_a2a
    MOV [EBX+2],AL
    LEA EBX,md_a2b
    MOV [EBX+2],AL
    LEA EBX,md_a2c
    MOV [EBX+2],AL
    LEA EBX,md_b2a
    MOV [EBX+2],AL
    LEA EBX,md_b2b
    MOV [EBX+2],AL
    LEA EBX,md_b2c
    MOV [EBX+2],AL

    {n: 3}
    LEA EBX,md_a3a
    MOV [EBX+3],CL
    LEA EBX,md_a3b
    MOV [EBX+3],CL
    LEA EBX,md_a3c
    MOV [EBX+3],CL
    LEA EBX,md_b3a
    MOV [EBX+3],CL
    LEA EBX,md_b3b
    MOV [EBX+3],CL
    LEA EBX,md_b3c
    MOV [EBX+3],CL
  END;

  IF (y2<y1) THEN
    BEGIN
      h:=x1;x1:=x2;x2:=h;
      h:=y1;y1:=y2;y2:=h;
      hl:=f1;f1:=f2;f2:=hl;
    END;
  IF (y3<y1) THEN
    BEGIN
      h:=x1;x1:=x3;x3:=h;
      h:=y1;y1:=y3;y3:=h;
      hl:=f1;f1:=f3;f3:=hl;
    END;
  IF (y3<y2) THEN
    BEGIN
      h:=x2;x2:=x3;x3:=h;
      h:=y2;y2:=y3;y3:=h;
      hl:=f2;f2:=f3;f3:=hl;
    END;

  xd12:=x2-x1;
  yd12:=y2-y1+1;

  xd13:=x3-x1;
  yd13:=y3-y1+1;

  xd23:=x3-x2;
  yd23:=y3-y2+1;

  xp1ai:=(longint(xd13) SHL 16) DIV yd13;
  xp1bi:=(longint(xd12) SHL 16) DIV yd12;
  xp2ai:=(longint(xd13) SHL 16) DIV yd13;
  xp2bi:=(longint(xd23) SHL 16) DIV yd23;
  xp1:=longint(x1) SHL 16;
  _xp2:=longint(x1) SHL 16;

  _xt1:=longint(word(f1)) SHL 16;
  _yt1:=longint(word(f1 SHR 16)) SHL 16;

  _xt2:=longint(word(f2)) SHL 16;
  _yt2:=longint(word(f2 SHR 16)) SHL 16;

  _xt3:=longint(word(f3)) SHL 16;
  _yt3:=longint(word(f3 SHR 16)) SHL 16;

  _xtd1a:=longint(_xt3-_xt1) DIV yd13;
  _ytd1a:=longint(_yt3-_yt1) DIV yd13;

  _xtd1b:=longint(_xt2-_xt1) DIV yd12;
  _ytd1b:=longint(_yt2-_yt1) DIV yd12;

  _xtd2a:=longint(_xt3-_xt1) DIV yd13;
  _ytd2a:=longint(_yt3-_yt1) DIV yd13;

  _xtd2b:=longint(_xt3-_xt2) DIV yd23;
  _ytd2b:=longint(_yt3-_yt2) DIV yd23;

  xp1i:=xp1bi-xp1ai;
  xp2i:=xp2bi-xp2ai;

  xtyi1:=_xtd1b-_xtd1a;
  ytyi1:=_ytd1b-_ytd1a;
  xtyi2:=_xtd2b-_xtd2a;
  ytyi2:=_ytd2b-_ytd2a;

  IF (x2<x1+((xp1ai*yd12) DIV 65536)) THEN
    BEGIN
   {   hl:=xp1ai;xp1ai:=xp1bi;xp1bi:=hl;
      hl:=xp2ai;xp2ai:=xp2bi;xp2bi:=hl; }

  {    hl:=_xtd1a;_xtd1a:=_xtd1b;_xtd1b:=hl;
      hl:=_ytd1a;_ytd1a:=_ytd1b;_ytd1b:=hl; }

   {   hl:=_xtd2a;_xtd2a:=_xtd2b;_xtd2b:=hl;
      hl:=_ytd2a;_ytd2a:=_ytd2b;_ytd2b:=hl; }

      xp1ai:=xp1bi;
      xp2ai:=xp2bi;

      xp1i:=-xp1i;
      xp2i:=-xp2i;

      _xtd1a:=_xtd1b;
      _ytd1a:=_ytd1b;

      _xtd2a:=_xtd2b;
      _ytd2a:=_ytd2b;

      xtyi1:=-xtyi1;
      ytyi1:=-ytyi1;
      xtyi2:=-xtyi2;
      ytyi2:=-ytyi2;
    END;

  _xt2:=_xt1;
  _yt2:=_yt1;

  _xtxd:=0;
  _ytyd:=0;

  xpd:=0;

  IF (y2>=vy1) AND (y1<=vy2) THEN
    BEGIN
      IF (y1<vy1) THEN
        BEGIN
          h:=(vy1-y1);

          xp1:=xp1+xp1ai*h;
          xpd:=xpd+xp1i*h;

          _xt1:=_xt1+_xtd1a*h;
          _yt1:=_yt1+_ytd1a*h;

          _xtxd:=_xtxd+xtyi1*h;
          _ytyd:=_ytyd+ytyi1*h;

          y1:=vy1;
        END;
      IF (y2>vy2) THEN y2:=vy2;
  lineoffs:=LFBoffs+drawoffset+y1*bytperline;
  FOR y:=y1 TO y2 DO
    BEGIN
      ASM
        MOVSX ECX,WORD PTR [xpd+2]
        OR ECX,ECX
        JLE @nolinea
        INC ECX
        MOV EBX,ECX

        MOVSX EDI,WORD PTR [xp1+2]
        XOR ESI,ESI
        CMP EDI,vx1
        JGE @no_left_clipa
        MOV ESI,vx1
        SUB ESI,EDI
        SUB EBX,ESI
        JLE @nolinea
        MOV EDI,vx1
      @no_left_clipa:

        MOV EAX,EDI
        ADD EAX,EBX
        CMP EAX,vx2
        JLE @no_right_clipa
        SUB EAX,vx2
        DEC EAX
        SUB EBX,EAX
        JLE @nolinea
      @no_right_clipa:

        MOV pixel2draw,EBX

        ADD EDI,lineoffs

        MOV EAX,_xtxd
        CDQ
        IDIV ECX
        MOV _xtd,EAX
        MUL ESI
        MOV EBX, _xt1
        ADD EBX,EAX

        MOV EAX,_ytyd
        CDQ
        IDIV ECX
        MOV _ytd,EAX
        MUL ESI
        MOV EDX,_yt1
        ADD EDX,EAX

        MOV ECX,pixel2draw

      md_a1:  {16-n: 2,5,9,13}
        SHL EBX,8      {16-n}
        SHL EDX,8
        SHL _xtd,8
        SHL _ytd,8
        SUB EBX,_xtd

        TEST EDI,0001h
        JZ @nosinglepixela
        DEC ECX
      @singlepixela:
        MOV ESI,EDX
        ADD EBX,_xtd
md_a2a: {32-n: 3}
        SHR ESI,24 {SHR ESI,(32-n)}
        ADD EDX,_ytd
md_a3a: {n: 4}
        SHLD ESI,EBX,8 {SHLD ESI,EBX,n}
     {   ADD ESI,imagedatastart }
        ADD ESI,imgofs
        MOVSB
      @nosinglepixela:

        ROR ECX,1
        OR CX,CX
        JZ @noloopa
      @loop1a_:
        MOV ESI,EDX {MOV ESI,EDX}
        ADD EBX,_xtd
md_a2b:
        SHR ESI,24 {SHR ESI,(32-n)}
        ADD EDX,_ytd
md_a3b:
        SHLD ESI,EBX,8 {SHLD ESI,EBX,n}
        MOV EAX,EDX {MOV EAX,EDX}
        ADD EBX,_xtd
md_a2c:
        SHR EAX,24 {SHR ESI,(32-n)}
        ADD EDX,_ytd
md_a3c:
        SHLD EAX,EBX,8 {SHLD EAX,EBX=0D8h}
        ADD ESI,imgofs
        ADD EAX,imgofs
        MOV AH,[EAX{+imagedatastart}]  {MOV AX,[EAX+10h]}
        MOV AL,[ESI{+imagedatastart}]  {MOV AX,FS:[ESI+10h]}
        DEC CX
        STOSW
        JNZ @loop1a_
      @noloopa:
        SHL ECX,1
        JC @singlepixela
      @nolinea:
      END;
      xp1:=xp1+xp1ai;
      xpd:=xpd+xp1i;

      _xt1:=_xt1+_xtd1a;
      _yt1:=_yt1+_ytd1a;

      _xtxd:=_xtxd+xtyi1;
      _ytyd:=_ytyd+ytyi1;

      lineoffs:=lineoffs+bytperline;
    END;
    END
  ELSE
    BEGIN
      h:=(y2-y1+1);
      xp1:=xp1+xp1ai*h;
      xpd:=xpd+xp1i*h;

      _xt1:=_xt1+_xtd1a*h;
      _yt1:=_yt1+_ytd1a*h;

      _xtxd:=_xtxd+xtyi1*h;
      _ytyd:=_ytyd+ytyi1*h;
    END;
  inc(y2);
  IF (y3>=vy1) AND (y2<=vy2) THEN
    BEGIN
      IF (y2<vy1) THEN
        BEGIN
          h:=(vy1-y2);

          xp1:=xp1+xp2ai*h;
          xpd:=xpd+xp2i*h;

          _xt1:=_xt1+_xtd2a*h;
          _yt1:=_yt1+_ytd2a*h;

          _xtxd:=_xtxd+xtyi2*h;
          _ytyd:=_ytyd+ytyi2*h;

         y2:=vy1;
        END;
      IF (y3>vy2) THEN y3:=vy2;
  lineoffs:=LFBoffs+drawoffset+dword(y2)*bytperline;
  FOR y:=y2 TO y3 DO
    BEGIN
      ASM
        MOVSX ECX,WORD PTR [xpd+2]
        OR ECX,ECX
        JLE @nolineb
        INC ECX
        MOV EBX,ECX

        MOVSX EDI,WORD PTR [xp1+2]
        XOR ESI,ESI
        CMP EDI,vx1
        JGE @no_left_clipb
        MOV ESI,vx1
        SUB ESI,EDI
        SUB EBX,ESI
        JLE @nolineb
        MOV EDI,vx1
      @no_left_clipb:

        MOV EAX,EDI
        ADD EAX,EBX
        CMP EAX,vx2
        JLE @no_right_clipb
        SUB EAX,vx2
        DEC EAX
        SUB EBX,EAX
        JLE @nolineb
      @no_right_clipb:

        MOV pixel2draw,EBX

        ADD EDI,lineoffs

        MOV EAX,_xtxd
        CDQ
        IDIV ECX
        MOV _xtd,EAX
        MUL ESI
        MOV EBX, _xt1
        ADD EBX,EAX

        MOV EAX,_ytyd
        CDQ
        IDIV ECX
        MOV _ytd,EAX
        MUL ESI
        MOV EDX,_yt1
        ADD EDX,EAX

        MOV ECX,pixel2draw

md_b1:  {16-n: 2,5,9,13}
        SHL EBX,8      {16-n}
        SHL EDX,8
        SHL _xtd,8
        SHL _ytd,8
        SUB EBX,_xtd

        TEST EDI,0001h
        JZ @nosinglepixelb
        DEC ECX
      @singlepixelb:
        MOV ESI,EDX {MOV ESI,EDX}
        ADD EBX,_xtd
md_b2a: {32-n: 3}
        SHR ESI,24 {SHR ESI,(32-n)}
        ADD EDX,_ytd
md_b3a: {n: 4}
        SHLD ESI,EBX,8 {SHLD ESI,EBX,n}
      {  ADD ESI,imagedatastart }
        ADD ESI,imgofs
        MOVSB
      @nosinglepixelb:

        ROR ECX,1
        OR CX,CX
        JZ @noloopb
      @loop1b_:
        MOV ESI,EDX {MOV ESI,EDX}
        ADD EBX,_xtd
md_b2b:
        SHR ESI,24 {SHR ESI,(32-n)}
        ADD EDX,_ytd
md_b3b:
        SHLD ESI,EBX,8 {SHLD ESI,EBX,n}
        MOV EAX,EDX {MOV EAX,EDX}
        ADD EBX,_xtd
md_b2c:
        SHR EAX,24 {SHR ESI,(32-n)}
        ADD EDX,_ytd
md_b3c:
        SHLD EAX,EBX,8 {SHLD EAX,EBX=0D8h}
        ADD ESI,imgofs
        ADD EAX,imgofs
        MOV AH,[EAX{+imagedatastart}]  {MOV AX,[EAX+10h]}
        MOV AL,[ESI{+imagedatastart}]  {MOV AX,[ESI+10h]}
        DEC CX
        STOSW
        JNZ @loop1b_
      @noloopb:
        SHL ECX,1
        JC @singlepixelb
      @nolineb:
      END;
      _xt1:=_xt1+_xtd2a;
      _yt1:=_yt1+_ytd2a;

      xp1:=xp1+xp2ai;
      xpd:=xpd+xp2i;

  {    xt2:=xt2+xtd2b;
      yt2:=yt2+ytd2b; }

      _xtxd:=_xtxd+xtyi2;
      _ytyd:=_ytyd+ytyi2;
      lineoffs:=lineoffs+bytperline;
    END;
    END;
END;

PROCEDURE triangle_texturedL16(rend:prender);
LABEL md_a1,md_a2a,md_a3a,md_a2b,md_a3b,md_a2c,md_a3c;
LABEL md_b1,md_b2a,md_b3a,md_b2b,md_b3b,md_b2c,md_b3c;
VAR xp1,_xp2,xpd,yp,xp1ai,xp1bi,xp2ai,xp2bi,xp1i,xp2i,hl:longint;
    _xt,_yt,_xtd,_ytd,
    _xt1,_yt1,_xtd1a,_ytd1a,_xtd1b,_ytd1b,_xtxd,
    _xt2,_yt2,_xtd2a,_ytd2a,_xtd2b,_ytd2b,_ytyd,
    _xt3,_yt3,f1,f2,f3:longint;
    xtyi1,ytyi1,xtyi2,ytyi2:longint;
    imgofs:pointer;
    lineoffs:dword;
    x,y,x1,y1,x2,y2,x3,y3,h:longint;
    xd12,yd12,xd13,yd13,xd23,yd23:longint;
    pixel2draw:longint;
    ts:byte;
BEGIN
  imgofs:=rend^.texture^.pixeldata;
  f1:=longint(rend^.texcoords[0].y) SHL 16+rend^.texcoords[0].x;
  f2:=longint(rend^.texcoords[1].y) SHL 16+rend^.texcoords[1].x;
  f3:=longint(rend^.texcoords[2].y) SHL 16+rend^.texcoords[2].x;
  ts:=rend^.texturesize;
  x1:=rend^.points[0].x;
  y1:=rend^.points[0].y;
  x2:=rend^.points[1].x;
  y2:=rend^.points[1].y;
  x3:=rend^.points[2].x;
  y3:=rend^.points[2].y;

  ASM
    MOV CL,ts
    {16-n: 2,5,9,13}
    MOV AL,16
    SUB AL,CL

    LEA EBX,md_a1
    MOV [EBX+2],AL
    MOV [EBX+5],AL
    MOV [EBX+9],AL
    MOV [EBX+13],AL

    LEA EBX,md_b1
    MOV [EBX+2],AL
    MOV [EBX+5],AL
    MOV [EBX+9],AL
    MOV [EBX+13],AL

    {16+16-n: 2}
    ADD AL,16
    LEA EBX,md_a2a
    MOV [EBX+2],AL
    LEA EBX,md_a2b
    MOV [EBX+2],AL
    LEA EBX,md_a2c
    MOV [EBX+2],AL
    LEA EBX,md_b2a
    MOV [EBX+2],AL
    LEA EBX,md_b2b
    MOV [EBX+2],AL
    LEA EBX,md_b2c
    MOV [EBX+2],AL

    {n: 3}
    LEA EBX,md_a3a
    MOV [EBX+3],CL
    LEA EBX,md_a3b
    MOV [EBX+3],CL
    LEA EBX,md_a3c
    MOV [EBX+3],CL
    LEA EBX,md_b3a
    MOV [EBX+3],CL
    LEA EBX,md_b3b
    MOV [EBX+3],CL
    LEA EBX,md_b3c
    MOV [EBX+3],CL
  END;

  IF (y2<y1) THEN
    BEGIN
      h:=x1;x1:=x2;x2:=h;
      h:=y1;y1:=y2;y2:=h;
      hl:=f1;f1:=f2;f2:=hl;
    END;
  IF (y3<y1) THEN
    BEGIN
      h:=x1;x1:=x3;x3:=h;
      h:=y1;y1:=y3;y3:=h;
      hl:=f1;f1:=f3;f3:=hl;
    END;
  IF (y3<y2) THEN
    BEGIN
      h:=x2;x2:=x3;x3:=h;
      h:=y2;y2:=y3;y3:=h;
      hl:=f2;f2:=f3;f3:=hl;
    END;

  xd12:=x2-x1;
  yd12:=y2-y1+1;

  xd13:=x3-x1;
  yd13:=y3-y1+1;

  xd23:=x3-x2;
  yd23:=y3-y2+1;

  xp1ai:=(longint(xd13) SHL 16) DIV yd13;
  xp1bi:=(longint(xd12) SHL 16) DIV yd12;
  xp2ai:=(longint(xd13) SHL 16) DIV yd13;
  xp2bi:=(longint(xd23) SHL 16) DIV yd23;
  xp1:=longint(x1) SHL 16;
  _xp2:=longint(x1) SHL 16;

  _xt1:=longint(word(f1)) SHL 16;
  _yt1:=longint(word(f1 SHR 16)) SHL 16;

  _xt2:=longint(word(f2)) SHL 16;
  _yt2:=longint(word(f2 SHR 16)) SHL 16;

  _xt3:=longint(word(f3)) SHL 16;
  _yt3:=longint(word(f3 SHR 16)) SHL 16;

  _xtd1a:=longint(_xt3-_xt1) DIV yd13;
  _ytd1a:=longint(_yt3-_yt1) DIV yd13;

  _xtd1b:=longint(_xt2-_xt1) DIV yd12;
  _ytd1b:=longint(_yt2-_yt1) DIV yd12;

  _xtd2a:=longint(_xt3-_xt1) DIV yd13;
  _ytd2a:=longint(_yt3-_yt1) DIV yd13;

  _xtd2b:=longint(_xt3-_xt2) DIV yd23;
  _ytd2b:=longint(_yt3-_yt2) DIV yd23;

  xp1i:=xp1bi-xp1ai;
  xp2i:=xp2bi-xp2ai;

  xtyi1:=_xtd1b-_xtd1a;
  ytyi1:=_ytd1b-_ytd1a;
  xtyi2:=_xtd2b-_xtd2a;
  ytyi2:=_ytd2b-_ytd2a;

  IF (x2<x1+((xp1ai*yd12) DIV 65536)) THEN
    BEGIN
   {   hl:=xp1ai;xp1ai:=xp1bi;xp1bi:=hl;
      hl:=xp2ai;xp2ai:=xp2bi;xp2bi:=hl; }

  {    hl:=_xtd1a;_xtd1a:=_xtd1b;_xtd1b:=hl;
      hl:=_ytd1a;_ytd1a:=_ytd1b;_ytd1b:=hl; }

   {   hl:=_xtd2a;_xtd2a:=_xtd2b;_xtd2b:=hl;
      hl:=_ytd2a;_ytd2a:=_ytd2b;_ytd2b:=hl; }

      xp1ai:=xp1bi;
      xp2ai:=xp2bi;

      xp1i:=-xp1i;
      xp2i:=-xp2i;

      _xtd1a:=_xtd1b;
      _ytd1a:=_ytd1b;

      _xtd2a:=_xtd2b;
      _ytd2a:=_ytd2b;

      xtyi1:=-xtyi1;
      ytyi1:=-ytyi1;
      xtyi2:=-xtyi2;
      ytyi2:=-ytyi2;
    END;

  _xt2:=_xt1;
  _yt2:=_yt1;

  _xtxd:=0;
  _ytyd:=0;

  xpd:=0;

  IF (y2>=vy1) AND (y1<=vy2) THEN
    BEGIN
      IF (y1<vy1) THEN
        BEGIN
          h:=(vy1-y1);

          xp1:=xp1+xp1ai*h;
          xpd:=xpd+xp1i*h;

          _xt1:=_xt1+_xtd1a*h;
          _yt1:=_yt1+_ytd1a*h;

          _xtxd:=_xtxd+xtyi1*h;
          _ytyd:=_ytyd+ytyi1*h;

          y1:=vy1;
        END;
      IF (y2>vy2) THEN y2:=vy2;
  lineoffs:=LFBoffs+drawoffset+dword(y1)*bytperline;
  FOR y:=y1 TO y2 DO
    BEGIN
      ASM
        MOVSX ECX,WORD PTR [xpd+2]
        OR ECX,ECX
        JLE @nolinea
        INC ECX
        MOV EBX,ECX

        MOVSX EDI,WORD PTR [xp1+2]
        XOR ESI,ESI
        CMP EDI,vx1
        JGE @no_left_clipa
        MOV ESI,vx1
        SUB ESI,EDI
        SUB EBX,ESI
        JLE @nolinea
        MOV EDI,vx1
      @no_left_clipa:

        MOV EAX,EDI
        ADD EAX,EBX
        CMP EAX,vx2
        JLE @no_right_clipa
        SUB EAX,vx2
        DEC EAX
        SUB EBX,EAX
        JLE @nolinea
      @no_right_clipa:

        MOV pixel2draw,EBX

        SHL EDI,1
        ADD EDI,lineoffs

        MOV EAX,_xtxd
        CDQ
        IDIV ECX
        MOV _xtd,EAX
        MUL ESI
        MOV EBX, _xt1
        ADD EBX,EAX

        MOV EAX,_ytyd
        CDQ
        IDIV ECX
        MOV _ytd,EAX
        MUL ESI
        MOV EDX,_yt1
        ADD EDX,EAX

        MOV ECX,pixel2draw

md_a1:  {16-n: 2,5,9,13}
        SHL EBX,8      {16-n}
        SHL EDX,8
        SHL _xtd,8
        SHL _ytd,8
        SUB EBX,_xtd

        TEST EDI,0003h
        JZ @nosinglepixela
        DEC ECX
      @singlepixela:
        MOV ESI,EDX
        ADD EBX,_xtd
md_a2a: {32-n: 3}
        SHR ESI,24 {SHR ESI,(32-n)}
        ADD EDX,_ytd
md_a3a: {n: 4}
        SHLD ESI,EBX,8 {SHLD ESI,EBX,n}
        SHL ESI,1
     {   ADD ESI,imagedatastart }
        ADD ESI,imgofs
        MOVSW
      @nosinglepixela:

        ROR ECX,1
        OR CX,CX
        JZ @noloopa
      @loop1a_:
        MOV ESI,EDX {MOV ESI,EDX}
        ADD EBX,_xtd
md_a2b:
        SHR ESI,24 {SHR ESI,(32-n)}
        ADD EDX,_ytd
md_a3b:
        SHLD ESI,EBX,8 {SHLD ESI,EBX,n}
        MOV EAX,EDX {MOV EAX,EDX}
        ADD EBX,_xtd
md_a2c:
        SHR EAX,24 {SHR ESI,(32-n)}
        ADD EDX,_ytd
md_a3c:
        SHLD EAX,EBX,8 {SHLD EAX,EBX=0D8h}
        SHL ESI,1
        SHL EAX,1
        ADD ESI,imgofs
        ADD EAX,imgofs
        MOV AX,[EAX{+imagedatastart}]  {MOV AX,[EAX+10h]}
        SHL EAX,16
        MOV AX,[ESI{+imagedatastart}]  {MOV AX,[ESI+10h]}
        DEC CX
        STOSD
        JNZ @loop1a_
      @noloopa:
        SHL ECX,1
        JC @singlepixela
      @nolinea:
      END;
      xp1:=xp1+xp1ai;
      xpd:=xpd+xp1i;

      _xt1:=_xt1+_xtd1a;
      _yt1:=_yt1+_ytd1a;

      _xtxd:=_xtxd+xtyi1;
      _ytyd:=_ytyd+ytyi1;

      lineoffs:=lineoffs+bytperline;
    END;
    END
  ELSE
    BEGIN
      h:=(y2-y1+1);
      xp1:=xp1+xp1ai*h;
      xpd:=xpd+xp1i*h;

      _xt1:=_xt1+_xtd1a*h;
      _yt1:=_yt1+_ytd1a*h;

      _xtxd:=_xtxd+xtyi1*h;
      _ytyd:=_ytyd+ytyi1*h;
    END;
  inc(y2);
  IF (y3>=vy1) AND (y2<=vy2) THEN
    BEGIN
      IF (y2<vy1) THEN
        BEGIN
          h:=(vy1-y2);

          xp1:=xp1+xp2ai*h;
          xpd:=xpd+xp2i*h;

          _xt1:=_xt1+_xtd2a*h;
          _yt1:=_yt1+_ytd2a*h;

          _xtxd:=_xtxd+xtyi2*h;
          _ytyd:=_ytyd+ytyi2*h;

         y2:=vy1;
        END;
      IF (y3>vy2) THEN y3:=vy2;
  lineoffs:=LFBoffs+drawoffset+dword(y2)*bytperline;
  FOR y:=y2 TO y3 DO
    BEGIN
      ASM
        MOVSX ECX,WORD PTR [xpd+2]
        OR ECX,ECX
        JLE @nolineb
        INC ECX
        MOV EBX,ECX

        MOVSX EDI,WORD PTR [xp1+2]
        XOR ESI,ESI
        CMP EDI,vx1
        JGE @no_left_clipb
        MOV ESI,vx1
        SUB ESI,EDI
        SUB EBX,ESI
        JLE @nolineb
        MOV EDI,vx1
      @no_left_clipb:

        MOV EAX,EDI
        ADD EAX,EBX
        CMP EAX,vx2
        JLE @no_right_clipb
        SUB EAX,vx2
        DEC EAX
        SUB EBX,EAX
        JLE @nolineb
      @no_right_clipb:

        MOV pixel2draw,EBX

        SHL EDI,1
        ADD EDI,lineoffs

        MOV EAX,_xtxd
        CDQ
        IDIV ECX
        MOV _xtd,EAX
        MUL ESI
        MOV EBX, _xt1
        ADD EBX,EAX

        MOV EAX,_ytyd
        CDQ
        IDIV ECX
        MOV _ytd,EAX
        MUL ESI
        MOV EDX,_yt1
        ADD EDX,EAX

        MOV ECX,pixel2draw

md_b1:  {16-n: 2,5,9,13}
        SHL EBX,8      {16-n}
        SHL EDX,8
        SHL _xtd,8
        SHL _ytd,8
        SUB EBX,_xtd

        TEST EDI,0003h
        JZ @nosinglepixelb
        DEC ECX
      @singlepixelb:
        MOV ESI,EDX {MOV ESI,EDX}
        ADD EBX,_xtd
md_b2a: {32-n: 3}
        SHR ESI,24 {SHR ESI,(32-n)}
        ADD EDX,_ytd
md_b3a: {n: 4}
        SHLD ESI,EBX,8 {SHLD ESI,EBX,n}
        SHL ESI,1
     {   ADD ESI,imagedatastart }
        ADD ESI,imgofs
        MOVSW
      @nosinglepixelb:

        ROR ECX,1
        OR CX,CX
        JZ @noloopb
      @loop1b_:
        MOV ESI,EDX {MOV ESI,EDX}
        ADD EBX,_xtd
md_b2b:
        SHR ESI,24 {SHR ESI,(32-n)}
        ADD EDX,_ytd
md_b3b:
        SHLD ESI,EBX,8 {SHLD ESI,EBX,n}
        MOV EAX,EDX {MOV EAX,EDX}
        ADD EBX,_xtd
md_b2c:
        SHR EAX,24 {SHR ESI,(32-n)}
        ADD EDX,_ytd
md_b3c:
        SHLD EAX,EBX,8 {SHLD EAX,EBX=0D8h}
        SHL ESI,1
        SHL EAX,1
        ADD ESI,imgofs
        ADD EAX,imgofs
        MOV AX,[EAX{+imagedatastart}]  {MOV AX,[EAX+10h]}
        SHL EAX,16
        MOV AX,[ESI{+imagedatastart}]  {MOV AX,[ESI+10h]}
        DEC CX
        STOSD
        JNZ @loop1b_
      @noloopb:
        SHL ECX,1
        JC @singlepixelb
      @nolineb:
      END;
      _xt1:=_xt1+_xtd2a;
      _yt1:=_yt1+_ytd2a;

      xp1:=xp1+xp2ai;
      xpd:=xpd+xp2i;

  {    xt2:=xt2+xtd2b;
      yt2:=yt2+ytd2b; }

      _xtxd:=_xtxd+xtyi2;
      _ytyd:=_ytyd+ytyi2;
      lineoffs:=lineoffs+bytperline;
    END;
    END;
END;

PROCEDURE triangle_texturedL24(rend:prender);
LABEL md_a1,md_a2,md_a3,md_b1,md_b2,md_b3;
VAR xp1,_xp2,xpd,yp,xp1ai,xp1bi,xp2ai,xp2bi,xp1i,xp2i,hl:longint;
    _xt,_yt,_xtd,_ytd,
    _xt1,_yt1,_xtd1a,_ytd1a,_xtd1b,_ytd1b,_xtxd,
    _xt2,_yt2,_xtd2a,_ytd2a,_xtd2b,_ytd2b,_ytyd,
    _xt3,_yt3,f1,f2,f3:longint;
    xtyi1,ytyi1,xtyi2,ytyi2:longint;
    lineoffs:dword;
    x,y,x1,y1,x2,y2,x3,y3,h:longint;
    xd12,yd12,xd13,yd13,xd23,yd23:longint;
    pixel2draw:longint;
    imgofs:pointer;
    ts:byte;
    t:word;
BEGIN
  imgofs:=rend^.texture^.pixeldata;
  f1:=longint(rend^.texcoords[0].y) SHL 16+rend^.texcoords[0].x;
  f2:=longint(rend^.texcoords[1].y) SHL 16+rend^.texcoords[1].x;
  f3:=longint(rend^.texcoords[2].y) SHL 16+rend^.texcoords[2].x;
  ts:=rend^.texturesize;
  x1:=rend^.points[0].x;
  y1:=rend^.points[0].y;
  x2:=rend^.points[1].x;
  y2:=rend^.points[1].y;
  x3:=rend^.points[2].x;
  y3:=rend^.points[2].y;
  ASM
    MOV CL,ts
    MOV AL,16
    SUB AL,CL
    {16-n: 2,5,9,13}
    LEA EBX,md_a1
    MOV [EBX+2],AL
    MOV [EBX+5],AL
    MOV [EBX+9],AL
    MOV [EBX+13],AL
    LEA EBX,md_b1
    MOV [EBX+2],AL
    MOV [EBX+5],AL
    MOV [EBX+9],AL
    MOV [EBX+13],AL
    {16+16-n: 2}
    ADD AL,16
    LEA EBX,md_a2
    MOV [EBX+2],AL
    LEA EBX,md_b2
    MOV [EBX+2],AL
    {n: 3}
    LEA EBX,md_a3
    MOV [EBX+3],CL
    LEA EBX,md_b3
    MOV [EBX+3],CL
  END;

  IF (y2<y1) THEN
    BEGIN
      h:=x1;x1:=x2;x2:=h;
      h:=y1;y1:=y2;y2:=h;
      hl:=f1;f1:=f2;f2:=hl;
    END;
  IF (y3<y1) THEN
    BEGIN
      h:=x1;x1:=x3;x3:=h;
      h:=y1;y1:=y3;y3:=h;
      hl:=f1;f1:=f3;f3:=hl;
    END;
  IF (y3<y2) THEN
    BEGIN
      h:=x2;x2:=x3;x3:=h;
      h:=y2;y2:=y3;y3:=h;
      hl:=f2;f2:=f3;f3:=hl;
    END;

  xd12:=x2-x1;
  yd12:=y2-y1+1;

  xd13:=x3-x1;
  yd13:=y3-y1+1;

  xd23:=x3-x2;
  yd23:=y3-y2+1;

  xp1ai:=(longint(xd13) SHL 16) DIV yd13;
  xp1bi:=(longint(xd12) SHL 16) DIV yd12;
  xp2ai:=(longint(xd13) SHL 16) DIV yd13;
  xp2bi:=(longint(xd23) SHL 16) DIV yd23;
  xp1:=longint(x1) SHL 16;
  _xp2:=longint(x1) SHL 16;

  _xt1:=longint(word(f1)) SHL 16;
  _yt1:=longint(word(f1 SHR 16)) SHL 16;

  _xt2:=longint(word(f2)) SHL 16;
  _yt2:=longint(word(f2 SHR 16)) SHL 16;

  _xt3:=longint(word(f3)) SHL 16;
  _yt3:=longint(word(f3 SHR 16)) SHL 16;

  _xtd1a:=longint(_xt3-_xt1) DIV yd13;
  _ytd1a:=longint(_yt3-_yt1) DIV yd13;

  _xtd1b:=longint(_xt2-_xt1) DIV yd12;
  _ytd1b:=longint(_yt2-_yt1) DIV yd12;

  _xtd2a:=longint(_xt3-_xt1) DIV yd13;
  _ytd2a:=longint(_yt3-_yt1) DIV yd13;

  _xtd2b:=longint(_xt3-_xt2) DIV yd23;
  _ytd2b:=longint(_yt3-_yt2) DIV yd23;

  xp1i:=xp1bi-xp1ai;
  xp2i:=xp2bi-xp2ai;

  xtyi1:=_xtd1b-_xtd1a;
  ytyi1:=_ytd1b-_ytd1a;
  xtyi2:=_xtd2b-_xtd2a;
  ytyi2:=_ytd2b-_ytd2a;

  IF (x2<x1+((xp1ai*yd12) DIV 65536)) THEN
    BEGIN
   {   hl:=xp1ai;xp1ai:=xp1bi;xp1bi:=hl;
      hl:=xp2ai;xp2ai:=xp2bi;xp2bi:=hl; }

  {    hl:=_xtd1a;_xtd1a:=_xtd1b;_xtd1b:=hl;
      hl:=_ytd1a;_ytd1a:=_ytd1b;_ytd1b:=hl; }

   {   hl:=_xtd2a;_xtd2a:=_xtd2b;_xtd2b:=hl;
      hl:=_ytd2a;_ytd2a:=_ytd2b;_ytd2b:=hl; }

      xp1ai:=xp1bi;
      xp2ai:=xp2bi;

      xp1i:=-xp1i;
      xp2i:=-xp2i;

      _xtd1a:=_xtd1b;
      _ytd1a:=_ytd1b;

      _xtd2a:=_xtd2b;
      _ytd2a:=_ytd2b;

      xtyi1:=-xtyi1;
      ytyi1:=-ytyi1;
      xtyi2:=-xtyi2;
      ytyi2:=-ytyi2;
    END;

  _xt2:=_xt1;
  _yt2:=_yt1;

  _xtxd:=0;
  _ytyd:=0;

  xpd:=0;

  IF (y2>=vy1) AND (y1<=vy2) THEN
    BEGIN
      IF (y1<vy1) THEN
        BEGIN
          h:=(vy1-y1);

          xp1:=xp1+xp1ai*h;
          xpd:=xpd+xp1i*h;

          _xt1:=_xt1+_xtd1a*h;
          _yt1:=_yt1+_ytd1a*h;

          _xtxd:=_xtxd+xtyi1*h;
          _ytyd:=_ytyd+ytyi1*h;

          y1:=vy1;
        END;
      IF (y2>vy2) THEN y2:=vy2;
  lineoffs:=LFBoffs+drawoffset+dword(y1)*bytperline;
  FOR y:=y1 TO y2 DO
    BEGIN
      ASM
        MOVSX ECX,WORD PTR [xpd+2]
        OR ECX,ECX
        JLE @nolinea
        INC ECX
        MOV EBX,ECX

        MOVSX EDI,WORD PTR [xp1+2]
        XOR ESI,ESI
        CMP EDI,vx1
        JGE @no_left_clipa
        MOV ESI,vx1
        SUB ESI,EDI
        SUB EBX,ESI
        JLE @nolinea
        MOV EDI,vx1
      @no_left_clipa:

        MOV EAX,EDI
        ADD EAX,EBX
        CMP EAX,vx2
        JLE @no_right_clipa
        SUB EAX,vx2
        DEC EAX
        SUB EBX,EAX
        JLE @nolinea
      @no_right_clipa:

        MOV pixel2draw,EBX

        LEA EDI,[EDI+EDI*2]
        ADD EDI,lineoffs

        MOV EAX,_xtxd
        CDQ
        IDIV ECX
        MOV _xtd,EAX
        MUL ESI
        MOV EBX, _xt1
        ADD EBX,EAX

        MOV EAX,_ytyd
        CDQ
        IDIV ECX
        MOV _ytd,EAX
        MUL ESI
        MOV EDX,_yt1
        ADD EDX,EAX

        MOV ECX,pixel2draw

     md_a1:  {16-n: 2,5,9,13}
        SHL EBX,8      {16-n}
        SHL EDX,8
        SHL _xtd,8
        SHL _ytd,8
        SUB EBX,_xtd
     @loop1a_:
        MOV ESI,EDX
        ADD EBX,_xtd
     md_a2: {32-n: 2}
        SHR ESI,24 {SHR ESI,(32-n)}
        ADD EDX,_ytd
     md_a3: {n: 3}
        SHLD ESI,EBX,8 {SHLD ESI,EBX,n}
        LEA ESI,[ESI+ESI*2]
        ADD ESI,imgofs
        DEC ECX
        MOVSW
        MOVSB
        JNZ @loop1a_
      @nolinea:
      END;
      xp1:=xp1+xp1ai;
      xpd:=xpd+xp1i;

      _xt1:=_xt1+_xtd1a;
      _yt1:=_yt1+_ytd1a;

      _xtxd:=_xtxd+xtyi1;
      _ytyd:=_ytyd+ytyi1;

      lineoffs:=lineoffs+bytperline;
    END;
    END
  ELSE
    BEGIN
      h:=(y2-y1+1);
      xp1:=xp1+xp1ai*h;
      xpd:=xpd+xp1i*h;

      _xt1:=_xt1+_xtd1a*h;
      _yt1:=_yt1+_ytd1a*h;

      _xtxd:=_xtxd+xtyi1*h;
      _ytyd:=_ytyd+ytyi1*h;
    END;
  inc(y2);
  IF (y3>=vy1) AND (y2<=vy2) THEN
    BEGIN
      IF (y2<vy1) THEN
        BEGIN
          h:=(vy1-y2);

          xp1:=xp1+xp2ai*h;
          xpd:=xpd+xp2i*h;

          _xt1:=_xt1+_xtd2a*h;
          _yt1:=_yt1+_ytd2a*h;

          _xtxd:=_xtxd+xtyi2*h;
          _ytyd:=_ytyd+ytyi2*h;

         y2:=vy1;
        END;
      IF (y3>vy2) THEN y3:=vy2;
  lineoffs:=LFBoffs+drawoffset+dword(y2)*bytperline;
  FOR y:=y2 TO y3 DO
    BEGIN
      ASM
        MOVSX ECX,WORD PTR [xpd+2]
        OR ECX,ECX
        JLE @nolineb
        INC ECX
        MOV EBX,ECX

        MOVSX EDI,WORD PTR [xp1+2]
        XOR ESI,ESI
        CMP EDI,vx1
        JGE @no_left_clipb
        MOV ESI,vx1
        SUB ESI,EDI
        SUB EBX,ESI
        JLE @nolineb
        MOV EDI,vx1
      @no_left_clipb:

        MOV EAX,EDI
        ADD EAX,EBX
        CMP EAX,vx2
        JLE @no_right_clipb
        SUB EAX,vx2
        DEC EAX
        SUB EBX,EAX
        JLE @nolineb
      @no_right_clipb:

        MOV pixel2draw,EBX

        LEA EDI,[EDI+EDI*2]
        ADD EDI,lineoffs

        MOV EAX,_xtxd
        CDQ
        IDIV ECX
        MOV _xtd,EAX
        MUL ESI
        MOV EBX, _xt1
        ADD EBX,EAX

        MOV EAX,_ytyd
        CDQ
        IDIV ECX
        MOV _ytd,EAX
        MUL ESI
        MOV EDX,_yt1
        ADD EDX,EAX

        MOV ECX,pixel2draw

     md_b1:  {16-n: 2,5,9,13}
        SHL EBX,8      {16-n}
        SHL EDX,8
        SHL _xtd,8
        SHL _ytd,8
        SUB EBX,_xtd
     @loop1b_:
        MOV ESI,EDX
        ADD EBX,_xtd
     md_b2: {32-n: 2}
        SHR ESI,24 {SHR ESI,(32-n)}
        ADD EDX,_ytd
     md_b3: {n: 3}
        SHLD ESI,EBX,8 {SHLD ESI,EBX,n}
        LEA ESI,[ESI+ESI*2]
        ADD ESI,imgofs
        DEC ECX
        MOVSW
        MOVSB
        JNZ @loop1b_
      @nolineb:
      END;
      _xt1:=_xt1+_xtd2a;
      _yt1:=_yt1+_ytd2a;

      xp1:=xp1+xp2ai;
      xpd:=xpd+xp2i;

  {    xt2:=xt2+xtd2b;
      yt2:=yt2+ytd2b; }

      _xtxd:=_xtxd+xtyi2;
      _ytyd:=_ytyd+ytyi2;
      lineoffs:=lineoffs+bytperline;
    END;
    END;
END;

PROCEDURE triangle_texturedL32(rend:prender);
LABEL md_a1,md_a2,md_a3,md_b1,md_b2,md_b3;                                                                                                                                                                                                                     
VAR xp1,_xp2,xpd,yp,xp1ai,xp1bi,xp2ai,xp2bi,xp1i,xp2i,hl:longint;                                                                                                                                                                                              
    _xt,_yt,_xtd,_ytd,                                                                                                                                                                                                                                         
    _xt1,_yt1,_xtd1a,_ytd1a,_xtd1b,_ytd1b,_xtxd,
    _xt2,_yt2,_xtd2a,_ytd2a,_xtd2b,_ytd2b,_ytyd,                                                                                                                                                                                                               
    _xt3,_yt3,f1,f2,f3:longint;                                                                                                                                                                                                                                
                                                                                                                                                                                                                                                               
    xtyi1,ytyi1,xtyi2,ytyi2:longint;                                                                                                                                                                                                                           

    lineoffs:dword;
    x,y,x1,y1,x2,y2,x3,y3,h:longint;                                                                                                                                                                                                                           
    xd12,yd12,xd13,yd13,xd23,yd23:longint;                                                                                                                                                                                                                     
    pixel2draw:longint;
    imgofs:pointer;
    ts:byte;                                                                                                                                                                                                                                                   
    t:word;                                                                                                                                                                                                                                                    
BEGIN                                                                                                                                                                                                                                                          
  imgofs:=rend^.texture^.pixeldata;
  f1:=longint(rend^.texcoords[0].y) SHL 16+rend^.texcoords[0].x;
  f2:=longint(rend^.texcoords[1].y) SHL 16+rend^.texcoords[1].x;
  f3:=longint(rend^.texcoords[2].y) SHL 16+rend^.texcoords[2].x;
  ts:=rend^.texturesize;
  x1:=rend^.points[0].x;                                                                                                                                                                                                                                       
  y1:=rend^.points[0].y;                                                                                                                                                                                                                                       
  x2:=rend^.points[1].x;                                                                                                                                                                                                                                       
  y2:=rend^.points[1].y;                                                                                                                                                                                                                                       
  x3:=rend^.points[2].x;                                                                                                                                                                                                                                       
  y3:=rend^.points[2].y;                                                                                                                                                                                                                                       
  ASM                                                                                                                                                                                                                                                          
    MOV CL,ts
    MOV AL,16
    SUB AL,CL
    {16-n: 2,5,9,13}
    LEA EBX,md_a1
    MOV [EBX+2],AL
    MOV [EBX+5],AL
    MOV [EBX+9],AL
    MOV [EBX+13],AL
    LEA EBX,md_b1
    MOV [EBX+2],AL
    MOV [EBX+5],AL
    MOV [EBX+9],AL
    MOV [EBX+13],AL
    {16+16-n: 2}
    ADD AL,16
    LEA EBX,md_a2
    MOV [EBX+2],AL
    LEA EBX,md_b2
    MOV [EBX+2],AL
    {n: 3}
    LEA EBX,md_a3
    MOV [EBX+3],CL
    LEA EBX,md_b3
    MOV [EBX+3],CL
  END;

  IF (y2<y1) THEN
    BEGIN                                                                                                                                                                                                                                                      
      h:=x1;x1:=x2;x2:=h;                                                                                                                                                                                                                                      
      h:=y1;y1:=y2;y2:=h;                                                                                                                                                                                                                                      
      hl:=f1;f1:=f2;f2:=hl;                                                                                                                                                                                                                                    
    END;                                                                                                                                                                                                                                                       
  IF (y3<y1) THEN                                                                                                                                                                                                                                              
    BEGIN                                                                                                                                                                                                                                                      
      h:=x1;x1:=x3;x3:=h;                                                                                                                                                                                                                                      
      h:=y1;y1:=y3;y3:=h;                                                                                                                                                                                                                                      
      hl:=f1;f1:=f3;f3:=hl;                                                                                                                                                                                                                                    
    END;                                                                                                                                                                                                                                                       
  IF (y3<y2) THEN
    BEGIN                                                                                                                                                                                                                                                      
      h:=x2;x2:=x3;x3:=h;
      h:=y2;y2:=y3;y3:=h;                                                                                                                                                                                                                                      
      hl:=f2;f2:=f3;f3:=hl;                                                                                                                                                                                                                                    
    END;                                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                               
  xd12:=x2-x1;                                                                                                                                                                                                                                                 
  yd12:=y2-y1+1;                                                                                                                                                                                                                                               
                                                                                                                                                                                                                                                               
  xd13:=x3-x1;                                                                                                                                                                                                                                                 
  yd13:=y3-y1+1;                                                                                                                                                                                                                                               
                                                                                                                                                                                                                                                               
  xd23:=x3-x2;                                                                                                                                                                                                                                                 
  yd23:=y3-y2+1;                                                                                                                                                                                                                                               
                                                                                                                                                                                                                                                               
  xp1ai:=(longint(xd13) SHL 16) DIV yd13;                                                                                                                                                                                                                      
  xp1bi:=(longint(xd12) SHL 16) DIV yd12;                                                                                                                                                                                                                      
  xp2ai:=(longint(xd13) SHL 16) DIV yd13;                                                                                                                                                                                                                      
  xp2bi:=(longint(xd23) SHL 16) DIV yd23;                                                                                                                                                                                                                      
  xp1:=longint(x1) SHL 16;                                                                                                                                                                                                                                     
  _xp2:=longint(x1) SHL 16;

  _xt1:=longint(word(f1)) SHL 16;                                                                                                                                                                                                                              
  _yt1:=longint(word(f1 SHR 16)) SHL 16;                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                               
  _xt2:=longint(word(f2)) SHL 16;                                                                                                                                                                                                                              
  _yt2:=longint(word(f2 SHR 16)) SHL 16;                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                               
  _xt3:=longint(word(f3)) SHL 16;                                                                                                                                                                                                                              
  _yt3:=longint(word(f3 SHR 16)) SHL 16;                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                               
  _xtd1a:=longint(_xt3-_xt1) DIV yd13;                                                                                                                                                                                                                         
  _ytd1a:=longint(_yt3-_yt1) DIV yd13;                                                                                                                                                                                                                         
                                                                                                                                                                                                                                                               
  _xtd1b:=longint(_xt2-_xt1) DIV yd12;                                                                                                                                                                                                                         
  _ytd1b:=longint(_yt2-_yt1) DIV yd12;                                                                                                                                                                                                                         
                                                                                                                                                                                                                                                               
  _xtd2a:=longint(_xt3-_xt1) DIV yd13;                                                                                                                                                                                                                         
  _ytd2a:=longint(_yt3-_yt1) DIV yd13;                                                                                                                                                                                                                         
                                                                                                                                                                                                                                                               
  _xtd2b:=longint(_xt3-_xt2) DIV yd23;                                                                                                                                                                                                                         
  _ytd2b:=longint(_yt3-_yt2) DIV yd23;
                                                                                                                                                                                                                                                               
  xp1i:=xp1bi-xp1ai;                                                                                                                                                                                                                                           
  xp2i:=xp2bi-xp2ai;                                                                                                                                                                                                                                           
                                                                                                                                                                                                                                                               
  xtyi1:=_xtd1b-_xtd1a;                                                                                                                                                                                                                                        
  ytyi1:=_ytd1b-_ytd1a;                                                                                                                                                                                                                                        
  xtyi2:=_xtd2b-_xtd2a;                                                                                                                                                                                                                                        
  ytyi2:=_ytd2b-_ytd2a;                                                                                                                                                                                                                                        
                                                                                                                                                                                                                                                               
  IF (x2<x1+((xp1ai*yd12) DIV 65536)) THEN
    BEGIN                                                                                                                                                                                                                                                      
   {   hl:=xp1ai;xp1ai:=xp1bi;xp1bi:=hl;                                                                                                                                                                                                                       
      hl:=xp2ai;xp2ai:=xp2bi;xp2bi:=hl; }                                                                                                                                                                                                                      
                                                                                                                                                                                                                                                               
  {    hl:=_xtd1a;_xtd1a:=_xtd1b;_xtd1b:=hl;                                                                                                                                                                                                                   
      hl:=_ytd1a;_ytd1a:=_ytd1b;_ytd1b:=hl; }                                                                                                                                                                                                                  
                                                                                                                                                                                                                                                               
   {   hl:=_xtd2a;_xtd2a:=_xtd2b;_xtd2b:=hl;                                                                                                                                                                                                                   
      hl:=_ytd2a;_ytd2a:=_ytd2b;_ytd2b:=hl; }                                                                                                                                                                                                                  

      xp1ai:=xp1bi;
      xp2ai:=xp2bi;                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                                               
      xp1i:=-xp1i;                                                                                                                                                                                                                                             
      xp2i:=-xp2i;                                                                                                                                                                                                                                             
                                                                                                                                                                                                                                                               
      _xtd1a:=_xtd1b;                                                                                                                                                                                                                                          
      _ytd1a:=_ytd1b;                                                                                                                                                                                                                                          
                                                                                                                                                                                                                                                               
      _xtd2a:=_xtd2b;                                                                                                                                                                                                                                          
      _ytd2a:=_ytd2b;                                                                                                                                                                                                                                          
                                                                                                                                                                                                                                                               
      xtyi1:=-xtyi1;                                                                                                                                                                                                                                           
      ytyi1:=-ytyi1;                                                                                                                                                                                                                                           
      xtyi2:=-xtyi2;                                                                                                                                                                                                                                           
      ytyi2:=-ytyi2;                                                                                                                                                                                                                                           
    END;                                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                               
  _xt2:=_xt1;                                                                                                                                                                                                                                                  
  _yt2:=_yt1;                                                                                                                                                                                                                                                  
                                                                                                                                                                                                                                                               
  _xtxd:=0;
  _ytyd:=0;                                                                                                                                                                                                                                                    
                                                                                                                                                                                                                                                               
  xpd:=0;                                                                                                                                                                                                                                                      
                                                                                                                                                                                                                                                               
  IF (y2>=vy1) AND (y1<=vy2) THEN                                                                                                                                                                                                                              
    BEGIN                                                                                                                                                                                                                                                      
      IF (y1<vy1) THEN                                                                                                                                                                                                                                         
        BEGIN                                                                                                                                                                                                                                                  
          h:=(vy1-y1);                                                                                                                                                                                                                                         
                                                                                                                                                                                                                                                               
          xp1:=xp1+xp1ai*h;                                                                                                                                                                                                                                    
          xpd:=xpd+xp1i*h;                                                                                                                                                                                                                                     
                                                                                                                                                                                                                                                               
          _xt1:=_xt1+_xtd1a*h;                                                                                                                                                                                                                                 
          _yt1:=_yt1+_ytd1a*h;                                                                                                                                                                                                                                 
                                                                                                                                                                                                                                                               
          _xtxd:=_xtxd+xtyi1*h;                                                                                                                                                                                                                                
          _ytyd:=_ytyd+ytyi1*h;                                                                                                                                                                                                                                
                                                                                                                                                                                                                                                               
          y1:=vy1;                                                                                                                                                                                                                                             
        END;
      IF (y2>vy2) THEN y2:=vy2;                                                                                                                                                                                                                                
  lineoffs:=LFBoffs+drawoffset+dword(y1)*bytperline;
  FOR y:=y1 TO y2 DO
    BEGIN
      ASM
        MOVSX ECX,WORD PTR [xpd+2]                                                                                                                                                                                                                             
        OR ECX,ECX                                                                                                                                                                                                                                             
        JLE @nolinea                                                                                                                                                                                                                                           
        INC ECX                                                                                                                                                                                                                                                
        MOV EBX,ECX                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                                               
        MOVSX EDI,WORD PTR [xp1+2]                                                                                                                                                                                                                             
        XOR ESI,ESI                                                                                                                                                                                                                                            
        CMP EDI,vx1                                                                                                                                                                                                                                            
        JGE @no_left_clipa                                                                                                                                                                                                                                     
        MOV ESI,vx1                                                                                                                                                                                                                                            
        SUB ESI,EDI                                                                                                                                                                                                                                            
        SUB EBX,ESI                                                                                                                                                                                                                                            
        JLE @nolinea                                                                                                                                                                                                                                           
        MOV EDI,vx1                                                                                                                                                                                                                                            
      @no_left_clipa:
                                                                                                                                                                                                                                                               
        MOV EAX,EDI                                                                                                                                                                                                                                            
        ADD EAX,EBX                                                                                                                                                                                                                                            
        CMP EAX,vx2                                                                                                                                                                                                                                            
        JLE @no_right_clipa                                                                                                                                                                                                                                    
        SUB EAX,vx2                                                                                                                                                                                                                                            
        DEC EAX                                                                                                                                                                                                                                                
        SUB EBX,EAX                                                                                                                                                                                                                                            
        JLE @nolinea                                                                                                                                                                                                                                           
      @no_right_clipa:                                                                                                                                                                                                                                         
                                                                                                                                                                                                                                                               
        MOV pixel2draw,EBX                                                                                                                                                                                                                                     
                                                                                                                                                                                                                                                               
        SHL EDI,2                                                                                                                                                                                                                                              
        ADD EDI,lineoffs                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                               
        MOV EAX,_xtxd                                                                                                                                                                                                                                          
        CDQ                                                                                                                                                                                                                                                    
        IDIV ECX                                                                                                                                                                                                                                               
        MOV _xtd,EAX                                                                                                                                                                                                                                           
        MUL ESI
        MOV EBX, _xt1                                                                                                                                                                                                                                          
        ADD EBX,EAX                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                                               
        MOV EAX,_ytyd                                                                                                                                                                                                                                          
        CDQ                                                                                                                                                                                                                                                    
        IDIV ECX                                                                                                                                                                                                                                               
        MOV _ytd,EAX                                                                                                                                                                                                                                           
        MUL ESI                                                                                                                                                                                                                                                
        MOV EDX,_yt1                                                                                                                                                                                                                                           
        ADD EDX,EAX                                                                                                                                                                                                                                            

        MOV ECX,pixel2draw                                                                                                                                                                                                                                     
                                                                                                                                                                                                                                                               
     md_a1:  {16-n: 2,5,9,13}
        SHL EBX,8      {16-n}                                                                                                                                                                                                                                  
        SHL EDX,8                                                                                                                                                                                                                                              
        SHL _xtd,8                                                                                                                                                                                                                                             
        SHL _ytd,8                                                                                                                                                                                                                                             
        SUB EBX,_xtd                                                                                                                                                                                                                                           
     @loop1a_:
        MOV ESI,EDX                                                                                                                                                                                                                                            
        ADD EBX,_xtd                                                                                                                                                                                                                                           
     md_a2: {32-n: 2}                                                                                                                                                                                                                                          
        SHR ESI,24 {SHR ESI,(32-n)}                                                                                                                                                                                                                            
        ADD EDX,_ytd                                                                                                                                                                                                                                           
     md_a3: {n: 3}                                                                                                                                                                                                                                             
        SHLD ESI,EBX,8 {SHLD ESI,EBX,n}                                                                                                                                                                                                                        
        SHL ESI,2                                                                                                                                                                                                                                              
        ADD ESI,imgofs                                                                                                                                                                                                                                         
        DEC ECX                                                                                                                                                                                                                                                
        MOVSD
        JNZ @loop1a_                                                                                                                                                                                                                                           
      @nolinea:                                                                                                                                                                                                                                                
                                                                                                                                                                                                                                                               
      END;
      xp1:=xp1+xp1ai;                                                                                                                                                                                                                                          
      xpd:=xpd+xp1i;                                                                                                                                                                                                                                           
                                                                                                                                                                                                                                                               
      _xt1:=_xt1+_xtd1a;
      _yt1:=_yt1+_ytd1a;                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                               
      _xtxd:=_xtxd+xtyi1;                                                                                                                                                                                                                                      
      _ytyd:=_ytyd+ytyi1;                                                                                                                                                                                                                                      
                                                                                                                                                                                                                                                               
      lineoffs:=lineoffs+bytperline;                                                                                                                                                                                                                           
    END;                                                                                                                                                                                                                                                       
    END                                                                                                                                                                                                                                                        
  ELSE                                                                                                                                                                                                                                                         
    BEGIN                                                                                                                                                                                                                                                      
      h:=(y2-y1+1);                                                                                                                                                                                                                                            
      xp1:=xp1+xp1ai*h;
      xpd:=xpd+xp1i*h;                                                                                                                                                                                                                                         
                                                                                                                                                                                                                                                               
      _xt1:=_xt1+_xtd1a*h;                                                                                                                                                                                                                                     
      _yt1:=_yt1+_ytd1a*h;                                                                                                                                                                                                                                     
                                                                                                                                                                                                                                                               
      _xtxd:=_xtxd+xtyi1*h;                                                                                                                                                                                                                                    
      _ytyd:=_ytyd+ytyi1*h;                                                                                                                                                                                                                                    
    END;                                                                                                                                                                                                                                                       
  inc(y2);
  IF (y3>=vy1) AND (y2<=vy2) THEN                                                                                                                                                                                                                              
    BEGIN                                                                                                                                                                                                                                                      
      IF (y2<vy1) THEN                                                                                                                                                                                                                                         
        BEGIN                                                                                                                                                                                                                                                  
          h:=(vy1-y2);                                                                                                                                                                                                                                         
                                                                                                                                                                                                                                                               
          xp1:=xp1+xp2ai*h;                                                                                                                                                                                                                                    
          xpd:=xpd+xp2i*h;                                                                                                                                                                                                                                     
                                                                                                                                                                                                                                                               
          _xt1:=_xt1+_xtd2a*h;                                                                                                                                                                                                                                 
          _yt1:=_yt1+_ytd2a*h;
                                                                                                                                                                                                                                                               
          _xtxd:=_xtxd+xtyi2*h;                                                                                                                                                                                                                                
          _ytyd:=_ytyd+ytyi2*h;                                                                                                                                                                                                                                
                                                                                                                                                                                                                                                               
         y2:=vy1;                                                                                                                                                                                                                                              
        END;                                                                                                                                                                                                                                                   
      IF (y3>vy2) THEN y3:=vy2;                                                                                                                                                                                                                                
  lineoffs:=LFBoffs+drawoffset+dword(y2)*bytperline;
  FOR y:=y2 TO y3 DO
    BEGIN
      ASM
        MOVSX ECX,WORD PTR [xpd+2]                                                                                                                                                                                                                             
        OR ECX,ECX                                                                                                                                                                                                                                             
        JLE @nolineb                                                                                                                                                                                                                                           
        INC ECX                                                                                                                                                                                                                                                
        MOV EBX,ECX                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                                               
        MOVSX EDI,WORD PTR [xp1+2]                                                                                                                                                                                                                             
        XOR ESI,ESI                                                                                                                                                                                                                                            
        CMP EDI,vx1
        JGE @no_left_clipb                                                                                                                                                                                                                                     
        MOV ESI,vx1                                                                                                                                                                                                                                            
        SUB ESI,EDI                                                                                                                                                                                                                                            
        SUB EBX,ESI                                                                                                                                                                                                                                            
        JLE @nolineb                                                                                                                                                                                                                                           
        MOV EDI,vx1                                                                                                                                                                                                                                            
      @no_left_clipb:                                                                                                                                                                                                                                          
                                                                                                                                                                                                                                                               
        MOV EAX,EDI                                                                                                                                                                                                                                            
        ADD EAX,EBX                                                                                                                                                                                                                                            
        CMP EAX,vx2
        JLE @no_right_clipb                                                                                                                                                                                                                                    
        SUB EAX,vx2                                                                                                                                                                                                                                            
        DEC EAX                                                                                                                                                                                                                                                
        SUB EBX,EAX                                                                                                                                                                                                                                            
        JLE @nolineb                                                                                                                                                                                                                                           
      @no_right_clipb:                                                                                                                                                                                                                                         
                                                                                                                                                                                                                                                               
        MOV pixel2draw,EBX                                                                                                                                                                                                                                     

        SHL EDI,2                                                                                                                                                                                                                                              
        ADD EDI,lineoffs                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                               
        MOV EAX,_xtxd                                                                                                                                                                                                                                          
        CDQ                                                                                                                                                                                                                                                    
        IDIV ECX                                                                                                                                                                                                                                               
        MOV _xtd,EAX                                                                                                                                                                                                                                           
        MUL ESI                                                                                                                                                                                                                                                
        MOV EBX, _xt1                                                                                                                                                                                                                                          
        ADD EBX,EAX                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                                               
        MOV EAX,_ytyd
        CDQ                                                                                                                                                                                                                                                    
        IDIV ECX                                                                                                                                                                                                                                               
        MOV _ytd,EAX                                                                                                                                                                                                                                           
        MUL ESI                                                                                                                                                                                                                                                
        MOV EDX,_yt1                                                                                                                                                                                                                                           
        ADD EDX,EAX                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                                               
        MOV ECX,pixel2draw
                                                                                                                                                                                                                                                               
     md_b1:  {16-n: 2,5,9,13}
        SHL EBX,8      {16-n}                                                                                                                                                                                                                                  
        SHL EDX,8                                                                                                                                                                                                                                              
        SHL _xtd,8                                                                                                                                                                                                                                             
        SHL _ytd,8                                                                                                                                                                                                                                             
        SUB EBX,_xtd                                                                                                                                                                                                                                           
     @loop1b_:                                                                                                                                                                                                                                                 
        MOV ESI,EDX                                                                                                                                                                                                                                            
        ADD EBX,_xtd                                                                                                                                                                                                                                           
     md_b2: {32-n: 2}                                                                                                                                                                                                                                          
        SHR ESI,24 {SHR ESI,(32-n)}
        ADD EDX,_ytd                                                                                                                                                                                                                                           
     md_b3: {n: 3}                                                                                                                                                                                                                                             
        SHLD ESI,EBX,8 {SHLD ESI,EBX,n}                                                                                                                                                                                                                        
        SHL ESI,2                                                                                                                                                                                                                                              
        ADD ESI,imgofs                                                                                                                                                                                                                                         
        DEC ECX                                                                                                                                                                                                                                                
        MOVSD                                                                                                                                                                                                                                                  
        JNZ @loop1b_
      @nolineb:                                                                                                                                                                                                                                                
                                                                                                                                                                                                                                                               
      END;
      _xt1:=_xt1+_xtd2a;                                                                                                                                                                                                                                       
      _yt1:=_yt1+_ytd2a;                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                               
      xp1:=xp1+xp2ai;                                                                                                                                                                                                                                          
      xpd:=xpd+xp2i;                                                                                                                                                                                                                                           
                                                                                                                                                                                                                                                               
  {    xt2:=xt2+xtd2b;                                                                                                                                                                                                                                         
      yt2:=yt2+ytd2b; }
                                                                                                                                                                                                                                                               
      _xtxd:=_xtxd+xtyi2;                                                                                                                                                                                                                                      
      _ytyd:=_ytyd+ytyi2;                                                                                                                                                                                                                                      
      lineoffs:=lineoffs+bytperline;                                                                                                                                                                                                                           
    END;                                                                                                                                                                                                                                                       
    END;                                                                                                                                                                                                                                                       
END;

{ triangle_textured_perspective =============================================}

CONST dp=20;

PROCEDURE DrawScanLine(x1,x2,y,u1,u2,v1,v2,z1,z2:longint;tex:pimage);
VAR h,width:longint;
    x,u,v,du,dv,dz:longint;
BEGIN
  IF NOT ((y>=vy1) AND (y<=vy2)) THEN exit;
  IF (x1>x2) THEN
    BEGIN
      h:=x1;x1:=x2;x2:=h;
      h:=u1;u1:=u2;u2:=h;
      h:=v1;v1:=v2;v2:=h;
      h:=z1;z1:=z2;z2:=h;
    END;
  ASM
    SAR x1,16
    SAR x2,16
  END;
  width:=x2-x1;
  IF (width<>0) THEN
    BEGIN
      du:=(u2-u1) DIV width;
      dv:=(v2-v1) DIV width;
      dz:=(z2-z1) DIV width;
    END;
  IF (x1<vx1) THEN
    BEGIN
      u1:=u1+du*(vx1-x1);
      v1:=v1+dv*(vx1-x1);
      z1:=z1+dz*(vx1-x1);
      x1:=vx1;
    END;
  IF (x2>vx2) THEN
    BEGIN
      x2:=vx2;
    END;
  FOR x:=x1 TO x2 DO
    BEGIN
      IF (z1<>0) AND (z2<>0) THEN
        BEGIN
          u:=((u1*4) DIV z1) AND $3FC;
          v:=((v1*4) DIV z1) AND $3FC;
          longint(pointer(LFBoffs+drawoffset+dword(y)*bytperline+dword(x*4))^):=
                  longint((tex^.pixeldata+(v*256+u))^);
        END;
      inc(u1,du);
      inc(v1,dv);
      inc(z1,dz);
    END;
END;

PROCEDURE triangle_textured_perspectiveL32(rend:prender);
TYPE TSC=RECORD su,sv,sz:longint; END;
VAR SC:array[0..2] of TSC;
    i,a0,a1,a2,ah:longint;
    dx1,dx2,du1,du2,dv1,dv2,dz1,dz2:longint;
    y,x1,x2,u1,u2,v1,v2,z1,z2:longint;
    h1,h2:longint;
BEGIN
  FOR i:=0 TO 2 DO
    BEGIN
      SC[i].su:=(rend^.texcoords[i].x SHL dp) DIV rend^.points[i].z;
      SC[i].sv:=(rend^.texcoords[i].y SHL dp) DIV rend^.points[i].z;
      SC[i].sz:=(                   1 SHL dp) DIV rend^.points[i].z;
    END;
{ oberster vertex}
  a0:=0;
  IF (rend^.points[1].y<rend^.points[a0].y) THEN a0:=1;
  IF (rend^.points[2].y<rend^.points[a0].y) THEN a0:=2;
  a1:=a0+1;
  a2:=a0-1;
  IF (a1>2) THEN a1:=0;
  IF (a2<0) THEN a2:=2;
{ start variablen }
   y:=rend^.points[a0].y;
  x1:=rend^.points[a0].x SHL 16;
  x2:=rend^.points[a0].x SHL 16;
{ hoehe }
  h1:=abs(rend^.points[a1].y-rend^.points[a0].y);
  h2:=abs(rend^.points[a2].y-rend^.points[a0].y);
  u1:=SC[a0].su;
  u2:=SC[a0].su;
  v1:=SC[a0].sv;
  v2:=SC[a0].sv;
  z1:=SC[a0].sz;
  z2:=SC[a0].sz;
  IF (h1<>0) THEN
    BEGIN
      dx1:=((rend^.points[a1].x-rend^.points[a0].x) SHL 16) DIV h1;
      du1:=(SC[a1].su-SC[a0].su) DIV h1;
      dv1:=(SC[a1].sv-SC[a0].sv) DIV h1;
      dz1:=(SC[a1].sz-SC[a0].sz) DIV h1;
    END;
  IF (h2<>0) THEN
    BEGIN
      dx2:=((rend^.points[a2].x-rend^.points[a0].x) SHL 16) DIV h2;
      du2:=(SC[a2].su-SC[a0].su) DIV h2;
      dv2:=(SC[a2].sv-SC[a0].sv) DIV h2;
      dz2:=(SC[a2].sz-SC[a0].sz) DIV h2;
    END;
{ zeichnen }
  FOR i:=0 TO 1 DO
    BEGIN
      WHILE (h1<>0) AND (h2<>0) DO
        BEGIN
          DrawScanLine(x1,x2,y,u1,u2,v1,v2,z1,z2,rend^.texture);
       {   lineH(x1 SHR 16,x2 SHR 16,y,$00FFFF*i); }
          inc(y);
          dec(h1);
          dec(h2);
          inc(x1,dx1);
          inc(x2,dx2);
          inc(u1,du1);
          inc(u2,du2);
          inc(v1,dv1);
          inc(v2,dv2);
          inc(z1,dz1);
          inc(z2,dz2);
        END;
      IF (h1=0) THEN
        BEGIN
          ah:=a1+1;
          IF (ah>2) THEN ah:=0;
          h1:=abs(rend^.points[ah].y-rend^.points[a1].y);
          IF (h1<>0) THEN
            BEGIN
              dx1:=((rend^.points[ah].x-rend^.points[a1].x) SHL 16) DIV h1;
              du1:=(SC[ah].su-SC[a1].su) DIV h1;
              dv1:=(SC[ah].sv-SC[a1].sv) DIV h1;
              dz1:=(SC[ah].sz-SC[a1].sz) DIV h1;
            END;
          x1:=rend^.points[a1].x SHL 16;
          u1:=SC[a1].su;
          v1:=SC[a1].sv;
          z1:=SC[a1].sz;
          a1:=ah;
        END;
      IF (h2=0) THEN
        BEGIN
          ah:=a2-1;
          IF (ah<0) THEN ah:=2;
          h2:=abs(rend^.points[ah].y-rend^.points[a2].y);
          IF (h2<>0) THEN
            BEGIN
              dx2:=((rend^.points[ah].x-rend^.points[a2].x) SHL 16) DIV h2;
              du2:=(SC[ah].su-SC[a2].su) DIV h2;
              dv2:=(SC[ah].sv-SC[a2].sv) DIV h2;
              dz2:=(SC[ah].sz-SC[a2].sz) DIV h2;
            END;
          x2:=rend^.points[a2].x SHL 16;
          u2:=SC[a2].su;
          v2:=SC[a2].sv;
          z2:=SC[a2].sz;
          a2:=ah;
        END;
    END;
END;

{-- Floating point }

TYPE float=single;

PROCEDURE DrawScanLineFP(x1,x2,y:longint;u1,u2,v1,v2,z1,z2:float;tex:pimage);
VAR hl,u,v,x:longint;
    hs,du,dv,dz,width,rz:float;
BEGIN
  IF NOT ((y>=vy1) AND (y<=vy2)) THEN exit;
  IF (x1>x2) THEN
    BEGIN
      hl:=x1;x1:=x2;x2:=hl;
      hs:=u1;u1:=u2;u2:=hs;
      hs:=v1;v1:=v2;v2:=hs;
      hs:=z1;z1:=z2;z2:=hs;
    END;
  width:=(x2-x1) DIV 65536;
  IF (width<>0) THEN
    BEGIN
      du:=(u2-u1)/width;
      dv:=(v2-v1)/width;
      dz:=(z2-z1)/width;
    END;
  x1:=x1 DIV 65536;
  x2:=x2 DIV 65536;
  IF (x1<vx1) THEN
    BEGIN
      hl:=vx1-x1;
      u1:=u1+du*hl;
      v1:=v1+dv*hl;
      z1:=z1+dz*hl;
      x1:=vx1;
    END;
  IF (x2>vx2) THEN
    BEGIN
      x2:=vx2;
    END;

  FOR x:=x1 TO x2 DO
    BEGIN
      rz:=1/z1;
      u:=trunc(abs(u1*rz)) AND $FF;
      v:=trunc(abs(v1*rz)) AND $FF;
      longint(pointer(LFBoffs+drawoffset+dword(y)*bytperline+dword(x*4))^):=
             longint((tex^.pixeldata+(v*256+u)*4)^);
      u1:=u1+du;
      v1:=v1+dv;
      z1:=z1+dz;
    END;
END;

PROCEDURE DrawScanLineFPlerp(x1,x2,y:longint;u1,u2,v1,v2,z1,z2:float;tex:pimage);
VAR hl,x,ix,u,v,ul,vl,dul,dvl:longint;
    hs,du,dv,dz,dup,dvp,dzp,width,rz:float;
    pixL:longint;
    pixS:float;
BEGIN
  IF NOT ((y>=vy1) AND (y<=vy2)) THEN exit;
  IF (x1>x2) THEN
    BEGIN
      hl:=x1;x1:=x2;x2:=hl;
      hs:=u1;u1:=u2;u2:=hs;
      hs:=v1;v1:=v2;v2:=hs;
      hs:=z1;z1:=z2;z2:=hs;
    END;
  width:=(x2-x1) DIV 65536;
  pixL:=trunc(abs(width/8))+1;
  pixS:=single(pixL);
  IF (abs(width)>=1) THEN
    BEGIN
      du:=(u2-u1)/width;
      dv:=(v2-v1)/width;
      dz:=(z2-z1)/width;
      dup:=du*pixS;
      dvp:=dv*pixS;
      dzp:=dz*pixS;
    END;
  ASM
    SAR x1,16
    SAR x2,16
  END;
  IF (x1<vx1) THEN
    BEGIN
      hs:=(vx1-x1);
      u1:=u1+du*hs;
      v1:=v1+dv*hs;
      z1:=z1+dz*hs;
      x1:=vx1;
    END;
  IF (x2>vx2) THEN
    BEGIN
      x2:=vx2;
    END;

  ix:=0;
  FOR x:=x1 TO x2 DO
    BEGIN
      IF (ix<1) THEN
        BEGIN
          ix:=pixL;
          ul:=trunc((u1/z1)*65536);
          vl:=trunc((v1/z1)*65536);
          ASM
            FCLEX
          END;
          u1:=u1+dup;
          v1:=v1+dvp;
          z1:=z1+dzp;
          dul:=(trunc((u1/z1)*65536)-ul) DIV pixL;
          dvl:=(trunc((v1/z1)*65536)-vl) DIV pixL;
        END;
      dec(ix);

      u:=(ul SHR 16) AND $FF;
      v:=(vl SHR 16) AND $FF;
      longint(pointer(LFBoffs+drawoffset+dword(y)*bytperline+dword(x*4))^):=
              longint((tex^.pixeldata+(v*256+u)*4)^);
      inc(ul,dul);
      inc(vl,dvl);
    END;
END;

PROCEDURE triangle_textured_perspectiveFPL32(rend:prender);
TYPE TSC=RECORD su,sv,sz:single; END;
VAR SC:array[0..2] of TSC;
    y,i,a0,a1,a2,ah:longint;
    dx1,dx2:longint;
    du1,du2,dv1,dv2,dz1,dz2:single;
    x1,x2:longint;
    u1,u2,v1,v2,z1,z2:single;
    h1,h2:longint;
BEGIN
  FOR i:=0 TO 2 DO
    BEGIN
      SC[i].su:=single(rend^.texcoords[i].x)/single(rend^.points[i].z);
      SC[i].sv:=single(rend^.texcoords[i].y)/single(rend^.points[i].z);
      SC[i].sz:=                 1.0/single(rend^.points[i].z);
    END;
{ oberster vertex}
  a0:=0;
  IF (rend^.points[1].y<rend^.points[a0].y) THEN a0:=1;
  IF (rend^.points[2].y<rend^.points[a0].y) THEN a0:=2;
  a1:=a0+1;
  a2:=a0-1;
  IF (a1>2) THEN a1:=0;
  IF (a2<0) THEN a2:=2;
{ start variablen }
   y:=rend^.points[a0].y;
  x1:=rend^.points[a0].x SHL 16;
  x2:=rend^.points[a0].x SHL 16;
  u1:=SC[a0].su;
  u2:=SC[a0].su;
  v1:=SC[a0].sv;
  v2:=SC[a0].sv;
  z1:=SC[a0].sz;
  z2:=SC[a0].sz;
{ hoehe }
  h1:=abs(rend^.points[a1].y-rend^.points[a0].y);
  h2:=abs(rend^.points[a2].y-rend^.points[a0].y);
  IF (h1<>0) THEN
    BEGIN
      dx1:=((rend^.points[a1].x-rend^.points[a0].x) SHL 16) DIV h1;
      du1:=(SC[a1].su-SC[a0].su)/h1;
      dv1:=(SC[a1].sv-SC[a0].sv)/h1;
      dz1:=(SC[a1].sz-SC[a0].sz)/h1;
    END;
  IF (h2<>0) THEN
    BEGIN
      dx2:=((rend^.points[a2].x-rend^.points[a0].x) SHL 16) DIV h2;
      du2:=(SC[a2].su-SC[a0].su)/h2;
      dv2:=(SC[a2].sv-SC[a0].sv)/h2;
      dz2:=(SC[a2].sz-SC[a0].sz)/h2;
    END;
{ zeichnen }
  FOR i:=0 TO 1 DO
    BEGIN
      WHILE (h1<>0) AND (h2<>0) DO
        BEGIN
          DrawScanLineFP{lerp}(x1,x2,y,u1,u2,v1,v2,z1,z2,rend^.texture);
       {   lineH(x1 SHR 16,x2 SHR 16,y,$00FFFF*i); }
          inc(y);
          dec(h1);
          dec(h2);
          x1:=x1+dx1;
          x2:=x2+dx2;
          u1:=u1+du1;
          u2:=u2+du2;
          v1:=v1+dv1;
          v2:=v2+dv2;
          z1:=z1+dz1;
          z2:=z2+dz2;
        END;
      IF (h1=0) THEN
        BEGIN
          ah:=a1+1;
          IF (ah>2) THEN ah:=0;
          h1:=abs(rend^.points[ah].y-rend^.points[a1].y);
          IF (h1<>0) THEN
            BEGIN
              dx1:=((rend^.points[ah].x-rend^.points[a1].x) SHL 16) DIV h1;
              du1:=(SC[ah].su-SC[a1].su)/h1;
              dv1:=(SC[ah].sv-SC[a1].sv)/h1;
              dz1:=(SC[ah].sz-SC[a1].sz)/h1;
            END;
          x1:=rend^.points[a1].x SHL 16;
          u1:=SC[a1].su;
          v1:=SC[a1].sv;
          z1:=SC[a1].sz;
          a1:=ah;
        END;
      IF (h2=0) THEN
        BEGIN
          ah:=a2-1;
          IF (ah<0) THEN ah:=2;
          h2:=abs(rend^.points[ah].y-rend^.points[a2].y);
          IF (h2<>0) THEN
            BEGIN
              dx2:=((rend^.points[ah].x-rend^.points[a2].x) SHL 16) dIV h2;
              du2:=(SC[ah].su-SC[a2].su)/h2;
              dv2:=(SC[ah].sv-SC[a2].sv)/h2;
              dz2:=(SC[ah].sz-SC[a2].sz)/h2;
            END;
          x2:=rend^.points[a2].x SHL 16;
          u2:=SC[a2].su;
          v2:=SC[a2].sv;
          z2:=SC[a2].sz;
          a2:=ah;
        END;
    END;
END;

{============================================================================}
{--------------------------- polygon_flat -----------------------------------}

PROCEDURE polygon_flatL16(rend:ppolyrender);assembler;
CONST linesize=64;
      linesizeld=6;
VAR f,num,ofss,{ofsd,}la,px,py,px1,py1,px2,py2,{pxd,}pyd{,lx1,ly1,lx2,ly2}{,lxd,lyd}{,xinc}:longint;
{    la1,la2:longint; }
ASM
  MOV ESI,rend
  MOV EAX,[ESI+0]
  MOV num,EAX
  MOV EAX,[ESI+4]
  MOV ofss,EAX
  MOV EAX,[ESI+8]
  MOV f,EAX

  MOV ESI,ofss
  LODSD
  MOV px1,EAX
  MOV px2,EAX
  LODSD
  MOV py1,EAX
  MOV py2,EAX
  ADD ESI,4

  MOV ECX,num
  DEC ECX
@pf16_loop11:
  LODSD
  CMP EAX,px1
  JGE @pf16_w1
  MOV px1,EAX
@pf16_w1:
  CMP EAX,px2
  JLE @pf16_w2
  MOV px2,EAX
@pf16_w2:
  LODSD
  CMP EAX,py1
  JGE @pf16_w3
  MOV py1,EAX
@pf16_w3:
  CMP EAX,py2
  JLE @pf16_w4
  MOV py2,EAX
@pf16_w4:
  ADD ESI,4
  DEC ECX
  JNZ @pf16_loop11
{----------}
  MOV EAX,px1
  CMP EAX,vx2
  JG @pf16_ende
  MOV EAX,py1
  CMP EAX,vy2
  JG @pf16_ende
  MOV EAX,px2
  CMP EAX,vx1
  JL @pf16_ende
  MOV EAX,py2
  CMP EAX,vy1
  JL @pf16_ende
{----------}
  MOV EAX,vy1
  CMP EAX,py1
  JLE @pf16_w5
  MOV py1,EAX
@pf16_w5:
  MOV EAX,vy2
  CMP EAX,py2
  JGE @pf16_w6
  MOV py2,EAX
@pf16_w6:
  MOV EAX,py2
  SUB EAX,py1
  MOV pyd,EAX
{----------}
  MOV ECX,pyd
  INC ECX
  XOR EAX,EAX
  MOV EDI,graphbuf
@pf16_loop22:
  MOV [EDI],EAX
  ADD EDI,linesize
  DEC ECX
  JNZ @pf16_loop22
{----------}
  MOV ESI,ofss
  MOV ECX,num
  LEA EAX,[ECX*4-4]
  LEA EAX,[EAX+EAX*2]
  MOV EBX,[EAX+ESI+0]
  MOV EDI,[EAX+ESI+4]
@pf16_loop33:
  PUSH ECX
  MOV EAX,[ESI+0]
  MOV ECX,[ESI+4]
  CMP EDI,ECX
  JZ @pf16_weiter44
  JL @pf16_weiter22
  XCHG EBX,EAX
  XCHG EDI,ECX
@pf16_weiter22:
  SUB ECX,EDI
  JLE @pf16_weiter44
  SHL EBX,16
  SHL EAX,16
  SUB EDI,py1
  SUB EAX,EBX
  CDQ
  IDIV ECX
  OR EDI,EDI
  JGE @pf16_w4A
  ADD ECX,EDI
  NEG EDI
  IMUL EDI,EAX
  ADD EBX,EDI
  MOV EDI,0
@pf16_w4A:
  CMP ECX,pyd
  JLE @pf16_w4B
  MOV ECX,pyd
@pf16_w4B:
  OR ECX,ECX
  JLE @pf16_weiter44
  SHL EDI,linesizeld
  ADD EDI,graphbuf
@pf16_loop44:
  MOV EDX,[EDI]
  CMP EDX,linesize-4
  JAE @pf16_weiter33
  ADD EDX,4
  MOV [EDI+EDX],EBX
  MOV [EDI],EDX
@pf16_weiter33:
  ADD EBX,EAX
  ADD EDI,linesize
  DEC ECX
  JNZ @pf16_loop44
@pf16_weiter44:
  MOV EBX,[ESI+0]
  MOV EDI,[ESI+4]
  ADD ESI,12
  POP ECX
  DEC ECX
  JNZ @pf16_loop33
{--- Sortieren und Zeichnen der X-Werte ---}
  MOV ESI,graphbuf

  MOV EBX,py1
  MOV ECX,pyd
  OR ECX,ECX
  JLE @pf16_weiter66

  MOV EAX,EBX
  MUL bytperline
  MOV EBX,EAX
  ADD EBX,drawoffset
  ADD EBX,LFBoffs

@pf16_loop55:
  PUSH ECX
  PUSH ESI
{--- Bubble-Sort ---}
  MOV ECX,[ESI]
  OR ECX,ECX
  JZ @pf16_weiter55
  PUSH ECX
  ADD ESI,ECX
@pf16_loop66:
  PUSH ECX
  MOV EAX,[ESI]
  MOV EDI,ESI
@pf16_loop77:
  MOV EDX,[EDI]
  CMP EAX,EDX
  JGE @pf16_weiter
  XCHG EAX,EDX
  MOV [ESI],EAX
  MOV [EDI],EDX
@pf16_weiter:
  SUB EDI,4
  SUB ECX,4
  JNZ @pf16_loop77
  SUB ESI,4
  POP ECX
  SUB ECX,4
  JNZ @pf16_loop66
  POP EDX
{---}
  ADD ESI,4
  SHR EDX,3
  MOV EAX,f
@pf16_loop88:
  MOVSX EDI,WORD PTR [ESI+2]
  MOVSX ECX,WORD PTR [ESI+6]
  ADD ESI,8
  CMP EDI,vx2
  JG @pf16_Lende
  CMP ECX,vx1
  JL @pf16_Lende
  CMP EDI,vx1
  JGE @pf16_Lw2
  MOV EDI,vx1
@pf16_Lw2:
  CMP ECX,vx2
  JLE @pf16_Lw3
  MOV ECX,vx2
@pf16_Lw3:
  SUB ECX,EDI
  INC ECX

  SHL EDI,1
  ADD EDI,EBX
  REP STOSW


@pf16_Lende:
  DEC EDX
  JNZ @pf16_loop88
@pf16_weiter55:
  POP ESI
  POP ECX
  ADD EBX,bytperline
  ADD ESI,linesize
  DEC ECX
  JNZ @pf16_loop55
@pf16_weiter66:
@pf16_ende:
END;

PROCEDURE polygon_flatL32(rend:ppolyrender);assembler;
CONST linesize=64;
      linesizeld=6;
VAR f,num,ofss,{ofsd,}la,px,py,px1,py1,px2,py2,{pxd,}pyd{,lx1,ly1,lx2,ly2}{,lxd,lyd}{,xinc}:longint;
{    la1,la2:longint; }
ASM
  MOV ESI,rend
  MOV EAX,[ESI+0]
  MOV num,EAX
  MOV EAX,[ESI+4]
  MOV ofss,EAX
  MOV EAX,[ESI+8]
  MOV f,EAX

  MOV ESI,ofss
  LODSD
  MOV px1,EAX
  MOV px2,EAX
  LODSD
  MOV py1,EAX
  MOV py2,EAX
  ADD ESI,4

  MOV ECX,num
  DEC ECX
@pf32_loop11:
  LODSD
  CMP EAX,px1
  JGE @pf32_w1
  MOV px1,EAX
@pf32_w1:
  CMP EAX,px2
  JLE @pf32_w2
  MOV px2,EAX
@pf32_w2:
  LODSD
  CMP EAX,py1
  JGE @pf32_w3
  MOV py1,EAX
@pf32_w3:
  CMP EAX,py2
  JLE @pf32_w4
  MOV py2,EAX
@pf32_w4:
  ADD ESI,4
  DEC ECX
  JNZ @pf32_loop11
{----------}
  MOV EAX,px1
  CMP EAX,vx2
  JG @pf32_ende
  MOV EAX,py1
  CMP EAX,vy2
  JG @pf32_ende
  MOV EAX,px2
  CMP EAX,vx1
  JL @pf32_ende
  MOV EAX,py2
  CMP EAX,vy1
  JL @pf32_ende
{----------}
  MOV EAX,vy1
  CMP EAX,py1
  JLE @pf32_w5
  MOV py1,EAX
@pf32_w5:
  MOV EAX,vy2
  CMP EAX,py2
  JGE @pf32_w6
  MOV py2,EAX
@pf32_w6:
  MOV EAX,py2
  SUB EAX,py1
  MOV pyd,EAX
{----------}
  MOV ECX,pyd
  INC ECX
  XOR EAX,EAX
  MOV EDI,graphbuf
@pf32_loop22:
  MOV [EDI],EAX
  ADD EDI,linesize
  DEC ECX
  JNZ @pf32_loop22
{----------}
  MOV ESI,ofss
  MOV ECX,num
  LEA EAX,[ECX*4-4]
  LEA EAX,[EAX+EAX*2]
  MOV EBX,[EAX+ESI+0]
  MOV EDI,[EAX+ESI+4]
@pf32_loop33:
  PUSH ECX
  MOV EAX,[ESI+0]
  MOV ECX,[ESI+4]
  CMP EDI,ECX
  JZ @pf32_weiter44
  JL @pf32_weiter22
  XCHG EBX,EAX
  XCHG EDI,ECX
@pf32_weiter22:
  SUB ECX,EDI
  JLE @pf32_weiter44
  SHL EBX,16
  SHL EAX,16
  SUB EDI,py1
  SUB EAX,EBX
  CDQ
  IDIV ECX
  OR EDI,EDI
  JGE @pf32_w4A
  ADD ECX,EDI
  NEG EDI
  IMUL EDI,EAX
  ADD EBX,EDI
  MOV EDI,0
@pf32_w4A:
  CMP ECX,pyd
  JLE @pf32_w4B
  MOV ECX,pyd
@pf32_w4B:
  OR ECX,ECX
  JLE @pf32_weiter44
  SHL EDI,linesizeld
  ADD EDI,graphbuf
@pf32_loop44:
  MOV EDX,[EDI]
  CMP EDX,linesize-4
  JAE @pf32_weiter33
  ADD EDX,4
  MOV [EDI+EDX],EBX
  MOV [EDI],EDX
@pf32_weiter33:
  ADD EBX,EAX
  ADD EDI,linesize
  DEC ECX
  JNZ @pf32_loop44
@pf32_weiter44:
  MOV EBX,[ESI+0]
  MOV EDI,[ESI+4]
  ADD ESI,12
  POP ECX
  DEC ECX
  JNZ @pf32_loop33
{--- Sortieren und Zeichnen der X-Werte ---}
  MOV ESI,graphbuf

  MOV EBX,py1
  MOV ECX,pyd
  OR ECX,ECX
  JLE @pf32_weiter66

  MOV EAX,EBX
  MUL bytperline
  MOV EBX,EAX
  ADD EBX,drawoffset
  ADD EBX,LFBoffs

@pf32_loop55:
  PUSH ECX
  PUSH ESI
{--- Bubble-Sort ---}
  MOV ECX,[ESI]
  OR ECX,ECX
  JZ @pf32_weiter55
  PUSH ECX
  ADD ESI,ECX
@pf32_loop66:
  PUSH ECX
  MOV EAX,[ESI]
  MOV EDI,ESI
@pf32_loop77:
  MOV EDX,[EDI]
  CMP EAX,EDX
  JGE @pf32_weiter
  XCHG EAX,EDX
  MOV [ESI],EAX
  MOV [EDI],EDX
@pf32_weiter:
  SUB EDI,4
  SUB ECX,4
  JNZ @pf32_loop77
  SUB ESI,4
  POP ECX
  SUB ECX,4
  JNZ @pf32_loop66
  POP EDX
{---}
  ADD ESI,4
  SHR EDX,3
  MOV EAX,f
@pf32_loop88:
  MOVSX EDI,WORD PTR [ESI+2]
  MOVSX ECX,WORD PTR [ESI+6]
  ADD ESI,8
  CMP EDI,vx2
  JG @pf32_Lende
  CMP ECX,vx1
  JL @pf32_Lende
  CMP EDI,vx1
  JGE @pf32_Lw2
  MOV EDI,vx1
@pf32_Lw2:
  CMP ECX,vx2
  JLE @pf32_Lw3
  MOV ECX,vx2
@pf32_Lw3:
  SUB ECX,EDI
  INC ECX
  SHL EDI,2
  ADD EDI,EBX
  REP STOSD
@pf32_Lende:
  DEC EDX
  JNZ @pf32_loop88
@pf32_weiter55:
  POP ESI
  POP ECX
  ADD EBX,bytperline
  ADD ESI,linesize
  DEC ECX
  JNZ @pf32_loop55
@pf32_weiter66:
@pf32_ende:
END;

PROCEDURE polygon_flatLM32(rend:ppolyrender);assembler;
CONST linesizeld=7;
      linesize=1 SHL linesizeld;
VAR f,num,ofss,{ofsd,}la,px,py,px1,py1,px2,py2,{pxd,}pyd{,lx1,ly1,lx2,ly2}{,lxd,lyd}{,xinc}:longint;
{    la1,la2:longint; }
ASM
  MOV ESI,rend
  MOV EAX,[ESI+0]
  MOV num,EAX
  MOV EAX,[ESI+4]
  MOV ofss,EAX
  MOV EAX,[ESI+8]
  MOV f,EAX

  MOV ESI,ofss
  LODSD
  MOV px1,EAX
  MOV px2,EAX
  LODSD
  MOV py1,EAX
  MOV py2,EAX
  ADD ESI,4

  MOV ECX,num
  DEC ECX
@pfm32_loop11:
  LODSD
  CMP EAX,px1
  JGE @pfm32_w1
  MOV px1,EAX
@pfm32_w1:
  CMP EAX,px2
  JLE @pfm32_w2
  MOV px2,EAX
@pfm32_w2:
  LODSD
  CMP EAX,py1
  JGE @pfm32_w3
  MOV py1,EAX
@pfm32_w3:
  CMP EAX,py2
  JLE @pfm32_w4
  MOV py2,EAX
@pfm32_w4:
  ADD ESI,4
  DEC ECX
  JNZ @pfm32_loop11
{----------}
  MOV EAX,px1
  CMP EAX,vx2
  JG @pfm32_ende
  MOV EAX,py1
  CMP EAX,vy2
  JG @pfm32_ende
  MOV EAX,px2
  CMP EAX,vx1
  JL @pfm32_ende
  MOV EAX,py2
  CMP EAX,vy1
  JL @pfm32_ende
{----------}
  MOV EAX,vy1
  CMP EAX,py1
  JLE @pfm32_w5
  MOV py1,EAX
@pfm32_w5:
  MOV EAX,vy2
  CMP EAX,py2
  JGE @pfm32_w6
  MOV py2,EAX
@pfm32_w6:
  MOV EAX,py2
  SUB EAX,py1
  MOV pyd,EAX
{----------}
  MOV ECX,pyd
  INC ECX
  XOR EAX,EAX
  MOV EDI,graphbuf
@pfm32_loop22:
  MOV [EDI],EAX
  ADD EDI,linesize
  DEC ECX
  JNZ @pfm32_loop22
{----------}
  MOV ESI,ofss
  MOV ECX,num
  LEA EAX,[ECX*4-4]
  LEA EAX,[EAX+EAX*2]
  MOV EBX,[EAX+ESI+0]
  MOV EDI,[EAX+ESI+4]
{  MOVQ MM0,[EAX+ESI] }
@pfm32_loop33:
  PUSH ECX
  MOV EAX,[ESI+0]
  MOV ECX,[ESI+4]
{  MOVQ MM1,[ESI] }
  CMP EDI,ECX
  JZ @pfm32_weiter44
  JL @pfm32_weiter22
  XCHG EBX,EAX
  XCHG EDI,ECX
{  MOVQ MM7,MM0
  MOVQ MM0,MM1
  MOVQ MM1,MM7 }
@pfm32_weiter22:
  SUB ECX,EDI
  JLE @pfm32_weiter44
  SHL EBX,16
  SHL EAX,16
  SUB EDI,py1
  SUB EAX,EBX
  CDQ
  IDIV ECX
  OR EDI,EDI
  JGE @pfm32_w4A
  ADD ECX,EDI
  NEG EDI
  IMUL EDI,EAX
  ADD EBX,EDI
  MOV EDI,0
@pfm32_w4A:
  CMP ECX,pyd
  JLE @pfm32_w4B
  MOV ECX,pyd
@pfm32_w4B:
  OR ECX,ECX
  JLE @pfm32_weiter44
  SHL EDI,linesizeld
  ADD EDI,graphbuf
@pfm32_loop44:
  MOV EDX,[EDI]
  CMP EDX,linesize-4
  JAE @pfm32_weiter33
  ADD EDX,4
  MOV [EDI+EDX],EBX
  MOV [EDI],EDX
@pfm32_weiter33:
  ADD EBX,EAX
  ADD EDI,linesize
  DEC ECX
  JNZ @pfm32_loop44
@pfm32_weiter44:
  MOV EBX,[ESI+0]
  MOV EDI,[ESI+4]
{  MOVQ MM0,[ESI] }
  ADD ESI,12
  POP ECX
  DEC ECX
  JNZ @pfm32_loop33
{--- Sortieren und Zeichnen der X-Werte ---}
  MOV ESI,graphbuf

  MOV EBX,py1
  MOV ECX,pyd
  OR ECX,ECX
  JLE @pfm32_weiter66

  MOV EAX,EBX
  MUL bytperline
  MOV EBX,EAX
  ADD EBX,drawoffset
  ADD EBX,LFBoffs

@pfm32_loop55:
  PUSH ECX
  PUSH ESI
{--- Bubble-Sort ---}
  MOV ECX,[ESI]
  OR ECX,ECX
  JZ @pfm32_weiter55
  PUSH ECX
  ADD ESI,ECX
@pfm32_loop66:
  PUSH ECX
  MOV EAX,[ESI]
  MOV EDI,ESI
@pfm32_loop77:
  MOV EDX,[EDI]
  CMP EAX,EDX
  JGE @pfm32_weiter
  XCHG EAX,EDX
  MOV [ESI],EAX
  MOV [EDI],EDX
@pfm32_weiter:
  SUB EDI,4
  SUB ECX,4
  JNZ @pfm32_loop77
  SUB ESI,4
  POP ECX
  SUB ECX,4
  JNZ @pfm32_loop66
  POP EDX
{---}
  ADD ESI,4
  SHR EDX,3
  MOV EAX,f
  MOVD MM7,EAX
  PUNPCKLDQ MM7,MM7
@pfm32_loop88:
  MOVSX EDI,WORD PTR [ESI+2]
  MOVSX ECX,WORD PTR [ESI+6]
  CMP EDI,vx2
  JG @pfm32_Lende
  CMP ECX,vx1
  JL @pfm32_Lende
  CMP EDI,vx1
  JGE @pfm32_Lw2
  MOV EDI,vx1
@pfm32_Lw2:
  CMP ECX,vx2
  JLE @pfm32_Lw3
  MOV ECX,vx2
@pfm32_Lw3:
  SUB ECX,EDI
  LEA EDI,[EBX+EDI*4]
  XOR EAX,EAX
  MOVD DWORD PTR [EDI],MM7
  TEST EDI,7
  SETNZ AL
  INC EAX
  LEA EDI,[EDI+EAX*4-4]
  SUB ECX,EAX
  JS @bar32_nomiddle
@bar32_loop1:
  MOVQ [EDI],MM7
  ADD EDI,8
  SUB ECX,2
  JNS @bar32_loop1
@bar32_nomiddle:
  AND ECX,1
  MOVD DWORD PTR [EDI+ECX*4-4],MM7
@pfm32_Lende:
  ADD ESI,8
  DEC EDX
  JNZ @pfm32_loop88

@pfm32_weiter55:
  POP ESI
  POP ECX
  ADD EBX,bytperline
  ADD ESI,linesize
  DEC ECX
  JNZ @pfm32_loop55
@pfm32_weiter66:
@pfm32_ende:
  EMMS
END;

PROCEDURE polygon_flat32_matrox(rend:ppolyrender);assembler;
CONST linesizeld=6;
      linesize=1 SHL linesizeld;
VAR f,num,ofss,{ofsd,}la,px,py,px1,py1,px2,py2,{pxd,}pyd{,lx1,ly1,lx2,ly2}{,lxd,lyd}{,xinc}:longint;
{    la1,la2:longint; }
ASM
  MOV ESI,rend
  MOV EAX,[ESI+0]
  MOV num,EAX
  MOV EAX,[ESI+4]
  MOV ofss,EAX
  MOV EAX,[ESI+8]
  MOV f,EAX

  MOV ESI,ofss
  LODSD
  MOV px1,EAX
  MOV px2,EAX
  LODSD
  MOV py1,EAX
  MOV py2,EAX
  ADD ESI,4

  MOV ECX,num
  DEC ECX
@pfm32_loop11:
  LODSD
  CMP EAX,px1
  JGE @pfm32_w1
  MOV px1,EAX
@pfm32_w1:
  CMP EAX,px2
  JLE @pfm32_w2
  MOV px2,EAX
@pfm32_w2:
  LODSD
  CMP EAX,py1
  JGE @pfm32_w3
  MOV py1,EAX
@pfm32_w3:
  CMP EAX,py2
  JLE @pfm32_w4
  MOV py2,EAX
@pfm32_w4:
  ADD ESI,4
  DEC ECX
  JNZ @pfm32_loop11
{----------}
  MOV EAX,px1
  CMP EAX,vx2
  JG @pfm32_ende
  MOV EAX,py1
  CMP EAX,vy2
  JG @pfm32_ende
  MOV EAX,px2
  CMP EAX,vx1
  JL @pfm32_ende
  MOV EAX,py2
  CMP EAX,vy1
  JL @pfm32_ende
{----------}
  MOV EAX,vy1
  CMP EAX,py1
  JLE @pfm32_w5
  MOV py1,EAX
@pfm32_w5:
  MOV EAX,vy2
  CMP EAX,py2
  JGE @pfm32_w6
  MOV py2,EAX
@pfm32_w6:
  MOV EAX,py2
  SUB EAX,py1
  MOV pyd,EAX
{----------}
  MOV ECX,pyd
  INC ECX
  XOR EAX,EAX
  MOV EDI,graphbuf
@pfm32_loop22:
  MOV [EDI],EAX
  ADD EDI,linesize
  DEC ECX
  JNZ @pfm32_loop22
{----------}
  MOV ESI,ofss
  MOV ECX,num
  LEA EAX,[ECX*4-4]
  LEA EAX,[EAX+EAX*2]
  MOV EBX,[EAX+ESI+0]
  MOV EDI,[EAX+ESI+4]
@pfm32_loop33:
  PUSH ECX
  MOV EAX,[ESI+0]
  MOV ECX,[ESI+4]
  CMP EDI,ECX
  JZ @pfm32_weiter44
  JL @pfm32_weiter22
  XCHG EBX,EAX
  XCHG EDI,ECX
@pfm32_weiter22:
  SUB ECX,EDI
  JLE @pfm32_weiter44
  SHL EBX,16
  SHL EAX,16
  SUB EDI,py1
  SUB EAX,EBX
  CDQ
  IDIV ECX
  OR EDI,EDI
  JGE @pfm32_w4A
  ADD ECX,EDI
  NEG EDI
  IMUL EDI,EAX
  ADD EBX,EDI
  MOV EDI,0
@pfm32_w4A:
  CMP ECX,pyd
  JLE @pfm32_w4B
  MOV ECX,pyd
@pfm32_w4B:
  OR ECX,ECX
  JLE @pfm32_weiter44
  SHL EDI,linesizeld
  ADD EDI,graphbuf
@pfm32_loop44:
  MOV EDX,[EDI]
  CMP EDX,linesize-4
  JAE @pfm32_weiter33
  ADD EDX,4
  MOV [EDI+EDX],EBX
  MOV [EDI],EDX
@pfm32_weiter33:
  ADD EBX,EAX
  ADD EDI,linesize
  DEC ECX
  JNZ @pfm32_loop44
@pfm32_weiter44:
  MOV EBX,[ESI+0]
  MOV EDI,[ESI+4]
  ADD ESI,12
  POP ECX
  DEC ECX
  JNZ @pfm32_loop33
{--- Sortieren und Zeichnen der X-Werte ---}
  MOV ESI,graphbuf

  MOV ECX,pyd
  OR ECX,ECX
  JLE @pfm32_weiter66

  MOV EDI,MMIOoffs
  MOV EAX,f
  MOV [EDI+1C24h],EAX

  MOV EBX,py1
  SHL EBX,16
  OR EBX,1

@pfm32_loop55:
  PUSH ECX
  PUSH ESI
{--- Bubble-Sort ---}
  MOV ECX,[ESI]
  OR ECX,ECX
  JZ @pfm32_weiter55
  PUSH ECX
  ADD ESI,ECX
@pfm32_loop66:
  PUSH ECX
  MOV EAX,[ESI]
  MOV EDI,ESI
@pfm32_loop77:
  MOV EDX,[EDI]
  CMP EAX,EDX
  JGE @pfm32_weiter
  XCHG EAX,EDX
  MOV [ESI],EAX
  MOV [EDI],EDX
@pfm32_weiter:
  SUB EDI,4
  SUB ECX,4
  JNZ @pfm32_loop77
  SUB ESI,4
  POP ECX
  SUB ECX,4
  JNZ @pfm32_loop66
  POP EDX
{---}
  ADD ESI,4
  SHR EDX,3
  MOV EDI,MMIOoffs
@pfm32_loop88:
  MOVSX EAX,WORD PTR [ESI+2]
  MOVSX ECX,WORD PTR [ESI+6]
  CMP EAX,vx2
  JG @pfm32_Lende
  CMP ECX,vx1
  JL @pfm32_Lende
  INC ECX
  MOV [EDI+1CA8h],EAX
  MOV [EDI+1CACh],ECX
  MOV [EDI+1C88h],EBX
  MOV DWORD PTR [EDI+1D00h],000C7844h
@pfm32_Lende:
  ADD ESI,8
  DEC EDX
  JNZ @pfm32_loop88
@pfm32_weiter55:
  POP ESI
  POP ECX
  ADD EBX,00010000h

  ADD ESI,linesize
  DEC ECX
  JNZ @pfm32_loop55
@pfm32_weiter66:
@pfm32_ende:
END;

{=== Z - B U F F E R ===}

PROCEDURE polygon_flatL16Z32(rend:ppolyrender);assembler;
CONST linesizeld=7;
      linesize=1 SHL linesizeld;
VAR f,num,ofss,{ofsd,}la,px,py,px1,py1,px2,py2,{pxd,}pyd{,lx1,ly1,lx2,ly2}{,lxd,lyd}{,xinc},pdoffs:longint;
{    la1,la2:longint; }
    z1,z2,incxy,inczy,inczx,zboffs:longint;
    dwoffs:longint;
    maxx,vx2a1:longint;
ASM
  MOV ESI,rend
  MOV EAX,[ESI+0]
  MOV num,EAX
  MOV EAX,[ESI+4]
  MOV ofss,EAX
  MOV EAX,[ESI+8]
  MOV f,EAX

  MOV EAX,vx2
  INC EAX
  MOV vx2a1,EAX

  MOV ESI,ofss
  LODSD
  MOV px1,EAX
  MOV px2,EAX
  LODSD
  MOV py1,EAX
  MOV py2,EAX
  ADD ESI,4

  MOV ECX,num
  DEC ECX
@pfm16_loop11:
  LODSD
  CMP EAX,px1
  JGE @pfm16_w1
  MOV px1,EAX
@pfm16_w1:
  CMP EAX,px2
  JLE @pfm16_w2
  MOV px2,EAX
@pfm16_w2:
  LODSD
  CMP EAX,py1
  JGE @pfm16_w3
  MOV py1,EAX
@pfm16_w3:
  CMP EAX,py2
  JLE @pfm16_w4
  MOV py2,EAX
@pfm16_w4:
  ADD ESI,4
  DEC ECX
  JNZ @pfm16_loop11
{----------}
  MOV EAX,px1
  CMP EAX,vx2
  JG @pfm16_ende
  MOV EAX,py1
  CMP EAX,vy2
  JG @pfm16_ende
  MOV EAX,px2
  CMP EAX,vx1
  JL @pfm16_ende
  MOV EAX,py2
  CMP EAX,vy1
  JL @pfm16_ende
{----------}
  MOV EAX,vy1
  CMP EAX,py1
  JLE @pfm16_w5
  MOV py1,EAX
@pfm16_w5:
  MOV EAX,vy2
  CMP EAX,py2
  JGE @pfm16_w6
  MOV py2,EAX
@pfm16_w6:
  MOV EAX,py2
  SUB EAX,py1
  MOV pyd,EAX
{----------}
  MOV ECX,pyd
  INC ECX
  MOV EDI,graphbuf
  XOR EAX,EAX
@pfm16_loop22:
  MOV [EDI],EAX
  ADD EDI,linesize
  DEC ECX
  JNZ @pfm16_loop22
{----------}
  MOV EAX,pyd
  INC EAX
  SHL EAX,linesizeld
  ADD EAX,graphbuf
  MOV pdoffs,EAX
{----------}
  MOV ESI,ofss
  MOV ECX,num
  LEA EDI,[ECX*4-4]
  LEA EDI,[EDI+EDI*2]
  ADD EDI,ESI
@pfm16_loop33:
  PUSH ECX
  PUSH ESI

  MOV EDX,[EDI+4]
  MOV ECX,[ESI+4]

  CMP EDX,ECX
  JZ @pfm16_weiter44
  JL @pfm16_weiter22
  XCHG EDX,ECX
  XCHG EDI,ESI
@pfm16_weiter22:
  SUB ECX,EDX
  JLE @pfm16_weiter44

  PUSH EDX

  MOV EBX,[EDI+0]
  MOV EAX,[ESI+0]
  SHL EBX,16
  SHL EAX,16
  SUB EAX,EBX
  CDQ
  IDIV ECX
  MOV incxy,EAX
  MOV EBX,[EDI+0]
  SHL EBX,16

  MOV EDX,[EDI+8]
  MOV EAX,[ESI+8]
{  SHL EDX,16
  SHL EAX,16 }
  SUB EAX,EDX
  CDQ
  IDIV ECX
  MOV inczy,EAX
  MOV EDX,[EDI+8]
{  SHL EDX,16 }

  POP EDI

  SUB EDI,py1
  JNS @pfm16_w4A

  ADD ECX,EDI
  NEG EDI

  MOV EAX,EDI
  IMUL EAX,incxy
  ADD EBX,EAX

  MOV EAX,EDI
  IMUL EAX,inczy
  ADD EDX,EAX

  MOV EDI,0
@pfm16_w4A:

  CMP ECX,pyd
  JLE @pfm16_w4B
  MOV ECX,pyd
@pfm16_w4B:

  OR ECX,ECX
  JLE @pfm16_weiter44


  SHL EDI,linesizeld
  ADD EDI,graphbuf
  MOV ESI,pdoffs
@pfm16_loop44:
  MOV EAX,[EDI]
  CMP EAX,linesize-8
  JAE @pfm16_weiter33
  ADD EAX,8
  MOV [EDI+EAX],EBX
  MOV [EDI+EAX+4],ESI
  MOV [ESI],EDX
  ADD ESI,4
  MOV [EDI],EAX
@pfm16_weiter33:
  ADD EBX,incxy
  ADD EDX,inczy
  ADD EDI,linesize
  DEC ECX
  JNZ @pfm16_loop44
  MOV pdoffs,ESI

@pfm16_weiter44:
  POP ESI
  MOV EDI,ESI
  ADD ESI,12
  POP ECX
  DEC ECX
  JNZ @pfm16_loop33
{--- Sortieren und Zeichnen der X-Werte ---}

  MOV EBX,py1
  MOV ECX,pyd
  OR ECX,ECX
  JLE @pfm16_weiter66

  MOV EAX,EBX
  MUL zbufbytperline
  ADD EAX,zbufoffs
  MOV zboffs,EAX

  MOV EAX,EBX
  MUL bytperline
  ADD EAX,drawoffset
  ADD EAX,LFBoffs
  MOV dwoffs,EAX

  MOV ESI,graphbuf
@pfm16_loop55:
  PUSH ECX
  PUSH ESI
{--- Bubble-Sort ---}
  MOV ECX,[ESI]
  OR ECX,ECX
  JZ @pfm16_weiter55

  PUSH ECX
@pfm16_loop66:
  MOV EBX,ECX
  MOV EAX,[ESI+ECX]
  MOV EDX,[ESI+ECX+4]
@pfm16_loop77:
  CMP EAX,[ESI+EBX]
  JGE @pfm16_weiter
  XCHG EAX,[ESI+EBX]
  XCHG EDX,[ESI+EBX+4]
@pfm16_weiter:
  SUB EBX,8
  JNZ @pfm16_loop77
  MOV [ESI+ECX],EAX
  MOV [ESI+ECX+4],EDX
  SUB ECX,8
  JNZ @pfm16_loop66
  POP EDX
{---}
  ADD ESI,8
  SHR EDX,4
@pfm16_loop88:
  PUSH EDX

  MOVSX EDI,WORD PTR [ESI+2]
  MOVSX ECX,WORD PTR [ESI+10]

  CMP EDI,vx2
  JG @pfm16_Lende
  CMP ECX,vx1
  JL @pfm16_Lende

  MOV EBX,[ESI+4]
  MOV EAX,[ESI+12]
  MOV EBX,[EBX]
  MOV EAX,[EAX]
  SUB ECX,EDI
  SUB EAX,EBX
  INC ECX
  CDQ
  IDIV ECX
  MOV inczx,EAX

  PUSH ESI
  MOV ESI,vx2a1

  CMP EDI,vx1
  JGE @pfm16_Lw2
  NEG EDI
  ADD EDI,vx1
  SUB ECX,EDI
  IMUL EDI
  ADD EBX,EAX
  MOV EDI,vx1
@pfm16_Lw2:

  SUB ESI,EDI

  CMP ECX,ESI
  JLE @pfm16_Lw3
  MOV ECX,ESI
@pfm16_Lw3:

  LEA ESI,[EDI*4]
  LEA EDI,[EDI*2]
  ADD ESI,zboffs
  ADD EDI,dwoffs

  MOV EAX,f
@pf32z16_loopD1:
  CMP EBX,[ESI]
  JL @pf32z16_nopix
  MOV [EDI],AX
  MOV [ESI],EBX
@pf32z16_nopix:
  ADD EDI,2
  ADD ESI,4
  ADD EBX,inczx
  DEC ECX
  JNZ @pf32z16_loopD1


  POP ESI
{  POP EBX }

@pfm16_Lende:
  ADD ESI,16
  POP EDX
  DEC EDX
  JNZ @pfm16_loop88

@pfm16_weiter55:
  POP ESI
  POP ECX
  MOV EAX,zbufbytperline
  MOV EBX,bytperline
  ADD zboffs,EAX
  ADD dwoffs,EBX
  ADD ESI,linesize

  DEC ECX
  JNZ @pfm16_loop55
@pfm16_weiter66:
@pfm16_ende:
END;


PROCEDURE polygon_flatL32Z32(rend:ppolyrender);assembler;
CONST linesizeld=7;
      linesize=1 SHL linesizeld;
VAR f,num,ofss,{ofsd,}la,px,py,px1,py1,px2,py2,{pxd,}pyd{,lx1,ly1,lx2,ly2}{,lxd,lyd}{,xinc},pdoffs:longint;
{    la1,la2:longint; }
    z1,z2,incxy,inczy,inczx,zboffs:longint;
    dwoffs:longint;
    maxx,vx2a1:longint;
ASM
  MOV ESI,rend
  MOV EAX,[ESI+0]
  MOV num,EAX
  MOV EAX,[ESI+4]
  MOV ofss,EAX
  MOV EAX,[ESI+8]
  MOV f,EAX

  MOV EAX,vx2
  INC EAX
  MOV vx2a1,EAX

  MOV ESI,ofss
  LODSD
  MOV px1,EAX
  MOV px2,EAX
  LODSD
  MOV py1,EAX
  MOV py2,EAX
  ADD ESI,4

  MOV ECX,num
  DEC ECX
@pfm32_loop11:
  LODSD
  CMP EAX,px1
  JGE @pfm32_w1
  MOV px1,EAX
@pfm32_w1:
  CMP EAX,px2
  JLE @pfm32_w2
  MOV px2,EAX
@pfm32_w2:
  LODSD
  CMP EAX,py1
  JGE @pfm32_w3
  MOV py1,EAX
@pfm32_w3:
  CMP EAX,py2
  JLE @pfm32_w4
  MOV py2,EAX
@pfm32_w4:
  ADD ESI,4
  DEC ECX
  JNZ @pfm32_loop11
{----------}
  MOV EAX,px1
  CMP EAX,vx2
  JG @pfm32_ende
  MOV EAX,py1
  CMP EAX,vy2
  JG @pfm32_ende
  MOV EAX,px2
  CMP EAX,vx1
  JL @pfm32_ende
  MOV EAX,py2
  CMP EAX,vy1
  JL @pfm32_ende
{----------}
  MOV EAX,vy1
  CMP EAX,py1
  JLE @pfm32_w5
  MOV py1,EAX
@pfm32_w5:
  MOV EAX,vy2
  CMP EAX,py2
  JGE @pfm32_w6
  MOV py2,EAX
@pfm32_w6:
  MOV EAX,py2
  SUB EAX,py1
  MOV pyd,EAX
{----------}
  MOV ECX,pyd
  INC ECX
  MOV EDI,graphbuf
  XOR EAX,EAX
@pfm32_loop22:
  MOV [EDI],EAX
  ADD EDI,linesize
  DEC ECX
  JNZ @pfm32_loop22
{----------}
  MOV EAX,pyd
  INC EAX
  SHL EAX,linesizeld
  ADD EAX,graphbuf
  MOV pdoffs,EAX
{----------}
  MOV ESI,ofss
  MOV ECX,num
  LEA EDI,[ECX*4-4]
  LEA EDI,[EDI+EDI*2]
  ADD EDI,ESI
@pfm32_loop33:
  PUSH ECX
  PUSH ESI

  MOV EDX,[EDI+4]
  MOV ECX,[ESI+4]

  CMP EDX,ECX
  JZ @pfm32_weiter44
  JL @pfm32_weiter22
  XCHG EDX,ECX
  XCHG EDI,ESI
@pfm32_weiter22:
  SUB ECX,EDX
  JLE @pfm32_weiter44

  PUSH EDX

  MOV EBX,[EDI+0]
  MOV EAX,[ESI+0]
  SHL EBX,16
  SHL EAX,16
  SUB EAX,EBX
  CDQ
  IDIV ECX
  MOV incxy,EAX
  MOV EBX,[EDI+0]
  SHL EBX,16

  MOV EDX,[EDI+8]
  MOV EAX,[ESI+8]
{  SHL EDX,16
  SHL EAX,16 }
  SUB EAX,EDX
  CDQ
  IDIV ECX
  MOV inczy,EAX
  MOV EDX,[EDI+8]
{  SHL EDX,16 }

  POP EDI

  SUB EDI,py1
  JNS @pfm32_w4A

  ADD ECX,EDI
  NEG EDI

  MOV EAX,EDI
  IMUL EAX,incxy
  ADD EBX,EAX

  MOV EAX,EDI
  IMUL EAX,inczy
  ADD EDX,EAX

  MOV EDI,0
@pfm32_w4A:

  CMP ECX,pyd
  JLE @pfm32_w4B
  MOV ECX,pyd
@pfm32_w4B:

  OR ECX,ECX
  JLE @pfm32_weiter44


  SHL EDI,linesizeld
  ADD EDI,graphbuf
  MOV ESI,pdoffs
@pfm32_loop44:
  MOV EAX,[EDI]
  CMP EAX,linesize-8
  JAE @pfm32_weiter33
  ADD EAX,8
  MOV [EDI+EAX],EBX
  MOV [EDI+EAX+4],ESI
  MOV [ESI],EDX
  ADD ESI,4
  MOV [EDI],EAX
@pfm32_weiter33:
  ADD EBX,incxy
  ADD EDX,inczy
  ADD EDI,linesize
  DEC ECX
  JNZ @pfm32_loop44
  MOV pdoffs,ESI

@pfm32_weiter44:
  POP ESI
  MOV EDI,ESI
  ADD ESI,12
  POP ECX
  DEC ECX
  JNZ @pfm32_loop33
{--- Sortieren und Zeichnen der X-Werte ---}

  MOV EBX,py1
  MOV ECX,pyd
  OR ECX,ECX
  JLE @pfm32_weiter66

  MOV EAX,EBX
  MUL zbufbytperline
  ADD EAX,zbufoffs
  MOV zboffs,EAX

  MOV EAX,EBX
  MUL bytperline
  ADD EAX,drawoffset
  ADD EAX,LFBoffs
  MOV dwoffs,EAX

  MOV ESI,graphbuf
@pfm32_loop55:
  PUSH ECX
  PUSH ESI
{--- Bubble-Sort ---}
  MOV ECX,[ESI]
  OR ECX,ECX
  JZ @pfm32_weiter55

  PUSH ECX
@pfm32_loop66:
  MOV EBX,ECX
  MOV EAX,[ESI+ECX]
  MOV EDX,[ESI+ECX+4]
@pfm32_loop77:
  CMP EAX,[ESI+EBX]
  JGE @pfm32_weiter
  XCHG EAX,[ESI+EBX]
  XCHG EDX,[ESI+EBX+4]
@pfm32_weiter:
  SUB EBX,8
  JNZ @pfm32_loop77
  MOV [ESI+ECX],EAX
  MOV [ESI+ECX+4],EDX
  SUB ECX,8
  JNZ @pfm32_loop66
  POP EDX
{---}
  ADD ESI,8
  SHR EDX,4
@pfm32_loop88:
  PUSH EDX

  MOVSX EDI,WORD PTR [ESI+2]
  MOVSX ECX,WORD PTR [ESI+10]

  CMP EDI,vx2
  JG @pfm32_Lende
  CMP ECX,vx1
  JL @pfm32_Lende

  MOV EBX,[ESI+4]
  MOV EAX,[ESI+12]
  MOV EBX,[EBX]
  MOV EAX,[EAX]
  SUB ECX,EDI
  SUB EAX,EBX
  INC ECX
  CDQ
  IDIV ECX
  MOV inczx,EAX

  PUSH ESI
  MOV ESI,vx2a1

  CMP EDI,vx1
  JGE @pfm32_Lw2
  NEG EDI
  ADD EDI,vx1
  SUB ECX,EDI
  IMUL EDI
  ADD EBX,EAX
  MOV EDI,vx1
@pfm32_Lw2:

  SUB ESI,EDI

  CMP ECX,ESI
  JLE @pfm32_Lw3
  MOV ECX,ESI
@pfm32_Lw3:

  LEA ESI,[EDI*4]
  LEA EDI,[EDI*4]
  ADD ESI,zboffs
  ADD EDI,dwoffs

  MOV EAX,f
@pf32z16_loopD1:
  CMP EBX,[ESI]
  JL @pf32z16_nopix
  MOV [EDI],EAX
  MOV [ESI],EBX
@pf32z16_nopix:
  ADD EDI,4
  ADD ESI,4
  ADD EBX,inczx
  DEC ECX
  JNZ @pf32z16_loopD1


  POP ESI
{  POP EBX }

@pfm32_Lende:
  ADD ESI,16
  POP EDX
  DEC EDX
  JNZ @pfm32_loop88

@pfm32_weiter55:
  POP ESI
  POP ECX
  MOV EAX,zbufbytperline
  MOV EBX,bytperline
  ADD zboffs,EAX
  ADD dwoffs,EBX
  ADD ESI,linesize

  DEC ECX
  JNZ @pfm32_loop55
@pfm32_weiter66:
@pfm32_ende:
END;

{============================================================================}

PROCEDURE InitGX3D;
BEGIN
  CASE gxcurcol OF
  ig_col8:
    BEGIN
      triangle_flat:=@triangle_flatL8;
      triangle_gouraud:=@triangle_gouraudL8;
      triangle_textured:=@triangle_texturedL8;
{$IFDEF GO32V2}
      IF HWAenabled AND HWAused THEN
        BEGIN
          CASE curinit OF
            ig_matrox:
              BEGIN
                triangle_flat:=@triangle_flat8_matrox;
                triangle_gouraud:=@triangle_gouraud_matrox;
              END;
            ig_s3virge:
              BEGIN
              {  triangle_flat:=triangle_flat8_s3v; }
            {    triangle_gouraud:=triangle_gouraud8_s3v; }
              END;
          END;
        END;
{$ENDIF}
    END;
  ig_col15:
    BEGIN
      triangle_flat:=@triangle_flatL16;
      triangle_gouraud:=@triangle_gouraudL15;
      triangle_textured:=@triangle_texturedL16;
{$IFDEF GO32V2}
      IF HWAenabled AND HWAused THEN
        BEGIN
          CASE curinit OF
            ig_matrox:
              BEGIN
                triangle_flat:=@triangle_flat16_matrox;
                triangle_gouraud:=@triangle_gouraud_matrox;
              END;
            ig_s3virge:
              BEGIN
              {  triangle_flat:=triangle_flat16_s3v; }
            {    triangle_gouraud:=triangle_gouraud15_s3v; }
              END;
          END;
        END;
{$ENDIF}
    END;
  ig_col16:
    BEGIN
      triangle_flat:=@triangle_flatL16;
      triangle_gouraud:=@triangle_gouraudL16;
      triangle_textured:=@triangle_texturedL16;
      polygon_flat:=@polygon_flatL32;
{$IFDEF GO32V2}
      IF HWAenabled AND HWAused THEN
        BEGIN
          CASE curinit OF
            ig_matrox:
              BEGIN
                triangle_flat:=@triangle_flat16_matrox;
                triangle_gouraud:=@triangle_gouraud_matrox;
              END;
            ig_s3virge:
              BEGIN
            {    triangle_flat:=triangle_flat16_s3v; }
            {    triangle_gouraud:=triangle_gouraud16_s3v; }
              END;
          END;
        END;
{$ENDIF}
    END;
  ig_col24:
    BEGIN
      triangle_flat:=@triangle_flatL24;
      triangle_gouraud:=@triangle_gouraudL24;
      triangle_textured:=@triangle_texturedL24;
    END;
  ig_col32:
    BEGIN
      IF mmxavail THEN
        BEGIN
          triangle_flat:=@triangle_flatL32;
          triangle_gouraud:=@triangle_gouraudLM32;
          triangle_textured:=@triangle_texturedL32;
          triangle_textured_perspective:=@triangle_textured_perspectiveFPL32;
          polygon_flat:=@polygon_flatLM32;
        END
      ELSE
        BEGIN
          triangle_flat:=@triangle_flatL32;
          triangle_gouraud:=@triangle_gouraudL32;
          triangle_textured:=@triangle_texturedL32;
          triangle_textured_perspective:=@triangle_textured_perspectiveL32;
          polygon_flat:=@polygon_flatL32;
        END;
{$IFDEF GO32V2}
      IF HWAenabled AND HWAused THEN
        BEGIN
          CASE curinit OF
            ig_matrox:
              BEGIN
                triangle_flat:=@triangle_flat32_matrox;
                triangle_gouraud:=@triangle_gouraud_matrox;
                polygon_flat:=@polygon_flat32_matrox;
              END;
            ig_s3virge:
              BEGIN
            {    triangle_flat:=triangle_flat32_s3v; }
              {  triangle_gouraud:=triangle_gouraud32_s3v; }
              END;
          END;
        END;
{$ENDIF}
    END;
  END;
END;

PROCEDURE InitGX3DZBuffer;
BEGIN
  CASE gxcurcol OF
  ig_col16:
    BEGIN
      IF mmxavail THEN
        BEGIN
          polygon_flat:=@polygon_flatL16Z32;
        END
      ELSE
        BEGIN
          polygon_flat:=@polygon_flatL16Z32;
        END;
    END;
  ig_col32:
    BEGIN
      IF mmxavail THEN
        BEGIN
          polygon_flat:=@polygon_flatL32Z32;
        END
      ELSE
        BEGIN
          polygon_flat:=@polygon_flatL32Z32;
        END;
    END;
  END;
END;

PROCEDURE DoneGX3DZBuffer;
BEGIN
  CASE gxcurcol OF
  ig_col16:
    BEGIN
      IF mmxavail THEN
        BEGIN
          polygon_flat:=@polygon_flatL16;
        END
      ELSE
        BEGIN
          polygon_flat:=@polygon_flatL16;
        END;
    END;
  ig_col32:
    BEGIN
      IF mmxavail THEN
        BEGIN
          polygon_flat:=@polygon_flatLM32;
        END
      ELSE
        BEGIN
          polygon_flat:=@polygon_flatL32;
        END;
    END;
  END;
END;

PROCEDURE graphwin3D(x1,y1,x2,y2:longint);
BEGIN
  v3dx1:=x1 SHL 16;
  v3dy1:=y1 SHL 16;
  v3dx2:=x2 SHL 16;
  v3dy2:=y2 SHL 16;
END;

PROCEDURE maxgraphwin3D;
BEGIN
  graphwin3D(0,0,maxX,maxY);
END;

BEGIN
  RegisterGXUnit(@InitGX3D);
END.

{==========================================================================}

