{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

{============================================================================}
{ cirrus Logic 1000PV, 2000Pv, 2000MT, 2000MI                                   }
{============================================================================}
{$I gxglobal.cfg}
UNIT gxhw_cir;

INTERFACE

USES gxbase,gxpci,gx3dtype,gxsup,gxmem;
{$I gxlocal.cfg}

PROCEDURE sethwaprocs_cirrus(col:longint);
{PROCEDURE setupdevice_cirrus(baseaddr:dword;var pcidev:TPCIdevice);
PROCEDURE adjustaddresses_cirrus(old_ds_base,new_ds_base:dword); }
PROCEDURE setreslist_cirrus(mem,chipid:dword;var modelist:PModeEntry);
FUNCTION detectchip_cirrus(var chipid:dword;var name:string):longint;
FUNCTION detectmem_cirrus:longint;
PROCEDURE enableregs_cirrus;
PROCEDURE disableregs_cirrus;
PROCEDURE setcolormode_cirrus(col:longint);
PROCEDURE scanline_cirrus(linewidth:word);
PROCEDURE displaystart_cirrus_542x(offs:dword);
PROCEDURE displaystart_cirrus_543x(offs:dword);
PROCEDURE bankswitch_cirrus;
PROCEDURE enableLFB_cirrus_pci(physaddr:dword);
PROCEDURE enableLFB_cirrus_542x(physaddr:dword);
PROCEDURE disableLFB_cirrus;
PROCEDURE enableHWA_cirrus(col,init,bpl,bpp,pix:longint);
PROCEDURE disableHWA_cirrus;

IMPLEMENTATION

USES gxcrtext,graphix;

{VAR mmiomap0:tmmiomap;
    mmiomap1:tmmiomap;
    reg_mca:dword;
    option,devid:longint;

PROCEDURE setupdevice_cirrus(baseaddr:dword;var pcidev:TPCIdevice);
BEGIN
END;

PROCEDURE adjustaddresses_cirrus(old_ds_base,new_ds_base:dword);
BEGIN
  adjustaddress(lfbbase,old_ds_base,new_ds_base);
END;}

{----------------------------------------------------------------------------}

FUNCTION detectchip_cirrus(var chipid:dword;var name:string):longint;
VAR chip:byte;
BEGIN
  ASM
    MOV DX,03C4h
    MOV AL,06h
    OUT DX,AL
    INC DX
    XOR AL,AL
    OUT DX,AL
    IN AL,DX
    OR AL,AL
    JZ @cirrus_not_detected
    MOV AL,12h
    OUT DX,AL
    IN AL,DX
    CMP AL,12h
    JNE @cirrus_not_detected
  
    MOV DX,03D4h
    MOV AL,27h
    OUT DX,AL
    INC DX
    IN AL,DX
    AND AX,00FCh
    JMP @ende
  @cirrus_not_detected:
    XOR AX,AX
  @ende:
    MOV chip,AL
  END;
  CASE chip OF
    $00:;
    $8A:name:='Cirrus Logic CL-GD5420';
    $8B:name:='Cirrus Logic CL-GD5420 r1';
    $8C:name:='Cirrus Logic CL-GD5422';
    $90:name:='Cirrus Logic CL-GD5426';
    $94:name:='Cirrus Logic CL-GD5424';
    $98:name:='Cirrus Logic CL-GD5428';
    $9C:name:='Cirrus Logic CL-GD5429';
    $A0:name:='Cirrus Logic CL-GD5430/40';
    $A4:name:='Cirrus Logic CL-GD5434 rev 4';
    $A8:name:='Cirrus Logic CL-GD5434 rev 8';
    $AC:name:='Cirrus Logic CL-GD5436';
    $B8:name:='Cirrus Logic CL-GD5446';
    $BC:name:='Cirrus Logic CL-GD5480';
    $D0:name:='Cirrus Logic CL-GD5462';
    $D4:name:='Cirrus Logic CL-GD5464';
    $D5:name:='Cirrus Logic CL-GD5464 rev BD';
    $D6:name:='Cirrus Logic CL-GD5465';
    $E8:name:='Cirrus Logic CL-GD5436';
    ELSE name:='Cirrus Logic - unknown - ID '+hexbyte(chip);
  END;
  chipid:=chip;
  detectchip_cirrus:=chip;
END;

FUNCTION detectmem_cirrus:longint;
VAR m:byte;
BEGIN
  ASM
    MOV DX,03C4h
    MOV AL,0Fh
    OUT DX,AL
    INC DX
    IN AL,DX
    AND AL,98h
    MOV m,AL
  END;
  CASE m OF
    $08:detectmem_cirrus:=512;
    $88:detectmem_cirrus:=1024;
    $10:detectmem_cirrus:=1024;
    $90:detectmem_cirrus:=2048;
    $18:detectmem_cirrus:=2048;
    $98:detectmem_cirrus:=4096;
  END;
END;

{----------------------------------------------------------------------------}

PROCEDURE enableregs_cirrus;assembler;
ASM
  MOV DX,03C4h
  MOV AX,1206h
  OUT DX,AX

  MOV DX,03CEh
  MOV AL,06h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0F3h
  OR AL,04h
  OUT DX,AL

  MOV DX,03CEh
  MOV AL,0Bh
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0FEh
  OR AL,20h
  OUT DX,AL
END;

PROCEDURE disableregs_cirrus;assembler;
ASM
  MOV DX,03C4h
  MOV AX,0006h
  OUT DX,AX
END;

PROCEDURE setcolormode_cirrus(col:longint);
BEGIN
  IF (col=ig_col15) THEN
    ASM
      MOV DX,03C8h
      IN AL,DX
      MOV DX,03C6h
      IN AL,DX
      IN AL,DX
      IN AL,DX
      IN AL,DX
      MOV AL,0A0h
      OUT DX,AL
      MOV DX,03C8h
      IN AL,DX
    END;
END;


PROCEDURE scanline_cirrus(linewidth:word);assembler;
ASM
{bit 0-7}
  MOV DX,03D4h
  MOV AH,BYTE PTR linewidth
  MOV AL,13h
  OUT DX,AX
{bit 8,9}
  MOV AX,linewidth
  MOV AL,AH
  AND AX,0201h
  SHL AL,4
  SHL AH,5
  OR AH,AL

  MOV AL,1Bh
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0AFh
  OR AL,AH
  OUT DX,AL
END;

PROCEDURE displaystart_cirrus_542x(offs:dword);assembler;
ASM
  MOV EBX,offs
{bit 0-7}
  SHR EBX,2
  MOV DX,03D4h
  MOV AH,BL
  MOV AL,0Dh
  OUT DX,AX
{bit 8-15}
  SHR EBX,8
  MOV DX,03D4h
  MOV AH,BL
  MOV AL,0Ch
  OUT DX,AX
{bit 16,17-18}
  SHR EBX,1
  SHR BL,1
  SHR EBX,2
  SHR BL,4
  AND BL,0Dh
  MOV AL,1Bh
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0F2h
  OR AL,BL
  OUT DX,AL
END;

PROCEDURE displaystart_cirrus_543x(offs:dword);assembler;
ASM
  MOV EBX,offs
{bit 0-7}
  SHR EBX,2
  MOV DX,03D4h
  MOV AH,BL
  MOV AL,0Dh
  OUT DX,AX
{bit 8-15}
  SHR EBX,8
  MOV DX,03D4h
  MOV AH,BL
  MOV AL,0Ch
  OUT DX,AX
{bit 16,17-18}
  SHR EBX,1
  SHR BL,1
  SHR EBX,2
  SHR BL,4
  AND BL,0Dh
  MOV AL,1Bh
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0F2h
  OR AL,BL
  OUT DX,AL
{bit 19}
  SHR EBX,1
  AND BL,80h
  MOV AL,1Dh
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,07Fh
  OR AL,BL
  OUT DX,AL
END;

PROCEDURE bankswitch_cirrus;assembler;
ASM
  MOV AH,DL
  MOV AL,CL
  MOV CL,BYTE PTR bankgran
  SHL AH,CL
  MOV CL,AL
  MOV AL,09h
  MOV DX,03CEh
  OUT DX,AX
END;

PROCEDURE enableLFB_cirrus_pci(physaddr:dword);assembler;
ASM
  MOV DX,03C4h {enable LFB}
  MOV AL,07h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0Fh
  OR AL,80h
  OUT DX,AL
END;

PROCEDURE enableLFB_cirrus_542x(physaddr:dword);assembler;
ASM
  MOV DX,03C4h {enable LFB}
  MOV AL,07h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0Fh
  MOV BL,BYTE PTR [physaddr+2]
  AND BL,0F0h
  OR AL,BL
  OUT DX,AL
END;

PROCEDURE disableLFB_cirrus;assembler;
ASM
  MOV DX,03C4h {disable LFB}
  MOV AL,07h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0Fh
  OUT DX,AL
END;

{------------------------------- Hardware-Acceleration ----------------------}

PROCEDURE enableHWA_cirrus(col,init,bpl,bpp,pix:longint);
VAR COPpixelsize,FrameBufferPitch:byte;
BEGIN
  CASE bpp OF
    1:COPpixelsize:=$04;
    2:COPpixelsize:=$08;
    4:COPpixelsize:=$0C;
  END;
  CASE (bpl DIV bpp) OF
    640:FrameBufferPitch:=$0;
    800:FrameBufferPitch:=$1;
    1024:FrameBufferPitch:=$2;
    1280:FrameBufferPitch:=$4;
    1600:FrameBufferPitch:=$5;
    2048:FrameBufferPitch:=$6;
  END;
  ASM
    MOV DX,03C4h
    MOV AL,11h
    OUT DX,AL
    INC DX
    IN AL,DX
    AND AL,0F3h
    OR AL,COPpixelsize
    OUT DX,AL
    MOV DX,03C4h
    MOV AL,17h
    OUT DX,AL
    INC DX
    IN AL,DX
    AND AL,0F8h
    OR AL,FrameBufferPitch
    OUT DX,AL

    MOV EDI,mmiooffs
    MOV WORD PTR [EDI+1Ah],0FFFFh
    MOV WORD PTR [EDI+1Eh],0FFFFh
  END;
END;

PROCEDURE disableHWA_cirrus;
BEGIN
END;

PROCEDURE graphwinhw_cirrus(x1,y1,x2,y2:longint);assembler;
ASM
  MOV EDI,mmiooffs
  MOV EAX,x1
  MOV [EDI+58h],AX
  MOV EAX,y1
  MOV [EDI+5Ah],AX
  MOV EAX,x2
  MOV [EDI+5Ch],AX
  MOV EAX,y2
  MOV [EDI+5Eh],AX
END;
{
PROCEDURE setpattern_cirrus;assembler;
ASM
  MOV EBX,curpattern
  MOV AL,[EBX+1]
  MOV AH,AL
  SHL EAX,16
  MOV AL,[EBX+0]
  MOV AH,AL
  MOV [EDI+1C30h],EAX
  MOV AL,[EBX+3]
  MOV AH,AL
  SHL EAX,16
  MOV AL,[EBX+2]
  MOV AH,AL
  MOV [EDI+1C34h],EAX
  MOV AL,[EBX+5]
  MOV AH,AL
  SHL EAX,16
  MOV AL,[EBX+4]
  MOV AH,AL
  MOV [EDI+1C38h],EAX
  MOV AL,[EBX+7]
  MOV AH,AL
  SHL EAX,16
  MOV AL,[EBX+6]
  MOV AH,AL
  MOV [EDI+1C3Ch],EAX
END;
}
{----------------------------- line ---------------------------------------}
{
PROCEDURE line_cirrus(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,mmiooffs

  MOV WORD PTR [EDI+18h],0305h
  MOV EAX,f
  MOV [EDI+02h],AX
  SHR EAX,16
  MOV [EDI+06h],AX




  MOV AX,WORD PTR y1
  SHL EAX,16
  MOV AX,WORD PTR x1
  MOV [EDI+1C40h],EAX
  MOV AX,WORD PTR y2
  SHL EAX,16
  MOV AX,WORD PTR x2
  MOV [EDI+1C44h],EAX
  MOV AL,BYTE PTR f
  MOV AH,AL
  SHL EAX,8
  MOV AL,AH
  SHL EAX,8
  MOV AL,AH
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],040C4803h
@line8_cirrus_busy:
  TEST DWORD PTR [EDI+1E14h],00010000h
  JNZ @line8_cirrus_busy
END;
}
{-------------------------------- lineH -------------------------------------}

PROCEDURE lineh_cirrus(x1,x2,y,f:longint);assembler;
ASM
  MOV EDI,mmiooffs
  MOV WORD PTR [EDI+18h],0305h
  MOV EAX,f
  MOV [EDI+02h],AX
  SHR EAX,16
  MOV [EDI+06h],AX

  MOV EAX,x1
  MOV EBX,x2
  CMP EAX,EBX
  JLE @lineh_cirrus_w1
  XCHG EBX,EAX
@lineh_cirrus_w1:
  MOV [EDI+70h],AX
  SUB EBX,EAX
  MOV [EDI+74h],BX

  MOV EAX,y
  MOV [EDI+72h],AX
  MOV WORD PTR [EDI+76h],0000h

  MOV WORD PTR [EDI+7Ch],0000h
  MOV WORD PTR [EDI+7Eh],2800h

{  MOV DX,03CBh
@lineh_cirrus_busy:
  IN AL,DX
  TEST AL,40h
  JNZ @lineh_cirrus_busy }
END;

{-------------------------------- lineH_pattern -----------------------------}
{
PROCEDURE lineH_pattern_cirrus(x1,x2,y,f:longint);assembler;
ASM
END;
}
{-------------------------------- bar -------------------------------------}

PROCEDURE bar_cirrus(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,mmiooffs
  MOV WORD PTR [EDI+18h],0305h
  MOV EAX,f
  MOV [EDI+02h],AX
  SHR EAX,16
  MOV [EDI+06h],AX

  MOV EAX,x1
  MOV EBX,x2
  CMP EAX,EBX
  JLE @bar_cirrus_w1
  XCHG EBX,EAX
@bar_cirrus_w1:
  MOV [EDI+70h],AX
  SUB EBX,EAX
  MOV [EDI+74h],BX

  MOV EAX,y1
  MOV EBX,y2
  CMP EAX,EBX
  JLE @bar_cirrus_w2
  XCHG EAX,EBX
@bar_cirrus_w2:
  MOV [EDI+72h],AX
  SUB EBX,EAX
  MOV [EDI+76h],BX

  MOV WORD PTR [EDI+7Ch],0000h
  MOV WORD PTR [EDI+7Eh],2800h

  MOV DX,03CBh
@bar_cirrus_busy:
  IN AL,DX
  TEST AL,40h
  JNZ @bar_cirrus_busy
END;

{-------------------------------- bar_pattern -------------------------------}
{
PROCEDURE bar_pattern_cirrus(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,mmiooffs
  MOV WORD PTR [EDI+18h],0305h
  MOV EAX,f
  MOV [EDI+02h],AX
  SHR EAX,16
  MOV [EDI+06h],AX

  MOV EAX,x1
  MOV EBX,x2
  CMP EAX,EBX
  JLE @bar_cirrus_w1
  XCHG EBX,EAX
@bar_cirrus_w1:
  MOV [EDI+70h],AX
  SUB EBX,EAX
  MOV [EDI+74h],BX

  MOV EAX,y1
  MOV EBX,y2
  CMP EAX,EBX
  JLE @bar_cirrus_w2
  XCHG EAX,EBX
@bar_cirrus_w2:
  MOV [EDI+72h],AX
  SUB EBX,EAX
  MOV [EDI+76h],BX

  MOV WORD PTR [EDI+7Ch],0001h
  MOV WORD PTR [EDI+7Eh],2C10h

  MOV DX,03CBh
@bar_cirrus_busy:
  IN AL,DX
  TEST AL,40h
  JNZ @bar_cirrus_busy
END;
}
{-------------------------------- barXOR ----------------------------------}

PROCEDURE barxor_cirrus(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,mmiooffs
  MOV WORD PTR [EDI+18h],0605h
  MOV EAX,f
  MOV [EDI+02h],AX
  SHR EAX,16
  MOV [EDI+06h],AX

  MOV EAX,x1
  MOV EBX,x2
  CMP EAX,EBX
  JLE @bar_cirrus_w1
  XCHG EBX,EAX
@bar_cirrus_w1:
  MOV [EDI+70h],AX
  SUB EBX,EAX
  MOV [EDI+74h],BX

  MOV EAX,y1
  MOV EBX,y2
  CMP EAX,EBX
  JLE @bar_cirrus_w2
  XCHG EAX,EBX
@bar_cirrus_w2:
  MOV [EDI+72h],AX
  SUB EBX,EAX
  MOV [EDI+76h],BX

  MOV WORD PTR [EDI+7Ch],0000h
  MOV WORD PTR [EDI+7Eh],2800h

  MOV DX,03CBh
@bar_cirrus_busy:
  IN AL,DX
  TEST AL,40h
  JNZ @bar_cirrus_busy
END;

{-------------------------------- barXOR_pattern ----------------------------}
{
PROCEDURE barXOR_pattern_cirrus(x1,y1,x2,y2,f:longint);assembler;
ASM
END;
}

{------------------------- moverect ---------------------------------------}
{
PROCEDURE moverect_cirrus(x1,y1,x2,y2,x,y:longint);assembler;
ASM
END;
}
{============================================================================}

PROCEDURE setreslist_cirrus(mem,chipid:dword;var modelist:PModeEntry);
BEGIN
  IF (mem>=512) THEN
    BEGIN
      IF chipid IN [$8C..$E8] THEN AddModeToList(modelist,$70,  320, 200,3,  960, $78,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb{+ig_hwa}+ig_col24);
      AddModeToList(modelist,$5F,  640, 480,1,  640, $50,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb{+ig_hwa}+ig_col8);
    END;
  IF (mem>=1024) THEN
    BEGIN
      IF chipid IN [$8C..$E8] THEN AddModeToList(modelist,$66,  640, 480,2, 1280, $A0,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb{+ig_hwa}+ig_col15);
      IF chipid IN [$8C..$E8] THEN AddModeToList(modelist,$64,  640, 480,2, 1280, $A0,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb{+ig_hwa}+ig_col16);
      IF chipid IN [$8C..$E8] THEN AddModeToList(modelist,$71,  640, 480,3, 1920, $F0,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb{+ig_hwa}+ig_col24);
      AddModeToList(modelist,$5C,  800, 600,1,  800, $64,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb{+ig_hwa}+ig_col8);
      IF chipid IN [$8C..$E8] THEN AddModeToList(modelist,$67,  800, 600,2, 1600, $C8,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb{+ig_hwa}+ig_col15);
      IF chipid IN [$8C..$E8] THEN AddModeToList(modelist,$65,  800, 600,2, 1600, $C8,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb{+ig_hwa}+ig_col16);
      AddModeToList(modelist,$60, 1024, 768,1, 1024, $80,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb{+ig_hwa}+ig_col8);
      IF chipid IN [$A0..$E8] THEN AddModeToList(modelist,$5E,  640, 400,1,  640, $50,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb{+ig_hwa}+ig_col8);
    END;
  IF (mem>=2048) THEN
    BEGIN
      AddModeToList(modelist,$78,  800, 600,3, 2400,$12C,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb{+ig_hwa}+ig_col24);
      AddModeToList(modelist,$68, 1024, 768,2, 2048,$100,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb{+ig_hwa}+ig_col15);
      AddModeToList(modelist,$74, 1024, 768,2, 2048,$100,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb{+ig_hwa}+ig_col16);
      AddModeToList(modelist,$6D, 1280,1024,1, 1280, $A0,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb{+ig_hwa}+ig_col8);
      AddModeToList(modelist,$78, 1600,1200,1, 1600, $C8,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb{+ig_hwa}+ig_col8);
      IF chipid IN [$A4..$E8] THEN AddModeToList(modelist,$76,  640, 480,4, 2560,$140,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb{+ig_hwa}+ig_col32);
      IF chipid IN [$A4..$E8] THEN AddModeToList(modelist,$72,  800, 600,4, 3200,$190,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb{+ig_hwa}+ig_col32);
    END;
  IF (mem>=4096) THEN
    BEGIN
      AddModeToList(modelist,$79, 1024, 768,3, 3072,$180,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb{+ig_hwa}+ig_col24);
      AddModeToList(modelist,$73, 1024, 768,4, 4096,$200,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb{+ig_hwa}+ig_col32);
      AddModeToList(modelist,$69, 1280,1024,2, 2560,$140,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb{+ig_hwa}+ig_col15);
      AddModeToList(modelist,$75, 1280,1024,2, 2560,$140,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb{+ig_hwa}+ig_col16);
      AddModeToList(modelist,$77, 1280,1024,3, 3840,$1E0,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb{+ig_hwa}+ig_col24);
    END;
END;

{============================================================================}

PROCEDURE sethwaprocs_cirrus(col:longint);
BEGIN
  graphwinHW:=@graphwinHW_cirrus;
{  line:=@line_cirrus; }
  lineh:=@lineh_cirrus;
  lineh_solid:=@lineh_cirrus;
  bar:=@bar_cirrus;
  bar_solid:=@bar_cirrus;
{  bar_pattern:=@bar_pattern_cirrus; }
  barxor:=@barxor_cirrus;
  barxor_solid:=@barxor_cirrus;
END;


END.
