{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

{$ASMMODE intel}
UNIT gxdemo1;

INTERFACE

PROCEDURE GraphixDemo1(background:pointer);

IMPLEMENTATION

USES gxcrt,dos,gxcrtext,graphix,gximg,gxtext,gx3d,gx3dtype,gxmouse,gxtype,gximeff;

CONST xc=0;
      yc=0;
      zc=1000;
      size:longint=20;

      rt_flat=0;
      rt_gouraud=1;
      rt_textured=2;

TYPE
     float=single;

     TPoint3Df=RECORD
       x,y,z:float;
     END;

     TObjIdx=array[0..5] of longint;

     TObjPts=^TPoint3D;
     TObjPtsf=^TPoint3Df;
     TObjTcs=^TPoint2D;
     TObjDat=^TObjIdx;

     TPoint3D4a=array[1..4] of TPoint3D;
     TObjDraw=^TPoint3D4a;
     TObjD=^longint;

VAR ObjPtsNr:dword;
    ObjDatNr:dword;
    ObjDraw:TObjDraw;
    ObjD,ObjNo:TObjD;
    ObjNewPts:TObjPtsf;
    ObjPts,ObjPtsDraw:TObjPts;
    ObjTcs:TObjTcs;
    ObjDat:TObjDat;
    ObjTcsAvail:boolean;

    wx,wy{,wz}:real;
    mx,my,ty:longint;
    texture,bg:pointer;
    fntcol,bgcol:longint;
    bckgrnd,waitretrace:boolean;
    render:prender;
    usetexcoords:boolean;
    disptext:boolean;
    texsiz:longint;

    fc:dword;
    time:longint;
    ft1,ft2:pfontfnt;
    fps:dword;
    info:string;
    triangle:triangle_renderproc;
    rtype:longint;
    ci,cii:longint;


FUNCTION zeit:longint;
VAR st,mi,se,hs:word;
BEGIN
  gettime(st,mi,se,hs);
  zeit:=(longint(st)*3600+mi*60+se)*100+hs;
END;

{---------------------------------------------------------------------}

FUNCTION shar(v,s:longint):longint;assembler;
ASM
  MOV ECX,s
  MOV EAX,v
  SAR EAX,CL
END;

{---------------------------------------------------------------------}

PROCEDURE Init_3D_Object(pts,dat:dword);
BEGIN
  ObjPtsNr:=pts;
  ObjDatNr:=dat;
  getmem(ObjD,(ObjDatNr+1)*sizeof(longint));
  getmem(ObjNo,(ObjDatNr+1)*sizeof(longint));
  getmem(ObjPts,(ObjPtsNr+1)*sizeof(TPoint3D));
  getmem(ObjTcs,(ObjPtsNr+1)*sizeof(TPoint2D));
  getmem(ObjNewPts,(ObjPtsNr+1)*sizeof(TPoint3Df));
  getmem(ObjPtsDraw,(ObjPtsNr+1)*sizeof(TPoint3D));
  getmem(ObjDat,(ObjDatNr+1)*sizeof(TObjIdx));
  getmem(ObjDraw,(ObjDatNr+1)*4*sizeof(TPoint3D));
END;

PROCEDURE Destroy_3D_Object;
BEGIN
  freemem(ObjD,(ObjDatNr+1)*sizeof(longint));
  freemem(ObjNo,(ObjDatNr+1)*sizeof(longint));
  freemem(ObjPts,(ObjPtsNr+1)*sizeof(TPoint3D));
  freemem(ObjTcs,(ObjPtsNr+1)*sizeof(TPoint2D));
  freemem(ObjNewPts,(ObjPtsNr+1)*sizeof(TPoint3Df));
  freemem(ObjPtsDraw,(ObjPtsNr+1)*sizeof(TPoint3D));
  freemem(ObjDat,(ObjDatNr+1)*sizeof(TObjIdx));
  freemem(ObjDraw,(ObjDatNr+1)*4*sizeof(TPoint3D));
END;

PROCEDURE CreateCube(d:longint);
BEGIN
  Init_3D_Object(8,12);
  ObjPts[1].x:=d;
  ObjPts[1].y:=d;
  ObjPts[1].z:=d;
  ObjPts[2].x:=-d;
  ObjPts[2].y:=d;
  ObjPts[2].z:=d;
  ObjPts[3].x:=-d;
  ObjPts[3].y:=-d;
  ObjPts[3].z:=d;
  ObjPts[4].x:=d;
  ObjPts[4].y:=-d;
  ObjPts[4].z:=d;
  ObjPts[5].x:=d;
  ObjPts[5].y:=d;
  ObjPts[5].z:=-d;
  ObjPts[6].x:=-d;
  ObjPts[6].y:=d;
  ObjPts[6].z:=-d;
  ObjPts[7].x:=-d;
  ObjPts[7].y:=-d;
  ObjPts[7].z:=-d;
  ObjPts[8].x:=d;
  ObjPts[8].y:=-d;
  ObjPts[8].z:=-d;

  ObjDat[1,0]:=3;
  ObjDat[1,1]:=1;
  ObjDat[1,2]:=2;
  ObjDat[1,3]:=4;
  ObjDat[1,5]:=0;
  ObjDat[2,0]:=3;
  ObjDat[2,1]:=2;
  ObjDat[2,2]:=3;
  ObjDat[2,3]:=4;
  ObjDat[2,5]:=1;

  ObjDat[3,0]:=3;
  ObjDat[3,1]:=1;
  ObjDat[3,2]:=5;
  ObjDat[3,3]:=2;
  ObjDat[3,5]:=0;
  ObjDat[4,0]:=3;
  ObjDat[4,1]:=5;
  ObjDat[4,2]:=6;
  ObjDat[4,3]:=2;
  ObjDat[4,5]:=1;

  ObjDat[5,0]:=3;
  ObjDat[5,1]:=2;
  ObjDat[5,2]:=6;
  ObjDat[5,3]:=3;
  ObjDat[5,5]:=0;
  ObjDat[6,0]:=3;
  ObjDat[6,1]:=6;
  ObjDat[6,2]:=7;
  ObjDat[6,3]:=3;
  ObjDat[6,5]:=1;

  ObjDat[7,0]:=3;
  ObjDat[7,1]:=3;
  ObjDat[7,2]:=7;
  ObjDat[7,3]:=4;
  ObjDat[7,5]:=0;
  ObjDat[8,0]:=3;
  ObjDat[8,1]:=7;
  ObjDat[8,2]:=8;
  ObjDat[8,3]:=4;
  ObjDat[8,5]:=1;

  ObjDat[9,0]:=3;
  ObjDat[9,1]:=4;
  ObjDat[9,2]:=8;
  ObjDat[9,3]:=1;
  ObjDat[9,5]:=0;
  ObjDat[10,0]:=3;
  ObjDat[10,1]:=8;
  ObjDat[10,2]:=5;
  ObjDat[10,3]:=1;
  ObjDat[10,5]:=1;

  ObjDat[11,0]:=3;
  ObjDat[11,1]:=5;
  ObjDat[11,2]:=8;
  ObjDat[11,3]:=6;
  ObjDat[11,5]:=0;
  ObjDat[12,0]:=3;
  ObjDat[12,1]:=8;
  ObjDat[12,2]:=7;
  ObjDat[12,3]:=6;
  ObjDat[12,5]:=1;

  ObjTcsAvail:=FALSE;
END;

PROCEDURE CreateTorus(e1,e2,d1,d2,ts:longint);
VAR x1,y1,x2,y2,i,j,txs:longint;
BEGIN
  txs:=1 SHL ts;
  Init_3D_Object((e1+1)*(e2+1),e1*e2*2);
  FOR i:=0 TO e1 DO
    BEGIN
      FOR j:=0 TO e2 DO
        BEGIN
          x2:=trunc(sin(2*j*pi/e2+pi/e2)*d2);
          y2:=trunc(cos(2*j*pi/e2+pi/e2)*d2);
          x1:=trunc(sin(2*i*pi/e1)*(d1+x2));
          y1:=trunc(cos(2*i*pi/e1)*(d1+x2));
          ObjPts[i*(e2+1)+j+1].x:=x1;
          ObjPts[i*(e2+1)+j+1].y:=y1;
          ObjPts[i*(e2+1)+j+1].z:=y2;
        END;
    END;

  FOR i:=0 TO e1 DO
    BEGIN
      FOR j:=0 TO e2 DO
        BEGIN
          x1:=((4*i*txs) DIV e1);
          y1:=((2*j*txs) DIV e2);
          ObjTcs[i*(e2+1)+j+1].x:=x1;
          ObjTcs[i*(e2+1)+j+1].y:=y1;
        END;
    END;


  FOR i:=0 TO e1-1 DO
    FOR j:=0 TO e2-1 DO
      BEGIN
        ObjDat[i*e2*2+j+1,0]:=3;
        ObjDat[i*e2*2+j+1,3]:=i*(e2+1)+j+1;
        ObjDat[i*e2*2+j+1,2]:=i*(e2+1)+j+2;
        ObjDat[i*e2*2+j+1,1]:=i*(e2+1)+j+e2+3;
        ObjDat[i*e2*2+j+1,5]:=1;

        ObjDat[i*e2*2+e2+j+1,0]:=3;
        ObjDat[i*e2*2+e2+j+1,3]:=i*(e2+1)+j+1;
        ObjDat[i*e2*2+e2+j+1,2]:=i*(e2+1)+j+e2+3;
        ObjDat[i*e2*2+e2+j+1,1]:=i*(e2+1)+j+e2+2;
        ObjDat[i*e2*2+e2+j+1,5]:=0;
      END;
  ObjTcsAvail:=TRUE;
END;

{
PROCEDURE CreateKonus(e1,d1,d2,h1,h,h2:longint);
VAR x1,y1,x2,y2,i:longint;
BEGIN
  Init_3D_Object((e1+2)*2,e1*4);
  FOR i:=0 TO e1 DO
    BEGIN
      x1:=trunc(sin(2*i*pi/e1)*d1);
      y1:=trunc(cos(2*i*pi/e1)*d1);
      x2:=trunc(sin(2*i*pi/e1)*d2);
      y2:=trunc(cos(2*i*pi/e1)*d2);


      ObjPts[i+2].x:=x1;
      ObjPts[i+2].y:=h DIV 2;
      ObjPts[i+2].z:=y1;
      ObjPts[e1+i+4].x:=x2;
      ObjPts[e1+i+4].y:=-h DIV 2;
      ObjPts[e1+i+4].z:=y2;
    END;
  ObjPts[1].x:=0;
  ObjPts[1].y:=h DIV 2+h1;
  ObjPts[1].z:=0;
  ObjPts[e1+3].x:=0;
  ObjPts[e1+3].y:=-h DIV 2-h2;
  ObjPts[e1+3].z:=0;

  FOR i:=0 TO e1-1 DO
    BEGIN
      ObjDat[i+1,0]:=3;
      ObjDat[i+1,1]:=1;
      ObjDat[i+1,2]:=i+2;
      ObjDat[i+1,3]:=i+3;

      ObjDat[e1+i+1,0]:=3;
      ObjDat[e1+i+1,1]:=e1+3;
      ObjDat[e1+i+1,2]:=e1+i+5;
      ObjDat[e1+i+1,3]:=e1+i+4;


      ObjDat[2*e1+i*2+1,0]:=3;
      ObjDat[2*e1+i*2+1,1]:=i+3;
      ObjDat[2*e1+i*2+1,2]:=i+2;
      ObjDat[2*e1+i*2+1,3]:=e1+i+4;

      ObjDat[2*e1+i*2+2,0]:=3;
      ObjDat[2*e1+i*2+2,1]:=e1+i+4;
      ObjDat[2*e1+i*2+2,2]:=e1+i+5;
      ObjDat[2*e1+i*2+2,3]:=i+3;
    END;
  ObjTcsAvail:=FALSE;
END;
}

PROCEDURE CreateSphere(r,grid,ts:longint);
VAR i,j:longint;
    r1,r2:longint;
    e1,e2,e2a:longint;
BEGIN
  e1:=grid;
  e2:=e1*2;
  e2a:=e2+1;
  Init_3D_Object(e2a*e1+2,e2*2*(e1-1)+2*e2);

  ObjPts[1].x:=0;
  ObjPts[1].y:=-r;
  ObjPts[1].z:=0;
  FOR j:=0 TO (e1-1) DO
    BEGIN
      r1:=-trunc(sin(pi*(j+1)/(e1+1))*r);
      r2:=-trunc(cos(pi*(j+1)/(e1+1))*r);
      FOR i:=0 TO e2 DO
        BEGIN
          ObjPts[2+j*e2a+i].x:=trunc(sin(2*pi*i/e2)*r1);
          ObjPts[2+j*e2a+i].y:=r2;
          ObjPts[2+j*e2a+i].z:=trunc(cos(2*pi*i/e2)*r1);
        END;
    END;
  ObjPts[2+e1*e2a].x:=0;
  ObjPts[2+e1*e2a].y:=r;
  ObjPts[2+e1*e2a].z:=0;

  ObjTcs[1].x:=1 SHL (ts-1);
  ObjTcs[1].y:=0;
  FOR j:=0 TO (e1-1) DO
    BEGIN
 {     r1:=-trunc(sin(pi*(j+1)/(e1+1))*(texsiz SHR 5)); }
  {    r2:=-trunc(cos(pi*(j+1)/(e1+1))*(1 SHL (ts-1))); }
      FOR i:=0 TO e2 DO
        BEGIN
          ObjTcs[2+j*e2a+i].x:=(longint(i)*(1 SHL ts)) DIV e2;
          ObjTcs[2+j*e2a+i].y:={(1 SHL (ts-1))+r2}(longint(j+1)*(1 SHL ts)) DIV (e1+1);
       {   circlefill(ObjTcs[2+j*e2a+i].x,ObjTcs[2+j*e2a+i].y,5,$00FFFF); }
        END;
    END;
  ObjTcs[2+e1*e2a].x:=1 SHL (ts-1);
  ObjTcs[2+e1*e2a].y:=1 SHL ts;
  ObjTcsAvail:=TRUE;

  FOR i:=0 TO (e2-1) DO
    BEGIN
      ObjDat[1+i,0]:=3;
      ObjDat[1+i,1]:=1;
      ObjDat[1+i,2]:=2+i+1;
      ObjDat[1+i,3]:=2+i;
      ObjDat[1+i,5]:=0;
    END;
  FOR j:=0 TO (e1-2) DO
    FOR i:=0 TO (e2-1) DO
      BEGIN
        ObjDat[1+e2+j*e2*2+i*2,0]:=3;
        ObjDat[1+e2+j*e2*2+i*2,1]:=2+j*e2a+i;
        ObjDat[1+e2+j*e2*2+i*2,2]:=2+j*e2a+i+1;
        ObjDat[1+e2+j*e2*2+i*2,3]:=2+(j+1)*e2a+i;
        ObjDat[1+e2+j*e2*2+i*2,5]:=0;

        ObjDat[1+e2+j*e2*2+i*2+1,0]:=3;
        ObjDat[1+e2+j*e2*2+i*2+1,1]:=2+j*e2a+i+1;
        ObjDat[1+e2+j*e2*2+i*2+1,2]:=2+(j+1)*e2a+i+1;
        ObjDat[1+e2+j*e2*2+i*2+1,3]:=2+(j+1)*e2a+i;
        ObjDat[1+e2+j*e2*2+i*2+1,5]:=1;
      END;
  FOR i:=0 TO (e2-1) DO
    BEGIN
      ObjDat[(e1-2)*e2*2+e2+(e2-1)*2+3+i,0]:=3;
      ObjDat[(e1-2)*e2*2+e2+(e2-1)*2+3+i,1]:=2+e1*e2a;
      ObjDat[(e1-2)*e2*2+e2+(e2-1)*2+3+i,2]:=2+(e1-1)*e2a+i;
      ObjDat[(e1-2)*e2*2+e2+(e2-1)*2+3+i,3]:=3+(e1-1)*e2a+i;
      ObjDat[(e1-2)*e2*2+e2+(e2-1)*2+3+i,5]:=0;
    END;
END;

{PROCEDURE LoadFCE(datei:string;zoom:longint);
VAR pts,dat,i,nr,w:word;
    FCE:text;
    s:string;
    r:real;
BEGIN
  assign(FCE,datei);
  reset(FCE);
  pts:=0;
  dat:=0;
  REPEAT
     readln(FCE,s);
    IF (s='[POINT]') THEN inc(pts);
    IF (s='[FACE]') THEN inc(dat);
  UNTIL (s='[END]') OR eof(FCE);
  reset(FCE);
  Init_3D_Object(pts,dat);
  pts:=0;
  dat:=0;
  REPEAT
    readln(FCE,s);
    IF (s='[POINT]') THEN
      BEGIN
        inc(pts);
        readln(FCE,r);
        ObjPts[pts].x:=round(r*zoom);
        readln(FCE,r);
        ObjPts[pts].y:=round(r*zoom);
        readln(FCE,r);
        ObjPts[pts].z:=round(r*zoom);
      END;
    IF (s='[FACE]') THEN
      BEGIN
        inc(dat);
        readln(FCE,nr);
        IF (nr<3) THEN nr:=3;
        IF (nr>4) THEN nr:=4;
        ObjDat[dat,0]:=nr;
        FOR i:=1 TO nr DO
          BEGIN
            readln(FCE,w);
            ObjDat[dat,i]:=w+1;
          END;
        ObjDat[dat,5]:=dat;
      END;
  UNTIL (s='[END]') OR eof(FCE);
  close(FCE);
END;  }

PROCEDURE QSort_ObjD(l,r:longint);
VAR i,j,x,h:longint;
BEGIN
  i:=l;
  j:=r;
  x:=ObjD[(l+r) DIV 2];
  REPEAT
    WHILE (ObjD[i]<x) DO inc(i);
    WHILE (x<ObjD[j]) DO dec(j);
    IF (i<=j) THEN
      BEGIN
        h:=ObjD[i];
        ObjD[i]:=ObjD[j];
        ObjD[j]:=h;
        h:=ObjNo[i];
        ObjNo[i]:=ObjNo[j];
        ObjNo[j]:=h;
        inc(i);
        dec(j);
      END;
  UNTIL (i>j);
  IF (l<j) THEN QSort_ObjD(l,j);
  IF (i<r) THEN QSort_ObjD(i,r);
END;

{CONST light:array[0..2] of double=(0.577350269,0.577350269,0.577350269);}
CONST light:array[0..2] of double=(0,0,1);

{FUNCTION CalcLight(x,y,z,x1,y1,z1,x2,y2,z2:longint):byte;}
FUNCTION CalcLight(var p,p1,p2:TPoint3Df):double;
VAR v1x,v1y,v1z,v2x,v2y,v2z,nx,ny,nz,ln,w,cosphi:double;
BEGIN
  v1x:=p1.x-p.x;
  v1y:=p1.y-p.y;
  v1z:=p1.z-p.z;

  v2x:=p2.x-p.x;
  v2y:=p2.y-p.y;
  v2z:=p2.z-p.z;

  nx:= (v1y*v2z-v1z*v2y);
  ny:=-(v1x*v2z-v1z*v2x);
  nz:= (v1x*v2y-v1y*v2x);

  ln:=sqrt(nx*nx+ny*ny+nz*nz);
  w:=(nx*light[0])+(ny*light[1])+(nz*light[2]);
  cosphi:=w/ln;
  IF (cosphi<0) THEN cosphi:=0;
  IF (cosphi>1) THEN cosphi:=1;
  calclight:=cosphi;
END;

CONST ps=1024;

VAR palette:array[0..ps-1,0..2] of byte;

PROCEDURE createpalette;
VAR r,g,b,rr,rg,rb:longint;
    i:word;
BEGIN
  randomize;
  r:=random(256);
  g:=random(256);
  b:=random(256);
  rr:=1;
  rg:=1;
  rb:=1;
  FOR i:=0 TO ps-1 DO
    BEGIN
    palette[i,0]:=r;
    palette[i,1]:=g;
    palette[i,2]:=b;
   {    palette[i]:=rgbcolorRGB(r,g,b);}
    inc(r,rr);
    inc(g,rg);
    inc(b,rb);
    IF (r>255) THEN
      BEGIN
        r:=255;
        rr:=-1-random(5);
      END;
    IF (r<0) THEN
      BEGIN
        r:=0;
        rr:=+1+random(5);
      END;
    IF (g>255) THEN
      BEGIN
        g:=255;
        rg:=-1-random(5);
      END;
    IF (g<0) THEN
      BEGIN
        g:=0;
        rg:=+1+random(5);
      END;
    IF (b>255) THEN
      BEGIN
        b:=255;
        rb:=-1-random(5);
      END;
    IF (b<0) THEN
      BEGIN
        b:=0;
        rb:=+1+random(5);
      END;
  END;
END;

{FUNCTION zalpha(z:longint):longint;
BEGIN
  IF (z>255) THEN zalpha:=$FF000000;
  IF (z<=255) THEN zalpha:=longint(z) SHL 24;
  IF (z<0) THEN zalpha:=0;
END;}

VAR sinwx,sinwy,coswx,coswy:float;

PROCEDURE Calculate;
VAR x1,y1,z1:float;
    i:longint;
BEGIN
  sinwx:=sin(wx);
  sinwy:=sin(wy);
  coswx:=cos(wx);
  coswy:=cos(wy);

  FOR i:=1 TO ObjPtsNr DO
    BEGIN
      x1:=ObjPts[i].x;
      y1:=ObjPts[i].y;
      z1:=ObjPts[i].z;
      ObjNewPts[i].x:=x1;
      ObjNewPts[i].y:=y1*coswx-z1*sinwx;
      ObjNewPts[i].z:=y1*sinwx+z1*coswx;
    END;
  FOR i:=1 TO ObjPtsNr DO
    BEGIN
      x1:=ObjNewPts[i].x;
      y1:=ObjNewPts[i].y;
      z1:=ObjNewPts[i].z;
      ObjNewPts[i].x:=x1*coswy+z1*sinwy;
      ObjNewPts[i].y:=y1;
      ObjNewPts[i].z:=-x1*sinwy+z1*coswy;
    END;
{  FOR i:=1 TO ObjPtsNr DO
    BEGIN
      x1:=ObjNewPts[i].x;
      y1:=ObjNewPts[i].y;
      z1:=ObjNewPts[i].z;
      x2:=(x1*coswy+z1*sinwy) SHR 16;
      y2:=y1;
      z2:=(-x1*sinwy+z1*coswy) SHR 16;
      ObjNewPts[i].x:=x2;
      ObjNewPts[i].y:=(y2*coswx+z2*sinwx) SHR 16;
      ObjNewPts[i].z:=(-y2*sinwx+z2*coswx) SHR 16;
    END;   }
END;

PROCEDURE Draw;
VAR i,j,idx,nr,ix1,ix2,ix3:longint;
    x,y,z,c:longint;
    l:double;
    col:array[0..2] of byte;
BEGIN
  IF bckgrnd THEN putimage(0,0,bg) ELSE bar(0,0,getmaxX,getmaxY,bgcol);
  FOR i:=1 TO ObjPtsNr DO
    BEGIN
      x:=trunc(ObjNewPts[i].x);
      y:=trunc(ObjNewPts[i].y);
      z:=trunc(ObjNewPts[i].z);
      ObjPtsDraw[i].x:=mx+(xc*z-x*size) DIV (z-zc);
      ObjPtsDraw[i].y:=my+(yc*z-y*size) DIV (z-zc);
      ObjPtsDraw[i].z:=z-zc;
    END;
  FOR i:=1 TO ObjDatNr DO
    BEGIN
      ObjD[i]:=0;
      ObjNo[i]:=i;
      nr:=ObjDat[i,0];
      FOR j:=1 TO nr DO
        WITH ObjPtsDraw[ObjDat[i,j]] DO
          BEGIN
            ObjDraw[i,j].x:=x;
            ObjDraw[i,j].y:=y;
            ObjDraw[i,j].z:=z;
            ObjD[i]:=ObjD[i]+z;
          END;
      ObjD[i]:=ObjD[i] DIV nr;
    END;

  QSort_ObjD(1,ObjDatNr);

{  directvideo:=FALSE;
  textcolor(15);
  writeln(ObjD[1],' ',ObjD[ObjDatNr]);
  readkey;  }

  FOR i:=1 TO ObjDatNr DO
    BEGIN
      idx:=ObjNo[i];
   {   Polygon(ObjDraw[idx],ObjDat[idx,0],ObjDat[idx,5]); }
  {    Triangle(ObjDraw[idx],ObjDat[idx,5]); }
      c:=(ObjDraw[idx,1].x-ObjDraw[idx,2].x)*(ObjDraw[idx,3].y-ObjDraw[idx,2].y)-
         (ObjDraw[idx,1].y-ObjDraw[idx,2].y)*(ObjDraw[idx,3].x-ObjDraw[idx,2].x);
  {    (x1-x2)*(y3-y2)-(y1-y2)*(x3-x2) }
      IF (c<=0) THEN
        BEGIN
          WITH render^ DO
            BEGIN
              ix1:=ObjDat[idx,1];
              ix2:=ObjDat[idx,2];
              ix3:=ObjDat[idx,3];
              points[0].x:=ObjDraw[idx,1].x;
              points[0].y:=ObjDraw[idx,1].y;
              points[0].z:=ObjDraw[idx,1].z;
              points[1].x:=ObjDraw[idx,2].x;
              points[1].y:=ObjDraw[idx,2].y;
              points[1].z:=ObjDraw[idx,2].z;
              points[2].x:=ObjDraw[idx,3].x;
              points[2].y:=ObjDraw[idx,3].y;
              points[2].z:=ObjDraw[idx,3].z;
              CASE rtype OF
              rt_flat:
                BEGIN
                  l:=calclight(ObjNewPts[ix1],ObjNewPts[ix2],ObjNewPts[ix3]);
                  colors[0]:=rgbcolorRGB(trunc(palette[ci,0]*l),trunc(palette[ci,1]*l),trunc(palette[ci,2]*l));
                  triangle:=triangle_flat;
                END;
              rt_gouraud:
                BEGIN
                  l:=calclight(ObjNewPts[ix1],ObjNewPts[ix2],ObjNewPts[ix3]);
                  col:=palette[trunc(abs(ObjNewPts[ix1].z))];
                  colors[0]:=rgbcolorRGB(trunc(col[0]*l),trunc(col[1]*l),trunc(col[2]*l));
                  col:=palette[trunc(abs(ObjNewPts[ix2].z))];
                  colors[1]:=rgbcolorRGB(trunc(col[0]*l),trunc(col[1]*l),trunc(col[2]*l));
                  col:=palette[trunc(abs(ObjNewPts[ix3].z))];
                  colors[2]:=rgbcolorRGB(trunc(col[0]*l),trunc(col[1]*l),trunc(col[2]*l));
                  triangle:=triangle_gouraud;
                END;
              rt_textured:
                BEGIN
                  texturesize:=texsiz;
                  IF usetexcoords THEN
                    BEGIN
                      texcoords[0].x:=ObjTcs[ix1].x;
                      texcoords[0].y:=ObjTcs[ix1].y;
                      texcoords[1].x:=ObjTcs[ix2].x;
                      texcoords[1].y:=ObjTcs[ix2].y;
                      texcoords[2].x:=ObjTcs[ix3].x;
                      texcoords[2].y:=ObjTcs[ix3].y;
                    END
                  ELSE
                    BEGIN
                      CASE ObjDat[idx,5] OF
                        0:BEGIN
                            texcoords[0].x:=0;
                            texcoords[0].y:=0;
                            texcoords[1].x:=(1 SHL texturesize)-1;
                            texcoords[1].y:=0;
                            texcoords[2].x:=0;
                            texcoords[2].y:=(1 SHL texturesize)-1;
                          END;
                        1:BEGIN
                            texcoords[0].x:=(1 SHL texturesize)-1;
                            texcoords[0].y:=0;
                            texcoords[1].x:=(1 SHL texturesize)-1;
                            texcoords[1].y:=(1 SHL texturesize)-1;
                            texcoords[2].x:=0;
                            texcoords[2].y:=(1 SHL texturesize)-1;
                          END;
                      END;
                    END;
                  triangle:=triangle_textured;
                END;
              END;
            END;
          render^.texture:=texture;
          triangle(render);
        END;
    END;
  ft1^.outtext(getmaxX-60,ty,long2str(fps),fntcol);
  ft2^.outtext(getmaxX-80,ty+5,'fps',fntcol);
  IF disptext THEN
    BEGIN
      ft2^.outtext(10,getmaxY-20,info,fntcol);
      ft2^.outtext(10,ty+0,'<B>  background',fntcol);
      ft2^.outtext(10,ty+10,'<D>  Text on/off',fntcol);
      ft2^.outtext(10,ty+20,'<F>  flat shading',fntcol);
      ft2^.outtext(10,ty+30,'<G>  gouraud shading',fntcol);
{      ft2^.outtext(10,ty+40,'<T>  texture mapping',fntcol); }
      ft2^.outtext(10,ty+50,'<C>  change colors',fntcol);
      ft2^.outtext(10,ty+60,'<P>  pause',fntcol);
      ft2^.outtext(10,ty+70,'<R>  retrace',fntcol);
      ft2^.outtext(10,ty+80,'<W>  wrap texture',fntcol);
      ft2^.outtext(10,ty+90,'<+>/Left Button  increase size',fntcol);
      ft2^.outtext(10,ty+100,'<->/Right Button  decrease size',fntcol);
      ft2^.outtext(10,ty+110,'<1>  8/4 edge Torus',fntcol);
      ft2^.outtext(10,ty+120,'<2>  round Torus',fntcol);
      ft2^.outtext(10,ty+130,'<3>  Cube',fntcol);
      ft2^.outtext(10,ty+140,'<4>  Sphere',fntcol);
      ft2^.outtext(10,ty+150,'ESC  Exit',fntcol);
    END;
  FlipSurface(waitretrace);

  inc(ci,cii);
  IF (ci=0) THEN cii:=+1;
  IF (ci=ps-1) THEN cii:=-1;
END;

PROCEDURE InfoStr;
BEGIN
  info:=gxcurresname+'x'+gxcurcolname+' - ';
  IF LFBenabled THEN info:=info+'Linear Frame Buffer' ELSE info:=info+'Banked Frame Buffer';
  IF MFBused THEN info:=info+', Backbuffer' ELSE info:=info+', Double-Buffer';
  IF HWAused THEN info:=info+', Hardware Acceleration' ELSE info:=info+', Software';
END;

VAR ch:char;

PROCEDURE LoadTexture(ts:dword;f:string;var p:pimage);
VAR i:pimage;
BEGIN
  p:=createimageWH(dword(1) SHL ts,dword(1) SHL ts);
  LoadImageFile(itJPG,f,i,0);
  scaleimage(p,i);
  DestroyImage(i);
END;

PROCEDURE GraphixDemo1(background:pointer);
BEGIN
  new(render);
  bg:=background;
  bckgrnd:=TRUE;
  waitretrace:=TRUE;
  usetexcoords:=FALSE;
  disptext:=TRUE;
  fntcol:=rgbcolorRGB(255,255,255);
  bgcol:=rgbcolorRGB(0,0,110);
  InfoStr;
  triangle:=triangle_gouraud;
  rtype:=rt_gouraud;
  ci:=0;
  cii:=+1;
  new(ft1,LoadFont('font6.fnt'));
  new(ft2,LoadFont('fontega.fnt'));

{  LoadImageFile(itJPG,'GXTEX8.JPG',texture); }

  texsiz:=8;

{  LoadImageFile(itJPG,'GXTEX8.JPG',texture); }

  LoadTexture(texsiz,'gxtex8.jpg',texture);

  createpalette;
  mx:=getmaxX DIV 2;
  my:=getmaxY DIV 2;
  wx:=3*pi/2;
  wy:=0;
{  wz:=0; }

  CASE gxcurres OF
  $03200200..$05120480:ty:=10;
  $06400350..$16001200:ty:=100;
  END;

{  CreateCube(300); }
  CreateTorus(8,4,80*4,40*4,texsiz);
{  LoadFCE('..\TEST\HELI.FCE',2); }
  size:=getmaxY*1;
  Calculate;
  Draw;
  fc:=0;
  fps:=100;
  time:=zeit;
  ch:=#0;
  REPEAT
    wx:=wx+0.02;
    wy:=wy+0.005;
    Calculate;
    Draw;
    inc(fc);
    IF ((fc MOD fps)=0) THEN
      BEGIN
        fps:=trunc(fc/(real(zeit-time)/100));
        fc:=0;
        time:=zeit;
      END;
    IF keypressed THEN
      BEGIN
        ch:=upcase(readkey);
        CASE ch OF
        'B':bckgrnd:=NOT bckgrnd;
        'D':disptext:=NOT disptext;
        'C':CreatePalette;
        'F':rtype:=rt_flat;
        'G':rtype:=rt_gouraud;
      {  'T':rtype:=rt_textured; }
      {  'S':triangle:=triangle_textured_perspective; }
        'P':readkey;
        'R':waitretrace:=NOT waitretrace;
        'W':usetexcoords:=(NOT usetexcoords) AND ObjTcsAvail;
        '+':inc(size,20);
        '-':dec(size,20);
        '1':BEGIN
              Destroy_3D_Object;
              CreateTorus(8,4,80*4,40*4,texsiz);
              usetexcoords:=usetexcoords AND ObjTcsAvail;
            END;
        '2':BEGIN
              Destroy_3D_Object;
              CreateTorus(32,16,80*4,40*4,texsiz);
              usetexcoords:=usetexcoords AND ObjTcsAvail;
            END;
        '3':BEGIN
              Destroy_3D_Object;
              CreateCube(300);
              usetexcoords:=usetexcoords AND ObjTcsAvail;
            END;
        '4':BEGIN
              Destroy_3D_Object;
              CreateSphere(400,20,texsiz+2);
              usetexcoords:=usetexcoords AND ObjTcsAvail;
            END;
      END;
    END;
    CASE MouseButton OF
     1:inc(size,20);
     2:dec(size,20);
    END;
  UNTIL (ch=#27);
  DestroyImage(texture);
  Destroy_3D_Object;
  dispose(ft1,removefont);
  dispose(ft2,removefont);
  dispose(render);
END;

END.
