{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

UNIT gxdemo3;

INTERFACE

PROCEDURE GraphixDemo3;

IMPLEMENTATION

USES gxcrt,graphix,gxtext,gxttf;

VAR FontCHR:PFontCHR;
    FontFNT:PFontFNT;
    FontVGA:PFontVGA;
    FontTTF:PFontTTF;
    dx1,dy1,dx2,dy2:longint;

PROCEDURE Rahmen;
BEGIN
  graphwin(0,0,getmaxX,getmaxY);
  dx1:=10;
  CASE gxcurres OF
  $03200200..$05120480:dy1:=10;
  $06400350..$16001200:dy1:=100;
  END;
  dx2:=getmaxX-10;
  dy2:=getmaxY-10;
  rectangle(dx1-1,dy1-1,dx2+1,dy2+1,rgbcolorRGB(255,255,255));
  bar(dx1,dy1,dx2,dy2,rgbcolorRGB(0,0,80));
  graphwin(dx1,dy1,dx2,dy2);
END;

PROCEDURE ZoomText(y:longint;s:string);
CONST z=32;
VAR i,l,h:longint;
    r,g,b,rr,rg,rb:longint;
    ft:PFontTTF;
BEGIN
  randomize;
  r:=0;
  g:=0;
  b:=0;
  rr:=1+random(z);
  rg:=1+random(z);
  rb:=1+random(z);
  i:=8;
  FontTTF^.SetFontSize(i);
  l:=FontTTF^.textlength(s);
  WHILE (l<getmaxX-20) DO
    BEGIN
      FontTTF^.SetFontSize(i);
      l:=FontTTF^.textlength(s);
      h:=FontTTF^.fontheight;
      FontTTF^.outtext((getmaxX-l) DIV 2,y-h DIV 2,s,rgbcolorRGB(r,g,b));
      inc(i,2);
      inc(r,rr);
      inc(g,rg);
      inc(b,rb);
      IF (r>255) THEN
        BEGIN
          r:=255;
          rr:=-1-random(z);
        END;
      IF (r<0) THEN
        BEGIN
          r:=0;
          rr:=+1+random(z);
        END;
      IF (g>255) THEN
        BEGIN
          g:=255;
          rg:=-1-random(z);
        END;
      IF (g<0) THEN
        BEGIN
          g:=0;
          rg:=+1+random(z);
        END;
      IF (b>255) THEN
        BEGIN
          b:=255;
          rb:=-1-random(z);
        END;
      IF (b<0) THEN
        BEGIN
          b:=0;
          rb:=+1+random(z);
        END;
      delay(20);
    END;
END;

PROCEDURE WelcomeDemo;
BEGIN
  ZoomText((getmaxY DIV 8)*3,'Welcome to');
  ZoomText((getmaxY DIV 8)*5,'the GraphiX');
  ZoomText((getmaxY DIV 8)*7,'Text-Demo');
  delay(1000);
END;

PROCEDURE EditDemo;
VAR s:string;
BEGIN
  bar(50,dy1+10,getmaxX-50,dy1+10+FontFNT^.fontheight,rgbcolorRGB(0,90,0));
  FontFNT^.outtext(50,dy1+10,'Please enter something...',$00FFFFFF);
  s:='';
  EditText(FontFNT,50,dy1+10+35,getmaxX-100,rgbcolorRGB(0,0,80),rgbcolorRGB(220,130,0),s,80);
  bar(50,dy1+10+70,getmaxX-50,dy1+10+70+FontFNT^.fontheight,rgbcolorRGB(0,90,0));
  FontFNT^.outtext(50,dy1+10+70,'You have entered: '+s,$00FFFFFF);
  bar(50,dy1+10+105,getmaxX-50,dy1+10+105+FontFNT^.fontheight,rgbcolorRGB(220,130,0));
  FontFNT^.outtext(50,dy1+10+105,'Press any key to continue ...',rgbcolorRGB(0,0,80));
  readkey;
END;

PROCEDURE FontVGADemo;
VAR h:longint;
    s:string;
BEGIN
  h:=FontVGA^.fontheight;
  FontVGA^.outtext(dx1+10,dy1+10,'First the good old VGA standard 8x16 Font...',$00FFFFFF);
  FontVGA^.outtext(dx1+10,dy1+20+1*h,'*) Standard Style',$00FFFFFF);
  FontVGA^.setfontstyle(fts_italic);
  FontVGA^.outtext(dx1+10,dy1+20+2*h,'*) Italic Style',$00FFFFFF);
  FontVGA^.setfontstyle(fts_normal);
  FontVGA^.outtext(dx1+10,dy2-10-h,'Press ENTER to continue...',$00FFFFFF);
  s:='This font can be used with the Line-Editor ...';
  FontVGA^.setfontstyle(fts_normal);
  EditText(FontVGA,dx1+10,dy1+20+3*h,dx2-dx1-20,rgbcolorRGB(0,0,80),rgbcolorRGB(220,130,0),s,80);
END;

PROCEDURE FontFNTDemo;
VAR h:longint;
    s:string;
BEGIN
  h:=FontFNT^.fontheight;
  FontFNT^.outtext(dx1+10,dy1+10,'...then the MS-Windows Bitmap Font...',$00FFFFFF);
  FontFNT^.outtext(dx1+10,dy1+20+1*h,'*) Standard Style',$00FFFFFF);
  FontFNT^.setfontstyle(fts_italic);
  FontFNT^.outtext(dx1+10,dy1+20+2*h,'*) Italic Style',$00FFFFFF);
  FontFNT^.setfontstyle(fts_normal);
  FontFNT^.outtext(dx1+10,dy2-10-h,'Press ENTER to continue...',$00FFFFFF);
  s:='... the Line-Editor works with it ...';
  FontFNT^.setfontstyle(fts_normal);
  EditText(FontFNT,dx1+10,dy1+20+3*h,dx2-dx1-20,rgbcolorRGB(0,0,80),rgbcolorRGB(220,130,0),s,80);
END;

PROCEDURE FontCHRDemo;
VAR i,jx,jy,h:longint;
    f:longint;
    s:string;
BEGIN
  FontCHR^.setfontsize((getmaxX+1) DIV 20);
  h:=FontCHR^.fontheight;
  FontCHR^.outtext(dx1+10,dy1+10,'...the BGI-CHR Font',$00FFFFFF);

  FontCHR^.setfontstyle(fts_normal);
  FontCHR^.outtext(dx1+10,dy1+20+1*h,'*) Standard Style',$00FFFFFF);
  FontCHR^.setfontstyle(fts_italic);
  FontCHR^.outtext(dx1+10,dy1+20+2*h,'*) Italic Style',$00FFFFFF);

  FontCHR^.setfontstyle(fts_normal);
  FOR i:=0 TO 4 DO
    BEGIN
      FontCHR^.SetFontDirection(i SHL 12);
      CASE i OF
      0:f:=rgbcolorRGB(255,0,0);
      1:f:=rgbcolorRGB(0,255,0);
      2:f:=rgbcolorRGB(255,255,0);
      3:f:=rgbcolorRGB(0,0,255);
      4:f:=rgbcolorRGB(255,0,255);
      END;
      FontCHR^.outtext(dx2-FontCHR^.textlength('FreeDirection'),dy1+10,'Free Direction',f);
    END;
  FontCHR^.SetFontDirection(0);
  jx:=0;
  jy:=0;
  i:=1;
  REPEAT
    CASE 1+i MOD 5 OF
    1:f:=rgbcolorRGB(255,0,0);
    2:f:=rgbcolorRGB(0,255,0);
    3:f:=rgbcolorRGB(255,255,0);
    4:f:=rgbcolorRGB(0,0,255);
    5:f:=rgbcolorRGB(255,0,255);
    END;
    FontCHR^.setfontsize(10+i*10);
    FontCHR^.outtext(dx1+10+jx,dy1+20+h*6+jy,'Free Size',f);
    inc(jy,FontCHR^.fontheight);
    inc(jx,FontCHR^.textlength('Free Size'));
    inc(i);
  UNTIL (jx>getmaxX);

  FontCHR^.setfontsize((getmaxX+1) DIV 20);
  FontCHR^.outtext(dx1+10,dy2-10-h,'Press ENTER to continue...',$00FFFFFF);
  s:='Yes, you can use that font here, too ...';
  FontCHR^.setfontstyle(fts_normal);
  EditText(FontCHR,dx1+10,dy1+20+5*h,dx2-dx1-20,rgbcolorRGB(0,0,80),rgbcolorRGB(220,130,0),s,80);
END;

PROCEDURE FontTTFDemo;
VAR i,jx,jy,h:longint;
    f:longint;
    s:string;
BEGIN
  FontTTF^.setfontsize((getmaxX+1) DIV 30);
  h:=FontTTF^.fontheight;
  FontTTF^.outtext(dx1+10,dy1+10,'...and at last the TrueType Font',$00FFFFFF);

  FontTTF^.setfontstyle(fts_normal);
  FontTTF^.outtext(dx1+10,dy1+20+1*h,'*) Standard Style',$00FFFFFF);
  FontTTF^.setfontstyle(fts_italic);
  FontTTF^.outtext(dx1+10,dy1+20+2*h,'*) Italic Style',$00FFFFFF);

  FontTTF^.setfontstyle(fts_normal);
  FOR i:=0 TO 4 DO
    BEGIN
      FontTTF^.SetFontDirection(i SHL 12);
      CASE i OF
      0:f:=rgbcolorRGB(255,0,0);
      1:f:=rgbcolorRGB(0,255,0);
      2:f:=rgbcolorRGB(255,255,0);
      3:f:=rgbcolorRGB(0,0,255);
      4:f:=rgbcolorRGB(255,0,255);
      END;
      FontTTF^.outtext(dx2-FontTTF^.textlength('FreeDirection'),dy1+10,'Free Direction',f);
    END;
  FontTTF^.SetFontDirection(0);
  jx:=0;
  jy:=0;
  i:=1;
  REPEAT
    CASE 1+i MOD 5 OF
    1:f:=rgbcolorRGB(255,0,0);
    2:f:=rgbcolorRGB(0,255,0);
    3:f:=rgbcolorRGB(255,255,0);
    4:f:=rgbcolorRGB(0,0,255);
    5:f:=rgbcolorRGB(255,0,255);
    END;
    FontTTF^.setfontsize(10+i*5);
    FontTTF^.outtext(dx1+10+jx,dy1+20+h*6+jy,'Free Size',f);
    inc(jy,FontTTF^.fontheight);
    inc(jx,FontTTF^.textlength('Free Size'));
    inc(i);
  UNTIL (jx>getmaxX);

  FontTTF^.setfontsize((getmaxX+1) DIV 30);
  FontTTF^.outtext(dx1+10,dy2-10-h,'Press ENTER to continue...',$00FFFFFF);
  s:='Yes, you can use that font here, too ...';
  FontTTF^.setfontstyle(fts_normal);
  EditText(FontTTF,dx1+10,dy1+20+5*h,dx2-dx1-20,rgbcolorRGB(0,0,80),rgbcolorRGB(220,130,0),s,80);
END;

PROCEDURE GraphixDemo3;
BEGIN
  new(FontVGA,LoadFont);
  new(FontCHR,LoadFont('bold.chr'));
  IF (gxcurres<=$05120480) THEN new(FontFNT,LoadFont('font3.fnt'))
                           ELSE new(FontFNT,LoadFont('font5.fnt'));
  new(FontTTF,LoadFont('avalonb.ttf'));

  WelcomeDemo;
  Rahmen;EditDemo;
  Rahmen;FontVGADemo;
  Rahmen;FontFNTDemo;
  Rahmen;FontCHRDemo;
  Rahmen;FontTTFDemo;

  dispose(FontCHR,RemoveFont);
  dispose(FontFNT,RemoveFont);
  dispose(FontVGA,RemoveFont);
  dispose(FontTTF,RemoveFont);

  maxgraphwin;
END;

END.
