{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

UNIT gxdemo5;

INTERFACE

PROCEDURE GraphixDemo5;

IMPLEMENTATION

USES gxcrt,graphix,gxtext,gxmouse,gx3d,gx3dtype,gximg,gxmedia,gxdemot;

VAR curstate:string;

PROCEDURE shadedbar(x1,y1,x2,y2,col1,col2,col3,col4:longint);
VAR rend:trender;
BEGIN
  IF LFBenabled OR MFBused THEN
    BEGIN
      rend.points[0].x:=x1;
      rend.points[0].y:=y1;
      rend.points[1].x:=x2;
      rend.points[1].y:=y1;
      rend.points[2].x:=x1;
      rend.points[2].y:=y2;
      rend.colors[0]:=col1;
      rend.colors[1]:=col2;
      rend.colors[2]:=col3;
      triangle_gouraud(prender(addr(rend)));
      rend.points[0].x:=x2;
      rend.points[0].y:=y1;
      rend.points[1].x:=x1;
      rend.points[1].y:=y2;
      rend.points[2].x:=x2;
      rend.points[2].y:=y2;
      rend.colors[0]:=col2;
      rend.colors[1]:=col3;
      rend.colors[2]:=col4;
      triangle_gouraud(Prender(addr(rend)));
    END;
END;

PROCEDURE BaseScreen;
VAR gxlogo:pointer;
BEGIN
  MouseOff;
  StartDraw;
  LoadImageFile(itGIF,'gxlogo.gif',gxlogo,0);
  bar(0,0,getmaxX,getmaxY,rgbcolorRGB(0,0,80));
  shadedbar(0,100,getmaxX,getmaxY,rgbcolorRGB(0,0,80),rgbcolorRGB(0,0,80),rgbcolorRGB(192,192,192),rgbcolorRGB(192,192,192));
  shadedbar(10,10,getmaxX-10,60,rgbcolorRGB(192,192,192),rgbcolorRGB(96,96,136),rgbcolorRGB(96,96,136),rgbcolorRGB(0,0,80));
  ft2^.outtext(335,20,'Media-Player-Demo',rgbcolor($00FFFFFF));
  ft3^.outtext(335,45,vergraphix,rgbcolor($00FFFFFF));
  zoomimage(15,15,315,55,gxlogo);
  shadedbar(10,65,getmaxX-10,getmaxY-55,rgbcolorRGB(192,192,192),rgbcolorRGB(96,96,136),rgbcolorRGB(96,96,136),rgbcolorRGB(0,0,80));
  shadedbar(10,getmaxY-50,getmaxX-10,getmaxY-10,rgbcolorRGB(192,192,192),rgbcolorRGB(96,96,136),rgbcolorRGB(96,96,136),rgbcolorRGB(0,0,80));
  ft3^.outtext(15,70,'<f> - fullscreen/original size',rgbcolor($00FFFFFF));
  ft3^.outtext(15,80,'<w> - frame-delay on/off',rgbcolor($00FFFFFF));
  DestroyImage(gxlogo);
  EndDraw;
  MouseOn;
END;

FUNCTION MouseArea(x1,y1,x2,y2:longint):boolean;
BEGIN
  MouseArea:=FALSE;
  IF (IsMouseInArea(x1,y1,x2,y2)=129) THEN
    BEGIN
      MouseOff;
      barXOR(x1,y1,x2,y2,$FFFFFF);
      MouseOn;
      WaitButtonReleased;
      MouseOff;
      barXOR(x1,y1,x2,y2,$FFFFFF);
      MouseOn;
      IF (IsMouseInArea(x1,y1,x2,y2)=128) THEN MouseArea:=TRUE;
    END;
END;

PROCEDURE Status(s:string);
BEGIN
  MouseOff;
  curstate:=s;
  bar(15,getmaxY-80,getmaxX-15,getmaxY-60,rgbcolorRGB(0,0,80));
  ft1^.outtext(20,getmaxY-78,'Status: '+s,rgbcolor($00FFFFFF));
  MouseOn;
END;

PROCEDURE MainMenu;
VAR ch:char;
    mediaopen,mediarunning,fullscreen,framedelay:boolean;
    media:Pmedia;
    medianame:string;
    gxctrl:pointer;
    pos:longint;
    xx,vx,vy,fx1,fy1,fx2,fy2:longint;
BEGIN
  xx:=(getmaxX-450) DIV 2;
  LoadImageFile(itGIF,'gxmedcb.gif',gxctrl,0);
  ch:=#0;
  mediaopen:=FALSE;
  mediarunning:=FALSE;
  fullscreen:=FALSE;
  framedelay:=TRUE;
  medianame:='';
  media:=nil;
  putimageC(xx,getmaxY-44,gxctrl);
  Status('no file opened');

  REPEAT
    IF keypressed THEN
      BEGIN
        ch:=readkey;
        CASE ch OF
        'f':BEGIN
              fullscreen:=NOT fullscreen;
              IF NOT fullscreen THEN
                BEGIN
                  BaseScreen;
                  MouseOff;
                  putimageC(xx,getmaxY-44,gxctrl);
                  MouseOn;
                  Status(curstate);
                END
              ELSE
                BEGIN
                  MouseOff;
                  bar(0,0,getmaxX,getmaxY,0);
                END;
            END;
         'w':framedelay:=NOT framedelay;
        END;
      END;
    IF NOT fullscreen THEN
    IF (MouseButton>0) THEN
      BEGIN
        IF MouseArea(xx+4,getmaxY-40,xx+25,getmaxY-18) THEN
          BEGIN
            IF EditText(ft1,xx+120,getmaxY-37,295,rgbcolorRGB(0,0,128),rgbcolorRGB(91,191,191),medianame,80) THEN
              BEGIN
                IF mediaopen THEN
                  BEGIN
                    dispose(media,closemedia);
                    mediaopen:=FALSE;
                  END;
                media:=new(PmediaAVI,OpenMedia(medianame));
                IF (media^.GetNumFrame=0) THEN
                  BEGIN
                    dispose(media,CloseMedia);
                    media:=new(PmediaFLC,OpenMedia(medianame));
                    IF (media^.GetNumFrame=0) THEN
                      BEGIN
                        dispose(media,CloseMedia);
                        media:=new(PmediaGIF,OpenMedia(medianame));
                        IF (media^.GetNumFrame=0) THEN
                          BEGIN
                            dispose(media,CloseMedia);
                            media:=new(PmediaMOV,OpenMedia(medianame));
                            IF (media^.GetNumFrame=0) THEN
                              BEGIN
                                dispose(media,CloseMedia);
                                media:=new(PmediaANI,OpenMedia(medianame));
                                IF (media^.GetNumFrame=0) THEN
                                  BEGIN
                                    dispose(media,CloseMedia);
                                  END
                                ELSE mediaopen:=TRUE;
                              END
                            ELSE mediaopen:=TRUE;
                          END
                        ELSE mediaopen:=TRUE;
                      END
                    ELSE mediaopen:=TRUE;
                  END
                ELSE mediaopen:=TRUE;
              END;
            MouseOff;
            putimageC(xx,getmaxY-44,gxctrl);
            IF mediaopen THEN
              BEGIN
                mediarunning:=FALSE;
                Status('['+medianame+'] opened');
                vx:=(getmaxX-media^.framexd) DIV 2;
                vy:=(getmaxY-media^.frameyd) DIV 2;

                fx1:=0;
                fx2:=getmaxX;
                fy1:=(getmaxY-(media^.frameyd*(getmaxX+1)) DIV media^.framexd) DIV 2;
                fy2:=getmaxY-fy1;
                IF (fy1<0) THEN
                  BEGIN
                    fy1:=0;
                    fy2:=getmaxY;
                    fx1:=(getmaxX-(media^.framexd*(getmaxY+1)) DIV media^.frameyd) DIV 2;
                    fx2:=getmaxX-fx1;
                  END;
                putimage(vx,vy,media^.grabframe);
              END
            ELSE
              BEGIN
                Status('Can''t open ['+medianame+'] or file-format not supported');
              END;
            MouseOn;
          END;
        IF MouseArea(xx+32,getmaxY-40,xx+53,getmaxY-18) AND mediaopen THEN
          BEGIN
            mediarunning:=FALSE;
            media^.StartMedia;
            Status('['+medianame+'] stopped');
          END;
        IF MouseArea(xx+60,getmaxY-40,xx+81,getmaxY-18) AND mediaopen THEN
          BEGIN
            mediarunning:=FALSE;
            Status('['+medianame+'] paused');
          END;
        IF MouseArea(xx+88,getmaxY-40,xx+109,getmaxY-18) AND mediaopen THEN
          BEGIN
            mediarunning:=TRUE;
            Status('['+medianame+'] running');
          END;
      END;
    IF mediarunning THEN
      BEGIN
        IF fullscreen THEN
          BEGIN
            waitforretraceend;
          {  zoomimage(0,0,getmaxX,getmaxY,media^.grabframe); }
            zoomimage(fx1,fy1,fx2,fy2,media^.grabframe);
            waitforretracestart;
          END
        ELSE
          BEGIN
            putimage(vx,vy,media^.grabframe);
            pos:=longint(media^.GetCurFrame)*298 DIV media^.GetNumFrame;
            bar(xx+118,getmaxY-38,xx+118+pos,getmaxY-21,rgbcolor($00000080));
            bar(xx+118+pos+1,getmaxY-38,xx+417,getmaxY-21,rgbcolor($00BFBFBF));
          END;
        IF framedelay THEN delay(media^.getframetime);
        IF media^.EndofMedia THEN
          BEGIN
             {  mediarunning:=FALSE;
                Status('['+medianame+'] finished'); }
            media^.StartMedia;
          END;
      END;
  UNTIL (ch=#27) OR MouseArea(xx+424,getmaxY-40,xx+445,getmaxY-18);
  IF mediaopen THEN
    BEGIN
      dispose(media,closemedia);
      mediaopen:=FALSE;
    END;
  DestroyImage(gxctrl);
END;

PROCEDURE GraphixDemo5;
BEGIN
  BaseScreen;
  MainMenu;
END;

END.
