{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

UNIT gxdemot;

INTERFACE

USES graphix,gxtext;

VAR primarysurface,backsurface:PSurface;
    ft1,ft2,ft3,ftf:PFontFNT;

PROCEDURE InitGXDemo;
PROCEDURE DoneGXDemo;
PROCEDURE StartDraw;
PROCEDURE EndDraw;

IMPLEMENTATION

PROCEDURE InitGXDemo;
BEGIN
  CreateSurface(primarysurface,gxsf_primary);
  IF NOT LFBenabled THEN CreateSurface(backsurface,gxsf_sysmem); 
  new(ft1,LoadFont('font2.fnt'));
  new(ft2,LoadFont('font4.fnt'));
  new(ft3,LoadFont('font7.fnt'));
  new(ftf,LoadFont('fontfix1.fnt'));
END;

PROCEDURE DoneGXDemo;
BEGIN
  dispose(ft1,RemoveFont);
  dispose(ft2,RemoveFont);
  dispose(ft3,RemoveFont);
  dispose(ftf,RemoveFont);
  IF NOT LFBenabled THEN DestroySurface(backsurface);
  DestroySurface(primarysurface);
END;

PROCEDURE StartDraw;
BEGIN
  IF NOT LFBenabled THEN setactivesurface(backsurface,false);
END;

PROCEDURE EndDraw;
BEGIN
  IF NOT LFBenabled THEN
    BEGIN
      copysurface(primarysurface,backsurface);
      setactivesurface(primarysurface,false);
    END;
END;


END.