{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

{============================================================================}
{ Matrox MGA-2064W, MGA-2164W, MGA-1064SG, MGA-1164SG                        }
{============================================================================}
{$I gxglobal.cfg}
UNIT gxhw_mga;

INTERFACE

USES gxbase,gxpci,gx3dtype,gxsup,gxmem;
{$I gxlocal.cfg}

PROCEDURE sethwaprocs_matrox(col:longint);
PROCEDURE setupdevice_matrox(baseaddr:dword;var pcidev:TPCIdevice);
PROCEDURE adjustaddresses_matrox(old_ds_base,new_ds_base:dword);
PROCEDURE setreslist_matrox(var modelist:PModeEntry);
FUNCTION detectmem_matrox(devid:longint):longint;
PROCEDURE enableregs_matrox;
PROCEDURE disableregs_matrox;
PROCEDURE scanline_matrox(linewidth:word);
PROCEDURE displaystart_matrox(offs:dword);
PROCEDURE bankswitch_matrox;
PROCEDURE enableHWA_matrox(col,init,bpl,bpp,pix:longint);
PROCEDURE disableHWA_matrox;

PROCEDURE triangle_flat8_matrox(rend:prender);
PROCEDURE triangle_flat16_matrox(rend:prender);
PROCEDURE triangle_flat32_matrox(rend:prender);
PROCEDURE triangle_gouraud_matrox(rend:prender);

IMPLEMENTATION

USES graphix,gxtype;

VAR mmiomap0:tmmiomap;
    mmiomap1:tmmiomap;
    reg_mca:dword;
    option{,devid}:longint;
{    patbuf:array[0..7,0..1] of byte; }

PROCEDURE setupdevice_matrox(baseaddr:dword;var pcidev:TPCIdevice);
BEGIN
{  devid:=0; }
  CASE pcidev.device OF
  $0519: {Matrox Millenium I}
    BEGIN
      mapresource(mmiomap0,pcidev.base0 AND $FFFFC000,getpcibasesize(baseaddr,0));
      mapresource(mmiomap1,pcidev.base1 AND $FF800000,getpcibasesize(baseaddr,1));
      reg_mca:=mmiomap0.offs;
      lfbbase:=mmiomap1.offs;
      option:=readpci32(baseaddr+$40);
   {   devid:=pcidev.device; }
    END;
  $051A,$051E: {Matrox Mystique}
    BEGIN
      mapresource(mmiomap0,pcidev.base0 AND $FF800000,getpcibasesize(baseaddr,0));
      mapresource(mmiomap1,pcidev.base1 AND $FFFFC000,getpcibasesize(baseaddr,1));
      lfbbase:=mmiomap0.offs;
      reg_mca:=mmiomap1.offs;
      option:=readpci32(baseaddr+$40);
    {  devid:=pcidev.device; }
    END;
  $051B,$051F,$0520,$0521: {Matrox Millenium II, G200}
    BEGIN
      mapresource(mmiomap0,pcidev.base0 AND $FF000000,getpcibasesize(baseaddr,0));
      mapresource(mmiomap1,pcidev.base1 AND $FFFFC000,getpcibasesize(baseaddr,1));
      lfbbase:=mmiomap0.offs;
      reg_mca:=mmiomap1.offs;
      option:=readpci32(baseaddr+$40);
  {    devid:=pcidev.device; }
    END;
  END;
END;

PROCEDURE adjustaddresses_matrox(old_ds_base,new_ds_base:dword);
BEGIN
  adjustaddress(lfbbase,old_ds_base,new_ds_base);
  adjustaddress(reg_mca,old_ds_base,new_ds_base);
END;

{----------------------------------------------------------------------------}

FUNCTION detectmem_matrox1064:longint;
BEGIN
  CASE (option AND $00001000) OF
  $00000000:detectmem_matrox1064:=2048;
  $00001000:detectmem_matrox1064:=4096;
  END;
END;

FUNCTION detectmem_matrox2x64:longint;
VAR w:word;
BEGIN
  ASM
    MOV DX,03DEh
    MOV AL,03h
    OUT DX,AL
    INC DX
    IN AL,DX
    AND AX,000Ch
    MOV w,AX
  END;
  CASE w OF
  $0000:detectmem_matrox2x64:=4096;
  $0004:detectmem_matrox2x64:=2048;
  $0008:detectmem_matrox2x64:=8192;
  $000C:detectmem_matrox2x64:=8192;
  END;
END;

FUNCTION detectmem_matroxG200:longint;
BEGIN
  CASE (option AND $00001800) OF
  $00000000:detectmem_matroxG200:=8192;
  $00000800:detectmem_matroxG200:=16384;
  $00001000:detectmem_matroxG200:=16384;
  $00001800:detectmem_matroxG200:=16384;
  END;
END;

FUNCTION detectmem_matrox(devid:longint):longint;
BEGIN
  detectmem_matrox:=4096;
  CASE devid OF
  $0519: {Matrox Millenium I}
    detectmem_matrox:=detectmem_matrox2x64;
  $051A,$051E: {Matrox Mystique}
    detectmem_matrox:=detectmem_matrox1064;
  $051B,$051F: {Matrox Millenium II}
    detectmem_matrox:=detectmem_matrox2x64;
  $0520,$0521: {G200}
    detectmem_matrox:=detectmem_matroxG200;
  END;
END;

{----------------------------------------------------------------------------}

PROCEDURE enableregs_matrox;assembler;
ASM
{MGA on}
  MOV DX,03DEh
  MOV AL,03h
  OUT DX,AL
  INC DX
  IN AL,DX
  OR AL,080h
  OUT DX,AL
END;

PROCEDURE disableregs_matrox;
BEGIN
END;

PROCEDURE scanline_matrox(linewidth:word);assembler;
ASM
{doubleword-mode}
  MOV DX,03D4h
  MOV AL,14h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0BFh
{  OR AL,40h }
  OUT DX,AL
{bit 0-7}
  MOV DX,03D4h
  MOV AH,BYTE PTR linewidth
  MOV AL,13h
  OUT DX,AX
{bit 8-9}
  MOV AX,linewidth
  SHL AH,4
  AND AH,30h
  MOV DX,03DEh
  XOR AL,AL
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0CFh
  OR AL,AH
  OUT DX,AL
END;

PROCEDURE displaystart_matrox(offs:dword);assembler;
ASM
  MOV EBX,offs
{bit 0-7}
  SHR EBX,3
  MOV DX,03D4h
  MOV AH,BL
  MOV AL,0Dh
  OUT DX,AX
{bit 8-15}
  SHR EBX,8
  MOV DX,03D4h
  MOV AH,BL
  MOV AL,0Ch
  OUT DX,AX
{bit 16-19}
  SHR EBX,8
  AND BL,0Fh
  MOV DX,03DEh
  MOV AL,00h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0F0h
  OR AL,BL
  OUT DX,AL
END;

PROCEDURE bankswitch_matrox;assembler;
ASM
  MOV AH,DL
  MOV AL,04h
  MOV DX,03DEh
  OUT DX,AX
END;

{------------------------------- Hardware-Acceleration ----------------------}

PROCEDURE enableHWA_matrox(col,init,bpl,bpp,pix:longint);assembler;
ASM
  MOV EBX,bpp
  MOV EAX,bpl
  MOV EDX,0
  DIV EBX
  MOV hwascanline,EAX

  MOV EDI,reg_mca
  MOV EAX,hwascanline
  MOV [EDI+1C8Ch],EAX
{  MOV EAX,drawoffset
  MOV [EDI+1C94h],EAX }

  CMP col,ig_col8
  JNE @matrox_ne8
  MOV EAX,000000000h
@matrox_ne8:
  CMP col,ig_col15
  JNE @matrox_ne15
  MOV EAX,080000001h
@matrox_ne15:
  CMP col,ig_col16
  JNE @matrox_ne16
  MOV EAX,000000001h
@matrox_ne16:
  CMP col,ig_col32
  JNE @matrox_ne32
  MOV EAX,040000002h
@matrox_ne32:
  MOV [EDI+1C04h],EAX

  MOV DWORD PTR [EDI+1C1Ch],0FFFFFFFFh
  MOV EAX,maxY
  INC EAX
  MUL bytperline
  MOV [EDI+1C0Ch],EAX
END;

PROCEDURE disableHWA_matrox;
BEGIN
END;

PROCEDURE graphwinhw_matrox(x1,y1,x2,y2:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV EAX,x1
  MOV [EDI+1CA0h],EAX
  MOV EAX,x2
  MOV [EDI+1CA4h],EAX

  MOV ECX,frontdrawoffsetpix
  MOV [EDI+1C94h],ECX
{  MOV ECX,drawoffset
  MOV [EDI+1C94h],ECX }
  MOV EBX,hwascanline
  MOV EAX,y1
  MUL EBX
  ADD EAX,ECX
  MOV [EDI+1C98h],EAX
  MOV EAX,y2
  MUL EBX
  ADD EAX,ECX
  MOV [EDI+1C9Ch],EAX
END;

PROCEDURE setpatternHW_matrox(pattern:ppattern);assembler;
{VAR i:longint;
BEGIN
  FOR i:=0 TO 7 DO
    BEGIN
      patbuf[i,0]:=pattern^[i];
      patbuf[i,1]:=pattern^[i];
    END;
END;}

ASM
  MOV EDI,reg_mca
  MOV EBX,pattern
  MOV AL,[EBX+1]
  MOV AH,AL
  SHL EAX,16
  MOV AL,[EBX+0]
  MOV AH,AL
  MOV [EDI+1C30h],EAX
  MOV AL,[EBX+3]
  MOV AH,AL
  SHL EAX,16
  MOV AL,[EBX+2]
  MOV AH,AL
  MOV [EDI+1C34h],EAX
  MOV AL,[EBX+5]
  MOV AH,AL
  SHL EAX,16
  MOV AL,[EBX+4]
  MOV AH,AL
  MOV [EDI+1C38h],EAX
  MOV AL,[EBX+7]
  MOV AH,AL
  SHL EAX,16
  MOV AL,[EBX+6]
  MOV AH,AL
  MOV [EDI+1C3Ch],EAX
END;

{PROCEDURE setpattern_matrox;assembler;
ASM
  MOV EDI,reg_mca
  MOV ESI,OFFSET patbuf
  ADD EDI,1C30h
  MOVSD
  MOVSD
  MOVSD
  MOVSD
END;}

{----------------------------- line ---------------------------------------}

PROCEDURE line8_matrox(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV AX,WORD PTR y1
  SHL EAX,16
  MOV AX,WORD PTR x1
  MOV [EDI+1C40h],EAX
  MOV AX,WORD PTR y2
  SHL EAX,16
  MOV AX,WORD PTR x2
  MOV [EDI+1C44h],EAX
  MOV AL,BYTE PTR f
  MOV AH,AL
  SHL EAX,8
  MOV AL,AH
  SHL EAX,8
  MOV AL,AH
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],040C4803h
@line8_matrox_busy:
  TEST DWORD PTR [EDI+1E14h],00010000h
  JNZ @line8_matrox_busy
END;

PROCEDURE line16_matrox(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV AX,WORD PTR y1
  SHL EAX,16
  MOV AX,WORD PTR x1
  MOV [EDI+1C40h],EAX
  MOV AX,WORD PTR y2
  SHL EAX,16
  MOV AX,WORD PTR x2
  MOV [EDI+1C44h],EAX
  MOV AX,WORD PTR f
  SHL EAX,16
  MOV AX,WORD PTR f
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],040C4803h
@line16_matrox_busy:
  TEST DWORD PTR [EDI+1E14h],00010000h
  JNZ @line16_matrox_busy
END;

PROCEDURE line32_matrox(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV AX,WORD PTR y1
  SHL EAX,16
  MOV AX,WORD PTR x1
  MOV [EDI+1C40h],EAX
  MOV AX,WORD PTR y2
  SHL EAX,16
  MOV AX,WORD PTR x2
  MOV [EDI+1C44h],EAX
  MOV EAX,f
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],040C4803h
@line32_matrox_busy:
  TEST DWORD PTR [EDI+1E14h],00010000h
  JNZ @line32_matrox_busy
END;

{----------------------------- lineXOR ------------------------------------}

PROCEDURE linexor8_matrox(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV AX,WORD PTR y1
  SHL EAX,16
  MOV AX,WORD PTR x1
  MOV [EDI+1C40h],EAX
  MOV AX,WORD PTR y2
  SHL EAX,16
  MOV AX,WORD PTR x2
  MOV [EDI+1C44h],EAX
  MOV AL,BYTE PTR f
  MOV AH,AL
  SHL EAX,8
  MOV AL,AH
  SHL EAX,8
  MOV AL,AH
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],04064813h
@line8_matrox_busy:
  TEST DWORD PTR [EDI+1E14h],00010000h
  JNZ @line8_matrox_busy
END;

PROCEDURE linexor16_matrox(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV AX,WORD PTR y1
  SHL EAX,16
  MOV AX,WORD PTR x1
  MOV [EDI+1C40h],EAX
  MOV AX,WORD PTR y2
  SHL EAX,16
  MOV AX,WORD PTR x2
  MOV [EDI+1C44h],EAX
  MOV AX,WORD PTR f
  SHL EAX,16
  MOV AX,WORD PTR f
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],04064813h
@line16_matrox_busy:
  TEST DWORD PTR [EDI+1E14h],00010000h
  JNZ @line16_matrox_busy
END;

PROCEDURE linexor32_matrox(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV AX,WORD PTR y1
  SHL EAX,16
  MOV AX,WORD PTR x1
  MOV [EDI+1C40h],EAX
  MOV AX,WORD PTR y2
  SHL EAX,16
  MOV AX,WORD PTR x2
  MOV [EDI+1C44h],EAX
  MOV EAX,f
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],04064813h
@line32_matrox_busy:
  TEST DWORD PTR [EDI+1E14h],00010000h
  JNZ @line32_matrox_busy
END;

{-------------------------------- lineH -------------------------------------}

PROCEDURE lineH8_matrox(x1,x2,y,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV EBX,x1
  MOV EAX,x2
  CMP EBX,EAX
  JLE @lineH8_matrox_w1
  XCHG EBX,EAX
@lineH8_matrox_w1:
  INC EAX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C84h],EAX

  MOV EAX,y
  SHL EAX,16
  MOV AX,1
  MOV [EDI+1C88h],EAX
  MOV AL,BYTE PTR f
  MOV AH,AL
  SHL EAX,8
  MOV AL,AH
  SHL EAX,8
  MOV AL,AH
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],000C7844h
END;

PROCEDURE lineH16_matrox(x1,x2,y,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV EBX,x1
  MOV EAX,x2
  CMP EBX,EAX
  JLE @lineH16_matrox_w1
  XCHG EBX,EAX
@lineH16_matrox_w1:
  INC EAX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C84h],EAX

  MOV EAX,y
  SHL EAX,16
  MOV AX,1
  MOV [EDI+1C88h],EAX
  MOV AX,WORD PTR f
  SHL EAX,16
  MOV AX,WORD PTR f
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],000C7844h
END;

PROCEDURE lineH32_matrox(x1,x2,y,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV EBX,x1
  MOV EAX,x2
  CMP EBX,EAX
  JLE @lineH32_matrox_w1
  XCHG EBX,EAX
@lineH32_matrox_w1:
  INC EAX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C84h],EAX

  MOV EAX,y
  SHL EAX,16
  MOV AX,1
  MOV [EDI+1C88h],EAX
  MOV EAX,f
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],000C7844h
END;

{-------------------------------- lineH_pattern -----------------------------}

PROCEDURE lineH8_pattern_matrox(x1,x2,y,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV EBX,x1
  MOV EAX,x2
  CMP EBX,EAX
  JLE @lineH8p_matrox_w1
  XCHG EBX,EAX
@lineH8p_matrox_w1:
  INC EAX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C84h],EAX

  MOV EAX,y
  SHL EAX,16
  MOV AX,1
  MOV [EDI+1C88h],EAX
{  CALL setpattern_matrox }
  MOV AL,BYTE PTR f
  MOV AH,AL
  SHL EAX,8
  MOV AL,AH
  SHL EAX,8
  MOV AL,AH
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],400C7044h
END;

PROCEDURE lineH16_pattern_matrox(x1,x2,y,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV EBX,x1
  MOV EAX,x2
  CMP EBX,EAX
  JLE @lineH16p_matrox_w1
  XCHG EBX,EAX
@lineH16p_matrox_w1:
  INC EAX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C84h],EAX

  MOV EAX,y
  SHL EAX,16
  MOV AX,1
  MOV [EDI+1C88h],EAX
{  CALL setpattern_matrox }
  MOV AX,WORD PTR f
  SHL EAX,16
  MOV AX,WORD PTR f
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],400C7044h
END;

PROCEDURE lineH32_pattern_matrox(x1,x2,y,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV EBX,x1
  MOV EAX,x2
  CMP EBX,EAX
  JLE @lineH32p_matrox_w1
  XCHG EBX,EAX
@lineH32p_matrox_w1:
  INC EAX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C84h],EAX
  MOV EAX,y
  SHL EAX,16
  MOV AX,1
  MOV [EDI+1C88h],EAX
{  CALL setpattern_matrox }
  MOV EAX,f
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],400C7044h
END;

{-------------------------------- bar -------------------------------------}

PROCEDURE bar8_matrox(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV EBX,x1
  MOV EAX,x2
  CMP EBX,EAX
  JLE @bar8_matrox_w1
  XCHG EBX,EAX
@bar8_matrox_w1:
  INC EAX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C84h],EAX

  MOV EAX,y1
  MOV EBX,y2
  CMP EAX,EBX
  JLE @bar8_matrox_w2
  XCHG EAX,EBX
@bar8_matrox_w2:
  SUB EBX,EAX
  INC EBX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C88h],EAX
  MOV AL,BYTE PTR f
  MOV AH,AL
  SHL EAX,8
  MOV AL,AH
  SHL EAX,8
  MOV AL,AH
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],000C7844h
@bar8_matrox_busy:
  TEST DWORD PTR [EDI+1E14h],00010000h
  JNZ @bar8_matrox_busy
END;

PROCEDURE bar16_matrox(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV EBX,x1
  MOV EAX,x2
  CMP EBX,EAX
  JLE @bar16_matrox_w1
  XCHG EBX,EAX
@bar16_matrox_w1:
  INC EAX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C84h],EAX

  MOV EAX,y1
  MOV EBX,y2
  CMP EAX,EBX
  JLE @bar16_matrox_w2
  XCHG EAX,EBX
@bar16_matrox_w2:
  SUB EBX,EAX
  INC EBX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C88h],EAX
  MOV AX,WORD PTR f
  SHL EAX,16
  MOV AX,WORD PTR f
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],000C7844h
@bar16_matrox_busy:
  TEST DWORD PTR [EDI+1E14h],00010000h
  JNZ @bar16_matrox_busy
END;

PROCEDURE bar32_matrox(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV EBX,x1
  MOV EAX,x2
  CMP EBX,EAX
  JLE @bar32_matrox_w1
  XCHG EBX,EAX
@bar32_matrox_w1:
  INC EAX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C84h],EAX

  MOV EAX,y1
  MOV EBX,y2
  CMP EAX,EBX
  JLE @bar32_matrox_w2
  XCHG EAX,EBX
@bar32_matrox_w2:
  SUB EBX,EAX
  INC EBX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C88h],EAX
  MOV EAX,f
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],000C7844h
@bar32_matrox_busy:
  TEST DWORD PTR [EDI+1E14h],00010000h
  JNZ @bar32_matrox_busy
END;

{-------------------------------- bar_pattern -------------------------------}

PROCEDURE bar8_pattern_matrox(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV EBX,x1
  MOV EAX,x2
  CMP EBX,EAX
  JLE @bar8p_matrox_w1
  XCHG EBX,EAX
@bar8p_matrox_w1:
  INC EAX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C84h],EAX

  MOV EAX,y1
  MOV EBX,y2
  CMP EAX,EBX
  JLE @bar8p_matrox_w2
  XCHG EAX,EBX
@bar8p_matrox_w2:
  SUB EBX,EAX
  INC EBX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C88h],EAX

{  CALL setpattern_matrox }
  MOV AL,BYTE PTR f
  MOV AH,AL
  SHL EAX,8
  MOV AL,AH
  SHL EAX,8
  MOV AL,AH
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],400C7044h
@bar8p_matrox_busy:
  TEST DWORD PTR [EDI+1E14h],00010000h
  JNZ @bar8p_matrox_busy
END;

PROCEDURE bar16_pattern_matrox(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV EBX,x1
  MOV EAX,x2
  CMP EBX,EAX
  JLE @bar16_matrox_w1
  XCHG EBX,EAX
@bar16_matrox_w1:
  INC EAX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C84h],EAX

  MOV EAX,y1
  MOV EBX,y2
  CMP EAX,EBX
  JLE @bar16_matrox_w2
  XCHG EAX,EBX
@bar16_matrox_w2:
  SUB EBX,EAX
  INC EBX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C88h],EAX
{  CALL setpattern_matrox }
  MOV AX,WORD PTR f
  SHL EAX,16
  MOV AX,WORD PTR f
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],400C7044h
@bar16_matrox_busy:
  TEST DWORD PTR [EDI+1E14h],00010000h
  JNZ @bar16_matrox_busy
END;

PROCEDURE bar32_pattern_matrox(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV EBX,x1
  MOV EAX,x2
  CMP EBX,EAX
  JLE @bar32_matrox_w1
  XCHG EBX,EAX
@bar32_matrox_w1:
  INC EAX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C84h],EAX

  MOV EAX,y1
  MOV EBX,y2
  CMP EAX,EBX
  JLE @bar32_matrox_w2
  XCHG EAX,EBX
@bar32_matrox_w2:
  SUB EBX,EAX
  INC EBX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C88h],EAX
{  CALL setpattern_matrox }
  MOV EAX,f
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],400C7044h
@bar32_matrox_busy:
  TEST DWORD PTR [EDI+1E14h],00010000h
  JNZ @bar32_matrox_busy
END;

{-------------------------------- barXOR ----------------------------------}

PROCEDURE barXOR8_matrox(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV EBX,x1
  MOV EAX,x2
  CMP EBX,EAX
  JLE @barXOR8_matrox_w1
  XCHG EBX,EAX
@barXOR8_matrox_w1:
  INC EAX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C84h],EAX

  MOV EAX,y1
  MOV EBX,y2
  CMP EAX,EBX
  JLE @barXOR8_matrox_w2
  XCHG EAX,EBX
@barXOR8_matrox_w2:
  SUB EBX,EAX
  INC EBX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C88h],EAX
  MOV AL,BYTE PTR f
  MOV AH,AL
  SHL EAX,8
  MOV AL,AH
  SHL EAX,8
  MOV AL,AH
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],00067814h
@barXOR8_matrox_busy:
  TEST DWORD PTR [EDI+1E14h],00010000h
  JNZ @barXOR8_matrox_busy
END;

PROCEDURE barXOR16_matrox(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV EBX,x1
  MOV EAX,x2
  CMP EBX,EAX
  JLE @barXOR16_matrox_w1
  XCHG EBX,EAX
@barXOR16_matrox_w1:
  INC EAX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C84h],EAX

  MOV EAX,y1
  MOV EBX,y2
  CMP EAX,EBX
  JLE @barXOR16_matrox_w2
  XCHG EAX,EBX
@barXOR16_matrox_w2:
  SUB EBX,EAX
  INC EBX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C88h],EAX
  MOV AX,WORD PTR f
  SHL EAX,16
  MOV AX,WORD PTR f
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],00067814h
@barXOR16_matrox_busy:
  TEST DWORD PTR [EDI+1E14h],00010000h
  JNZ @barXOR16_matrox_busy
END;

PROCEDURE barXOR32_matrox(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV EBX,x1
  MOV EAX,x2
  CMP EBX,EAX
  JLE @barXOR32_matrox_w1
  XCHG EBX,EAX
@barXOR32_matrox_w1:
  INC EAX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C84h],EAX

  MOV EAX,y1
  MOV EBX,y2
  CMP EAX,EBX
  JLE @barXOR32_matrox_w2
  XCHG EAX,EBX
@barXOR32_matrox_w2:
  SUB EBX,EAX
  INC EBX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C88h],EAX
  MOV EAX,f
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],00067814h
@barXOR32_matrox_busy:
  TEST DWORD PTR [EDI+1E14h],00010000h
  JNZ @barXOR32_matrox_busy
END;

{-------------------------------- barXOR_pattern ----------------------------}

PROCEDURE barXOR8_pattern_matrox(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV EBX,x1
  MOV EAX,x2
  CMP EBX,EAX
  JLE @barXOR8p_matrox_w1
  XCHG EBX,EAX
@barXOR8p_matrox_w1:
  INC EAX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C84h],EAX

  MOV EAX,y1
  MOV EBX,y2
  CMP EAX,EBX
  JLE @barXOR8p_matrox_w2
  XCHG EAX,EBX
@barXOR8p_matrox_w2:
  SUB EBX,EAX
  INC EBX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C88h],EAX
{  CALL setpattern_matrox }
  MOV AL,BYTE PTR f
  MOV AH,AL
  SHL EAX,8
  MOV AL,AH
  SHL EAX,8
  MOV AL,AH
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],40067014h
@barXOR8p_matrox_busy:
  TEST DWORD PTR [EDI+1E14h],00010000h
  JNZ @barXOR8p_matrox_busy
END;

PROCEDURE barXOR16_pattern_matrox(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV EBX,x1
  MOV EAX,x2
  CMP EBX,EAX
  JLE @barXOR16p_matrox_w1
  XCHG EBX,EAX
@barXOR16p_matrox_w1:
  INC EAX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C84h],EAX

  MOV EAX,y1
  MOV EBX,y2
  CMP EAX,EBX
  JLE @barXOR16p_matrox_w2
  XCHG EAX,EBX
@barXOR16p_matrox_w2:
  SUB EBX,EAX
  INC EBX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C88h],EAX
{  CALL setpattern_matrox }
  MOV AX,WORD PTR f
  SHL EAX,16
  MOV AX,WORD PTR f
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],40067014h
@barXOR16p_matrox_busy:
  TEST DWORD PTR [EDI+1E14h],00010000h
  JNZ @barXOR16p_matrox_busy
END;

PROCEDURE barXOR32_pattern_matrox(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,reg_mca
  MOV EBX,x1
  MOV EAX,x2
  CMP EBX,EAX
  JLE @barXOR32p_matrox_w1
  XCHG EBX,EAX
@barXOR32p_matrox_w1:
  INC EAX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C84h],EAX

  MOV EAX,y1
  MOV EBX,y2
  CMP EAX,EBX
  JLE @barXOR32p_matrox_w2
  XCHG EAX,EBX
@barXOR32p_matrox_w2:
  SUB EBX,EAX
  INC EBX
  SHL EAX,16
  MOV AX,BX
  MOV [EDI+1C88h],EAX
{  CALL setpattern_matrox }
  MOV EAX,f
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],40067014h
@barXOR32p_matrox_busy:
  TEST DWORD PTR [EDI+1E14h],00010000h
  JNZ @barXOR32p_matrox_busy
END;

{------------------------- moverect ---------------------------------------}

PROCEDURE moverect_matrox(x1,y1,x2,y2,x,y:longint);assembler;
VAR sgn,scl:longint;
ASM
  MOV EBX,x1
  MOV ECX,x2
  MOV EDX,y1
  MOV EDI,y2

  CMP EBX,ECX
  JLE @mr_matrox_w1
  XCHG EBX,ECX
@mr_matrox_w1:
  CMP EDX,EDI
  JLE @mr_matrox_w2
  XCHG EDX,EDI
@mr_matrox_w2:

  MOV ESI,reg_mca
  MOV EAX,x
  ADD EAX,ECX
  SUB EAX,EBX
  SHL EAX,16
  MOV AX,WORD PTR x
  MOV [ESI+1C84h],EAX

  MOV sgn,0
  MOV EAX,hwascanline
  MOV scl,EAX

  MOV EAX,EDI
  SUB EAX,EDX
  INC EAX
  SHL EAX,16
  MOV AX,WORD PTR y

  CMP DX,AX
  JGE @mr_matrox_w3
  OR sgn,00000004h
  ADD AX,DI
  SUB AX,DX
  MOV EDX,EDI
  NEG scl

@mr_matrox_w3:
  ROR EAX,16
  MOV [ESI+1C88h],EAX

  MOV EAX,hwascanline
  MUL EDX
  MOV EDX,EAX
  ADD EAX,ECX
  ADD EDX,EBX

  CMP EBX,x
  JGE @mr_matrox_w4
  OR sgn,00000001h
  XCHG EAX,EDX

@mr_matrox_w4:
  MOV [ESI+1C60h],EAX
  MOV [ESI+1C6Ch],EDX
  MOV EAX,scl
  MOV [ESI+1C74h],EAX
  MOV EAX,sgn
  MOV [ESI+1C58h],EAX
  MOV DWORD PTR [ESI+1D00h],040C4008h

@mr_matrox_busy:
  TEST DWORD PTR [ESI+1E14h],00010000h
  JNZ @mr_matrox_busy
END;

{=== 3D-Funktionen ==========================================================}
{-- flat-shading ------------------------------------------------------------}

PROCEDURE triangle_flat8_matrox(rend:prender);assembler;
VAR x1,y1,x2a,x2b,y2,x3,y3:longint;
    xd12,yd12,xd13,yd13,xd23,yd23:longint;
ASM
{---------------------------}
  MOV EAX,rend
  MOV EDX,[EAX+04h]
  MOV EDI,[EAX+10h]
  MOV ESI,[EAX+1Ch]
  MOV EAX,0
  MOV EBX,12
  MOV ECX,24

  CMP EDX,EDI
  JLE @tf8_mga_w1
  XCHG EAX,EBX
  XCHG EDX,EDI
@tf8_mga_w1:
  CMP EDX,ESI
  JLE @tf8_mga_w2
  XCHG EAX,ECX
  XCHG EDX,ESI
@tf8_mga_w2:
  CMP EDI,ESI
  JLE @tf8_mga_w3
  XCHG EBX,ECX
  XCHG EDI,ESI
@tf8_mga_w3:
  MOV ESI,rend
  MOV EDX,[ESI+EAX]
  MOV x1,EDX
  MOV EDX,[ESI+EAX+4]
  MOV y1,EDX
  MOV EDX,[ESI+EBX]
  MOV x2a,EDX
  MOV EDX,[ESI+EBX+4]
  MOV y2,EDX
  MOV EDX,[ESI+ECX]
  MOV x3,EDX
  MOV EDX,[ESI+ECX+4]
  MOV y3,EDX
{---------------------------}
  MOV EAX,x2a
  SUB EAX,x1
  MOV xd12,EAX
  MOV EAX,y2
  SUB EAX,y1
  MOV yd12,EAX

  MOV EAX,x3
  SUB EAX,x2a
  MOV xd23,EAX
  MOV EAX,y3
  SUB EAX,y2
  MOV yd23,EAX

  MOV EAX,x3
  SUB EAX,x1
  MOV xd13,EAX
  MOV EAX,y3
  SUB EAX,y1
  MOV yd13,EAX

  JZ @tf8_mga_ende
{---------------------------}
  MOV EAX,xd13
  IMUL yd12
  IDIV yd13
  ADD EAX,x1
  MOV x2b,EAX
{---------------------------}
  MOV EDI,reg_mca
  MOV EAX,[ESI+24h]
  MOV AH,AL
  SHL EAX,8
  MOV AL,AH
  SHL EAX,8
  MOV AL,AH
  MOV [EDI+1C24h],EAX
{---------------------------}
  MOV EAX,x2a
  CMP EAX,x2b
  JLE @tf8_mga_x2a_x2b
{-- x2a>x2b ----------------}
  XOR ESI,ESI
  MOV EBX,xd12
  MOV ECX,xd13
  MOV EDX,xd23

  MOV EAX,EBX
  SAR EAX,31
  XOR EBX,EAX
  SUB EBX,EAX
  AND EAX,00000020h
  OR ESI,EAX

  MOV EAX,ECX
  SAR EAX,31
  XOR ECX,EAX
  SUB ECX,EAX
  AND EAX,00000202h
  OR ESI,EAX

  MOV EAX,EDX
  SAR EAX,31
  XOR EDX,EAX
  SUB EDX,EAX
  AND EAX,00002000h
  OR ESI,EAX

  NEG EBX
  NEG ECX
  NEG EDX

{-- part 1a ----------------}
  MOV EAX,yd13
  MOV [EDI+1C60h],EAX
  MOV EAX,ECX
  SAR EAX,1
  MOV [EDI+1C64h],EAX
  MOV [EDI+1C68h],ECX
  MOV EAX,EBX
  SAR EAX,1
  MOV [EDI+1C70h],EAX
  MOV [EDI+1C74h],EBX
  MOV EAX,yd12
  MOV [EDI+1C78h],EAX
  MOV EAX,x1
  SHL EAX,16
  MOV AX,WORD PTR x1
  MOV [EDI+1C84h],EAX
  MOV EAX,ESI
  MOVZX EAX,AL
  MOV [EDI+1C58h],EAX
  MOV EAX,y1
  SHL EAX,16
  MOV AX,WORD PTR yd12
  MOV [EDI+1C88h],EAX
  MOV DWORD PTR [EDI+1D00h],000C4844h

{-- part 2a ----------------}
  MOV EAX,EDX
  SAR EAX,1
  MOV [EDI+1C70h],EAX
  MOV [EDI+1C74h],EDX
  MOV EAX,yd23
  MOV [EDI+1C78h],EAX
  MOV EAX,x2a
  MOV [EDI+1CACh],EAX
  MOV EAX,ESI
  MOVZX EAX,AH
  MOV [EDI+1C58h],EAX
  MOV EAX,y2
  SHL EAX,16
  MOV AX,WORD PTR yd23
  MOV [EDI+1C88h],EAX
  MOV DWORD PTR [EDI+1D00h],000C4844h

  JMP @tf8_mga_busy

{-- x2a<x2b ----------------}
@tf8_mga_x2a_x2b:
  XOR ESI,ESI
  MOV EBX,xd12
  MOV ECX,xd13
  MOV EDX,xd23

  MOV EAX,EBX
  SAR EAX,31
  XOR EBX,EAX
  SUB EBX,EAX
  AND EAX,00000002h
  OR ESI,EAX

  MOV EAX,ECX
  SAR EAX,31
  XOR ECX,EAX
  SUB ECX,EAX
  AND EAX,00002020h
  OR ESI,EAX

  MOV EAX,EDX
  SAR EAX,31
  XOR EDX,EAX
  SUB EDX,EAX
  AND EAX,00000200h
  OR ESI,EAX

  NEG EBX
  NEG ECX
  NEG EDX

{-- part 1b ----------------}
  MOV EAX,yd12
  MOV [EDI+1C60h],EAX
  MOV EAX,EBX
  SAR EAX,1
  MOV [EDI+1C64h],EAX
  MOV [EDI+1C68h],EBX
  MOV EAX,ECX
  SAR EAX,1
  MOV [EDI+1C70h],EAX
  MOV [EDI+1C74h],ECX
  MOV EAX,yd13
  MOV [EDI+1C78h],EAX
  MOV EAX,x1
  SHL EAX,16
  MOV AX,WORD PTR x1
  MOV [EDI+1C84h],EAX
  MOV EAX,ESI
  MOVZX EAX,AL
  MOV [EDI+1C58h],EAX
  MOV EAX,y1
  SHL EAX,16
  MOV AX,WORD PTR yd12
  MOV [EDI+1C88h],EAX
  MOV DWORD PTR [EDI+1D00h],000C4844h

{-- part 2b ----------------}
  MOV EAX,yd23
  MOV [EDI+1C60h],EAX
  MOV EAX,EDX
  SAR EAX,1
  MOV [EDI+1C64h],EAX
  MOV [EDI+1C68h],EDX
  MOV EAX,x2a
  MOV [EDI+1CA8h],EAX
  MOV EAX,ESI
  MOVZX EAX,AH
  MOV [EDI+1C58h],EAX
  MOV EAX,y2
  SHL EAX,16
  MOV AX,WORD PTR yd23
  MOV [EDI+1C88h],EAX
  MOV DWORD PTR [EDI+1D00h],000C4844h

{-- busy -------------------}
@tf8_mga_busy:
  TEST DWORD PTR [EDI+1E14h],00010000h
  JNZ @tf8_mga_busy
@tf8_mga_ende:
END;

PROCEDURE triangle_flat16_matrox(rend:prender);assembler;
VAR x1,y1,x2a,x2b,y2,x3,y3:longint;
    xd12,yd12,xd13,yd13,xd23,yd23:longint;
ASM
{---------------------------}
  MOV EAX,rend
  MOV EDX,[EAX+04h]
  MOV EDI,[EAX+10h]
  MOV ESI,[EAX+1Ch]
  MOV EAX,0
  MOV EBX,12
  MOV ECX,24

  CMP EDX,EDI
  JLE @tf16_mga_w1
  XCHG EAX,EBX
  XCHG EDX,EDI
@tf16_mga_w1:
  CMP EDX,ESI
  JLE @tf16_mga_w2
  XCHG EAX,ECX
  XCHG EDX,ESI
@tf16_mga_w2:
  CMP EDI,ESI
  JLE @tf16_mga_w3
  XCHG EBX,ECX
  XCHG EDI,ESI
@tf16_mga_w3:
  MOV ESI,rend
  MOV EDX,[ESI+EAX]
  MOV x1,EDX
  MOV EDX,[ESI+EAX+4]
  MOV y1,EDX
  MOV EDX,[ESI+EBX]
  MOV x2a,EDX
  MOV EDX,[ESI+EBX+4]
  MOV y2,EDX
  MOV EDX,[ESI+ECX]
  MOV x3,EDX
  MOV EDX,[ESI+ECX+4]
  MOV y3,EDX
{---------------------------}
  MOV EAX,x2a
  SUB EAX,x1
  MOV xd12,EAX
  MOV EAX,y2
  SUB EAX,y1
  MOV yd12,EAX

  MOV EAX,x3
  SUB EAX,x2a
  MOV xd23,EAX
  MOV EAX,y3
  SUB EAX,y2
  MOV yd23,EAX

  MOV EAX,x3
  SUB EAX,x1
  MOV xd13,EAX
  MOV EAX,y3
  SUB EAX,y1
  MOV yd13,EAX

  JZ @tf16_mga_ende
{---------------------------}
  MOV EAX,xd13
  IMUL yd12
  IDIV yd13
  ADD EAX,x1
  MOV x2b,EAX
{---------------------------}
  MOV EDI,reg_mca
  MOV AX,[ESI+24h]
  SHL EAX,16
  MOV AX,[ESI+24h]
  MOV [EDI+1C24h],EAX
{---------------------------}
  MOV EAX,x2a
  CMP EAX,x2b
  JLE @tf16_mga_x2a_x2b
{-- x2a>x2b ----------------}
  XOR ESI,ESI
  MOV EBX,xd12
  MOV ECX,xd13
  MOV EDX,xd23

  MOV EAX,EBX
  SAR EAX,31
  XOR EBX,EAX
  SUB EBX,EAX
  AND EAX,00000020h
  OR ESI,EAX

  MOV EAX,ECX
  SAR EAX,31
  XOR ECX,EAX
  SUB ECX,EAX
  AND EAX,00000202h
  OR ESI,EAX

  MOV EAX,EDX
  SAR EAX,31
  XOR EDX,EAX
  SUB EDX,EAX
  AND EAX,00002000h
  OR ESI,EAX

  NEG EBX
  NEG ECX
  NEG EDX

{-- part 1a ----------------}
  MOV EAX,yd13
  MOV [EDI+1C60h],EAX
  MOV EAX,ECX
  SAR EAX,1
  MOV [EDI+1C64h],EAX
  MOV [EDI+1C68h],ECX
  MOV EAX,EBX
  SAR EAX,1
  MOV [EDI+1C70h],EAX
  MOV [EDI+1C74h],EBX
  MOV EAX,yd12
  MOV [EDI+1C78h],EAX
  MOV EAX,x1
  SHL EAX,16
  MOV AX,WORD PTR x1
  MOV [EDI+1C84h],EAX
  MOV EAX,ESI
  MOVZX EAX,AL
  MOV [EDI+1C58h],EAX
  MOV EAX,y1
  SHL EAX,16
  MOV AX,WORD PTR yd12
  MOV [EDI+1C88h],EAX
  MOV DWORD PTR [EDI+1D00h],000C4844h

{-- part 2a ----------------}
  MOV EAX,EDX
  SAR EAX,1
  MOV [EDI+1C70h],EAX
  MOV [EDI+1C74h],EDX
  MOV EAX,yd23
  MOV [EDI+1C78h],EAX
  MOV EAX,x2a
  MOV [EDI+1CACh],EAX
  MOV EAX,ESI
  MOVZX EAX,AH
  MOV [EDI+1C58h],EAX
  MOV EAX,y2
  SHL EAX,16
  MOV AX,WORD PTR yd23
  MOV [EDI+1C88h],EAX
  MOV DWORD PTR [EDI+1D00h],000C4844h

  JMP @tf16_mga_busy

{-- x2a<x2b ----------------}
@tf16_mga_x2a_x2b:
  XOR ESI,ESI
  MOV EBX,xd12
  MOV ECX,xd13
  MOV EDX,xd23

  MOV EAX,EBX
  SAR EAX,31
  XOR EBX,EAX
  SUB EBX,EAX
  AND EAX,00000002h
  OR ESI,EAX

  MOV EAX,ECX
  SAR EAX,31
  XOR ECX,EAX
  SUB ECX,EAX
  AND EAX,00002020h
  OR ESI,EAX

  MOV EAX,EDX
  SAR EAX,31
  XOR EDX,EAX
  SUB EDX,EAX
  AND EAX,00000200h
  OR ESI,EAX

  NEG EBX
  NEG ECX
  NEG EDX

{-- part 1b ----------------}
  MOV EAX,yd12
  MOV [EDI+1C60h],EAX
  MOV EAX,EBX
  SAR EAX,1
  MOV [EDI+1C64h],EAX
  MOV [EDI+1C68h],EBX
  MOV EAX,ECX
  SAR EAX,1
  MOV [EDI+1C70h],EAX
  MOV [EDI+1C74h],ECX
  MOV EAX,yd13
  MOV [EDI+1C78h],EAX
  MOV EAX,x1
  SHL EAX,16
  MOV AX,WORD PTR x1
  MOV [EDI+1C84h],EAX
  MOV EAX,ESI
  MOVZX EAX,AL
  MOV [EDI+1C58h],EAX
  MOV EAX,y1
  SHL EAX,16
  MOV AX,WORD PTR yd12
  MOV [EDI+1C88h],EAX
  MOV DWORD PTR [EDI+1D00h],000C4844h

{-- part 2b ----------------}
  MOV EAX,yd23
  MOV [EDI+1C60h],EAX
  MOV EAX,EDX
  SAR EAX,1
  MOV [EDI+1C64h],EAX
  MOV [EDI+1C68h],EDX
  MOV EAX,x2a
  MOV [EDI+1CA8h],EAX
  MOV EAX,ESI
  MOVZX EAX,AH
  MOV [EDI+1C58h],EAX
  MOV EAX,y2
  SHL EAX,16
  MOV AX,WORD PTR yd23
  MOV [EDI+1C88h],EAX
  MOV DWORD PTR [EDI+1D00h],000C4844h

{-- busy -------------------}
@tf16_mga_busy:
  TEST DWORD PTR [EDI+1E14h],00010000h
  JNZ @tf16_mga_busy
@tf16_mga_ende:
END;

PROCEDURE triangle_flat32_matrox(rend:prender);assembler;
VAR x1,y1,x2a,x2b,y2,x3,y3:longint;
    xd12,yd12,xd13,yd13,xd23,yd23:longint;
ASM
{---------------------------}
  MOV EAX,rend
  MOV EDX,[EAX+04h]
  MOV EDI,[EAX+10h]
  MOV ESI,[EAX+1Ch]
  MOV EAX,0
  MOV EBX,12
  MOV ECX,24

  CMP EDX,EDI
  JLE @tf32_mga_w1
  XCHG EAX,EBX
  XCHG EDX,EDI
@tf32_mga_w1:
  CMP EDX,ESI
  JLE @tf32_mga_w2
  XCHG EAX,ECX
  XCHG EDX,ESI
@tf32_mga_w2:
  CMP EDI,ESI
  JLE @tf32_mga_w3
  XCHG EBX,ECX
  XCHG EDI,ESI
@tf32_mga_w3:
  MOV ESI,rend
  MOV EDX,[ESI+EAX]
  MOV x1,EDX
  MOV EDX,[ESI+EAX+4]
  MOV y1,EDX
  MOV EDX,[ESI+EBX]
  MOV x2a,EDX
  MOV EDX,[ESI+EBX+4]
  MOV y2,EDX
  MOV EDX,[ESI+ECX]
  MOV x3,EDX
  MOV EDX,[ESI+ECX+4]
  MOV y3,EDX
{---------------------------}
  MOV EAX,x2a
  SUB EAX,x1
  MOV xd12,EAX
  MOV EAX,y2
  SUB EAX,y1
  MOV yd12,EAX

  MOV EAX,x3
  SUB EAX,x2a
  MOV xd23,EAX
  MOV EAX,y3
  SUB EAX,y2
  MOV yd23,EAX

  MOV EAX,x3
  SUB EAX,x1
  MOV xd13,EAX
  MOV EAX,y3
  SUB EAX,y1
  MOV yd13,EAX

  JZ @tf32_mga_ende
{---------------------------}
  MOV EAX,xd13
  IMUL yd12
  IDIV yd13
  ADD EAX,x1
  MOV x2b,EAX
{---------------------------}
  MOV EDI,reg_mca
  MOV EAX,[ESI+24h]
  MOV [EDI+1C24h],EAX
{---------------------------}
  MOV EAX,x2a
  CMP EAX,x2b
  JLE @tf32_mga_x2a_x2b
{-- x2a>x2b ----------------}
  XOR ESI,ESI
  MOV EBX,xd12
  MOV ECX,xd13
  MOV EDX,xd23

  MOV EAX,EBX
  SAR EAX,31
  XOR EBX,EAX
  SUB EBX,EAX
  AND EAX,00000020h
  OR ESI,EAX

  MOV EAX,ECX
  SAR EAX,31
  XOR ECX,EAX
  SUB ECX,EAX
  AND EAX,00000202h
  OR ESI,EAX

  MOV EAX,EDX
  SAR EAX,31
  XOR EDX,EAX
  SUB EDX,EAX
  AND EAX,00002000h
  OR ESI,EAX

  NEG EBX
  NEG ECX
  NEG EDX

{-- part 1a ----------------}
  MOV EAX,yd13
  MOV [EDI+1C60h],EAX
  MOV EAX,ECX
  SAR EAX,1
  MOV [EDI+1C64h],EAX
  MOV [EDI+1C68h],ECX
  MOV EAX,EBX
  SAR EAX,1
  MOV [EDI+1C70h],EAX
  MOV [EDI+1C74h],EBX
  MOV EAX,yd12
  MOV [EDI+1C78h],EAX
  MOV EAX,x1
  SHL EAX,16
  MOV AX,WORD PTR x1
  MOV [EDI+1C84h],EAX
  MOV EAX,ESI
  MOVZX EAX,AL
  MOV [EDI+1C58h],EAX
  MOV EAX,y1
  SHL EAX,16
  MOV AX,WORD PTR yd12
  MOV [EDI+1C88h],EAX
  MOV DWORD PTR [EDI+1D00h],000C4844h

{-- part 2a ----------------}
  MOV EAX,EDX
  SAR EAX,1
  MOV [EDI+1C70h],EAX
  MOV [EDI+1C74h],EDX
  MOV EAX,yd23
  MOV [EDI+1C78h],EAX
  MOV EAX,x2a
  MOV [EDI+1CACh],EAX
  MOV EAX,ESI
  MOVZX EAX,AH
  MOV [EDI+1C58h],EAX
  MOV EAX,y2
  SHL EAX,16
  MOV AX,WORD PTR yd23
  MOV [EDI+1C88h],EAX
  MOV DWORD PTR [EDI+1D00h],000C4844h

  JMP @tf32_mga_busy

{-- x2a<x2b ----------------}
@tf32_mga_x2a_x2b:
  XOR ESI,ESI
  MOV EBX,xd12
  MOV ECX,xd13
  MOV EDX,xd23

  MOV EAX,EBX
  SAR EAX,31
  XOR EBX,EAX
  SUB EBX,EAX
  AND EAX,00000002h
  OR ESI,EAX

  MOV EAX,ECX
  SAR EAX,31
  XOR ECX,EAX
  SUB ECX,EAX
  AND EAX,00002020h
  OR ESI,EAX

  MOV EAX,EDX
  SAR EAX,31
  XOR EDX,EAX
  SUB EDX,EAX
  AND EAX,00000200h
  OR ESI,EAX

  NEG EBX
  NEG ECX
  NEG EDX

{-- part 1b ----------------}
  MOV EAX,yd12
  MOV [EDI+1C60h],EAX
  MOV EAX,EBX
  SAR EAX,1
  MOV [EDI+1C64h],EAX
  MOV [EDI+1C68h],EBX
  MOV EAX,ECX
  SAR EAX,1
  MOV [EDI+1C70h],EAX
  MOV [EDI+1C74h],ECX
  MOV EAX,yd13
  MOV [EDI+1C78h],EAX
  MOV EAX,x1
  SHL EAX,16
  MOV AX,WORD PTR x1
  MOV [EDI+1C84h],EAX
  MOV EAX,ESI
  MOVZX EAX,AL
  MOV [EDI+1C58h],EAX
  MOV EAX,y1
  SHL EAX,16
  MOV AX,WORD PTR yd12
  MOV [EDI+1C88h],EAX
  MOV DWORD PTR [EDI+1D00h],000C4844h

{-- part 2b ----------------}
  MOV EAX,yd23
  MOV [EDI+1C60h],EAX
  MOV EAX,EDX
  SAR EAX,1
  MOV [EDI+1C64h],EAX
  MOV [EDI+1C68h],EDX
  MOV EAX,x2a
  MOV [EDI+1CA8h],EAX
  MOV EAX,ESI
  MOVZX EAX,AH
  MOV [EDI+1C58h],EAX
  MOV EAX,y2
  SHL EAX,16
  MOV AX,WORD PTR yd23
  MOV [EDI+1C88h],EAX
  MOV DWORD PTR [EDI+1D00h],000C4844h

{-- busy -------------------}
@tf32_mga_busy:
  TEST DWORD PTR [EDI+1E14h],00010000h
  JNZ @tf32_mga_busy
@tf32_mga_ende:
END;

{-- gouraud-shading ---------------------------------------------------------}

PROCEDURE memL32(offs:dword;value:longint);assembler;
ASM
  MOV EDI,offs
  ADD EDI,reg_mca
  MOV EAX,value
  MOV [EDI],EAX
END;

FUNCTION rmemL32(offs:dword):longint;assembler;
ASM
  MOV EDI,offs
  ADD EDI,reg_mca
  MOV EAX,[EDI]
END;

PROCEDURE triangle_gouraud_matrox(rend:prender);
VAR x1,y1,x2a,x2b,y2,x3,y3,h{,lxd,lyd,rxd,ryd}:longint;
    xd12,yd12,xd13,yd13,xd23,yd23,xd,yd:longint;
    sgn:word;
    r1,g1,b1,r2a,g2a,b2a,r2b,g2b,b2b,r3,g3,b3,
    rxd,ryd,gxd,gyd,bxd,byd,hl:longint;
    f1,f2,f3:longint;
BEGIN
{  x1:=longint((p+0)^);
  y1:=longint((p+4)^);
 x2a:=longint((p+12)^);
  y2:=longint((p+16)^);
  x3:=longint((p+24)^);
  y3:=longint((p+28)^);
  f1:=longint((p+36)^);
  f2:=longint((p+40)^);
  f3:=longint((p+44)^); }

  x1:=rend^.points[0].x;
  y1:=rend^.points[0].y;
 x2a:=rend^.points[1].x;
  y2:=rend^.points[1].y;
  x3:=rend^.points[2].x;
  y3:=rend^.points[2].y;
  f1:=rend^.colors[0];
  f2:=rend^.colors[1];
  f3:=rend^.colors[2];

  f1:=getrgbcolor32(f1);
  f2:=getrgbcolor32(f2);
  f3:=getrgbcolor32(f3);

  IF (x2a<x1) THEN
    BEGIN
      h:=x1;x1:=x2a;x2a:=h;
      h:=y1;y1:=y2;y2:=h;
      hl:=f1;f1:=f2;f2:=hl;
    END;
  IF (x3<x1) THEN
    BEGIN
      h:=x1;x1:=x3;x3:=h;
      h:=y1;y1:=y3;y3:=h;
      hl:=f1;f1:=f3;f3:=hl;
    END;
  IF (x3<x2a) THEN
    BEGIN
      h:=x2a;x2a:=x3;x3:=h;
      h:=y2;y2:=y3;y3:=h;
      hl:=f2;f2:=f3;f3:=hl;
    END;

  xd12:=x2a-x1;
  yd12:=y2-y1;
  xd13:=x3-x1;
  yd13:=y3-y1;
  xd23:=x3-x2a;
  yd23:=y3-y2;

  IF (xd13=0) THEN exit;

  yd:=((yd13*xd12*8) DIV xd13)-(yd12*8);

  r1:=longint(byte(f1 SHR 16)) SHL 15;
  g1:=longint(byte(f1 SHR 8)) SHL 15;
  b1:=longint(byte(f1)) SHL 15;
  r2a:=longint(byte(f2 SHR 16)) SHL 15;
  g2a:=longint(byte(f2 SHR 8)) SHL 15;
  b2a:=longint(byte(f2)) SHL 15;
  r3:=longint(byte(f3 SHR 16)) SHL 15;
  g3:=longint(byte(f3 SHR 8)) SHL 15;
  b3:=longint(byte(f3)) SHL 15;

{  r2b:=r1+((r3-r1)*xd12) DIV xd13;
  g2b:=g1+((g3-g1)*xd12) DIV xd13;
  b2b:=b1+((b3-b1)*xd12) DIV xd13;
  ryd:=(r2b-r2a) SHL 3;
  gyd:=(g2b-g2a) SHL 3;
  byd:=(b2b-b2a) SHL 3;   }

  ASM
    MOV EAX,r3
    SUB EAX,r1
    IMUL xd12
    IDIV xd13
    ADD EAX,r1
    SUB EAX,r2a
    SHL EAX,3
    MOV ryd,EAX

    MOV EAX,g3
    SUB EAX,g1
    IMUL xd12
    IDIV xd13
    ADD EAX,g1
    SUB EAX,g2a
    SHL EAX,3
    MOV gyd,EAX

    MOV EAX,b3
    SUB EAX,b1
    IMUL xd12
    IDIV xd13
    ADD EAX,b1
    SUB EAX,b2a
    SHL EAX,3
    MOV byd,EAX
  END;


  IF (y2<y1) THEN
    BEGIN
      h:=x1;x1:=x2a;x2a:=h;
      h:=y1;y1:=y2;y2:=h;
      hl:=f1;f1:=f2;f2:=hl;
    END;
  IF (y3<y1) THEN
    BEGIN
      h:=x1;x1:=x3;x3:=h;
      h:=y1;y1:=y3;y3:=h;
      hl:=f1;f1:=f3;f3:=hl;
    END;
  IF (y3<y2) THEN
    BEGIN
      h:=x2a;x2a:=x3;x3:=h;
      h:=y2;y2:=y3;y3:=h;
      hl:=f2;f2:=f3;f3:=hl;
    END;

  xd12:=x2a-x1;
  yd12:=y2-y1;
  xd13:=x3-x1;
  yd13:=y3-y1;
  xd23:=x3-x2a;
  yd23:=y3-y2;

  IF (yd13=0) THEN exit;

  x2b:=x1+(longint(xd13)*longint(yd12)) DIV yd13;
{  xd:=-xd12*8+(longint(xd13)*longint(yd12)*8) DIV yd13); }


  xd:=((xd13*yd12*8) DIV yd13)-(xd12*8);

  r1:=longint(byte(f1 SHR 16)) SHL 15;
  g1:=longint(byte(f1 SHR 8)) SHL 15;
  b1:=longint(byte(f1)) SHL 15;
  r2a:=longint(byte(f2 SHR 16)) SHL 15;
  g2a:=longint(byte(f2 SHR 8)) SHL 15;
  b2a:=longint(byte(f2)) SHL 15;
  r3:=longint(byte(f3 SHR 16)) SHL 15;
  g3:=longint(byte(f3 SHR 8)) SHL 15;
  b3:=longint(byte(f3)) SHL 15;

{  r2b:=r1+((r3-r1)*yd12) DIV yd13;
  g2b:=g1+((g3-g1)*yd12) DIV yd13;
  b2b:=b1+((b3-b1)*yd12) DIV yd13;
  rxd:=(r2b-r2a) SHL 3;
  gxd:=(g2b-g2a) SHL 3;
  bxd:=(b2b-b2a) SHL 3; }

  ASM
    MOV EAX,r3
    SUB EAX,r1
    IMUL yd12
    IDIV yd13
    ADD EAX,r1
    SUB EAX,r2a
    SHL EAX,3
    MOV rxd,EAX

    MOV EAX,g3
    SUB EAX,g1
    IMUL yd12
    IDIV yd13
    ADD EAX,g1
    SUB EAX,g2a
    SHL EAX,3
    MOV gxd,EAX

    MOV EAX,b3
    SUB EAX,b1
    IMUL yd12
    IDIV yd13
    ADD EAX,b1
    SUB EAX,b2a
    SHL EAX,3
    MOV bxd,EAX
  END;


{  memL32($1C24,f1); }
  IF (xd=0) THEN exit;
  IF (yd=0) THEN exit;

  memL32($1CD0,r1);
  memL32($1CD8,rxd DIV xd);
  memL32($1CDC,ryd DIV yd);
  memL32($1CE0,g1);
  memL32($1CE8,gxd DIV xd);
  memL32($1CEC,gyd DIV yd);
  memL32($1CF0,b1);
  memL32($1CF8,bxd DIV xd);
  memL32($1CFC,byd DIV yd);

  IF (x2a>x2b) THEN
    BEGIN
      sgn:=0;
      IF (xd12<0) THEN sgn:=sgn OR $0020;
      IF (xd13<0) THEN sgn:=sgn OR $0202;
      IF (xd23<0) THEN sgn:=sgn OR $2000;
      xd12:=-abs(xd12);
      xd13:=-abs(xd13);
      xd23:=-abs(xd23);

      memL32($1C60,yd13);
      memL32($1C64,xd13 DIV 2);
      memL32($1C68,xd13);
      memL32($1C70,xd12 DIV 2);
      memL32($1C74,xd12);
      memL32($1C78,yd12);
      memL32($1C58,lo(sgn));
      memL32($1C84,longint(x1+1) SHL 16+x1);
      memL32($1C88,longint(y1) SHL 16+yd12);
      memL32($1D00,$000C4074);

   {   memL32($1CD0,r2b);
      memL32($1CE0,g2b);
      memL32($1CF0,b2b); }

      memL32($1C70,xd23 DIV 2);
      memL32($1C74,xd23);
      memL32($1C78,yd23);
      memL32($1CAC,x2a);
      memL32($1C58,hi(sgn));
      memL32($1C88,longint(y2) SHL 16+yd23);
      memL32($1D00,$000C4074);
    END
  ELSE
    BEGIN
      sgn:=0;
      IF (xd12<0) THEN sgn:=sgn OR $0002;
      IF (xd13<0) THEN sgn:=sgn OR $2020;
      IF (xd23<0) THEN sgn:=sgn OR $0200;
      xd12:=-abs(xd12);
      xd13:=-abs(xd13);
      xd23:=-abs(xd23);

      memL32($1C60,yd12);
      memL32($1C64,xd12 DIV 2);
      memL32($1C68,xd12);
      memL32($1C70,xd13 DIV 2);
      memL32($1C74,xd13);
      memL32($1C78,yd13);
      memL32($1C58,lo(sgn));
      memL32($1C84,longint(x1+1) SHL 16+x1);
      memL32($1C88,longint(y1) SHL 16+yd12);
      memL32($1D00,$000C4074);

      memL32($1C60,yd23);
      memL32($1C64,xd23 DIV 2);
      memL32($1C68,xd23);
      memL32($1CA8,x2a);
      memL32($1CD0,r2a);
      memL32($1CE0,g2a);
      memL32($1CF0,b2a);
      memL32($1C58,hi(sgn));
      memL32($1C88,longint(y2) SHL 16+yd23);
      memL32($1D00,$000C4074);
    END;
  REPEAT
  UNTIL (rmemL32($1E14) AND $00010000=0)
END;

{============================================================================}

PROCEDURE setreslist_matrox(var modelist:PModeEntry);
BEGIN
  AddModeToList(modelist,$20,  640, 400,1,  640, $28,0,$280, 5,3,2,3,0,2, ig_bank+ig_lfb+ig_hwa+ig_col8);
  AddModeToList(modelist,$21,  640, 480,1,  640, $28,0,$280, 5,3,2,3,0,2, ig_bank+ig_lfb+ig_hwa+ig_col8);
  AddModeToList(modelist,$30,  640, 480,2, 1280, $50,0,$280,10,5,5,5,0,5, ig_bank+ig_lfb+ig_hwa+ig_col15);
  AddModeToList(modelist,$31,  640, 480,2, 1280, $50,0,$280,11,5,5,6,0,5, ig_bank+ig_lfb+ig_hwa+ig_col16);
  AddModeToList(modelist,$32,  640, 480,4, 2560, $A0,0,$280,16,8,8,8,0,8, ig_bank+ig_lfb+ig_hwa+ig_col32);
  AddModeToList(modelist,$23,  800, 600,1,  896, $38,0,$380, 5,3,2,3,0,2, ig_bank+ig_lfb+ig_hwa+ig_col8);
  AddModeToList(modelist,$33,  800, 600,2, 1664, $68,0,$340,10,5,5,5,0,5, ig_bank+ig_lfb+ig_hwa+ig_col15);
  AddModeToList(modelist,$34,  800, 600,2, 1664, $68,0,$340,11,5,5,6,0,5, ig_bank+ig_lfb+ig_hwa+ig_col16);
  AddModeToList(modelist,$35,  800, 600,4, 3200, $C8,0,$320,16,8,8,8,0,8, ig_bank+ig_lfb+ig_hwa+ig_col32);
  AddModeToList(modelist,$25, 1024, 768,1, 1024, $40,0,$400, 5,3,2,3,0,2, ig_bank+ig_lfb+ig_hwa+ig_col8);
  AddModeToList(modelist,$36, 1024, 768,2, 2048, $80,0,$400,10,5,5,5,0,5, ig_bank+ig_lfb+ig_hwa+ig_col15);
  AddModeToList(modelist,$37, 1024, 768,2, 2048, $80,0,$400,11,5,5,6,0,5, ig_bank+ig_lfb+ig_hwa+ig_col16);
  AddModeToList(modelist,$38, 1024, 768,4, 4096,$100,0,$400,16,8,8,8,0,8, ig_bank+ig_lfb+ig_hwa+ig_col32);
  AddModeToList(modelist,$27, 1280,1024,1, 1280, $50,0,$500, 5,3,2,3,0,2, ig_bank+ig_lfb+ig_hwa+ig_col8);
  AddModeToList(modelist,$39, 1280,1024,2, 2560, $A0,0,$500,10,5,5,5,0,5, ig_bank+ig_lfb+ig_hwa+ig_col15);
  AddModeToList(modelist,$3A, 1280,1024,2, 2560, $A0,0,$500,11,5,5,6,0,5, ig_bank+ig_lfb+ig_hwa+ig_col16);
  AddModeToList(modelist,$3C, 1600,1200,1, 1664, $68,0,$680, 5,3,2,3,0,2, ig_bank+ig_lfb+ig_hwa+ig_col8);
  AddModeToList(modelist,$3D, 1600,1200,2, 3200, $C8,0,$640,10,5,5,5,0,5, ig_bank+ig_lfb+ig_hwa+ig_col15);
  AddModeToList(modelist,$3E, 1600,1200,2, 3200, $C8,0,$640,11,5,5,6,0,5, ig_bank+ig_lfb+ig_hwa+ig_col16);

{  AddModeToList(modelist,$32,  640, 480,3, 1920, $78,0,   0,16,8,8,8,0,8, ig_bank+ig_lfb+ig_hwa+ig_col24);
  AddModeToList(modelist,$38, 1024, 768,3, 3072, $C0,0,   0,16,8,8,8,0,8, ig_bank+ig_lfb+ig_hwa+ig_col24); }
END;

{============================================================================}

PROCEDURE sethwaprocs_matrox(col:longint);
BEGIN
  CASE col OF
    ig_col8:
      BEGIN
        graphwinHW:=@graphwinHW_matrox;
        setpatternHW:=@setpatternHW_matrox;
        line:=@line8_matrox;
        lineXOR:=@lineXOR8_matrox;
        lineH:=@lineH8_matrox;
        lineH_solid:=@lineH8_matrox;
        lineH_pattern:=@lineH8_pattern_matrox;
        bar:=@bar8_matrox;
        bar_solid:=@bar8_matrox;
        bar_pattern:=@bar8_pattern_matrox;
        barXOR:=@barXOR8_matrox;
        barXOR_solid:=@barXOR8_matrox;
        barXOR_pattern:=@barXOR8_pattern_matrox;
        moverect:=@moverect_matrox;
      END;
    ig_col15:
      BEGIN
        graphwinHW:=@graphwinHW_matrox;
        setpatternHW:=@setpatternHW_matrox;
        line:=@line16_matrox;
        lineXOR:=@lineXOR16_matrox;
        lineH:=@lineH16_matrox;
        lineH_solid:=@lineH16_matrox;
        lineH_pattern:=@lineH16_pattern_matrox;
        bar:=@bar16_matrox;
        bar_solid:=@bar16_matrox;
        bar_pattern:=@bar16_pattern_matrox;
        barXOR:=@barXOR16_matrox;
        barXOR_solid:=@barXOR16_matrox;
        barXOR_pattern:=@barXOR16_pattern_matrox;
        moverect:=@moverect_matrox;
      END;
    ig_col16:
      BEGIN
        graphwinHW:=@graphwinHW_matrox;
        setpatternHW:=@setpatternHW_matrox;
        line:=@line16_matrox;
        lineXOR:=@lineXOR16_matrox;
        lineH:=@lineH16_matrox;
        lineH_solid:=@lineH16_matrox;
        lineH_pattern:=@lineH16_pattern_matrox;
        bar:=@bar16_matrox;
        bar_solid:=@bar16_matrox;
        bar_pattern:=@bar16_pattern_matrox;
        barXOR:=@barXOR16_matrox;
        barXOR_solid:=@barXOR16_matrox;
        barXOR_pattern:=@barXOR16_pattern_matrox;
        moverect:=@moverect_matrox;
      END;
    ig_col24:
      BEGIN
        graphwinHW:=@graphwinHW_matrox;
        setpatternHW:=@setpatternHW_matrox;
      END;
    ig_col32:
      BEGIN
        graphwinHW:=@graphwinHW_matrox;
        setpatternHW:=@setpatternHW_matrox;
        line:=@line32_matrox;
        lineXOR:=@lineXOR32_matrox;
        lineH:=@lineH32_matrox;
        lineH_solid:=@lineH32_matrox;
        lineH_pattern:=@lineH32_pattern_matrox;
        bar:=@bar32_matrox;
        bar_solid:=@bar32_matrox;
        bar_pattern:=@bar32_pattern_matrox;
        barXOR:=@barXOR32_matrox;
        barXOR_solid:=@barXOR32_matrox;
        barXOR_pattern:=@barXOR32_pattern_matrox;
        moverect:=@moverect_matrox;
      END;
  END;
END;

END.
