{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

{============================================================================}
{ Trident                                                                    }
{============================================================================}
{$I gxglobal.cfg}
UNIT gxhw_trd;

INTERFACE

USES gxbase,gxpci,gx3dtype,gxsup,gxmem;
{$I gxlocal.cfg}

PROCEDURE sethwaprocs_trident(col:longint);
{PROCEDURE setupdevice_trident(baseaddr:dword;var pcidev:TPCIdevice);
PROCEDURE adjustaddresses_trident(old_ds_base,new_ds_base:dword); }
PROCEDURE setreslist_trident(mem,chipid:dword;var modelist:PModeEntry);
FUNCTION detectchip_trident(var chipid:dword;var name:string):longint;
FUNCTION detectmem_trident:longint;
PROCEDURE enableregs_trident;
PROCEDURE disableregs_trident;
PROCEDURE scanline_trident(linewidth:word);
PROCEDURE displaystart_trident(offs:dword);
PROCEDURE bankswitch_trident_a;
PROCEDURE bankswitch_trident_b;
PROCEDURE enableLFB_trident(physaddr:dword);
PROCEDURE enableLFB_trident_pci(physaddr:dword);
PROCEDURE disableLFB_trident;
PROCEDURE enableMMIO_trident(physaddr:dword);
PROCEDURE disableMMIO_trident;
PROCEDURE enableHWA_trident(col,init,bpl,bpp,pix:longint);
PROCEDURE disableHWA_trident;

IMPLEMENTATION

USES gxcrtext,graphix,gxtype;
{
VAR mmiomap0:tmmiomap;
    mmiomap1:tmmiomap;
    option,devid:longint; }
{    patbuf:array[0..7] of byte; }

{PROCEDURE setupdevice_trident(baseaddr:dword;var pcidev:TPCIdevice);
BEGIN
  devid:=0;
  option:=0;
END;

PROCEDURE adjustaddresses_trident(old_ds_base,new_ds_base:dword);
BEGIN
  adjustaddress(lfbbase,old_ds_base,new_ds_base);
END;}

{----------------------------------------------------------------------------}

FUNCTION detectchip_trident(var chipid:dword;var name:string):longint;
VAR chip:word;
BEGIN
  ASM
    MOV DX,03C4h
    MOV AL,0Bh
    OUT DX,AL
    INC DX
    IN AL,DX
    DEC DX
    MOV BL,AL

    MOV AL,0Eh
    OUT DX,AL
    INC DX
    IN AL,DX
    MOV BH,AL

    MOV AL,00h
    OUT DX,AL

    IN AL,DX
    MOV CL,AL
    AND CL,0Fh

    MOV AL,BH
    OUT DX,AL

    CMP CL,02h
    JNE @trid_not_detected
    XOR AL,02h
    OUT DX,AL

    MOV AL,09h
    MOV DX,03C4h
    OUT DX,AL
    INC DX
    IN AL,DX
    MOV AH,BL
    JMP @trid_ende
  @trid_not_detected:
    XOR AX,AX
  @trid_ende:
    MOV chip,AX
  END;
  CASE chip OF
    $0000:;
    $0100..$01FF:name:='Trident TR8800BR';
    $0200..$02FF:name:='Trident TR8800CS';
    $0300..$03FF:name:='Trident TR8900B';
    $0400..$04FF:name:='Trident TVGA8900C';
    $1300..$13FF:name:='Trident TVGA8900C';
    $2300..$23FF:name:='Trident TR9000';
    $3300..$33FF:name:='Trident TVGA8900CL, TVGA8900D or TVGA9000C';
    $4300..$43FF:name:='Trident TVGA9000i';
    $5300..$53FF:name:='Trident TR9200CXr';
    $6300..$63FF:name:='Trident TLCD9100B';
    $7300..$73FF:name:='Trident TGUI9420';
    $8300..$83FF:name:='Trident TRLX8200';
    $9300..$93FF:name:='Trident TGUI9400CXi';
    $A300..$A3FF:name:='Trident TLCD9320';
    $C300..$C3FF:name:='Trident TGUI9420DGi';
    $D300       :name:='Trident TGUI9660XGi';
    $D301       :name:='Trident TGUI9680Xgi';
    $D302       :name:='Trident TGUI9680-1 (CR)';
    $D303..$D30F:name:='Trident TGUI9680';
    $D310..$D31F:name:='Trident Providia9682';
    $D320..$D32F:name:='Trident Providia9685';
    $D330..$D33F:name:='Trident Cyber9385';
    $D340..$D347:name:='Trident Cyber9382';
    $D348..$D34F:name:='Trident Cyber9386';
    $D350..$D35F:name:='Trident Providia9692';
    $D360..$D3FF:name:='Trident TGUI9660 unknown';
    $E300       :name:='Trident TGUI9440';
    $E301       :name:='Trident TGUI9440_1';
    $E382       :name:='Trident TGUI9470';
    $E302..$E381,
    $E383..$E3FF:name:='Trident TGUI9440AGi';
    $F300       :name:='Trident 3Dimage975';
    $F301       :name:='Trident Jaguar-B';
    $F308       :name:='Trident 3Dimage985';
    $F30B       :name:='Trident 3Dimage985';
    $F320       :name:='Trident Cyber9387';
    $F350       :name:='Trident Cyber9387';
    ELSE name:='Trident - unknown - ID '+hexword(chipid);
  END;
  chipid:=chip;
  detectchip_trident:=chip;
END;

FUNCTION detectmem_trident:longint;
VAR m:byte;
BEGIN
  ASM
    MOV DX,03D4h
    MOV AL,1Fh
    OUT DX,AL
    INC DX
    IN AL,DX
    AND AL,07h
    MOV m,AL
    AND AL,0Fh
  END;
  CASE m OF
    $00:detectmem_trident:=256;
    $01:detectmem_trident:=512;
    $02:detectmem_trident:=768;
    $03:detectmem_trident:=1024;
    $04:detectmem_trident:=256;
    $05:detectmem_trident:=512;
    $06:detectmem_trident:=768;
    $07:detectmem_trident:=2048;
  END;
END;

{----------------------------------------------------------------------------}

PROCEDURE enableregs_trident;assembler;
ASM
  MOV DX,03C4h
  MOV AL,0Bh
  OUT DX,AL
  INC DX
  IN AL,DX
  DEC DX
  MOV AX,800Eh
  OUT DX,AX
END;

PROCEDURE disableregs_trident;
BEGIN
END;

PROCEDURE scanline_trident(linewidth:word);assembler;
ASM
{??? - notwendig fr bit 8}
  MOV DX,03C4h
  MOV AX,800Eh
  OUT DX,AX
{bit 0-7}
  MOV DX,03D4h
  MOV AH,BYTE PTR linewidth
  MOV AL,13h
  OUT DX,AX
{bit 8}
  MOV AX,linewidth
  AND AH,01h
  SHL AH,4

  MOV DX,03D4h
  MOV AL,29h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0EFh
  OR AL,AH
  OUT DX,AL
END;

PROCEDURE displaystart_trident(offs:dword);assembler;
ASM
  MOV EBX,offs
{bit 0-7-}
  SHR EBX,2
  MOV DX,03D4h
  MOV AH,BL
  MOV AL,0Dh
  OUT DX,AX
{bit 8-15}
  SHR EBX,8
  MOV DX,03D4h
  MOV AH,BL
  MOV AL,0Ch
  OUT DX,AX
{bit 16}
  SHR EBX,1
  SHR BL,2
  AND BL,20h
  MOV AL,1Eh
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0DFh
  OR AL,BL
  OUT DX,AL
  DEC DX
{bit 17-18}
  SHR EBX,2
  SHR BL,6
  AND BL,03h
  MOV AL,27h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0FCh
  OR AL,BL
  OUT DX,AL
END;

PROCEDURE bankswitch_trident_a;assembler;
ASM
  MOV AH,DL
  XOR AH,02h
  MOV AL,0Eh
  MOV DX,03C4h
  OUT DX,AX
END;

PROCEDURE bankswitch_trident_b;assembler;
ASM
  MOV AL,DL
  MOV DX,03D8h
  OUT DX,AL
END;

PROCEDURE enableLFB_trident(physaddr:dword);assembler;
ASM
  MOV DX,03D4h {disable LFB}
  MOV AL,21h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0DFh
  OUT DX,AL
  DEC DX

  MOV EBX,physaddr {Set LFB addr}
  SHR EBX,20
  MOV BH,BL
  SHL BH,2
  AND BX,0C00Fh
  OR BL,BH
  MOV AX,3021h
  OR AH,BL
  OUT DX,AX
END;

PROCEDURE enableLFB_trident_pci(physaddr:dword);assembler;
ASM
  MOV DX,03D4h {enable LFB}
  MOV AL,21h
  OUT DX,AL
  INC DX
  IN AL,DX
  OR AL,20h
  OUT DX,AL
END;

PROCEDURE disableLFB_trident;assembler;
ASM
  MOV DX,03D4h {disable LFB}
  MOV AL,21h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0DFh
  OUT DX,AL
END;

PROCEDURE enableMMIO_trident(physaddr:dword);assembler;
ASM
  MOV DX,03D4h
  MOV AL,36h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0F8h
  OR AL,02h
  OUT DX,AL
END;

PROCEDURE disableMMIO_trident;assembler;
ASM
  MOV DX,03D4h
  MOV AL,36h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0FCh
  OUT DX,AL
END;

{------------------------------- Hardware-Acceleration ----------------------}

PROCEDURE enableHWA_trident(col,init,bpl,bpp,pix:longint);
VAR mode:word;
BEGIN
  ASM
    MOV DX,03D4h
    MOV AL,36h
    OUT DX,AL
    INC DX
    IN AL,DX
    AND AL,0F8h
    OR AL,86h
    OUT DX,AL
  END;

{  port[$03D4]:=$36;
  port[$03D5]:=(port[$03D5] AND $F8) OR $84; }

{  CASE curcol OF
    col8:x:=$00;
    col15,col16:x:=$04;
    col24:x:=$08;
    col32:x:=$0C;
  END; }

{  CMP col,ig_col8
  JNE @eh_trid_w1
  MOV AH,00h
  MOV BX,0000h
@eh_trid_w1:
  CMP col,ig_col15
  JNE @eh_trid_w2
  MOV AH,04h
  MOV BX,0001h
@eh_trid_w2:
  CMP col,ig_col16
  JNE @eh_trid_w3
  MOV AH,04h
  MOV BX,0001h
@eh_trid_w3:
  CMP col,ig_col24
  JNE @eh_trid_w4
  MOV AH,08h
  MOV BX,0003h
@eh_trid_w4:
  CMP col,ig_col32
  JNE @eh_trid_w5
  MOV AH,0Ch
  MOV BX,0002h
@eh_trid_w5: }


{  port[$03D4]:=$38;
  port[$03D5]:=(port[$03D5] AND $D2) OR x OR $01; }

{  ASM
    MOV DX,03D4h
    MOV AL,38h
    OUT DX,AL
    INC DX
    IN AL,DX
    AND AL,0D2h
    OR AL,AH
    OR AL,01h
    OUT DX,AL
  END;}

  mode:=0;
  CASE col OF
    ig_col8: mode:=mode OR $0000;
    ig_col15:mode:=mode OR $0001;
    ig_col16:mode:=mode OR $0001;
    ig_col24:mode:=mode OR $0003;
    ig_col32:mode:=mode OR $0002;
  END;
  CASE pix OF
    640:mode:=mode OR $0000;
    800:mode:=mode OR $3000;
    832:mode:=mode OR $1000;
   1024:mode:=mode OR $9000;
   1280:mode:=mode OR $2000;
   1600:mode:=mode OR $8000;
  END;
  CASE roundpower2(bpl) OF
    512:mode:=mode OR $0000;
   1024:mode:=mode OR $0004;
   2048:mode:=mode OR $0008;
   4096:mode:=mode OR $000C;
  END;
  word(pointer(mmiooffs+$22)^):=mode;
END;

PROCEDURE disableHWA_trident;assembler;
ASM
  MOV DX,03D4h
  MOV AL,36h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,07Ch
  OUT DX,AL
END;

PROCEDURE graphwinhw_trident(x1,y1,x2,y2:longint);assembler;
ASM
  MOV EDI,MMIOoffs
  MOV EAX,frontdrawoffsety
  MOV [EDI+00h],EAX
  MOV [EDI+08h],EAX
  MOV AX,WORD PTR x1
  MOV [EDI+48h],AX
  MOV AX,WORD PTR y1
  MOV [EDI+4Ah],AX
  MOV AX,WORD PTR x2
  MOV [EDI+4Ch],AX
  MOV AX,WORD PTR y2
  MOV [EDI+4Eh],AX
END;

PROCEDURE setpatternHW_trident(pattern:PPattern);assembler;
ASM
  MOV EDI,mmiooffs
  MOV WORD PTR [EDI+34h],0
  ADD EDI,80h
  MOV ESI,pattern
  MOV ECX,8
@loop:
  LODSB
  SHL AX,1
  ROR AH,2
  SHL AX,1
  ROR AH,2
  SHL AX,1
  ROR AH,2
  SHL AX,1
  ROR AH,2
  SHL AX,1
  ROR AH,2
  SHL AX,1
  ROR AH,2
  SHL AX,1
  ROR AH,2
  SHL AX,1
  ROR AH,1
  MOV AL,AH
  STOSB
  DEC ECX
  JNZ @loop
END;

{PROCEDURE setpattern_trident;assembler;
ASM
  MOV EDI,mmiooffs
  MOV ESI,OFFSET patbuf
  ADD EDI,80h
  MOVSD
  MOVSD
END;}

{----------------------------- line ---------------------------------------}

PROCEDURE line_trident(x1,y1,x2,y2,f:longint);assembler;
{VAR min,max,xd,yd,k1,k2:integer; }
VAR flags:word;
ASM
  MOV EDI,x1
  MOV ESI,y1
  MOV ECX,x2
  MOV EBX,y2

  CMP hwaclip,0
  JNE @lin_hwaclip

  CMP ESI,EBX
  JLE @lin_w0y
  XCHG EDI,ECX
  XCHG ESI,EBX
@lin_w0y:
  CMP EBX,vy1
  JL @lin_trid_end
  CMP ESI,vy2
  JG @lin_trid_end
  PUSH ECX
  PUSH EBX
  SUB ECX,EDI
  SUB EBX,ESI
  JZ @lin_noy
  MOV EAX,ECX
  SHL EAX,16
  CDQ
  IDIV EBX
  POP EBX
  POP ECX
  CMP ESI,vy1
  JGE @lin_w0y1
  PUSH EAX
  MOV EDX,vy1
  SUB EDX,ESI
  IMUL EDX
  SAR EAX,16
  ADD EDI,EAX
  MOV ESI,vy1
  POP EAX
@lin_w0y1:
  CMP EBX,vy2
  JLE @lin_w0y2
  PUSH EAX
  MOV EDX,vy2
  SUB EDX,EBX
  IMUL EDX
  SAR EAX,16
  ADD ECX,EAX
  MOV EBX,vy2
  POP EAX
@lin_w0y2:
  JMP @lin_joy
@lin_noy:
  POP EBX
  POP ECX
@lin_joy:

  CMP EDI,ECX
  JLE @lin_w0x
  XCHG EDI,ECX
  XCHG ESI,EBX
@lin_w0x:
  CMP ECX,vx1
  JL @lin_trid_end
  CMP EDI,vx2
  JG @lin_trid_end
  PUSH ECX
  PUSH EBX
  SUB ECX,EDI
  JZ @lin_nox
  SUB EBX,ESI
  MOV EAX,EBX
  SHL EAX,16
  CDQ
  IDIV ECX
  POP EBX
  POP ECX
  CMP EDI,vx1
  JGE @lin_w0x1
  PUSH EAX
  MOV EDX,vx1
  SUB EDX,EDI
  IMUL EDX
  SAR EAX,16
  ADD ESI,EAX
  MOV EDI,vx1
  POP EAX
@lin_w0x1:
  CMP ECX,vx2
  JLE @lin_w0x2
  PUSH EAX
  MOV EDX,vx2
  SUB EDX,ECX
  IMUL EDX
  SAR EAX,16
  ADD EBX,EAX
  MOV ECX,vx2
  POP EAX
@lin_w0x2:
  JMP @lin_jox
@lin_nox:
  POP EBX
  POP ECX
@lin_jox:

@lin_hwaclip:

  PUSH EDI
  PUSH ESI
  PUSH ECX
  PUSH EBX
  POP EDX
  POP ECX
  POP EBX
  POP EAX

  MOV flags,0C000h
  SUB ECX,EAX
  SUB EDX,EBX

{  xd:=x2-x1;
  yd:=y2-y1;
  flags:=$C000; }

  OR ECX,ECX
  JNS @lin_trid_w1
  NEG ECX
  OR flags,0200h
@lin_trid_w1:

  OR EDX,EDX
  JNS @lin_trid_w2
  NEG EDX
  OR flags,0100h
@lin_trid_w2:

  CMP ECX,EDX
  JGE @lin_trid_w3
  XCHG ECX,EDX
  OR flags,0400h
@lin_trid_w3:

{ min=EDX, max=ECX }


{  IF (xd<0) THEN flags:=flags OR $0200;
  IF (yd<0) THEN flags:=flags OR $0100;
  xd:=abs(xd);
  yd:=abs(yd); }


{  IF (yd<xd) THEN
    BEGIN
      min:=yd;
      max:=xd;
    END
  ELSE
    BEGIN
      min:=xd;
      max:=yd;
      flags:=flags OR $0400;
    END; }

{  WHILE (port[$2120] AND $80>0) DO; }

{  port[$2127]:=$F0;
  portW[$212C]:=f;
  portW[$212E]:=f SHR 16;
  portW[$2138]:=x1;
  portW[$213A]:=y1; }

  MOV EDI,MMIOoffs

  SHL EBX,16
  MOV BX,AX
  MOV EAX,f
  MOV BYTE PTR [EDI+27h],0F0h
  MOV [EDI+2Ch],EAX
  MOV [EDI+38h],EBX


{  portW[$213C]:=2*(min-max);
  portW[$213E]:=2*min;  }

  MOV AX,DX
  SHL EAX,17
  MOV AX,DX
  SUB AX,CX
  SHL AX,1
  MOV [EDI+3Ch],EAX


{  portW[$2140]:=2*min-max;
  portW[$2142]:=max;   }

  MOV AX,CX
  SHL EAX,16
  MOV AX,DX
  SHL AX,1
  SUB AX,CX
  MOV [EDI+40h],EAX

{  portW[$2128]:=flags;
  port[$2124]:=$04; }

  MOV EAX,frontdrawoffsetpix
  MOV [EDI+00h],EAX
  MOV [EDI+08h],EAX

  MOV AX,flags
  MOV WORD PTR [EDI+28h],AX
  MOV BYTE PTR [EDI+24h],04h
@lin_trid_busy:
  TEST BYTE PTR [EDI+20h],80h
  JNZ @lin_trid_busy
@lin_trid_end:
END;

{-------------------------------- lineh -------------------------------------}

PROCEDURE lineh_trident(x1,x2,y,f:longint);assembler;
ASM
  MOV EAX,x1
  MOV ECX,x2
  MOV EBX,y

  CMP EAX,ECX
  JLE @lh_trid_w1
  XCHG EAX,ECX
@lh_trid_w1:

  CMP EBX,vy1
  JL @lh_trid_ende
  CMP EBX,vy2
  JG @lh_trid_ende
  CMP EAX,vx2
  JG @lh_trid_ende
  CMP ECX,vx1
  JL @lh_trid_ende

  CMP HWAclip,0
  JNE @lh_trid_hwclip
  CMP EAX,vx1
  JGE @lh_trid_nc1
  MOV EAX,vx1
@lh_trid_nc1:
  CMP ECX,vx2
  JLE @lh_trid_nc2
  MOV ECX,vx2
@lh_trid_nc2:
  ADD EBX,frontdrawoffsety
@lh_trid_hwclip:
  SUB ECX,EAX
  SHL EBX,16
  MOV BX,AX
  MOV EDI,MMIOoffs
  MOV EAX,f
  MOV BYTE PTR [EDI+27h],0F0h
  MOV WORD PTR [EDI+28h],4000h
  MOV [EDI+2Ch],EAX
  MOV [EDI+38h],EBX
  MOV [EDI+40h],CX
  MOV BYTE PTR [EDI+24h],03h
@lh_trid_busy:
  TEST BYTE PTR [EDI+20h],80h
  JNZ @lh_trid_busy
@lh_trid_ende:
END;

{-------------------------------- lineh_pattern -----------------------------}

PROCEDURE lineh_pattern_trident(x1,x2,y,f:longint);assembler;
ASM
  MOV EAX,x1
  MOV ECX,x2
  MOV EBX,y

  CMP EAX,ECX
  JLE @lh_trid_w1
  XCHG EAX,ECX
@lh_trid_w1:

  CMP EBX,vy1
  JL @lh_trid_ende
  CMP EBX,vy2
  JG @lh_trid_ende
  CMP EAX,vx2
  JG @lh_trid_ende
  CMP ECX,vx1
  JL @lh_trid_ende

  CMP HWAclip,0
  JNE @lh_trid_hwclip
  CMP EAX,vx1
  JGE @lh_trid_nc1
  MOV EAX,vx1
@lh_trid_nc1:
  CMP ECX,vx2
  JLE @lh_trid_nc2
  MOV ECX,vx2
@lh_trid_nc2:
  ADD EBX,frontdrawoffsety
@lh_trid_hwclip:
{  CALL setpattern_trident }
  SUB ECX,EAX
  SHL EBX,16
  MOV BX,AX
  MOV EDI,MMIOoffs
  MOV EAX,f
  MOV BYTE PTR [EDI+27h],0F0h
  MOV WORD PTR [EDI+28h],1020h
  MOV WORD PTR [EDI+2Ah],0h
  MOV [EDI+2Ch],EAX
  MOV [EDI+38h],EBX
  MOV [EDI+40h],CX
  MOV BYTE PTR [EDI+24h],03h
@lh_trid_busy:
  TEST BYTE PTR [EDI+20h],80h
  JNZ @lh_trid_busy
@lh_trid_ende:
END;

{-------------------------------- bar ---------------------------------------}

PROCEDURE bar_trident(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EAX,x1
  MOV EBX,y1
  MOV ECX,x2
  MOV EDX,y2
  CMP EAX,ECX
  JLE @bar_trid_w1
  XCHG EAX,ECX
@bar_trid_w1:
  CMP EBX,EDX
  JLE @bar_trid_w2
  XCHG EBX,EDX
@bar_trid_w2:

  CMP EDX,vy1
  JL @bar_trid_ende
  CMP EBX,vy2
  JG @bar_trid_ende
  CMP EAX,vx2
  JG @bar_trid_ende
  CMP ECX,vx1
  JL @bar_trid_ende

  CMP HWAclip,0
  JNE @bar_trid_hwclip
  CMP EAX,vx1
  JGE @bar_trid_nc1
  MOV EAX,vx1
@bar_trid_nc1:
  CMP EBX,vy1
  JGE @bar_trid_nc2
  MOV EBX,vy1
@bar_trid_nc2:
  CMP ECX,vx2
  JLE @bar_trid_nc3
  MOV ECX,vx2
@bar_trid_nc3:
  CMP EDX,vy2
  JLE @bar_trid_nc4
  MOV EDX,vy2
@bar_trid_nc4:
  ADD EBX,frontdrawoffsety
  ADD EDX,frontdrawoffsety
@bar_trid_hwclip:
  SUB ECX,EAX
  SUB EDX,EBX
  SHL EDX,16
  MOV DX,CX
  SHL EBX,16
  MOV BX,AX
  MOV EDI,MMIOoffs
  MOV EAX,f
  MOV BYTE PTR [EDI+27h],0F0h
  MOV WORD PTR [EDI+28h],4000h
  MOV [EDI+2Ch],EAX
  MOV [EDI+38h],EBX
  MOV [EDI+40h],EDX
  MOV BYTE PTR [EDI+24h],01h
@bar_trid_busy:
  TEST BYTE PTR [EDI+20h],80h
  JNZ @bar_trid_busy
@bar_trid_ende:
END;

{----------------------------- bar_pattern ----------------------------------}

PROCEDURE bar_pattern_trident(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EAX,x1
  MOV EBX,y1
  MOV ECX,x2
  MOV EDX,y2
  CMP EAX,ECX
  JLE @bar_trid_w1
  XCHG EAX,ECX
@bar_trid_w1:
  CMP EBX,EDX
  JLE @bar_trid_w2
  XCHG EBX,EDX
@bar_trid_w2:

  CMP EDX,vy1
  JL @bar_trid_ende
  CMP EBX,vy2
  JG @bar_trid_ende
  CMP EAX,vx2
  JG @bar_trid_ende
  CMP ECX,vx1
  JL @bar_trid_ende

  CMP HWAclip,0
  JNE @bar_trid_hwclip
  CMP EAX,vx1
  JGE @bar_trid_nc1
  MOV EAX,vx1
@bar_trid_nc1:
  CMP EBX,vy1
  JGE @bar_trid_nc2
  MOV EBX,vy1
@bar_trid_nc2:
  CMP ECX,vx2
  JLE @bar_trid_nc3
  MOV ECX,vx2
@bar_trid_nc3:
  CMP EDX,vy2
  JLE @bar_trid_nc4
  MOV EDX,vy2
@bar_trid_nc4:
  ADD EBX,frontdrawoffsety
  ADD EDX,frontdrawoffsety
@bar_trid_hwclip:
{  CALL setpattern_trident }
  SUB ECX,EAX
  SUB EDX,EBX
  SHL EDX,16
  MOV DX,CX
  SHL EBX,16
  MOV BX,AX
  MOV EDI,MMIOoffs
  MOV EAX,f
  MOV BYTE PTR [EDI+27h],0F0h
  MOV WORD PTR [EDI+28h],1020h
  MOV [EDI+2Ch],EAX
  MOV [EDI+38h],EBX
  MOV [EDI+40h],EDX
  MOV BYTE PTR [EDI+24h],01h
@bar_trid_busy:
  TEST BYTE PTR [EDI+20h],80h
  JNZ @bar_trid_busy
@bar_trid_ende:
END;

{-------------------------------- barxor ------------------------------------}

PROCEDURE barXOR_trident(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EAX,x1
  MOV EBX,y1
  MOV ECX,x2
  MOV EDX,y2
  CMP EAX,ECX
  JLE @barx_trid_w1
  XCHG EAX,ECX
@barx_trid_w1:
  CMP EBX,EDX
  JLE @barx_trid_w2
  XCHG EBX,EDX
@barx_trid_w2:

  CMP EDX,vy1
  JL @barx_trid_ende
  CMP EBX,vy2
  JG @barx_trid_ende
  CMP EAX,vx2
  JG @barx_trid_ende
  CMP ECX,vx1
  JL @barx_trid_ende

  CMP HWAclip,0
  JNE @barx_trid_hwclip
  CMP EAX,vx1
  JGE @barx_trid_nc1
  MOV EAX,vx1
@barx_trid_nc1:
  CMP EBX,vy1
  JGE @barx_trid_nc2
  MOV EBX,vy1
@barx_trid_nc2:
  CMP ECX,vx2
  JLE @barx_trid_nc3
  MOV ECX,vx2
@barx_trid_nc3:
  CMP EDX,vy2
  JLE @barx_trid_nc4
  MOV EDX,vy2
@barx_trid_nc4:
  ADD EBX,frontdrawoffsety
  ADD EDX,frontdrawoffsety
@barx_trid_hwclip:
  SUB EDX,EBX
  SUB ECX,EAX
  SHL EDX,16
  MOV DX,CX
  SHL EBX,16
  MOV BX,AX
  MOV EDI,MMIOoffs
  MOV EAX,f
  MOV BYTE PTR [EDI+27h],05Ah
  MOV WORD PTR [EDI+28h],4000h
  MOV [EDI+2Ch],EAX
  MOV [EDI+38h],EBX
  MOV [EDI+40h],EDX
  MOV BYTE PTR [EDI+24h],01h
@barx_trid_busy:
  TEST BYTE PTR [EDI+20h],80h
  JNZ @barx_trid_busy
@barx_trid_ende:
END;

{-------------------------------- barxor_pattern ----------------------------}

PROCEDURE barXOR_pattern_trident(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EAX,x1
  MOV EBX,y1
  MOV ECX,x2
  MOV EDX,y2
  CMP EAX,ECX
  JLE @barx_trid_w1
  XCHG EAX,ECX
@barx_trid_w1:
  CMP EBX,EDX
  JLE @barx_trid_w2
  XCHG EBX,EDX
@barx_trid_w2:

  CMP EDX,vy1
  JL @barx_trid_ende
  CMP EBX,vy2
  JG @barx_trid_ende
  CMP EAX,vx2
  JG @barx_trid_ende
  CMP ECX,vx1
  JL @barx_trid_ende

  CMP HWAclip,0
  JNE @barx_trid_hwclip
  CMP EAX,vx1
  JGE @barx_trid_nc1
  MOV EAX,vx1
@barx_trid_nc1:
  CMP EBX,vy1
  JGE @barx_trid_nc2
  MOV EBX,vy1
@barx_trid_nc2:
  CMP ECX,vx2
  JLE @barx_trid_nc3
  MOV ECX,vx2
@barx_trid_nc3:
  CMP EDX,vy2
  JLE @barx_trid_nc4
  MOV EDX,vy2
@barx_trid_nc4:
  ADD EBX,frontdrawoffsety
  ADD EDX,frontdrawoffsety
@barx_trid_hwclip:
{  CALL setpattern_trident }
  SUB EDX,EBX
  SUB ECX,EAX
  SHL EDX,16
  MOV DX,CX
  SHL EBX,16
  MOV BX,AX
  MOV EDI,MMIOoffs
  MOV EAX,f
  MOV BYTE PTR [EDI+27h],05Ah
  MOV WORD PTR [EDI+28h],1020h
  MOV [EDI+2Ch],EAX
  MOV [EDI+38h],EBX
  MOV [EDI+40h],EDX
  MOV BYTE PTR [EDI+24h],01h
@barx_trid_busy:
  TEST BYTE PTR [EDI+20h],80h
  JNZ @barx_trid_busy
@barx_trid_ende:
END;

{-------------------------------- moverect ----------------------------------}

PROCEDURE moverect_trident(x1,y1,x2,y2,x,y:longint);assembler;
{VAR xd,yd:integer;
    drawcmd,drawopt:word; }
ASM
  MOV EAX,x1
  MOV EBX,y1
  MOV ECX,x2
  MOV EDX,y2
  CMP EAX,ECX
  JLE @mr_trid_w1
  XCHG EAX,ECX
@mr_trid_w1:
  CMP EBX,EDX
  JLE @mr_trid_w2
  XCHG EBX,EDX
@mr_trid_w2:

  CMP HWAclip,0
  JNE @mr_hwaclip
  MOV EDI,frontdrawoffset
  ADD EBX,EDI
  ADD EDX,EDI
  ADD y,EDI
@mr_hwaclip:

  MOV EDI,MMIOoffs
  MOV BYTE PTR [EDI+27h],0CCh

{  port[$2127]:=$CC;
  IF (y<y1) OR ((y=y1) AND (x<x1)) THEN
    BEGIN   }

  CMP EBX,y
  JL @mr_trid_w5
  JG @mr_trid_w6
  CMP EAX,x
  JLE @mr_trid_w5
@mr_trid_w6:

    {  portW[$2128]:=$0004;
      portW[$2138]:=x;
      portW[$213A]:=y;
      portW[$213C]:=x1;
      portW[$213E]:=y1; }

  MOV WORD PTR [EDI+28h],0004h
  SUB ECX,EAX
  SUB EDX,EBX
  MOV SI,WORD PTR y
  SHL ESI,16
  MOV SI,WORD PTR x
  MOV [EDI+38h],ESI
  SHL EBX,16
  MOV BX,AX
  MOV [EDI+3Ch],EBX
  SHL EDX,16
  ADD DX,CX
  MOV [EDI+40h],EDX


{    END
  ELSE
    BEGIN }

  {    portW[$2128]:=$0304;
      portW[$2138]:=x+xd;
      portW[$213A]:=y+yd;
      portW[$213C]:=x2;
      portW[$213E]:=y2; }
  JMP @mr_trid_draw

@mr_trid_w5:
  MOV WORD PTR [EDI+28h],0304h
  SUB EAX,ECX
  SUB EBX,EDX
  NEG EAX
  NEG EBX
  MOV SI,WORD PTR y
  ADD SI,BX
  SHL ESI,16
  MOV SI,WORD PTR x
  ADD SI,AX
  MOV [EDI+38h],ESI
  SHL EDX,16
  MOV DX,CX
  MOV [EDI+3Ch],EDX
  SHL EBX,16
  ADD BX,AX
  MOV [EDI+40h],EBX
@mr_trid_draw:
{    END;
  port[$2124]:=$01; }
{  MOV EAX,frontdrawoffsetpix
  MOV [EDI+00h],EAX
  MOV [EDI+08h],EAX}

  MOV BYTE PTR [EDI+24h],01h
@mr_trid_busy:
  TEST BYTE PTR [EDI+20h],80h
  JNZ @mr_trid_busy


{  IF readkey=#27 THEN halt; }
END;

{============================================================================}

PROCEDURE setreslist_trident(mem,chipid:dword;var modelist:PModeEntry);
VAR hwa8,hwa16,hwa24,hwaclp:dword;
BEGIN
  CASE chipid OF $E300..$E3FF,$9440..$9999,$8400,$8420,$8500,$8520:hwa8:=ig_hwa ELSE hwa8:=0; END;
  CASE chipid OF $E300..$E3FF,$9440..$9999,$8400,$8420,$8500,$8520:hwa16:=ig_hwa ELSE hwa16:=0; END;
  CASE chipid OF $D300..$D3FF,$9660..$9999,$8400,$8420,$8500,$8520:hwa24:=ig_hwa ELSE hwa24:=0; END;
  CASE chipid OF $D300..$D3FF,$9660..$9999,$8400,$8420,$8500,$8520:hwaclp:=ig_hwaclip ELSE hwaclp:=0; END;
  hwa8:=hwa8 OR hwaclp;
  hwa16:=hwa16 OR hwaclp;
  hwa24:=hwa24 OR hwaclp;
  IF (mem>=512) THEN
    BEGIN
      AddModeToList(modelist,$7E,  320, 200,2,  640, $50,0,$0004, 10,5,5,5,0,5, ig_bank+ig_lfb+hwa16+ig_col15);
      AddModeToList(modelist,$7F,  320, 200,2,  640, $50,0,$0004, 11,5,5,6,0,5, ig_bank+ig_lfb+hwa16+ig_col16);
      AddModeToList(modelist,$6B,  320, 200,3,  960, $78,0,$0004, 16,8,8,8,0,8, ig_bank+ig_lfb+hwa24+ig_col24);
      AddModeToList(modelist,$70,  512, 480,2, 1024, $80,0,$0004, 10,5,5,5,0,5, ig_bank+ig_lfb+hwa16+ig_col15);
      AddModeToList(modelist,$71,  512, 480,2, 1024, $80,0,$0004, 11,5,5,6,0,5, ig_bank+ig_lfb+hwa16+ig_col16);
      AddModeToList(modelist,$5C,  640, 400,1,  640, $50,0,$0004,  5,3,2,3,0,2, ig_bank+ig_lfb+hwa8+ig_col8);
      AddModeToList(modelist,$72,  640, 400,2, 1280, $A0,0,$0008, 10,5,5,5,0,5, ig_bank+ig_lfb+hwa16+ig_col15);
      AddModeToList(modelist,$73,  640, 400,2, 1280, $A0,0,$0008, 11,5,5,6,0,5, ig_bank+ig_lfb+hwa16+ig_col16);
      AddModeToList(modelist,$5D,  640, 480,1,  640, $50,0,$0004,  5,3,2,3,0,2, ig_bank+ig_lfb+hwa8+ig_col8);
      AddModeToList(modelist,$5E,  800, 600,1,  800, $64,0,$3004,  5,3,2,3,0,2, ig_bank+ig_lfb+hwa8+ig_col8);
    END;
  IF (mem>=1024) THEN
    BEGIN
      AddModeToList(modelist,$74,  640, 480,2, 1280, $A0,0,$0008, 10,5,5,5,0,5, ig_bank+ig_lfb+hwa16+ig_col15);
      AddModeToList(modelist,$75,  640, 480,2, 1280, $A0,0,$0008, 11,5,5,6,0,5, ig_bank+ig_lfb+hwa16+ig_col16);
      AddModeToList(modelist,$6C,  640, 480,3, 1920, $F0,0,$0008, 16,8,8,8,0,8, ig_bank+ig_lfb+hwa24+ig_col24);
      AddModeToList(modelist,$76,  800, 600,2, 1600, $C8,0,$3008, 10,5,5,5,0,5, ig_bank+ig_lfb+hwa16+ig_col15);
      AddModeToList(modelist,$77,  800, 600,2, 1600, $C8,0,$3008, 11,5,5,6,0,5, ig_bank+ig_lfb+hwa16+ig_col16);
      AddModeToList(modelist,$62, 1024, 768,1, 1024, $80,0,$9004,  5,3,2,3,0,2, ig_bank+ig_lfb+hwa8+ig_col8);
    END;
  IF (mem>=2048) THEN
    BEGIN
      AddModeToList(modelist,$6D,  800, 600,3, 2400,$12C,0,$300C, 16,8,8,8,0,8, ig_bank+ig_lfb+hwa24+ig_col24);
      AddModeToList(modelist,$78, 1024, 768,2, 2048,$100,0,$9008, 10,5,5,5,0,5, ig_bank+ig_lfb+hwa16+ig_col15);
      AddModeToList(modelist,$79, 1024, 768,2, 2048,$100,0,$9008, 11,5,5,6,0,5, ig_bank+ig_lfb+hwa16+ig_col16);
      AddModeToList(modelist,$64, 1280,1024,1, 1280, $A0,0,$2008,  5,3,2,3,0,2, ig_bank+ig_lfb+hwa8+ig_col8);
      AddModeToList(modelist,$66, 1600,1200,1, 1600, $C8,0,$8008,  5,3,2,3,0,2, ig_bank+ig_lfb+hwa8+ig_col8);
    END;
  IF (mem>=4096) THEN
    BEGIN
      AddModeToList(modelist,$6E, 1024, 768,3, 3072,$180,0,$900C, 16,8,8,8,0,8, ig_bank+ig_lfb+hwa24+ig_col24);
      AddModeToList(modelist,$7A, 1280,1024,2, 2560,$140,0,$200C, 10,5,5,5,0,5, ig_bank+ig_lfb+hwa16+ig_col15);
      AddModeToList(modelist,$7B, 1280,1024,2, 2560,$140,0,$200C, 11,5,5,6,0,5, ig_bank+ig_lfb+hwa16+ig_col16);
    END;
END;

{============================================================================}

PROCEDURE sethwaprocs_trident(col:longint);
BEGIN
  graphwinHW:=@graphwinHW_trident;
  setpatternHW:=@setpatternHW_trident;
  line:=@line_trident;
  lineh:=@lineh_trident;
  lineh_solid:=@lineh_trident;
  lineh_pattern:=@lineh_pattern_trident;
  bar:=@bar_trident;
  bar_solid:=@bar_trident;
  bar_pattern:=@bar_pattern_trident;
  barxor:=@barxor_trident;
  barxor_solid:=@barxor_trident;
  barxor_pattern:=@barxor_pattern_trident;
  moverect:=@moverect_trident;
END;


END.
