{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

{$I gxglobal.cfg}
UNIT gxmem;

INTERFACE

{$I gxlocal.cfg}

TYPE TMMIOMap=RECORD
       pbase,lbase,offs,size,dsbase:dword;
     END;

     adjustaddressesproc=procedure(old_ds_base,new_ds_base:dword);

VAR adjustaddresses:adjustaddressesproc;

PROCEDURE mapresource(var mmiomap:tmmiomap;base,size:dword);
PROCEDURE unmapresource(var mmiomap:tmmiomap);
PROCEDURE adjustaddress(var offs:dword;old_ds_base,new_ds_base:dword);

IMPLEMENTATION

USES go32{,dbgherc};

{---------------------------- memory-management -----------------------------}

PROCEDURE SetLimits;
BEGIN
  set_segment_limit(get_ds,-1{ $FFFFFFFF});
END;

PROCEDURE mapresource(var mmiomap:tmmiomap;base,size:dword);
VAR lbase,offs:dword;
BEGIN
  lbase:=get_linear_addr(base,size);
  lock_linear_region(lbase,size);
  offs:=lbase-dword(get_segment_base_address(get_ds));
  mmiomap.pbase:=base;
  mmiomap.lbase:=lbase;
  mmiomap.offs:=offs;
  mmiomap.size:=size;
  mmiomap.dsbase:=get_ds;
END;

PROCEDURE unmapresource(var mmiomap:tmmiomap);
BEGIN
  unlock_linear_region(mmiomap.lbase,mmiomap.size);
END;

PROCEDURE adjustaddress(var offs:dword;old_ds_base,new_ds_base:dword);
BEGIN
  offs:=offs+old_ds_base-new_ds_base;
END;

{==========================================================================}

TYPE heaperrorproc=function(size:longint):integer;

CONST HeapErrorIsHooked:boolean = false;
      OldHeapError:HeapErrorProc=nil;
      DS_limit:dword=0;

FUNCTION NewHeapError(size:longint):integer;
VAR old_ds_base,new_ds_base:dword;
BEGIN
{DBG('heaperror start');}
  old_ds_base:=get_segment_base_address(get_ds);
  set_segment_limit(get_ds,DS_limit);
  NewHeapError:=OldHeapError(size);
  new_ds_base:=get_segment_base_address(get_ds);
  set_segment_limit(get_ds,-1{ $FFFFFFFF});
{  IF (LFBoffs=LFBbase) THEN adjustaddress(LFBoffs,old_ds_base,new_ds_base);
  CurGraphiX.adjustaddresses(old_ds_base,new_ds_base);                       }
  adjustaddresses(old_ds_base,new_ds_base);
{DBGadjust;
DBG('heaperror end');}
END;

PROCEDURE HookHeapError;
BEGIN
  IF HeapErrorIsHooked THEN exit;
  DS_limit:=get_segment_limit(get_ds);
  OldHeapError:=HeapErrorProc(HeapError);
  HeapError:=@NewHeapError;
  HeapErrorIsHooked:=TRUE;
END;

PROCEDURE UnHookHeapError;
BEGIN
  IF NOT HeapErrorIsHooked THEN exit;
  set_segment_limit(get_ds,DS_limit);
  HeapError:=OldHeapError;
  HeapErrorIsHooked:=FALSE;
END;

{==========================================================================}

VAR OldExitProc:pointer;

PROCEDURE NewExitProc;
BEGIN
  UnHookHeapError;
  ExitProc:=OldExitProc;
END;

BEGIN
  OldExitProc:=ExitProc;
  ExitProc:=@NewExitProc;
  HookHeapError;
  SetLimits;
END.
