using System;
using System.Collections;

namespace Hash
{
	public delegate object HashFunction(object Item,object HashParameter);

	public class HashTable :IEnumerable
	{
		public static int DefaultHashParameter = 1024;
		private class HashItem
		{
			public object ID;
			public object Item;

			public HashItem()
			{
				ID = null;
				Item = null;
			}

			public HashItem(object ID,object Item)
			{
				this.ID = ID;
				this.Item = Item;
			}
		}

		private class HashTableItem
		{
			public	object		HashCode;
			public	ArrayList	Items = new ArrayList();

			public HashTableItem()
			{
				this.HashCode = null;
			}

			public	HashTableItem(object Hash)
			{
				this.HashCode = Hash;
			}
		}

		private class HashTableEnumerator :IEnumerator
		{
			IEnumerator HashEnumerator;
			IEnumerator IDEnumerator;
			HashTable	Table;

			public HashTableEnumerator(HashTable Table)
			{
				this.Table = Table;
				Reset();
			}

			public void Reset()
			{
				HashEnumerator = null;
				IDEnumerator = null;
			}

			public bool MoveNext()
			{
				if (HashEnumerator == null)
					HashEnumerator = Table.Items.GetEnumerator();
				if (IDEnumerator == null)
					if (HashEnumerator.MoveNext())
						IDEnumerator = ((HashTableItem)HashEnumerator.Current).Items.GetEnumerator();
					else
					{
						Reset();
						return false;
					}
				if (IDEnumerator.MoveNext())
					return true;
				if (HashEnumerator.MoveNext())
				{
					IDEnumerator = ((HashTableItem)HashEnumerator.Current).Items.GetEnumerator();
					return IDEnumerator.MoveNext();
				}
				Reset();
				return false;
			}

			private object GetCurrent()
			{
				if (HashEnumerator != null)
					if (IDEnumerator != null)
						return ((HashItem)IDEnumerator.Current).Item;
				return null;
			}

			public object Current{get {return GetCurrent();}}
		}

		private	ArrayList		Items = new ArrayList();
		public	HashFunction	HashFn;
		public	object			HashParameter;

		public static object	DefaultHash(object Item,object HashParameter)
		{
			if (HashParameter.GetHashCode() == 0)
				return Item.GetHashCode() % DefaultHashParameter;
			else
				return Item.GetHashCode() % HashParameter.GetHashCode();
		}
		public	HashTable()
		{
			HashParameter = DefaultHashParameter;
			HashFn = new HashFunction(DefaultHash);
		}

		public HashTable(object HashParameter)
		{
			this.HashParameter = HashParameter;
			HashFn = new HashFunction(DefaultHash);
		}

		public HashTable(object HashParameter,HashFunction HashFn)
		{
			this.HashParameter = HashParameter;
			this.HashFn = HashFn;
		}

		public IEnumerator	GetEnumerator()
		{
			return new HashTableEnumerator(this);
		}

		private int			GetCount()
		{
			int Result = 0;
			foreach (HashTableItem ti in Items)
				Result += ti.Items.Count;
			return Result;
		}

		private object		GetItem(object Key)
		{
			object HashCode = HashFn(Key,HashParameter);
			foreach (HashTableItem ti in Items)
				if (ti.HashCode.Equals(HashCode))
					foreach (HashItem hi in ti.Items)
						if (hi.ID.Equals(Key))
							return hi.Item;
			return null;
		}

		public void			Add(object Key,object Item)
		{
			object HashCode = HashFn(Key,HashParameter);
			foreach (HashTableItem ti in Items)
				if (ti.HashCode.Equals(HashCode))
				{
					foreach (HashItem hi in ti.Items)
						if (hi.ID.Equals(Key))
						{
							hi.Item = Item;
							return;
						}
					ti.Items.Add(new HashItem(Key,Item));
					return;
				}
			HashTableItem NewHashTableItem = new HashTableItem(HashCode);
			NewHashTableItem.Items.Add(new HashItem(Key,Item));
			Items.Add(NewHashTableItem);
		}

		public void			Delete(object Key)
		{
			object HashCode = HashFn(Key,HashParameter);
			foreach (HashTableItem ti in Items)
				if (ti.HashCode.Equals(HashCode))
					foreach (HashItem hi in ti.Items)
						if (hi.ID.Equals(Key))
						{
							ti.Items.Remove(hi);
							return;
						}
		}

		public int		Count {get {return GetCount();}}
		public object	this[object Key] {get {return GetItem(Key);} set {Add(Key,value);}}
	}
}